/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)Rwrite.c	1.3 87/05/21
*/

/*
**	Buffer output to save system calls, and/or align writes.
*/

#include	"global.h"
#include	"debug.h"

#include	<errno.h>

#include	"daemon.h"


static char	buffer[PBUFSIZE];
int		Wbufcount;	/* Global so driver can clear it */

static int	_write();



int
Rwrite(fd, buf, size)
	int		fd;
	register char *	buf;
	int		size;
{
	register int	osize;		/* Writes aligned on this quantity */
	register int	count;
	register int	n;

	if ( (count = size) <= 0 )
		return count;

	if ( (osize = BufferOutput) == 0 )
		osize = size;

	while ( !Cook && Wbufcount == 0 && count >= osize )
	{
		if ( (n = _write(fd, buf, osize, false)) <= 0 )
			return n;

		count -= n;
		buf += n;
	}

	while ( count )
	{
		if ( (n = osize - Wbufcount) > count )
			n = count;

		if ( n > 0 )
		{
			bcopy(buf, &buffer[Wbufcount], n);

			count -= n;
			buf += n;

			if ( (Wbufcount += n) < osize )
				continue;
		}

		if ( (n = RWflush(fd)) <= 0 )
			return n;
	}

	return size;
}



int
RWflush(fd)
	int		fd;
{
	register int	n;

	if ( Cook && buffer[Wbufcount-1] != '\r' )
		buffer[Wbufcount++] = '\r';

	if ( (n = _write(fd, buffer, Wbufcount, true)) > 0 )
		Wbufcount = 0;

	return n;
}



static int
_write(fd, buf, size, fix)
	int		fd;
	register char *	buf;
	int		size;
	bool		fix;
{
	register int	count;
	register int	n;

	if ( (count = size) <= 0 )
		return count;

	while ( (n = write(fd, buf, count)) != count )
	{
		if ( n <= 0 )
		{
			if ( n == SYSERROR && errno == EINTR )
				continue;

			if ( fix && buf != buffer )
			{
				bcopy(buf, buffer, count);
				Wbufcount = count;
			}

			return n;
		}

		count -= n;
		buf += n;
	}

	return size;
}
