/*
**	Patterns and functions to call using the Netcomm
**	Automodem 1234 (mostly Hayes compatible.)
*/

#include	"global.h"
#include	"caller.h"
#include	<signal.h>

#define TRACE

#define	MAXPHONES	8
#define	MAXDEV		4

extern	int	Traceflag;

char
	*callargs	= NULLSTR,
	*daemon1	= NNDAEMON,	/* standard daemon */
	*daemon2	= NN2DAEMON,	/* alternate protocol */
	*daemon3	= PNDAEMON,	/* high-speed protocol */
	*hostflg	= "-BF",	/* dialup, don't fork */
	*hostarg	= NULLSTR,	/* extra args (cooked, whatever) */
	*loginname	= NULLSTR,	/* our login name on remote host */
	*target  	= NULLSTR,	/* connecting to where? */
	*passwd  	= NULLSTR,
	*dialpw  	= NULLSTR,
	*ccitt		= "2",		/* modem mode for dialing */
	*modes		= "",
	*afterst	= "",
	*ph_num[MAXPHONES + 1],		/* array of phone number pointers */
	**phoneno	= ph_num,	/* Current phone number to call */
	*tone		= "P",		/* pulse (P) or tone (T) dialing */
	*device  	= NULLSTR,	/* Which call unit? (cul0) */
	*speed   	= "2400",
	*connectspeed	= NULLSTR,	/* speed to use if get "CONNECT" */
	*retries	= "10 2",	/* retry twice, 10 seconds apart */
	*dial_delay	= "30",		/* gap between dial attempts */
	*opentime	= "60",
	*logintime	= "45",		/* MUST be greater then 15 seconds
						(modem carrier detect time) */
	*sendstr	= NULLSTR;


int
	Devices  = 0,	/* count of device names */
	rclcount = 0,	/* count of resets calls */
	max_rcl	 = 30,		/* max reset calls */
	rcount	 = 0,	/* count of resets */
	max_rc	 = 3,		/* max resets */
	tcount	 = 0,	/* count of timeouts */
	max_to	 = 5,		/* max timeouts */
	ecount	 = 0,	/* count of unexpected eofs */
	max_eof	 = 3,		/* max stray eof's */
	lcount	 = 0,	/* count of Unix login attempts */
	max_lc	 = 8,		/* max login attempts */
	dcount	 = 0,	/* count of dial attempts */
	max_dial = 15,		/* max dial attempts */
	bcount	 = 0,	/* count of waits on busy device */
	max_busy = 15,		/* max waits on busy device */
	busywait = 5,		/* minutes to wait for busy device */
	errcount = 0,	/* error counter */
	max_errs = 2,		/* max errors */
	trash	 = 0,	/* counter of meaningless received lines */
	max_tr	 = 10,		/* max trash lines between good ones */
	flush	 = 0,	/* flush input on connect flag */
	sbreak	 = 0;	/* send break after connect */

int
	callbusy(),
	callefail(),
	calltfail(),
	devicebusy(),
	eof(),
	gotlogin(),
	gotpasswd(),
	gotdialpw(),
	ignoreline(),
	nocarrier(),
	nullline(),
	openok(),
	resettimo(),
	resetunit(),
	retrylogin(),
	start2(),
	started(),
	startpn(),
	timeout(),
	tocallunit(),
	tounix300(),
	tounix1200(),
	tounix2400(),
	trashline();

char *	NodeName();

struct patlist opendevice[] =
{
	{ LOCKED,	devicebusy },
	{ OPENFAIL,	devicebusy },
	{ OPENED,	openok },
	{ 0, 0 }
};

struct patlist atreset[] =
{
	{ "OK",		tocallunit },
	{ TIMEOUT,	resettimo },
	{ 0, 0 }
};

struct patlist atcallunit[] =
{
	{ "CONNECT 1200", tounix1200 },
	{ "CONNECT 2400", tounix2400 },
	{ "CONNECT",	  tounix300 },
	{ "BUSY",	  callbusy },
	{ "NO CARRIER",   nocarrier },
	{ "NO ANSWER",    nocarrier },
	{ "NO DIALTONE",  callefail },
	{ "ERROR",	  callefail },
	{ TIMEOUT,	  calltfail },
	{ 0, 0 }
};

struct patlist atunix[] =
{
	{ "[Ii]llegal", ignoreline },
	{ "[Ii]ncorrect", ignoreline },
	{ "[Ll]ogin", gotlogin },
	{ "[Dd]ial[iu][np] [Pp]assword", gotdialpw },
	{ "[Ww]rong [Pp]assword", ignoreline },
	{ "[Pp]assword", retrylogin },
	{ PNSTARTS, startpn },	/* high-speed protocol */
	{ START2MSG, start2 },	/* alternate protocol */
	{ STARTMSG, started},
	{ "NO CARRIER", nocarrier },
	{ "NO ANSWER", nocarrier },
	{ TIMEOUT, timeout },
	{ EOFSTR, eof },
	{ "^\n", nullline },
	{ ".", trashline },
	{ 0, 0 }
};

struct patlist pwwait[] =
{
	{ "[Ii]llegal", retrylogin },
	{ "[Ii]ncorrect", retrylogin },
	{ "[Ww]rong [Pp]assword", retrylogin },
	{ "[Pp]assword", gotpasswd },
	{ PNSTARTS, startpn },	/* high-speed protocol */
	{ START2MSG, start2 },	/* alternate protocol */
	{ STARTMSG, started},
	{ "NO CARRIER", nocarrier },
	{ "NO ANSWRE", nocarrier },
	{ TIMEOUT, timeout },
	{ EOFSTR, eof },
	{ "^\n", nullline },
	{ ".", trashline },
	{ 0, 0 }
};

struct patlist daemonwait[] =
{
	{ "[Ii]llegal", retrylogin },
	{ "[Ii]ncorrect", retrylogin },
	{ "[Ww]rong [Pp]assword", retrylogin },
	{ PNSTARTS, startpn },	/* high-speed protocol */
	{ START2MSG, start2 },	/* alternate protocol */
	{ STARTMSG, started},
	{ "NO CARRIER", nocarrier },
	{ "NO ANSWER", nocarrier },
	{ TIMEOUT, timeout },
	{ EOFSTR, eof },
	{ "^\n", nullline },
	{ ".", trashline },
	{ 0, 0 }
};

args(argc, argv)
	register int	argc;
	register char *	argv[];
{
	register char *cargs = callargs;
	register int n;

	while ( --argc > 0 )
	{
#ifdef TRACE
		if (Traceflag > 3)
			Command("trace caller arg: ", argv[1], NULLSTR);
#endif
		if ( **++argv == '-' )
		{
			register int	c;
			register char *	p;

			while ( c = *++*argv )
			{
/*
 * Used:
 *	123abdglmnprstwABCDFMPRST
 * free:
 *	0456789cefhijkqvxyzEGHIJKLNOQUVWXYZ
 */

				switch ( c )
				{
				case '1':
					daemon1 = ++*argv;
					goto break2;
				case '2':
					daemon2 = ++*argv;
					goto break2;
				case '3':
					daemon3 = ++*argv;
					goto break2;
				case 'a':
					if (*++*argv)
						callargs = newstr(*argv);
					goto break2;
				case 'b':
					sbreak = 1;
					break;
				case 'd':
					if (++Devices > MAXDEV) {
						Command(
						    "fail too many -d args",
						    NULLSTR
						);
						exit(1);
					}
					if (device != NULLSTR)
						device = concat(device, " ",
						    ++*argv, NULLSTR);
					else
						device = ++*argv;
					goto break2;
				case 'g':
					dial_delay = ++*argv;
					goto break2;
				case 'l':
					loginname = ++*argv;
					goto break2;
				case 'm':
					modes = ++*argv;
					goto break2;
				case 'n':
					if (phoneno != &ph_num[MAXPHONES]) {
						*phoneno++ = ++*argv;
						goto break2;
					}
					Command("fail too many phone numbers",
					    NULLSTR);
					exit(1);
				case 'p':
					tone = "P";
					break;
				case 'r':
					afterst = ++*argv;
					goto break2;
				case 's':
					speed = ++*argv;
					goto break2;
				case 't':
					tone = "T";
					break;
				case 'w':
					n = atoi(++*argv);
					if (n > 0)
						busywait = n;
					goto break2;
				case 'A':
					hostarg = ++*argv;
					goto break2;
				case 'B':
					ccitt = ++*argv;
					break;
				case 'C':
					if (*++*argv)
						connectspeed = *argv;
					goto break2;
				case 'D':
					dialpw = ++*argv;
					goto break2;
				case 'F':
					flush = 1;	/* Flush input on connect */
					break;
				case 'M':
				    {
					n = 0;

					c = *++*argv;
					if (c)
						n = atoi(++*argv);
					switch (c) {
					case 'R':
						max_rcl = n;
						break;
					case 'r':
						max_rc = n;
						break;
					case 'T':
						max_to = n;
						break;
					case 'E':
						max_eof = n;
						break;
					case 'l':
						max_lc = n;
						break;
					case 'd':
						max_dial = n;
						break;
					case 'e':
						max_errs = n;
						break;
					case 't':
						max_tr = n;
						break;
					case 'b':
						max_busy = n;
						break;
					default:
						Command("fail Unknown limit option \"-M", *argv - 1, " in ", cargs, NULLSTR);
						exit(1);
					}
					goto break2;
				    }
				case 'P':
					passwd = ++*argv;
					goto break2;
				case 'R':
					retries = ++*argv;
					for (p = retries; *p; p++)
						if (*p == '/')
							*p = ' ';
					goto break2;
				case 'S':
					if (*++*argv)
						sendstr = *argv;
					else
						sendstr = "\r";
					goto break2;
				case 'T':
#ifdef TRACE
					Traceflag = atoi(++*argv);
#endif
					goto break2;
				default:
					Command("fail unexpected flag \"-", *argv, "\" in ", cargs, NULLSTR);
					exit(1);
				}
			}
break2:			;
		}
		else
			target = *argv;
	}
}

setafter()
{
	Command("after sleep 2", NULLSTR);
	Command("after write +++", NULLSTR);
	Command("after sleep 2", NULLSTR);

/*		(surely should leave this at speed last set??)
	Command("after speed ", speed, NULLSTR);
*/

	Command("after write \rATH0\r", NULLSTR);
	if (afterst != NULLSTR && *afterst != '\0')
		Command("after write AT", afterst, "\r", NULLSTR);
	else
		Command("after write ATZ\r", NULLSTR);
	Command("after close", NULLSTR);
}

sigabort()
{
#ifdef	TRACE
	if (Traceflag)
		Command("trace sigterm received - exiting", NULLSTR);	/**/
#endif	/* TRACE */
	onlinefail("sigterm received");		/* perhaps online, be safe ..*/
}

void
init(argc, argv)
	int	argc;
	char	*argv[];
{
	register char *cp;
	register i;
	
	args(argc, argv);

	if (callargs == NULLSTR) {
		if ( target != NULLSTR )
			callargs = concat(SPOOLDIR(), target, "/",
				CALLARGS, NULLSTR);
		else {
			if ( (cp = strrchr(*argv, '/')) != NULLSTR ) {
				*cp = '\0';
				cp = *argv;
				while ((cp = strchr(cp, '/')) != NULLSTR)
					cp++;
				if (*cp != '\0')
					target = cp;
				cp = *argv;
			} else
				cp = ".";

			callargs = concat(cp, "/", CALLARGS, NULLSTR);
		}
	}

	i = 0;
	do {
		cp = callargs;
		(void)readargs(callargs, args);
		if (i > 0)
			free(cp);
	} while (++i < 10 && cp != callargs);

	if (target == NULLSTR) {
		Command("fail no target", NULLSTR);
		exit(1);
	}

	phoneno = ph_num;
	if (*phoneno == NULLSTR) {
		Command("fail no phone numbers", NULLSTR);
		exit(1);
	}

	if (device == NULLSTR) {
		Command("fail no device", NULLSTR);
		exit(1);
	}

	if (loginname == NULLSTR)
		loginname = NodeName();

	signal(SIGTERM, sigabort);

	Command("tellme", NULLSTR);

#ifdef	TRACE
	if (Traceflag >= 2 )
		Command("trace cleanup commands ......", NULLSTR);
#endif	/* TRACE */
	setafter();
#ifdef	TRACE
	if (Traceflag >= 2 )
		Command("trace opening line ......", NULLSTR);
#endif	/* TRACE */
	resetunit();
}

resetunit()
{
	if (++rclcount > max_rcl)
		fail("call fail - modem reset called too many times.");

	if (rclcount > 1) {
#ifdef	TRACE
		if (Traceflag > 1 )
			outend("trace killing old reader ......");
#endif	/* TRACE */
		Command("close", NULLSTR);
		Command("sleep ", dial_delay, NULLSTR);
	}
	flushinput();
	Command("timeout ", opentime, NULLSTR);
	if (retries && *retries)
		Command("retry ", retries, NULLSTR);
	Command("opendial ", device, NULLSTR);
	state(opendevice);
	reset();
}

openok()
{
	Command("speed ", speed, NULLSTR);
	Command("timeout ", logintime, NULLSTR);
#ifdef	TRACE
	if (Traceflag > 1 )
		Command("trace starting reader ......");
#endif	/* TRACE */
	Command("read");
	rcount = 0;
	tcount = 0;
	resettimo();
}

devicebusy()
{
	if (++bcount > max_busy)
		fail("call fail - device continually busy.");

#ifdef	TRACE
	if (Traceflag)
		Command("trace waiting for busy device", NULLSTR);
#endif	/* TRACE */

	sleep(busywait * 60);
	flushinput();
	rclcount = 0;
	resetunit();
}

resettimo()
{
#ifdef	TRACE
	if (Traceflag > 2 )
		Command("trace ", rcount ? "resetting" : "initialising",
		    " the modem ......", NULLSTR);
#endif	/* TRACE */
	if (++rcount > max_rc)
		fail("call fail - couldn't gain attention of modem.");
	state(atreset);
	Command("sleep 2", NULLSTR);
	flushinput();
	Command("write +++", NULLSTR);
	Command("sleep 2", NULLSTR);
	flushinput();
	Command("speed ", speed, NULLSTR);
	Command("write \r", NULLSTR);
	Command("write ATH0", NULLSTR);
	if (ccitt && *ccitt)
		Command("write B", ccitt, NULLSTR);
	Command("write Q0E0", NULLSTR);
	Command("write X1V1", NULLSTR);
#ifdef	TRACE
	if (Traceflag)
		Command("write M1", NULLSTR);
	else
#endif	/* TRACE */
	Command("write M0", NULLSTR);
	if (modes && *modes)
		Command("write ", modes, NULLSTR);
	Command("write S0=0\r", NULLSTR);
	trash = 0;
	reset();
}

tocallunit()
{
#ifdef	TRACE
	if (Traceflag > 2 )
		Command("trace dialing......", NULLSTR);
#endif	/* TRACE */
	state(atcallunit);
	Command("write ATD", tone, *phoneno++, "\r", NULLSTR);
	if (*phoneno == NULLSTR)
	    phoneno = ph_num;
	trash = 0;
	reset();
}

callbusy()
{
	if (++dcount > max_dial)
		fail("target busy");
	else {
#ifdef	TRACE
		if (Traceflag)
			Command("trace reset modem - call busy", NULLSTR);
#endif	/* TRACE */
		resetunit();
	}
}

calltfail()
{
#ifdef	TRACE
	if (Traceflag >= 2 )
		Command("trace waiting......", NULLSTR);
#endif	/* TRACE */
	if (++tcount > max_to)
		fail("too many timeouts");
	else
		reset();
	trash = 0;
}

callefail()
{
	if (++errcount > max_errs)
		fail("modem error");
	else {
#ifdef	TRACE
		if (Traceflag)
			Command("trace reset modem - error", NULLSTR);
#endif	/* TRACE */
		flushinput();
		resetunit();
	}
}

ignoreline()
{
	trash = 0;
	reset();
}

nocarrier()
{
	if (++dcount > max_dial)
		fail("no carrier");
	else {
#ifdef	TRACE
		if (Traceflag)
			Command("trace reset modem - no carrier", NULLSTR);
#endif	/* TRACE */
		resetunit();
	}
}

tounix300()
{
	if (connectspeed)
		tounix(connectspeed);
	else {
#ifdef	TRACE
		if (Traceflag)
			Command("trace reset modem - bad connect", NULLSTR);
#endif	/* TRACE */
		onlinereset();
	}
}

tounix1200()
{
	tounix("1200");
}

tounix2400()
{
	tounix("2400");
}

tounix(sp)
	char *sp;
{
	if (strcmp(speed, sp) != 0) {
		Command("speed ", sp, NULLSTR);
	}
#ifdef	TRACE
	if (Traceflag >= 2 )
		Command("trace waiting for login......", NULLSTR);
#endif	/* TRACE */
	if (sbreak)
		Command("break", NULLSTR);
	if (flush) {
		Command("sleep 2", NULLSTR);
		flushinput();	/* toss away junk */
		if (sendstr)
			Command("write ", sendstr, NULLSTR);
		else
			Command("write ", loginname, "\r", NULLSTR);
	} else if (sendstr)
		Command("write ", sendstr, NULLSTR);

	state(atunix);
	tcount = 0;
	trash = 0;
	reset();
}

gotlogin()
{
#ifdef	TRACE
	if (Traceflag >= 2 )
		Command("trace got login ......", NULLSTR);
#endif	/* TRACE */
	if ( ++lcount >= max_lc )
		onlinefail("too many login attempts");
	Command("write ", loginname, "\r", NULLSTR);
	state(pwwait);
	trash = 0;
	reset();
}


gotpasswd()
{
#ifdef	TRACE
	if (Traceflag >= 2 )
		Command("trace got passwd ......", NULLSTR);
#endif	/* TRACE */
	if (passwd == NULLSTR)
		onlinefail("required login password not supplied");
	Command("write ", passwd, "\r", NULLSTR);
	state(daemonwait);
	trash = 0;
	reset();
}

retrylogin()
{
#ifdef	TRACE
	if (Traceflag >= 2 )
		Command("trace retrying login ......", NULLSTR);
#endif	/* TRACE */
	if (++lcount > max_lc)
		onlinefail("too many login failures");
	Command("write \r", NULLSTR);
	state(atunix);
	trash = 0;
	reset();
}


gotdialpw()
{
#ifdef	TRACE
	if (Traceflag >= 2 )
		Command("trace got dialin passwd ......", NULLSTR);
#endif	/* TRACE */
	if (dialpw == NULLSTR || *dialpw == '\0')
		onlinefail("required dialup passwd not supplied");
	Command("write ", dialpw, "\r", NULLSTR);
	trash = 0;
	reset();
}


startpn()
{
#ifdef	TRACE
	if (Traceflag)
		Command("trace call succeeded, PNdaemon starting", NULLSTR);	/**/
#endif	/* TRACE */
	if (hostarg && *hostarg)
		Command("mode ", hostarg, NULLSTR);
	Command("daemon ", daemon3, NULLSTR);
	Command("succeed ", hostflg, " ", target, NULLSTR);
	exit(0);
}


started()
{
#ifdef	TRACE
	if (Traceflag)
		Command("trace call succeeded, daemon starting", NULLSTR);	/**/
#endif	/* TRACE */
	if (hostarg && *hostarg)
		Command("mode ", hostarg, NULLSTR);
	Command("daemon ", daemon1, NULLSTR);
	Command("succeed ", hostflg, " ", target, NULLSTR);
	exit(0);
}


start2()
{
#ifdef	TRACE
	if (Traceflag)
		Command("trace call succeeded, daemon 2 starting", NULLSTR);	/**/
#endif	/* TRACE */
	if (hostarg && *hostarg)
		Command("mode ", hostarg, NULLSTR);
	Command("daemon ", daemon2, NULLSTR);
	Command("succeed ", hostflg, " ", target, NULLSTR);
	exit(0);
}


timeout()
{
	if (++tcount >= max_to)
		onlinefail("too many timeouts in login");
	Command("write \r", NULLSTR);
	state(atunix);
	trash = 0;
	reset();
}

nullline()
{
	reset();
}

trashline()
{
	register char *p;
	register i, j;
	extern char input[];
	extern int inputlen;

	for (j = 0, i = inputlen, p = input; --i >= 0; p++)
		if ((*p < ' ' && *p != '\n' && *p != '\t' && *p != '\r') ||
		    *p > '~')
			j++;

	if (j > 2 && j * 4 > inputlen && ++trash >= max_tr)
		onlinereset();
	else
		reset();
}

eof()
{
	if (++ecount > max_eof)
		fail("unexpected eof");
#ifdef	TRACE
	if (Traceflag)
		Command("trace unexpected eof", NULLSTR);	/**/
#endif	/* TRACE */
	resetunit();
}

onlinereset()
{
	Command("sleep 3", NULLSTR);
	Command("write +++", NULLSTR);
	Command("sleep 3", NULLSTR);
	Command("write \rATH0\r", NULLSTR);
	resetunit();
}

onlinefail(s)
	char *s;
{
	Command("sleep 3", NULLSTR);
	Command("write +++", NULLSTR);
	Command("sleep 3", NULLSTR);
	Command("write \rATH0\r", NULLSTR);
	fail(s);
}

fail(s)
	register char *s;
{
	Command("write \r", NULLSTR);
	if (afterst != NULLSTR && *afterst != '\0')
		Command("write AT", afterst, "\r", NULLSTR);
	else
		Command("write ATZ\r", NULLSTR);
	Command("close", NULLSTR);		/* avoid "SIGPIPE on callin" */
	Command("fail ", s, NULLSTR);
	exit(1);
}
