/*
 *	ACSnet udp/ip datagram channel establishment
 *
 * this end is the receiver
 */

#define STDIO
#define	INETD

#include "global.h"

#if	BSD4 < 2		/* dangerous on standard 4.2 bsd as well */

main()
{
	fprintf(stderr, "So you think that you have UDP/IP ...\n");
	exit(1);
}

#else	BSD4 < 2

#define	STD_PORT		812		/* random, < IPPORT_RESERVED */

#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/wait.h>

#include <netinet/in.h>

#include <arpa/inet.h>			/* debug really */

#include <netdb.h>
#include <errno.h>
#include <signal.h>

struct sockaddr_in addr;
struct sockaddr_in hisaddr;
int addlen;

char ConnMsg[] = "ACSnet deamon starting";
char NNdaemon[] = "/usr/spool/ACSnet/_lib/ENdaemon";		/* I'm lazy */

char buf[512];

int buryit();

main(argc, argv)
	char **argv;
{
	register sfd;
	register i;
	register lport;
	int xfd;
	register struct servent *sp;
	register struct hostent *hp;
	int on = 1;
	extern int errno;
	int debug = 0;
	int dofork = 1;

	if (argc > 1 && strncmp(argv[1], "-T", 2) == 0) {
		debug = 1;
		argc--; argv++;
	}
	if (argc > 1 && strncmp(argv[1], "-F", 2) == 0) {
		dofork = 0;
		argc--;
		argv++;
	}

	signal(SIGCHLD, buryit);

#ifndef	INETD
	sp = getservbyname("ACSnet", "udp");
	if (sp == 0) {
		fprintf(stderr, "ACSnet/udp: unknown service\n");
		exit(1);
	}
	addr.sin_port = sp->s_port;

	sfd = socket(AF_INET, SOCK_DGRAM, 0);
	if (sfd < 0) {
		perror("socket");
		exit(1);
	}
#if BSD4 <= 2
	if (setsockopt(sfd,  SOL_SOCKET, SO_REUSEADDR, 0, 0) < 0) {
#else
	if (setsockopt(sfd,  SOL_SOCKET, SO_REUSEADDR, &on, sizeof on) < 0) {
#endif
		perror("setsockopt (REUSEADDR)");
		exit(1);
	}
	if (bind(sfd, &addr, sizeof addr, 0) < 0) {
		perror("bind");
		exit(1);
	}

	if (debug == 0 && dofork) {
		if (fork() != 0)		/* into background */
			exit(0);

		{	register t = open("/dev/tty", 2);
			if (t >= 0) {
				ioctl(t, TIOCNOTTY, 0);
				close(t);
			}
		}
	}

top:

#else	INETD

	/*
	 * inetd execs us with a datagram pending on fd 0
	 */

	sfd = 0;

#endif	INETD

	do {
		addlen = sizeof hisaddr;
		i = recvfrom(sfd, buf, sizeof buf, 0, &hisaddr, &addlen);
	} while (i == -1 && errno == EINTR);

	if (i == -1) {
		perror("recvfrom");
		goto top;
	}

#ifdef	DEBUG
	if (debug) {
		printf("tudp: received a dgram from %d/%s (%d)\n",
			ntohs(hisaddr.sin_port), inet_ntoa(hisaddr.sin_addr),
			addlen);
		printf("Data <<%.*s>>\n", i, buf);
	}
#endif

	/*
	 * ignore dgram if its not from a priveleged port
	 */
	if (ntohs(hisaddr.sin_port) >= IPPORT_RESERVED) {
#ifdef	DEBUG
		if (debug)
			printf("Don't like its port\n");
#endif
		goto top;
	}

	/*
	 * ignore dgram if we don't know the name of its origin host
	 */
	hp = gethostbyaddr(&hisaddr.sin_addr,sizeof(hisaddr.sin_addr),AF_INET);
	if (hp == 0) {
#ifdef	DEBUG
		if (debug)
			printf("Can't find host to match addr\n");
#endif
		goto top;
	}

	/*
	 * ignore dgram if we can't fork a process to deal with it
	 */

	if (fork() != 0)
		goto top;

#ifdef	DEBUG
	if (debug)
		printf("tudp: child %d got a connection\n", getpid());
#endif

	/*
	 * child process turns into NNdaemon, after completing
	 * innitial connection protocol ...
	 */

	close(sfd);

	sfd = socket(AF_INET, SOCK_DGRAM, 0);
	if (sfd < 0) {
		perror("socket(2)");
		exit(1);
	}
	for (lport = STD_PORT, i = 0; i < 30; i++, lport++) {
		addr.sin_port = htons(lport);
		if (bind(sfd, &addr, sizeof addr) < 0) {
			extern int errno;

			if (errno == EADDRINUSE)
				continue;

			perror("bind(2)");
			exit(1);
		} else
			break;
	}
	if (i >= 30) {
		fprintf(stderr, "Can't find a suitable port\n");
		exit(1);
	}

	if (connect(sfd, &hisaddr, addlen) < 0) {
		perror("connect");
		exit(1);
	}

	/*
	 * Tell caller that we're starting.  The content
	 * of this message is (presently) ignored, its used
	 * merely to tell remote end our new (unique) address.
	 */

	if (send(sfd, ConnMsg, strlen(ConnMsg), 0) < 0) {
		perror("send");
		exit(1);
	}

	/*
	 * now protocol is complete,
	 * just need to set things up for NNdaemon ...
	 */

	dup2(sfd, 1);
	close(0);
	dup(1);
	for (i = getdtablesize(); i >= 2; i--)
		close(i);

	/*
	 * Non-batch mode, fd == 1, no fork (we've already done that)
	 * on the host that the datagram arrived from
	 */

	execle(NNdaemon,
		"NNdaemon+udp", "-Fd", hp->h_name, (char *)0, (char **)0);

#ifdef INETD
 top:
#endif
	exit(1);
}

buryit()
{
	union wait status;

	while (wait3(&status, WNOHANG, 0) >= 0)
		;
}

#endif	BSD4 < 2
