/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)strrcmp.c	1.1 85/11/01
*/

/*
**	Compare two strings in reverse order to "strcmp()".
*/

int
strrcmp(s1, s2)
	register char *	s1;
	register char *	s2;
{
	register int	l1 = strlen(s1);
	register int	l2 = strlen(s2);

	s1 += l1;
	s2 += l2;

	while ( --l1 >= 0 && --l2 >= 0 )
	{
		if ( *--s1 == *--s2 )
			continue;

		return (*s1&0xff) - (*s2&0xff);
	}

	return l1 - l2;
}
