/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID 88/07/24 @(#)concat.c	1.3
*/

/*
**	Concatenate strings into allocated memory.
**	Variable number of args terminated by a NULLSTR.
*/

#include	"global.h"



#if VARARGS
char *
concat(va_alist)
	va_dcl
{
	register char *	ap;
	register char *	cp;
	register int	size;
	char *		string;
	va_list		va;

	va_start(va);
	for (size = 0; (ap = va_arg(va, char *)) != NULLSTR; )
		size += strlen(ap);
	va_end(va);
	
	string = cp = Malloc(size+1);

	va_start(va);
	while ((ap = va_arg(va, char *)) != NULLSTR)
		cp = strcpyend(cp, ap);
	va_end(va);
	
	return string;
}
#else
/*VARARGS1*/
char *
concat(s1, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10)
	char *		s1;
	char *		a0;
	char *		a1;
	char *		a2;
	char *		a3;
	char *		a4;
	char *		a5;
	char *		a6;
	char *		a7;
	char *		a8;
	char *		a9;
	char *		a10;
{
	char **		cpp;
	register char *	ap;
	register char *	cp;
	register int	size;
	char *		string;

	for ( size = 0, cpp = &s1 ; (ap = ARGS_OFF_STACK(cpp)) != NULLSTR ; )
		size += strlen(ap);
	
	string = cp = Malloc(size+1);

	for ( cpp = &s1 ; (ap = ARGS_OFF_STACK(cpp)) != NULLSTR ; )
		cp = strcpyend(cp, ap);
	
	return string;
}
#endif
