/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)SetLock.c	1.2 86/07/03
*/

/*
**	Set/test a lock file with passed pid.
*/

#define	FILE_CONTROL
#define	STAT_CALL

#include	"global.h"
#include	"debug.h"

#include	<signal.h>

#define	PIDLEN	LENGTH_SIZE
static char	pidstr[PIDLEN];

extern int	RdFileSize;
extern Time_t	RdFileTime;

#define	DELTA	(60*60)		/* Maximum time to write a lock file */



bool
SetLock(file, pid)
	char *	file;
	int	pid;
{
	int	fd;
	char *	s;

	Trace3(1, "SetLock(\"%s\", %d)", file, pid);

#	if	KILL_0 != 1 && SIG0 != SIGINT
	(void)signal(SIG0, SIG_IGN);	/* To allow interrogation for existence */
#	endif	KILL_0 != 1 && SIG0 != SIGINT

	RdFileSize = -1;

	if
	(
		(
			(s = ReadFile(file)) != NULLSTR
			&&
			RdFileSize == PIDLEN
			&&
			(fd = atoi(s)) > 0
			&&
			fd != pid
			&&
			kill(fd, SIG0) != SYSERROR
		)
		||
		(
			RdFileSize == 0
			&&
			(RdFileTime - time((long *)0)) < DELTA
		)
	)
	{
		if ( s != NULLSTR )
			free(s);

		return false;
	}

	if ( s != NULLSTR )
		free(s);

	while ( (fd = creat(file, 0664)) == SYSERROR )
		Syserror("Could not creat \"%s\"", file);

	(void)sprintf(pidstr, "%lu", (ulong)pid);

	while ( write(fd, pidstr, PIDLEN) != PIDLEN )
	{
		Syserror("Could not write \"%s\"", file);
		(void)lseek(fd, (long)0, 0);
	}

	(void)close(fd);

	Trace1(1, "SetLock returns true");

	return true;
}
