/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)ReadCom.c	1.2 85/10/09
*/

/*
**	Read in a command file and pass back commands via function.
**
**	Returns TRUE if no errors.
*/

#define	STAT_CALL

#include	"global.h"
#include	"command.h"



bool
ReadCom(fd, mtp, funcp)
	int		fd;
	Time_t *	mtp;
	bool		(*funcp)();
{
	register int	size;
	register char *	cp;
	register char *	end;
	char *		name;
	char *		base;
	char *		commands;
	struct stat	statb;

	if ( fstat(fd, &statb) == SYSERROR )
		return false;

	if
	(
		(statb.st_mode & S_IFMT) != S_IFREG
		||
		(size = (int)statb.st_size) != statb.st_size
		||
		size > MAXCOMZ
		||
		size < MINCOMZ
	)
		return false;

	commands = cp = Malloc(size+1);

	if ( read(fd, cp, size) != size )
	{
		free(commands);
		return false;
	}

	*mtp = statb.st_mtime;

	end = &cp[size];
	*end = '\0';
	size = 0;

	do
	{
		switch ( (Com_s)size )
		{
		case cs_fn:
			name = cp;
			break;

		case cs_base:
			base = cp;
			break;

		case cs_range:
			if ( !(*funcp)(newstr(name), atol(base), atol(cp)) )
			{
				free(commands);
				return false;
			}

			size = 0;
			continue;
		}

		size++;
	}
		while ( (cp += strlen(cp)+1) < end );

	free(commands);

	if ( cp != end || size != 0 )
		return false;

	return true;
}
