/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)MatchString.c	1.7 86/07/29
*/

/*
**	Find "match" in "string".
**	Return pointer to start of match, or NULLSTR.
**
**	Boyd & Moore algorithm.
*/

#include	"global.h"

#define	ASIZE	040
#define	AMASK	(ASIZE-1)



char *
MatchString(string, match)
	register char *	string;
	register char *	match;
{
	register int	i;
	register int	j;
	register int *	a;
	int		b[ASIZE];

	if ( string == NULLSTR || match == NULLSTR )
		return NULLSTR;

	for ( i = 0 ; match[i] != '\0' ; i++ )
		if ( string[i] == '\0' )
			return NULLSTR;

	if ( i == 0 )
		if ( string[0] == '\0' )
			return string;
		else
			return NULLSTR;

	for ( a = b, j = ASIZE ; --j >= 0 ; )
		*a++ = i;

	for ( a = b, j = 0 ; --i > 0 ; j++ )
		a[match[j]&AMASK] = i;

	for ( ;; )
	{
		i = j;

		if ( match[i] == string[i] )
		{
			do
				if ( --i < 0 )
					return string;
			while
				( match[i] == string[i] );

			i = 1;
		}
		else
			i = a[string[i]&AMASK];

		do
			if ( (++string)[j] == '\0' )
				return NULLSTR;
		while
			( --i > 0 );
	}
}
