/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID 88/07/24 @(#)InList.c	1.4
*/

/*
**	Return TRUE if arg1 is in list.
**
**	"list" may be any sequence of words separated by any of '\n', ' ', or '\t',
**	in any number of arguments terminated by a NULLSTR.
**
**	If "list" is a full path name, and the file can be read,
**	then the list will be read from the file.
*/

#define	FILE_CONTROL
#define	STAT_CALL

#include	"global.h"
#include	"debug.h"



#if VARARGS
bool
InList(va_alist)
	va_dcl
{
	char *		arg1;
	char *		list;
	register char *	cp;
	register int	count;
	va_list		va;

	va_start(va);
	arg1 = va_arg(va, char *);
	list = va_arg(va, char *);

	Trace3(2, "InList \"%s\" \"%s\"", arg1, list);

	count = 0;
	if (list != NULLSTR) {		/* this might not be necessary */
		if (MatchString(list, arg1))
			return true;

		for (count = 1; (cp = va_arg(va, char *)) != NULLSTR; count++)
			if (MatchString(cp, arg1))
				return true;
	}

	va_end(va);

	Trace2(2, "InList trying file \"%s\"", list);

	if ( count == 1 && list[0] == '/' && (cp = ReadFile(list)) != NULLSTR )
	{

		if ( MatchString(cp, arg1) )
		{
			free(cp);
			return true;
		}

		free(cp);
	}

	Trace1(2, "InList no match");

	return false;
}
#else
/*VARARGS3*/
bool
InList(arg1, list, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10)
	char *		arg1;
	char *		list;
	char *		a1;
	char *		a2;
	char *		a3;
	char *		a4;
	char *		a5;
	char *		a6;
	char *		a7;
	char *		a8;
	char *		a9;
	char *		a10;
{
	char **		cpp;
	register char *	cp;
	register int	count;

	Trace3(2, "InList \"%s\" \"%s\"", arg1, list);

	for ( count = 0, cpp = &list ; (cp = ARGS_OFF_STACK(cpp)) != NULLSTR ; count++ )
		if ( MatchString(cp, arg1) )
			return true;

	Trace2(2, "InList trying file \"%s\"", list);

	if ( count == 1 && list[0] == '/' && (cp = ReadFile(list)) != NULLSTR )
	{

		if ( MatchString(cp, arg1) )
		{
			free(cp);
			return true;
		}

		free(cp);
	}

	Trace1(2, "InList no match");

	return false;
}
#endif
