/*
**	Copyright (c) 1986 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)FreeArgs.c	1.2 86/07/22
*/

/*
**	Clear out VarArgs (all must have been malloc'ed).
*/

#include	"global.h"
#include	"debug.h"



void
FreeArgs(vap)
	register VarArgs *	vap;
{
	register char *		cp;
	register int		i;

	Trace2(2, "FreeArgs(%d)", NARGS(vap));

	if ( (i = NARGS(vap)) > MAXVARARGS )
		Fatal1("Too many VarArgs");
	
	while ( --i >= 0 )
		if ( (cp = ARG(vap, i)) != NULLSTR )
			free(cp);
	
	NARGS(vap) = 0;
}
