/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID 88/07/24 @(#)Fatal.c	1.5
*/

/*
**	Report on stderr
*/

#define	STDIO
#define	LOCKING

#include	"global.h"


#if VARARGS
void
Fatal(va_alist)
	va_dcl
{
	char *		s;
	va_list		va;

	va_start(va);
	s = va_arg(va, char *);
	VMesg("fatal error", s, va);
	va_end(va);
	putc('\n', stderr);
	(void)fflush(stderr);
	UnLock(0);	/* Only needed on systems with file-locking */
	(void)abort();
}
#else
/*VARARGS1*/
void
Fatal(s, a1, a2, a3, a4, a5, a6)
	char *		s;
	char *		a1;
	char *		a2;
	char *		a3;
	char *		a4;
	char *		a5;
	char *		a6;
{
	Mesg("fatal error", s, a1, a2, a3, a4, a5, a6);
	putc('\n', stderr);
	(void)fflush(stderr);
	UnLock(0);	/* Only needed on systems with file-locking */
	(void)abort();
}
#endif
