/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	@(#)EncodeName.c	1.3 85/06/26
*/

/*
**	Encode last element of a path name with various values.
*/

#include	"global.h"
#include	"debug.h"
#include	"messagename.h"



char *
EncodeName(name, flag1, flag2, time)
	char *		name;
	char		flag1;
	char		flag2;
	Time_t		time;
{
	register char *	p;

	/*
	**	Find last element of path name
	*/

	if ( (p = strrchr(name, '/')) == NULLSTR )
		p = name;
	else
		p++;

	DODEBUG
	(
		if ( strlen(p) < PNAMELEN )
			Fatal("EncodeName last component too short: \"%s\"", name);
	);

	EncodNum(&p[PFLAG1], (ulong)flag1, PFLAG1LEN);
	EncodNum(&p[PFLAG2], (ulong)flag2, PFLAG2LEN);
	EncodNum(&p[PTIME], (ulong)time, PTIMLEN);
	EncodNum(&p[PNUM], (ulong)MesgNumber++, PNUMLEN);

	return name;
}
