/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)DestReached.c	1.9 88/12/13
*/

/*
**	Check if HomeNode is in address,
**	if so, remove HomeNode from list if necessary, return true,
**	otherwise return false.
*/

#include	"global.h"

#include	"address.h"
#include	"debug.h"
#include	"header.h"


/*
**	Structure for parsing address into.
*/

typedef struct AddrEl *	Ap;

typedef union
{
	Ap	ua_part;
	char *	ua_addr;
}
		UAp;

typedef struct AddrEl
{
	Ap	a_next;
	UAp	a_adpt;
	char	a_type;
}
		AddrEl;

#define	a_part	a_adpt.ua_part
#define	a_addr	a_adpt.ua_addr

static Ap	Top;

/*
**	Structure for holding handler/address sets.
*/

typedef struct Handler *Hp;

typedef struct Handler
{
	Hp	h_next;
	Ap	h_addr;
	char *	h_name;
	int	h_count;
}
		Handler;

static Hp	Handlers;

static char *	Addrp;
static char *	FmtErr;

static void	address(), freeaddr(), do_handlers();
static bool	parse();



bool
DestReached(handler)
	int	(*handler)();
{
	bool	result;
	char *	work = newstr(HdrDest);

	Trace2(2, "DestReached with \"%s\"", HdrDest);

	FmtErr = NULLSTR;
	Handlers = (Hp)0;
	Top = (Ap)0;

	result = parse(&Top, HdrDest);

	if ( FmtErr != NULLSTR )
	{
		Error("Bad address format in DestReached \"%s\"", FmtErr);
		HdrDest[0] = '\0';
		result = false;
	}
	else
	{
		do_handlers(handler, work);

		Addrp = HdrDest;	/* Can do this as Top is in original order */
		address(Top);
	}

	free(work);

	return result;
}



static
bool
parse(prev_ap, addr)
	Ap *		prev_ap;
	register char *	addr;
{
	register Ap	ap;
	register Ap *	pap = prev_ap;
	register char *	tail;
	register int	c;
	int		count;
	int		parts;
	bool		result;
	char *		handler = NULLSTR;

	Trace3(3, "parse(%#lx, %s)", prev_ap, addr);

	switch ( c = *addr++ )
	{
	case ATYP_BROADCAST:
		ap = Talloc(AddrEl);
		ap->a_type = '\0';
		ap->a_addr = &addr[-1];
		ap->a_next = (Ap)0;
		*pap = ap;

		if ( *addr == '\0' )
			return true;

		if ( *addr++ == DOMAIN_SEP )
		{
			if ( *addr == ATYP_BROADCAST )
			{
				if ( addr[1] == '\0' )
					return true;
			}
			else
			{
				if ( HomeDomain(addr, &handler, EXCL_HIER) )
				{
					addr = ap->a_addr;
					goto test_handler;
				}

				return false;
			}
		}

		FmtErr = ap->a_addr;
		return false;

	case ATYP_GROUP:
	case ATYP_EXPLICIT:
	case ATYP_MULTICAST:
		result = false;
		count = 0;
		parts = 0;

		do
		{
			if ( (tail = strchr(addr, c)) != NULLSTR )
				*tail++ = '\0';
			else
			{
				if ( count == 0 )
				{
					FmtErr = --addr;
					return false;
				}
			}

			ap = Talloc(AddrEl);
			ap->a_type = '\177';
			ap->a_next = (Ap)0;
			*pap = ap;
			pap = &ap->a_next;

			if ( parse(&ap->a_part, addr) )
			{
				if ( c == ATYP_EXPLICIT && tail != NULLSTR )
				{
					freeaddr(ap->a_part);
					ap->a_part = (Ap)0;
				}
				else
				if ( ap->a_part != (Ap)0 )
					parts++;

				result = true;
			}
			else
			{
				if ( FmtErr != NULLSTR )
					return false;

				parts++;

				if ( c == ATYP_EXPLICIT )
				{
					if ( tail != NULLSTR )
					{
						*--tail = c;
						parts++;
					}

					result = false;
					break;
				}
			}

			count++;
		}
			while ( (addr = tail) != NULLSTR );

		if ( parts == 0 )
		{
			freeaddr(*prev_ap);
			*prev_ap = (Ap)0;
		}
		else
		if ( parts > 1 )
		{
			for ( ap = *prev_ap ; ap != (Ap)0 ; ap = ap->a_next )
				ap->a_type = c;
		}

		return result;
	}

	if ( HomeAddress(--addr, &handler, INCL_HIER) )
	{
		register Hp	hp;

		*pap = (Ap)0;

test_handler:
		if ( handler == NULLSTR )
			return true;

		for ( hp = Handlers ; hp != (Hp)0 ; hp = hp->h_next )
			if ( strcmp(handler, hp->h_name) == STREQUAL )
				break;
		
		if ( hp == (Hp)0 )
		{
			hp = Talloc(Handler);
			hp->h_next = Handlers;
			Handlers = hp;

			hp->h_name = handler;
			hp->h_addr = (Ap)0;
			hp->h_count = 0;
		}

		ap = Talloc(AddrEl);
		ap->a_next = hp->h_addr;
		hp->h_addr = ap;
		hp->h_count++;
	}
	else
	{
		ap = Talloc(AddrEl);
		ap->a_next = (Ap)0;
		*pap = ap;
	}

	ap->a_type = '\0';
	ap->a_addr = addr;

	return false;
}



static
void
address(tp)
	Ap		tp;
{
	register Ap	ap;

	Trace2(3, "address(%#lx)", tp);

	while ( (ap = tp) != (Ap)0 )
	{
		Trace3
		(
			3,
			" type '%c', addr \"%s\"",
			ap->a_type=='\0'?'0':ap->a_type=='\177'?'X':ap->a_type,
			ap->a_part==(Ap)0?"<null>":ap->a_type=='\0'?ap->a_addr:"<PART>"
		);

		if ( ap->a_part != (Ap)0 )
		{
			if ( ap->a_type != '\0' )
			{
				if ( ap->a_type != '\177' )
					*Addrp++ = ap->a_type;

				address(ap->a_part);
			}
			else
				Addrp = strcpyend(Addrp, ap->a_addr);
		}

		tp = ap->a_next;
		free((char *)ap);
	}

	*Addrp = '\0';
}



static
void
freeaddr(tp)
	Ap		tp;
{
	register Ap	ap;

	Trace2(3, "freeaddr(%#lx)", tp);

	while ( (ap = tp) != (Ap)0 )
	{
		Trace3
		(
			3,
			" type '%c', addr \"%s\"",
			ap->a_type=='\0'?'0':ap->a_type=='\177'?'X':ap->a_type,
			ap->a_part==(Ap)0?"<null>":ap->a_type=='\0'?ap->a_addr:"<PART>"
		);

		if ( ap->a_part != (Ap)0 && ap->a_type != '\0' )
			freeaddr(ap->a_part);

		tp = ap->a_next;
		free((char *)ap);
	}
}



static
void
do_handlers(handler, addr)
	int		(*handler)();
	char *		addr;
{
	register Hp	hp;
	register Ap	ap;
	register char *	cp;

	while ( (hp = Handlers) != (Hp)0 )
	{
		cp = addr;

		while ( (ap = hp->h_addr) != (Ap)0 )
		{
			if ( hp->h_count > 1 )
				*cp++ = ATYP_MULTICAST;
			cp = strcpyend(cp, ap->a_addr);
			hp->h_addr = ap->a_next;
			free((char *)ap);
		}

		(*handler)(hp->h_name, addr);

		Handlers = hp->h_next;
		free((char *)hp);
	}
}
