/*
**	Copyright (c) 1988 Alan Skea, University of New South Wales
*/

/*
**	Derived from:
**	"ENcall.c	1.2	12/10/86";
**	Copyright (c) 1986 Phillip Nicholson, Telecom Australia
**
**	Derived from:
**	"call.c	1.33 86/07/03";
**	Copyright (c) 1984 Piers Lauder, University of Sydney
*/

/*
**	Call a remote host and start a network daemon on it.
*/

#ifndef	lint
static char	sccsid[]	= "@(#)ENcall.c	2.0	88/02/25";
#endif	lint

char	Usage[]	= "\nUsage: %s [-[&][F][I]] [-D<daemon>] [-T<level>] [-ddaemonargs]\\\n\
	-h<host> [-i<inet-host>] [-l<logfile>] [-t<timeout>]\n";


#define	FILE_CONTROL
#define	TERMIOCTL
#define	STDIO
#define	RECOVER

#include	"global.h"
#include	"debug.h"

#include	<signal.h>
#include	<errno.h>

#include	"caller.h"


/*
**	Parameters set from arguments
**/

int		Background	= 0;	/* True if call runs in background */
VarArgs		DmnArgs			/* Passed to exec to invoke daemon */
=
{
	2,
	ENDAEMON,			/* Node-node daemon */
	"-F"				/* no fork */
}
;
bool		IgnoreOldPid	= false;
char *		Name;
int		Traceflag	= 0;
FILE *		LogFd		= NULL;
unsigned int	TimeOut		= TIMEOUT;

/*
**	Miscellaneous
*/

char *		Spooldir	= SPOOLDIR();
char *		DevNull		= "/dev/null";
int		Fd		= SYSERROR;
char *		Acs_Target	= NULLSTR;
char *		Udp_Target	= NULLSTR;
char		Errbuf[BUFSIZ];


/*
**	Routines
*/

int		catch();

void		args(),
		cleartty(),
		usage();


int
main(argc, argv)
	int	argc;
	char **	argv;
{
	register int	c;

	if ( (Name = strrchr(*argv, '/')) != NULLSTR )
		Name++;
	else
		Name = *argv;

	Recover(ert_return);
	args(argc, argv);

	if ( Acs_Target == NULLSTR )
	{
		Error("No target specified");
		return 1;
	}

	if
	(
		chdir(Spooldir) == SYSERROR
		||
		chdir(Acs_Target) == SYSERROR
	)
	{
		Syserror("%s%s inaccessible", Spooldir, Acs_Target);
		return 1;
	}

	if ( (argv = (char **)ReadFile(CALLARGS)) != (char **)0 )
	{
		VarArgs va;

		FIRSTARG(&va) = Name;
		SplitArg(&va, (char *)argv);
		args(NARGS(&va), &ARG(&va, 0));
		free((char *)argv);
	}

	if ( Udp_Target == NULLSTR )
		Udp_Target = Acs_Target;

	if ( Background )
	{
		switch ( fork() )
		{
		case SYSERROR:
			Syserror("Can't fork");
			return 1;

		case 0:
			break;

		default:
			return 0;
		}

		(void)cleartty();

		if ( LogFd == NULL )
			(void)freopen(DevNull, "w", stderr);

		(void)signal(SIGHUP, SIG_IGN);
		(void)signal(SIGINT, SIG_IGN);
		(void)signal(SIGQUIT, SIG_IGN);
	}
	else
		if ( signal(SIGINT, SIG_IGN) != SIG_IGN )
			(void)signal(SIGINT, catch);

	(void)signal(SIGTERM, catch);

#	if	KILL_0 != 1
	(void)signal(SIG0, SIG_IGN);
#	endif	KILL_0 != 1

	if ( !IgnoreOldPid && DaemonActive(".", true) )
		return 0;

	(void)SetDaemonActive(".", getpid());

	if (( Fd = ConnectSocket(Udp_Target)) == SYSERROR )
		return 1;

	(void)SplitArg(&DmnArgs, Acs_Target);

	if ( NARGS(&DmnArgs) > MAXVARARGS )
		Error("too many args for \"%s\"", ARG(&DmnArgs, 0));

	if ( NARGS(&DmnArgs) < 3 )
		Error
		(
			"too few args for daemon: \"%s %s\", need at least path name of daemon, flag \"-B\" or \"-d\", and name of link",
			ARG(&DmnArgs, 0),
			ARG(&DmnArgs, 1)
		);

	(void)dup2(Fd, 0);
	(void)dup2(Fd, 1);
	(void)close(Fd);

	Trace5
	(
		1,
		"%s %s %s %s",
		ARG(&DmnArgs, 0),
		ARG(&DmnArgs, 1),
		ARG(&DmnArgs, 2),
		ARG(&DmnArgs, 3) == NULLSTR ? "" : ARG(&DmnArgs, 3)
	);

	(void)fflush(stderr);

	(void)execve(ARG(&DmnArgs, 0), &ARG(&DmnArgs, 0), StripEnv());
	Syserror("cannot exec \"%s\"", ARG(&DmnArgs, 0));
	return 1;
}


int
catch(sig)
	int	sig;
{
	(void)signal(sig, SIG_IGN);
	finish(0);
}


finish(reason)
	int	reason;
{
	exit(reason);
}


void
cleartty()
{
#ifndef	BASSER
	register fd;

	(void)setpgrp(0, 0);

	if ( (fd = open("/dev/tty", 0)) < 0 )
		return;

	(void)ioctl(fd, TIOCNOTTY, (char *)0);
	(void)close(fd);
#endif	BASSER
}


#if VARARGS
void
usage(va_alist)
	va_dcl
{
	va_list		ap;
	register char 	*s;

	va_start(ap);
	s = va_arg(ap, char *);
	VMesg("argument error", s, ap);
	va_end(ap);
	(void)fprintf(stderr, Usage, Name);
}
#else
/*VARARGS1*/
void
usage(s, a1, a2)
	char *	s;
	char *	a1;
	char *	a2;
{
	Mesg("argument error", s, a1, a2);
	(void)fprintf(stderr, Usage, Name);
}
#endif

void
args(argc, argv)
	register int	argc;
	register char *	argv[];
{
	while ( --argc > 0 )
	{
		if ( **++argv == '-' )
		{
			register int	c;

			while ( c = *++*argv )
			{
				switch ( c )
				{
				case '&':
					Background++;
					continue;

				case 'D':
					ARG(&DmnArgs, 0) = ++*argv;
					goto break2;

				case 'F':	/* for rundaemon */
					continue;

				case 'I':
					IgnoreOldPid = true;
					continue;

				case 'T':
					if ( (Traceflag = atoi(++*argv)) <= 0 )
						Traceflag = 1;
					break;

				case 'd':
					NEXTARG(&DmnArgs) = ++*argv;
					goto break2;

				case 'h':
					Acs_Target = ++*argv;
					goto break2;

				case 'i':
					Udp_Target = ++*argv;
					goto break2;

				case 'l':
					if ( (LogFd = freopen(++*argv, "a", stderr)) == NULL )
					{
						Syserror("can't open \"%s\"", *argv);
						return;
					}
					goto break2;

				case 't':
					if ( (TimeOut = atoi(++*argv)) == 0 )
					{
						usage("bad timeout %d", TimeOut);
						return;
					}
					break;

				default:
					usage("unrecognised flag '%c'", c);
					return;
				}

				while ( (c = **argv) <= '9' && c >= '0' )
					++*argv;
				--*argv;
			}

break2:			;
		}
	}
}
