.\" pic | tbl | troff -mm
.nr Hy 0
.fp 4 HB
.ds HF 3 3 2 2 2 2 2
.ds HP 12 11 10 10 10 10 10 10
.nr Hb 7
.ds sN \s-1SUN\ III\s0
.ds iG \fIInstallation Guide\fP
.ds uX \s-1UNIX\s0
.ds dD \fIDomain Addressing on \s-1SUN\ III\s0\fP
.ds aM acsmap
.ds mN physiol.su.oz
.\"
.\" command definitions - should be set from the Makefile
.\"
.ds aW \f(CWacswhois\fP
.ds cN \f(CWcon\fP
.ds dS \f(CWdis\fP
.ds fF \f(CWfetchfile\fP
.ds gF \f(CWgetfile\fP
.ds lK \f(CWlinkstats\fP
.ds pU \f(CWpurge\fP
.ds aQ \f(CWacsqueue\fP
.ds rD \f(CWrundaemon\fP
.ds rQ \f(CWrequest\fP
.ds sF \f(CWsendfile\fP
.ds aS \f(CWacsstate\fP
.ds sT \f(CWacsstop\fP
.\"
.de cS
.sp 0.2c
.ft CW
.nf
.in +1c
..
.de cE
.fi
.in
.ft R
.sp 0.2c
..
.TL
Getting Started and Debugging Guide for \*(sN
.ds ZZ University of Sydney
.AF "Department of Physiology"
.AU "David F. Davey" "" ZZ
.AS
This document is designed to supplement the
guide to the installation
of the \*(sN software.
It details simple checks of the integrity of the installation,
and is aimed at trying to catch some of the common problems
before they cause trouble.
There is also information on some of the "tricks" that can be
used to detect and work around faults in the network operation.
.AE
.de mA
\f4\s-1\\$1\s0\fP\\$2
..
.\" version 1.01 checked and corrected by piers@cs.su.oz, johnd@physiol.su.oz
.\" version 1.02 prompted substantial input from kre@munnari.oz
.\" version 1.03 sent to piers kre stephenf brian@hpulsa john@basser etc.
.\"		- corrections from piers and john, numerous suggestions from kre
.OF "''V E R S I O N   1.04'\\\\*(DT'"
.EF "'\\\\*(DT'V E R S I O N   1.04''"
.MT 4
.SA 1
.H 1 INTRODUCTION\*F
.FS
Although I
.I initiated
this document, partly because of experiences
related to aus.map (see AUUGN 9(1):1-13),
it would not be in its present form without substantial help from
Robert Elz, and additions and improvements from John Mackin,
Stephen Frede and Chris Maltby.  Moreover it would not exist at all
without Piers Lauder,
not only because he is responsible for \*(sN,
but because he tolerated what must have seemed an endless series of
questions.
Suggestions for improvements or additions to daved\|@physiol.su.oz please.
.FE
This document is designed to assist in:
.BL
.LI
getting a new installation running even if you know little about \*(sN
.LI
solving some common problems with running installations
.LE
.P
The document begins with consideration of some important decisions that
must be made before your first network connection is established,
some of which are difficult to reverse.
This is followed by
instructions on how to perform some tests
before you attempt to make contact with your network "neighbour(s)",
i.e. before starting the daemon(s).
You can be sure that if these tests fail without the daemon(s) running,
things will not be improved by starting them.
.H 2 "Preliminaries \- node and domain names"
There are some decisions you must make before your node can make
contact with the rest of the network.
These include:
what node your node will link to;
what name your node will be known by;
and what domains your node will belong to,
including probably a domain you create for your site.
Your link arrangements must be made with the cooperation of
the site you wish to link to.\*F
.FS
If you need to find a site to connect to,
there are some sites that will provide a link for a fee,
e.g. metro.ucc.su.oz (University of Sydney Computing Service).
.FE
Contact with the system administrator there is absolutely essential,
and in the first instance must be by non-network means.
This person may also serve to advise you with regard to
the name questions below,
either to answer questions or refer you to someone who can.
You should already have read the relevant parts of the \*(iG and the
document on \*(dD,
but some important points will be reiterated here:
.BL
.LI
Your domain name, assuming you create one for your site,
.I must
be unique within the regional domain to which you connect.
.LI
Your node name
.I must
be unique within any domain you are a member of.
.LI
Your node name is best chosen to be unique within \*(sN.
.LI
There are some advantages to a node name which is absolutely unique.
.LI
You should avoid names with equivocal characters (e.g. vax1
.I vs.
vaxl).
Such names
.I will
be confused.
.LI
Be creative when deciding upon your node name.\*F
.FS
Your node will be known by its name.
People will use the name in speech and text.
It is nice if the name is pronounceable.
It is boring if it is yet another combination of meaningless
letters coupled to a machine type (e.g.
.I yavax ).
Besides when you replace your Vax with a Cray, it will be silly for it
to be called
.I yavax .
.FE
.LE
.P
.B "Be Warned:"
It is difficult to change your node name.\*F
.FS
Strictly this means changing your node name is likely to have so many
adverse effects that doing so is masochistic even though the
act of changing the name is easy.
If you have a network of Suns,
be aware that randomly changing
your hostname or domainname (with those commands) may interfere
with NFS, YP etc.
Set these names first, before compiling \*(sN.
.FE
It is close to impossible to change your hierarchy.
Therefore it is important to get these right at the outset.
.H 2 "Preliminaries \- The \*(sN account name \f4\s-1ACSNETNAME\s0\fP"
As stated in the \*(iG the \*(sN processes will run under the account
name
.mA ACSNETNAME
and its associated
.mA ACSNETUID ,
and is installed under group
.mA ACSNETGROUP
and its associated
.mA ACSNETGID .
There are a number of advantages in creating a special account for
this purpose.
Indeed on some systems, notably those that restrict the number of processes
that an account can run at one time,\*F
.FS
Notably 4.3BSD and derived systems.
.FE
there are dangers in not doing so,
for at times \*(sN can generate a substantial number of processes.
On systems supporting disc quotas,
having a separate account for \*(sN can be useful in keeping track of
disc usage.
On systems with more elaborate accounting,
other parameters may be monitored.
It is also possible to allow certain users to know the account password
in order to allow access to \*(sN files that would otherwise be restricted,
although on some systems this can be managed more easily through
.mA ACSNETGROUP
access.
.H 2 "Preliminaries \- the compilation configuration"
As described in the \*(iG,
there are two ways to organise the compilation of \*(sN for your
system:
to edit the template Makefile (\fIMakefile.dist\fP),
or use a
.I run
file.
The latter method is preferable because it is much easier to adapt
to a new distribution of the software.\*F
.FS
New distributions will be necessary as new features are
added to the network and bugs are eliminated.
A sound
.I run
file can make the installation of such updates a trivial task.
.FE
If your system is one already catered for in the distributed
.I run
files (in the
.I Makefiles
directory,
your task should be easy.
Nevertheless your
.I run
file must be checked carefully and will almost certainly
need to be edited with regard to simple matters like
.mA ACSNETNAME ,
.mA ACSNETUID ,
and
.mA FUZZ ,
with careful reference to the \*(iG for the definitions.
The
.I run
files also tend to get out-of-date,
so it is also important to check through the
.I Makefile.dist
that came with your distribution to check each parameter will be
set the way you want it,
adjusting the
.I run
file where necessary.
.P
If your system is one that "auto-nices" long running processes
it is essential to set
.mA NICEDAEMON
to a negative value,
otherwise the daemons will become so "nice" they will cease
to be of any use.
.P
If you are configuring for a system not referenced in any of the
.I run
files,
or for a new CPU,
particular care must be exercised.
Examination of values for
.mA CONFIG
and
.mA CFLAGS
in the available
.I run
files will give hints of places to look out for problems.
If you do configure for a new system,
share the result with future installers by sending the working
.I run
file to wherever you obtained your \*(sN distribution.\*F
.FS
Send it to piers@basser.cs.su.oz by default.
.FE
If you are aware of deficiencies in your compiler, e.g. with the
optimiser,
adjust
.mA CFLAGS
accordingly,
as optimisation is used by default.
.P
For any "first-time" installation,
or one which is not on a fairly standard system,
it is worth setting
.mA DEBUG =2
so that tracing can be enabled if any debugging is required.
.H 2 "The compilation"
Assuming you have your
.I run
file ready, the basic steps in the compilation and installation are just:
.cS
\&./run certain
\&./run directories special
\&./run install
.cE
.br
.\" I shouldn't need the need but...
.ne 2c
.H 1 "GETTING STARTED"
.H 2 "Tests of user commands to perform before starting the daemon(s)"
.P
Once the \*(sN software is compiled and installed,
there are a number of tests you can perform to help ensure
the integrity of the installation which do not require the
network daemons to be active, i.e. these tests can be (or should be)
carried out before you attempt to make contact with other machines.
These tests are best performed when logged in
.I without
special privileges,
to check that the correct permissions have been established for
ordinary users.\*F
.FS
However if your installation makes use of flags to control network access
(e.g. AUSAS or MUSH),
make sure the account that will do the testing has the appropriate flag(s)
first!
.FE
None of the tests should result in error messages if the installation is
sound.
If error messages do occur,
hopefully they will be self explanatory,
and the fault should be corrected;
some of the possible causes of faults are detailed with each test.
.BL
.LI
Try sending yourself a file:
.cS
\*(sF\*F my_login file_name
.cE
.FS
The names by which the \*(sN commands are known are configurable.
The names used in the printing of this document are related to the
names used in the configuration as follows:
.TS
center;
rf4 l.
\s-1CON\s0	\*(cN
\s-1FETCH\s0	\*(fF
\s-1FILEGETTER\s0	\*(gF
\s-1QUEUE\s0	\*(aQ
\s-1SEND\s0	\*(sF
\s-1STATEP\s0	\*(aS
\s-1STOP\s0	\*(sT
\s-1WHOIS\s0	\*(aW
.TE
.FE
There should not be any error messages (unless you use a non-existent login
name or file name).
You should receive mail telling you the file is available,
and then, as described below,
you should be able to collect the spooled file.
.LI
First examine the mail.
Check the headers carefully to see if the
addresses are correct (the mail interface is a common problem
with new installations).\*F
.FS
If mail advising you that the file is available for collection
is not received,
see the section
"PROBLEMS WITH THE MAIL INTERFACE" for help on specific problems.
It cannot be over-emphasised that lack of mail at this stage is a serious fault,
since almost all the \*(sN error handling is by mail to the account
set with
.mA FUZZ
in the compilation.
If such mail cannot be delivered,
faults will never be apparent.
.FE
.LI
Try collecting the file.  It is worth changing directory first so
collecting it will not interfere with the original
.cS
cd /tmp
\*(gF
.cE
You should need only to type a 'y' and a RETURN in response to the query.
Examine the file ownership and mode after collection.
With the possible exception of permissions masked by your
.I umask
they should be the same as the original.
Compare the collected and sent file, which should be identical.
.LI
Check that mail to your network address works:
.cS
mail my_login@our_node
.cE
Again check the headers carefully,
paying particular attention to the "From " and "From: " lines which
should contain your user name and node name in the form
.I username@node.domains.
If the node and/or domain information is missing,
it could be for any one of a number of reasons,
some of which do not indicate faults.  Nevertheless it is worth
checking this out by referring to the section on
"Testing network mail locally".
.LI
Check that the commandsfile information has correctly set up the statefile:
.cS
\*(aS -V our_node
.cE
The output should look something like:
.DS
.cS
our_node          {domain1.domain2.oz} [domain1|domain2]
                   "Our comment string"
.cE
.DE
This fictitious output would relate to lines in the commandsfile:
.cS
.ta +1i +1.8i
#
# configure our node
#
domain	our_node	domain1,domain2
hierarchy	our_node	domain1.domain2.oz
comment	our_node	"Our comment string"
.cE
In other words,
the output should show an entry for your node name, with its
hierarchy in braces and its domains in brackets separated by '|'
characters with the primary domain listed first.\*F
.FS
The node you intend to connect to must be a member (at least) of this
primary domain.
.FE
Your comment should follow.
With the possible exception of the comment,
all these components should be present in the \*(aS output.
The hierarchy
.I must
end in the top domain, currently "oz" for Australia.\*F
.FS
Some other top domains are "nz" for New Zealand, "th" for Thailand.
.FE
If anything is missing from the output,
you should edit the commandsfile with reference to the \*(iG and the manual for
\*(aS;
a task which must be performed with system privileges.\*F
.FS
Whenever you edit the commandsfile you should run the command:
.cS
\*(aS -RSWc
.cE
which will force the changes into the routing file (\-R) and the state file
(\-S), as well as give warnings (\-W) about any faults.
The c argument must come last to indicate the default commandsfile.
.FE
There could be other things listed if you put them in the
commandsfile,
such as "caller" or "filter".\*F
.FS
It is worth noting that the contents of the commandsfile should be kept
to a minimum and managed very carefully (see section "ROUTING PROBLEMS".)
.FE
If you put information on links in the commandsfile (not the
recommended procedure),
information on these links will follow the \*(aS output on "our_node".
Assuming you did not put the link information in the commandsfile
(the recommended procedure),
some of the simple tests below will not work,
so you should temporarily get \*(aS to add information to
the state and routing files for the node to which you intend to link,
which is called "neighbour" in this document.
Execute the command:
.cS
\*(aS -RSWC\*F<<!
add	neighbour
link	our_node,neighbour	msg
!
.cE
.FS
The upper case C tells state to read commands from standard input
instead of from the commandsfile as in the previous example.
.FE
.LI
Check that the link information is correctly displayed by \*(aS.
.cS
\*(aS -V our_node
.cE
The output should now look something like:
.DS
.cS
our_node          {domain1.domain2.oz} [domain1|domain2]
                   "Our comment string"
 ->         neighbour (msg)
.cE
i.e. the link to neighbour is shown (indicated by "\f(CW->\fP"),
together with the link flags in parentheses.
.DE
.LI
Check that the link(s) you expect to have are listed by
the \*(lK command.
Try
.cS
\*(lK
.cE
which should print a header, then one line of output for each link
you intend to have.  The absence of such lines most likely indicates
that the directories for them have not been set up.
See the \*(iG "Starting the Network".
.LI
Try to send a file to your nearest neighbour
.cS
\*(sF root@neighbour < /dev/null\*F
.cE
.FS
The use of \*(sF redirected from /dev/null is the most efficient
means of testing \*(sF, as no file to send is needed, and a zero-length
file is sent.
.FE
.LI
Now check that this file has been spooled for transmission (it will not
actually be transmitted until the network
daemon is active):
.cS
\*(aQ -V neighbour
.cE
which should give output something like:
.cS
.ps -2
neighbour       daemon inactive
                1 message in queue
1: Files from my_login at our_node.domains to root@neighbour at neighbour 138 bytes
               0  Jan 17 12:04  stdin
.ps
.cE
where the number of bytes will probably be different, and the time is
the last modification time of /dev/null, not when the message was sent.
.LI
You probably do not want this test message to be delivered,
so check that you can stop it:
.cS
\*(sT
.cE
which should result in output something like:
.cS
Link to neighbour:-
Files   from my_login    to root@neighbour at neighbour    138 bytes
Stop ? (y or n)
.cE
To which you need type only a 'y' and RETURN,
after which \*(sT should report:
.cS
1 message stopped.
.cE
which you can confirm with the \*(aQ command.
.LI
You can check the \*(aW command:
.cS
\*(aW my_login@our_node
.cE
which at the very worst should give you the message "Information not available",
indicating the whois database you specified in the configuration is
not available, possibly by choice.
.LI
You can check that the \*(fF command is operational:
.cS
\*(fF -dour_node -L .\*F
.cE
.FS
Note that the last argument is a dot.
.FE
What will happen is dependent upon whether you configured your
installation to serve as a fileserver host\*F
.FS
Acting as a fileserver host means that you have a place where you
put files that users at other nodes may request to have sent to them.
If you think that your site may be a source of files for other
sites,
you should define
.mA PUBLICFILES
in your configuration.
If you want to minimise the size of your \*(sN installation
or exclude the possibility of a security hole that acting
as a fileserver could represent,
leave it out.  (Note: this is not to suggest there are
.I known
security problems with \*(fF.)
Consult the \*(iG for more information.
.FE
by defining
.mA PUBLICFILES
\&\*F
.FS
Upper case names printed in this way refer to compile time definitions
which are site configurable.
They are described in the \*(iG.
.FE
in your configuration.
If you did, the \*(fF command
should result in a file called PublicFileList being sent to you.
The message:
.cS
fileserver: error --  No public files are currently available.
.cE
indicates the directory you specified in the configuration is not accessible.
If you did not define
.mA PUBLICFILES
you should get the message:
.cS
There are no remotely accessible files at our_node.  Sorry.
.cE
.LE
.H 2 "Tests of system commands to do before you start the daemons"
These commands can only be executed with system privileges.
Some of them are not installed in your system bin directory,
but are to be found in the _lib directory in the \*(sN spool
directory.
.BL
.LI
The \*(pU command should be run regularly (see "Maintenance"
section) to clean up the
\*(sN directories of out-of-date files.
You should check that this command is executable and does not report
any errors
.cS
\&./\*(pU \-W
.cE
.LI
Many of the standard user commands have flags that only the system
administrator can use.  e.g the \*(gF command can be used to collect
(or delete) files sent to any user.  You should test that one of the
restricted flags will work, e.g. try:
.cS
\*(gF \-LA
.cE
which will list all files spooled regardless of who they were sent to.
This is valuable in checking for uncollected files, or in cleaning
up if disc space is short.
.LI
The \*(rQ command is one you will probably not need to use,
and certainly should not use unnecessarily.\*F
.FS
Amongst other things,
reverse charging applies to the file(s) the request causes to be sent to you.
.FE
Nevertheless,
in a sound installation it should work,
so try this simple test of the \*(rQ command:
.cS
cd /usr/spool/ACSnet/_lib\*F
\&./\*(rQ neighbour
.cE
.FS
on a "standard" installation.  Your _lib directory could be
somewhere else according to your configuration at compile time.
.FE
This command should queue a state file for delivery to neighbour.
.cS
\*(aQ \-VMA
.cE
should list this message; the listing should include the string "ENQ"
.LE
.H 2 "Simple tests of the mail interface"
First check that mail to a non-existent node generates an error.
.cS
mail blogs@notanode
.cE
should, depending on your
.I mail
program, either give the message:
.cS
sendfile: error -- "notanode" unknown
.cE
or generate mail to you informing you that the mail was undeliverable.
.P
Check that mail to a user at a node that is in your statefile
("neighbour" in the examples above),
is spooled for delivery.
.cS
mail blogs@neighbour
.cE
should
.I not
generate any errors,
and it should be visible with the \*(aQ command.  The command
.cS
\*(aQ -VM
.cE
can be used to check that the message has been queued,
but also that the "mail envelope" is correct,
i.e. that the sender and destination look correct in the
\*(aQ output.  (Note that since these are generated by the
.I mail
program initially and not by \*(sN,
we are checking something quite different to the \*(sF tests
above.)
.P
Next check that the contents of the message are correct.
Change directory to
.mA SPOOLDIR /neighbour and list the directory contents.
There should be a file with a name made up of apparently meaningless characters;
This file contains information as to where the files containing the message
and the \*(sN message header are located.
Use
.I strings(1)\*F
.FS
In its absence use \f(CWcat -v\fP or \f(CWod -c\fP.
.FE
to examine this file.  The file name in the _work directory is the critical
one.  It is essentially a binary file,
although in many cases it may begin with an ascii component.  It will
always end with the binary \*(sN FTP.
Examine this file to see if the
mail header lines look correct \- again
.I strings(1)
or a similar program can be used.
The command
.cS
sed "" spool_file
.cE
is a simple way to strip the FTP from an otherwise ascii file.
.P
If the file contents do not appear sound,
consult the section "PROBLEMS WITH THE MAIL INTERFACE".
You should now \*(sT the message.
.H 2 "Tests on network-related commands not really part of \*(sN"
.P
The internationally agreed upon standard account for mail
enquiries at all sites is "postmaster"\*F.
.FS
See RFC822 "Standard for the format of ARPA Internet messages".
This document is obtainable from a number of sites, including
munnari.cs.mu.oz and physiol.physiol.su.oz, e.g.
.cS
\*(fF -dphysiol.physiol.su.oz rfc/rfc822
.cE
.FE
You should check that
.cS
mail postmaster
.cE
works and that the mail is delivered to someone who will attend to
it.  If your system does not already have a postmaster facility,
you should establish it.  If your mail programs support aliases
for incoming mail you can alias postmaster to root or someone
appropriate.  If it does not, you must create an account postmaster,
preferably arranging for mail forwarding to the system administrator.
Ideally,  all case variant names should be recognised (i.e. Postmaster,
POSTMASTER, PostMaster etc.)
If your mail program accepts case independent names,
such variants will obviously be accepted,
but if not,
the obvious additional aliases should be included.
.H 2 "Testing a daemon and a link"
.P
There is really only one test of what is happening on a link:
the \*(lK command.  It can be given a flag (\-c) to repeatedly output
the status of the link, and this output can be piped to the
command \*(dS.\*F
.FS
The source for \*(dS
is distributed with \*(sN, but it is not
installed as a part of the normal installation.
To compile it:
.cS
cd <your \*(sN source directory>
cd Control
make dis
.cE
If you install this command, you should also install the manual
which distributed with the sources.
.FE
If your system supports windows, or if you can devote a terminal
to this command, run:
.cS
\*(lK \-Vc3 neighbour | \*(dS\*F
.cE
.FS
Some administrators find a shell script or function to do this is handy:
.cS
\*(lK \-Vc3 ${1:-neighbour} | dis
.cE
.FE
.I while
the daemon is starting,
.ig XX
.FS
The particular issue of starting the daemon(s) is not addressed
(at least not yet)
in this document.
What must be done is highly dependent upon the type of link you
are going to establish, and must be done with the cooperation
of the site to which you will link.  The \*(sN expert at that site
will be the best source of specific advice on what to do.
Unless the site is very remote,
the best strategy is to have the remote site's expert on the phone at the
time, so someone can be watching \(lK from the other end.
.FE
.XX
and while you try to establish your link and
perform some of the operations in the
section "ESTABLISHING YOUR LINK".
.H 2 "Cleaning up after the tests"
Any test files spooled for link "neighbour" following the above tests
should be removed,
and if you added link information by reading from standard input as
recommended above,
this link information should now be removed:
.cS
\*(sT -AY neighbour
\*(aS -RSWC<<!
remove neighbour
!
.cE
.H 1 "ESTABLISHING YOUR LINK"
There are a variety of ways your node may establish contact
with another node.
The nature of the connections involves two issues:
the nature of the physical link;
the nature of the logical link used over the physical link.
You may have a dedicated connection between
your node and the one you link to,
e.g. twisted pairs and line
drivers between two machines in reasonable proximity,
or an Ethernet,
or even an infrared or microwave link over longer distances.
For isolated sites it is more common to make use of a telephone
modem link, usually on an intermittent basis, especially if the
telephone calls involve long distance charges.
Over dedicated links it is common to have node-to-node
communication operating on a permanent basis.
This minimises transmission delays.
However, sometimes even a dedicated link may be used
for other purposes, e.g. remote logins, and can be used for
\*(sN communication only intermittently,
although it is possible to do both if you can run a multiplexer
protocol over the link.
(See "Remote logins using \*(sN".)
.P
Intermittent links have a calling and a called end.
You may wish to provide for both if possible.
.H 2 "Common requirements for all links"
There must be a directory with the \*(sN spool directory,
.mA SPOOLDIR ,
named with
the name of the link.
This directory must be owned by
.mA ACSNETNAME ,
and be read-write-executable by owner.
Unless you are paranoid, it can be read-executable by mortals.
.P
If there are special reasons to do with the nature of the link,
you might need to insert appropriate "add" and "link" lines to your commandsfile
with a minimum of detail about the link.\*F
.FS
There are pros and cons to doing this.
The state information concerning
the link will be established automatically when \*(sN daemons
first run on the link,
and thus it is not necessary to include link
information in the commandsfile.
Indeed the "add" command overrides \*(sN's automatic
configuration behaviour.
On the other hand,
it is not possible to spool files for a link until the statefile
contains information about it.
This makes preliminary testing
somewhat difficult,
but can cause serious problems if the statefile is corrupted
or has to be truncated,
and the only state information will come from the commandsfile.
.FE
.P
Within the link directory, you should create a file called
.I params
which can contain arguments for the daemon used on
the link.  It can be empty at this stage, but should
be readable by
.mA ACSNETNAME .\*F
.FS
If you intend to let the remote site be responsible for the link,
the file should be owned by the user from the remote system who
must be able to adjust the contents to match those at the remote end.
.FE
.H 2 "Permanent links over dedicated connections"
This is probably the simplest form of link.
There must be a special file
which the daemon will use to connect to the remote link.
This file must therefore be appropriate to the physical connection
to be used, and must be read-writeable by
.mA ACSNETNAME .
The file name can be passed to the daemon as a \-d\fIspecial_file_name\fP
argument, or the default name can be used which requires that
in the directory /dev/net there be a file having
the same name as the link's nodename,
e.g. for a link to node "neighbour",
the file
.I /dev/net/neighbour .
Unless the transmission speed of the link is hard wired,
edit the link
.I params
file to contain a \-p\fIspeed\fP\*F
.FS
Note that the
.I speed
is not the baud rate
.I "per se"
but the system define for that speed.  See the
.I NNdaemon(1)
manual.
.FE
flag according to the baud rate the link will
be run at (remembering that this will have to be the same
at both ends).
All that needs to be done to activate the link is to
run the NNdaemons at both ends,
assuming that the physical link is sound\*F.
.FS
One way to test the physical link is to get the remote site to run a
getty on their end of the line,
and use a utility like
.I cu(1)/tip(1)
or something similar (\*(sN'c \*(cN utility for example) to
connect to the line at the local end and make sure you can log in at the remote
end,
and that you can examine large files on the remote machine
without character loss or corruption.
(See the section "Remote logins using \*(sN" for information on how to use
\*(cN for this purpose.)
.FE
These should normally be started in the system startup code,
e.g. by placing an appropriate line in /etc/rc:
.cS
(cd /usr/spool/ACSnet/_lib; ./\*(rD -I -w60 neighbour)
.cE
The command \*(rD is used instead of directly invoking \f(CWNNdaemon\fP
because the NNdaemons have a nasty habit of dying from
time to time and rundaemon will start a new daemon upon
such a death.
Alternatively,
if your system supports /etc/inittab,  the NNdaemon
can be spawned from it (with a respawn flag).
Once the NNdaemons are running at both ends,
\*(lK should show the link as up and \*(aS should show that there
has been an exchange of state information.
(See "Testing a daemon and link.")
Any failure at this stage is most likely due to
incorrect special files,
mismatched speeds or problems with the physical link such as
incorrect cabling.
.H 2 "Setting up for incoming calls \- intermittent links"
If you are arranging for an intermittent link,
most commonly over modems,
setting up for the remote site to call you in the first instance is easiest.
The daemons are started through the remote system logging into yours,
so whatever the incoming route, it must be set up to accept logins.
.BL
.LI
Make an account for the calling node.
The account name should be the name of the calling node.\*F
.FS
If you cannot use the nodename, e.g. if it has more characters than
your system will tolerate for login names,
or if the login name is already in use,
chose a reasonable alias that you can use for a login
name, and create an account with this name instead.
Then add the line
.cS
.ta +1i +1.8i
alias	real_nodename	chosen_alias
.cE
to your commandsfile after the "link" line for the node.
Finally advise the calling node that they will have to use
the alias you selected.
.FE
(It will be used by the calling program at the remote site.)
.LI
Set a password for the account (which you will have to agree upon
with the administrators of the calling node;
it will be used by the the calling process to effect the login).
If your system supports password ageing,
disable it for the account.
.LI
Set the home directory of the account to be
.mA SPOOLDIR /nodename.\*F
.FS
This is not essential,
but it can be convenient to be able to
.cS
cd ~nodename
.cE
to get to the spool directory.
.FE
.LI
If your \*(sN installation supports any accounting system to
permit/deny network access,
give the necessary network flags to this account.
If your login procedure allows control of logins over dialup lines,
and one is to be used,
be sure the account has the necessary flags.
.LI
Set the login shell of the account to be
.mA SPOOLDIR /_lib/NNshell\*F
.FS
On some systems,
where timezones are set from /etc/profile,
you might change the initial shell to be
.mA SPOOLDIR /_lib/netlogin
which would be a shell script that set the timezone (/etc/TIMEZONE perhaps)
and then executes NNshell "exec 
.mA SPOOLDIR /_lib/NNshell".
.FE
.LI
Within the link's directory in
.mA SPOOLDIR ,
create a directory called
.I q
with the same ownership and permissions as the link directory (see above).
This step is optional but generally advised (see the NNdaemon manual
explanation of \-r).
.LI
Create a
.I params
file which at this stage need only contain the line
.cS
-rq
.cE
if you are going to use the
.I q
directory created above.
.LE
.P
Getting the link going will now be largely the responsibility
of the calling site.
If problems arise,
addition of \-T1 to the
.I params
file will assist in
diagnosis (with the output appearing in the
.I log
file).
Selecting seven bit mode (\-C in the
.I params
file),
or changing the speed of the line,
will have to be done with the guidance of the calling node,
for these parameters must be changed at both ends.
.H 2 "Setting up for outgoing calls \- modem links"
Many of the requirements for initiating calls to another
site are the same as for receiving calls,
and the details of these can be found above:
a link directory within
.mA SPOOLDIR ;
a
.I q
directory within the link directory;
a
.I params
file (probably containing \-rq).
.P
In addition you need a calling program.
This program must know how to initiate calls on your modem
and how to log in at the remote site.
If you have a common modem, and the remote login procedure is
standard,
all you need do is compile the appropriate call program
from the distributed sources in the NNcall/Callers directory,
and install the binary in your
.mA SPOOLDIR /_lib
directory.\*F
.FS
See the \*(iG and the NNCall Makefile to see how to do the
compilation.
.FE
If you have an unusual situation, and cannot find a site with
similar demands,
you will have to create your own caller, probably by starting
with a common one like hayesmodem.c.
Now link the call program binary in _lib to
.I call
in the link's directory.
Create the file
.I callargs
and place in it the appropriate
arguments for the calling process,
i.e. giving
.I call
the number to telephone, the name to log in under,
the password etc.\*F
.FS
If this seems a little vague, it is because the call arguments
.I will
vary substantially with the call program (not even the flag letters
are consistent).
For the hayesmodem caller it might look like:
.cS
-d/dev/modem -s2400 -pP12345678 -llogin -Psomepasswd remote_node_name
.cE
.FE
Note that this file should probably
.I "not be readable by mortals"
since it contains the remote password and telephone number.
To test a call to node "neighbour", \f(CWcd\fP to your
.mA SPOOLDIR
and run
.cS
_lib/NNcall -T1 -hneighbour neighbour/call
.cE
.P
On intermittent links it is often necessary
to run the daemon twice to make anything much happen.
The first time allows the remote node to know you exist,
which starts it sending state information everywhere,
including to you.
Usually the daemons
have seen that there is nothing in the link queues well before that
happens,
and so they quit.
A delay of a few minutes between the first successful
call and the second one is a good idea,
thereby making sure the daemons have sufficient
time to queue their state messages,
unless the commandsfile contains explicit link information in which case
the state messages should have been queued and transferred.
In between the two calls,
the calling site can use \*(lK to see if a message was transmitted.
If so, it was your state message going out;
if not, then it should appear in the outgoing queue, and can
checked with the
.cS
\*(aQ -AVM
.cE
command.
.P
If the daemons start, indicating that the connection was made, but
die,
then something is probably wrong.
First make sure the problem is not just that the remote site is very
busy;
add a \-B\fIN\fP flag to your
.I neighbour/params
file to increase the delay before the daemon will time out.
.I N
is 11 seconds by default.
If this still does not work,
the _bad directory and log file should be checked, and core
dumps sought in the obvious places
(e.g.
.mA SPOOLDIR ,
.mA SPOOLDIR /neighbour).
If the daemons run for a reasonably long time,
then die,
check that you do not have a problem with "auto-nicing"
(see the "Preliminaries \- the \*(sN configuration" section).
.P
Once calls can be made reliably,
you should organise to make them on a regular basis,
invoked by
.I cron(1),\*F
.FS
A typical
.I crontab
entry might be
.cS
15  4,12,16,22 * * 1-5 /bin/sh \f4\s-1SPOOLDIR\s0\fP/netcall neighbour
.cE
where
.I netcall
is a shell script to invoke \f(CWNNcall\fP containing essentially:
.cS
cd \f4\s-1SPOOLDIR\s0\fP
HOST="${1:-neighbour}"
_lib/NNcall "-&" "-h$HOST" "$HOST/call"
.cE
but which could have local features such as means of correctly setting the
time zone if necessary.
.FE
at times agreed upon at both ends of the link.
.H 2 "TCP/IP links"
This protocol essentially involves a call operation.
For an Ethernet and 4.3BSD,
ENcall and ENshell programs exist to establish these links.
If you are setting up a new Ethernet, you will almost certainly need
advice from a site that has a similar operating system and
a working system.\*F
.FS
cad.eecs.unsw.oz and physiol.physiol.su.oz have 4.3BSD Ethernet
systems in use.
.FE
If you are just adding a node,
seek advice from elsewhere on the TCP net.
.H 2 "X.25 links"
Another call type link.
Seek help from the other end.\*F
.FS
All these links have unique features that makes generalisation impossible.
.FE
.H 2 "Tests of commands once the daemons are running"
There are some obvious tests to ensure everything is working.
Once the daemons have made contact, they should immediately
exchange network state information.  This means the bare bones
statefile created from the information in your commandsfile
should be expanded.  That this is so can be tested with
.cS
\*(aS \-V
.cE
which should now give more information.  There will probably be many
more nodes unless your primary domain is very restricted.  At
the very least there should be more information on the
node to which the daemon is communicating, e.g. its comment.
.P
A simple test message is a good idea:
.cS
\*(sF \-A root@neighbour < /dev/null
.cE
This zero-length file should be transmitted and acknowledged (because
of the \-A flag) very quickly.
.P
You can test that you can send a file to yourself, routed
.I via
you
neighbour:
.cS
\*(sF my_login@neighbour!our_node < /dev/null \*F
.cE
.FS
The syntax destination_1\fB!\fPdestination_2 is called \fIexplicit routing\fP.
The message will first be routed to destination_1,
and when it arrives there will be routed to destination_2.
These destinations need not be directly linked.
N.B. If your shell is the csh or any other that treats the '\fB!\fP'
character specially, you will have to escape it.
.FE
Once again this message should be transmitted and returned quite quickly.
.P
You should also test that a message sent to a non-existent user at
your node results in mail to you advising of the failure to deliver,
and to the
.mA FUZZ ,
if you have
.mA LOG_RETURNED =1
in your configuration
.cS
\*(sF bogus_login@neighbour!our_node < /dev/null
.cE
The undeliverable message should be saved
in the _bad
directory within the \*(sN spool directory.
The mail to the
.mA FUZZ ,
if it exists, should refer to this file.
Check that the _bad file has been created; then you can remove it.
.H 2 "Making yourself known"
Once you are satisfied that your configuration is sound,
you should arrange for your site information to be entered in the
"Network Map" which is distributed by the network news system both
over \*(sN and overseas.
To acquire information about how to do this:
.cS
\*(fF -d\*(mN README acsmap_form
.cE
which should result in the delivery to you of the two named files.
If this does not happen within a reasonable period,
there is a potential that something is wrong with your \*(sN
configuration.
You should send mail to
.I \*(aM@\*(mN
describing what has happened.
The map moderator will try to help ensure your configuration is sound
and that messages can be routed to you.
.H 1 "REMOTE LOGINS WITH \*(sN"
The \*(cN utility distributed with \*(sN
allows you to logically connect your terminal to
any serial device your hardware and operating system supports.
Usually the serial device is a dedicated link to another machine with a
.I getty
running on the remote end.\*F
.FS
If your system remote login procedures such as
.I telnet ,
\*(cN may seem somewhat superfluous.
However if you have a number of machines not all of which support
.I telnet,
\*(cN may assist you in connecting to such machines.
Furthermore,
\*(cN can provide a redundant connection mechanism between machines linked
by other means to cope with hardware or software failures.
.FE
\*(sN supports routing to remote machines through a series of
\*(cN processes,
although it is mandatory that the
.I getty
at each node can fork
\*(cN to connect to the next link in the chain of \*(cN processes.\*F
.FS
This system is used extensively at the University of Sydney and University
of New South Wales on a variety of \*(uX versions.
.FE
.P
To support \*(cN to a directly connected node "neighbour" over a serial
connection,
there must be a device special file
.I /dev/net/neighbour\o'0/' .
(Note that the '\o'0/'' is obligatory and that the file is very different
to
.I /dev/net/neighbour
(see "Permanent links over dedicated connections").
Generally the file is a link to the conventional
.I tty
device special file in use for the serial connection.\*F
.FS
In the case of multiplexed links,
it would be a link to the device special file for the appropriate channel 
on the multiplexed port.
.FE
If more than one \*(cN channel is provided,
additional sequential device special files must be created,
e.g.
.I /dev/net/neighbour1 etc.,
.H 2 "\*(cN in a local network"
If a number of machines are linked with \*(cN support,
\*(sN will route
\*(cN requests according to state information,
provided the commandsfile contains appropriate information,
e.g. if your machine is linked to node "neighbour" and supports
both NNdaemons and connections,
your commandsfile "link" or "flag" line would look like:
.cS
link	our_node,neighbour	msg,con
.cE
If \*(cN is used extensively,
all available connections can be busy when a user tries use \*(cN.
If there is an alternative route to the target,
\*(sN
.I "will not"
use it if the lines are busy.
There is a trick to exploit such alternative routes.
Consider the following simple network:
.PS
circlerad = 0.35
O: circle "our_node"
move right 1.3
H: circle "hub"
line from O.c to H.c chop
move to center of last line then up 0.8
N: circle "neighbour"
line from O.c to N.c chop
line from N.c to H.c chop
.PE
Suppose you have two
\*(cN channels between each pair of machines.
The first two users of \*(cN from "our_node" to "neighbour" will use
.I /dev/net/neighbour\o'0/'
and
.I /dev/net/neighbour1
respectively.
A third user's attempt to \*(cN to "neighbour" will fail and
\*(sN will
.I not
exploit the available route to "neighbour"
.I via
"hub".
However if you create a link between the device special file
.I /dev/net/hub\o'0/'
and
.I /dev/net/neighbour2 ,
the third \*(cN attempt will actually go to "hub" which will in turn
connect to "neighbour".\*F
.FS
Assuming the
.I getty
running on "hub" knows how to fork \*(cN.
If you have the sources to
the login process adding support for this is quite easy.
.FE
.H 2 "\*(cN as a general testing utility"
To use \*(cN to connect to any serial line,
e.g. a modem,
simply create a link to the appropriate device special file in
/dev/net, e.g.
.cS
ln /dev/modem /dev/net/modem\o'0/'
\*(cN modem
.cE
If the hardware requires that carrier be asserted before the device can
be opened,
\*(cN will not work without it.
.H 1 MAINTENANCE
.P
Most \*(sN maintenance can be automated.
The following recommendations are not essential if your administrators
are willing to do things by hand,
but are
.I "highly recommended"
to make your installation as trouble free as possible in the long term.
.BL
.LI
\*(pU should be run regularly \- every night at most sites, more
often at busy sites \- to remove out-of-date state messages\*F.
.FS
See the \*(pU manual for more details.
.FE
This may mean adding an entry to the
.I cron(1)
table,
or adding it to a script run for related purposes (e.g. /usr/adm/daily
on BSD systems).
The output generated by the \-W flag will alert you to potential
faults,
so redirecting the output of \*(pU to mail to the system administrator
is worth considering.
.LI
remove (or otherwise deal with) old files in the _files directory.
When users are advised of the availability of files for collection
with \*(gF, they are told they should collect or delete them within
.mA FILESEXPIREDAYS
or they will be deleted.
This deletion will not occur unless you arrange to do it.
If you want to be rigourous about this,
simply remove, on a daily basis, any file in the _files directory
older than
.mA FILESEXPIREDAYS
relative to the current date.
This can be done using
.I find(1)
or
.cS
\*(gF -Ao\fIN\fP -delete
.cE
where
.I N
is
.mA FILESEXPIREDAYS ,
or perhaps some slightly larger number to give a period of grace.
.P
On the other hand, if you have users who log in rather infrequently,
and/or you wish not to delete potentially valuable files,
you may choose to generate further messages once a certain period
has passed, and perhaps to later alert the system administrator.\*F
.FS
The shellscript oldfilewarn.sh performs this task.
.FE
.LI
Truncate the log files in each link directory.
The strategy needed varies greatly with the nature of the link.
The log file for a dedicated and reliable link will not grow
at a great rate, and might need to be truncated only rarely.\*F
.FS
For example only when the system is rebooted.  The system startup
file (/etc/rc or the like) might contain, for a link called
.I neighbour :
.cS
cd /usr/spool/ACSnet/neighbour
cp log OLDlog
> log
.cE
.FE
A log file for an intermittent link with frequent calls and/or
a link with frequent faults can cause the log file to grow rapidly,
its truncation might need to be done on a daily basis.
.LI
Discard old state files in the _state directory.
Any files here older than a few months are of doubtful value.
They should be removed, perhaps weekly, using find.\*F
.FS
The script purge.sh does the double duty of running the \*(pU
command and discarding old state files.
.FE
.LI
Examine then discard state error messages in _state.\*F
.FS
The shellscript staterep.sh will do this for you.
.FE
These files
have the same names as the state files to which they apply,
but with a ',' prepended to the name.
The contents may give important information about state
inconsistencies,
especially those between incoming state messages and the contents of
your statefile.
Even if you choose to ignore these messages, you should truncate
the files which can otherwise grow indefinitely.
.LE
.H 1 "PROBLEMS WITH THE MAIL INTERFACE"
As many of the problems to do with \*(sN relate to its use
with electronic mail,
considerable attention to certain problems is given below.
It is important to appreciate that the Mail Interface is complex,
and really consists of several parts:
.AL 1
.LI
messages pass from your user mail program(s) to \*(sN by invoking \*(sF
.LI
\*(sN messages destined for your mail system are passed to
.mA MAILER
with arguments selected by
.mA MAILERARGS
.LI
mail generated by \*(sN (e.g. notification of files available for collection)
is passed to
.mA BINMAIL
with arguments selected by
.mA BINMAILARGS .
.LE
.P
It is therefore possible to have failures in three independent places.
The first phase is undoubtedly the most complex.  The user mail program
(possibly /bin/mail,
but more likely something better)
generally utilises a second program to
deliver the mail (e.g. smail or sendmail) which in turn must invoke
\*(sF.\*F
.FS
Actually sendmail is even worse, as there must be an intermediate
program between sendmail and \*(sF to do some argument handling and
run with system privileges.
.FE
The next test enables testing both the first and second aspects.
.H 2 "Testing \*(sN network mail locally"
You can usually test your \*(sN mail interface by just sending mail to
.I my_login@our_node ,
since the presence of the '@' will usually cause the mail program to
pass the mail to \*(sN.  Some mail programs examine the destination
after the '@' in an attempt to try to recognise mail that is really
destined for your site,
in which case you may have to use some variant on the normal
address to defeat the mail program's ability to bypass
\*(sN.
Using
.I my_login@our_destination
where
.I our_destination
is a fully qualified address consisting of
.I our_node.domains \*F
.FS
E.g. for node basser this would be basser.cs.su.oz.
.FE
will usually work,
but if your mail program recognises this too as a local address,
.I my_login@our_node@our_node
might trick it.
A certain way to test \*(sN is to establish a \*(sN alias
for your node name (that your mail program does not know about),
then mail to
.I my_login@node_alias .
.P
If network mail appears to be working from this test,
and \*(sN informative mail was correctly generated in the \*(sF
tests in Section 2,
you need not proceed further with
the "Mail Interface" section.  If problems are evident, some of the subsections
below may help with specific problems.
.H 2 "No mail from \*(sN"
If any of the preliminary tests show that mail is not being delivered,
error diagnostics should tell you what is happening.
If there are no diagnostics, it could be because
.mA IGNMAILERSTATUS
was set to
1 at compile time.
You might want to reverse this to aid in tracking down the
fault.
If you did not compile \*(sN with the
.mA DEBUG
option set,
you might want to recompile with it set so that tracing can
be used.
Then consult the following sections designed to isolate faults
in the various parts of the Mail Interface described above.
.H 2 "No informative mail from \*(sN"
The command:
.cS
\*(sF -T4 my_login < /dev/null
.cE
should display the mail command which is called,
provided the DEBUG feature was enable for the \*(sN compilation.
This may help
detect the fault.
It is worth checking the last access time of the program
you selected with
.mA BINMAIL
to ensure it is being invoked.
You can check the home directory of the account set by
.mA ACSNETNAME
in the compilation for dead.letters which may also help sort things
out.  It is also worth searching the relevant directories for core
dumps, e.g. the _lib directory,  the
.mA ACSNETNAME
and the home directory (for possible core dumps from
.mA BINMAIL ).
Examination
of any core file found (strings(1) will tell you what process caused it)
with debugging tools may be required.
The most common cause is incorrect
.mA BINMAILARGS
set at compile time.
.P
The script
.I debug.sh \*F
.FS
In common with the other useful little shell scripts mentioned in this
document,
this will be found in the sources Admin directory.
.FE
can assist, especially if you have not enabled tracing
with
.mA DEBUG .
If you temporarily replace the program specified by
.mA BINMAIL
with
.I debug.sh
(set to be executable and readable)
you can ensure it is being invoked and examine the
arguments.\*F
.FS
Presumably you would not want to do this without the system
being restricted to system administrators!
.FE
Furthermore,
after restoring
.mA BINMAIL,
the output file can in turn be executed,
after adjusting arguments if needed (e.g. adding debug flags).
Once you have determined the problem,
you must correct
.mA BINMAILARGS
or alter
the program selected by
.mA BINMAIL
to make it work.
.H 2 "No network mail from \*(sN - testing the \*(sN to \f4MAILER\fP interface"
To simulate what \*(sN does when a message destined to be delivered as
mail arrives, simply execute the command:
.cS
echo "Test mail" | \*(sF \-amailer my_login
.cE
If this fails, and if diagnostic output does
not make it clear why it failed,
addition of the \-T4 flag to the \*(sF command will
cause the ultimate command executed to be displayed, together with its
arguments, i.e.
.mA MAILER
executed with
.mA MAILERARGS .
Check these carefully to ensure they are what you
wanted.
Then either correct
.mA MAILERARGS
or determine why
.mA MAILER
is not working.
The use of the
.I debug.sh
script mentioned above may again be of assistance.
.H 2 "No user generated mail reaching \*(sN"
This is undoubtedly the most difficult of the mail problems because,
as mentioned at the head of this main section,
the process of a user sending mail
.I via
\*(sN involves a chain of programs starting with the primary
mail user interface and ending with \*(sF.  Any problem
here is not a problem with \*(sN, but with the way it is invoked.
\*(sF
.I must
be invoked, and
.I "it must be invoked with sensible arguments".
.H 3 "Testing how \*(sF is invoked"
Examination of the last access time of the \*(sF binary following a
mail test such as described in "Testing \*(sN network mail locally"
will determine if \*(sF is being used.
If it is but is failing,
replace the \*(sF binary
with
.I debug.sh
and determine what arguments it is being called with.
Ascertain what is wrong with the arguments, either by
inspection or by running the \*(sF command as recorded by
.I debug.sh
and make the necessary corrections to the
process calling \*(sF.\*F
.FS
It is difficult to give advice here as there are many different
user mail systems.
If your system mail programs are not able to be configured to
use an arbitrary network, you may have to replace them with
ones that will.  The so-called "Rourke mail" is essentially
public domain (not for redistribution for profit) and will
do the job.
.P
If you use sendmail, it is essential to edit the sendmail.cf
file to correctly interface to \*(sN.  The best starting point
is the file
.I sendm.cf.shand
distributed in the Admin directory with the sources.
If you use this file you will need to edit it slightly, and the
comments say almost everything.  You should end up with two lines
.cS
DJour_node
DDour_hierarchy
.cE
Note that this file requires that _lib/netmail in the \*(sN
directory be installed.  The source is distributed in Admin/netmail.c.
.FE
.ig XX
On most sendmail sites, none of the methods of fooling sendmail into
dumping the mail onto sendfile to handle will work (the alias will
perhaps, but that then relies on SunIII stripping the alias from the
address before it hands the mail back to MAILER, which it does, but
which I think is not guaranteed anywhere).  That is, strictly, the
mailer should ALWAYS recognise all possible methods of sending mail
to itself, and never call sendfile with any of it, to avoid possibly
creating loops.
.XX
.H 2 "Duplication of source in \`From \' line (From user@source@source) in  your mail arriving at remote sites"
This error, in the so called "\*(uX\*F From_ line",
.FS
\*(uX is a trademark of AT&T Bell Laboratories.
.FE
usually relates to the
\-s\fIsender\fP argument passed to \*(sF.
The \fIsender\fP should normally be just the sender's login-name,
but \*(sF will accept a string including "@source" (useful feature for
gateway sites).  The problem is that when \*(sN generates an address for
the sender, e.g. when the mail is delivered,
it concatenates "sender" "@" and "source",
so if your mail program passed the "@source" to \*(sF
.I via
the \-s flag,
duplication of this part will result.
.P
Another possible source of the problem is any filter between the mail
program and \*(sF.
As an example,
on some BSD systems a program known as ACSmail or netmail is called by
sendmail; this program in turn calls \*(sF.  It runs setuid root
so that \*(sF can be called with the \-amailer flag.  Since
this filter sets up the \*(sF arguments,
it can be the source of the problem.
.P
If someone at another site tells you they see this duplication in
the \*(uX From_ line in mail from your site,
but you cannot replicate the fault locally,
it may be because different methods of generating the \*(uX From_ line
are being used.  If the remote site confirms they only see the fault
in mail from your site,  there is a possibility your mail delivery
program is generating the From_ line correctly,
despite the fault in your outgoing mail.
If you have not set
.mA MAIL_FROM =1
in compiling \*(sN,
whereas the remote site has done so,
this discrepancy is to be expected.\*F
.FS
You could set
.mA MAIL_FROM =1
to assist in finding the fault,
but this will require a potentially long recompilation and is probably
a last resort.
.FE
.P
The means of correcting this fault is dependent upon the mail program(s)
you are using,  and to some extent on the version of \*(sN you have.
If a new installation, simply substitute \-r for \-s wherever \*(sF
is being called.
If your \*(sF does not support \-r,
you must check that whatever arrangements you made to pass the
\-s flag to \*(sF do not include passing "@source".\*F
.FS
For \fIsendmail\fP this would usually mean "\-s$f" as part of the
rule for \*(sN mail.
.FE
.H 2 "Incorrect or Incomplete Address in \`From: \' line"
.P
The "From: " line (along with To:, Cc:, Date: etc.) is the
responsibility of your mail program(s), not \*(sN.
It is important that your "From: " line be correct,
for all correct mail programs used by recipients of your mail will use
it to generate return addresses, especially on non-\*(uX
systems.
Testing the generation of the "From: " line may require the same means of
ensuring your mailer treats the addressee as a network address as mentioned
above for the \*(uX From_ line.  Once again your mail program may
only produce a full
.I user@source\*F
.FS
Where
.I source
includes the full domain hierarchy, not just the node name.
.FE
"From: " line if the addressee appears to be at a remote site.
You may also have to use a special command to your mail reading
program to see the "From: " line, as many of the message headers
are suppressed by some readers.  If in doubt, examine the mailbox file
itself.
.P
Incomplete "From: " lines seem to arise most commonly from sites
using
.I sendmail .
In this case definition of the "From: " line in sendmail.cf should be
examined.\*F
.FS
One common configuration includes:
.cS
# format of a total name
Dq$g$?x ($x)$.
.cE
where the use of \f(CW$g\fP is critical,
then
.cS
# format of header lines
H?F?From: $q
.cE
.FE
For systems with mailers making use of the \*(uX
.I uname
system call, it should be noted that
.I uname
does not return domain information and this may have to be added in
other ways, possibly even when compiling the mail program(s).
.P
It is also worth remembering that some mailers obtain the node name from a
configuration file,
or have it compiled in.
In such cases, changing the node name will require reconfiguring
or recompiling the mailer. Failure to do so will result in incorrect
"From: " lines.
Similarly, such binary and configuration files cannot be simply copied from
one site to another.
.H 1 "PROBLEMS WITH SMALL ADDRESS SPACE MACHINES"
.I
If your machine is 32-bit,
you can probably skip this section unless your machine has a very limited amount
of physical memory, or its memory management system is deficient.\*F
.FS
I am told that some PC/AT machines fall into this category.
.FE
.R
.P
Small address space machines (like the DEC PDP11 family) present
certain problems and restrictions on the use of \*(sN.
These are most acute on machines without separate I&D spaces.
Other machines should exploit the \-i flag during compilation.
.H 2 "The Statefile"
It is quite possible for the statefile\*F
.FS
This is a data file in the \*(sN lib directory typically named
/usr/spool/ACSnet/_lib/statefile.
.FE
to grow too large for
\*(aS to be able to hold all the data in core.
If this happens,
the \*(aS command will become useless,
and the network will probably stop, i.e. the daemon(s)
will adopt an error status\*F
.FS
The most obvious symptom is the output of the \*(lK command.  If the \-V
flag is not used, the first character after the nodename will be an 'E'.
With the \-V flag, the output will include "waiting for error to be fixed".
.FE
and operator intervention will be required.
Sometimes \*(aS will still work, but the receiver will not, again
because too much core is consumed.
Whenever the daemon error condition is encountered, the best first step
is to kill the daemon(s), and examine the log file(s)\*F
.FS
The log file will be found in the directory within the \*(sN spool
directory having the name of the link as the directory name.
Usually only the last 10 to 20 lines of the file need be examined.
.FE
for error
diagnostics.  Messages concerning "not enough core" point to the possibility
that the statefile is too large.
If the \*(aS command reports this, the conclusion is confirmed.
.P
There are two issues here: prevention and cure.
.H 3 "Preventing the statefile from getting too large"
.P
There are a number of rules that need to be followed:
.BL
.LI
Only make your node's primary domain as large as it must be.
.LI
Only allow your node's domain membership list to contain the primary
domain as its largest domain.
It is essentially impossible for a small address machine to be a member
of a large domain such as "oz".
.LI
Use the \*(rQ command as little as possible.
.LI
Never \*(rQ from a node in a larger domain using the \-A flag.
.LI
Judiciously add "remove node" lines to your commandsfile for nodes which
creep into you statefile, but which you are prepared not to know about.
.LI
If your \*(sN release\*F
.FS
The \*(sN release can be determined with the command
.cS
\*(aS -O | tail -1
.cE
.FE
is <\ 1.500\*F,
.FS
Which it should not be if you are performing a new installation.
.FE
keep your statefile as free as possible of routing information to
foreign domains, especially bogus foreign domains.  This is a
genuine problem due to a bug in the \*(sN software for releases < 1.500.
For such earlier releases,
the prevention is to run a script regularly that removes these domains\*F.
.FS
The presence of these domains is indicated by the output of \*(aS
with the \-V flag showing large numbers of domains after the node name
within the domain field (i.e. enclosed by brackets) each of which
is enclosed by parentheses.  Except for a few genuine domains
(e.g. nz, usa, th) these are likely to be nonsensical and troublesome.
The script which corrects this problem was distributed in earlier
releases with the sources
in the Admin directory and is named remdoms.sh.
.FE
.LE
.H 3 "Recovering from the statefile getting too large"
.P
Once state will not run, there is no simple mechanism for paring down
the statefile.  It will almost certainly have to be truncated.
Unless your node is a major through route\*F,
.FS
Not very likely with a small address space machine!
.FE
this is not as serious as it sounds.  The state information can
be imported from your network links as soon as the network starts.
You should not try to truncate the statefile with the network active.
So start by stopping the daemons,\*F
.FS
The statefile is subject to some form of locking protocol dependent upon
the system kernel you are using.
It may not be possible to truncate the statefile unless all processes using
it are stopped.
.FE
then perform the
following commands\*F:
.FS
You may have to substitute the appropriate directory name for the
cd command if you have a "non-standard" installation.
.FE
.cS
cd /usr/spool/ACSnet/_lib
> statefile
\*(aS \-RSWc
\*(aS \-V
.cE
The first \*(aS command recreates the basic state information for your
node from the statefile.  The second allows you to confirm this has worked.
You should then restart the daemon(s) and issue a \*(rQ for each of
your links, i.e.
.cS
\&./\*(rQ neighbour
.cE
.P
If this problem is a recurrent one, and if the temporary truncation of
the statefile is a problem,  you could make provision to periodically make
a backup copy with the aid of cron(1).
.H 2 "Too many files"
It is possible for a link directory to end up with more files than
various \*(sN processes can handle
because of memory limitations.
This can happen if a link is down and large numbers of files accumulate for it,
or if some process spools large numbers of files for the link at a rate
faster than it can handle.\*F
.FS
Such processes can be restricted to an acceptable rate by making them
wait for a "queue empty" status from \*(aQ periodically.
.FE
If this happens,  the log file will probably make it clear, as
will a simple "ls" command, as it may also run out of core.
This is a difficult problem to deal with, since some of the ordinary tools
fail.
Start by making \*(pU unavailable (e.g. by renaming it), so that if
it happens to run while you are doing what is suggested below, files
are not lost.
Rename the link directory and create a new replacement (empty) directory,
with the correct ownership/permissions.
Kill and restart the daemon, which will have been in an error state.
Progressively move files from the renamed directory into the new one.
You may have to use
.I find(1)
or
.I ncheck(8)
to obtain the file names in extreme cases.
These files should start to be transmitted.
Preferably move the files in
temporal sequence, oldest first.  After moving a group of files, wait until
the \*(aQ command shows the queue empty before moving more.
Eventually you should be able to clear the renamed directory which can
then be discarded.  Finally, restore \*(pU.
.H 1 "RUNNING OUT OF DISC SPACE"
.P
\*(sN is resilient to its file system becoming full.
Incoming file transfers will be blocked, but the daemon(s) will
continue to run,
and if space becomes available,
normal operations will resume.
An unfortunate side-effect of this behaviour is that file transmission
can silently stop, i.e. no error messages are issued by \*(sN
and the daemon(s) will not be in an error condition.
The kernel will probably issue "disc full" messages,
but these may not be apparent if they are written to an error log file
somewhere.
.P
Even though the daemon(s) will continue to operate with the disc full,
under some circumstances it may be necessary to
stop it/them, sometimes selectively if there is more than one.
These circumstances will become apparent in considering the causes of
depletion of disc resources.
.H 2 "Reasons for disc consumption"
.AL 1
.LI
Receipt of many or large files for your node where the rate of receipt
is not matched by the rate of collection.
.LI
Receipt of files on one link destined for another link which is not
functioning, or transmitting slower than the rate of receipt.
.LI
Buildup of numerous files in the _bad directory.
.LI
Buildup of state messages for inactive links not cleared by
\*(pU.
.LI
Buildup of statistics files in _stats
.LI
Growth of log files in the link directories
.LI
Accumulation of old state messages in the _state directory
.LI
Accumulation/growth of state error messages in the _state directory.\*F
.FS
See the Maintenance section for more details.
.FE
.LE
.P
Of course factors not related to \*(sN can consume disc space if
the disc is used by other processes.\*F
.FS
It is desirable that \*(sN have its own disc partition so that
it does not compete with other processes for disc space, and
will not block other processes if the available space is consumed.
.FE
.H 2 "What to do with a full file system"
The first thing to do is try to establish why the disc has filled.
The \*(lK command will show you if any link is in an error state or not
running when it should be,
that could cause a backlog of messages for transmission.
The command \f(CWdu\fP
.mA SPOOLDIR
will show how the space has been consumed.
If the _files directory is the problem,
it probably means a large volume of files are spooled for collection.
.cS
\*(gF \-LA
.cE
will confirm if this is true as well as give details on the files.
If a link directory,
or
.I _work
is involved,
.cS
\*(aQ \-A
.cE
will provide details.
If none of these commands disclose the problem, use
\f(CWls \-la\fP on the appropriate directory.
If there is no apparent reason, do not fail to consider the possibility that
the file system has been corrupted.
.P
If a large amount of disc space is consumed with spooled files,
it may be simply a matter
of deleting some or collecting them
(perhaps on behalf of a user,
if the recipient is not available to do it) (see below).
If things have backed up for a link which has failed, it may simply be a matter
of getting that link up again.
If space has to be made,
refer to the next section.
.H 2 "Freeing disc space"
A simple start is to change directory to the \*(sN spool
directory and
.cS
_lib/\*(pU
rm */core\*F _lib/OLD* _state/,*
.cE
.FS
One way of preventing daemon core dumps being left in the link directories
is to create 0 size root ownership core files in each such directory.
.FE
In fact any files in _state are expendable.
.P
Examine _bad.  If there are files here, they are a result of some failure of
\*(sN to deliver messages - e.g. messages to non-existent users,
messages that have been looping around a route, messages saved because some
process forked by \*(sN failed, e.g. news.
The script badmv.sh distributed in the \*(sN sources Admin directory can be
used to deal with such files.
.P
Files in _stats are probably expendable unless you really are collecting
statistics for some purpose.   If the file Accumulated is there it could be
very large.  Copying it to another file system and truncating it is the
answer if you need it.  Otherwise truncate it.
Remove the file
.mA SPOOLDIR /_lib/statsfile
to disable statistics.
.P
The log files in each link directory will grow indefinitely unless
truncated.
.cS
tail \-100 neighbour/log > /tmp/log
cp /tmp/log neighbour/log
rm /tmp/log
.cE
If \*(gF \-LA showed a large volume of files awaiting collection,
you could collect or delete some of these on behalf of ordinary
users.  For example, suppose user "blogs" has a lot of files awaiting
collection but is away.
.cS
cd ~blogs
mkdir GotFiles
chown blogs GotFiles
cd GotFiles
\*(gF \-ublogs
.cE
Answering 'y' to each \*(gF query will collect the files,
which will be owned by blogs.\*F
.FS
If files include full paths or subdirectories, the use of the 'b'
reply may be necessary.
.FE
Files spooled for ordinary users can be deleted in the same way!
.H 1 "ROUTING PROBLEMS"
.H 2 "Hierarchical vs. non-hierarchical domains"
\*(sN supports the concept of non-hierarchical domains.
These are domains which are in the commandsfile "domain our_node"
list, but which are not in your hierarchy.
The idea is that you might claim to be a member of domain "ozturing"
if you happened to have an OzTuring computer.  If all sites using
these machines did this, the address
.I postmaster@*.ozturing
would address to all such sites.
However if OzTuring Pty. Ltd. subsequently
decides to use ozturing as its primary
hierarchical domain, things can go very wrong, e.g. your machine may
receive messages for OzTuring's nodes, which will almost certainly
end up in _bad.
.P
A more serious problem from your point of view,
will arise if you put an established non-hierarchical
domain into your hierarchy.  In this case messages to your site are quite
likely to end up at nodes that are members of the non-hierarchical
domain.
.P
There are two messages here:
.BL
.LI
Choose your domain membership carefully, with advice from experts
at other sites.
.LI
Do not add non-hierarchical domains to your domain list.\*F
.FS
These will not be supported in the future.
.FE
.LE
.H 2 "Meddling with the commandsfile"
There may occasionally be a real need to put specific commands into
the commandsfile aimed at determining the routing of messages.
There can be dire consequences of many such commands if they
conflict with the real state of affairs.
(The \*(sN state information
is designed to be dynamic,
and based on fact, not what someone would like.)
Routing loops can often result.
In general, any such commands should only be applied after consultation.
Attempts to cause certain routes to be favoured should probably be
limited to the use of a "cost" on the less preferable one.
The use of "break" or flagging of links permanently up or down
should be avoided.\*F
.FS
It is important to appreciate that you can cause serious problems at
other sites by ill-considered changes to your commandsfile.
If you have a routing problem that you feel needs actions of this
type,
post a news article to the aus.mail and/or aus.acsnet newsgroup
seeking advice.
The chances are that your problem will have been seen by someone before,
and the solution may be in place (and tested) elsewhere.
.FE
.P
If you are convinced that any routing parameter needs to be altered
for a link,
it is essential that this parameter is altered at the other end of the link
as well.
Unilateral changes are a formula for chaos.
.H 2 Re-routing
If your node has more than one link,
there can be occasions when files that are spooled for one link which is
down for an extended period,
may be deliverable if sent out on another link.
This is quite easy to do.
As described in the section on
"Simple tests of the mail interface"
the spooling of a file involves writing a control file in the
link's directory in
.mA SPOOLDIR .
These files start with a number and are followed by irregular strings
of characters.
Re-routing requires only that these files be moved into the directory of
the desired out-going link.
Re-routing state messages is of little value,
so you might first \*(pU then "\*(sT -A dead_link" and stop any
remaining state messages.
Then
.cS
cd \f4\s-1SPOOLDIR\s0\fP/dead_link
mv [0-2]* ../alternate_link
.cE
.TC
.CS
