#!/bin/sh
#
#	Print out all hosts, one per line
#

acsstate -VZ $* | awk	'
		BEGIN				{
				hier = ""
				node = ""
				comment = "\"\""
				route = ""
			}
		/^ACSnet map/			{
				next
			}
		/^Local domain hierarchy/	{
				next
			}
		/^ -> /				{
				next
			}
		/^ !/				{
				route = $0
			}
		/^[^ ]+/			{
				if ( node != "" ) {
					printf "%s", node
					if ( hier != "" ) printf "%s", hier
					len = length(node hier)
					while ( len < 35 ) { printf " "; len++ }
					printf "%s%s\n", comment, route
				}
				comment = "\"\""
				route = ""
				node = $1
				hier = $2
				if ( hier ~ /^{/ ) {
					hier = "." substr(hier, 2, length(hier)-2)
				} else
					hier = ""
				next
			}
		/^ +["]/			{
				comment = ""
				for ( i = 1 ; i <= NF ; i++ )
					comment = comment $i " "
			}
		END				{
				if ( node != "" ) {
					printf "%s", node
					if ( hier != "" ) printf "%s", hier
					len = length(node hier)
					while ( len < 35 ) { printf " "; len++ }
					printf "%s%s\n", comment, route
				}
			}'
