#!/bin/sh
#
#	build_whois - Shell script to build "whois" database used by acswhois
#
#		Lawrie Brown	lpb@csadfa.oz	1/4/87
#
#	Improvements on a simple "cut" script are:
#		1) Expansion of group number into appropriate name
#		2) Inclusion of each users ".project" file (used by finger(1)),
#			which lets the user taylor his entry a little
#
#	This script should be run periodically (weekly?) by cron(8)
#
WHOIS="${WHOIS:-/usr/pub/whois}"
PATH="/bin:/usr/bin:/usr/ucb"
export PATH

#	Build a shell script with fixed info from /etc/group & /etc/passed,
#		plus a command to read each users .project file
cat /etc/group /etc/passwd | \
awk '	BEGIN {			# Set field separator & 1st line of shell script
		FS = ":" 
		printf("#!/bin/sh\n")
	}
	NF == 3 || NF == 4 {	# Parse /etc/group to build table of group num/name
		grpname[$3] = $1
	}
	NF > 4 {		# Parse /etc/passwd to build shell script
		if ( $3 < 100)	# Ignore system special accounts
			break
		uid = $1			# Grab fixed info
		group = grpname[$4]
		name = $5
		project = $6 "/.project"	# Build name of .project file
		printf("echo \"%s: %s: %s: \" `sed 1q %s`\n", name, uid, group, project)
	} ' > /tmp/whois.sh.$$
#
#	Now build the database from the passwd info & each user .project file
#
sh /tmp/whois.sh.$$ 2>/dev/null | \
	sort > $WHOIS
rm /tmp/whois.sh.$$
exit 0
