#!/bin/sh
#
#	Generate a statefile for a foreign node and broadcast it.
#	The message generated this way will have to be incorporated
#	by hand at each site in the domain "prim_dom" using
#	the shell script "add_state".
#

if [ $# != 5 ]
then
	echo "Usage: $0 node_name hierarchy domain_list linked_to \"comment\""
	exit 1
fi

node=$1
hier=$2
domains=$3
home=$4
comment="$5"
prim_dom=`expr $domains : '\([^,]*\)'`

cd /usr/spool/ACSnet/_lib &&
mv handlers OLDhandlers && (
echo "acsstate -CNOh$node | sendfile -DNRastater -o$node -d*.$prim_dom"
acsstate -CRS <<!
add	$node		local,foreign
domain	$node		$domains
link	$home,$node	msg
hierarchy $node		$hier
comment	$node		$comment
!
acsstate -CNOh$node <<! | sendfile -DNRastater -o$node -d*.$prim_dom 2>/dev/null
xalias
!
)
mv OLDhandlers handlers
