#
#	comp_sites.sh	- compile a list of sites
#
#	Take the uucp map style files for ACSnet and produce a sites file
#	containing the following - 
#
#	site name, contact, contact ACSnet address, organisation,
#	organisation's address and telephone number
#

: ${ACCTS_DIR=/usr/spool/ACSnet/_accts}
: ${MAP_DIR=${ACCTS_DIR}/acs_maps}
: ${SITE_FILE=${ACCTS_DIR}/acs_sites}

tmpf=/tmp/acs$$

trap "rm -f ${tmpf}; exit 1;" 0 1 2 13 15

cd ${MAP_DIR}
for files in aus.*
do
	echo "compiling ${files} ..."
	cat ${files} | awk '
/^#N/	{ N = $2 }
/^#C/	{ C = $2; for (x=3; x<=NF; x++) C = C " " $x}
/^#E/	{ E = $2; for (x=3; x<=NF; x++) E = E " " $x}
/^#O/	{ O = $2; for (x=3; x<=NF; x++) O = O " " $x}
/^#P/	{ P = $2; for (x=3; x<=NF; x++) P = P " " $x}
/^#T/	{ T = $2; for (x=3; x<=NF; x++) T = T " " $x}
/^$/	{ printf "%s:%s:%s:%s:%s:%s\n", N, C, E, O, P, T }
END {
	printf "%s:%s:%s:%s:%s:%s\n", N, C, E, O, P, T
}
' >> ${tmpf}
done

#
#	Now sort the site file and take out any duplicated entries
#

echo "sorting ..."
sort ${tmpf} | uniq > ${SITE_FILE}
chown daemon ${SITE_FILE}
chgrp daemon ${SITE_FILE}
chmod 644 ${SITE_FILE}

#
#	Clean up
#

rm ${tmpf}
