/*
 *	This is the op-code table.  It contains the translation from
 *	external form to internal form for each instruction.  Since hashing
 *	is based on the first 2 chars, codes are arranged to compensate.
 */
struct optab optab[] {
	"bra",	BRA,
	"bcc",	CBR | BCC<<8,
	"bcs",	CBR | BCS<<8,
	"beq",	CBR | BEQ<<8,
	"bge",	CBR | BGE<<8,
	"bgt",	CBR | BGT<<8,
	"bhi",	CBR | BHI<<8,
	"ble",	CBR | BLE<<8,
	"bls",	CBR | BLS<<8,
	"blt",	CBR | BLT<<8,
	"bmi",	CBR | BMI<<8,
	"bne",	CBR | BNE<<8,
	"bpl",	CBR | BPL<<8,
	"bvc",	CBR | BVC<<8,
	"bvs",	CBR | BVS<<8,
	"jmp",	JMP,
	"*Routine", EROU,
	"*Text", TEXT,
	"*Data", DATA,
	"*Bss", BSS,
	"ab",	ABA,
	"adc",	ADC,
	"add",	ADD,
	"and",	AND,
	"asl",	ASL,
	"asr",	ASR,
	"bit",	BIT,
	"bsr",	BSR,
	"cba",	CBA,
	"clr",	CLR,
	"clc",	CLC,
	"cli",	CLI,
	"clv",	CLV,
	"cmp",	CMP,
	"com",	COM,
	"cpx",	CPX,
	"da",	DAA,
	"des",	DES,
	"dec",	DEC,
	"dex",	DEX,
	"eor",	EOR,
	"ins",	INS,
	"inc",	INC,
	"inx",	INX,
	"jsr",	JSR,
	"lda",	LDA,
	"lds",	LDS,
	"ldx",	LDX,
	"lsr",	LSR,
	"neg",	NEG,
	"nop",	NOP,
	"ora",	ORA,
	"psh",	PSH,
	"pul",	PUL,
	"rol",	ROL,
	"ror",	ROR,
	"rts",	RTS,
	"rti",	RTI,
	"sbc",	SBC,
	"sb",	SBA,
	"sec",	SEC,
	"sei",	SEI,
	"sev",	SEV,
	"sta",	STA,
	"sts",	STS,
	"stx",	STX,
	"sub",	SUB,
	"swi",	SWI,
	"ta",	TAB,
	"tap",	TAP,
	"tb",	TBA,
	"tp",	TPA,
	"tst",	TST,
	"tsx",	TSX,
	"txs",	TXS,
	"wai",	WAI,
	"equ",	EQU,
	"rmb",	RMB,
	"fcb",	FCB,
	"fdb",	FDB,
	"org",	ORG,
	0,	0};
