.th oxo cmd 6/28/79
.sh NAME
oxo \*- othello, a game of dramatic reversals
.sh SYNOPSIS
.bd /sys/games/oxo
[
.bd B
] [
.bd b\c
#
] [
.bd d\c
#
] [
.bd IB\c
mv
] [
.bd IW\c
mv
] [
.bd i\c
file
] [
.bd l\c
#
] [
.bd o\c
file
] [
.bd q
] [
.bd r\c
[#]
] [
.bd s\c
#
] [
.bd T
]
.it file
]
.sh DESCRIPTION
.it Oxo,
(a.k.a \fIothello\fR, a.k.a \fIreversi\fR),
is played on an square board, (usually 8 x 8),
using tokens which are "white", (O), on one side, and "black",
(X), on the other.
Each player takes his turn by placing
a token with his color up in an empty square.
The board initially contains two "O" and two "X" tokens.
With each turn, a player must
flip over one or more tokens displaying his opponent's color.
He does this by placing
one of his tokens such that
he outflanks one or more
of his opponent's,
horizontally, vertically, or diagonally.
The outflanked tokens are flipped over
and thus can be re-flipped.
If a player cannot outflank
his opponent, he must pass thereby forfeiting
his turn.
The play continues until both players must pass.
.s3
In this game
you move by typing in the column letter and row number
at which you want to place your token.
You can also type in:
.s3
.lp +10 7
\fB?\fR\*Tto re-draw the board,
.lp +10 7
\fB^\fR \fIn\fR\*Tto retract your last move, (handy for cheating),
.lp +10 7
\fBpass\fR\*Tto acknowledge that you have no legal move,
.lp +10 7
\fBresign\fR\*Tto give up, and
.lp +10 7
\fB!\fR\*Tto escape to the Shell. Control-d gets you back.
.i0
.s3
.it Oxo
has several flag arguments.  Their meanings are:
.lp +10 7
\fBB\fR\*TThe computer plays "black" and goes first.
.lp +10 7
\fBb\fR#\*TThe board size is set to #x#, (max is 10x10).  The default is 8x8.
.lp +10 7
\fBd\fR#\*TThe debug flag is turned on; # indicates how much meaningless
trace information you'd like to be buried under.
This flag also forces the \fBT\fR flag.
.lp +10 7
\fBIB\fRmv\*TInitialize the square at "mv" to hold a black token,
where "mv" is the letter-number of a square on the board.
This is useful for starting a game with an arbitrary board configuration.
.lp +10 7
\fBIW\fRmv\*TInitialize the square at "mv" to hold a white token,
as above.
.lp +10 7
\fBi\fRfoo\*TTake move input from the file named "foo".  Useful for
having the program play against other programs, (this sentence no verb).
.lp +10 7
\fBl\fR#\*TSet look-ahead level to # initially; look-ahead level is
modified dynamically to try for a given compute time per move, (see
the \fBs\fR flag, below).
.lp +10 7
\fBo\fRfubar\*TSend computer moves to the file named "fubar".
The format is the same as expected for input, (see \fBi\fR flag, above).
.lp +10 7
\fBq\fR\*TQuiet mode.  Suppress gratuitous display of the board.
.lp +10 7
\fBr\fR#\*TReport on look-ahead results down to level #.  This option is
similar, but not identical, to \fBd\fR.
This flag also forces the \fBT\fR flag.
.lp +10 7
\fBs\fR#\*TAttempt to use # seconds of combined user and system time
for each computer move.  If unspecified the default is 5 seconds.
.lp +10 7
\fBT\fR\*TThe terminal in use either has no cursor addressing or
has different cursor addressing from the standard.
Normally, the playing board is displayed and
modified on the screen via cursor motion commands and the list of
moves is scrolled at the bottom of the screen.
This flag indicates that your terminal is functionally a teletype
and should be treated as such.
.i0
.sh DIAGNOSTICS
Fairly reasonable explanations of illegal moves, etc.
.sh BUGS
