.TH VN 1 2/1/85
.UC
.SH NAME
vn - visual news reader
.SH SYNOPSIS
.I vn
.SH DESCRIPTION
.I Vn
is a news reader which uses the same 
.B .newsrc
file as
.I readnews
(1), but displays and interacts differently.  It is aimed at allowing
you to rapidly scan a large number of newsgroups, looking for something
you want to read.  The major premise is that you will be interested in a
small number of articles, but will be interested in keeping tabs on a large
number of newsgroups which may contain something interesting from time to time.
It also has the ability to unpackage digests.
.sp
.I Vn
supports the -n, -x and -t options of
.I readnews
(newsgroup, read all articles, and title).  In addition, there
is a -w (writer) option which works like -t, but is a search string to
apply to the "From" header line rather than the subject.  In the -n, -t
and -w options, a leading ! on the string is taken to mean negation.
The rest of the string is a regular expression for the -w and -t options.
.sp
For example:
.sp
-n net.dogs -w !fred -t [Bb]eagle
.sp
For articles in net.dogs about beagles written by somebody other
than fred.  Multiple -w -t options result in the logical "or" of the
-w's anded with the logical "or" of the -t's, whatever order you may specify
them in.  -n options allow the "all" convention, replacing ".all" by
".*" before using the regular expression calls.  -n options are processed
in order given, so that subsequent more specific -n's may partially
undo the effect of previous "alls".
.sp
Options may be given on the command line, in which case they will
supersede those given in the
.B .newsrc
file.  For command line -n options, the "!" unsubscriptions in
.B .newsrc
are also ignored.  This allows you to override all subscription information
by command line specification.
.sp
When
.I vn
is invoked,
there will be a pause (with an explanatory "reading" message and
a series of newsgroups) while vn reads the news.  The newsgroups listed
are ones articles are actually being found in.
The length of the pause depends
on how much news there is.  If there is a lot,
it may take a long time to get through the reading phase.
.sp
Once the reading phase is over, interaction is rapid.
If
.I vn
is backgrounded, it suppresses the "reading" output, so
that it will not halt on tty output until it is ready to begin showing
articles.
.sp
.I Vn
may show you a list of newsgroups which were not mentioned in the
.B .newsrc
file.  Records for these newsgroups will be added, whether
they were scanned for articles or not.  The first time
.I vn
is used, the list may be quite long and scroll off the screen.
Thereafter, there should only be a list when new newsgroups are
created.  This display serves to let you know of their existence,
or of something happening to your
.B .newsrc
file.
.sp
The basic display is a "page" which shows a newsgroup and a list of
titles, number of
lines, and authors for new articles.
Articles which have been updated in the
.B .newsrc
file  are flagged with an underscore preceding the article number.
You also have the ability to "mark" articles for the duration of a session,
shown with an asterisk (col. 1 and 2 are reserved for asterisk and
underscore respectively - 
in normal usage they will be blank, so that the casual user will probably
be unaware of their use until marking and updating are invoked)
.sp
There is a help menu to go with this page.
You may read articles, save them, send them to the printer, either by cursor
position, the whole page, or in specified sets.  Sets are specified either
as a set of article numbers, a regular expression to match the subject /
author / number of lines data on, or an asterisk to indicate the choice
of a set of previously marked articles.  Any of these methods also
accept a leading "!" to indicate negation.
.sp
By default, when you read articles only a couple of the dozen or so
header lines are
shown.  There is an option to allow you to see all the
header lines when you read articles.  The command controlling this toggles
between the two states.
.sp
A similar toggle is used to support ROT13.
.sp
.I Vn
is capable of manipulating digests.  The "d" command unpacks a digest,
and presents you with a page showing the unpacked articles, which can
be accessed as for articles on normal newsgroup pages.
When you leave the digest page(s), you reenter the normal flow of newsgroups.
Digests can also be read as normal articles, of course.
.sp
Order of pages is determined by
order of groups in
.B .newsrc.
Newsgroups which are not
mentioned in
.B .newsrc
will be added, as mentioned previously, and tacked onto the end.
Lines corresponding to non-existent newsgroups will be deleted.
You will probably want to run
.I vn
once, then edit
.B .newsrc
to the desired order of presentation.
.sp
Updating the data for
.B .newsrc
is under user control.  If you do
no "W", "w", "^w", o or O commands, no updating takes place, and you'll see the
articles again the next time you read news.
Breaks result in a "really quit?" query, so you can recover from noisy
lines and prompts for commands you didn't really mean.
If you quit without updating, you will be prompted to make sure you
don't want to do so.
.sp
Commands are single character (no return key required), except that
they may be preceded with numeric characters, which may have
some effect on their actions.  Commands which require further input
cause prompts for the information, this input being
terminated by return.  For prompted input, the erase and kill keys
work.
.sp
.ce 1
Command Menu For Page:
.sp
.nf
[...] = effect of optional number preceding command
pipes are specified by filenames beginning with |
articles specified as a list of numbers, title search string, or
	* to specify marked articles.  ! may be used to negate any

	 q - quit
	 k - move up [number of lines]
	 j - move down [number of lines]
 <back sp> - previous page [number of pages]
  <return> - next page [number of pages]
	 d - unpack digest
	 r - read article [number of articles]
   <space> - read article (alternate 'r')
	 R - read all articles on page
 control-r - specify articles to read
	 s - save or pipe article [number of articles]
	 S - save or pipe all articles on page
 control-s - specify articles to save
 control-t - specify articles to save (alternate ctl-s)
	 p - print article [number of articles]
	 P - print all article on page
 control-p - specify articles to print
	 w - update .newsrc status to cursor
	 W - update .newsrc status for whole newsgroup
 control-w - update .newsrc status for all pages displayed
	 o - recover original .newsrc status for newsgroup
	 O - recover all original .newsrc status
	 # - display count of groups and pages - shown and total
	 % - list newsgroups with new article, updated counts
	 n - specify newsgroup to display and/or resubscribe to
	 u - unsubscribe from group
	 x - mark/unmark article [number of articles]
	 * - mark/unmark article [number of articles]
	 X - erase marks on articles
	 h - toggle flag for display of headers when reading
	 z - toggle rotation for reading
<formfeed> - redraw screen
	 ! - escape to UNIX to execute a command
	 ? - show this help menu
.fi
.sp
When you read articles, there is another help menu, for advancing through
the articles, replying, posting followups, and saving the
articles.  Breaks may be used to
stop the output of an article if you decide that you didn't really
want to read it.  You can jump from the reading portion back to either
page you came from or the NEXT page.
.sp
For replying and posting followups, you will be thrown into an editor
to create the reply or article.
The article will be included in the file you are editing, marked with
"> "'s for excerpting in your reply or followup.  After you exit the
editor, you are prompted to make sure you still want to post or reply,
so you can abort.
.sp
For the "mail reply" choice, you will be shown the address taken from
the article, and you may specify a different one.  This is done with
the article you have been reading still on the screen so that you
may copy the authors suggested path, if present.
.sp
The editor is determined by your EDITOR variable, as for
.I postnews.
If EDITOR is not set, you get
.I vi,
or the default determined at your site.
.sp
.ce 1
Reading menu:
.sp
.nf
         n - next article, if any
         q - quit reading articles, if any more to read
         Q - quit reading, and turn to next page of articles
         r - rewind article to beginning
  <return> - next line
         m - send mail to author of article
         f - post followup to article
         s - save article in a file
         ? - see this help menu
	 z - toggle rotation flag
	 h - toggle header suppression flag

 anything else to continue normal reading
.fi
.sp
.SH FILES
.TP 24
/usr/tmp/*
One temporary file created by
.I tmpnam
(3), and immediately unlinked,
remains open in update mode for duration of session.
Disk space freed by system close of file descriptor at exit.
Can be large, as this file contains the "page" displays.
Temporary files also created by
.I tmpnam
(3) for mailing replies, posting followups and creating digest "articles".
.TP 24
(login directory)/.newsrc
news status file.  Updated following session.  See NEWSRC environment variable.
.TP 24
(login directory)/*.vn
One temporary file created by
.I tmpnam
(3) while updating the .newsrc file.  If the update fails, you are informed,
and this file
may be used to recover the last update.  Unlinked following successful update.
.TP 24
(spool directory)/*
spooling directories containing articles.
.TP 24
/usr/lib/news/active
active newsgroup list.
.SH "ENVIRONMENT VARIABLES"
.TP 24
PS1
used to present prompt string for command on unix escape.
defaults to "$ "
.TP 24
EDITOR
editor used for mailing replies and posting followups.
defaults to "ed".
.TP 24
POSTER
posting program for followups.  defaults to "inews -h".
.TP 24
MAILER
used when mailing replies.  defaults to "/bin/mail".
.TP 24
PRINTER
program used with the print commands for sending articles to
the printer.  defaults to "lpr -p".
.TP 24
NEWSRC
if set, can be used to override the choice of ".newsrc" as the
name for the status file.  Name will still be used relative to
the login directory.
.SH DIAGNOSTICS
user error messages.  self explanatory.
.SH AUTHOR
R. L. McQueer
.SH BUGS
Note that
.I readnews
will rearrange the order of
.B .newsrc.
If you
interleave use of it with
.I vn,
order selection gets hosed.
.sp
If you've really taken advantage of the ability of readnews to skip
articles in the middle of the spooling numbers, be warned that
.I vn
doesn't have it, and will
assume you've read the articles in the middle.
.sp
If the
.B .newsrc
file indicates that you've read articles in a newsgroup with a higher
number than the current spooling number for that newsgroup,
.I vn
will show you the entire newsgroup.  This is intended for recovery in
cases where article spooling has been reset, or to avoid missing articles
because you just changed machines and didn't bother to edit your
.B .newsrc
file.  Rather than miss stuff, you'll see some old stuff again.
.sp
Sometimes a "break" during reading an article will not only halt the
article but suppress the prompt.  A command character will work anyway.
.sp
If a prompt to be displayed on the dialogue line
contains non-printing sequences, stuff on the
line may not get erased when you are prompted, because
.I vn
thinks the string is long enough to overprint its current contents.
This usually comes up when you have escape sequences in your UNIX
prompt, and do a "!" command.
The "overprint" check is made to save a clear-line sequence (kludged in
by overprinting to the end with blanks if the terminal doesn't
have one - annoying at 1200 baud).
.sp
Output during the reading phase which was suppressed by backgrounding
.I vn
does not get started by foregrounding it again without doing a
control-z and a second foreground (it doesn't figure out its background /
foreground status on each output - only on startup and while handling
the SIGTSTP signal).  Actually, this results in a method for having
.I vn
do its reading phase silently in the foreground without redirecting
output, should such a thing be desired.
.sp
Very many -w or -t options cause SLOW reading phases.  It is reccomended
that these be used only when reading a few specific groups.
.sp
Digest extraction will split a single article into several if it contains
embedded ---- lines, the normal separator between articles in digests.
They will all have identical titles.
Digest extraction may not work with human built digests which don't
use the expected syntax for joining articles.  mod.computers.ibm-pc
and mod.computers.mac were used as models for the feature.
