'''
''' @(#) admin.man	1.2 (TDI) 2/3/87
''' This file is part of UNaXcess Conferencing 1.0.2.
'''
.ds U \fBUNaXcess\fR
.TH ADMIN LOCAL UNaXcess
.SH NAME
admin - \*U administration procedures
.SH SYNOPSIS
ua sysop
.br
mvmsg conference[/msg] ... conference[/msg]
.SH "\*U Administration"
\*U administration has advanced from the earlier versions, but is still a
tricky affair in many cases.  Bulletin management has been embedded in \*U,
and file UDL administration is coming soon.  However, much administration must
still be carried out from the shell.
.P
System administration consists of the following procedures:
.de LS
.in +10
.ll -5
.sp
.ns
..
.de LI
.sp
.ti -5
\fB\\$1\fR \-
..
.de LE
.sp
.in -10
.ll +5
.ns
..
.de BS
.in +5
.ll -5
.sp
.ns
..
.de BI
.sp
\fB\o'o+'\fR \fI\\$1\fR
.br
..
.de BE
.sp
.in -5
.ll +5
.ns
..
.BS
.BI "User Administration"
.BI "Message Base Administration"
.BI "Bulletins"
.BI "File UDL Administration"
.BI "Fairwitnessing"
.BE
.SH "1. User Administration"
User administration consists largely of validating new users and restricting
those who violate the local rules.  The primary commands for this are:
.LS
.LI A
Alter users.  The administration options for the Alter command are:  Name,
Password, Access, line Size, Lines/screen, UNIX user name, default
Conference, Kill user, Finished, and Quit.  For the New User access level, the
options are: Name, Password, Access, Kill, Finished, Quit, and Default access.
.LI W
List users.  The administrative option displays the user's full address and
phone number for validation purposes.
.LE
The full options to the Alter command are described below.
.LS
.LI N
Change the user's name.  Previous versions of \*U created a new user under
this option; the current version only changes the user's name.  Standard \*U
naming rules are enforced:  a name may not be more than 32 characters, and may
not contain colons.
.LI P
Change the user's password.  A password must be 3-8 characters long.  It is
NOT verified; however, the password is displayed openly.  This practice is
debatable.
.LI A
Change the user's access level.  Valid access levels are described below.
Only the Sysop may assign or revoke Fairwitness access.
.LI D
For New User access, the D command sets the default access level for new
users.  Usually, this access level will be Denied or Guest for validating
systems, or Messages for open systems.  New User and Fairwitness access may
not be assigned as the default access level.
.sp
For all other access levels, the D command sets the default conference,
similar to the D command on the Message Base menu (see the \*U User's Guide).
The conference is checked against the user's subscription list.
.LI U
This command sets the user's UNIX login name.  At present, this field is
commentary; in the future, it may be used to permit access from the shell.
It will be used for UANet when it is released.
.sp
This command is not available if the user's access is New User.
.LI L
This command sets the number of lines on the user's screen.  This number must
be between 0 and 66; a value of 0 disables \*U's internal paging.
.sp
This command is not available if the user's access is New User.
.LI S
This command sets the number of characters per line.  This number must be
between 40 and 132.  The lower limit may be changed to 32 or even 20 in the
future; the upper value is unlikely to change.
.sp
This command is not available if the user's access is New User.
.LI K
This command deletes (kills) the user from the \*U userfile.  It asks for
confirmation before doing so; if it does delete the user, an immediate exit
from Alter is performed.
.sp
No user may Kill himself, the Sysop included.
.LI Q
This command causes the Alter command to be aborted.  New user creations will
also not be performed.  It asks for confirmation before aborting.
.sp
If a Fairwitness examines another Fairwitness, Quit is the only valid command;
and it does not ask for confirmation.
.LI F
Finished.  This command encrypts the password if it was changed, and saves the
user's userfile information.
.LE
Three things should be noted about the Alter command:
.LS
.LI 1
No user may Kill himself; and
''' OOPS!  Changed 2/3/87 ++bsa
.LI 2
No Fairwitness (except the Sysop) may change anything about another
Fairwitness.
''' OOPS!  3 lines deleted, 1 line changed 2/3/87 ++bsa
.LE
A fairwitness (or the Sysop) can create another user by naming hir; if the
user doesn't exist, s/he will be asked if s/he wishes to create a new user.
.P
The other major command used in user administration is the V command from the
Administration menu.  This command looks up the current default access level
for new users and displays the information for each user who has this access.
You are given the option to Validate the user for another access level, Hold
hir at the current access level, Kill the user, Deny the user access, or
execute a subshell.  (The latter option is most useful in checking to see if a
\*U user is also a shell user, for the purpose of validating a user for System
access.  Note that later versions of \*U will use the Unix user information,
so every user's stated Unix login name should be checked.)  After all users
have been presented, they will be validated according to the access level
given.
.SH "2. Message Base Administration"
Very little message base administration has been implemented within \*U at
present.  The functions of message base administration are:  creation and
deletion of conferences, deletion of messages, relocation of messages,
creation and maintenance of read-only conferences, and conference restriction.
.P
Creation of conferences is described under the Join command of the Message
Base Menu in the \*U User's Guide.  One modification is permitted for
Fairwitnesses:  they may designate a conference with the prefix ``R-'', which
will be treated as a read-only conference; only Fairwitnesses may post
messages to it.  (This option must be enabled in the configuration file; see
"Configuration" below.)
.P
Deletion of conferences has not been implemented within \*U as yet; for the
security system to work, a setuid-root program would have to be created to do
it, and as yet the "mkconf" program used for conference creation has not
gained widespread approval.  (The author considers it safer than a setuid-root
\*U, however.)
.P
Deletion of messages may be done from \*U; however, the author has found that
the best way to "strip" a conference of old messages is the command:
.sp
.ce
find msgdir -mtime +30 -print | xargs rm
.sp
This option (delete all old messages) may be added to \*U in the future;
however, it is certain that some sites may wish to use different criteria for
message deletion.
.P
Relocation of messages may only be performed from the shell by the owner of
\*U.  The command "mvmsg" is used, with two different syntaxes.
.LS
.LI 1
mvmsg conference/msg conference
.br
Move the specified message to the specified conference.  It is installed in
the destination conference as if it were a new message.
.LI 2
mvmsg conference conference
.br
Move all messages from the source conference to the destination; all messages
are installed in the destination conference as if they were new messages.
This command also deletes the source conference
.IR "if \fBmvmsg\fI is not setuid" .
A setuid 
.B mvmsg
is not recommended, as this permits any user to relocate messages.
.LE
.P
Conference restriction is performed via the E command of the Administration
Menu.  It is restricted to Fairwitnesses who are members of the restricted
conference, and to the Sysop.  Only the Sysop may restrict or de-restrict a
conference.
.P
Any conference may be restricted.  Restriction causes a conference to be
restricted only to members; non-members cannot Join it, and the conference
will be silently skipped by the New command of the Message Base menu.  All
Fairwitnesses are members of restricted conferences in that they may enter
and delete messages; however, they must be explicitly named as members in
order to modify restrictions.
.P
The Edit command is used to edit restrictions.  Only Fairwitnesses and the
Sysop may execute the Edit command.  On start-up, it asks for the conference
to edit; if the conference is not restricted, Edit permits the Sysop to
restrict it.  Fairwitnesses will be returned to the Administration menu.  The
Sysop must confirm the restriction of a conference.  Fairwitnesses who Edit a
conference to which they are not members will be shown the membership list and
returned to the Administration menu.
.P
The Edit commands are as follows:
.LS
.LI L
List conference membership.  This command displays the membership list for the
conference.
.sp
This command is automatically executed for Fairwitnesses who are non-members;
the Edit command then exits.
.LI A
Add a member to the conference.  A user name is read; it is then added to the
membership list if it is not already listed as a member.
.LI D
Delete a member from a conference.  A user name is read; if it is a member of
the conference, it is deleted from the membership list.
.LI S
This command exits the Edit command.  It does not save changes; the A and D
commands directly affect the membership list.
.LI C
This command de-restricts a conference.  The membership list is deleted, and
the conference becomes unrestricted.
.sp
Only the Sysop may Clear a conference restriction.
.LE
.SH "3. Bulletins"
Bulletins are created via the B command.  It works similarly to the E command
of the Message Base menu, but posts to the bulletin directory.  There is no
way to delete a bulletin as yet.
.P
There is one special bulletin, the new user bulletin.  There is as yet no way
to create a new user bulletin; the simplest way is to create it as an ordinary
bulletin and execute the command:
.sp
.ce
cp motd/`cat motd/himotd` NewMessage
.sp
All of this is subject to change in the future.
.SH "4. File UDL Administration"
File UDL is self-administering, except for access permissions and installation
of uploaded files in the download area.  Access permissions are maintained as
part of user administration.
.P
The primary reason for not installing uploaded files is that there is no easy
way to check such files for "trojan horse" programs from within \*U.
Therefore, upload administration is a shell task.
.P
A File UDL area consists of two files and two directories.  For each branch,
there exists a directory within the
.B library
directory where downloadable files reside.  If uploading is to be permitted, a
directory must be created within the
.B uploads
directory.  Neither is possible from within \*U; the
.B mkconf
program is too restricted.  (See the discussion of conference deletion
above.)  There are also two global files:
.LS
.LI directory
This file contains definitions for each branch of the File UDL library and for
each downloadable file within the Library.
.LI upload-log
This file contains definitions for each branch allowing uploading, as well as
information about uploaded files.
.LE
The
.B directory
and
.B upload-log
files have the same format:  one line for each branch or file definition.  The
format of a definition is:
.sp
.ce
branch \fBfile\fR id; date \fBby\fR user: description
''' OOPS!  Above line fixed 2/3/87 ++bsa
.sp
The words
.B file
and
.B by
are required, as is the punctuation; however, the description may be any
arbitrary ASCII text.
.P
.B Branch
is the name of the branch being defined or containing the file being defined.
.P
.B Id
is a file name, if a file is being defined.  If a branch is being defined, it
is the reserved word
.BR branch .
.P
.B Date
is a date delimited by spaces; it is usually of the form
.IR mm/dd/yy ,
although nothing requires this; it is displayed as text.
.P
.B User
is a user name.  It need not be a \*U user name, although it must follow the
same rules.
.P
.B Description
is any text.  It should be limited to 50 characters or less.
.P
Once an uploaded file has been validated, it should be relocated from the
.B upload
directory to the 
.B library 
directory; the corresponding line in
.B upload-log
should be appended to the
.B directory
file.
.SH "5. Fairwitnessing"
The art of Fairwitnessing is still new.  In principle, a Fairwitness is
capable of anything the Sysop can do, except that s/he may not administer
other Fairwitnesses in any way.
.P
In practice, a Fairwitness is envisioned as a person in charge of a conference
or group of conferences, acting as a stimulator of discussion.  Hir functions
include summarizing previous messages for new participants, pointing out
unnoticed relationships between parts of a discussion or between a discussion
and other things/events, asking questions or making statements in order to
stimulate discussion, et cetera.  A good Fairwitness should aid a discussion,
not hinder it; censorship is against all principles of Fairwitnessing.  Any
opinion should be permitted voice; the more "contrary" to previous discussion,
the better, as such opinions force the mind to stretch.
.P
There are two potential problems awaiting a Fairwitness.  The first is the
one-sided discussion; such discussions are meaningless.  The best way to deal
with this is for the Fairwitness to throw a dissenting or contradictory
opinion into the pot and demonstrate a rationale for it; with multiple
viewpoints, the conference is much livelier.
.P
This, however, makes possible the other extreme, as is often seen on the
Usenet and other large conferencing systems:  some user or group of users
conspire to voice their opinion loudly, and hurl insults at anyone who dares
to voice dissent.  Experience has shown that the best way to deal with such
users is user administration; set the offending user's access to Denied.
However, this is contradictory to freedom of speech (despite the fact that the
users' actions are themselves contradictory to it); limited success has been
achieved by way of ridicule and other techniques.  It should be noted that
if a lack of discussion is evident, it may be a symptom of censorship; a
Fairwitness's biggest job is to strike at censorship whernever it rears its
ugly head.
.P
The original concept of the Fairwitness comes from the Fair Witness of Robert
A. Heinlein's book,
.IR "Stranger in a Strange Land" .
However, while Heinlein's Fair Witnesses were observers only, unable to voice
opinions, the purpose of a Fairwitness is to voice opinions as necessary
.IR "to stimulate free speech" .
S/he must not attempt to "control" a discussion; s/he should fuel it, and let
it evolve on its own, unless it begins to die out or become limited.
.P
The job of a Fairwitness is the most difficult of all administration duties;
it is also the most important.  A Fairwitness can \- literally \- make or
break a \*U system.
.SH Configuration
Configuration is another task that must be performed from the shell.  The \*U
installation script does some configuration, but the Sysop may decide to alter
the configuration later on.
.P
The \*U configuration is stored in an ascii file named
.BR ua-config .
This file may be edited with an ordinary text editor, unlike bulletin and
message files.  It consists of lines of the form:
.sp
.ce
variable		value
.sp
The variables understood by \*U are:
.LS
.LI bbs-directory
string
.br
This is the directory containing the \*U working files and message base.  This
allows the Sysop to be an ordinary UNIX user, with only the 
.B ua-config
file within hir directory.  If the NOAUTOPATH directive was used when \*U was
compiled, this is the only way to change the directory used by \*U.
.sp
The default value is the home directory of the owner of \*U.
.LI readonly
boolean
.br
This variable indicates whether read-only conferences are permitted in the \*U
system.  The default is FALSE.
.LI restricted
boolean
.br
This variable indicates whether conference restriction is permitted within
\*U.  The default is FALSE.
.LI shell
shell
.br
This variable is the shell executed by the C command.  The default is /bin/sh.
.LI read-env
boolean
.br
This variable indicates whether the 
.I shell
variable may be overridden by the environment variable
.IR SHELL .
The default is FALSE.
.LI bbs-user
string
.br
This variable is a comma-separated list of UNIX users who cannot use the
direct shell login feature.  This prevents new users from creating security
problems by naming themselves by UNIX logins for which \*U is the shell.
The default is the empty string.
.LI time-limit
number
.br
This variable indictates the time limit in minutes for \*U users.  The time
limit does not apply to the Sysop.  A time-lmit of 0 means that there is no
time limit.
.sp
The default time-limit is 30 minutes.
.LI sysop
string
.br
This variable contains the Sysop's \*U user name.  This provides a flexibility
found in few other conferencing systems; the sysop may have any valid \*U
name.  Note, however, that the \*U user named must exist and have Fairwitness
access level to qualify as a Sysop.
.sp
The default is "sysop".
.LI private-msgs
boolean
.br
This variable indicates whether private messages are permitted.  The default
is FALSE.
.LI loggin
boolean
.br
This variable indicates whether full logging is to be enabled.  New users,
errors, panics, and some other occurrences are always logged.  The default is
FALSE.
.sp
Warning:  the file
.B LogFile
can become quite large when logging is enabled.
.LI banner
string
.br
This variable names a file which contains a banner to be printed when \*U
starts up.  The empty string indicates that a built-in banner consisting of a
copyright message should be printed.
.sp
The default is the empty string.
.LI login-msg
string
.br
This variable is a string to be printed as the login prompt.  The empty string
indicates that the string,
.sp
.ce
Enter your user name, GUEST, OFF, or New:
.sp
should be printed.
.sp
The default is the empty string.
.LI login-tries
numeric
.br
This variable indicates the number of login attempts permitted before \*U
exits.  A value of 0 causes \*U not to count login attempts.  The default is
3.
.LI udl-command
There are six UDL commands, which are all of type string:
.BR ascii-upload ,
.BR ascii-download ,
.BR xmodem-upload ,
.BR xmodem-download ,
.BR kermit-upload ,
and
.BR kermit-download .
Each may contain the escape sequence %s to indicate the location of the file
name to be uploaded/downloaded; otherwise, the file name is appended to the
end of the command string.  An empty string denotes the lack of the
corresponding ability.
.sp
The defaults use
.B cat(1)
for ASCII, 
.B umodem(1)
for Xmodem, and C-Kermit for Kermit.
.LI validation-level
This variable indicates the access level granted to new users.  At the present
time, it is the internal access level code, as follows:  0 is the code for no
access; 1 is Guest access; 2 is Messages access; 3 is File UDL access; 4 is
system access.  Access levels 5 and 6 (Fairwitness and New User) should
.B NEVER
be used.
.LE
Variables of type
.B string
may have as values single words without quotes, or any number of characters
and spaces enclosed in double quotes.  Variables of type
.B number
may have as values any number from 0 to 255.  Variables of type
.B boolean
may have as values unquoted strings, case ignored, beginning with Y or T for
true or with N or F for false.
.SH "Acknowledgements and Copyrights"
UNIX(R) is a registered trademark of AT&T.
.br
Kermit is copyrighted by Columbia University.
