.TH CGREP 1 "18 April 1986"
.UC 4
.SH NAME
cgrep \- search a file for a piece of context
.SH SYNOPSIS
.B cgrep
[-mi] [-n -p -/pat] [+n +p +/pat] pattern [ files... ]
.LP
.SH DESCRIPTION
.I Cgrep
takes a chunk of context out of a text file based on a pattern that lies
inside the context, and rules for specifying the amount of context. If no
rules are specified, then
.I cgrep 
works just like grep
except that it finds only the first occurrence of "pattern".  A backward
searching rule need not be matched by a forward searching rule, and vice
versa, however, no more than one rule "per direction" should be used.  
.I Cgrep
does not recognize the grep family metacharacters.  It matches exactly what
it is given. The default input is the standard input.

When more than one file is searched, the name of the file in which the
context is found is enclosed in <> at the top of the text.

The following options are recognized:
.TP
.B \-n
Begin printing 
.I n
lines before the first occurrence of "pattern". If no
.I n
is specified, default is one.
.TP
.B \-p
Begin printing at the beginning of the paragraph 
containing the first occurrence of "pattern".  (assuming
that paragraphs are separated by a blank line)
.TP
.B \-/pat
Begin printing at the line containing "pat" nearest 
before the first occurrence of "pattern".
.TP
.B +n
Stop printing 
.I n
lines after the first occurrence of "pattern".  If no
.I n
is specified, default is one.
.TP
.B \+p
Stop printing at the end of the paragraph containing the
first occurrence of "pattern".  (i.e. the next blank line)
.TP
.B +/pat
Stop printing at the first line past "pattern" which
contains "pat".
.TP
.B \-i
Ignore case.
.TP
.B \-m
Mail mode.  Delete all blank space at the beginning of the lines to be
printed and insert "> ".  This may be useful from within the editor
in replying to mail or news.
.TP
.SH
.SH EXAMPLE
$ cgrep -2 +/john harry file1

searches file1, and prints starting 2 lines before the first occurrence of
"harry" and ending when it finds a line containing "john"

$ cgrep -p +p george file2

searches file2 and prints the paragraph containing "george"
.SH BUGS
When using both -m and -i, use separate flags.

Results are unpredictable if multiple rules for searching the same direction
are given, though it will probably use the latter.

If the pattern is found in the first of multiple files, the filename is
not printed at the top.

If a backward pattern search is done on a non-existent pattern, the backward
search is ignored.

Line length is limited to 256 characters.

Send all comments, etc to iannucci@sjuvax.UUCP
