


GENEAL(LOCAL)       UNIX Programmer's Manual        GENEAL(LOCAL)



NAME
     geneal - genealogy program

SYNOPSIS
     Geneal [ option ] ...  [ file ]

DESCRIPTION
     _G_e_n_e_a_l is a program to read a database of family relations
     in the named _f_i_l_e and print the information out in various
     formats.

     If no _f_i_l_e argument is present, the default file,
     _g_e_n_e_a_l_o_g_y._d_a_t , is read.

     It deals with families and individuals, each identified by a
     unique integer.  The database contains information such as
     _b_i_r_t_h , _d_e_a_t_h and _m_a_r_r_i_a_g_e dates and places (if you know
     them!), relations between people (i.e. what children belong
     to X, are you my mother), and miscellaneous information of
     general interest.  The program can read the information for
     a specified individual and output it in a specified format.
     At the moment there are two formats (only one of which is
     "real"): the tree, and the family page.  The tree format is
     only a tiny bit implemented, so it's not very useful yet.
     The family page gives information about an entire family
     (one generation), i.e. parents, children, and childrens's
     spouses.  More formats can easily be added (and will be in
     the future!).

     Geneal expects one argument on the command line, which is
     the index number of the person or family to center the data
     search/output on.

     The options available are:

     -f   produce a family information page

     -h   give this help message (try this in case this man page
          is wrong!)

     -i   produce information about an individual

     -s   use a short form of output

     -t   produce a tree (not implemented very far!)

     -D   debug data routines

     -F_f_i_l_e
          use the specified file as datafile

     -I   debug index routines



Printed 8/29/85              8/28/85                            1






GENEAL(LOCAL)       UNIX Programmer's Manual        GENEAL(LOCAL)



     -N   output internal index numbers with all names

     If no format switches (-f, -i, -t) are given, browse mode is
     entered.  The two debug switches (-D and -I) will probably
     not be useful to you unless you are familiar with the data-
     man and index routines which they apply to.


EXAMPLE
     Individuals or families are specified by index number.  Thus
     the command to output the family data page for a particular
     family would be


              geneal -f 1025
          where 1025 is the index number for that family.

NOTES
     There is some flexibility in the data file as to what
     numbers you use as index numbers.  The authors have adopted
     the convention that individuals are numbered starting at 1
     and families starting at 1000 (when I get 1000 individuals,
     I will start the next group at 10000).  You may want to use
     different conventions, e.g. odd numbers for males, even for
     females; families starting at a higher number; or whatever.

FILES
        genealogy.dat    The database file. This is a sample
                    file for you to use as a template
                    for creating your own data file.

        family.1003           Sample output file produced by
                    "geneal -f 1003".

        pgmr.doc         Programmer's documentation. Gives
                    more details about some of the source
                    files. Read this if you need to look
                    for bugs.

AUTHOR
     Jim McBeath (original author)
     Terry L. Ridder (ported geneal to Version 7 and SYS V)













Printed 8/29/85              8/28/85                            2



