# DUNGEON-- MAIN PROGRAM
#
	PROGRAM DUNGEO
	INCLUDE 'zork.com'

# DUNGEON, PAGE 2
#
# DATA STATEMENTS FOR CONSTANT ARRAYS
#
	DATA VMAJ/2/,VMIN/1/,VEDIT/'A'/
#
	DATA SDIR/o'40000'/,SIND/o'20000'/,SSTD/o'10000'/,
		SFLIP/o'4000'/,SDRIV/o'2000'/,SVMASK/o'777'/
	DATA VABIT/o'40000'/,VRBIT/o'20000'/,VTBIT/o'10000'/,
		VCBIT/o'4000'/,VEBIT/o'2000'/,VFBIT/o'1000'/,VPMASK/o'777'/
#
	DATA BATDRP/66,67,68,69,70,71,72,65,73/
#
	DATA SCOLDR/o'2000',153,o'12000',154,o'6000',152,o'16000',151/
	DATA SCOLWL/151,202,o'6000',152,203,o'16000',
		153,201,o'12000',154,200,o'2000'/
#
	DATA CEVCUR/1/,CEVMNT/2/,CEVLNT/3/,CEVMAT/4/,
		CEVCND/5/,CEVBAL/6/,CEVBRN/7/,CEVFUS/8/,
		CEVLED/9/,CEVSAF/10/,CEVVLG/11/,CEVGNO/12/,
		CEVBUC/13/,CEVSPH/14/,CEVEGH/15/,
		CEVFOR/16/,CEVSCL/17/,CEVZGI/18/,CEVZGO/19/,
		CEVSTE/20/,CEVMRS/21/,CEVPIN/22/,CEVINQ/23/,
		CEVFOL/24/
#
	DATA XRMASK/o'377'/,XDMASK/o'76000'/,XFMASK/3/
	DATA XFSHFT/256/,XASHFT/256/
	DATA XNORM/1/,XNO/2/,XCOND/3/,XDOOR/4/
	DATA XELNT/1,2,3,3/,XLFLAG/o'100000'/
	DATA XMIN/o'2000'/,XMAX/o'40000'/,XUP/o'22000'/,XDOWN/o'24000'/
	DATA XNORTH/o'2000'/,XSOUTH/o'12000'/,XENTER/o'32000'/,XEXIT/o'34000'/
#
	DATA PLAYER/1/,AROBOT/2/,AMASTR/3/
	DATA ASTAG/o'100000'/
#
	DATA RSEEN/o'100000'/,RLIGHT/o'40000'/,RLAND/o'20000'/
	DATA RWATER/o'10000'/,RAIR/o'4000'/,RSACRD/o'2000'/,RFILL/o'1000'/
	DATA RMUNG/o'400'/,RBUCK/o'200'/,RHOUSE/o'100'/,RNWALL/o'40'/,REND/o'20'/
#
	DATA WHOUS/2/,LROOM/8/,CELLA/9/
	DATA MTROL/10/,MAZE1/11/
	DATA MGRAT/25/,MAZ15/30/
	DATA FORE1/31/,FORE3/33/,CLEAR/36/,RESER/40/
	DATA STREA/42/,EGYPT/44/,ECHOR/49/
	DATA TSHAF/61/
	DATA BSHAF/76/,MMACH/77/,DOME/79/,MTORC/80/
	DATA CAROU/83/
	DATA RIDDL/91/,LLD2/94/,TEMP1/96/,TEMP2/97/,MAINT/100/
	DATA MCYCL/101/,BLROO/102/,TREAS/103/,RIVR1/107/,RIVR2/108/
	DATA 	RIVR3/109/
	DATA RIVR4/112/,RIVR5/113/,FCHMP/114/,MBARR/119/,FALLS/120/
	DATA MRAIN/121/,POG/122/,VLBOT/126/,VAIR1/127/,VAIR2/128/
	DATA 	VAIR3/129/,VAIR4/130/
	DATA LEDG2/131/,LEDG3/132/,LEDG4/133/,MSAFE/135/,CAGER/140/
	DATA CAGED/141/,TWELL/142/,BWELL/143/,ALICE/144/,ALISM/145/
	DATA 	ALITR/146/,MTREE/147/,BKENT/148/
	DATA BKVW/151/,BKTWI/153/,BKVAU/154/,BKBOX/155/
	DATA	CRYPT/157/,TSTRS/158/,MRANT/159/
	DATA MREYE/160/,MRA/161/,MRB/162/,MRC/163/,MRG/164/
	DATA	MRD/165/,FDOOR/166/,MRAE/167/
	DATA MRCE/171/,MRCW/172/,MRGE/173/,MRGW/174/,MRDW/176/
	DATA	INMIR/177/,SCORR/179/
	DATA NCORR/182/,PARAP/183/,CELL/184/,PCELL/185/,NCELL/186/
#
	DATA CINTW/1/,DEADXW/2/,FRSTQW/3/,INXW/4/
	DATA OUTXW/5/,WALKIW/6/,FIGHTW/7/,FOOW/8/
#
	DATA READW/100/,MELTW/101/
	DATA INFLAW/102/,DEFLAW/103/,ALARMW/104/,EXORCW/105/
	DATA PLUGW/106/,KICKW/107/,WAVEW/108/,RAISEW/109/,LOWERW/110/
	DATA RUBW/111/,PUSHW/112/,UNTIEW/113/,TIEW/114/,TIEUPW/115/
	DATA TURNW/116/,BREATW/117/,KNOCKW/118/,LOOKW/119/
	DATA EXAMIW/120/,SHAKEW/121/,MOVEW/122/,TRNONW/123/,TRNOFW/124/
	DATA OPENW/125/,CLOSEW/126/,FINDW/127/,WAITW/128/,SPINW/129/
	DATA BOARDW/130/,UNBOAW/131/,TAKEW/132/,INVENW/133/
	DATA FILLW/134/,EATW/135/,DRINKW/136/,BURNW/137/
	DATA MUNGW/138/,KILLW/139/,ATTACW/141/
	DATA SWINGW/140/,WALKW/142/,TELLW/143/,PUTW/144/
	DATA DROPW/145/,GIVEW/146/,POURW/147/,THROWW/148/
#
	DATA DIGW/89/,LEAPW/91/,STAYW/73/,FOLLOW/85/
	DATA HELLOW/151/,LOOKIW/152/,LOOKUW/153/,PUMPW/154/
	DATA WINDW/155/,CLMBW/156/,CLMBUW/157/,CLMBDW/158/,TRNTOW/159/
#
	DATA VISIBT/o'100000'/,READBT/o'40000'/,TAKEBT/o'20000'/,DOORBT/o'10000'/,
		TRANBT/o'4000'/,FOODBT/o'2000'/,NDSCBT/o'1000'/,DRNKBT/o'400'/,
		CONTBT/o'200'/,LITEBT/o'100'/,VICTBT/o'40'/,BURNBT/o'20'/,
		FLAMBT/o'10'/,TOOLBT/o'4'/,TURNBT/o'2'/,ONBT/o'1'/
#
	DATA FINDBT/o'100000'/,SLEPBT/o'40000'/,SCRDBT/o'20000'/,TIEBT/o'10000'/,
		CLMBBT/o'4000'/,ACTRBT/o'2000'/,WEAPBT/o'1000'/,FITEBT/o'400'/,
		VILLBT/o'200'/,STAGBT/o'100'/,TRYBT/o'40'/,NOCHBT/o'20'/,
		OPENBT/o'10'/,TCHBT/o'4'/,VEHBT/o'2'/,SCHBT/o'1'/
#
	DATA GARLI/2/,FOOD/3/,GUNK/4/,COAL/5/,MACHI/7/,DIAMO/8/
	DATA	TCASE/9/,BOTTL/10/
	DATA WATER/11/,ROPE/12/,KNIFE/13/,SWORD/14/,LAMP/15/,BLAMP/16/
	DATA	RUG/17/,LEAVE/18/,TROLL/19/,AXE/20/
	DATA RKNIF/21/,KEYS/23/,BAR/26/,ICE/30/
	DATA COFFI/33/,TORCH/34/,TBASK/35/,FBASK/36/,IRBOX/39/
	DATA GHOST/42/,TRUNK/45/,BELL/46/,BOOK/47/,CANDL/48/
	DATA MATCH/51/,TUBE/54/,PUTTY/55/,WRENC/56/,SCREW/57/
	DATA	CYCLO/58/,CHALI/59/
	DATA THIEF/61/,STILL/62/,WINDO/63/,GRATE/65/,DOOR/66/
	DATA HPOLE/71/,RBUTT/79/,LEAK/78/,RAILI/75/
	DATA POT/85/,STATU/86/,IBOAT/87/,DBOAT/88/,PUMP/89/,RBOAT/90/
	DATA STICK/92/,BUOY/94/,SHOVE/96/,GUANO/97/,BALLO/98/,RECEP/99/
	DATA BROPE/101/,HOOK1/102/,HOOK2/103/,SAFE/105/,SSLOT/107/
	DATA	BRICK/109/,FUSE/110/
	DATA GNOME/111/,BLABE/112/,DBALL/113/,TOMB/119/
	DATA LCASE/123/,CAGE/124/,RCAGE/125/,SPHER/126/,SQBUT/127/
	DATA FLASK/132/,POOL/133/,SAFFR/134/,BUCKE/137/,ORICE/139/
	DATA	ECAKE/138/,RDICE/140/
	DATA BLICE/141/,ROBOT/142/,FTREE/145/,BILLS/148/,PORTR/149/
	DATA SCOL/151/,ZGNOM/152/,EGG/154/,BEGG/155/,BAUBL/156/
	DATA	CANAR/157/,BCANA/158/,YLWAL/159/
	DATA RDWAL/161/,PINDR/164/
	DATA RBEAM/171/,ODOOR/172/,QDOOR/173/,CDOOR/175/
	DATA	NUM1/178/,NUM8/185/
	DATA ITOBJ/187/,OPLAY/188/,EVERY/189/
	DATA	VALUA/190/,SAILO/191/,TEETH/192/,WALL/193/
	DATA HANDS/195/,LUNGS/196/,AVIAT/197/
	DATA WNORT/200/,GWATE/204/,MASTER/210/

# DUNGEON, PAGE 3
#
# 1) INITIALIZE DATA STRUCTURES
# 2) PLAY GAME
#
	CALL ERRSET(0)				#NO OV'FLO MESSAGES
	IF(INIT(X)) CALL GAME			#IF INIT, PLAY GAME.
	CALL EXIT				#DONE
	END
# GAME- MAIN COMMAND LOOP FOR DUNGEON
#
# DECLARATIONS
#
	SUBROUTINE GAME
	IMPLICIT INTEGER (A-Z)
	LOGICAL RMINFO,VAPPLI,RAPPLI,AAPPLI
	LOGICAL F,PARSE,FINDXT,XVEHIC,LIT
	LOGICAL SECHO(4),GDTSTR(3)
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	common  /spare/ccflg
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
	COMMON /STATE/ MOVES,DEATHS,RWSCOR,MXSCOR,MXLOAD,
		LTSHFT,BLOC,MUNGRM,HS,EGSCOR,EGMXSC
#
# MISCELLANEOUS VARIABLES
#
	LOGICAL INLINE
	COMMON /INPUT/ INLNT,INLINE(78)
	COMMON /CHAN/ INPCH,OUTCH,DBCH
#
# ROOMS
#
	COMMON /ROOMS/ RLNT,RDESC2,RDESC1(215),REXIT(215),
			RACTIO(215),RVAL(215),RFLAG(215)
	INTEGER RRAND(215)
	EQUIVALENCE (RVAL,RRAND)
#
	COMMON /RINDEX/ WHOUS,LROOM,CELLA
	COMMON /RINDEX/ MTROL,MAZE1	
	COMMON /RINDEX/ MGRAT,MAZ15	
	COMMON /RINDEX/ FORE1,FORE3,CLEAR,RESER
	COMMON /RINDEX/ STREA,EGYPT,ECHOR
	COMMON /RINDEX/ TSHAF	
	COMMON /RINDEX/ BSHAF,MMACH,DOME,MTORC
	COMMON /RINDEX/ CAROU	
	COMMON /RINDEX/ RIDDL,LLD2,TEMP1,TEMP2,MAINT
	COMMON /RINDEX/ BLROO,TREAS,RIVR1,RIVR2,RIVR3,MCYCL
	COMMON /RINDEX/ RIVR4,RIVR5,FCHMP,FALLS,MBARR
	COMMON /RINDEX/ MRAIN,POG,VLBOT,VAIR1,VAIR2,VAIR3,VAIR4
	COMMON /RINDEX/ LEDG2,LEDG3,LEDG4,MSAFE,CAGER
	COMMON /RINDEX/ CAGED,TWELL,BWELL,ALICE,ALISM,ALITR
	COMMON /RINDEX/ MTREE,BKENT,BKVW,BKTWI,BKVAU,BKBOX
	COMMON /RINDEX/ CRYPT,TSTRS,MRANT,MREYE
	COMMON /RINDEX/ MRA,MRB,MRC,MRG,MRD,FDOOR
	COMMON /RINDEX/ MRAE,MRCE,MRCW,MRGE,MRGW,MRDW,INMIR
	COMMON /RINDEX/ SCORR,NCORR,PARAP,CELL,PCELL,NCELL
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
		OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
	COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
	COMMON /OINDEX/ WATER,ROPE,KNIFE,SWORD,LAMP,BLAMP,RUG
	COMMON /OINDEX/	LEAVE,TROLL,AXE
	COMMON /OINDEX/ RKNIF,KEYS,ICE,BAR
	COMMON /OINDEX/ COFFI,TORCH,TBASK,FBASK,IRBOX
	COMMON /OINDEX/ GHOST,TRUNK,BELL,BOOK,CANDL
	COMMON /OINDEX/ MATCH,TUBE,PUTTY,WRENC,SCREW,CYCLO,CHALI
	COMMON /OINDEX/ THIEF,STILL,WINDO,GRATE,DOOR
	COMMON /OINDEX/ HPOLE,LEAK,RBUTT,RAILI
	COMMON /OINDEX/ POT,STATU,IBOAT,DBOAT,PUMP,RBOAT
	COMMON /OINDEX/ STICK,BUOY,SHOVE,BALLO,RECEP,GUANO
	COMMON /OINDEX/ BROPE,HOOK1,HOOK2,SAFE,SSLOT,BRICK,FUSE
	COMMON /OINDEX/ GNOME,BLABE,DBALL,TOMB
	COMMON /OINDEX/ LCASE,CAGE,RCAGE,SPHER,SQBUT
	COMMON /OINDEX/ FLASK,POOL,SAFFR,BUCKE,ECAKE,ORICE,RDICE,BLICE
	COMMON /OINDEX/ ROBOT,FTREE,BILLS,PORTR,SCOL,ZGNOM
	COMMON /OINDEX/ EGG,BEGG,BAUBL,CANAR,BCANA
	COMMON /OINDEX/ YLWAL,RDWAL,PINDR,RBEAM
	COMMON /OINDEX/ ODOOR,QDOOR,CDOOR,NUM1,NUM8
	COMMON /OINDEX/ HANDS,WALL,LUNGS,SAILO,AVIAT,TEETH
	COMMON /OINDEX/ ITOBJ,EVERY,VALUA,OPLAY,WNORT,GWATE,MASTER
#
# ADVENTURERS
#
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
		AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
#
	COMMON /AINDEX/ PLAYER,AROBOT,AMASTR
#
# VERBS
#
	COMMON /VINDEX/ CINTW,DEADXW,FRSTQW,INXW,OUTXW
	COMMON /VINDEX/ WALKIW,FIGHTW,FOOW
	COMMON /VINDEX/ MELTW,READW,INFLAW,DEFLAW,ALARMW,EXORCW
	COMMON /VINDEX/ PLUGW,KICKW,WAVEW,RAISEW,LOWERW,RUBW
	COMMON /VINDEX/ PUSHW,UNTIEW,TIEW,TIEUPW,TURNW,BREATW
	COMMON /VINDEX/ KNOCKW,LOOKW,EXAMIW,SHAKEW,MOVEW,TRNONW,TRNOFW
	COMMON /VINDEX/ OPENW,CLOSEW,FINDW,WAITW,SPINW,BOARDW,UNBOAW,TAKEW
	COMMON /VINDEX/ INVENW,FILLW,EATW,DRINKW,BURNW
	COMMON /VINDEX/ MUNGW,KILLW,ATTACW,SWINGW
	COMMON /VINDEX/ WALKW,TELLW,PUTW,DROPW,GIVEW,POURW,THROWW
	COMMON /VINDEX/ DIGW,LEAPW,STAYW,FOLLOW
	COMMON /VINDEX/ HELLOW,LOOKIW,LOOKUW,PUMPW,WINDW
	COMMON /VINDEX/ CLMBW,CLMBUW,CLMBDW,TRNTOW
#
# FLAGS
#
	LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL FOLLWF,SPELLF,sprf
	COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
		DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
		MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
		EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
		GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
		GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
		MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
		follwf,spellf,sprf(6)
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL
#
# FUNCTIONS AND DATA
#
	DATA SECHO/'E','C','H','O'/
	DATA GDTSTR/'G','D','T'/

# GAME, PAGE 2
#
# START UP, DESCRIBE CURRENT LOCATION.
#
	CALL RSPEAK(1)				#WELCOME ABOARD.
	F=RMINFO(.TRUE.)			#START GAME.
#
# NOW LOOP, READING AND EXECUTING COMMANDS.
#
100	WINNER=PLAYER				#PLAYER MOVING.
	TELFLG=.FALSE.				#ASSUME NOTHING TOLD.
	IF(PRSCON.LE.1) CALL RDLINE(INLINE,INLNT,1)	#READ COMMAND.
#
	DO I=1,3 {				#CALL ON GDT?
	  IF(INLINE(I+PRSCON-1).NE.GDTSTR(I)) GO TO 200
	  }
	CALL GDT				#YES, INVOKE.
	GO TO 100				#ONWARD.
#
200	MOVES=MOVES+1
	PRSWON=PARSE(INLINE,INLNT,.TRUE.)	#PARSE INPUT, NORMAL MODE.
	IF(.NOT.PRSWON) GO TO 400		#PARSE LOSES?
	IF(XVEHIC(1)) GO TO 400			#VEHICLE HANDLE?
#
	IF(PRSA.EQ.TELLW) GO TO 2000		#TELL?
300	IF((PRSO.EQ.VALUA).OR.(PRSO.EQ.EVERY)) GO TO 900
	prsab=prsa
	IF(.NOT.VAPPLI(PRsab)) GO TO 400	#VERB OK?
350	IF(.NOT.ECHOF.AND.(HERE.EQ.ECHOR)) GO TO 1000
	F=RAPPLI(RACTIO(HERE))
#
400	CALL XENDMV(TELFLG)			#DO END OF MOVE.
	IF(.NOT.LIT(HERE)) PRSCON=1
	GO TO 100
#
900	CALL VALUAC(VALUA)
	GO TO 350

# GAME, PAGE 3
#
# SPECIAL CASE-- ECHO ROOM.
# IF INPUT IS NOT 'ECHO' OR A DIRECTION, JUST ECHO.
#
1000	CALL RDLINE(INLINE,INLNT,0)		#READ LINE.
	MOVES=MOVES+1				#CHARGE FOR MOVES.
	DO I=1,4 {				#INPUT = ECHO?
	  IF(INLINE(I).NE.SECHO(I)) GO TO 1300
	  }
#
	DO I=5,78 {				#REST BLANK?
	  IF(INLINE(I).NE.' ') GO TO 1300
	  }
#
	CALL RSPEAK(571)			#KILL THE ECHO.
	ECHOF=.TRUE.
	OFLAG2(BAR)=AND(OFLAG2(BAR),NOT(SCRDBT))	#LET THIEF STEAL BAR.
	PRSWON=.TRUE.				#FAKE OUT PARSER.
	PRSCON=1				#FORCE NEW INPUT.
	GO TO 400
#
1300	PRSWON=PARSE(INLINE,INLNT,.FALSE.)	#PARSE INPUT, ECHO MODE.
	IF(.NOT.PRSWON .OR. (PRSA.NE.WALKW)) {
		GO TO 1400			#WALK?
		}
	IF(FINDXT(PRSO,HERE)) GO TO 300		#VALID EXIT?
#
1400	WRITE(OUTCH,1410) (INLINE(J),J=1,INLNT)	#ECHO INPUT.
1410	FORMAT('+',78A1)
	ccflg=.false.
	TELFLG=.TRUE.				#INDICATE OUTPUT.
	GO TO 1000				#MORE ECHO ROOM.

# GAME, PAGE 4
#
# SPECIAL CASE-- TELL <ACTOR>, NEW COMMAND
# NOTE THAT WE CANNOT BE IN THE ECHO ROOM.
#
2000	IF(AND(OFLAG2(PRSO),ACTRBT).NE.0) GO TO 2100	#ACTOR?
	CALL RSPEAK(602)			#CANT DO IT.
	GO TO 350				#VAPPLI SUCCEEDS.
#
2100	WINNER=OACTOR(PRSO)			#NEW PLAYER.
	HERE=AROOM(WINNER)			#NEW LOCATION.
	IF(PRSCON.LE.1) GO TO 2700		#ANY INPUT?
	IF(PARSE(INLINE,INLNT,.TRUE.)) GO TO 2150	#PARSE COMMAND.
2700	I=341					#FAILS.
	IF(TELFLG) I=604			#GIVE RESPONSE.
	CALL RSPEAK(I)
2600	WINNER=PLAYER				#RESTORE STATE.
	HERE=AROOM(WINNER)
	GO TO 350
#
2150	IF(AAPPLI(AACTIO(WINNER))) GO TO 2400	#ACTOR HANDLE?
	IF(XVEHIC(1)) GO TO 2400		#VEHICLE HANDLE?
	IF((PRSO.EQ.VALUA).OR.(PRSO.EQ.EVERY)) GO TO 2900
	IF(.NOT.VAPPLI(PRSA)) GO TO 2400	#VERB HANDLE?
2350	F=RAPPLI(RACTIO(HERE))
#
2400	CALL XENDMV(TELFLG)			#DO END OF MOVE.
	GO TO 2600				#DONE.
#
2900	CALL VALUAC(VALUA)			#ALL OR VALUABLES.
	GO TO 350
#
	END

# XENDMV-	EXECUTE END OF MOVE FUNCTIONS.
#
# DECLARATIONS
#
	SUBROUTINE XENDMV(FLAG)
	IMPLICIT INTEGER(A-Z)
	LOGICAL F,CLOCKD,FLAG,XVEHIC
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSO,PRSI,PRSWON,PRSCON
#
# VILLAINS AND DEMONS
#
	LOGICAL THFFLG,SWDACT,THFACT
	COMMON /HACK/ THFPOS,THFFLG,THFACT,SWDACT,SWDSTA
#
	IF(.NOT.FLAG) CALL RSPEAK(341)		#DEFAULT REMARK.
	IF(THFACT) CALL THIEFD			#THIEF DEMON.
	IF(PRSWON) CALL FIGHTD			#FIGHT DEMON.
	IF(SWDACT) CALL SWORDD			#SWORD DEMON.
	IF(PRSWON) F=CLOCKD(X)			#CLOCK DEMON.
	IF(PRSWON) F=XVEHIC(2)			#VEHICLE READOUT.
	RETURN
	END

# XVEHIC- EXECUTE VEHICLE FUNCTION
#
# DECLARATIONS
#
	LOGICAL FUNCTION XVEHIC(N)
	IMPLICIT INTEGER(A-Z)
	LOGICAL OAPPLI
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
		OADV(250),OCAN(250),OREAD(250)
#
# ADVENTURERS
#
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
		AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
#
	XVEHIC=.FALSE.				#ASSUME LOSES.
	AV=AVEHIC(WINNER)			#GET VEHICLE.
	IF(AV.NE.0) XVEHIC=OAPPLI(OACTIO(AV),N)
	RETURN
	END

# RSPEAK-- OUTPUT RANDOM MESSAGE ROUTINE
#
# CALLED BY--
#
#	CALL RSPEAK(MSGNUM)
#
	SUBROUTINE RSPEAK(N)
	IMPLICIT INTEGER(A-Z)
#
	CALL RSPSB2(N,0,0)
	RETURN
	END

# RSPSUB-- OUTPUT RANDOM MESSAGE WITH SUBSTITUTABLE ARGUMENT
#
# CALLED BY--
#
#	CALL RSPSUB(MSGNUM,SUBNUM)
#
	SUBROUTINE RSPSUB(N,S1)
	IMPLICIT INTEGER(A-Z)
#
	CALL RSPSB2(N,S1,0)
	RETURN
	END

# RSPSB2-- OUTPUT RANDOM MESSAGE WITH SUBSTITUTABLE ARGUMENTS
#
# CALLED BY--
#
#	CALL RSPSB2(MSGNUM,S1,S2)
#
	SUBROUTINE RSPSB2(A,B,C)
	IMPLICIT INTEGER(A-Z)
	LOGICAL B1(78),B2(78)
	integer bx(16),by(16)
#
# DECLARATIONS
#
	LOGICAL TELFLG,CCFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
	COMMON /SPARE/CCFLG
#
	COMMON /RMSG/ MLNT,RTEXT(1050)
	COMMON /CHAN/ INPCH,OUTCH,DBCH
#
# CONVERT ALL ARGUMENTS FROM DICTIONARY NUMBERS (IF POSITIVE)
# TO ABSOLUTE RECORD NUMBERS.
#
	X=A					#SET UP WORK VARIABLES.
	Y=B
	Z=C
	IF(X.GT.0) X=RTEXT(X)			#IF >0, LOOK UP IN RTEXT.
	IF(Y.GT.0) Y=RTEXT(Y)
	IF(Z.GT.0) Z=RTEXT(Z)
	X=IABS(X)				#TAKE ABS VALUE.
	Y=IABS(Y)
	Z=IABS(Z)
	IF(X.EQ.0) RETURN			#ANYTHING TO DO?
	TELFLG=.TRUE.				#SAID SOMETHING.
#
	READ(DBCH,REC=X) OLDREC,bx			#READ FIRST LINE.
200	len=78
	call decrpt(x,b1,len,bx)
250	IF(Y.EQ.0) GO TO 400			#ANY SUBSTITUTABLE?
	DO I=1,78 {				#YES, LOOK FOR #.
	  IF(B1(I).EQ.'#') GO TO 1000
	  }
#
400	DO I=len,1,-1 {				#BACKSCAN FOR BLANKS.
	  IF(B1(I).NE.' ') GO TO 600
	  }
#
600	IF(.NOT.CCFLG)WRITE(OUTCH,610)
610	FORMAT(' ')
	WRITE(OUTCH,650) (B1(J),J=1,I)		#OUTPUT LINE.
650	FORMAT('+',78A1)
	CCFLG=.FALSE.
	X=X+1					#ON TO NEXT RECORD.
	READ(DBCH,REC=X) NEWREC,bx		#READ NEXT RECORD.
	IF(OLDREC.EQ.NEWREC) GO TO 200		#CONTINUATION?
	RETURN					#NO, EXIT.
#
# SUBSTITUTION WITH SUBSTITUTABLE AVAILABLE.
# I IS INDEX OF # IN B1.
# Y IS NUMBER OF RECORD TO SUBSTITUTE.
#
# PROCEDURE:
#   1) COPY REST OF B1 TO B2
#   2) READ SUBSTITUTABLE OVER B1
#   3) RESTORE TAIL OF ORIGINAL B1
#
# THE IMPLICIT ASSUMPTION HERE IS THAT THE SUBSTITUTABLE STRING
# IS VERY SHORT.
#
1000	K2=1					#TO
	DO K1=I+1,78 {				#COPY REST OF B1.
	  B2(K2)=B1(K1)
	  K2=K2+1
	  }
#
	READ(DBCH,REC=Y) J,by
	len2=78-i+1
	call decrpt(y,b1(i),len2,by)
#
	DO J=78,1,-1 {				#ELIM TRAILING BLANKS.
	  IF(B1(J).NE.' ') GO TO 1300
	  }
#
1300	K1=1					#FROM
	DO K2=J+1,78 {				#COPY REST OF B1 BACK.
	  B1(K2)=B2(K1)
	  K1=K1+1
	  }
#
	Y=Z					#SET UP FOR NEXT
	Z=0					#SUBSTITUTION AND
	GO TO 250				#RECHECK LINE.
#
	END

# OBJACT-- APPLY OBJECTS FROM PARSE VECTOR
#
# DECLARATIONS
#
	LOGICAL FUNCTION OBJACT(X)
	IMPLICIT INTEGER (A-Z)
	LOGICAL OAPPLI
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
		OADV(250),OCAN(250),OREAD(250)
#
	OBJACT=.TRUE.				#ASSUME WINS.
	IF(PRSI.EQ.0) GO TO 100			#IND OBJECT?
	IF(OAPPLI(OACTIO(PRSI),0)) RETURN	#YES, LET IT HANDLE.
#
100	IF(PRSO.EQ.0) GO TO 200			#DIR OBJECT?
	IF(OAPPLI(OACTIO(PRSO),0)) RETURN	#YES, LET IT HANDLE.
#
200	OBJACT=.FALSE.				#LOSES.
	RETURN
	END

# BUG-- REPORT FATAL SYSTEM ERROR
#
# CALLED BY--
#
#	CALL BUG(NO,PAR)
#
	SUBROUTINE BUG(A,B)
	IMPLICIT INTEGER(A-Z)
#
	COMMON /DEBUG/ DBGFLG
#
	TYPE 100,A,B
	IF(DBGFLG.NE.0) RETURN
	CALL EXIT
#
100	FORMAT(' PROGRAM ERROR ',I2,', PARAMETER=',I6)
	END

# NEWSTA-- SET NEW STATUS FOR OBJECT
#
# CALLED BY--
#
#	CALL NEWSTA(OBJECT,STRING,NEWROOM,NEWCON,NEWADV)
#
	SUBROUTINE NEWSTA(O,R,RM,CN,AD)
	IMPLICIT INTEGER(A-Z)
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
		OADV(250),OCAN(250),OREAD(250)
#
	CALL RSPEAK(R)
	OROOM(O)=RM
	OCAN(O)=CN
	OADV(O)=AD
	RETURN
	END

# QHERE-- TEST FOR OBJECT IN ROOM
#
# DECLARATIONS
#
	LOGICAL FUNCTION QHERE(OBJ,RM)
	IMPLICIT INTEGER (A-Z)
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
		OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OROOM2/ R2LNT,O2(15),R2(15)
#
	QHERE=.TRUE.
	IF(OROOM(OBJ).EQ.RM) RETURN		#IN ROOM?
	DO I=1,R2LNT {				#NO, SCH ROOM2.
	  IF((O2(I).EQ.OBJ).AND.(R2(I).EQ.RM)) RETURN
	  }
	QHERE=.FALSE.				#NOT PRESENT.
	RETURN
	END

# QEMPTY-- TEST FOR OBJECT EMPTY
#
# DECLARATIONS
#
	LOGICAL FUNCTION QEMPTY(OBJ)
	IMPLICIT INTEGER (A-Z)
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
		OADV(250),OCAN(250),OREAD(250)
#
	QEMPTY=.FALSE.				#ASSUME LOSE.
	DO I=1,OLNT {
	  IF(OCAN(I).EQ.OBJ) RETURN		#INSIDE TARGET?
	  }
	QEMPTY=.TRUE.
	RETURN
	END

# JIGSUP- YOU ARE DEAD
#
# DECLARATIONS
#
	SUBROUTINE JIGSUP(DESC)
	IMPLICIT INTEGER (A-Z)
	LOGICAL YESNO,MOVETO,QHERE,F
	INTEGER RLIST(9)
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
	COMMON /STATE/ MOVES,DEATHS,RWSCOR,MXSCOR,MXLOAD,
		LTSHFT,BLOC,MUNGRM,HS,EGSCOR,EGMXSC
#
	COMMON /CHAN/ INPCH,OUTCH,DBCH
	COMMON /DEBUG/ DBGFLG
#
# ROOMS
#
	COMMON /ROOMS/ RLNT,RDESC2,RDESC1(215),REXIT(215),
		RACTIO(215),RVAL(215),RFLAG(215)
	INTEGER RRAND(215)
	EQUIVALENCE (RVAL,RRAND)
#
	COMMON /RFLAG/ RSEEN,RLIGHT,RLAND,RWATER,RAIR,
		RSACRD,RFILL,RMUNG,RBUCK,RHOUSE,RNWALL,REND
#
	COMMON /RINDEX/ WHOUS,LROOM,CELLA
	COMMON /RINDEX/ MTROL,MAZE1	
	COMMON /RINDEX/ MGRAT,MAZ15	
	COMMON /RINDEX/ FORE1,FORE3,CLEAR,RESER
	COMMON /RINDEX/ STREA,EGYPT,ECHOR
	COMMON /RINDEX/ TSHAF	
	COMMON /RINDEX/ BSHAF,MMACH,DOME,MTORC
	COMMON /RINDEX/ CAROU	
	COMMON /RINDEX/ RIDDL,LLD2,TEMP1,TEMP2,MAINT
	COMMON /RINDEX/ BLROO,TREAS,RIVR1,RIVR2,RIVR3,MCYCL
	COMMON /RINDEX/ RIVR4,RIVR5,FCHMP,FALLS,MBARR
	COMMON /RINDEX/ MRAIN,POG,VLBOT,VAIR1,VAIR2,VAIR3,VAIR4
	COMMON /RINDEX/ LEDG2,LEDG3,LEDG4,MSAFE,CAGER
	COMMON /RINDEX/ CAGED,TWELL,BWELL,ALICE,ALISM,ALITR
	COMMON /RINDEX/ MTREE,BKENT,BKVW,BKTWI,BKVAU,BKBOX
	COMMON /RINDEX/ CRYPT,TSTRS,MRANT,MREYE
	COMMON /RINDEX/ MRA,MRB,MRC,MRG,MRD,FDOOR
	COMMON /RINDEX/ MRAE,MRCE,MRCW,MRGE,MRGW,MRDW,INMIR
	COMMON /RINDEX/ SCORR,NCORR,PARAP,CELL,PCELL,NCELL
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
		OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
	COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
	COMMON /OINDEX/ WATER,ROPE,KNIFE,SWORD,LAMP,BLAMP,RUG
	COMMON /OINDEX/	LEAVE,TROLL,AXE
	COMMON /OINDEX/ RKNIF,KEYS,ICE,BAR
	COMMON /OINDEX/ COFFI,TORCH,TBASK,FBASK,IRBOX
	COMMON /OINDEX/ GHOST,TRUNK,BELL,BOOK,CANDL
	COMMON /OINDEX/ MATCH,TUBE,PUTTY,WRENC,SCREW,CYCLO,CHALI
	COMMON /OINDEX/ THIEF,STILL,WINDO,GRATE,DOOR
	COMMON /OINDEX/ HPOLE,LEAK,RBUTT,RAILI
	COMMON /OINDEX/ POT,STATU,IBOAT,DBOAT,PUMP,RBOAT
	COMMON /OINDEX/ STICK,BUOY,SHOVE,BALLO,RECEP,GUANO
	COMMON /OINDEX/ BROPE,HOOK1,HOOK2,SAFE,SSLOT,BRICK,FUSE
	COMMON /OINDEX/ GNOME,BLABE,DBALL,TOMB
	COMMON /OINDEX/ LCASE,CAGE,RCAGE,SPHER,SQBUT
	COMMON /OINDEX/ FLASK,POOL,SAFFR,BUCKE,ECAKE,ORICE,RDICE,BLICE
	COMMON /OINDEX/ ROBOT,FTREE,BILLS,PORTR,SCOL,ZGNOM
	COMMON /OINDEX/ EGG,BEGG,BAUBL,CANAR,BCANA
	COMMON /OINDEX/ YLWAL,RDWAL,PINDR,RBEAM
	COMMON /OINDEX/ ODOOR,QDOOR,CDOOR,NUM1,NUM8
	COMMON /OINDEX/ HANDS,WALL,LUNGS,SAILO,AVIAT,TEETH
	COMMON /OINDEX/ ITOBJ,EVERY,VALUA,OPLAY,WNORT,GWATE,MASTER
#
# ADVENTURERS
#
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
		AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
#
	COMMON /AINDEX/ PLAYER,AROBOT,AMASTR
#
# FLAGS
#
	LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL FOLLWF,SPELLF,sprf
	COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
		DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
		MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
		EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
		GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
		GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
		MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
		follwf,spellf,sprf(6)
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL
#
# FUNCTIONS AND DATA
#
	DATA RLIST/8,6,36,35,34,4,34,6,5/

# JIGSUP, PAGE 2
#
	CALL RSPEAK(DESC)			#DESCRIBE SAD STATE.
	PRSCON=1				#STOP PARSER.
	IF(DBGFLG.NE.0) RETURN			#IF DBG, EXIT.
	AVEHIC(WINNER)=0			#GET RID OF VEHICLE.
	IF(WINNER.EQ.PLAYER) GO TO 100		#HIMSELF?
	CALL RSPSUB(432,ODESC2(AOBJ(WINNER)))	#NO, SAY WHO DIED.
	CALL NEWSTA(AOBJ(WINNER),0,0,0,0)	#SEND TO HYPER SPACE.
	RETURN
#
100	IF(ENDGMF) GO TO 900			#NO RECOVERY IN END GAME.
	IF(DEATHS.GE.2) GO TO 1000		#DEAD TWICE? KICK HIM OFF.
	IF(.NOT.YESNO(10,9,8)) GO TO 1100	#CONTINUE?
#
	DO J=1,OLNT {				#TURN OFF FIGHTING.
	  IF(QHERE(J,HERE)) OFLAG2(J)=AND(OFLAG2(J),NOT(FITEBT))
	  }
#
	DEATHS=DEATHS+1
	CALL SCRUPD(-10)			#CHARGE TEN POINTS.
	F=MOVETO(FORE1,WINNER)			#REPOSITION HIM.
	EGYPTF=.TRUE.				#RESTORE COFFIN.
	IF(OADV(COFFI).EQ.WINNER) CALL NEWSTA(COFFI,0,EGYPT,0,0)
	OFLAG2(DOOR)=AND(OFLAG2(DOOR),NOT(TCHBT))	#RESTORE DOOR.
	OFLAG1(ROBOT)=AND(OR(OFLAG1(ROBOT),VISIBT),NOT(NDSCBT))
	IF((OROOM(LAMP).NE.0).OR.(OADV(LAMP).EQ.WINNER)) {
		CALL NEWSTA(LAMP,0,LROOM,0,0)	#RESTORE LAMP.
		}
#
# NOW REDISTRIBUTE HIS VALUABLES AND OTHER BELONGINGS.
#
# THE LAMP HAS BEEN PLACED IN THE LIVING ROOM.
# THE FIRST 8 NON-VALUABLES ARE PLACED IN LOCATIONS AROUND THE HOUSE.
# HIS VALUABLES ARE PLACED AT THE END OF THE MAZE.
# REMAINING NON-VALUABLES ARE PLACED AT THE END OF THE MAZE.
#
	I=1
	DO J=1,OLNT {				#LOOP THRU OBJECTS.
	  IF((OADV(J).NE.WINNER).OR.(OTVAL(J).NE.0)) {
		GO TO 200			#GET HIS NON-VAL OBJS.
		}
	  I=I+1
	  IF(I.GT.9) GO TO 400			#MOVE TO RANDOM LOCATIONS.
	  CALL NEWSTA(J,0,RLIST(I),0,0)
	  }
#
400	I=RLNT+1				#NOW MOVE VALUABLES.
	NONOFL=RAIR+RWATER+RSACRD+REND		#DONT MOVE HERE.
	DO J=1,OLNT {
	  IF((OADV(J).NE.WINNER).OR.(OTVAL(J).EQ.0)) {
		NEXT				#ON ADV AND VALUABLE?
		}
250	  I=I-1					#FIND NEXT ROOM.
	  IF(AND(RFLAG(I),NONOFL).NE.0) GO TO 250	#SKIP IF NONO.
	  CALL NEWSTA(J,0,I,0,0)		#YES, MOVE.
	  }
#
	DO J=1,OLNT {				#NOW GET RID OF REMAINDER.
	  IF(OADV(J).NE.WINNER) NEXT
450	  I=I-1					#FIND NEXT ROOM.
	  IF(AND(RFLAG(I),NONOFL).NE.0) GO TO 450	#SKIP IF NONO.
	  CALL NEWSTA(J,0,I,0,0)
	  }
	RETURN
#
# CANT OR WONT CONTINUE, CLEAN UP AND EXIT.
#
900	CALL RSPEAK(625)			#IN ENDGAME, LOSE.
	GO TO 1100
#
1000	CALL RSPEAK(7)				#INVOLUNTARY EXIT.
1100	CALL SCORE(.FALSE.)			#TELL SCORE.
	CLOSE (UNIT=DBCH,DISPOSE='SAVE')
	CALL EXIT
#
	END

# OACTOR-	GET ACTOR ASSOCIATED WITH OBJECT
#
# DECLARATIONS
#
	INTEGER FUNCTION OACTOR(OBJ)
	IMPLICIT INTEGER(A-Z)
#
# ADVENTURERS
#
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
		AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
#
	DO I=1,ALNT {				#LOOP THRU ACTORS.
	  OACTOR=I				#ASSUME FOUND.
	  IF(AOBJ(I).EQ.OBJ) RETURN		#FOUND IT?
	  }
	CALL BUG(40,OBJ)			#NO, DIE.
	RETURN
	END

# PROB-		COMPUTE PROBABILITY
#
# DECLARATIONS
#
	LOGICAL FUNCTION PROB(G,B)
	IMPLICIT INTEGER(A-Z)
#
# FLAGS
#
	LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL FOLLWF,SPELLF,sprf
	COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
		DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
		MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
		EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
		GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
		GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
		MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
		follwf,spellf,sprf(6)
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL
#
	I=G					#ASSUME GOOD LUCK.
	IF(BADLKF) I=B				#IF BAD, TOO BAD.
	PROB=RND(100).LT.I			#COMPUTE.
	RETURN
	END

# RMINFO-- PRINT ROOM DESCRIPTION
#
# RMINFO PRINTS A DESCRIPTION OF THE CURRENT ROOM.
# IT IS ALSO THE PROCESSOR FOR VERBS 'LOOK' AND 'EXAMINE'.
#
	LOGICAL FUNCTION RMINFO(FULL)
#
# DECLARATIONS
#
	IMPLICIT INTEGER (A-Z)
	LOGICAL FULL,PROB,LIT,RAPPLI
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
#
# SCREEN OF LIGHT
#
	COMMON /SCREEN/ FROMDR,SCOLRM,SCOLAC
#
# ROOMS
#
	COMMON /ROOMS/ RLNT,RDESC2,RDESC1(215),REXIT(215),
		RACTIO(215),RVAL(215),RFLAG(215)
	INTEGER RRAND(215)
	EQUIVALENCE (RVAL,RRAND)
#
	COMMON /RFLAG/ RSEEN,RLIGHT,RLAND,RWATER,RAIR,
		RSACRD,RFILL,RMUNG,RBUCK,RHOUSE,RNWALL,REND
#
	COMMON /XSRCH/ XMIN,XMAX,XDOWN,XUP,
		XNORTH,XSOUTH,XENTER,XEXIT
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
		OADV(250),OCAN(250),OREAD(250)
#
# ADVENTURERS
#
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
		AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
#
	MON /AINDEX/ PLAYER,AROBOT,AMASTR
#
# VERBS
#
	COMMON /VINDEX/ CINTW,DEADXW,FRSTQW,INXW,OUTXW
	COMMON /VINDEX/ WALKIW,FIGHTW,FOOW
	COMMON /VINDEX/ MELTW,READW,INFLAW,DEFLAW,ALARMW,EXORCW
	COMMON /VINDEX/ PLUGW,KICKW,WAVEW,RAISEW,LOWERW,RUBW
	COMMON /VINDEX/ PUSHW,UNTIEW,TIEW,TIEUPW,TURNW,BREATW
	COMMON /VINDEX/ KNOCKW,LOOKW,EXAMIW,SHAKEW,MOVEW,TRNONW,TRNOFW
	COMMON /VINDEX/ OPENW,CLOSEW,FINDW,WAITW,SPINW,BOARDW,UNBOAW,TAKEW
	COMMON /VINDEX/ INVENW,FILLW,EATW,DRINKW,BURNW
	COMMON /VINDEX/ MUNGW,KILLW,ATTACW,SWINGW
	COMMON /VINDEX/ WALKW,TELLW,PUTW,DROPW,GIVEW,POURW,THROWW
	COMMON /VINDEX/ DIGW,LEAPW,STAYW,FOLLOW
	COMMON /VINDEX/ HELLOW,LOOKIW,LOOKUW,PUMPW,WINDW
	COMMON /VINDEX/ CLMBW,CLMBUW,CLMBDW,TRNTOW
#
# FLAGS
#
	LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL FOLLWF,SPELLF,sprf
	COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
		DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
		MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
		EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
		GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
		GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
		MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
		follwf,spellf,sprf(6)
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL

# RMINFO, PAGE 2
#
	RMINFO=.TRUE.				#ASSUME WINS.
	IF(PRSO.LT.XMIN) GO TO 50		#IF DIRECTION,
	FROMDR=PRSO				#SAVE AND
	PRSO=0					#CLEAR.
50	IF(HERE.EQ.AROOM(PLAYER)) GO TO 100	#PLAYER JUST MOVE?
	CALL RSPEAK(2)				#NO, JUST SAY DONE.
	PRSA=WALKIW				#SET UP WALK IN ACTION.
	RETURN
#
100	IF(LIT(HERE)) GO TO 300			#LIT?
	CALL RSPEAK(430)			#WARN OF GRUE.
	RMINFO=.FALSE.
	RETURN
#
300	RA=RACTIO(HERE)				#GET ROOM ACTION.
	I=RDESC2-HERE				#ASSUME SHORT DESC.
	IF(.NOT.FULL .AND. (SUPERF.OR.(((RFLAG(HERE).AND.RSEEN).NE.0)
		.AND. (BRIEFF.OR.PROB(80,80))))) GO TO 400
	I=RDESC1(HERE)				#USE LONG.
	IF((I.NE.0).OR.(RA.EQ.0)) GO TO 400	#IF GOT DESC, SKIP.
	PRSA=LOOKW				#PRETEND LOOK AROUND.
	IF(.NOT.RAPPLI(RA)) GO TO 100		#ROOM HANDLES, NEW DESC?
	PRSA=FOOW				#NOP PARSER.
	GO TO 500
#
400	CALL RSPEAK(I)				#OUTPUT DESCRIPTION.
500	IF(AVEHIC(WINNER).NE.0) CALL RSPSUB(431,ODESC2(AVEHIC(WINNER)))
	CALL PRINCR(FULL,HERE)			#PRINT CONTENTS OF ROOM.
	RFLAG(HERE)=RFLAG(HERE).OR.RSEEN	#INDICATE ROOM SEEN.
	IF(FULL.OR.(RA.EQ.0)) RETURN		#ANYTHING MORE?
	PRSA=WALKIW				#GIVE HIM A SURPISE.
	IF(.NOT.RAPPLI(RA)) GO TO 100		#ROOM HANDLES, NEW DESC?
	PRSA=FOOW
	RETURN
#
	END

# RAPPLI-	ROUTING ROUTINE FOR ROOM APPLICABLES
#
# DECLARATIONS
#
	LOGICAL FUNCTION RAPPLI(RI)
	IMPLICIT INTEGER(A-Z)
	LOGICAL RAPPL1,RAPPL2
	DATA NEWRMS/38/
#
	RAPPLI=.TRUE.				#ASSUME WINS.
	IF(RI.EQ.0) RETURN			#IF ZERO, WIN.
	IF(RI.LT.NEWRMS) RAPPLI=RAPPL1(RI)	#IF OLD, PROCESSOR 1.
	IF(RI.GE.NEWRMS) RAPPLI=RAPPL2(RI)	#IF NEW, PROCESSOR 2.
	RETURN
	END

#
#	decrpt - routine to decrpt the text files
#
	subroutine decrpt(rec,line,len,line2)
	implicit integer(a-z)
	dimension line2(16)
	dimension line(len)
	common /magic/magic

	crypt=XOR(magic,AND(rec,o'777'))*o'1001001001'

	do kj=16,1,-1 {
	  if(line2(kj).ne.0)goto 6
	}

6	do kc=1,kj {
	  line2(kc)=XOR(line2(kc),crypt)
	  }
	decode(len,9,line2)line
9	format(78a1)
	return
	end

# PROTCT-- CHECK FOR USER VIOLATION
#
# THIS ROUTINE SHOULD BE MODIFIED IF YOU WISH TO ADD SYSTEM
# DEPENDANT PROTECTION AGAINST ABUSE.
#
# AT THE MOMENT, PLAY IS PERMITTED UDER ALL CIRCUMSTANCES.
#
	LOGICAL FUNCTION PROTCT(X)
	IMPLICIT INTEGER(A-Z)
#
	PROTCT=.TRUE.
	RETURN
	END

#
# subroutine to encrypt the text file
#
	subroutine encrpt(rec,line,line2)
	implicit integer(a-z)
	dimension line2(16)
	dimension line(78)
	common /magic/ magic

	encode(78,9,line2)line
9	format(78a1)

	LINE2(16)=(LINE2(16)+AND('     ',77777))
	do kl=16,1,-1 {
	  if(line2(kl).eq.'     ')goto 8
	  kj=kl
	  goto 7
8	  line2(kl)=0
	}

7	crypt=XOR(magic,AND(rec,o'777'))*o'1001001001'
	do kc=1,kj {
	 line2(kc)=XOR(line2(kc),crypt)
	 }
	return
	end
# RDLINE-	READ INPUT LINE
#
# DECLARATIONS
#
	SUBROUTINE RDLINE(INBUF,INLNT,WHO)
	IMPLICIT INTEGER(A-Z)
	LOGICAL INBUF(78)
#
# PARSER OUTPUT
#
	LOGICAL PRSWON,CCFLG
	COMMON /SPARE/ CCFLG			#NEED FLAG TO SEE IF WE NEED CC
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
	COMMON /CHAN/ INPCH,OUTCH,DBCH
#
5	GO TO (90,10),WHO+1			#SEE WHO TO PROMPT FOR.
10	IF(.NOT.CCFLG)WRITE(OUTCH,7)
7	FORMAT(' ')
	WRITE(OUTCH,50)				#PROMPT FOR GAME.
50	FORMAT('+>')
#
90	READ(INPCH,100) INBUF			#GET INPUT.
100	FORMAT(78A1)
	CCFLG=.TRUE.				#SAY THAT WE HAVE DONE READ
#
	DO INLNT=78,1,-1 {
	  IF(INBUF(INLNT).NE.' ') GO TO 300	#NOT BLANK?
	  }
	GO TO 5					#TRY AGAIN.
#
300	DO I=1,INLNT {				#CONVERT TO UPPER CASE.
	  IF((INBUF(I).GE.'a').AND.(INBUF(I).LE.'z')) {
		INBUF(I)=INBUF(I)-o'200000000000'
		}
	  }
	PRSCON=1				#RESTART LEX SCAN.
	RETURN
	END

# PARSE-	TOP LEVEL PARSE ROUTINE
#
# DECLARATIONS
#
# THIS ROUTINE DETAILS ON BIT 0 OF PRSFLG
#
	LOGICAL FUNCTION PARSE(INBUF,INLNT,VBFLAG)
	IMPLICIT INTEGER(A-Z)
	LOGICAL INBUF(78)
	LOGICAL LEX,SYNMCH,DFLAG,VBFLAG
	INTEGER OUTBUF(40)
	COMMON /DEBUG/ DBGFLG,PRSFLG
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
	COMMON /LAST/ spv(4)
	COMMON /XSRCH/ XMIN,XMAX,XDOWN,XUP,
		XNORTH,XSOUTH,XENTER,XEXIT
#
#D	DFLAG=AND(PRSFLG,o'1').NE.0
	PARSE=.FALSE.				#ASSUME FAILS.
	PRSA=0					#ZERO OUTPUTS.
	PRSI=0
	PRSO=0
#
	IF(.NOT.LEX(INBUF,INLNT,OUTBUF,OUTLNT,VBFLAG)) GO TO 100
	IF(SPARSE(OUTBUF,OUTLNT,VBFLAG)) 100,200,300	#DO SYN SCAN.
#
# PARSE REQUIRES VALIDATION
#
200	IF(.NOT.VBFLAG) GO TO 350		#ECHO MODE, FORCE FAIL.
	IF(.NOT.SYNMCH(X)) GO TO 100		#DO SYN MATCH.
	IF((PRSO.GT.0).AND.(PRSO.LT.XMIN)) spv(1)=PRSO
#
# SUCCESSFUL PARSE OR SUCCESSFUL VALIDATION
#
300	PARSE=.TRUE.
350	CALL ORPHAN(0,0,0,0,0)			#CLEAR ORPHANS.
#D	IF(DFLAG) TYPE 10,PARSE,PRSA,PRSO,PRSI
#D10	FORMAT(' PARSE RESULTS- ',L7,3I7)
	SPV(2)=PRSA
	SPV(1)=PRSO
	SPV(3)=PRSI
	SPV(4)=.TRUE.
	RETURN
#
# PARSE FAILS, DISALLOW CONTINUATION
#
100	PRSCON=1
#D	IF(DFLAG) TYPE 10,PARSE,PRSA,PRSO,PRSI
	SPV(4)=.FALSE.
	RETURN
#
	END

# ORPHAN- SET UP NEW ORPHANS
#
# DECLARATIONS
#
	SUBROUTINE ORPHAN(O1,O2,O3,O4,O5)
	IMPLICIT INTEGER(A-Z)
	COMMON /ORPHS/ A,B,C,D,E
#
	A=O1					#SET UP NEW ORPHANS.
	B=O2
	C=O3
	D=O4
	E=O5
	RETURN
	END

# LEX-	LEXICAL ANALYZER
#
# DECLARATIONS
#
# THIS ROUTINE DETAILS ON BIT 1 OF PRSFLAG
#
	LOGICAL FUNCTION LEX(INBUF,INLNT,OUTBUF,OP,VBFLAG)
	IMPLICIT INTEGER(A-Z)
	LOGICAL INBUF(78),J
	INTEGER OUTBUF(40)
	LOGICAL DFLAG,VBFLAG
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
	COMMON /DEBUG/ DBGFLG,PRSFLG
#
	DO I=1,40 {				#CLEAR OUTPUT BUF.
	  OUTBUF(I)=0
	  }
#
#D	DFLAG=AND(PRSFLG,o'2').NE.0
	LEX=.FALSE.				#ASSUME LEX FAILS.
	OP=-1					#OUTPUT PTR.
50	OP=OP+2					#ADV OUTPUT PTR.
	CP=0					#CHAR PTR=0.
#
200	IF(PRSCON.GT.INLNT) GO TO 1000		#END OF INPUT?
	J=INBUF(PRSCON)				#NO, GET CHARACTER,
	PRSCON=PRSCON+1				#ADVANCE PTR.
	IF(J.EQ.'.') GO TO 1000			#END OF SENTENCE?
	IF(J.EQ.',') GO TO 2000			#END OF COMMAND?
	IF(J.EQ.' ') GO TO 6000			#SPACE?
	J1=G50(J)				#CONVERT TO R50
	IF(J1.NE.0) GO TO 4000
#
	IF(VBFLAG) CALL RSPEAK(601)		#GREEK TO ME, FAIL.
	RETURN
#
# END OF INPUT, SEE IF PARTIAL WORD AVAILABLE.
#
1000	PRSCON=1				#FORCE PARSE RESTART.
2000	IF((CP.EQ.0).AND.(OP.EQ.1)) RETURN	#ANY RESULTS?
	IF(CP.EQ.0) OP=OP-2			#ANY LAST WORD?
	LEX=.TRUE.
#D	IF(DFLAG) TYPE 10,CP,OP,PRSCON,(OUTBUF(I),I=1,OP+1)
#D10	FORMAT(' LEX RESULTS- ',3I7/1X,10O7)
	RETURN
#
# LEGITIMATE CHARACTERS: LETTER, DIGIT, OR HYPHEN.
#
4000	CONTINUE
#D	IF(DFLAG) TYPE 20,J,J1,CP
#D20	FORMAT(' LEX- CHAR= ',3I7)
	IF(CP.GE.6) GO TO 200			#IGNORE IF TOO MANY CHAR.
	K=OP+(CP/3)				#COMPUTE WORD INDEX.
	GO TO (4100,4200,4300),(MOD(CP,3)+1)	#BRANCH ON CHAR.
4100	J2=J1*780				#CHAR 1... *780
	OUTBUF(K)=OUTBUF(K)+J2+J2		#*1560 (40 ADDED BELOW).
4200	OUTBUF(K)=OUTBUF(K)+(J1*39)		#*39 (1 ADDED BELOW).
4300	OUTBUF(K)=OUTBUF(K)+J1			#*1.
	CP=CP+1
	GO TO 200				#GET NEXT CHAR.
#
# SPACE
#
6000	IF(CP.EQ.0) GO TO 200			#ANY WORD YET?
	GO TO 50				#YES, ADV OP.
#
	END
# SPARSE-	START OF PARSE
#
# DECLARATIONS
#
# THIS ROUTINE DETAILS ON BIT 2 OF PRSFLG
#
	INTEGER FUNCTION SPARSE(LBUF,LLNT,VBFLAG)
	IMPLICIT INTEGER(A-Z)
	INTEGER LBUF(40)
	LOGICAL LIT,QHERE,OTEST,DFLAG,VBFLAG
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
# PARSER STATE
#
	COMMON /ORPHS/ OFLAG,OACT,OSLOT,OPREP,ONAME
	COMMON /LAST/ spv(4)
	COMMON /PV/ ACT,O1,O2,P1,P2
	INTEGER OBJVEC(2),PRPVEC(2)
	EQUIVALENCE (OBJVEC(1),O1),(PRPVEC(1),P1)
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
	COMMON /DEBUG/ DBGFLG,PRSFLG
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
		OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
	COMMON /OINDEX/ WATER,ROPE,KNIFE,SWORD,LAMP,BLAMP,RUG
	COMMON /OINDEX/	LEAVE,TROLL,AXE
	COMMON /OINDEX/ RKNIF,KEYS,ICE,BAR
	COMMON /OINDEX/ COFFI,TORCH,TBASK,FBASK,IRBOX
	COMMON /OINDEX/ GHOST,TRUNK,BELL,BOOK,CANDL
	COMMON /OINDEX/ MATCH,TUBE,PUTTY,WRENC,SCREW,CYCLO,CHALI
	COMMON /OINDEX/ THIEF,STILL,WINDO,GRATE,DOOR
	COMMON /OINDEX/ HPOLE,LEAK,RBUTT,RAILI
	COMMON /OINDEX/ POT,STATU,IBOAT,DBOAT,PUMP,RBOAT
	COMMON /OINDEX/ STICK,BUOY,SHOVE,BALLO,RECEP,GUANO
	COMMON /OINDEX/ BROPE,HOOK1,HOOK2,SAFE,SSLOT,BRICK,FUSE
	COMMON /OINDEX/ GNOME,BLABE,DBALL,TOMB
	COMMON /OINDEX/ LCASE,CAGE,RCAGE,SPHER,SQBUT
	COMMON /OINDEX/ FLASK,POOL,SAFFR,BUCKE,ECAKE,ORICE,RDICE,BLICE
	COMMON /OINDEX/ ROBOT,FTREE,BILLS,PORTR,SCOL,ZGNOM
	COMMON /OINDEX/ EGG,BEGG,BAUBL,CANAR,BCANA
	COMMON /OINDEX/ YLWAL,RDWAL,PINDR,RBEAM
	COMMON /OINDEX/ ODOOR,QDOOR,CDOOR,NUM1,NUM8
	COMMON /OINDEX/ HANDS,WALL,LUNGS,SAILO,AVIAT,TEETH
	COMMON /OINDEX/ ITOBJ,EVERY,VALUA,OPLAY,WNORT,GWATE,MASTER
#
# ADVENTURERS
#
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
		AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
#
	COMMON /AINDEX/ PLAYER,AROBOT,AMASTR
#
# VERBS
#
	COMMON /VINDEX/ CINTW,DEADXW,FRSTQW,INXW,OUTXW
	COMMON /VINDEX/ WALKIW,FIGHTW,FOOW
	COMMON /VINDEX/ MELTW,READW,INFLAW,DEFLAW,ALARMW,EXORCW
	COMMON /VINDEX/ PLUGW,KICKW,WAVEW,RAISEW,LOWERW,RUBW
	COMMON /VINDEX/ PUSHW,UNTIEW,TIEW,TIEUPW,TURNW,BREATW
	COMMON /VINDEX/ KNOCKW,LOOKW,EXAMIW,SHAKEW,MOVEW,TRNONW,TRNOFW
	COMMON /VINDEX/ OPENW,CLOSEW,FINDW,WAITW,SPINW,BOARDW,UNBOAW,TAKEW
	COMMON /VINDEX/ INVENW,FILLW,EATW,DRINKW,BURNW
	COMMON /VINDEX/ MUNGW,KILLW,ATTACW,SWINGW
	COMMON /VINDEX/ WALKW,TELLW,PUTW,DROPW,GIVEW,POURW,THROWW
	COMMON /VINDEX/ DIGW,LEAPW,STAYW,FOLLOW
	COMMON /VINDEX/ HELLOW,LOOKIW,LOOKUW,PUMPW,WINDW
	COMMON /VINDEX/ CLMBW,CLMBUW,CLMBDW,TRNTOW

# SPARSE, PAGE 2
#
# VOCABULARIES
#
	COMMON /BUZVOC/ BVOC(20)
	COMMON /PRPVOC/ PVOC(45)
	COMMON /DIRVOC/ DVOC(75)
	INTEGER AVOC(400)
	COMMON /ADJVOC/ AVOC1(181),AVOC2(111),AVOC3(106),AVOCND
	INTEGER VVOC(900)
	COMMON /VRBVOC/ VVOC1(92),VVOC1A(118),VVOC2(104),VVOC3(136),
		VVOC4(116),VVOC5(134),VVOC6(117),VVOC7(89),VVOCND
	INTEGER OVOC(1050)
	COMMON /OBJVOC/ OVOC1(158),OVOC2(144),OVOC3(149),OVOC4(127),
		OVOC5(108),OVOC6(104),OVOC6A(91),OVOC7(124),OVOCND
#
	EQUIVALENCE (VVOC(1),VVOC1(1))
	EQUIVALENCE (AVOC(1),AVOC1(1))
	EQUIVALENCE (OVOC(1),OVOC1(1))
#
# FUNCTIONS AND DATA
#
	OTEST(R)=(R.GT.0).AND.(R.LT.R50MIN)
	DATA R50MIN/o'3100'/,R50WAL/'WAL'/
#
# BUZZ WORDS--	IGNORED IN SYNTACTIC PROCESSING
#
	DATA BVOC/'AND',0,'BY',0,'IS',0,'A',0,
		'AN',0,'THE',0,'RUN',0,'GO',0,'PRO','CEE',0,0/
#
# PREPOSITIONS--	MAPS PREPOSITIONS TO INDICES
#
	DATA PVOC/'OVE','R',1,'WIT','H',2,'USI','NG',2,'THR','OUG',2,
		'AT',0,3,'TO',0,4,'IN',0,5,'INS','IDE',5,'INT','O',5,
		'DOW','N',6,'UP',0,7,'UND','ER',8,'OF',0,9,'ON',0,10,
		'OFF',0,11/
#
# DIRECTIONS--	MAPS DIRECTIONS TO INDICES
#
	DATA DVOC/'N',0,o'2000','NOR','TH',o'2000','S',0,o'12000',
		'E',0,o'6000','EAS','T',o'6000','W',0,o'16000','WES','T',o'16000',
		'SE',0,o'10000','SW',0,o'14000',
		'NE',0,o'4000','NW',0,o'20000',
		'U',0,o'22000','UP',0,o'22000','D',0,o'24000','DOW','N',o'24000',
		'LAU','NCH',o'26000','LAN','D',o'30000','ENT','ER',o'32000',
		'EXI','T',o'34000','OUT',0,o'34000','LEA','VE',o'34000',
		'TRA','VEL',o'36000','SOU','TH',o'12000',
		'IN',0,o'32000',
		'CRO','SS',o'36000'/

# SPARSE, PAGE 3
#
# ADJECTIVES--	MAPS ADJECTIVES TO OBJECT NUMBERS
#
# EACH ENTRY IS VARIABLE LENGTH AND CONSISTS OF A TWO WORD
# ADJECTIVE IN RADIX-50 FOLLOWED BY ONE OR MORE OBJECT NUMBERS.
# NOTE THAT ADJECTIVES CAN BE DISTINGUISHED FROM OBJECTS AS
# FOLLOWS-- ALL ADJECTIVES ARE .GE. 'A (1600)', WHILE ALL OBJECTS
# ARE .LE. OLNT (255 MAX).
#
	DATA AVOC1/'BRO','WN',1,81,'ELO','NGA',1,'HOT',0,3,'PEP','PER',3,
		'VIT','REO',4,'JAD','E',6,'HUG','E',8,'ENO','RMO',8,122,
		'TRO','PHY',9,'CLE','AR',10,'LAR','GE',12,26,47,95,96,123,
		133,135,146,147,150,176,'NAS','TY',13,'ELV','ISH',14,
		'BRA','SS',15,16,46,156,
		'BRO','KEN',16,22,92,113,155,158,'ORI','ENT',17,
		'BLO','ODY',20,'RUS','TY',21,'BUR','NED',22,
		'DEA','D',22,'OLD',0,25,41,44,45,'LEA','THE',25,
		'PLA','TIN',26,'PEA','RL',27,
		'MOB','Y',31,'CRY','STA',32,126,'GOL','D',33,85,104,157,158,
		'IVO','RY',34,'SAP','PHI',37,'WOO','DEN',38,67,136,137,
		165,173,174,175,'WOO','D',38,67,136,137,165,173,174,175,
		'STE','EL',39,125,
		'DEN','TED',39,'FAN','CY',40,'ANC','IEN',41,44,
		'SMA','LL',5,46,52,53,89,102,103,153,
		'BLA','CK',47,162,'TOU','R',49,
		'VIS','COU',55,'VIC','IOU',62,
		 'GLA','SS',10,126,132,'TRA','P',66/
#
	DATA AVOC2/'FRO','NT',68,'STO','NE',69,150,209,'MAN','GLE',72,
		'RED',0,79,94,140,161,170,171,'YEL','LOW',80,159,
		'BLU','E',82,112,114,141,
		'VAM','PIR',83,'MAG','IC',90,
		'SEA','WOR',90,'TAN',0,91,'SHA','RP',92,
		'WIC','KER',98,'CLO','TH',100,
		'BRA','IDE',101,
		'GAU','DY',108,'SQU','ARE',109,127,'CLA','Y',109,
		'SHI','NY',110,'THI','N',110,
		'GRE','EN',115,143,'PUR','PLE',116,'WHI','TE',117,147,160,
		'MAR','BLE',119,'COK','E',121,
		'ROU','ND',128,'TRI','ANG',129,
 	2 'RAR','E',134,'OBL','ONG',135,'EAT','$ME',138,
		'EAT','ME',138,'ORA','NGE',139,'ECC','H',141/
#
	DATA AVOC3/'ROC','KY',147,'SHE','ER',147,
		'200',0,148,'NEA','T',148,'SHI','MME',151,
		'ZUR','ICH',152,'BIR','DS',153,154,155,
		'ENC','RUS',154,155,'BEA','UTI',156,'CLO','CKW',157,158,
		'MEC','HAN',157,158,'BAR','E',195,'SON','G',198,
		'MAH','OGA',163,'PIN','E',164,'LON','G',166,
		'CEN','TER',166,'SHO','RT',167,'T',0,168,
		'COM','PAS',169,206,'BRO','NZE',172,'CEL','L',174,175,
		'LOC','KED',174,'SUN',0,177,
		'NOR','TH',200,'NOR','THE',200,'SOU','TH',201,
		'SOU','THE',201,'EAS','T',202,'EAS','TER',202,
		'WES','T',203,'WES','TER',203,'DUN','GEO',210/
#
	DATA AVOCND/-1/

# SPARSE, PAGE 4
#
# VERBS--	MAPS VERBS TO SYNTAX SLOTS
#
# EACH ENTRY IS VARIABLE LENGTH AND CONSISTS OF ONE OR MORE
# TWO WORD VERBS IN RADIX-50 FOLLOWED BY A SYNTAX WORD COUNT
# FOLLOWED BY ONE OR MORE SYNTAXES.  NOTE THAT VERBS CAN BE
# DISTINGUISHED FROM WORD COUNTS AS FOLLOWS--
# ALL VERBS ARE .GE. 'A (1600)', WHILE ALL SYNTAX WORD COUNTS
# ARE .LE. 255.
#
# SYNTAX ENTRIES CONSIST OF A FLAG WORD FOLLOWED BY 0, 1, OR 2
# OBJECT DESCRIPTIONS.  THE FLAG WORD HAS THE FOLLOWING FORMAT--
#
# BIT <14>	IF 1, SYNTAX INCLUDES DIRECT OBJECT
# BIT <13>	IF 1, SYNTAX INCLUDES INDIRECT OBJECT
# BIT <12>	IF 1, DIRECT OBJECT IS IMPLICIT (STANDARD FORM)
# BIT <11>	IF 1, DIRECT AND INDIRECT OBJECT MUST BE SWAPPED
#			AFTER SYNTAX PROCESSING
# BIT <10>	IF 1, THIS IS DEFAULT SYNTAX FOR ORPHANERY
# BITS <8:0>	VERB NUMBER FOR VAPPLI
#
# OBJECT DESCRIPTIONS CONSIST OF A FLAG WORD AND TWO FWIM WORDS.
# THE FLAG WORD HAS THE FOLLOWING FORMAT--
#
# BIT <14>	IF 1, SEARCH ADVENTURER FOR OBJECT
# BIT <13>	IF 1, SEARCH ROOM FOR OBJECT
# BIT <12>	IF 1, PARSER WILL TRY TO TAKE OBJECT
# BIT <11>	IF 1, ADVENTURER MUST HAVE OBJECT
# BIT <10>	IF 1, QUALIFYING BITS (NORMALLY -1,-1) ARE SAME
#			AS FWIM BITS
# BIT <9>	IF 1, OBJECT MUST BE REACHABLE
# BITS <8:0>	PREPOSITION NUMBER FOR SYNMCH
#
# THE FWIM WORDS HAVE THE SAME FORMAT AS THE TWO OBJECT FLAG WORDS.
#
# NOTE THAT BITS 12 AND 11 OF OBJECT DESCRIPTIONS ACTUALLY HAVE
# FOUR DISTINCT STATES--
#
#	BIT 12	BIT 11	MDLDESC		INTERPRETATION
#	------	------	-------		---------------
#
#	  0	  0	 --		NO PARSER ACTION
#	  0	  1	 HAVE		ADVENTURER MUST HAVE OBJECT
#	  1	  0	 TRY		TRY TO TAKE, DONT CARE IF FAIL
#	  1	  1	 TAKE		TRY TO TAKE, CARE IF FAIL
#

# SPARSE, PAGE 5
#
	DATA VVOC1/'BRI','EF',1,70,'VER','BOS',1,71,
		'SUP','ERB',1,72,'STA','Y',1,73,'VER','SIO',1,74,
		'SWI','M','BAT','HE','WAD','E',1,75,'GER','ONI',1,76,
		'ULY','SSE','ODY','SSE',1,77,
		 'WEL','L',1,78,'PRA','Y',1,79,'TRE','ASU',1,80,
		'TEM','PLE',1,81,'BLA','ST',1,82,'SCO','RE',1,83,
		'Q',0,'QUI','T',1,84,'HEL','P',1,50,'INF','O',1,51,
		'HIS','TOR','UPD','ATE',1,52,'BAC','K',1,53,
		'SIG','H','MUM','BLE',1,54/
#
	DATA VVOC1A/'CHO','MP','LOS','E','BAR','F',1,55,
		'DUN','GEO',1,56,'FRO','BOZ',1,57,'FOO',0,'BLE','TCH',
		'BAR',0,1,58,'REP','ENT',1,59,'HOU','S','SCH','EDU',1,60,
		'WIN',0,1,61,'YEL','L','SCR','EAM','SHO','UT',1,62,
		'HOP',0,'SKI','P',1,63,'FUC','K','SHI','T','DAM','N',
		'CUR','SE',1,64,'ZOR','K',1,65,'GRA','NIT',1,o'50102',
		'SAV','E',1,149,'RES','TOR',1,150,'TIM','E',1,90,
		 'DIA','GNO',1,94,'EXO','RCI',1,105,'INV','ENT',
		'I',0,1,133,'WAI','T',1,128,
		'INC','ANT',1,95,'ANS','WER',1,96,'ROO','M','RNA','ME',1,97,
		'AGA','IN',1,255/

#
	DATA VVOC2/'DEF','LAT',1,o'50147',
		'DES','CRI','WHA','T','EXA','MIN',1,o'50170',
		'FIL','L',11,o'60206',o'61000',o'200',0,o'61002',o'400',0,
		o'40206',o'61000',o'200',0,
		'FIN','D','SEE','K','WHE','RE','SEE',0,4,o'40177',o'60000',-1,-1,
		'FOL','LOW',2,o'125',o'50125',
		'KIC','K','BIT','E','TAU','NT',1,o'50153','LOW','ER',1,o'50156',
		 'PUS','H','PRE','SS',1,o'50160','RIN','G','PEA','L',1,o'50127',
		'RUB',0,'CAR','ESS','TOU','CH','FON','DLE',1,o'50157',
		'SHA','KE',1,o'50171','SPI','N',1,o'50201',
		'UNT','IE','FRE','E',1,o'50161','WAL','K',9,o'50216',
		o'40126',o'61002',-1,-1,o'40126',o'61005',-1,-1/
#
	DATA VVOC3/'ATT','ACK','FIG','HT','INJ','URE','HIT',0,'HUR','T',
		7,o'60215',o'21000',0,o'200',o'44002',0,o'1000',
		'BOA','RD',4,o'40202',o'21000',0,o'2',
		 'BRU','SH','CLE','AN',5,o'52130',o'70130',o'61002',-1,-1,
		'BUR','N','IGN','ITE','INC','INE',7,o'60211',o'61000',o'20',0,
		o'64002',o'10',0,
		'CLI','MB',12,o'40235',o'20007',0,o'4000',
		o'40236',o'20006',0,o'4000',o'40234',o'20000',0,o'4000',
		'CLO','SE',4,o'40176',o'61000',o'10200',0,
		'DIG',0,4,o'40131',o'44002',o'4',0,
		'DIS','EMB',4,o'40203',o'20000',0,o'2',
		'DRI','NK','IMB','IBE','SWA','LLO',4,o'40210',o'61000',o'400',0,
		'DRO','P','REL','EAS',11,o'42221',o'41000',-1,-1,
		o'60221',o'41000',-1,-1,o'61005',-1,-1,
		'EAT',0,'CON','UME','GOB','BLE','MUN','CH','TAS','TE',
		4,o'40207',o'75000',o'2000',0,
		'EXT','ING','DOU','SE',4,o'40174',o'75000',o'100',0/
#
	DATA VVOC4/'GIV','E','HAN','D','DON','ATE',11,o'72222',o'21004',
		o'40',0,o'64222',o'21000',o'40',0,o'61000',-1,-1,
		'HEL','LO','HI',0,2,o'2227',o'50227',
		'BLO','W',15,o'62146',o'61007',-1,-1,o'61002',o'4',0,
		o'40160',o'61007',-1,-1,o'40165',o'61005',-1,-1,
		'INF','LAT',4,o'70146',o'61002',o'4',0,
		'JUM','P','LEA','P',5,o'133',o'40133',o'61001',-1,-1,
		'KIL','L','MUR','DER','SLA','Y','STA','B','DIS','PAT',
		7,o'60213',o'21000',0,o'200',
		o'44002',0,o'1000',
		'KNO','CK','RAP',0,12,o'42166',o'61003',-1,-1,
		o'40166',o'61012',-1,-1,o'40215',o'23006',o'40',0,
		'LIG','HT',11,o'42173o',o'75000',o'100',0,
			o'60211',o'61000',o'100',0,o'54002',o'10',0,
		'LOC','K',4,o'40134',o'20000',-1,-1/
#
	DATA VVOC5/'LOO','K','L',0,'STA','RE','GAZ','E',
		13,o'167',o'40167',o'60003',-1,-1,
		o'40231',o'61010',-1,-1,o'a40230',o'60005',-1,-1,
		'MEL','T','LIQ','UIF',4,o'70145',o'61002',o'10',0,
		 'MOV','E',4,o'40172',o'20000',-1,-1,
		'PUL','L','TUG',0,8,o'42172',o'21000',-1,-1,
		o'40172',o'21012',-1,-1,
		'MUN','G','HAC','K','FRO','B','DAM','AGE',
		5,o'52212',o'70212',o'44002',-1,-1,
		'OPE','N',11,o'42175',o'61000',o'10200',0,
		o'60175',o'61000',o'10200',0,o'54002',o'4',o'1000',
		'PIC','K',4,o'40204',o'61007',o'20000',o'40',
		'PLU','G','GLU','E','PAT','CH',4,o'70152',o'61002',-1,-1,
		'POK','E','BRE','AK','JAB',0,7,o'60212',o'21000',0,o'200',
		o'44002',0,o'1000',
		 'POU','R','SPI','LL',11,o'42223',o'42000',o'400',0,
		o'60223',o'42000',o'400',0,o'60005',-1,-1,
		'PUM','P',4,o'60232',o'60007',-1,-1/
#
	DATA VVOC6/'PUT',0,'INS','ERT','STU','FF','PLA','CE',
		8,o'72220',o'61005',-1,-1,
		o'40221',o'61006',-1,-1,
		'RAI','SE','LIF','T',5,o'52155',o'40155',o'61007',-1,-1,
		 'REA','D','SKI','M',11,o'42144',o'71000',o'40000',0,
		o'60144',o'71000',o'40000',0,o'61002',-1,-1,
		'STR','IKE',12,o'60215',o'23000',o'40',0,
		o'44002',0,o'1000',o'42215',o'23000',o'40',0,o'50173',
		'SWI','NG','THR','UST',7,o'60214',o'44000',0,o'1000',
		o'21003',0,o'200',
		'TAK','E','GET',0,'HOL','D','CAR','RY','REM','OVE',
		4,o'40204',o'61000',o'20000',o'40',
		'TEL','L','COM','MAN','REQ','UES',4,o'40217',o'20000',0,o'2000',
		'THR','OW','HUR','L','CHU','CK',14,o'60224',o'44000',-1,-1,
			o'21003',o'40',0,o'60224',o'44000',-1,-1,o'21002',o'40',0/
#
	DATA VVOC7/'TIE',0,'FAS','TEN',11,o'70162',o'61004',-1,-1,
		o'60163',o'21000',o'40',0,o'65002',o'4',0,
		'TUR','N','SET',0,22,o'62164',o'61000',o'2',0,
			o'64002',o'4',0,
		o'40173',o'75012',o'100',0,o'40174',o'75013',o'100',0,
		o'60237',o'61000',o'2',0,o'20004',-1,-1,
		'UNL','OCK',7,o'60135',o'21000',-1,-1,
		o'74002',o'4',0,
		'WAK','E','SUR','PRI','ALA','RM','STA','RTL',
		8,o'42150',o'20000',o'40',0,
		o'40150',o'20007',o'40',0,
		'WAV','E','FLA','UNT','BRA','NDI',4,o'40154',o'40000',-1,-1,
		'WIN','D',5,o'50233',o'40233',o'61007',-1,-1/
#
	DATA VVOCND/-1/

# SPARSE, PAGE 6
#
# OBJECTS--	MAPS OBJECTS TO OBJECT INDICES
#
# SAME FORMAT AS AVOC.
#
	DATA OVOC1/'BAG',0,1,25,100,'SAC','K',1,'GAR','LIC',2,
		'CLO','VE',2,'FOO','D',3,'SAN','DWI',3,'LUN','CH',3,
		'DIN','NER',3,
		'GUN','K',4,55,'PIE','CE',4,143,'SLA','G',4,'COA','L',5,
		 'PIL','E',5,38,78,87,88,122,'HEA','P',5,
		 'FIG','URI',6,
		'MAC','HIN',7,'PDP','10',7,'PDP','11',7,'DRY','ER',7,
		'LID',0,7,'DIA','MON',8,'CAS','E',9,123,'BOT','TLE',10,123,
		'CON','TAI',10,'WAT','ER',11,204,'QUA','NTI',11,204,
		'LIQ','UID',11,204,'H2O',0,11,204,
		'ROP','E',12,101,'HEM','P',12,'COI','L',12,110,
		'KNI','FE',13,21,'BLA','DE',13,14,'SWO','RD',14,'ORC','HRI',14,
		'GLA','MDR',14,'LAM','P',15,16,22,'LAN','TER',15,16,22,
		'RUG',0,17,'CAR','PET',17,
		'LEA','VES',18,'LEA','F',18,'TRO','LL',19,
		 'AXE',0,20,'DIN','NER',3/
#
	DATA OVOC2/'KEY','S',23,'KEY',0,23,
		'SET',0,23,'BON','ES',24,'SKE','LET',24,'BOD','Y',24,73,
		'COI','NS',25,'BAR',0,26,165,168,
		 'NEC','KLA',27,'PEA','RLS',27,'MIR','ROR',28,29,207,
		'ICE',0,30,'MAS','S',30,'GLA','CIE',30,'RUB','Y',31,
		'TRI','DEN',32,'FOR','K',32,'COF','FIN',33,'CAS','KET',33,
		'TOR','CH',34,'CAG','E',35,36,124,125,'DUM','BWA',35,36,
		'BAS','KET',35,36,98,113,'BRA','CEL',37,
		'JEW','EL',37,'TIM','BER',38,'BOX',0,39,53,105,'STR','ADI',40,
		'VIO','LIN',40,'ENG','RAV',41,'INS','CRI',41,44,'GHO','ST',42,
		'SPI','RIT',42,'FIE','ND',42,'GRA','IL',43,'PRA','YER',44,47,
		'TRU','NK',45,'CHE','ST',45,'BEL','L',46,
		 'BOO','K',47,49,114,115,116,117,'BIB','LE',47/
#
	DATA OVOC3/'GOO','DBO',47,'CAN','DLE',48,'PAI','R',48,
		'GUI','DEB',49,
		'GUI','DE',49,'PAP','ER',50,122,143,'NEW','SPA',50,
		'ISS','UE',50,'REP','ORT',50,'MAG','AZI',50,'NEW','S',50,
		 'MAT','CHB',51,
		 'MAT','CH',51,'MAT','CHE',51,'ADV','ERT',52,'PAM','PHL',52,
		'LEA','FLE',52,'BOO','KLE',52,'MAI','LBO',53,
		'TUB','E',54,'TOO','THP',54,'PUT','TY',55,'MAT','ERI',55,
		'GLU','E',55,'WRE','NCH',56,'SCR','EWD',57,
		'CYC','LOP',58,'MON','STE',58,'CHA','LIC',59,'CUP',0,59,
		'GOB','LET',59,'PAI','NTI',60,149,'ART',0,60,149,
		'CAN','VAS',60,'PIC','TUR',60,'WOR','K',60,
		'MAS','TER',60,210,'THI','EF',61,'ROB','BER',61,
		'CRI','MIN',61,'BAN','DIT',61,'CRO','OK',61,'GEN','T',61,
		'GEN','TLE',61,'MAN',0,61,'THU','G',61,
		 'BAG','MAN',61,'STI','LLE',62/
#
	DATA OVOC4/'WIN','DOW',63,'BOL','T',64,'NUT',0,64,
		'GRA','TE',65,'GRA','TIN',65,'DOO','R',66,67,68,69,
		164,172,173,174,175,'TRA','PDO',66,
		'TRA','P$D',66,'SWI','TCH',70,76,79,80,81,82,170,
		 'HEA','D',71,120,'COR','PSE',72,73,'BOD','IES',73,
		'DAM',0,74,'GAT','ES',74,76,'GAT','E',74,76,
		'FCD',0,74,'RAI','L',75,'RAI','LIN',75,
		'BUT','TON',76,79,80,81,82,127,128,129,170,176,
		'BUB','BLE',77,'LEA','K',78,'DRI','P',78,
		'HOL','E',78,107,
		'BAT',0,83,'RAI','NBO',84,
		'POT',0,85,'STA','TUE',86,'SCU','LPT',86,'ROC','K',86,
		'BOA','T',87,88,90,'PLA','STI',87,88,
		 'PUM','P',89/
#
	DATA OVOC5/'AIR','PUM',89,'AIR','$PU',89,'LAB','EL',91,112,
		'FIN','EPR',91,'STI','CK',92,'BAR','REL',93,'BUO','Y',94,
		'EME','RAL',95,'SHO','VEL',96,'GUA','NO',97,'CRA','P',97,
		 'SHI','T',97,'HUN','K',97,'BAL','LOO',98,113,
		'REC','EPT',99,'WIR','E',101,110,
		'HOO','K',102,103,'ZOR','KMI',104,148,'COI','N',104,
		'SAF','E',105,'CAR','D',106,'NOT','E',106,
		'SLO','T',107,'CRO','WN',108,'BRI','CK',109,
		'FUS','E',110,'GNO','ME',111,152,
		'STA','MP',118,
		'TOM','B',119,'CRY','PT',119,'GRA','VE',119,'HEA','DS',120,
		 'POL','ES',120,'IMP','LEM',120/
#
	DATA OVOC6/'LOS','ERS',120,'COK','ES',121,
		'LIS','TIN',122,'STA','CK',122,
		'PRI','NTO',122,
		 'SPH','ERE',126,'BAL','L',126,
		'ETC','HIN',130,131,
		'WAL','LS',130,131,193,200,201,202,203,'WAL','L',
		130,131,159,160,161,162,163,164,193,200,201,202,203,
		'FLA','SK',132,'POO','L',133,'SEW','AGE',133,
		'TIN',0,134,'SAF','FRO',134,'SPI','CES',134,'TAB','LE',135,
		'POS','T',136,166,167,'POS','TS',136,'BUC','KET',137,
		'CAK','E',138,139,140,141,'ICI','NG',139,140,141,
		'ROB','OT',142,'ROB','BY',142,
		'C3P','O',142,'R2D','2',142/
#
	DATA OVOC6A/'PAN','EL',159,160,161,162,163,164,208,
		'POL','E',166,167,'TBA','R',168,'T$B','AR',168,
		'ARR','OW',169,'POI','NT',169,'BEA','M',171,
		 'DIA','L',177,'SUN','DIA',177,'1',0,178,
		'ONE',0,178,'2',0,179,'TWO',0,179,'3',0,180,
		'THR','EE',180,'4',0,181,'FOU','R',181,'5',0,182,
		'FIV','E',182,'6',0,183,'SIX',0,183,'7',0,184,
		'SEV','EN',184,'8',0,185,'EIG','HT',185,
		 'IT',0,187,'THA','T',187,'THI','S',187/
#
	DATA OVOC7/'ME',0,188,'MYS','ELF',188,'CRE','TIN',188,
		'ALL',0,189,'EVE','RYT',189,
		'TRE','ASU',190,'VAL','UAB',190,'SAI','LOR',191,'TEE','TH',192,
		'GRU','E',194,'HAN','D',195,'HAN','DS',195,
		 'LUN','GS',196,'AIR',0,196,'AVI','ATO',197,
		'FLY','ER',197,'TRE','E',144,145,199,
		'CLI','FF',146,147,'LED','GE',146,147,'POR','TRA',149,
		'STA','CK',148,'BIL','LS',148,
		'VAU','LT',150,'CUB','E',150,'LET','TER',67,150,
		'CUR','TAI',151,'LIG','HT',151,'NES','T',153,
		'EGG',0,154,155,'BAU','BLE',156,'CAN','ARY',157,158,
		'BIR','D',198,'SON','GBI',198,
		'GUA','RD',205,'GUA','RDI',205,'ROS','E',206,
		'STR','UCT',207,'CHA','NNE',209,
		 'KEE','PER',210/
#
	DATA OVOCND/-1/

# SPARSE, PAGE 7
#
# SET UP FOR PARSING
#
	SPARSE=-1				#ASSUME PARSE FAILS.
	ADJ=0					#CLEAR PARTS HOLDERS.
	ACT=0
	PREP=0
	PPTR=0
	O1=0
	O2=0
	P1=0
	P2=0
#D	DFLAG=AND(PRSFLG,o'4').NE.0
#
	BUZLNT=20
	PRPLNT=48
	DIRLNT=75

# SPARSE, PAGE 8
#
# NOW LOOP OVER INPUT BUFFER OF LEXICAL TOKENS.
#
	DO I=1,LLNT,2 {				#TWO WORDS/TOKEN.
	  LBUF1=LBUF(I)				#GET CURRENT TOKEN.
	  LBUF2=LBUF(I+1)
	  IF(LBUF1.EQ.0) GO TO 1500		#END OF BUFFER?
#
# CHECK FOR BUZZ WORD
#
	  DO 50 J=1,BUZLNT,2
	    IF((LBUF1.EQ.BVOC(J)).AND.(LBUF2.EQ.BVOC(J+1))) {
		NEXT				#IGNORE BUZZ WORDS.
		}
50	  CONTINUE
#
# CHECK FOR ACTION OR DIRECTION
#
	  IF(ACT.NE.0) GO TO 75			#GOT ACTION ALREADY?
	  J=1					#CHECK FOR ACTION.
125	  IF((LBUF1.EQ.VVOC(J)).AND.(LBUF2.EQ.VVOC(J+1))) {
		GO TO 3000
		}
150	  J=J+2					#ADV TO NEXT SYNONYM.
	  IF(.NOT.OTEST(VVOC(J))) GO TO 125	#ANOTHER VERB?
	  J=J+VVOC(J)+1				#NO, ADVANCE OVER SYNTAX.
	  IF(VVOC(J).NE.-1) GO TO 125		#TABLE DONE?
#
75	  IF((ACT.NE.0).AND.((VVOC(ACT).NE.R50WAL).OR.
		(PREP.NE.0))) GO TO 200		#NO ACTION OR WALK?
	  DO J=1,DIRLNT,3 {			#THEN CHK FOR DIR.
	    IF((LBUF1.EQ.DVOC(J)).AND.(LBUF2.EQ.DVOC(J+1))) {
		GO TO 2000
		}
C100	  CONTINUE
	    }
#
# NOT AN ACTION, CHECK FOR PREPOSITION, ADJECTIVE, OR OBJECT.
#
200	  DO J=1,PRPLNT,3 {			#LOOK FOR PREPOSITION.
	    IF((LBUF1.EQ.PVOC(J)).AND.(LBUF2.EQ.PVOC(J+1))) {
		GO TO 4000
		}
C250	  CONTINUE
	    }
#
	  J=1					#LOOK FOR ADJECTIVE.
300	  IF((LBUF1.EQ.AVOC(J)).AND.(LBUF2.EQ.AVOC(J+1))) {
		GO TO 5000
		}
	  J=J+1
325	  J=J+1					#ADVANCE TO NEXT ENTRY.
	  IF(OTEST(AVOC(J))) GO TO 325	#A RADIX 50 CONSTANT?
	  IF(AVOC(J).NE.-1) GO TO 300		#POSSIBLY, END TABLE?
#
	  J=1					#LOOK FOR OBJECT.
450	  IF((LBUF1.EQ.OVOC(J)).AND.(LBUF2.EQ.OVOC(J+1))) {
		GO TO 600
		}
	  J=J+1
500	  J=J+1
	  IF(OTEST(OVOC(J))) GO TO 500
	  IF(OVOC(J).NE.-1) GO TO 450
#
# NOT RECOGNIZABLE
#
	  IF(VBFLAG) CALL RSPEAK(601)
	  RETURN

# SPARSE, PAGE 9
#
# OBJECT PROCESSING (CONTINUATION OF DO LOOP ON PREV PAGE)
#
600	  OBJ=GETOBJ(J,ADJ,0)			#IDENTIFY OBJECT.
#D	  IF(DFLAG) TYPE 60,J,OBJ
#D60	  FORMAT(' SPARSE- OBJ AT ',I6,'  OBJ= ',I6)
	  IF(OBJ.LE.0) GO TO 6000		#IF LE, COULDNT.
	  IF(OBJ.NE.ITOBJ) GO TO 650		#"IT"?
	  OBJ=GETOBJ(0,0,spv(1))		#FIND LAST.
	  IF(OBJ.LE.0) GO TO 6000		#IF LE, COULDNT.
#
650	  IF(PREP.EQ.9) GO TO 8000		#"OF" OBJ?
	  IF(PPTR.EQ.2) GO TO 7000		#TOO MANY OBJS?
	  PPTR=PPTR+1
	  OBJVEC(PPTR)=OBJ			#STUFF INTO VECTOR.
	  PRPVEC(PPTR)=PREP
700	  PREP=0
	  ADJ=0
	  }					#AT LAST.
#
# NOW SOME MISC CLEANUP
#
1500	IF(ACT.EQ.0) ACT=OFLAG.AND.OACT	#IF NO ACT, STEAL ORPHAN.
	IF(ACT.EQ.0) GO TO 9000			#IF STILL NONE, PUNT.
	IF(ADJ.NE.0) GO TO 10000		#IF DANGLING ADJ, PUNT.
#
	IF((OFLAG.NE.0).AND.(OPREP.NE.0).AND.(PREP.EQ.0).AND.
		(O1.NE.0).AND.(O2.EQ.0).AND.(ACT.EQ.OACT)) {
		GO TO 11000
		}
#
	SPARSE=0				#PARSE SUCCEEDS.
	IF(PREP.EQ.0) GO TO 1750		#IF DANGLING PREP,
	IF((PPTR.EQ.0).OR.(PRPVEC(PPTR).NE.0)) {
		GO TO 12000			#AND HAVE 'PICK FROB UP',
		}
	PRPVEC(PPTR)=PREP			#CVT TO 'PICK UP FROB'.
1750	CONTINUE				#WIN.
#D	IF(DFLAG) TYPE 70,ACT,O1,O2,P1,P2
#D70	FORMAT(' SPARSE RESULTS- ',5I7)
	RETURN

# SPARSE, PAGE 10
#
# SPECIAL PARSE PROCESSORS
#
# 2000--	DIRECTION
#
2000	PRSA=WALKW				#VERB IS WALK.
	PRSO=DVOC(J+2)				#GET DIRECTION.
	SPARSE=1				#WIN TOTALLY.
#D	IF(DFLAG) TYPE 10,J
#D10	FORMAT(' SPARSE- DIR AT ',I6)
	RETURN
#
# 3000--	ACTION
#
3000	ACT=J					#SAVE INDEX TO VERB.
	OACT=0					#NO ORPHAN.
#
	IF(vvoc(act+3).ne.255)GO TO 3500		#AGAIN PROCESSOR
	IF(SPV(4))GOTO 3200			#IF PREVIOUS COMMAND WAS BAD
	CALL RSPEAK(622)			#CHOMP
	RETURN
# ELSE
3200	PRSA=SPV(2)
	PRSO=SPV(1)
	PRSI=SPV(3)
#D	IF(DFLAG)TYPE 15,SPV
#D15	FORMAT(' SPARSE- AGAIN: ',4I6)
	SPARSE=1				#DO NOT REVALIDATE THE LINE
	RETURN
#
3500	CONTINUE
#D	IF(DFLAG) TYPE 20,J
#D20	FORMAT(' SPARSE- ACT AT ',I6)
	GO TO 1000				#DONE.
#
# 4000--	PREPOSITION
#
4000	IF(PREP.NE.0) GO TO 4500		#ALREADY HAVE ONE?
	PREP=PVOC(J+2)			#NO, GET INDEX.
	ADJ=0					#NO ADJECTIVE.
#D	IF(DFLAG) TYPE 30,J
#D30	FORMAT(' SPARSE- PREP AT ',I6)
	GO TO 1000
#
4500	IF(VBFLAG) CALL RSPEAK(616)		#YES, GAG AND LOSE.
	RETURN
#
# 5000--	ADJECTIVE
#
5000	ADJ=J					#SAVE ADJECTIVE.
	J=ONAME.AND.OFLAG
#D	IF(DFLAG) TYPE 40,ADJ,J
#D40	FORMAT(' SPARSE- ADJ AT ',I6,' ORPHAN= ',I6)
	IF((J.NE.0).AND.(I.GE.LLNT)) GO TO 600
	GO TO 1000
#
# 6000--	UNIDENTIFIABLE OBJECT (INDEX INTO OVOC IS J)
#
6000	IF(OBJ.LT.0) GO TO 6100			#IF LT, AMBIGUOUS.
	I=579					#NOT HERE OR
	IF(LIT(HERE)) I=618			#NOT LIT.
	IF(VBFLAG) CALL RSPEAK(I)
	RETURN					#LOSE.
#
6100	IF(OBJ.NE.-10000) GO TO 6200		#INSIDE VEHICLE?
	IF(VBFLAG) CALL RSPSUB(620,ODESC2(AVEHIC(WINNER)))
	RETURN
#
6200	IF(VBFLAG) CALL RSPEAK(619)		#CANT DISTINGUISH.
	IF(ACT.EQ.0) ACT=OFLAG.AND.OACT	#IF NO ACT, GET ORPHAN.
	CALL ORPHAN(-1,ACT,O1,PREP,J)		#ORPHAN THE WORLD.
	RETURN
#
# 7000--	TOO MANY OBJECTS.
#
7000	IF(VBFLAG) CALL RSPEAK(617)
	RETURN
#
# 8000--	RANDOMNESS FOR "OF" WORDS
#
8000	IF(OBJVEC(PPTR).EQ.OBJ) GO TO 700	#IGNORE IF OK.
	IF(VBFLAG) CALL RSPEAK(601)
	RETURN
#
# 9000--	NO ACTION, PUNT
#
9000	IF(O1.EQ.0) GO TO 10000			#ANY DIRECT OBJECT?
	IF(VBFLAG) CALL RSPSUB(621,ODESC2(O1))	#WHAT TO DO?
	CALL ORPHAN(-1,0,O1,0,0)
	RETURN
#
# 10000--	TOTAL CHOMP
#
10000	IF(VBFLAG) CALL RSPEAK(622)		#HUH?
	RETURN
#
# 11000--	ORPHAN PREPOSITION.  CONDITIONS ARE
#		O1.NE.0, O2=0, PREP=0, ACT=OACT
#
11000	IF(OSLOT.NE.0) GO TO 11500		#ORPHAN OBJECT?
	P1=OPREP				#NO, JUST USE PREP.
	GO TO 1750
#
11500	O2=O1					#YES, USE AS DIRECT OBJ.
	P2=OPREP
	O1=OSLOT
	P1=0
	GO TO 1750
#
# 12000--	TRUE HANGING PREPOSITION.
#		ORPHAN FOR LATER.
#
12000	CALL ORPHAN(-1,ACT,0,PREP,0)		#ORPHAN PREP.
	GO TO 1750
#
#  SPECIAL ENTRY TO INIT RADIX-50 TEXT (CALLED FROM DINIT)
#
	ENTRY SPINIT
#
	CALL R50CNV(R50WAL,1)
	CALL R50CNV(BVOC,20)
	CALL R50CNV(PVOC,45)
	CALL R50CNV(DVOC,75)
	CALL R50CNV(AVOC,400)
	CALL R50CNV(VVOC,900)
	CALL R50CNV(OVOC,1050)
	RETURN
#
	END

# GETOBJ--	FIND OBJ DESCRIBED BY ADJ, NAME PAIR
#
# DECLARATIONS
#
# THIS ROUTINE DETAILS ON BIT 3 OF PRSFLG
#
	INTEGER FUNCTION GETOBJ(OIDX,AIDX,SPCOBJ)
	IMPLICIT INTEGER(A-Z)
	LOGICAL THISIT,GHERE,LIT,CHOMP,DFLAG
#
	COMMON /OBJFLG/ VABIT,VRBIT,VTBIT,VCBIT,VEBIT,VFBIT,VPMASK
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
#
# MISCELLANEOUS VARIABLES
#
	COMMON /STAR/ MBASE,STRBIT
	COMMON /DEBUG/ DBGFLG,PRSFLG
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
# ADVENTURERS
#
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
		AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
#
# VOCABULARIES
#
	COMMON /OBJVOC/ OVOC(1050)

# GETOBJ, PAGE 2
#
#D	DFLAG=AND(PRSFLG,o'10').NE.0
	CHOMP=.FALSE.
	AV=AVEHIC(WINNER)
	OBJ=0					#ASSUME DARK.
	IF(.NOT.LIT(HERE)) GO TO 200		#LIT?
#
	OBJ=SCHLST(OIDX,AIDX,HERE,0,0,SPCOBJ)	#SEARCH ROOM.
#D	IF(DFLAG) TYPE 10,OBJ
#D10	FORMAT(' SCHLST- ROOM SCH ',I6)
	IF(OBJ) 1000,200,100			#TEST RESULT.
100	IF((AV.EQ.0).OR.(AV.EQ.OBJ).OR.
		(AND(OFLAG2(OBJ),FINDBT).NE.0)) GO TO 200
	IF(OCAN(OBJ).EQ.AV) GO TO 200		#TEST IF REACHABLE.
	CHOMP=.TRUE.				#PROBABLY NOT.
#
200	IF(AV.EQ.0) GO TO 400			#IN VEHICLE?
	NOBJ=SCHLST(OIDX,AIDX,0,AV,0,SPCOBJ)	#SEARCH VEHICLE.
#D	IF(DFLAG) TYPE 20,NOBJ
#D20	FORMAT(' SCHLST- VEH SCH  ',I6)
	IF(NOBJ) 1100,400,300			#TEST RESULT.
300	CHOMP=.FALSE.				#REACHABLE.
	IF(OBJ.EQ.NOBJ) GO TO 400		#SAME AS BEFORE?
	IF(OBJ.NE.0) NOBJ=-NOBJ			#AMB RESULT?
	OBJ=NOBJ
#
400	NOBJ=SCHLST(OIDX,AIDX,0,0,WINNER,SPCOBJ)	#SEARCH ADVENTURER.
#D	IF(DFLAG) TYPE 30,NOBJ
#D30	FORMAT(' SCHLST- ADV SCH  ',I6)
	IF(NOBJ) 1100,600,500			#TEST RESULT
500	IF(OBJ.NE.0) NOBJ=-NOBJ			#AMB RESULT?
1100	OBJ=NOBJ				#RETURN NEW OBJECT.
600	IF(CHOMP) OBJ=-10000			#UNREACHABLE.
1000	GETOBJ=OBJ
#
	IF(GETOBJ.NE.0) GO TO 1500		#GOT SOMETHING?
	DO I=STRBIT+1,OLNT {			#NO, SEARCH GLOBALS.
	  IF(.NOT.THISIT(OIDX,AIDX,I,SPCOBJ)) GO TO 1200
	  IF(.NOT.GHERE(I,HERE)) NEXT		#CAN IT BE HERE?
	  IF(GETOBJ.NE.0) GETOBJ=-I		#AMB MATCH?
	  IF(GETOBJ.EQ.0) GETOBJ=I
	  }
#
1500	CONTINUE				#END OF SEARCH.
#D	IF(DFLAG) TYPE 40,GETOBJ
#D40	FORMAT(' SCHLST- RESULT   ',I6)
	RETURN
	END

# SCHLST--	SEARCH FOR OBJECT
#
# DECLARATIONS
#
	INTEGER FUNCTION SCHLST(OIDX,AIDX,RM,CN,AD,SPCOBJ)
	IMPLICIT INTEGER(A-Z)
	LOGICAL THISIT,QHERE,NOTRAN,NOVIS
#
	COMMON /STAR/ MBASE,STRBIT
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
# FUNCTIONS AND DATA
#
	NOTRAN(O)=
		(AND(OFLAG1(O),TRANBT).EQ.0).AND.(AND(OFLAG2(O),OPENBT).EQ.0)
	NOVIS(O)=(AND(OFLAG1(O),VISIBT).EQ.0)
#
	SCHLST=0					#NO RESULT.
	DO I=1,OLNT {				#SEARCH OBJECTS.
	  IF(NOVIS(I).OR.
		(((RM.EQ.0).OR.(.NOT.QHERE(I,RM))).AND.
		 ((CN.EQ.0).OR.(OCAN(I).NE.CN)).AND.
			 ((AD.EQ.0).OR.(OADV(I).NE.AD)))) NEXT
	  IF(.NOT.THISIT(OIDX,AIDX,I,SPCOBJ)) GO TO 200
	  IF(SCHLST.NE.0) GO TO 2000		#GOT ONE ALREADY?
	  SCHLST=I					#NO.
#
# IF OPEN OR TRANSPARENT, SEARCH THE OBJECT ITSELF.
#
200	  IF(NOTRAN(I)) NEXT
#
# SEARCH IS CONDUCTED IN REVERSE.  ALL OBJECTS ARE CHECKED TO
# SEE IF THEY ARE AT SOME LEVEL OF CONTAINMENT INSIDE OBJECT 'I'.
# IF THEY ARE AT LEVEL 1, OR IF ALL LINKS IN THE CONTAINMENT
# CHAIN ARE OPEN, VISIBLE, AND HAVE SEARCHME SET, THEY CAN QUALIFY
# AS A POTENTIAL MATCH.
#
	  DO J=1,OLNT {				#SEARCH OBJECTS.
	    IF(NOVIS(J).OR. (.NOT.THISIT(OIDX,AIDX,J,SPCOBJ))) {
		NEXT				#VISIBLE & MATCH?
		}
	    X=OCAN(J)				#GET CONTAINER.
300	    IF(X.EQ.I) GO TO 400		#INSIDE TARGET?
	    IF(X.EQ.0) NEXT			#INSIDE ANYTHING?
	    IF(NOVIS(X).OR.NOTRAN(X).OR.
		(AND(OFLAG2(X),SCHBT).EQ.0)) NEXT
	    X=OCAN(X)				#GO ANOTHER LEVEL.
	    GO TO 300
#
400	    IF(SCHLST.NE.0) GO TO 2000		#ALREADY GOT ONE?
	    SCHLST=J				#NO.
	    }
#
	  }
	RETURN
#
2000	SCHLST=-SCHLST				#AMB RETURN.
	RETURN
#
	END

# THISIT--	VALIDATE OBJECT VS DESCRIPTION
#
# DECLARATIONS
#
	LOGICAL FUNCTION THISIT(OIDX,AIDX,OBJ,SPCOBJ)
	IMPLICIT INTEGER(A-Z)
	LOGICAL NOTEST
#
# VOCABULARIES
#
	COMMON /OBJVOC/ OVOC(1050)
	COMMON /ADJVOC/ AVOC(400)
#
# FUNCTIONS AND DATA
#
	NOTEST(O)=(O.LE.0).OR.(O.GE.R50MIN)
	DATA R50MIN/o'3100'/
#
	THISIT=.FALSE.				#ASSUME NO MATCH.
	IF((SPCOBJ.NE.0).AND.(OBJ.EQ.SPCOBJ)) GO TO 500
#
# CHECK FOR OBJECT NAMES
#
	I=OIDX+1
100	I=I+1
	IF(NOTEST(OVOC(I))) RETURN		#IF DONE, LOSE.
	IF(OVOC(I).NE.OBJ) GO TO 100		#IF FAIL, CONT.
#
	IF(AIDX.EQ.0) GO TO 500			#ANY ADJ?
	I=AIDX+1
200	I=I+1
	IF(NOTEST(AVOC(I))) RETURN		#IF DONE, LOSE.
	IF(AVOC(I).NE.OBJ) GO TO 200		#IF FAIL, CONT.
#
500	THISIT=.TRUE.
	RETURN
	END

# SYNMCH--	SYNTAX MATCHER
#
# DECLARATIONS
#
# THIS ROUTINE DETAILS ON BIT 4 OF PRSFLG
#
	LOGICAL FUNCTION SYNMCH
	IMPLICIT INTEGER(A-Z)
	LOGICAL SYNEQL,TAKEIT,DFLAG
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
	COMMON /DEBUG/ DBGFLG,PRSFLG
#
	COMMON /ORPHS/ OFLAG,OACT,OSLOT,OPREP,ONAME
	COMMON /PV/ ACT,O1,O2,P1,P2
	COMMON /SYNTAX/VFLAG,DOBJ,DFL1,DFL2,DFW1,DFW2,
		IOBJ,IFL1,IFL2,IFW1,IFW2
	COMMON /VRBVOC/ VVOC(900)
	COMMON /SYNFLG/ SDIR,SIND,SSTD,SFLIP,SDRIV,SVMASK
	COMMON /OBJFLG/ VABIT,VRBIT,VTBIT,VCBIT,VEBIT,VFBIT,VPMASK
	DATA R50MIN/o'3100'/
#
	SYNMCH=.FALSE.
#D	DFLAG=AND(PRSFLG,o'20').NE.0
	J=ACT					#SET UP PTR TO SYNTAX.
	DRIVE=0					#NO DEFAULT.
	DFORCE=0				#NO FORCED DEFAULT.
	QPREP=AND(OFLAG,OPREP)			#VALID ORPHAN PREP FLAG.
100	J=J+2					#FIND START OF SYNTAX.
	IF((VVOC(J).LE.0).OR.(VVOC(J).GE.R50MIN)) GO TO 100
	LIMIT=J+VVOC(J)+1			#COMPUTE LIMIT.
	J=J+1					#ADVANCE TO NEXT.
#
200	CALL UNPACK(J,NEWJ)			#UNPACK SYNTAX.
#D	IF(DFLAG) TYPE 60,O1,P1,DOBJ,DFL1,DFL2
#D60	FORMAT(' SYNMCH INPUTS TO SYNEQL- ',5I7)
	SPREP=AND(DOBJ,VPMASK)			#SAVE EXPECTED PREP.
	IF(.NOT.SYNEQL(P1,O1,DOBJ,DFL1,DFL2)) GO TO 1000
#D	IF(DFLAG) TYPE 60,O2,P2,IOBJ,IFL1,IFL2
	SPREP=AND(IOBJ,VPMASK)			#SAVE EXPECTED PREP.
	IF(SYNEQL(P2,O2,IOBJ,IFL1,IFL2)) GO TO 6000
#
# SYNTAX MATCH FAILS, TRY NEXT ONE.
#
	IF(O2) 3000,500,3000			#IF O2=0, SET DFLT.
1000	IF(O1) 3000,500,3000			#IF O1=0, SET DFLT.
500	IF((QPREP.EQ.0).OR.(QPREP.EQ.SPREP)) DFORCE=J	#IF PREP MCH.
	IF(AND(VFLAG,SDRIV).NE.0) DRIVE=J	#IF DRIVER, RECORD.
3000	J=NEWJ
	IF(J.LT.LIMIT) GO TO 200		#MORE TO DO?

# SYNMCH, PAGE 2
#
# MATCH HAS FAILED.  IF DEFAULT SYNTAX EXISTS, TRY TO SNARF
# ORPHANS OR GWIMS, OR MAKE NEW ORPHANS.
#
#D	IF(DFLAG) TYPE 20,DRIVE,DFORCE
#D20	FORMAT(' SYNMCH, DRIVE=',2I6)
	IF(DRIVE.EQ.0) DRIVE=DFORCE		#NO DRIVER? USE FORCE.
	IF(DRIVE.EQ.0) GO TO 10000		#ANY DRIVER?
	CALL UNPACK(DRIVE,DFORCE)		#UNPACK DFLT SYNTAX.
#
# TRY TO FILL DIRECT OBJECT SLOT IF THAT WAS THE PROBLEM.
#
	IF((AND(VFLAG,SDIR).EQ.0).OR.(O1.NE.0)) GO TO 4000
#
# FIRST TRY TO SNARF ORPHAN OBJECT.
#
	O1=AND(OFLAG,OSLOT)
	IF(O1.EQ.0) GO TO 3500			#ANY ORPHAN?
	IF(SYNEQL(P1,O1,DOBJ,DFL1,DFL2)) GO TO 4000
#
# ORPHAN FAILS, TRY GWIM.
#
3500	O1=GWIM(DOBJ,DFW1,DFW2)			#GET GWIM.
#D	IF(DFLAG) TYPE 30,O1
#D30	FORMAT(' SYNMCH- DO GWIM= ',I6)
	IF(O1.GT.0) GO TO 4000		#TEST RESULT.
	CALL ORPHAN(-1,ACT,0,AND(DOBJ,VPMASK),0)	#FAILS, ORPHAN.
	CALL RSPEAK(623)
	RETURN
#
# TRY TO FILL INDIRECT OBJECT SLOT IF THAT WAS THE PROBLEM.
#
4000	IF((AND(VFLAG,SIND).EQ.0).OR.(O2.NE.0)) GO TO 6000
	O2=GWIM(IOBJ,IFW1,IFW2)			#GWIM.
#D	IF(DFLAG) TYPE 40,O2
#D40	FORMAT(' SYNMCH- IO GWIM= ',I6)
	IF(O2.GT.0) GO TO 6000
	IF(O1.EQ.0) O1=AND(OFLAG,OSLOT)
	CALL ORPHAN(-1,ACT,O1,AND(DOBJ,VPMASK),0)
	CALL RSPEAK(624)
	RETURN
#
# TOTAL CHOMP
#
10000	CALL RSPEAK(601)			#CANT DO ANYTHING.
	RETURN

# SYNMCH, PAGE 3
#
# NOW TRY TO TAKE INDIVIDUAL OBJECTS AND
# IN GENERAL CLEAN UP THE PARSE VECTOR.
#
6000	IF(AND(VFLAG,SFLIP).EQ.0) GO TO 5000	#FLIP?
	J=O1					#YES.
	O1=O2
	O2=J
#
5000	PRSA=AND(VFLAG,SVMASK)			#GET VERB.
	PRSO=O1					#GET DIR OBJ.
	PRSI=O2					#GET IND OBJ.
	IF(.NOT.TAKEIT(PRSO,DOBJ)) RETURN	#TRY TAKE.
	IF(.NOT.TAKEIT(PRSI,IOBJ)) RETURN	#TRY TAKE.
	SYNMCH=.TRUE.
#D	IF(DFLAG) TYPE 50,SYNMCH,PRSA,PRSO,PRSI,ACT,O1,O2
#D50	FORMAT(' SYNMCH- RESULTS ',L1,6I7)
	RETURN
#
	END

# UNPACK-	UNPACK SYNTAX SPECIFICATION, ADV POINTER
#
# DECLARATIONS
#
	SUBROUTINE UNPACK(OLDJ,J)
	IMPLICIT INTEGER(A-Z)
#
	COMMON /VRBVOC/ VVOC(900)
#
	COMMON /SYNFLG/ SDIR,SIND,SSTD,SFLIP,SDRIV,SVMASK
	COMMON /OBJFLG/ VABIT,VRBIT,VTBIT,VCBIT,VEBIT,VFBIT,VPMASK
	COMMON /SYNTAX/ VFLAG,DOBJ,DFL1,DFL2,DFW1,DFW2,
		IOBJ,IFL1,IFL2,IFW1,IFW2
	INTEGER SYN(11)
	EQUIVALENCE (SYN(1),VFLAG)
#
	DO I=1,11 {				#CLEAR SYNTAX.
	  SYN(I)=0
	  }
#
	VFLAG=VVOC(OLDJ)
	J=OLDJ+1
	IF(AND(VFLAG,SDIR).EQ.0) RETURN		#DIR OBJECT?
	DFL1=-1					#ASSUME STD.
	DFL2=-1
	IF(AND(VFLAG,SSTD).EQ.0) GO TO 100	#STD OBJECT?
	DFW1=-1					#YES.
	DFW2=-1
	DOBJ=VABIT+VRBIT+VFBIT
	GO TO 200
#
100	DOBJ=VVOC(J)				#NOT STD.
	DFW1=VVOC(J+1)
	DFW2=VVOC(J+2)
	J=J+3
	IF(AND(DOBJ,VEBIT).EQ.0) GO TO 200	#VBIT = VFWIM?
	DFL1=DFW1				#YES.
	DFL2=DFW2
#
200	IF(AND(VFLAG,SIND).EQ.0) RETURN	#IND OBJECT?
	IFL1=-1					#ASSUME STD.
	IFL2=-1
	IOBJ=VVOC(J)
	IFW1=VVOC(J+1)
	IFW2=VVOC(J+2)
	J=J+3
	IF(AND(IOBJ,VEBIT).EQ.0) RETURN	#VBIT = VFWIM?
	IFL1=IFW1				#YES.
	IFL2=IFW2
	RETURN
#
	END

# SYNEQL-	TEST FOR SYNTAX EQUALITY
#
# DECLARATIONS
#
	LOGICAL FUNCTION SYNEQL(PREP,OBJ,SPREP,SFL1,SFL2)
	IMPLICIT INTEGER(A-Z)
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OBJFLG/ VABIT,VRBIT,VTBIT,VCBIT,VEBIT,VFBIT,VPMASK
#
	IF(OBJ.EQ.0) GO TO 100			#ANY OBJECT?
	SYNEQL=(PREP.EQ.AND(SPREP,VPMASK)).AND.((AND(SFL1,OFLAG1(OBJ)).OR.AND(SFL2,OFLAG2(OBJ))).NE.0)
	RETURN
#
100	SYNEQL=(PREP.EQ.0).AND.(SFL1.EQ.0).AND.(SFL2.EQ.0)
	RETURN
#
	END

# TAKEIT-	PARSER BASED TAKE OF OBJECT
#
# DECLARATIONS
#
	LOGICAL FUNCTION TAKEIT(OBJ,SFLAG)
	IMPLICIT INTEGER(A-Z)
#
	COMMON /OBJFLG/ VABIT,VRBIT,VTBIT,VCBIT,VEBIT,VFBIT,VPMASK
	COMMON /STAR/ MBASE,STRBIT
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
	COMMON /STATE/ MOVES,DEATHS,RWSCOR,MXSCOR,MXLOAD,
		LTSHFT,BLOC,MUNGRM,HS,EGSCOR,EGMXSC
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
# ADVENTURERS
#
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
		AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)

# TAKEIT, PAGE 2
#
	TAKEIT=.FALSE.				#ASSUME LOSES.
	IF((OBJ.EQ.0).OR.(OBJ.GT.STRBIT)) GO TO 4000	#NULL/STARS WIN.
	ODO2=ODESC2(OBJ)			#GET DESC.
	X=OCAN(OBJ)				#GET CONTAINER.
	IF((X.EQ.0).OR.(AND(SFLAG,VFBIT).EQ.0)) GO TO 500
	IF(AND(OFLAG2(X),OPENBT).NE.0) GO TO 500
	CALL RSPSUB(566,ODO2)			#CANT REACH.
	RETURN
#
500	IF(AND(SFLAG,VRBIT).EQ.0) GO TO 1000	#SHLD BE IN ROOM?
	IF(AND(SFLAG,VTBIT).EQ.0) GO TO 2000	#CAN BE TAKEN?
#
# SHOULD BE IN ROOM (VRBIT NE 0) AND CAN BE TAKEN (VTBIT NE 0)
#
	IF(SCHLST(0,0,HERE,0,0,OBJ).LE.0) GO TO 4000	#IF NOT, OK.
#
# ITS IN THE ROOM AND CAN BE TAKEN
#
	IF(AND(OFLAG1(OBJ),TAKEBT).NE.0) GO TO 3000
#
# NOT TAKEABLE.  IF WE CARE, FAIL.
#
	IF(AND(SFLAG,VCBIT).EQ.0) GO TO 4000	#IF NO CARE, RETURN.
	CALL RSPSUB(445,ODO2)
	RETURN
#
# 1000--	IT SHOULD NOT BE IN THE ROOM.
# 2000--	IT CANT BE TAKEN.
#
2000	IF(AND(SFLAG,VCBIT).EQ.0) GO TO 4000	#IF NO CARE, RETURN
1000	IF(SCHLST(0,0,HERE,0,0,OBJ).LE.0) GO TO 4000
	CALL RSPSUB(665,ODO2)
	RETURN

# TAKEIT, PAGE 3
#
# OBJECT IS IN THE ROOM, CAN BE TAKEN BY THE PARSER,
# AND IS TAKEABLE IN GENERAL.  IT IS NOT A STAR.
# IF IT IS INSIDE SOMETHING, THE CONTAINER IS OPEN.
# THE FOLLOWING CODE IS LIFTED FROM SUBROUTINE TAKE.
#
3000	IF(OBJ.NE.AVEHIC(WINNER)) GO TO 3500	#TAKE VEHICLE?
	CALL RSPEAK(672)
	RETURN
#
3500	IF(((X.NE.0).AND.(OADV(X).EQ.WINNER)).OR.
		((WEIGHT(0,OBJ,WINNER)+OSIZE(OBJ)).LE.MXLOAD))
		GO TO 3700
	CALL RSPEAK(558)			#TOO BIG.
	RETURN
#
3700	CALL NEWSTA(OBJ,559,0,0,WINNER)		#DO TAKE.
	OFLAG2(OBJ)=OFLAG2(OBJ).OR.TCHBT	#TOUCHED.
	CALL SCRUPD(OFVAL(OBJ))
	OFVAL(OBJ)=0
#
4000	TAKEIT=.TRUE.				#SUCCESS.
	RETURN
#
	END

# GWIM- GET WHAT I MEAN IN AMBIGOUS SITUATIONS
#
# DECLARATIONS
#
	INTEGER FUNCTION GWIM(SFLAG,SFW1,SFW2)
	IMPLICIT INTEGER(A-Z)
	LOGICAL TAKEIT,NOCARE
#
	COMMON /OBJFLG/ VABIT,VRBIT,VTBIT,VCBIT,VEBIT,VFBIT,VPMASK
	COMMON /STAR/ MBASE,STRBIT
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
# ADVENTURERS
#
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
		AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)

# GWIM, PAGE 2
#
	GWIM=-1					#ASSUME LOSE.
	AV=AVEHIC(WINNER)
	NOBJ=0
	NOCARE=AND(SFLAG,VCBIT).EQ.0
#
# FIRST SEARCH ADVENTURER
#
	IF(AND(SFLAG,VABIT).NE.0)
		NOBJ=FWIM(SFW1,SFW2,0,0,WINNER,NOCARE)
	IF(AND(SFLAG,VRBIT).NE.0) GO TO 100
50	GWIM=NOBJ
	RETURN
#
# ALSO SEARCH ROOM
#
100	ROBJ=FWIM(SFW1,SFW2,HERE,0,0,NOCARE)
	IF(ROBJ) 500,50,200			#TEST RESULT.
#
# ROBJ > 0
#
200	IF((AV.EQ.0).OR.(ROBJ.EQ.AV).OR.
		(AND(OFLAG2(ROBJ),FINDBT).NE.0)) GO TO 300
	IF(OCAN(ROBJ).NE.AV) GO TO 50		#UNREACHABLE? TRY NOBJ
300	IF(NOBJ.NE.0) RETURN			#IF AMBIGUOUS, RETURN.
	IF(.NOT.TAKEIT(ROBJ,SFLAG)) RETURN	#IF UNTAKEABLE, RETURN
	GWIM=ROBJ
500	RETURN
#
	END

# CLOCKD- CLOCK DEMON FOR INTERMOVE CLOCK EVENTS
#
# DECLARATIONS
#
	LOGICAL FUNCTION CLOCKD(X)
	IMPLICIT INTEGER (A-Z)
#
# CLOCK INTERRUPTS
#
	LOGICAL CFLAG
	COMMON /CEVENT/ CLNT,CTICK(25),CACTIO(25),CFLAG(25)
#
	CLOCKD=.FALSE.			#ASSUME NO ACTION.
	DO I=1,CLNT {
	  IF(.NOT.CFLAG(I) .OR.(CTICK(I).EQ.0)) NEXT
	  IF(CTICK(I).LT.0) GO TO 50		#PERMANENT ENTRY?
	  CTICK(I)=CTICK(I)-1
	  IF(CTICK(I).NE.0) NEXT		#TIMER EXPIRED?
50	  CLOCKD=.TRUE.
	  CALL CEVAPP(CACTIO(I))		#DO ACTION.
	  }
	RETURN
#
	END
# OAPPLI- OBJECT SPECIAL ACTION ROUTINES
#
# DECLARATIONS
#
	LOGICAL FUNCTION OAPPLI(RI,ARG)
	IMPLICIT INTEGER (A-Z)
	LOGICAL SOBJS,NOBJS
	LOGICAL QOPEN,QON,LIT
	LOGICAL MOVETO,RMINFO,CLOCKD
	LOGICAL THIEFP,CYCLOP,TROLLP,BALLOP,LIGHTP
	LOGICAL QEMPTY,QHERE,F,OPNCLS
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
	COMMON /STATE/ MOVES,DEATHS,RWSCOR,MXSCOR,MXLOAD,
		LTSHFT,BLOC,MUNGRM,HS,EGSCOR,EGMXSC
#
	COMMON /BATS/ BATDRP(9)
#
# ROOMS
#
	COMMON /ROOMS/ RLNT,RDESC2,RDESC1(215),REXIT(215),
		RACTIO(215),RVAL(215),RFLAG(215)
	INTEGER RRAND(215)
	EQUIVALENCE (RVAL,RRAND)
#
	COMMON /RFLAG/ RSEEN,RLIGHT,RLAND,RWATER,RAIR,
		RSACRD,RFILL,RMUNG,RBUCK,RHOUSE,RNWALL,REND
#
	COMMON /RINDEX/ WHOUS,LROOM,CELLA
	COMMON /RINDEX/ MTROL,MAZE1	
	COMMON /RINDEX/ MGRAT,MAZ15	
	COMMON /RINDEX/ FORE1,FORE3,CLEAR,RESER
	COMMON /RINDEX/ STREA,EGYPT,ECHOR
	COMMON /RINDEX/ TSHAF	
	COMMON /RINDEX/ BSHAF,MMACH,DOME,MTORC
	COMMON /RINDEX/ CAROU	
	COMMON /RINDEX/ RIDDL,LLD2,TEMP1,TEMP2,MAINT
	COMMON /RINDEX/ BLROO,TREAS,RIVR1,RIVR2,RIVR3,MCYCL
	COMMON /RINDEX/ RIVR4,RIVR5,FCHMP,FALLS,MBARR
	COMMON /RINDEX/ MRAIN,POG,VLBOT,VAIR1,VAIR2,VAIR3,VAIR4
	COMMON /RINDEX/ LEDG2,LEDG3,LEDG4,MSAFE,CAGER
	COMMON /RINDEX/ CAGED,TWELL,BWELL,ALICE,ALISM,ALITR
	COMMON /RINDEX/ MTREE,BKENT,BKVW,BKTWI,BKVAU,BKBOX
	COMMON /RINDEX/ CRYPT,TSTRS,MRANT,MREYE
	COMMON /RINDEX/ MRA,MRB,MRC,MRG,MRD,FDOOR
	COMMON /RINDEX/ MRAE,MRCE,MRCW,MRGE,MRGW,MRDW,INMIR
	COMMON /RINDEX/ SCORR,NCORR,PARAP,CELL,PCELL,NCELL
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
	COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
	COMMON /OINDEX/ WATER,ROPE,KNIFE,SWORD,LAMP,BLAMP,RUG
	COMMON /OINDEX/	LEAVE,TROLL,AXE
	COMMON /OINDEX/ RKNIF,KEYS,ICE,BAR
	COMMON /OINDEX/ COFFI,TORCH,TBASK,FBASK,IRBOX
	COMMON /OINDEX/ GHOST,TRUNK,BELL,BOOK,CANDL
	COMMON /OINDEX/ MATCH,TUBE,PUTTY,WRENC,SCREW,CYCLO,CHALI
	COMMON /OINDEX/ THIEF,STILL,WINDO,GRATE,DOOR
	COMMON /OINDEX/ HPOLE,LEAK,RBUTT,RAILI
	COMMON /OINDEX/ POT,STATU,IBOAT,DBOAT,PUMP,RBOAT
	COMMON /OINDEX/ STICK,BUOY,SHOVE,BALLO,RECEP,GUANO
	COMMON /OINDEX/ BROPE,HOOK1,HOOK2,SAFE,SSLOT,BRICK,FUSE
	COMMON /OINDEX/ GNOME,BLABE,DBALL,TOMB
	COMMON /OINDEX/ LCASE,CAGE,RCAGE,SPHER,SQBUT
	COMMON /OINDEX/ FLASK,POOL,SAFFR,BUCKE,ECAKE,ORICE,RDICE,BLICE
	COMMON /OINDEX/ ROBOT,FTREE,BILLS,PORTR,SCOL,ZGNOM
	COMMON /OINDEX/ EGG,BEGG,BAUBL,CANAR,BCANA
	COMMON /OINDEX/ YLWAL,RDWAL,PINDR,RBEAM
	COMMON /OINDEX/ ODOOR,QDOOR,CDOOR,NUM1,NUM8
	COMMON /OINDEX/ HANDS,WALL,LUNGS,SAILO,AVIAT,TEETH
	COMMON /OINDEX/ ITOBJ,EVERY,VALUA,OPLAY,WNORT,GWATE,MASTER
#
# CLOCK INTERRUPTS
#
	LOGICAL CFLAG
	COMMON /CEVENT/ CLNT,CTICK(25),CACTIO(25),CFLAG(25)
#
	COMMON /CINDEX/ CEVCUR,CEVMNT,CEVLNT,CEVMAT,CEVCND,
		CEVBAL,CEVBRN,CEVFUS,CEVLED,CEVSAF,CEVVLG,
		CEVGNO,CEVBUC,CEVSPH,CEVEGH,
			CEVFOR,CEVSCL,CEVZGI,CEVZGO,CEVSTE,
		CEVMRS,CEVPIN,CEVINQ,CEVFOL

#
# ADVENTURERS
#
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
		AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
#
	COMMON /AINDEX/ PLAYER,AROBOT,AMASTR
#
# VERBS
#
	COMMON /VINDEX/ CINTW,DEADXW,FRSTQW,INXW,OUTXW
	COMMON /VINDEX/ WALKIW,FIGHTW,FOOW
	COMMON /VINDEX/ MELTW,READW,INFLAW,DEFLAW,ALARMW,EXORCW
	COMMON /VINDEX/ PLUGW,KICKW,WAVEW,RAISEW,LOWERW,RUBW
	COMMON /VINDEX/ PUSHW,UNTIEW,TIEW,TIEUPW,TURNW,BREATW
	COMMON /VINDEX/ KNOCKW,LOOKW,EXAMIW,SHAKEW,MOVEW,TRNONW,TRNOFW
	COMMON /VINDEX/ OPENW,CLOSEW,FINDW,WAITW,SPINW,BOARDW,UNBOAW,TAKEW
	COMMON /VINDEX/ INVENW,FILLW,EATW,DRINKW,BURNW
	COMMON /VINDEX/ MUNGW,KILLW,ATTACW,SWINGW
	COMMON /VINDEX/ WALKW,TELLW,PUTW,DROPW,GIVEW,POURW,THROWW
	COMMON /VINDEX/ DIGW,LEAPW,STAYW,FOLLOW
	COMMON /VINDEX/ HELLOW,LOOKIW,LOOKUW,PUMPW,WINDW
	COMMON /VINDEX/ CLMBW,CLMBUW,CLMBDW,TRNTOW
#
# FLAGS
#
	LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL FOLLWF,SPELLF,sprf
	COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
		DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
		MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
			EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
		GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
		GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
		MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
		follwf,spellf,sprf(6)
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL
#
# FUNCTIONS AND DATA
#
	QOPEN(R)=AND(OFLAG2(R),OPENBT).NE.0
	QON(R)=AND(OFLAG1(R),ONBT).NE.0
	DATA MXSMP/99/

# OAPPLI, PAGE 2
#
	IF(RI.EQ.0) GO TO 10			#ZERO IS FALSE APP.
	IF(RI.LE.MXSMP) GO TO 100		#SIMPLE OBJECT?
	IF(PRSO.NE.0) ODO2=ODESC2(PRSO)
	IF(PRSI.NE.0) ODI2=ODESC2(PRSI)
	AV=AVEHIC(WINNER)
	FLOBTS=FLAMBT+LITEBT+ONBT
	OAPPLI=.TRUE.
#
	GO TO (2000,5000,10000,11000,12000,15000,18000,
		19000,20000,22000,25000,26000,32000,35000,39000,40000,
		45000,47000,48000,49000,50000,51000,52000,54000,55000,
		 56000,57000,58000,59000,60000,61000),
			(RI-MXSMP)
	CALL BUG(6,RI)
#
# RETURN HERE TO DECLARE FALSE RESULT
#
10	OAPPLI=.FALSE.
	RETURN
#
# SIMPLE OBJECTS, PROCESSED EXTERNALLY.
#
100	IF(RI.LT.32) OAPPLI=SOBJS(RI,ARG)
	IF(RI.GE.32) OAPPLI=NOBJS(RI,ARG)
	RETURN

# OAPPLI, PAGE 3
#
# O100--	MACHINE FUNCTION
#
2000	IF(HERE.NE.MMACH) GO TO 10		#NOT HERE? F
	OAPPLI=OPNCLS(MACHI,123,124)		#HANDLE OPN/CLS.
	RETURN
#
# O101--	WATER FUNCTION
#
5000	IF(PRSA.NE.FILLW) GO TO 5050		#FILL IS
	PRSA=PUTW				#MADE INTO
	I=PRSI
	PRSI=PRSO
	PRSO=I					#PUT WATER IN OBJ.
	I=ODI2
	ODI2=ODO2
	ODO2=I
5050	IF(PRSA.NE.THROWW) GO TO 5100		#THROW?
	CALL NEWSTA(PRSO,132,0,0,0)		#EVAPORATES.
	RETURN
#
5100	IF((PRSA.NE.DROPW).AND.(PRSA.NE.POURW).AND.(PRSA.NE.GIVEW))
		GO TO 5200			#DROP?
	IF(AV.NE.0) GO TO 5150			#INTO VEHICLE?
	CALL NEWSTA(PRSO,133,0,0,0)		#EVAPORATES.
	RETURN
#
5150	CALL NEWSTA(WATER,0,0,AV,0)		#INTO VEHICLE.
	CALL RSPSUB(296,ODESC2(AV))		#DESCRIBE.
	RETURN
#
5200	IF((PRSA.NE.TAKEW).AND.(PRSA.NE.PUTW)) GO TO 10
	IF((AV.EQ.PRSI).AND.(AV.NE.0)) GO TO 5150
	IF((PRSI.NE.0).AND.(PRSI.NE.BOTTL)) GO TO 5300
	IF(OADV(BOTTL).NE.WINNER) GO TO 5400	#GOT BOTTLE?
	I=612
	IF(.NOT.QOPEN(BOTTL)) GO TO 5250	#BOTTLE OPEN?
	I=613
	IF(.NOT.QEMPTY(BOTTL)) GO TO 5250	#BOTTLE EMPTY?
	I=614
	CALL NEWSTA(WATER,0,0,BOTTL,0)		#WATER INTO BOTTLE
5250	CALL RSPEAK(I)				#DESCRIBE.
	RETURN
#
5300	CALL RSPSUB(297,ODI2)			#WATER WONT GO
	CALL NEWSTA(PRSO,0,0,0,0)		#EVAPORATES.
	RETURN
#
# BOTTLE NOT ON WINNER.
#
5400	IF((OCAN(WATER).EQ.BOTTL).AND.(PRSA.EQ.TAKEW).AND.
		(PRSI.EQ.0)) GO TO 5500		#TAKE W IN B?
	CALL RSPEAK(615)			#NO, LOSE.
	RETURN
#
5500	IF(QHERE(BOTTL,HERE)) GO TO 5600	#BOTTLE HERE?
	CALL RSPSUB(566,ODESC2(BOTTL))		#NO, CANT TAKE IT.
	RETURN
#
5600	CALL NEWSTA(BOTTL,559,0,0,WINNER)	#FINALLY, TAKE BOTTLE.
	RETURN

# OAPPLI, PAGE 4
#
# O102--	LEAF PILE
#
10000	IF(PRSA.NE.BURNW) GO TO 10500		#BURN?
	IF(OROOM(PRSO).EQ.0) GO TO 10100	#WAS HE CARRYING?
	CALL NEWSTA(PRSO,158,0,0,0)		#NO, BURN IT.
	RETURN
#
10100	CALL NEWSTA(PRSO,0,HERE,0,0)		#DROP LEAVES.
	CALL JIGSUP(159)			#BURN HIM.
	RETURN
#
10500	IF(PRSA.NE.MOVEW) GO TO 10600		#MOVE?
	CALL RSPEAK(2)				#DONE.
	RETURN
#
10600	IF((PRSA.NE.LOOKUW).OR.(RVCLR.NE.0)) GO TO 10
	CALL RSPEAK(344)			#LOOK UNDER?
	RETURN
#
# O103--	TROLL, DONE EXTERNALLY.
#
11000	OAPPLI=TROLLP(ARG)			#TROLL PROCESSOR.
	RETURN
#
# O104--	RUSTY KNIFE.
#
12000	IF(PRSA.NE.TAKEW) GO TO 12100		#TAKE?
	IF(OADV(SWORD).EQ.WINNER) CALL RSPEAK(160)	#PULSE SWORD.
	GO TO 10
#
12100	IF((((PRSA.NE.ATTACW).AND.(PRSA.NE.KILLW)).OR.
		(PRSI.NE.RKNIF)).AND.
		(((PRSA.NE.SWINGW).AND.(PRSA.NE.THROWW)).OR.
			(PRSO.NE.RKNIF))) GO TO 10
	CALL NEWSTA(RKNIF,0,0,0,0)		#KILL KNIFE.
	CALL JIGSUP(161)			#KILL HIM.
	RETURN

# OAPPLI, PAGE 5
#
# O105--	GLACIER
#
15000	IF(PRSA.NE.THROWW) GO TO 15500	#THROW?
	IF(PRSO.NE.TORCH) GO TO 15400		#TORCH?
	CALL NEWSTA(ICE,169,0,0,0)		#MELT ICE.
	ODESC1(TORCH)=174			#MUNG TORCH.
	ODESC2(TORCH)=173
	OFLAG1(TORCH)=AND(OFLAG1(TORCH),NOT(FLOBTS))
	CALL NEWSTA(TORCH,0,STREA,0,0)		#MOVE TORCH.
	GLACRF=.TRUE.				#GLACIER GONE.
	IF(.NOT.LIT(HERE)) CALL RSPEAK(170)	#IN DARK?
	RETURN
#
15400	CALL RSPEAK(171)			#JOKE IF NOT TORCH.
	RETURN
#
15500	IF((PRSA.NE.MELTW).OR.(PRSO.NE.ICE)) GO TO 10
	IF(AND(OFLAG1(PRSI),FLOBTS).EQ.FLOBTS) GO TO 15600
	CALL RSPSUB(298,ODI2)			#CANT MELT WITH THAT.
	RETURN
#
15600	GLACMF=.TRUE.				#PARTIAL MELT.
	IF(PRSI.NE.TORCH) GO TO 15700		#MELT WITH TORCH?
	ODESC1(TORCH)=174			#MUNG TORCH.
	ODESC2(TORCH)=173
	OFLAG1(TORCH)=AND(OFLAG1(TORCH),NOT(FLOBTS))
15700	CALL JIGSUP(172)			#DROWN.
	RETURN
#
# O106--	BLACK BOOK
#
18000	IF(PRSA.NE.OPENW) GO TO 18100		#OPEN?
	CALL RSPEAK(180)			#JOKE.
	RETURN
#
18100	IF(PRSA.NE.CLOSEW) GO TO 18200		#CLOSE?
	CALL RSPEAK(181)
	RETURN
#
18200	IF(PRSA.NE.BURNW) GO TO 10		#BURN?
	CALL NEWSTA(PRSO,0,0,0,0)		#FATAL JOKE.
	CALL JIGSUP(182)
	RETURN

# OAPPLI, PAGE 6
#
# O107--	CANDLES, PROCESSED EXTERNALLY
#
19000	OAPPLI=LIGHTP(CANDL)
	RETURN
#
# O108--	MATCHES, PROCESSED EXTERNALLY
#
20000	OAPPLI=LIGHTP(MATCH)
	RETURN
#
# O109--	CYCLOPS, PROCESSED EXTERNALLY.
#
22000	OAPPLI=CYCLOP(ARG)			#CYCLOPS
	RETURN
#
# O110--	THIEF, PROCESSED EXTERNALLY
#
25000	OAPPLI=THIEFP(ARG)
	RETURN
#
# O111--	WINDOW
#
26000	OAPPLI=OPNCLS(WINDO,208,209)		#OPEN/CLS WINDOW.
	RETURN
#
# O112--	PILE OF BODIES
#
32000	IF(PRSA.NE.TAKEW) GO TO 32500		#TAKE?
	CALL RSPEAK(228)			#CANT.
	RETURN
#
32500	IF((PRSA.NE.BURNW).AND.(PRSA.NE.MUNGW)) GO TO 10
	IF(ONPOLF) RETURN			#BURN OR MUNG?
	ONPOLF=.TRUE.				#SET HEAD ON POLE.
	CALL NEWSTA(HPOLE,0,LLD2,0,0)
	CALL JIGSUP(229)			#BEHEADED.
	RETURN
#
# O113--	VAMPIRE BAT
#
35000	CALL RSPEAK(50)				#TIME TO FLY, JACK.
	F=MOVETO(BATDRP(RND(9)+1),WINNER)	#SELECT RANDOM DEST.
	F=RMINFO(.FALSE.)
	RETURN

# OAPPLI, PAGE 7
#
# O114--	STICK
#
39000	IF(PRSA.NE.WAVEW) GO TO 10		#WAVE?
	IF(HERE.EQ.MRAIN) GO TO 39500		#ON RAINBOW?
	IF((HERE.EQ.POG).OR.(HERE.EQ.FALLS)) GO TO 39200
	CALL RSPEAK(244)			#NOTHING HAPPENS.
	RETURN
#
39200	OFLAG1(POT)=OFLAG1(POT).OR.VISIBT	#MAKE GOLD VISIBLE.
	RAINBF=.NOT. RAINBF			#COMPLEMENT RAINBOW.
	I=245					#ASSUME OFF.
	IF(RAINBF) I=246			#IF ON, SOLID.
	CALL RSPEAK(I)				#DESCRIBE.
	RETURN
#
39500	RAINBF=.FALSE.				#ON RAINBOW,
	CALL JIGSUP(247)			#TAKE A FALL.
	RETURN
#
# O115--	BALLOON, HANDLED EXTERNALLY
#
40000	OAPPLI=BALLOP(ARG)
	RETURN
#
# O116--	HEADS
#
45000	IF(PRSA.NE.HELLOW) GO TO 45100		#HELLO HEADS?
	CALL RSPEAK(633)			#TRULY BIZARRE.
	RETURN
#
45100	IF(PRSA.EQ.READW) GO TO 10		#READ IS OK.
	CALL NEWSTA(LCASE,260,LROOM,0,0)	#MAKE LARGE CASE.
	I=ROBADV(WINNER,0,LCASE,0)+ROBRM(HERE,100,0,LCASE,0)
	CALL JIGSUP(261)			#KILL HIM.
	RETURN

# OAPPLI, PAGE 8
#
# O117--	SPHERE
#
47000	IF(CAGESF.OR.(PRSA.NE.TAKEW)) GO TO 10	#TAKE?
	IF(WINNER.NE.PLAYER) GO TO 47500	#ROBOT TAKE?
	CALL RSPEAK(263)			#NO, DROP CAGE.
	IF(OROOM(ROBOT).NE.HERE) GO TO 47200	#ROBOT HERE?
	F=MOVETO(CAGED,WINNER)			#YES, MOVE INTO CAGE.
	CALL NEWSTA(ROBOT,0,CAGED,0,0)	#MOVE ROBOT.
	AROOM(AROBOT)=CAGED
	OFLAG1(ROBOT)=OFLAG1(ROBOT).OR.NDSCBT	#DONT DESCRIBE ROBOT.
	CTICK(CEVSPH)=10			#GET OUT IN 10 OR ELSE.
	RETURN
#
47200	CALL NEWSTA(SPHER,0,0,0,0)		#YOURE DEAD.
	RFLAG(CAGER)=RFLAG(CAGER).OR.RMUNG	#MUNG CAGE ROOM.
	RRAND(CAGER)=147
	CALL JIGSUP(148)			#MUNG PLAYER.
	RETURN
#
47500	CALL NEWSTA(SPHER,0,0,0,0)		#ROBOT TRIED,
	CALL NEWSTA(ROBOT,264,0,0,0)		#KILL HIM.
	CALL NEWSTA(CAGE,0,HERE,0,0)		#INSERT MANGLED CAGE.
	RETURN
#
# O118--	GEOMETRICAL BUTTONS
#
48000	IF(PRSA.NE.PUSHW) GO TO 10		#PUSH?
	I=PRSO-SQBUT+1				#GET BUTTON INDEX.
	IF((I.LE.0).OR.(I.GE.4)) GO TO 10	#A BUTTON?
	IF(WINNER.NE.PLAYER) GO TO (48100,48200,48300),I
	CALL JIGSUP(265)			#YOU PUSHED, YOU DIE.
	RETURN
#
48100	I=267
	IF(CAROZF) I=266			#SPEED UP?
	CAROZF=.TRUE.
	CALL RSPEAK(I)
	RETURN
#
48200	I=266					#ASSUME NO CHANGE.
	IF(CAROZF) I=268
	CAROZF=.FALSE.
	CALL RSPEAK(I)
	RETURN
#
48300	CAROFF=.NOT.CAROFF			#FLIP CAROUSEL.
	IF(.NOT.QHERE(IRBOX,CAROU)) RETURN	#IRON BOX IN CAROUSEL?
	CALL RSPEAK(269)			#YES, THUMP.
	OFLAG1(IRBOX)=OFLAG1(IRBOX).XOR.VISIBT	#COMPLEMENT VISIBILITY.
	IF(CAROFF) RFLAG(CAROU)=AND(RFLAG(CAROU),NOT(RSEEN))
	RETURN
#
# O119--	FLASK FUNCTION
#
49000	IF(PRSA.EQ.OPENW) GO TO 49100		#OPEN?
	IF((PRSA.NE.MUNGW).AND.(PRSA.NE.THROWW)) GO TO 10
	CALL NEWSTA(FLASK,270,0,0,0)		#KILL FLASK.
49100	RFLAG(HERE)=RFLAG(HERE).OR.RMUNG	#MUNG ROOM.
	RRAND(HERE)=271
	CALL JIGSUP(272)			#POISONED.
	RETURN
#
# O120--	BUCKET FUNCTION
#
50000	IF(ARG.NE.2) GO TO 10			#READOUT?
	IF((OCAN(WATER).NE.BUCKE).OR.BUCKTF) GO TO 50500
	BUCKTF=.TRUE.				#BUCKET AT TOP.
	CTICK(CEVBUC)=100			#START COUNTDOWN.
	CALL NEWSTA(BUCKE,290,TWELL,0,0)	#REPOSITION BUCKET.
	GO TO 50900				#FINISH UP.
#
50500	IF((OCAN(WATER).EQ.BUCKE).OR..NOT.BUCKTF) GO TO 10
	BUCKTF=.FALSE.
	CALL NEWSTA(BUCKE,291,BWELL,0,0)	#BUCKET AT BOTTOM.
50900	IF(AV.NE.BUCKE) RETURN			#IN BUCKET?
	F=MOVETO(OROOM(BUCKE),WINNER)	#MOVE ADVENTURER.
	F=RMINFO(.FALSE.)			#DESCRIBE ROOM.
	RETURN

# OAPPLI, PAGE 9
#
# O121--	EATME CAKE
#
51000	IF((PRSA.NE.EATW).OR.(PRSO.NE.ECAKE).OR.
		(HERE.NE.ALICE)) GO TO 10	#EAT CAKE IN ALICEROOM?
	CALL NEWSTA(ECAKE,273,0,0,0)		#VANISH CAKE.
	OFLAG1(ROBOT)=AND(OFLAG1(ROBOT),NOT(VISIBT))	#VANISH ROBOT.
	DO I=1,OLNT {				#MAKE OBJECTS BIG.
	  IF((OROOM(I).NE.ALICE).OR.(OSIZE(I).EQ.10000)) {
		GO TO 51100
		}
	  OSIZE(I)=OSIZE(I)*64
	  OROOM(I)=ALISM
	  }
	OAPPLI=MOVETO(ALISM,WINNER)		#MOVE TO ALICE SMALL.
	RETURN
#
# O122--	ICINGS
#
52000	IF(PRSA.NE.READW) GO TO 52200		#READ?
	I=274					#CANT READ.
	IF(PRSI.NE.0) I=275			#THROUGH SOMETHING?
	IF(PRSI.EQ.BOTTL) I=276			#THROUGH BOTTLE?
	IF(PRSI.EQ.FLASK) I=277+(PRSO-ORICE)	#THROUGH FLASK?
	CALL RSPEAK(I)				#READ FLASK.
	RETURN
#
52200	IF((PRSA.NE.THROWW).OR.(PRSO.NE.RDICE).OR.(PRSI.NE.POOL)) {
		GO TO 52300			#THROW RDICE AT POOL?
		}
	CALL NEWSTA(POOL,280,0,0,0)		#VANISH POOL.
	OFLAG1(SAFFR)=OFLAG1(SAFFR).OR.VISIBT	#MATERIALIZE SPICES.
	RETURN
#
52300	IF((HERE.NE.ALICE).AND.(HERE.NE.ALISM).AND.(HERE.NE.ALITR)) {
		GO TO 10			#IN WONDERLAND?
		}
	IF(((PRSA.NE.EATW).AND.(PRSA.NE.THROWW)).OR.
		(PRSO.NE.ORICE)) GO TO 52400	#THROW ORANGE ICE?
	CALL NEWSTA(ORICE,0,0,0,0)		#VANISH ORANGE ICE.
	RFLAG(HERE)=RFLAG(HERE).OR.RMUNG	#VANISH ROOM.
	RRAND(HERE)=281
	CALL JIGSUP(282)			#VANISH ADVENTURER.
	RETURN
#
52400	IF((PRSA.NE.EATW).OR.(PRSO.NE.BLICE)) {
		GO TO 10			#EAT BLUE ICE?
		}
	CALL NEWSTA(BLICE,283,0,0,0)		#VANISH BLUE ICE.
	IF(HERE.NE.ALISM) GO TO 52500		#IN REDUCED ROOM?
	OFLAG1(ROBOT)=OFLAG1(ROBOT).OR.VISIBT	#MATERIALIZE ROBOT.
	DO I=1,OLNT {				#ENLARGE WORLD.
	  IF((OROOM(I).NE.HERE).OR.(OSIZE(I).EQ.10000)) {
		NEXT
		}
	  OROOM(I)=ALICE
	  OSIZE(I)=OSIZE(I)/64
	  }
	OAPPLI=MOVETO(ALICE,WINNER)		#RETURN
	RETURN
#
52500	CALL JIGSUP(284)			#ENLARGED IN WRONG ROOM.
	RETURN
#
# O123--	BRICK
#
54000	IF(PRSA.NE.BURNW) GO TO 10		#BURN?
	CALL JIGSUP(150)			#BOOM!
	RETURN
#
# O124--	MYSELF
#
55000	IF(PRSA.NE.GIVEW) GO TO 55100		#GIVE?
	CALL NEWSTA(PRSO,2,0,0,PLAYER)		#DONE.
	RETURN
#
55100	IF(PRSA.NE.TAKEW) GO TO 55200		#TAKE?
	CALL RSPEAK(286)			#JOKE.
	RETURN
#
55200	IF((PRSA.NE.KILLW).AND.(PRSA.NE.MUNGW)) GO TO 10
	CALL JIGSUP(287)			#KILL, NO JOKE.
	RETURN

# OAPPLI, PAGE 10
#
# O125--	PANELS INSIDE MIRROR
#
56000	IF(PRSA.NE.PUSHW) GO TO 10		#PUSH?
	IF(POLEUF.NE.0) GO TO 56100		#SHORT POLE UP?
	I=731					#NO, WONT BUDGE.
	IF(MOD(MDIR,180).EQ.0) I=732		#DIFF MSG IF N-S.
	CALL RSPEAK(I)				#TELL WONT MOVE.
	RETURN
#
56100	IF(MLOC.NE.MRG) GO TO 56200		#IN GDN ROOM?
	CALL RSPEAK(733)			#YOU LOSE.
	CALL JIGSUP(685)
	RETURN
#
56200	I=831					#ROTATE L OR R.
	IF((PRSO.EQ.RDWAL).OR.(PRSO.EQ.YLWAL)) I=830
	CALL RSPEAK(I)				#TELL DIRECTION.
	MDIR=MOD(MDIR+45+(270*(I-830)),360)	#CALCULATE NEW DIR.
	CALL RSPSUB(734,695+(MDIR/45))		#TELL NEW DIR.
	IF(WDOPNF) CALL RSPEAK(730)		#IF PANEL OPEN, CLOSE.
	WDOPNF=.FALSE.
	RETURN					#DONE.
#
# O126--	ENDS INSIDE MIRROR
#
57000	IF(PRSA.NE.PUSHW) GO TO 10		#PUSH?
	IF(MOD(MDIR,180).EQ.0) GO TO 57100	#MIRROR N-S?
	CALL RSPEAK(735)			#NO, WONT BUDGE.
	RETURN
#
57100	IF(PRSO.NE.PINDR) GO TO 57300		#PUSH PINE WALL?
	IF(((MLOC.EQ.MRC).AND.(MDIR.EQ.180)).OR.
		((MLOC.EQ.MRD).AND.(MDIR.EQ.0)).OR.
		(MLOC.EQ.MRG)) GO TO 57200		#IN VIEW OF GDN?
	CALL RSPEAK(736)			#NO, OPENS.
	WDOPNF=.TRUE.				#INDICATE OPEN.
	CFLAG(CEVPIN)=.TRUE.			#TIME OPENING.
	CTICK(CEVPIN)=5
	RETURN
#
57200	CALL RSPEAK(737)			#GDN SEES YOU, DIE.
	CALL JIGSUP(685)
	RETURN
#
57300	NLOC=MLOC-1				#NEW LOC IF SOUTH.
	IF(MDIR.EQ.0) NLOC=MLOC+1		#NEW LOC IF NORTH.
	IF((NLOC.GE.MRA).AND.(NLOC.LE.MRD)) GO TO 57400
	CALL RSPEAK(738)			#HAVE REACHED END.
	RETURN
#
57400	I=699					#ASSUME SOUTH.
	IF(MDIR.EQ.0) I=695			#NORTH.
	J=739					#ASSUME SMOOTH.
	IF(POLEUF.NE.0) J=740			#POLE UP, WOBBLES.
	CALL RSPSUB(J,I)			#DESCRIBE.
	MLOC=NLOC
	IF(MLOC.NE.MRG) RETURN			#NOW IN GDN ROOM?
#
	IF(POLEUF.NE.0) GO TO 57500		#POLE UP, GDN SEES.
	IF(MROPNF.OR.WDOPNF) GO TO 57600	#DOOR OPEN, GDN SEES.
	IF(MR1F.AND.MR2F) RETURN		#MIRRORS INTACT, OK.
	CALL RSPEAK(742)			#MIRRORS BROKEN, DIE.
	CALL JIGSUP(743)
	RETURN
#
57500	CALL RSPEAK(741)			#POLE UP, DIE.
	CALL JIGSUP(743)
	RETURN
#
57600	CALL RSPEAK(744)			#DOOR OPEN, DIE.
	CALL JIGSUP(743)
	RETURN

# OAPPLI, PAGE 11
#
# O127--	GLOBAL GUARDIANS
#
58000	IF((PRSA.NE.ATTACW).AND.(PRSA.NE.KILLW).AND.
		(PRSA.NE.MUNGW)) GO TO 58100		#AGGRESSIVE?
	CALL JIGSUP(745)			#LOSE.
	RETURN
#
58100	IF(PRSA.NE.HELLOW) GO TO 10		#HELLO?
	CALL RSPEAK(746)			#NO REPLY.
	RETURN
#
# O128--	GLOBAL MASTER
#
59000	IF((PRSA.NE.ATTACW).AND.(PRSA.NE.KILLW).AND.
		(PRSA.NE.MUNGW)) GO TO 59100		#AGGRESSIVE?
	CALL JIGSUP(747)			#BAD IDEA.
	RETURN
#
59100	IF(PRSA.NE.TAKEW) GO TO 10		#TAKE?
	CALL RSPEAK(748)			#JOKE.
	RETURN
#
# O129--	NUMERAL FIVE (FOR JOKE)
#
60000	IF(PRSA.NE.TAKEW) GO TO 10		#TAKE FIVE?
	CALL RSPEAK(419)			#TIME PASSES.
	DO I=1,3 {				#WAIT A WHILE.
	  IF(CLOCKD(X)) RETURN
	  }
	RETURN
#
# O130--	CRYPT FUNCTION
#
61000	IF(.NOT.ENDGMF) GO TO 45000		#IF NOT EG, DIE.
	IF(PRSA.NE.OPENW) GO TO 61100		#OPEN?
	I=793
	IF(QOPEN(TOMB)) I=794
	CALL RSPEAK(I)
	OFLAG2(TOMB)=OFLAG2(TOMB).OR.OPENBT	#NOW TOMB WITH VIEW.
	RETURN
#
61100	IF(PRSA.NE.CLOSEW) GO TO 45000		#CLOSE?
	I=795
	IF(QOPEN(TOMB)) I=796
	CALL RSPEAK(I)
	OFLAG2(TOMB)=(OFLAG2(TOMB),NOT(OPENBT))
	IF(HERE.EQ.CRYPT) CTICK(CEVSTE)=3	#IF IN CRYPT, START EG.
	RETURN
#
	END

# SVERBS-	SIMPLE VERBS PROCESSOR
#	ALL VERBS IN THIS ROUTINE MUST BE INDEPENDANT
#	OF OBJECT ACTIONS
#
# DECLARATIONS
#
	LOGICAL FUNCTION SVERBS(RI)
	IMPLICIT INTEGER (A-Z)
	LOGICAL MOVETO,YESNO
	LOGICAL RMINFO
	LOGICAL QOPEN
	LOGICAL FINDXT,QHERE,F
	INTEGER JOKES(20)
	LOGICAL ANSSTR(78)
	LOGICAL P1(6),P2(6),CH(6)
	INTEGER ANSWER(28)
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	common /spare/ccflg
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
	COMMON /STATE/ MOVES,DEATHS,RWSCOR,MXSCOR,MXLOAD,
		LTSHFT,BLOC,MUNGRM,HS,EGSCOR,EGMXSC
#
# SCREEN OF LIGHT
#
	COMMON /SCREEN/ FROMDR,SCOLRM,SCOLAC
	COMMON /SCREEN/ SCOLDR(8),SCOLWL(12)
#
# MISCELLANEOUS VARIABLES
#
	LOGICAL INBUF
	COMMON /INPUT/ INLNT,INBUF(78)
	COMMON /VERS/ VMAJ,VMIN,VEDIT
	COMMON /CHAN/ INPCH,OUTCH,DBCH
#
# ROOMS
#
	COMMON /ROOMS/ RLNT,RDESC2,RDESC1(215),REXIT(215),
		RACTIO(215),RVAL(215),RFLAG(215)
	INTEGER RRAND(215)
	EQUIVALENCE (RVAL,RRAND)
#
	COMMON /RFLAG/ RSEEN,RLIGHT,RLAND,RWATER,RAIR,
		RSACRD,RFILL,RMUNG,RBUCK,RHOUSE,RNWALL,REND
#
	COMMON /RINDEX/ WHOUS,LROOM,CELLA
	COMMON /RINDEX/ MTROL,MAZE1	
	COMMON /RINDEX/ MGRAT,MAZ15	
	COMMON /RINDEX/ FORE1,FORE3,CLEAR,RESER
	COMMON /RINDEX/ STREA,EGYPT,ECHOR
	COMMON /RINDEX/ TSHAF	
	COMMON /RINDEX/ BSHAF,MMACH,DOME,MTORC
	COMMON /RINDEX/ CAROU	
	COMMON /RINDEX/ RIDDL,LLD2,TEMP1,TEMP2,MAINT
	COMMON /RINDEX/ BLROO,TREAS,RIVR1,RIVR2,RIVR3,MCYCL
	COMMON /RINDEX/ RIVR4,RIVR5,FCHMP,FALLS,MBARR
	COMMON /RINDEX/ MRAIN,POG,VLBOT,VAIR1,VAIR2,VAIR3,VAIR4
	COMMON /RINDEX/ LEDG2,LEDG3,LEDG4,MSAFE,CAGER
	COMMON /RINDEX/ CAGED,TWELL,BWELL,ALICE,ALISM,ALITR
	COMMON /RINDEX/ MTREE,BKENT,BKVW,BKTWI,BKVAU,BKBOX
	COMMON /RINDEX/ CRYPT,TSTRS,MRANT,MREYE
	COMMON /RINDEX/ MRA,MRB,MRC,MRG,MRD,FDOOR
	COMMON /RINDEX/ MRAE,MRCE,MRCW,MRGE,MRGW,MRDW,INMIR
	COMMON /RINDEX/ SCORR,NCORR,PARAP,CELL,PCELL,NCELL
#
# EXITS
#
	COMMON /EXITS/ XLNT,TRAVEL(870)
#
	COMMON /CURXT/ XTYPE,XROOM1,XSTRNG,XACTIO,XOBJ
	EQUIVALENCE (XFLAG,XOBJ)
#
	COMMON /XPARS/ XRMASK,XDMASK,XFMASK,XFSHFT,XASHFT,
		XELNT(4),XNORM,XNO,XCOND,XDOOR,XLFLAG
#
	COMMON /XSRCH/ XMIN,XMAX,XDOWN,XUP,
		XNORTH,XSOUTH,XENTER,XEXIT
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
	COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
	COMMON /OINDEX/ WATER,ROPE,KNIFE,SWORD,LAMP,BLAMP,RUG
	COMMON /OINDEX/	LEAVE,TROLL,AXE
	COMMON /OINDEX/ RKNIF,KEYS,ICE,BAR
	COMMON /OINDEX/ COFFI,TORCH,TBASK,FBASK,IRBOX
	COMMON /OINDEX/ GHOST,TRUNK,BELL,BOOK,CANDL
	COMMON /OINDEX/ MATCH,TUBE,PUTTY,WRENC,SCREW,CYCLO,CHALI
	COMMON /OINDEX/ THIEF,STILL,WINDO,GRATE,DOOR
	COMMON /OINDEX/ HPOLE,LEAK,RBUTT,RAILI
	COMMON /OINDEX/ POT,STATU,IBOAT,DBOAT,PUMP,RBOAT
	COMMON /OINDEX/ STICK,BUOY,SHOVE,BALLO,RECEP,GUANO
	COMMON /OINDEX/ BROPE,HOOK1,HOOK2,SAFE,SSLOT,BRICK,FUSE
	COMMON /OINDEX/ GNOME,BLABE,DBALL,TOMB
	COMMON /OINDEX/ LCASE,CAGE,RCAGE,SPHER,SQBUT
	COMMON /OINDEX/ FLASK,POOL,SAFFR,BUCKE,ECAKE,ORICE,RDICE,BLICE
	COMMON /OINDEX/ ROBOT,FTREE,BILLS,PORTR,SCOL,ZGNOM
	COMMON /OINDEX/ EGG,BEGG,BAUBL,CANAR,BCANA
	COMMON /OINDEX/ YLWAL,RDWAL,PINDR,RBEAM
	COMMON /OINDEX/ ODOOR,QDOOR,CDOOR,NUM1,NUM8
	COMMON /OINDEX/ HANDS,WALL,LUNGS,SAILO,AVIAT,TEETH
	COMMON /OINDEX/ ITOBJ,EVERY,VALUA,OPLAY,WNORT,GWATE,MASTER
#
# CLOCK INTERRUPTS
#
	LOGICAL CFLAG
	COMMON /CEVENT/ CLNT,CTICK(25),CACTIO(25),CFLAG(25)
#
	COMMON /CINDEX/ CEVCUR,CEVMNT,CEVLNT,CEVMAT,CEVCND,
		CEVBAL,CEVBRN,CEVFUS,CEVLED,CEVSAF,CEVVLG,
		CEVGNO,CEVBUC,CEVSPH,CEVEGH,
			CEVFOR,CEVSCL,CEVZGI,CEVZGO,CEVSTE,
		CEVMRS,CEVPIN,CEVINQ,CEVFOL

#
# ADVENTURERS
#
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
		AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
#
	COMMON /AINDEX/ PLAYER,AROBOT,AMASTR
#
# VERBS
#
	COMMON /VINDEX/ CINTW,DEADXW,FRSTQW,INXW,OUTXW
	COMMON /VINDEX/ WALKIW,FIGHTW,FOOW
	COMMON /VINDEX/ MELTW,READW,INFLAW,DEFLAW,ALARMW,EXORCW
	COMMON /VINDEX/ PLUGW,KICKW,WAVEW,RAISEW,LOWERW,RUBW
	COMMON /VINDEX/ PUSHW,UNTIEW,TIEW,TIEUPW,TURNW,BREATW
	COMMON /VINDEX/ KNOCKW,LOOKW,EXAMIW,SHAKEW,MOVEW,TRNONW,TRNOFW
	COMMON /VINDEX/ OPENW,CLOSEW,FINDW,WAITW,SPINW,BOARDW,UNBOAW,TAKEW
	COMMON /VINDEX/ INVENW,FILLW,EATW,DRINKW,BURNW
	COMMON /VINDEX/ MUNGW,KILLW,ATTACW,SWINGW
	COMMON /VINDEX/ WALKW,TELLW,PUTW,DROPW,GIVEW,POURW,THROWW
	COMMON /VINDEX/ DIGW,LEAPW,STAYW,FOLLOW
	COMMON /VINDEX/ HELLOW,LOOKIW,LOOKUW,PUMPW,WINDW
	COMMON /VINDEX/ CLMBW,CLMBUW,CLMBDW,TRNTOW
#
# FLAGS
#
	LOGICAL flags(50)
	EQUIVALENCE (FLAGS(1),TROLLF)
	LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL FOLLWF,SPELLF,sprf
	COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
		DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
		MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
			EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
		GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
		GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
		MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
		follwf,spellf,sprf(6)
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL
#
# FUNCTIONS AND DATA
#
	QOPEN(R)=AND(OFLAG2(R),OPENBT).NE.0
	DATA MXNOP/49/,MXJOKE/69/
	DATA JOKES/4,5,3,304,305,306,307,308,309,310,
		311,312,313,5314,5319,324,325,0,0,0/
	DATA ANSWER/0,6,1,6,2,5,3,5,4,3,4,6,4,6,4,5,
		5,5,5,4,5,6,6,10,7,4,7,6/
	DATA ANSSTR/'T','E','M','P','L','E',
		'F','O','R','E','S','T',
		'3','0','0','0','3',
			'F','L','A','S','K',
		'R','U','B',
		'F','O','N','D','L','E',
		'C','A','R','R','E','S',
		'T','O','U','C','H',
		'B','O','N','E','S',
		'B','O','D','Y',
		'S','K','E','L','E','T',
		'R','U','S','T','Y','K','N','I','F','E',
			'N','O','N','E',
		'N','O','W','H','E','R',0/

# SVERBS, PAGE 2
#
	SVERBS=.TRUE.				#ASSUME WINS.
	IF(PRSO.NE.0) ODO2=ODESC2(PRSO)		#SET UP DESCRIPTORS.
	IF(PRSI.NE.0) ODI2=ODESC2(PRSI)
#
	IF(RI.EQ.0) CALL BUG(7,RI)		#ZERO IS VERBOTEN.
	IF(RI.LE.MXNOP) RETURN			#NOP?
	IF(RI.LE.MXJOKE) GO TO 100		#JOKE?
	GO TO (1000,2000,3000,4000,5000,6000,7000,8000,9000,10000,
		11000,12000,13000,14000,15000,16000,17000,18000,19000,20000,
		 21000,22000,23000,24000,25000,26000,27000,28000),
		(RI-MXJOKE)
	CALL BUG(7,RI)
#
# ALL VERB PROCESSORS RETURN HERE TO DECLARE FAILURE.
#
10	SVERBS=.FALSE.				#LOSE.
	RETURN
#
# JOKE PROCESSOR.
# FIND PROPER ENTRY IN JOKES, USE IT TO SELECT STRING TO PRINT.
#
100	I=JOKES(RI-MXNOP)			#GET TABLE ENTRY.
	J=I/1000				#ISOLATE # STRINGS.
	IF(J.NE.0) I=MOD(I,1000)+RND(J)		#IF RANDOM, CHOOSE.
	CALL RSPEAK(I)				#PRINT JOKE.
	RETURN

# SVERBS, PAGE 3
#
# V70--	BRIEF.  SET FLAG.
#
1000	BRIEFF=.TRUE.				#BRIEF DESCRIPTIONS.
	SUPERF=.FALSE.
	CALL RSPEAK(326)
	RETURN
#
# V71--	VERBOSE.  CLEAR FLAGS.
#
2000	BRIEFF=.FALSE.				#LONG DESCRIPTIONS.
	SUPERF=.FALSE.
	CALL RSPEAK(327)
	RETURN
#
# V72--	SUPERBRIEF.  SET FLAG.
#
3000	SUPERF=.TRUE.
	CALL RSPEAK(328)
	RETURN
#
# V73-- STAY (USED IN ENDGAME).
#
4000	IF(WINNER.NE.AMASTR) GO TO 4100		#TELL MASTER, STAY.
	CALL RSPEAK(781)			#HE DOES.
	CTICK(CEVFOL)=0				#NOT FOLLOWING.
	RETURN
#
4100	IF(WINNER.EQ.PLAYER) CALL RSPEAK(664)	#JOKE.
	RETURN
#
# V74--	VERSION.  PRINT INFO.
#
5000	WRITE(OUTCH,5010) VMAJ,VMIN,VEDIT
5010	FORMAT(' V',I1,'.',I2,A1)
	ccflg=.false.
	TELFLG=.TRUE.
	RETURN
#
# V75--	SWIM.  ALWAYS A JOKE.
#
6000	I=330					#ASSUME WATER.
	IF(AND(RFLAG(HERE),(RWATER+RFILL)).EQ.0)
		I=331+RND(3)			#IF NO WATER, JOKE.
	CALL RSPEAK(I)
	RETURN
#
# V76--	GERONIMO.  IF IN BARREL, FATAL, ELSE JOKE.
#
7000	IF(HERE.EQ.MBARR) GO TO 7100		#IN BARREL?
	CALL RSPEAK(334)			#NO, JOKE.
	RETURN
#
7100	CALL JIGSUP(335)			#OVER FALLS.
	RETURN
#
# V77--	SINBAD ET AL.  CHASE CYCLOPS, ELSE JOKE.
#
8000	IF((HERE.EQ.MCYCL).AND.QHERE(CYCLO,HERE)) GO TO 8100
	CALL RSPEAK(336)			#NOT HERE, JOKE.
	RETURN
#
8100	CALL NEWSTA(CYCLO,337,0,0,0)		#CYCLOPS FLEES.
	CYCLOF=.TRUE.				#SET ALL FLAGS.
	MAGICF=.TRUE.
	OFLAG2(CYCLO)=AND(OFLAG2(CYCLO),NOT(FITEBT))
	RETURN
#
# V78--	WELL.  OPEN DOOR, ELSE JOKE.
#
9000	IF(RIDDLF.OR.(HERE.NE.RIDDL)) GO TO 9100	#IN RIDDLE ROOM?
	RIDDLF=.TRUE.				#YES, SOLVED IT.
	CALL RSPEAK(338)
	RETURN
#
9100	CALL RSPEAK(339)			#WELL, WHAT?
	RETURN
#
# V79--	PRAY.  IF IN TEMP2, POOF!
#
10000	IF(HERE.NE.TEMP2) GO TO 10050		#IN TEMPLE?
	IF(MOVETO(FORE1,WINNER)) GO TO 10100	#FORE1 STILL THERE?
10050	CALL RSPEAK(340)			#JOKE.
	RETURN
#
10100	F=RMINFO(.TRUE.)			#MOVED, DESCRIBE.
	RETURN
#
# V80--	TREASURE.  IF IN TEMP1, POOF!
#
11000	IF(HERE.NE.TEMP1) GO TO 11050	#IN TEMPLE?
	IF(MOVETO(TREAS,WINNER)) GO TO 10100	#TREASURE ROOM THERE?
11050	CALL RSPEAK(341)			#NOTHING HAPPENS.
	RETURN
#
# V81--	TEMPLE.  IF IN TREAS, POOF!
#
12000	IF(HERE.NE.TREAS) GO TO 12050		#IN TREASURE?
	IF(MOVETO(TEMP1,WINNER)) GO TO 10100	#TEMP1 STILL THERE?
12050	CALL RSPEAK(341)			#NOTHING HAPPENS.
	RETURN
#
# V82--	BLAST.  USUALLY A JOKE.
#
13000	I=342					#DONT UNDERSTAND.
	IF(PRSO.EQ.SAFE) I=252			#JOKE FOR SAFE.
	CALL RSPEAK(I)
	RETURN
#
# V83--	SCORE.  PRINT SCORE.
#
14000	CALL SCORE(.FALSE.)
	RETURN
#
# V84--	QUIT.  FINISH OUT THE GAME.
#
15000	CALL SCORE(.TRUE.)			#TELLL SCORE.
	IF(.NOT.YESNO(343,0,0)) RETURN		#ASK FOR Y/N DECISION.
	CLOSE (UNIT=DBCH,DISPOSE='SAVE')	#CLEAN UP.
	CALL EXIT				#BYE.

# SVERBS, PAGE 4
#
# V85--	FOLLOW (USED IN ENDGAME)
#
16000	IF(WINNER.NE.AMASTR) RETURN		#TELL MASTER, FOLLOW.
	CALL RSPEAK(782)
	CTICK(CEVFOL)=-1			#STARTS FOLLOWING.
	RETURN
#
# V86--	WALK THROUGH
#
17000	IF((SCOLRM.EQ.0).OR.((PRSO.NE.SCOL).AND.
		((PRSO.NE.WNORT).OR.(HERE.NE.BKBOX)))) GO TO 17100
	SCOLAC=SCOLRM				#WALKED THRU SCOL.
	PRSO=0					#FAKE OUT FROMDR.
	CTICK(CEVSCL)=6				#START ALARM.
	CALL RSPEAK(668)			#DISORIENT HIM.
	F=MOVETO(SCOLRM,WINNER)			#INTO ROOM.
	F=RMINFO(.TRUE.)			#DESCRIBE.
	RETURN
#
17100	IF(HERE.NE.SCOLAC) GO TO 17300		#ON OTHER SIDE OF SCOL?
	DO I=1,12,3 {				#WALK THRU PROPER WALL?
	  IF((SCOLWL(I).EQ.HERE).AND.(SCOLWL(I+1).EQ.PRSO)) {
		GO TO 17500			#IN SPECIFIED ROOM?
		}
	  }
#
17300	IF(AND(OFLAG1(PRSO),TAKEBT).NE.0) GO TO 17400	#TKBLE?
	I=669					#NO, JOKE.
	IF(PRSO.EQ.SCOL) I=670			#SPECIAL JOKE FOR SCOL.
	CALL RSPSUB(I,ODO2)
	RETURN
#
17400	I=671					#JOKE.
	IF(OROOM(PRSO).NE.0) I=552+RND(5)	#SPECIAL JOKES IF CARRY.
	CALL RSPEAK(I)
	RETURN
#
17500	PRSO=SCOLWL(I+2)			#THRU SCOL WALL...
	DO I=1,8,2 {				#FIND MATCHING ROOM.
	  IF(PRSO.EQ.SCOLDR(I)) SCOLRM=SCOLDR(I+1)
	  }
	CTICK(CEVSCL)=0				#CANCEL ALARM.
	CALL RSPEAK(668)			#DISORIENT HIM.
	F=MOVETO(BKBOX,WINNER)			#BACK IN BOX ROOM.
	F=RMINFO(.TRUE.)
	RETURN
#
# V87--	RING.  A JOKE.
#
18000	I=359					#CANT RING.
	IF(PRSO.EQ.BELL) I=360			#DING, DONG.
	CALL RSPEAK(I)				#JOKE.
	RETURN
#
# V88--	BRUSH.  JOKE WITH OBSCURE TRAP.
#
19000	IF(PRSO.EQ.TEETH) GO TO 19100		#BRUSH TEETH?
	CALL RSPEAK(362)			#NO, JOKE.
	RETURN
#
19100	IF(PRSI.NE.0) GO TO 19200		#WITH SOMETHING?
	CALL RSPEAK(363)			#NO, JOKE.
	RETURN
#
19200	IF((PRSI.EQ.PUTTY).AND.(OADV(PUTTY).EQ.WINNER)) {
		GO TO 19300			#WITH PUTTY?
		}
	CALL RSPSUB(364,ODI2)			#NO, JOKE.
	RETURN
#
19300	CALL JIGSUP(365)			#YES, DEAD!!!!!
	RETURN

# SVERBS, PAGE 5
#
# V89--	DIG.  UNLESS SHOVEL, A JOKE.
#
20000	IF(PRSO.EQ.SHOVE) RETURN		#SHOVEL?
	I=392					#ASSUME TOOL.
	IF(AND(OFLAG1(PRSO),TOOLBT).EQ.0) I=393
	CALL RSPSUB(I,ODO2)
	RETURN
#
# V90--	TIME.  PRINT OUT DURATION OF GAME.
#
21000	CALL GTTIME(K)			#GET PLAY TIME.
	I=K/60
	J=MOD(K,60)
	WRITE(OUTCH,21010)
	IF(I.NE.0) WRITE(OUTCH,21011) I
	IF(I.GE.2) WRITE(OUTCH,21012)
	IF(I.EQ.1) WRITE(OUTCH,21013)
	IF(J.EQ.1) WRITE(OUTCH,21014) J
	IF(J.NE.1) WRITE(OUTCH,21015) J
	ccflg=.false.
	TELFLG=.TRUE.
	RETURN
#
21010	FORMAT(' You have been playing Dungeon for ')
21011	FORMAT('+',I3,' hour')
21012	FORMAT('+s and ')
21013	FORMAT('+ and ')
21014	FORMAT('+',I2,' minute.')
21015	FORMAT('+',I2,' minutes.')
#
# V91--	LEAP.  USUALLY A JOKE, WITH A CATCH.
#
22000	IF(PRSO.EQ.0) GO TO 22200		#OVER SOMETHING?
	IF(QHERE(PRSO,HERE)) GO TO 22100	#HERE?
	CALL RSPEAK(447)			#NO, JOKE.
	RETURN
#
22100	IF(AND(OFLAG2(PRSO),VILLBT).EQ.0) GO TO 22300
	CALL RSPSUB(448,ODO2)			#CANT JUMP VILLAIN.
	RETURN
#
22200	IF(.NOT.FINDXT(XDOWN,HERE)) GO TO 22300	#DOWN EXIT?
	IF((XTYPE.EQ.XNO).OR.((XTYPE.EQ.XCOND).AND.
		.NOT.FLAGS(XFLAG))) GO TO 22400	#BLOCKED OFF?
22300	CALL RSPEAK(314+RND(5))			#WHEEEE!
	RETURN
#
22400	CALL JIGSUP(449+RND(4))			#FATAL LEAP.
	RETURN

# SVERBS, PAGE 6
#
# V92--	LOCK.
#
23000	IF((PRSO.EQ.GRATE).AND.(HERE.EQ.MGRAT)) {
		GO TO 23200
		}
23100	CALL RSPEAK(464)			#NOT LOCK GRATE.
	RETURN
#
23200	GRUNLF=.FALSE.				#GRATE NOW LOCKED.
	CALL RSPEAK(214)
	TRAVEL(REXIT(HERE)+1)=214		#CHANGE EXIT STATUS.
	RETURN
#
# V93--	UNLOCK
#
24000	IF((PRSO.NE.GRATE).OR.(HERE.NE.MGRAT)) {
		GO TO 23100			#NOT UNLOCK GRATE.
		}
	IF(PRSI.EQ.KEYS) GO TO 24200		#GOT KEYS?
	CALL RSPSUB(465,ODI2)			#NO, JOKE.
	RETURN
#
24200	GRUNLF=.TRUE.				#UNLOCK GRATE.
	CALL RSPEAK(217)
	TRAVEL(REXIT(HERE)+1)=217		#CHANGE EXIT STATUS.
	RETURN
#
# V94--	DIAGNOSE.
#
25000	I=FIGHTS(WINNER,.FALSE.)		#GET FIGHTS STRENGTH.
	J=ASTREN(WINNER)			#GET HEALTH.
	K=MIN0(I+J,4)				#GET STATE.
	IF(.NOT.CFLAG(CEVCUR)) J=0		#IF NO WOUNDS.
	L=MIN0(4,IABS(J))			#SCALE.
	CALL RSPEAK(473+L)			#DESCRIBE HEALTH.
	I=(30*(-J-1))+CTICK(CEVCUR)		#COMPUTE WAIT.
	IF(J.NE.0) WRITE(OUTCH,25100) I
25100	FORMAT(' You will be cured after ',I3,' moves.')
	ccflg=.false.
	CALL RSPEAK(478+K)			#HOW MUCH MORE?
	IF(DEATHS.NE.0) CALL RSPEAK(482+DEATHS)	#HOW MANY DEATHS?
	RETURN

# SVERBS, PAGE 7
#
# V95--	INCANT
#
26000	DO I=1,6 {				#SET UP PARSE.
	  P1(I)=' '
	  P2(I)=' '
	  }
	WP=1					#WORD POINTER.
	CP=1					#CHAR POINTER.
	IF((PRSCON.LE.1).OR.(PRSCON.GT.INLNT)) GO TO 26300
	DO I=PRSCON,INLNT {			#PARSE INPUT
	  IF(INBUF(I).EQ.',') GO TO 26300	#END OF PHRASE?
	  IF(INBUF(I).NE.' ') GO TO 26150	#SPACE?
	  IF(CP.NE.1) WP=WP+1
	  CP=1
	  NEXT
26150	  IF(WP.EQ.1) P1(CP)=INBUF(I)		#STUFF INTO HOLDER.
	  IF(WP.EQ.2) P2(CP)=INBUF(I)
	  CP=MIN0(CP+1,6)
	  }
#
26300	PRSCON=1				#KILL REST OF LINE.
	IF(P1(1).NE.' ') GO TO 26400		#ANY INPUT?
	CALL RSPEAK(856)			#NO, HO HUM.
	RETURN
#
26400	CALL ENCRYP(P1,CH)			#COMPUTE RESPONSE.
	IF(P2(1).NE.' ') GO TO 26600	#TWO PHRASES?
#
	IF(SPELLF) GO TO 26550			#HE'S TRYING TO LEARN.
	IF(AND(RFLAG(MRANT),RSEEN).NE.0) GO TO 26575
	SPELLF=.TRUE.				#TELL HIM.
	TELFLG=.TRUE.
	WRITE(OUTCH,26510) P1,CH
%26510	FORMAT(' A hollow voice replies:  \"',6A1,1X,6A1,'\".')
	ccflg=.false.
	RETURN
#
26550	CALL RSPEAK(857)			#HE'S GOT ONE ALREADY.
	RETURN
#
26575	CALL RSPEAK(858)			#HE'S NOT IN ENDGAME.
	RETURN
#
26600	IF(AND(RFLAG(TSTRS),RSEEN).NE.0) GO TO 26800
	DO I=1,6 {
	  IF(P2(I).NE.CH(I)) GO TO 26575	#WRONG.
	  }
	SPELLF=.TRUE.				#IT WORKS.
	CALL RSPEAK(859)
	CTICK(CEVSTE)=1				#FORCE START.
	RETURN
#
26800	CALL RSPEAK(855)			#TOO LATE.
	RETURN

# SVERBS, PAGE 8
#
# V96--	ANSWER
#
27000	IF((PRSCON.GT.1).AND.(PRSCON.LE.INLNT).AND.
		(HERE.EQ.FDOOR).AND.INQSTF) {
		GO TO 27100
		}
	CALL RSPEAK(799)			#NO ONE LISTENS.
	PRSCON=1
	RETURN
#
27100	K=1					#POINTER INTO ANSSTR.
	DO J=1,28,2 {				#CHECK ANSWERS.
	  NEWK=K+ANSWER(J+1)			#COMPUTE NEXT K.
	  IF(QUESNO.NE.ANSWER(J)) GO TO 27300	#ONLY CHECK PROPER ANS.
	  I=PRSCON-1				#SCAN ANSWER.
	  DO L=K,NEWK-1 {
27150	    I=I+1				#SKIP INPUT BLANKS.
	    IF(I.GT.INLNT) GO TO 27300		#END OF INPUT? LOSE.
	    IF(INBUF(I).EQ.' ') GO TO 27150
	    IF(INBUF(I).NE.ANSSTR(L)) GO TO 27300
	    }
	  GO TO 27500				#RIGHT ANSWER.
27300	K=NEWK
	}
#
	PRSCON=1				#KILL REST OF LINE.
	NQATT=NQATT+1				#WRONG, CRETIN.
	IF(NQATT.GE.5) GO TO 27400		#TOO MANY WRONG?
	CALL RSPEAK(800+NQATT)			#NO, TRY AGAIN.
	RETURN
#
27400	CALL RSPEAK(826)			#ALL OVER.
	CFLAG(CEVINQ)=.FALSE.			#LOSE.
	RETURN
#
27500	PRSCON=1				#KILL REST OF LINE.
	CORRCT=CORRCT+1				#GOT IT RIGHT.
	CALL RSPEAK(800)			#HOORAY.
	IF(CORRCT.GE.3) GO TO 27600		#WON TOTALLY?
	CTICK(CEVINQ)=2				#NO, START AGAIN.
	QUESNO=MOD(QUESNO+3,8)
	NQATT=0
	CALL RSPEAK(769)			#ASK NEXT QUESTION.
	CALL RSPEAK(770+QUESNO)
	RETURN
#
27600	CALL RSPEAK(827)			#QUIZ OVER,
	CFLAG(CEVINQ)=.FALSE.
	OFLAG2(QDOOR)=OFLAG2(QDOOR).OR.OPENBT	#OPEN DOOR.
	RETURN
#
# v97 - rname : give the current room name
#
28000	call rspeak((rdesc2-here))
	return
		END
# TAKE-- BASIC TAKE SEQUENCE
#
# TAKE AN OBJECT (FOR VERBS TAKE, PUT, DROP, READ, ETC.)
#
	LOGICAL FUNCTION TAKE(FLG)
#
# DECLARATIONS
#
	IMPLICIT INTEGER (A-Z)
	LOGICAL FLG,OBJACT,OAPPLI,QOPEN,QHERE
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
	COMMON /STATE/ MOVES,DEATHS,RWSCOR,MXSCOR,MXLOAD,
		LTSHFT,BLOC,MUNGRM,HS,EGSCOR,EGMXSC
	COMMON /STAR/ MBASE,STRBIT
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
#
# ADVENTURERS
#
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
		AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
#
	COMMON /AINDEX/ PLAYER,AROBOT,AMASTR
#
# FUNCTIONS AND DATA
#
	QOPEN(O)=AND(OFLAG2(O),OPENBT).NE.0

# TAKE, PAGE 2
#
	TAKE=.FALSE.				#ASSUME LOSES.
	OA=OACTIO(PRSO)				#GET OBJECT ACTION.
	IF(PRSO.LE.STRBIT) GO TO 100	#STAR?
	TAKE=OBJACT(X)			#YES, LET IT HANDLE.
	RETURN
#
100	X=OCAN(PRSO)				#INSIDE?
	IF(PRSO.NE.AVEHIC(WINNER)) GO TO 400	#HIS VEHICLE?
	CALL RSPEAK(672)			#DUMMY.
	RETURN
#
400	IF(AND(OFLAG1(PRSO),TAKEBT).NE.0) GO TO 500	#TAKEABLE?
	IF(.NOT.OAPPLI(OA,0)) CALL RSPEAK(552+RND(5))
	RETURN
#
# OBJECT IS TAKEABLE AND IN POSITION TO BE TAKEN.
#
500	IF((X.NE.0).OR. QHERE(PRSO,HERE)) GO TO 600
	IF(OADV(PRSO).EQ.WINNER) CALL RSPEAK(557)	#ALREADY GOT IT?
	RETURN
#
600	MXLOAD=MXLOAD				#ADJUST MXLOAD (HOW???)
	IF(((X.NE.0).AND.(OADV(X).EQ.WINNER)).OR.
		((WEIGHT(0,PRSO,WINNER)+OSIZE(PRSO)).LE.MXLOAD)) {
		GO TO 700
		}
	CALL RSPEAK(558)			#TOO MUCH WEIGHT.
	RETURN
#
700	TAKE=.TRUE.				#AT LAST.
	IF(OAPPLI(OA,0)) RETURN			#DID IT HANDLE?
	CALL NEWSTA(PRSO,0,0,0,WINNER)		#TAKE OBJECT FOR WINNER.
	OFLAG2(PRSO)=OR(OFLAG2(PRSO),TCHBT)	#HAS BEEN TOUCHED.
	CALL SCRUPD(OFVAL(PRSO))		#UPDATE SCORE.
	OFVAL(PRSO)=0				#CANT BE SCORED AGAIN.
	IF(FLG) CALL RSPEAK(559)		#TELL TAKEN.
	RETURN
#
	END

# DROP- DROP VERB PROCESSOR
#
# DECLARATIONS
#
	LOGICAL FUNCTION DROP(Z)
	IMPLICIT INTEGER (A-Z)
	LOGICAL F,PUT,OBJACT
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
#
# ROOMS
#
	COMMON /RINDEX/ WHOUS,LROOM,CELLA
	COMMON /RINDEX/ MTROL,MAZE1	
	COMMON /RINDEX/ MGRAT,MAZ15	
	COMMON /RINDEX/ FORE1,FORE3,CLEAR,RESER
	COMMON /RINDEX/ STREA,EGYPT,ECHOR
	COMMON /RINDEX/ TSHAF	
	COMMON /RINDEX/ BSHAF,MMACH,DOME,MTORC
	COMMON /RINDEX/ CAROU	
	COMMON /RINDEX/ RIDDL,LLD2,TEMP1,TEMP2,MAINT
	COMMON /RINDEX/ BLROO,TREAS,RIVR1,RIVR2,RIVR3,MCYCL
	COMMON /RINDEX/ RIVR4,RIVR5,FCHMP,FALLS,MBARR
	COMMON /RINDEX/ MRAIN,POG,VLBOT,VAIR1,VAIR2,VAIR3,VAIR4
	COMMON /RINDEX/ LEDG2,LEDG3,LEDG4,MSAFE,CAGER
	COMMON /RINDEX/ CAGED,TWELL,BWELL,ALICE,ALISM,ALITR
	COMMON /RINDEX/ MTREE,BKENT,BKVW,BKTWI,BKVAU,BKBOX
	COMMON /RINDEX/ CRYPT,TSTRS,MRANT,MREYE
	COMMON /RINDEX/ MRA,MRB,MRC,MRG,MRD,FDOOR
	COMMON /RINDEX/ MRAE,MRCE,MRCW,MRGE,MRGW,MRDW,INMIR
	COMMON /RINDEX/ SCORR,NCORR,PARAP,CELL,PCELL,NCELL
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
#
# ADVENTURERS
#
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
		AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
#
# VERBS
#
	COMMON /VINDEX/ CINTW,DEADXW,FRSTQW,INXW,OUTXW
	COMMON /VINDEX/ WALKIW,FIGHTW,FOOW
	COMMON /VINDEX/ MELTW,READW,INFLAW,DEFLAW,ALARMW,EXORCW
	COMMON /VINDEX/ PLUGW,KICKW,WAVEW,RAISEW,LOWERW,RUBW
	COMMON /VINDEX/ PUSHW,UNTIEW,TIEW,TIEUPW,TURNW,BREATW
	COMMON /VINDEX/ KNOCKW,LOOKW,EXAMIW,SHAKEW,MOVEW,TRNONW,TRNOFW
	COMMON /VINDEX/ OPENW,CLOSEW,FINDW,WAITW,SPINW,BOARDW,UNBOAW,TAKEW
	COMMON /VINDEX/ INVENW,FILLW,EATW,DRINKW,BURNW
	COMMON /VINDEX/ MUNGW,KILLW,ATTACW,SWINGW
	COMMON /VINDEX/ WALKW,TELLW,PUTW,DROPW,GIVEW,POURW,THROWW
	COMMON /VINDEX/ DIGW,LEAPW,STAYW,FOLLOW
	COMMON /VINDEX/ HELLOW,LOOKIW,LOOKUW,PUMPW,WINDW
	COMMON /VINDEX/ CLMBW,CLMBUW,CLMBDW,TRNTOW

# DROP, PAGE 2
#
	DROP=.TRUE.				#ASSUME WINS.
	X=OCAN(PRSO)				#GET CONTAINER.
	IF(X.EQ.0) GO TO 200			#IS IT INSIDE?
	IF(OADV(X).NE.WINNER) GO TO 1000	#IS HE CARRYING CON?
	IF(AND(OFLAG2(X),OPENBT).NE.0) GO TO 300	#IS IT OPEN?
	CALL RSPSUB(525,ODESC2(X))		#CANT REACH.
	RETURN
#
200	IF(OADV(PRSO).NE.WINNER) GO TO 1000	#IS HE CARRYING OBJ?
300	IF(AVEHIC(WINNER).EQ.0) GO TO 400	#IS HE IN VEHICLE?
	PRSI=AVEHIC(WINNER)			#YES,
	F=PUT(.TRUE.)				#DROP INTO VEHICLE.
	RETURN					#DONE.
#
400	CALL NEWSTA(PRSO,0,HERE,0,0)		#DROP INTO ROOM.
	IF(HERE.EQ.MTREE) CALL NEWSTA(PRSO,0,FORE3,0,0)
500	IF(OBJACT(X)) RETURN			#DID IT HANDLE?
	I=0					#ASSUME NOTHING TO SAY.
	IF(PRSA.EQ.DROPW) I=528
	IF(PRSA.EQ.THROWW) I=529
	IF((I.NE.0).AND.(HERE.EQ.MTREE)) I=659
	CALL RSPSUB(I,ODESC2(PRSO))
	RETURN
#
1000	CALL RSPEAK(527)			#DONT HAVE IT.
	RETURN
#
	END

# PUT- PUT VERB PROCESSOR
#
# DECLARATIONS
#
	LOGICAL FUNCTION PUT(FLG)
	IMPLICIT INTEGER (A-Z)
	LOGICAL QOPEN,QHERE,OBJACT,FLG
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
#
# MISCELLANEOUS VARIABLES
#
	COMMON /STAR/ MBASE,STRBIT
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
# ADVENTURERS
#
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
		AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
#
# VERBS
#
	COMMON /VINDEX/ CINTW,DEADXW,FRSTQW,INXW,OUTXW
	COMMON /VINDEX/ WALKIW,FIGHTW,FOOW
	COMMON /VINDEX/ MELTW,READW,INFLAW,DEFLAW,ALARMW,EXORCW
	COMMON /VINDEX/ PLUGW,KICKW,WAVEW,RAISEW,LOWERW,RUBW
	COMMON /VINDEX/ PUSHW,UNTIEW,TIEW,TIEUPW,TURNW,BREATW
	COMMON /VINDEX/ KNOCKW,LOOKW,EXAMIW,SHAKEW,MOVEW,TRNONW,TRNOFW
	COMMON /VINDEX/ OPENW,CLOSEW,FINDW,WAITW,SPINW,BOARDW,UNBOAW,TAKEW
	COMMON /VINDEX/ INVENW,FILLW,EATW,DRINKW,BURNW
	COMMON /VINDEX/ MUNGW,KILLW,ATTACW,SWINGW
	COMMON /VINDEX/ WALKW,TELLW,PUTW,DROPW,GIVEW,POURW,THROWW
	COMMON /VINDEX/ DIGW,LEAPW,STAYW,FOLLOW
	COMMON /VINDEX/ HELLOW,LOOKIW,LOOKUW,PUMPW,WINDW
	COMMON /VINDEX/ CLMBW,CLMBUW,CLMBDW,TRNTOW
#
# FUNCTIONS AND DATA
#
	QOPEN(R)=AND(OFLAG2(R),OPENBT).NE.0

# PUT, PAGE 2
#
	PUT=.FALSE.
	IF((PRSO.LE.STRBIT).AND.(PRSI.LE.STRBIT)) GO TO 200
	IF(.NOT.OBJACT(X)) CALL RSPEAK(560)		#STAR
	PUT=.TRUE.
	RETURN
#
200	IF(QOPEN(PRSI).OR.(AND(OFLAG1(PRSI),(DOORBT+CONTBT)).NE.0)
		.OR.(AND(OFLAG2(PRSI),VEHBT).NE.0)) GO TO 300
	CALL RSPEAK(561)			#CANT PUT IN THAT.
	RETURN
#
300	IF(QOPEN(PRSI)) GO TO 400		#IS IT OPEN?
	CALL RSPEAK(562)			#NO, JOKE
	RETURN
#
400	IF(PRSO.NE.PRSI) GO TO 500		#INTO ITSELF?
	CALL RSPEAK(563)			#YES, JOKE.
	RETURN
#
500	IF(OCAN(PRSO).NE.PRSI) GO TO 600	#ALREADY INSIDE.
	CALL RSPSB2(564,ODESC2(PRSO),ODESC2(PRSI))
	PUT=.TRUE.
	RETURN
#
600	IF((WEIGHT(0,PRSO,0)+WEIGHT(0,PRSI,0)+OSIZE(PRSO))
		.LE.OCAPAC(PRSI)) GO TO 700	#NOT TOO FULL?
	CALL RSPEAK(565)			#THEN CANT DO IT.
	RETURN
#
# NOW SEE IF OBJECT (OR ITS CONTAINER) IS IN ROOM
#
700	J=PRSO					#START SEARCH.
725	IF(QHERE(J,HERE)) GO TO 750		#IS IT HERE?
	J=OCAN(J)
	IF(J.NE.0) GO TO 725			#MORE TO DO?
	GO TO 800				#NO, SCH FAILS.
#
750	SVO=PRSO				#SAVE PARSER.
	SVI=PRSI
	PRSA=TAKEW
	PRSI=0
	IF(.NOT.TAKE(.FALSE.)) RETURN		#TAKE OBJECT.
	PRSA=PUTW
	PRSO=SVO
	PRSI=SVI
	GO TO 1000
#
# NOW SEE IF OBJECT IS ON PERSON.
#
800	IF(OCAN(PRSO).EQ.0) GO TO 1000		#INSIDE?
	IF(QOPEN(OCAN(PRSO))) GO TO 900		#OPEN?
	CALL RSPSUB(566,ODESC2(PRSO))		#LOSE.
	RETURN
#
900	CALL SCRUPD(OFVAL(PRSO))		#SCORE OBJECT.
	OFVAL(PRSO)=0
	CALL NEWSTA(PRSO,0,0,0,WINNER)		#TEMPORARILY ON WINNER.
#
1000	IF(OBJACT(X)) RETURN			#NO, GIVE OBJECT A SHOT.
	CALL NEWSTA(PRSO,2,0,PRSI,0)		#CONTAINED INSIDE.
	PUT=.TRUE.
	RETURN
#
	END

# VALUAC- HANDLES VALUABLES/EVERYTHING
#
# DECLARATIONS
#
	SUBROUTINE VALUAC(V)
	IMPLICIT INTEGER (A-Z)
	common /chan/inpch,outch
	common /spare/ccflg
	LOGICAL LIT,F,F1,TAKE,PUT,DROP,NOTVAL,QHERE
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
# VERBS
#
	COMMON /VINDEX/ CINTW,DEADXW,FRSTQW,INXW,OUTXW
	COMMON /VINDEX/ WALKIW,FIGHTW,FOOW
	COMMON /VINDEX/ MELTW,READW,INFLAW,DEFLAW,ALARMW,EXORCW
	COMMON /VINDEX/ PLUGW,KICKW,WAVEW,RAISEW,LOWERW,RUBW
	COMMON /VINDEX/ PUSHW,UNTIEW,TIEW,TIEUPW,TURNW,BREATW
	COMMON /VINDEX/ KNOCKW,LOOKW,EXAMIW,SHAKEW,MOVEW,TRNONW,TRNOFW
	COMMON /VINDEX/ OPENW,CLOSEW,FINDW,WAITW,SPINW,BOARDW,UNBOAW,TAKEW
	COMMON /VINDEX/ INVENW,FILLW,EATW,DRINKW,BURNW
	COMMON /VINDEX/ MUNGW,KILLW,ATTACW,SWINGW
	COMMON /VINDEX/ WALKW,TELLW,PUTW,DROPW,GIVEW,POURW,THROWW
	COMMON /VINDEX/ DIGW,LEAPW,STAYW,FOLLOW
	COMMON /VINDEX/ HELLOW,LOOKIW,LOOKUW,PUMPW,WINDW
	COMMON /VINDEX/ CLMBW,CLMBUW,CLMBDW,TRNTOW
#
# FUNCTIONS AND DATA
#
	NOTVAL(R)=(SAVEP.EQ.V).AND.(OTVAL(R).LE.0)

# VALUAC, PAGE 2
#
	F=.TRUE.				#ASSUME NO ACTIONS.
	I=579					#ASSUME NOT LIT.
	IF(.NOT.LIT(HERE)) GO TO 4000		#IF NOT LIT, PUNT.
	I=677					#ASSUME WRONG VERB.
	SAVEP=PRSO				#SAVE PRSO.
	SAVEH=HERE				#SAVE HERE.
#
100	IF(PRSA.NE.TAKEW) GO TO 1000		#TAKE EVERY/VALUA?
	DO PRSO=1,OLNT {			#LOOP THRU OBJECTS.
	  IF(.NOT.QHERE(PRSO,HERE).OR.
		(AND(OFLAG1(PRSO),VISIBT).EQ.0).OR.
		(AND(OFLAG2(PRSO),ACTRBT).NE.0).OR.
			NOTVAL(PRSO)) NEXT
	  IF((AND(OFLAG1(PRSO),TAKEBT).EQ.0).AND.
		(AND(OFLAG2(PRSO),TRYBT).EQ.0)) NEXT
	  F=.FALSE.
	  CALL RSPSUB(580,ODESC2(PRSO))
	  write(outch,400)
	  ccflg=.true.
	  F1=TAKE(.TRUE.)
	  IF(SAVEH.NE.HERE) RETURN
400	format('   ')
	}
	GO TO 3000
#
1000	IF(PRSA.NE.DROPW) GO TO 2000		#DROP EVERY/VALUA?
	DO PRSO=1,OLNT {
	  IF((OADV(PRSO).NE.WINNER).OR.NOTVAL(PRSO)) {
		NEXT
		}
	  F=.FALSE.
	  CALL RSPSUB(580,ODESC2(PRSO))
	  write(outch,400)
	  ccflg=.true.
	  F1=DROP(.TRUE.)
	  IF(SAVEH.NE.HERE) RETURN
	  }
	GO TO 3000
#
2000	IF(PRSA.NE.PUTW) GO TO 3000		#PUT EVERY/VALUA?
	DO PRSO=1,OLNT {			#LOOP THRU OBJECTS.
	  IF((OADV(PRSO).NE.WINNER)
		.OR.(PRSO.EQ.PRSI).OR.NOTVAL(PRSO).OR.
		(AND(OFLAG1(PRSO),VISIBT).EQ.0)) NEXT
	  F=.FALSE.
	  CALL RSPSUB(580,ODESC2(PRSO))
	  write(outch,400)
 	  ccflg=.true.
	  F1=PUT(.TRUE.)
	  IF(SAVEH.NE.HERE) RETURN
	  }
#
3000	I=581
	IF(SAVEP.EQ.V) I=582			#CHOOSE MESSAGE.
4000	IF(F) CALL RSPEAK(I)			#IF NOTHING, REPORT.
	RETURN
	END

# SAVE- SAVE GAME STATE
#
# DECLARATIONS
#
	SUBROUTINE SAVEGM
	IMPLICIT INTEGER (A-Z)
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
	COMMON /STATE/ MOVES,DEATHS,RWSCOR,MXSCOR,MXLOAD,
		LTSHFT,BLOC,MUNGRM,HS,EGSCOR,EGMXSC
#
# SCREEN OF LIGHT
#
	COMMON /SCREEN/ FROMDR,SCOLRM,SCOLAC
#
# MISCELLANEOUS VARIABLES
#
	COMMON /VERS/ VMAJ,VMIN,VEDIT
	COMMON /TIME/ PLTIME,SHOUR,SMIN,SSEC
#
# ROOMS
#
	COMMON /ROOMS/ RLNT,RDESC2,RDESC1(215),REXIT(215),
		RACTIO(215),RVAL(215),RFLAG(215)
	INTEGER RRAND(215)
	EQUIVALENCE (RVAL,RRAND)
#
# EXITS
#
	COMMON /EXITS/ XLNT,travel(870)
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
#
# CLOCK INTERRUPTS
#
	LOGICAL CFLAG
	COMMON /CEVENT/ CLNT,CTICK(25),CACTIO(25),CFLAG(25)
#
#
# VILLAINS AND DEMONS
#
	LOGICAL THFFLG,SWDACT,THFACT
	COMMON /HACK/ THFPOS,THFFLG,THFACT,SWDACT,SWDSTA
	COMMON /VILL/ VLNT,VILLNS(4),VPROB(4),VOPPS(4),VBEST(4),VMELEE(4)
#
# ADVENTURERS
#
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
		AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
#
# FLAGS
#
	LOGICAL FLAGS(50)
	INTEGER SWITCH(27)
	COMMON /FINDEX/ FLAGS,SWITCH
#
	PRSWON=.FALSE.				#DISABLE GAME.
	OPEN (UNIT=1,FILE='DSAVE.DAT',
		ACCESS='SEQOUT',MODE='IMAGE',ERR=100)
#
	CALL GTTIME(I)				#GET TIME.
	WRITE(1) VMAJ,VMIN,VEDIT
	WRITE(1) WINNER,HERE,THFPOS,TELFLG,THFFLG,THFACT,
		SWDACT,SWDSTA
	WRITE(1) I,MOVES,DEATHS,RWSCOR,EGSCOR,MXLOAD,
		LTSHFT,BLOC,MUNGRM,HS,FROMDR,SCOLRM,SCOLAC
	WRITE(1) ODESC1,ODESC2,OFLAG1,OFLAG2,OFVAL,OTVAL,
		OSIZE,OCAPAC,OROOM,OADV,OCAN
	WRITE(1) RVAL,RFLAG
	WRITE(1) AROOM,ASCORE,AVEHIC,ASTREN,AFLAG
	WRITE(1) FLAGS,SWITCH,VPROB,CFLAG,CTICK
#
	CLOSE(UNIT=1,DISPOSE='SAVE')
	CALL RSPEAK(597)
	RETURN
#
100	CALL RSPEAK(598)			#CANT DO IT.
	RETURN
	END

# RESTORE- RESTORE GAME STATE
#
# DECLARATIONS
#
	SUBROUTINE RSTRGM
	IMPLICIT INTEGER (A-Z)
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
	COMMON /STATE/ MOVES,DEATHS,RWSCOR,MXSCOR,MXLOAD,
		LTSHFT,BLOC,MUNGRM,HS,EGSCOR,EGMXSC
#
# SCREEN OF LIGHT
#
	COMMON /SCREEN/ FROMDR,SCOLRM,SCOLAC
#
# MISCELLANEOUS VARIABLES
#
	COMMON /VERS/ VMAJ,VMIN,VEDIT
	COMMON /TIME/ PLTIME,SHOUR,SMIN,SSEC
#
# ROOMS
#
	COMMON /ROOMS/ RLNT,RDESC2,RDESC1(215),REXIT(215),
		RACTIO(215),RVAL(215),RFLAG(215)
	INTEGER RRAND(215)
	EQUIVALENCE (RVAL,RRAND)
#
# EXITS
#
	COMMON /EXITS/ XLNT,TRAVEL(870)
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
#
# CLOCK INTERRUPTS
#
	LOGICAL CFLAG
	COMMON /CEVENT/ CLNT,CTICK(25),CACTIO(25),CFLAG(25)
#
#
# VILLAINS AND DEMONS
#
	LOGICAL THFFLG,SWDACT,THFACT
	COMMON /HACK/ THFPOS,THFFLG,THFACT,SWDACT,SWDSTA
	COMMON /VILL/ VLNT,VILLNS(4),VPROB(4),VOPPS(4),VBEST(4),VMELEE(4)
#
# ADVENTURERS
#
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
		AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
#
# FLAGS
#
	LOGICAL flags(50)
	INTEGER switch(27)
	COMMON /FINDEX/ FLAGS,SWITCH
#
	PRSWON=.FALSE.			#DISABLE GAME.
	OPEN (UNIT=1,FILE='DSAVE.DAT',
		ACCESS='SEQIN',MODE='IMAGE',ERR=100)
#
	READ(1) I,J,K
	IF((I.NE.VMAJ).OR.(J.NE.VMIN)) GO TO 200
#
	READ(1) WINNER,HERE,THFPOS,TELFLG,THFFLG,THFACT,
		SWDACT,SWDSTA
	READ(1) PLTIME,MOVES,DEATHS,RWSCOR,EGSCOR,MXLOAD,
		LTSHFT,BLOC,MUNGRM,HS,FROMDR,SCOLRM,SCOLAC
	READ(1) ODESC1,ODESC2,OFLAG1,OFLAG2,OFVAL,OTVAL,
		OSIZE,OCAPAC,OROOM,OADV,OCAN
	READ(1) RVAL,RFLAG
	READ(1) AROOM,ASCORE,AVEHIC,ASTREN,AFLAG
	READ(1) FLAGS,SWITCH,VPROB,CFLAG,CTICK
#
	CLOSE(UNIT=1,DISPOSE='SAVE')
	CALL RSPEAK(599)
	RETURN
#
100	CALL RSPEAK(598)			#CANT DO IT.
	RETURN
#
200	CALL RSPEAK(600)			#OBSOLETE VERSION
	CLOSE (UNIT=1,DISPOSE='SAVE')
	RETURN
	END

# WALK- MOVE IN SPECIFIED DIRECTION
#
# DECLARATIONS
#
	LOGICAL FUNCTION WALK(X)
	IMPLICIT INTEGER(A-Z)
	LOGICAL FINDXT,QOPEN,LIT,PROB,MOVETO,RMINFO
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
#
# ROOMS
#
	COMMON /ROOMS/ RLNT,RDESC2,RDESC1(215),REXIT(215),
		RACTIO(215),RVAL(215),RFLAG(215)
	INTEGER RRAND(215)
	EQUIVALENCE (RVAL,RRAND)
#
	COMMON /RFLAG/ RSEEN,RLIGHT,RLAND,RWATER,RAIR,
		RSACRD,RFILL,RMUNG,RBUCK,RHOUSE,RNWALL,REND
#
# EXITS
#
	COMMON /CURXT/ XTYPE,XROOM1,XSTRNG,XACTIO,XOBJ
	EQUIVALENCE (XFLAG,XOBJ)
#
	COMMON /XSRCH/ XMIN,XMAX,XDOWN,XUP,
		XNORTH,XSOUTH,XENTER,XEXIT
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
	LOGICAL CFLAG
	COMMON /CEVENT/ CLNT,CTICK(25),CACTIO(25),CFLAG(25)
#
	COMMON /CINDEX/ CEVCUR,CEVMNT,CEVLNT,CEVMAT,CEVCND,
		CEVBAL,CEVBRN,CEVFUS,CEVLED,CEVSAF,CEVVLG,
		CEVGNO,CEVBUC,CEVSPH,CEVEGH,
			CEVFOR,CEVSCL,CEVZGI,CEVZGO,CEVSTE,
		CEVMRS,CEVPIN,CEVINQ,CEVFOL

#
# VILLAINS AND DEMONS
#
	LOGICAL THFFLG,SWDACT,THFACT
	COMMON /HACK/ THFPOS,THFFLG,THFACT,SWDACT
	COMMON /VILL/ VLNT,VILLNS(4),VPROB(4),VOPPS(4),VBEST(4),VMELEE(4)
#
# ADVENTURERS
#
	COMMON /AINDEX/ PLAYER,AROBOT,AMASTR
#
# FLAGS
#
	LOGICAL flags(50)
	EQUIVALENCE (FLAGS(1),TROLLF)
	LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL FOLLWF,SPELLF,sprf
	COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
		DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
		MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
			EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
		GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
		GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
		MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
		follwf,spellf,sprf(6)
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL
#
# FUNCTIONS AND DATA
#
	QOPEN(O)=AND(OFLAG2(O),OPENBT).NE.0

# WALK, PAGE 2
#
	WALK=.TRUE.				#ASSUME WINS.
	IF((WINNER.NE.PLAYER).OR.LIT(HERE).OR.PROB(25,25)) {
		GO TO 500
		}
	IF(.NOT.FINDXT(PRSO,HERE)) GO TO 450	#INVALID EXIT? GRUE!
	GO TO (400,200,100,300),XTYPE		#DECODE EXIT TYPE.
	CALL BUG(9,XTYPE)
#
100	IF(CXAPPL(XACTIO).NE.0) GO TO 400	#CEXIT... RETURNED ROOM?
	IF(FLAGS(XFLAG)) GO TO 400		#NO, FLAG ON?
200	CALL JIGSUP(523)			#BAD EXIT, GRUE!
	RETURN
#
300	IF(CXAPPL(XACTIO).NE.0) GO TO 400	#DOOR... RETURNED ROOM?
	IF(QOPEN(XOBJ)) GO TO 400		#NO, DOOR OPEN?
	CALL JIGSUP(523)			#BAD EXIT, GRUE!
	RETURN
#
400	IF(LIT(XROOM1)) GO TO 900		#VALID ROOM, IS IT LIT?
450	CALL JIGSUP(522)			#NO, GRUE!
	RETURN
#
# ROOM IS LIT, OR WINNER IS NOT PLAYER (NO GRUE).
#
500	IF(FINDXT(PRSO,HERE)) GO TO 550		#EXIT EXIST?
525	XSTRNG=524				#ASSUME WALL.
	IF(PRSO.EQ.XUP) XSTRNG=679		#IF UP, CANT.
	IF(PRSO.EQ.XDOWN) XSTRNG=680		#IF DOWN, CANT.
	IF((RFLAG(HERE).AND.RNWALL).EQ.0) XSTRNG=678
	CALL RSPEAK(XSTRNG)
	RETURN
#
550	GO TO (900,600,700,800),XTYPE	#BRANCH ON EXIT TYPE.
	CALL BUG(9,XTYPE)
#
600	CALL RSPEAK(XSTRNG)			#NO EXIT... TELL WHY.
	RETURN
#
700	IF(CXAPPL(XACTIO).NE.0) GO TO 900	#CEXIT... RETURNED ROOM?
	IF(FLAGS(XFLAG)) GO TO 900		#NO, FLAG ON?
	IF(XSTRNG.EQ.0) GO TO 525		#IF NO REASON, USE STD.
	CALL RSPEAK(XSTRNG)			#DENY EXIT.
	RETURN
#
800	IF(CXAPPL(XACTIO).NE.0) GO TO 900	#DOOR... RETURNED ROOM?
	IF(QOPEN(XOBJ)) GO TO 900		#NO, DOOR OPEN?
	IF(XSTRNG.EQ.0) XSTRNG=525		#IF NO REASON, USE STD.
	CALL RSPSUB(XSTRNG,ODESC2(XOBJ))
	RETURN
#
900	WALK=MOVETO(XROOM1,WINNER)		#MOVE TO ROOM.
	IF(WALK) WALK=RMINFO(.FALSE.)		#DESCRIBE ROOM.
	RETURN
	END

# CXAPPL- CONDITIONAL EXIT PROCESSORS
#
# DECLARATIONS
#
	INTEGER FUNCTION CXAPPL(RI)
	IMPLICIT INTEGER (A-Z)
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
# ROOMS
#
	COMMON /ROOMS/ RLNT,RDESC2,RDESC1(215),REXIT(215),
		RACTIO(215),RVAL(215),RFLAG(215)
	INTEGER RRAND(215)
	EQUIVALENCE (RVAL,RRAND)
#
	COMMON /RINDEX/ WHOUS,LROOM,CELLA
	COMMON /RINDEX/ MTROL,MAZE1	
	COMMON /RINDEX/ MGRAT,MAZ15	
	COMMON /RINDEX/ FORE1,FORE3,CLEAR,RESER
	COMMON /RINDEX/ STREA,EGYPT,ECHOR
	COMMON /RINDEX/ TSHAF	
	COMMON /RINDEX/ BSHAF,MMACH,DOME,MTORC
	COMMON /RINDEX/ CAROU	
	COMMON /RINDEX/ RIDDL,LLD2,TEMP1,TEMP2,MAINT
	COMMON /RINDEX/ BLROO,TREAS,RIVR1,RIVR2,RIVR3,MCYCL
	COMMON /RINDEX/ RIVR4,RIVR5,FCHMP,FALLS,MBARR
	COMMON /RINDEX/ MRAIN,POG,VLBOT,VAIR1,VAIR2,VAIR3,VAIR4
	COMMON /RINDEX/ LEDG2,LEDG3,LEDG4,MSAFE,CAGER
	COMMON /RINDEX/ CAGED,TWELL,BWELL,ALICE,ALISM,ALITR
	COMMON /RINDEX/ MTREE,BKENT,BKVW,BKTWI,BKVAU,BKBOX
	COMMON /RINDEX/ CRYPT,TSTRS,MRANT,MREYE
	COMMON /RINDEX/ MRA,MRB,MRC,MRG,MRD,FDOOR
	COMMON /RINDEX/ MRAE,MRCE,MRCW,MRGE,MRGW,MRDW,INMIR
	COMMON /RINDEX/ SCORR,NCORR,PARAP,CELL,PCELL,NCELL
#
# EXITS
#
	COMMON /EXITS/ XLNT,travel(870)
#
	COMMON /CURXT/ XTYPE,XROOM1,XSTRNG,XACTIO,XOBJ
	EQUIVALENCE (XFLAG,XOBJ)
#
	COMMON /XPARS/ XRMASK,XDMASK,XFMASK,XFSHFT,XASHFT,
		XELNT(4),XNORM,XNO,XCOND,XDOOR,XLFLAG
#
	COMMON /XSRCH/ XMIN,XMAX,XDOWN,XUP,
		XNORTH,XSOUTH,XENTER,XEXIT
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
	COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
	COMMON /OINDEX/ WATER,ROPE,KNIFE,SWORD,LAMP,BLAMP,RUG
	COMMON /OINDEX/	LEAVE,TROLL,AXE
	COMMON /OINDEX/ RKNIF,KEYS,ICE,BAR
	COMMON /OINDEX/ COFFI,TORCH,TBASK,FBASK,IRBOX
	COMMON /OINDEX/ GHOST,TRUNK,BELL,BOOK,CANDL
	COMMON /OINDEX/ MATCH,TUBE,PUTTY,WRENC,SCREW,CYCLO,CHALI
	COMMON /OINDEX/ THIEF,STILL,WINDO,GRATE,DOOR
	COMMON /OINDEX/ HPOLE,LEAK,RBUTT,RAILI
	COMMON /OINDEX/ POT,STATU,IBOAT,DBOAT,PUMP,RBOAT
	COMMON /OINDEX/ STICK,BUOY,SHOVE,BALLO,RECEP,GUANO
	COMMON /OINDEX/ BROPE,HOOK1,HOOK2,SAFE,SSLOT,BRICK,FUSE
	COMMON /OINDEX/ GNOME,BLABE,DBALL,TOMB
	COMMON /OINDEX/ LCASE,CAGE,RCAGE,SPHER,SQBUT
	COMMON /OINDEX/ FLASK,POOL,SAFFR,BUCKE,ECAKE,ORICE,RDICE,BLICE
	COMMON /OINDEX/ ROBOT,FTREE,BILLS,PORTR,SCOL,ZGNOM
	COMMON /OINDEX/ EGG,BEGG,BAUBL,CANAR,BCANA
	COMMON /OINDEX/ YLWAL,RDWAL,PINDR,RBEAM
	COMMON /OINDEX/ ODOOR,QDOOR,CDOOR,NUM1,NUM8
	COMMON /OINDEX/ HANDS,WALL,LUNGS,SAILO,AVIAT,TEETH
	COMMON /OINDEX/ ITOBJ,EVERY,VALUA,OPLAY,WNORT,GWATE,MASTER
#
	COMMON /AINDEX/ PLAYER,AROBOT,AMASTR
#
# FLAGS
#
	LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL FOLLWF,SPELLF,sprf
	COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
		DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
		MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
			EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
		GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
		GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
		MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
		follwf,spellf,sprf(6)
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL

# CXAPPL, PAGE 2
#
	CXAPPL=0				#NO RETURN.
	IF(RI.EQ.0) RETURN			#IF NO ACTION, DONE.
	GO TO (1000,2000,3000,4000,5000,6000,7000,
		8000,9000,10000,11000),RI	#BRANCH ON APP.
	CALL BUG(5,RI)
#
# C1- COFFIN-CURE
#
1000	EGYPTF=OADV(COFFI).NE.WINNER		#T IF NO COFFIN.
	RETURN
#
# C2- CAROUSEL EXIT
# C5- CAROUSEL OUT
#
2000	IF(CAROFF) RETURN			#IF FLIPPED, NOTHING.
2500	CALL RSPEAK(121)			#SPIN THE COMPASS.
5000	I=XELNT(XCOND)*RND(8)			#CHOOSE RANDOM EXIT.
	XROOM1=AND((TRAVEL(REXIT(HERE)+I)),XRMASK)
	CXAPPL=XROOM1				#RETURN EXIT.
	RETURN
#
# C3- CHIMNEY FUNCTION
#
3000	LITLDF=.FALSE.			#ASSUME HEAVY LOAD.
	J=0
	DO I=1,OLNT {			#COUNT OBJECTS.
	  IF(OADV(I).EQ.WINNER) J=J+1
	  }
#
	IF(J.GT.2) RETURN			#CARRYING TOO MUCH?
	XSTRNG=446				#ASSUME NO LAMP.
	IF(OADV(LAMP).NE.WINNER) RETURN		#NO LAMP?
	LITLDF=.TRUE.				#HE CAN DO IT.
	IF(AND(OFLAG2(DOOR),OPENBT).EQ.0)
		OFLAG2(DOOR)=AND(OFLAG2(DOOR),NOT(TCHBT))
	RETURN
#
# C4-	FROBOZZ FLAG (MAGNET ROOM, FAKE EXIT)
# C6-	FROBOZZ FLAG (MAGNET ROOM, REAL EXIT)
#
4000	IF(CAROFF) GO TO 2500			#IF FLIPPED, GO SPIN.
	FROBZF=.FALSE.				#OTHERWISE, NOT AN EXIT.
	RETURN
#
6000	IF(CAROFF) GO TO 2500			#IF FLIPPED, GO SPIN.
	FROBZF=.TRUE.				#OTHERWISE, AN EXIT.
	RETURN
#
# C7-	FROBOZZ FLAG (BANK ALARM)
#
7000	FROBZF=(OROOM(BILLS).NE.0).AND.(OROOM(PORTR).NE.0)
	RETURN

# CXAPPL, PAGE 3
#
# C8-	FROBOZZ FLAG (MRGO)
#
8000	FROBZF=.FALSE.				#ASSUME CANT MOVE.
	IF(MLOC.NE.XROOM1) GO TO 8100		#MIRROR IN WAY?
	IF((PRSO.EQ.XNORTH).OR.(PRSO.EQ.XSOUTH)) GO TO 8200
	IF(MOD(MDIR,180).NE.0) GO TO 8300	#MIRROR MUST BE N-S.
	XROOM1=((XROOM1-MRA)*2)+MRAE		#CALC EAST ROOM.
	IF(PRSO.GT.XSOUTH) XROOM1=XROOM1+1	#IF SW/NW, CALC WEST.
8100	CXAPPL=XROOM1
	RETURN
#
8200	XSTRNG=814				#ASSUME STRUC BLOCKS.
	IF(MOD(MDIR,180).EQ.0) RETURN		#IF MIRROR N-S, DONE.
8300	LDIR=MDIR				#SEE WHICH MIRROR.
	IF(PRSO.EQ.XSOUTH) LDIR=180
	XSTRNG=815				#MIRROR BLOCKS.
	IF(((LDIR.GT.180).AND..NOT.MR1F).OR.
		((LDIR.LT.180).AND..NOT.MR2F)) XSTRNG=816	#MIRROR BROKEN.
	RETURN
#
# C9-	FROBOZZ FLAG (MIRIN)
#
9000	IF(MRHERE(HERE).NE.1) GO TO 9100	#MIRROR 1 HERE?
	IF(MR1F) XSTRNG=805			#SEE IF BROKEN.
	FROBZF=MROPNF				#ENTER IF OPEN.
	RETURN
#
9100	FROBZF=.FALSE.				#NOT HERE,
	XSTRNG=817				#LOSE.
	RETURN

# CXAPPL, PAGE 4
#
# C10-	FROBOZZ FLAG (MIRROR EXIT)
#
10000	FROBZF=.FALSE.				#ASSUME CANT.
	LDIR=((PRSO-XNORTH)/XNORTH)*45		#XLATE DIR TO DEGREES.
	IF(.NOT.MROPNF .OR.
		((MOD(MDIR+270,360).NE.LDIR).AND.(PRSO.NE.XEXIT)))
		GO TO 10200			#EXIT VIA MIRROR?
	XROOM1=((MLOC-MRA)*2)+MRAE+1-(MDIR/180)	#ASSUME E-W EXIT.
	IF(MOD(MDIR,180).EQ.0) GO TO 10100	#IF N-S, OK.
	XROOM1=MLOC+1				#ASSUME N EXIT.
	IF(MDIR.GT.180) XROOM1=MLOC-1		#IF SOUTH.
10100	CXAPPL=XROOM1
	RETURN
#
10200	IF(.NOT.WDOPNF .OR.
		((MOD(MDIR+180,360).NE.LDIR).AND.(PRSO.NE.XEXIT)))
		RETURN				#EXIT VIA OPEN DOOR?
	XROOM1=MLOC+1				#ASSUME N.
	IF(MDIR.EQ.0) XROOM1=MLOC-1		#IF S.
	CALL RSPEAK(818)			#CLOSE DOOR.
	WDOPNF=.FALSE.
	CXAPPL=XROOM1
	RETURN
#
# C11-	MAYBE DOOR.  NORMAL MESSAGE IS THAT DOOR IS CLOSED.
#	BUT IF LCELL.NE.4, DOOR ISNT THERE.
#
11000	IF(LCELL.NE.4) XSTRNG=678		#SET UP MSG.
	RETURN
#
	END

# AAPPLI- APPLICABLES FOR ADVENTURERS
#
# DECLARATIONS
#
	LOGICAL FUNCTION AAPPLI(RI)
	IMPLICIT INTEGER (A-Z)
	LOGICAL F,MOVETO
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
#
# ROOMS
#
	COMMON /ROOMS/ RLNT,RDESC2,RDESC1(215),REXIT(215),
		RACTIO(215),RVAL(215),RFLAG(215)
	INTEGER RRAND(215)
	EQUIVALENCE (RVAL,RRAND)
#
	COMMON /RFLAG/ RSEEN,RLIGHT,RLAND,RWATER,RAIR,
		RSACRD,RFILL,RMUNG,RBUCK,RHOUSE,RNWALL,REND
#
	COMMON /RINDEX/ WHOUS,LROOM,CELLA
	COMMON /RINDEX/ MTROL,MAZE1	
	COMMON /RINDEX/ MGRAT,MAZ15	
	COMMON /RINDEX/ FORE1,FORE3,CLEAR,RESER
	COMMON /RINDEX/ STREA,EGYPT,ECHOR
	COMMON /RINDEX/ TSHAF	
	COMMON /RINDEX/ BSHAF,MMACH,DOME,MTORC
	COMMON /RINDEX/ CAROU	
	COMMON /RINDEX/ RIDDL,LLD2,TEMP1,TEMP2,MAINT
	COMMON /RINDEX/ BLROO,TREAS,RIVR1,RIVR2,RIVR3,MCYCL
	COMMON /RINDEX/ RIVR4,RIVR5,FCHMP,FALLS,MBARR
	COMMON /RINDEX/ MRAIN,POG,VLBOT,VAIR1,VAIR2,VAIR3,VAIR4
	COMMON /RINDEX/ LEDG2,LEDG3,LEDG4,MSAFE,CAGER
	COMMON /RINDEX/ CAGED,TWELL,BWELL,ALICE,ALISM,ALITR
	COMMON /RINDEX/ MTREE,BKENT,BKVW,BKTWI,BKVAU,BKBOX
	COMMON /RINDEX/ CRYPT,TSTRS,MRANT,MREYE
	COMMON /RINDEX/ MRA,MRB,MRC,MRG,MRD,FDOOR
	COMMON /RINDEX/ MRAE,MRCE,MRCW,MRGE,MRGW,MRDW,INMIR
	COMMON /RINDEX/ SCORR,NCORR,PARAP,CELL,PCELL,NCELL
#
# EXITS
#
	COMMON /XSRCH/ XMIN,XMAX,XDOWN,XUP,
		XNORTH,XSOUTH,XENTER,XEXIT
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
	COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
	COMMON /OINDEX/ WATER,ROPE,KNIFE,SWORD,LAMP,BLAMP,RUG
	COMMON /OINDEX/	LEAVE,TROLL,AXE
	COMMON /OINDEX/ RKNIF,KEYS,ICE,BAR
	COMMON /OINDEX/ COFFI,TORCH,TBASK,FBASK,IRBOX
	COMMON /OINDEX/ GHOST,TRUNK,BELL,BOOK,CANDL
	COMMON /OINDEX/ MATCH,TUBE,PUTTY,WRENC,SCREW,CYCLO,CHALI
	COMMON /OINDEX/ THIEF,STILL,WINDO,GRATE,DOOR
	COMMON /OINDEX/ HPOLE,LEAK,RBUTT,RAILI
	COMMON /OINDEX/ POT,STATU,IBOAT,DBOAT,PUMP,RBOAT
	COMMON /OINDEX/ STICK,BUOY,SHOVE,BALLO,RECEP,GUANO
	COMMON /OINDEX/ BROPE,HOOK1,HOOK2,SAFE,SSLOT,BRICK,FUSE
	COMMON /OINDEX/ GNOME,BLABE,DBALL,TOMB
	COMMON /OINDEX/ LCASE,CAGE,RCAGE,SPHER,SQBUT
	COMMON /OINDEX/ FLASK,POOL,SAFFR,BUCKE,ECAKE,ORICE,RDICE,BLICE
	COMMON /OINDEX/ ROBOT,FTREE,BILLS,PORTR,SCOL,ZGNOM
	COMMON /OINDEX/ EGG,BEGG,BAUBL,CANAR,BCANA
	COMMON /OINDEX/ YLWAL,RDWAL,PINDR,RBEAM
	COMMON /OINDEX/ ODOOR,QDOOR,CDOOR,NUM1,NUM8
	COMMON /OINDEX/ HANDS,WALL,LUNGS,SAILO,AVIAT,TEETH
	COMMON /OINDEX/ ITOBJ,EVERY,VALUA,OPLAY,WNORT,GWATE,MASTER
#
# CLOCK INTERRUPTS
#
	LOGICAL CFLAG
	COMMON /CEVENT/ CLNT,CTICK(25),CACTIO(25),CFLAG(25)
#
	COMMON /CINDEX/ CEVCUR,CEVMNT,CEVLNT,CEVMAT,CEVCND,
		CEVBAL,CEVBRN,CEVFUS,CEVLED,CEVSAF,CEVVLG,
		CEVGNO,CEVBUC,CEVSPH,CEVEGH,
			CEVFOR,CEVSCL,CEVZGI,CEVZGO,CEVSTE,
		CEVMRS,CEVPIN,CEVINQ,CEVFOL

#
# ADVENTURERS
#
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
		AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
#
	COMMON /AINDEX/ PLAYER,AROBOT,AMASTR
#
# VERBS
#
	COMMON /VINDEX/ CINTW,DEADXW,FRSTQW,INXW,OUTXW
	COMMON /VINDEX/ WALKIW,FIGHTW,FOOW
	COMMON /VINDEX/ MELTW,READW,INFLAW,DEFLAW,ALARMW,EXORCW
	COMMON /VINDEX/ PLUGW,KICKW,WAVEW,RAISEW,LOWERW,RUBW
	COMMON /VINDEX/ PUSHW,UNTIEW,TIEW,TIEUPW,TURNW,BREATW
	COMMON /VINDEX/ KNOCKW,LOOKW,EXAMIW,SHAKEW,MOVEW,TRNONW,TRNOFW
	COMMON /VINDEX/ OPENW,CLOSEW,FINDW,WAITW,SPINW,BOARDW,UNBOAW,TAKEW
	COMMON /VINDEX/ INVENW,FILLW,EATW,DRINKW,BURNW
	COMMON /VINDEX/ MUNGW,KILLW,ATTACW,SWINGW
	COMMON /VINDEX/ WALKW,TELLW,PUTW,DROPW,GIVEW,POURW,THROWW
	COMMON /VINDEX/ DIGW,LEAPW,STAYW,FOLLOW
	COMMON /VINDEX/ HELLOW,LOOKIW,LOOKUW,PUMPW,WINDW
	COMMON /VINDEX/ CLMBW,CLMBUW,CLMBDW,TRNTOW
#
# FLAGS
#
	LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL FOLLWF,SPELLF,sprf
	COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
		DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
		MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
			EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
		GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
		GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
		MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
		follwf,spellf,sprf(6)
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL

# AAPPLI, PAGE 2
#
	IF(RI.EQ.0) GO TO 10			#IF ZERO, NO APP.
	AAPPLI=.TRUE.				#ASSUME WINS.
	GO TO (1000,2000),RI			#BRANCH ON ADV.
	CALL BUG(11,RI)
#
# COMMON FALSE RETURN.
#
10	AAPPLI=.FALSE.
	RETURN
#
# A1--	ROBOT.  PROCESS MOST COMMANDS GIVEN TO ROBOT.
#
1000	IF((PRSA.NE.RAISEW).OR.(PRSO.NE.RCAGE)) GO TO 1200
	CFLAG(CEVSPH)=.FALSE.			#ROBOT RAISED CAGE.
	WINNER=PLAYER				#RESET FOR PLAYER.
	F=MOVETO(CAGER,WINNER)			#MOVE TO NEW ROOM.
	CALL NEWSTA(CAGE,567,CAGER,0,0)		#INSTALL CAGE IN ROOM.
	CALL NEWSTA(ROBOT,0,CAGER,0,0)		#INSTALL ROBOT IN ROOM.
	AROOM(AROBOT)=CAGER			#ALSO MOVE ROBOT/ADV.
	CAGESF=.TRUE.				#CAGE SOLVED.
	OFLAG1(ROBOT)=AND(OFLAG1(ROBOT),NOT(NDSCBT))
	OFLAG1(SPHER)=OR(OFLAG1(SPHER),TAKEBT)	#RESET FLAGS.
	RETURN
#
1200	IF((PRSA.NE.DRINKW).AND.(PRSA.NE.EATW)) GO TO 1300
	CALL RSPEAK(568)			#EAT OR DRINK, JOKE.
	RETURN
#
1300	IF(PRSA.NE.READW) GO TO 1400		#READ,
	CALL RSPEAK(569)			#JOKE.
	RETURN
#
1400	IF((PRSA.EQ.WALKW).OR.(PRSA.EQ.TAKEW).OR.(PRSA.EQ.DROPW)
		.OR.(PRSA.EQ.PUTW).OR.(PRSA.EQ.PUSHW).OR.(PRSA.EQ.THROWW)
		.OR.(PRSA.EQ.TURNW).OR.(PRSA.EQ.LEAPW)) GO TO 10
	CALL RSPEAK(570)			#JOKE.
	RETURN

# AAPLI, PAGE 3
#
# A2--	MASTER.  PROCESS MOST COMMANDS GIVEN TO MASTER.
#
2000	IF(AND(OFLAG2(QDOOR),OPENBT).NE.0) GO TO 2100
	CALL RSPEAK(783)			#NO MASTER YET.
	RETURN
#
2100	IF(PRSA.NE.WALKW) GO TO 2200		#WALK?
	I=784					#ASSUME WONT.
	IF(((HERE.EQ.SCORR).AND.
		((PRSO.EQ.XNORTH).OR.(PRSO.EQ.XENTER))).OR.
		((HERE.EQ.NCORR).AND.
			((PRSO.EQ.XSOUTH).OR.(PRSO.EQ.XENTER))))
		I=785				#IF PRISON, CANT.
	CALL RSPEAK(I)
	RETURN
#
2200	IF((PRSA.EQ.TAKEW).OR.(PRSA.EQ.DROPW).OR.(PRSA.EQ.PUTW).OR.
		(PRSA.EQ.THROWW).OR.(PRSA.EQ.PUSHW).OR.(PRSA.EQ.TURNW).OR.
		(PRSA.EQ.SPINW).OR.(PRSA.EQ.TRNTOW).OR.(PRSA.EQ.FOLLOW).OR.
		  (PRSA.EQ.STAYW).OR.(PRSA.EQ.OPENW).OR.(PRSA.EQ.CLOSEW).OR.
		 (PRSA.EQ.KILLW)) GO TO 10		#MASTER CAN DO.
	CALL RSPEAK(786)			#MASTER CANT DO IT.
	RETURN
#
	END

# THIEFD-	INTERMOVE THIEF DEMON
#
# DECLARATIONS
#
	SUBROUTINE THIEFD
	IMPLICIT INTEGER (A-Z)
	LOGICAL DFLAG,ONCE,PROB,QHERE,QSTILL,LIT,WINNIN
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
#
	COMMON /DEBUG/ DBGFLG,PRSFLG
#
# ROOMS
#
	COMMON /ROOMS/ RLNT,RDESC2,RDESC1(215),REXIT(215),
		RACTIO(215),RVAL(215),RFLAG(215)
	INTEGER RRAND(215)
	EQUIVALENCE (RVAL,RRAND)
#
	COMMON /RFLAG/ RSEEN,RLIGHT,RLAND,RWATER,RAIR,
		RSACRD,RFILL,RMUNG,RBUCK,RHOUSE,RNWALL,REND
#
	COMMON /RINDEX/ WHOUS,LROOM,CELLA
	COMMON /RINDEX/ MTROL,MAZE1	
	COMMON /RINDEX/ MGRAT,MAZ15	
	COMMON /RINDEX/ FORE1,FORE3,CLEAR,RESER
	COMMON /RINDEX/ STREA,EGYPT,ECHOR
	COMMON /RINDEX/ TSHAF	
	COMMON /RINDEX/ BSHAF,MMACH,DOME,MTORC
	COMMON /RINDEX/ CAROU	
	COMMON /RINDEX/ RIDDL,LLD2,TEMP1,TEMP2,MAINT
	COMMON /RINDEX/ BLROO,TREAS,RIVR1,RIVR2,RIVR3,MCYCL
	COMMON /RINDEX/ RIVR4,RIVR5,FCHMP,FALLS,MBARR
	COMMON /RINDEX/ MRAIN,POG,VLBOT,VAIR1,VAIR2,VAIR3,VAIR4
	COMMON /RINDEX/ LEDG2,LEDG3,LEDG4,MSAFE,CAGER
	COMMON /RINDEX/ CAGED,TWELL,BWELL,ALICE,ALISM,ALITR
	COMMON /RINDEX/ MTREE,BKENT,BKVW,BKTWI,BKVAU,BKBOX
	COMMON /RINDEX/ CRYPT,TSTRS,MRANT,MREYE
	COMMON /RINDEX/ MRA,MRB,MRC,MRG,MRD,FDOOR
	COMMON /RINDEX/ MRAE,MRCE,MRCW,MRGE,MRGW,MRDW,INMIR
	COMMON /RINDEX/ SCORR,NCORR,PARAP,CELL,PCELL,NCELL
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
	COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
	COMMON /OINDEX/ WATER,ROPE,KNIFE,SWORD,LAMP,BLAMP,RUG
	COMMON /OINDEX/	LEAVE,TROLL,AXE
	COMMON /OINDEX/ RKNIF,KEYS,ICE,BAR
	COMMON /OINDEX/ COFFI,TORCH,TBASK,FBASK,IRBOX
	COMMON /OINDEX/ GHOST,TRUNK,BELL,BOOK,CANDL
	COMMON /OINDEX/ MATCH,TUBE,PUTTY,WRENC,SCREW,CYCLO,CHALI
	COMMON /OINDEX/ THIEF,STILL,WINDO,GRATE,DOOR
	COMMON /OINDEX/ HPOLE,LEAK,RBUTT,RAILI
	COMMON /OINDEX/ POT,STATU,IBOAT,DBOAT,PUMP,RBOAT
	COMMON /OINDEX/ STICK,BUOY,SHOVE,BALLO,RECEP,GUANO
	COMMON /OINDEX/ BROPE,HOOK1,HOOK2,SAFE,SSLOT,BRICK,FUSE
	COMMON /OINDEX/ GNOME,BLABE,DBALL,TOMB
	COMMON /OINDEX/ LCASE,CAGE,RCAGE,SPHER,SQBUT
	COMMON /OINDEX/ FLASK,POOL,SAFFR,BUCKE,ECAKE,ORICE,RDICE,BLICE
	COMMON /OINDEX/ ROBOT,FTREE,BILLS,PORTR,SCOL,ZGNOM
	COMMON /OINDEX/ EGG,BEGG,BAUBL,CANAR,BCANA
	COMMON /OINDEX/ YLWAL,RDWAL,PINDR,RBEAM
	COMMON /OINDEX/ ODOOR,QDOOR,CDOOR,NUM1,NUM8
	COMMON /OINDEX/ HANDS,WALL,LUNGS,SAILO,AVIAT,TEETH
	COMMON /OINDEX/ ITOBJ,EVERY,VALUA,OPLAY,WNORT,GWATE,MASTER
#
# VILLAINS AND DEMONS
#
	LOGICAL THFFLG,SWDACT,THFACT
	COMMON /HACK/ THFPOS,THFFLG,THFACT,SWDACT,SWDSTA
#
# FLAGS
#
	LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL FOLLWF,SPELLF,sprf
	COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
		DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
		MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
			EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
		GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
		GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
		MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
		follwf,spellf,sprf(6)
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL
#
# FUNCTIONS AND DATA
#
	QSTILL(R)=(QHERE(STILL,R).OR.(OADV(STILL).EQ.-THIEF))

# THIEFD, PAGE 2
#
#D	DFLAG=AND(PRSFLG,o'100000').NE.0	#SET UP DETAIL FLAG.
	ONCE=.FALSE.				#INIT FLAG.
1025	RHERE=OROOM(THIEF)			#VISIBLE POS.
	IF(RHERE.NE.0) THFPOS=RHERE
#
	IF(THFPOS.EQ.HERE) GO TO 1100		#THIEF IN WIN RM?
	IF(THFPOS.NE.TREAS) GO TO 1400		#THIEF NOT IN TREAS?
#
# THIEF IS IN TREASURE ROOM, AND WINNER IS NOT.
#
#D	IF(DFLAG) TYPE 10
#D10	FORMAT(' THIEFD-- IN TREASURE ROOM')
	IF(RHERE.EQ.0) GO TO 1050		#VISIBLE?
	CALL NEWSTA(THIEF,0,0,0,0)		#YES, VANISH.
	RHERE=0
	IF(QSTILL(TREAS)) CALL NEWSTA(STILL,0,0,THIEF,0)
1050	I=ROBADV(-THIEF,THFPOS,0,0)			#DROP VALUABLES.
	IF(QHERE(EGG,THFPOS)) OFLAG2(EGG)=OFLAG2(EGG).OR.OPENBT
	GO TO 1700
#
# THIEF AND WINNER IN SAME ROOM.
#
1100	IF(THFPOS.EQ.TREAS) GO TO 1700		#IF TREAS ROOM, NOTHING.
	IF(AND(RFLAG(THFPOS),RLIGHT).NE.0) GO TO 1400	#NOT IF LIGHT.
#D	IF(DFLAG) TYPE 20
#D20	FORMAT(' THIEFD-- IN ADV ROOM')
	IF(THFFLG) GO TO 1300			#THIEF ANNOUNCED?
	IF((RHERE.NE.0).OR.PROB(70,70)) GO TO 1150	#IF INVIS AND 30%.
	IF(OCAN(STILL).NE.THIEF) GO TO 1700	#ABORT IF NO STILLETTO.
	CALL NEWSTA(THIEF,583,THFPOS,0,0)	#INSERT THIEF INTO ROOM.
	THFFLG=.TRUE.				#THIEF IS ANNOUNCED.
	RETURN
#
1150	IF((RHERE.EQ.0).OR.(AND(OFLAG2(THIEF),FITEBT).EQ.0)) {
		GO TO 1200			#IF VISIBLE AND FIGHT.
		}
	IF(WINNIN(THIEF,WINNER)) GO TO 1175	#WINNING?
	CALL NEWSTA(THIEF,584,0,0,0)		#NO, VANISH THIEF.
	OFLAG2(THIEF)=AND(OFLAG2(THIEF),NOT(FITEBT))
	IF(QSTILL(THFPOS)) CALL NEWSTA(STILL,0,0,THIEF,0)
	RETURN
#
1175	IF(PROB(90,90)) GO TO 1700		#90% CHANCE TO STAY.
#
1200	IF((RHERE.EQ.0).OR.PROB(70,70)) GO TO 1250	#IF VISIBLE AND 30%
	CALL NEWSTA(THIEF,585,0,0,0)		#VANISH THIEF.
	IF(QSTILL(THFPOS)) CALL NEWSTA(STILL,0,0,THIEF,0)
	RETURN
#
1300	IF(RHERE.EQ.0) GO TO 1700		#ANNOUNCED.  VISIBLE?
1250	IF(PROB(70,70)) RETURN			#70% CHANCE TO DO NOTHING.
	THFFLG=.TRUE.
	NR=ROBRM(THFPOS,100,0,0,-THIEF)+ROBADV(WINNER,0,0,-THIEF)
	I=586					#ROBBED EM.
	IF(RHERE.NE.0) I=588			#WAS HE VISIBLE?
	IF(NR.NE.0) I=I+1			#DID HE GET ANYTHING?
	CALL NEWSTA(THIEF,I,0,0,0)		#VANISH THIEF.
	IF(QSTILL(THFPOS))
		CALL NEWSTA(STILL,0,0,THIEF,0)	#RECLAIM STILLETTO.
	IF((NR.NE.0).AND..NOT.LIT(THFPOS)) CALL RSPEAK(406)
	RHERE=0
	GO TO 1700				#ONWARD.
#
# NOT IN ADVENTURERS ROOM.
#
1400	CALL NEWSTA(THIEF,0,0,0,0)		#VANISH.
	RHERE=0
#D	IF(DFLAG) TYPE 30,THFPOS
#D30	FORMAT(' THIEFD-- IN ROOM ',I4)
	IF(QSTILL(THFPOS))
		CALL NEWSTA(STILL,0,0,THIEF,0)
	IF(AND(RFLAG(THFPOS),RSEEN).EQ.0) GO TO 1700	#CANT ROB UNSEEN.
	I=ROBRM(THFPOS,75,0,0,-THIEF)		#ROB ROOM 75%.
	IF((THFPOS.LT.MAZE1).OR.(THFPOS.GT.MAZ15).OR.
		(HERE.LT.MAZE1).OR.(HERE.GT.MAZ15)) GO TO 1500
	DO I=1,OLNT {				#BOTH IN MAZE.
	  IF(.NOT.QHERE(I,THFPOS).OR.PROB(60,60).OR.
		(AND(OFLAG1(I),(VISIBT+TAKEBT)).NE.(VISIBT+TAKEBT)))
		NEXT
	  CALL RSPSUB(590,ODESC2(I))		#TAKE OBJECT.
	  IF(PROB(40,20)) GO TO 1700
	  CALL NEWSTA(I,0,0,0,-THIEF)		#MOST OF THE TIME.
	  OFLAG2(I)=OFLAG2(I).OR.TCHBT
	  GO TO 1700
	  }
	GO TO 1700
#
1500	DO I=1,OLNT {				#NOT IN MAZE.
	  IF(.NOT.QHERE(I,THFPOS).OR.(OTVAL(I).NE.0).OR.PROB(80,60).OR.
		(AND(OFLAG1(I),(VISIBT+TAKEBT)).NE.(VISIBT+TAKEBT)))
		NEXT
	  CALL NEWSTA(I,0,0,0,-THIEF)
	  OFLAG2(I)=OFLAG2(I).OR.TCHBT
	  GO TO 1700
	  }
#
# NOW MOVE TO NEW ROOM.
#
1700	IF(OADV(ROPE).EQ.-THIEF) DOMEF=.FALSE.
	IF(ONCE) GO TO 1800
	ONCE=.NOT.ONCE
1750	THFPOS=THFPOS-1			#NEXT ROOM.
	IF(THFPOS.LE.0) THFPOS=RLNT
	IF(AND(RFLAG(THFPOS),(RLAND+RSACRD+REND)).NE.RLAND)
		GO TO 1750			#MUST BE LAND, PROFANE.
	THFFLG=.FALSE.				#NOT ANNOUNCED.
	GO TO 1025				#ONCE MORE.
#
# ALL DONE.
#
1800	IF(THFPOS.EQ.TREAS) RETURN			#IN TREASURE ROOM?
	J=591					#NO, DROP STUFF.
	IF(THFPOS.NE.HERE) J=0
	DO I=1,OLNT {
	  IF((OADV(I).NE.-THIEF).OR.PROB(70,70).OR.
		(OTVAL(I).GT.0)) NEXT
	  CALL NEWSTA(I,J,THFPOS,0,0)
	  J=0
	  }
	RETURN
#
	END

# FIGHTD- INTERMOVE FIGHT DEMON
#
# DECLARATIONS
#
	SUBROUTINE FIGHTD
	IMPLICIT INTEGER (A-Z)
	LOGICAL PROB,OAPPLI
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
	COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
	COMMON /OINDEX/ WATER,ROPE,KNIFE,SWORD,LAMP,BLAMP,RUG
	COMMON /OINDEX/	LEAVE,TROLL,AXE
	COMMON /OINDEX/ RKNIF,KEYS,ICE,BAR
	COMMON /OINDEX/ COFFI,TORCH,TBASK,FBASK,IRBOX
	COMMON /OINDEX/ GHOST,TRUNK,BELL,BOOK,CANDL
	COMMON /OINDEX/ MATCH,TUBE,PUTTY,WRENC,SCREW,CYCLO,CHALI
	COMMON /OINDEX/ THIEF,STILL,WINDO,GRATE,DOOR
	COMMON /OINDEX/ HPOLE,LEAK,RBUTT,RAILI
	COMMON /OINDEX/ POT,STATU,IBOAT,DBOAT,PUMP,RBOAT
	COMMON /OINDEX/ STICK,BUOY,SHOVE,BALLO,RECEP,GUANO
	COMMON /OINDEX/ BROPE,HOOK1,HOOK2,SAFE,SSLOT,BRICK,FUSE
	COMMON /OINDEX/ GNOME,BLABE,DBALL,TOMB
	COMMON /OINDEX/ LCASE,CAGE,RCAGE,SPHER,SQBUT
	COMMON /OINDEX/ FLASK,POOL,SAFFR,BUCKE,ECAKE,ORICE,RDICE,BLICE
	COMMON /OINDEX/ ROBOT,FTREE,BILLS,PORTR,SCOL,ZGNOM
	COMMON /OINDEX/ EGG,BEGG,BAUBL,CANAR,BCANA
	COMMON /OINDEX/ YLWAL,RDWAL,PINDR,RBEAM
	COMMON /OINDEX/ ODOOR,QDOOR,CDOOR,NUM1,NUM8
	COMMON /OINDEX/ HANDS,WALL,LUNGS,SAILO,AVIAT,TEETH
	COMMON /OINDEX/ ITOBJ,EVERY,VALUA,OPLAY,WNORT,GWATE,MASTER
#
# VILLAINS AND DEMONS
#
	COMMON /VILL/ VLNT,VILLNS(4),VPROB(4),VOPPS(4),VBEST(4),VMELEE(4)
#
# ADVENTURERS
#
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
		AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
#
	COMMON /AFLAGS/ ASTAG
#
	COMMON /AINDEX/ PLAYER,AROBOT,AMASTR
#
# VERBS
#
	COMMON /VINDEX/ CINTW,DEADXW,FRSTQW,INXW,OUTXW
	COMMON /VINDEX/ WALKIW,FIGHTW,FOOW
	COMMON /VINDEX/ MELTW,READW,INFLAW,DEFLAW,ALARMW,EXORCW
	COMMON /VINDEX/ PLUGW,KICKW,WAVEW,RAISEW,LOWERW,RUBW
	COMMON /VINDEX/ PUSHW,UNTIEW,TIEW,TIEUPW,TURNW,BREATW
	COMMON /VINDEX/ KNOCKW,LOOKW,EXAMIW,SHAKEW,MOVEW,TRNONW,TRNOFW
	COMMON /VINDEX/ OPENW,CLOSEW,FINDW,WAITW,SPINW,BOARDW,UNBOAW,TAKEW
	COMMON /VINDEX/ INVENW,FILLW,EATW,DRINKW,BURNW
	COMMON /VINDEX/ MUNGW,KILLW,ATTACW,SWINGW
	COMMON /VINDEX/ WALKW,TELLW,PUTW,DROPW,GIVEW,POURW,THROWW
	COMMON /VINDEX/ DIGW,LEAPW,STAYW,FOLLOW
	COMMON /VINDEX/ HELLOW,LOOKIW,LOOKUW,PUMPW,WINDW
	COMMON /VINDEX/ CLMBW,CLMBUW,CLMBDW,TRNTOW
#
# FLAGS
#
	LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL FOLLWF,SPELLF,sprf
	COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
		DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
		MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
			EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
		GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
		GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
		MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
		follwf,spellf,sprf(6)
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL
#
# FUNCTIONS AND DATA
#
	DATA ROUT/1/

# FIGHTD, PAGE 2
#
	DO I=1,VLNT {				#LOOP THRU VILLAINS.
	  VOPPS(I)=0				#CLEAR OPPONENT SLOT.
	  OBJ=VILLNS(I)				#GET OBJECT NO.
	  RA=OACTIO(OBJ)			#GET HIS ACTION.
	  IF(HERE.NE.OROOM(OBJ)) GO TO 2200	#ADVENTURER STILL HERE?
	  IF((OBJ.EQ.THIEF).AND.THFENF) NEXT	#THIEF ENGROSSED?
	  IF(OCAPAC(OBJ).GE.0) GO TO 2050	#YES, VILL AWAKE?
	  IF((VPROB(I).EQ.0).OR..NOT.PROB(VPROB(I),VPROB(I)))
		GO TO 2025			#NO, SEE IF WAKES UP.
	  OCAPAC(OBJ)=IABS(OCAPAC(OBJ))
	  VPROB(I)=0
	  IF(RA.EQ.0) NEXT			#ANYTHING TO DO?
	  PRSA=INXW				#YES, WAKE HIM UP.
	  F=OAPPLI(RA,0)
	  NEXT					#NOTHING ELSE HAPPENS.
#
2025	  VPROB(I)=VPROB(I)+10			#INCREASE WAKEUP PROB.
	  NEXT					#NOTHING ELSE.
#
2050	  IF(AND(OFLAG2(OBJ),FITEBT).EQ.0) GO TO 2100
	  VOPPS(I)=OBJ				#FIGHTING, SET UP OPP.
	  NEXT
#
2100	  IF(RA.EQ.0) NEXT			#NOT FIGHTING,
	  PRSA=FRSTQW				#SET UP PROBABILITY
	  IF(.NOT.OAPPLI(RA,0)) NEXT		#OF FIGHTING.
	  OFLAG2(OBJ)=OFLAG2(OBJ).OR.FITEBT
	  VOPPS(I)=OBJ				#SET UP OPP.
	  NEXT
#
2200	  IF((AND(OFLAG2(OBJ),FITEBT).EQ.0).OR.(RA.EQ.0))
		GO TO 2300			#NOTHING TO DO.
	  PRSA=FIGHTW				#HAVE A FIGHT.
	  F=OAPPLI(RA,0)
2300	  IF(OBJ.EQ.THIEF) THFENF=.FALSE.	#TURN OFF ENGROSSED.
	  AFLAG(PLAYER)=AND(AFLAG(PLAYER),NOT(ASTAG))
	  OFLAG2(OBJ)=AND(OFLAG2(OBJ),NOT(STAGBT+FITEBT))
	  IF((OCAPAC(OBJ).GE.0).OR.(RA.EQ.0)) NEXT
	  PRSA=INXW				#WAKE HIM UP.
	  F=OAPPLI(RA,0)
	  OCAPAC(OBJ)=IABS(OCAPAC(OBJ))
	  }

# FIGHTD, PAGE 3
#
# NOW DO ACTUAL COUNTERBLOWS.
#
	OUT=0					#ASSUME HERO OK.
2600	DO I=1,VLNT {				#LOOP THRU OPPS.
	  J=VOPPS(I)
	  IF(J.EQ.0) NEXT			#SLOT EMPTY?
	  RA=OACTIO(J)
	  IF(RA.EQ.0) GO TO 2650		#VILLAIN ACTION?
	  PRSA=FIGHTW				#SEE IF
	  IF(OAPPLI(RA,0)) NEXT			#SPECIAL ACTION.
2650	  RES=BLOW(PLAYER,J,VMELEE(I),.FALSE.,OUT)	#STRIKE BLOW.
	  IF(RES.LT.0) RETURN			#IF HERO DEAD, EXIT.
	  IF(RES.EQ.ROUT) OUT=2+RND(3)		#IF HERO OUT, SET FLG.
	  }
	OUT=OUT-1				#DECREMENT OUT COUNT.
	IF(OUT.GT.0) GO TO 2600			#IF STILL OUT, GO AGAIN.
	RETURN
#
	END

# BLOW- STRIKE BLOW
#
# DECLARATIONS
#
	INTEGER FUNCTION BLOW(H,V,RMK,HFLG,OUT)
	IMPLICIT INTEGER (A-Z)
	LOGICAL HFLG,OAPPLI,PROB
	INTEGER DEF1R(3),DEF2R(4),DEF3R(5)
	INTEGER RVECTR(66),RSTATE(45)
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
#
# PARSE VECTOR
#
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
# MISCELLANEOUS VARIABLES
#
	COMMON /STAR/ MBASE,STRBIT
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
#
# CLOCK INTERRUPTS
#
	LOGICAL CFLAG
	COMMON /CEVENT/ CLNT,CTICK(25),CACTIO(25),CFLAG(25)
#
	COMMON /CINDEX/ CEVCUR,CEVMNT,CEVLNT,CEVMAT,CEVCND,
		CEVBAL,CEVBRN,CEVFUS,CEVLED,CEVSAF,CEVVLG,
		CEVGNO,CEVBUC,CEVSPH,CEVEGH,
			CEVFOR,CEVSCL,CEVZGI,CEVZGO,CEVSTE,
		CEVMRS,CEVPIN,CEVINQ,CEVFOL

#
# ADVENTURERS
#
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
		AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
#
	COMMON /AFLAGS/ ASTAG
#
	COMMON /AINDEX/ PLAYER,AROBOT,AMASTR
#
# VERBS
#
	COMMON /VINDEX/ CINTW,DEADXW,FRSTQW,INXW,OUTXW
	COMMON /VINDEX/ WALKIW,FIGHTW,FOOW
#
# FUNCTIONS AND DATA
#
	DATA RMISS/0/,ROUT/1/,RKILL/2/,RLIGHT/3/
	DATA RSER/4/,RSTAG/5/,RLOSE/6/,RHES/7/,RSIT/8/
	DATA DEF1R/1,2,3/
	DATA DEF2R/13,23,24,25/
	DATA DEF3R/35,36,46,47,57/
#
	DATA RVECTR/0,0,0,0,5,5,1,1,2,2,2,2,
		0,0,0,0,0,5,5,3,3,1,
		0,0,0,5,5,3,3,3,1,2,2,2,
			0,0,0,0,0,5,5,3,3,4,4,
		0,0,0,5,5,3,3,3,4,4,4,
		0,5,5,3,3,3,3,4,4,4/
	DATA RSTATE/5000,3005,3008,4011,3015,3018,1021,0,0,
		5022,3027,3030,4033,3037,3040,1043,0,0,
		4044,2048,4050,4054,5058,4063,4067,3071,1074,
			4075,1079,4080,4084,4088,4092,4096,4100,1104,
		4105,2109,4111,4115,4119,4123,4127,3131,3134/

# BLOW, PAGE 3
#
	RA=OACTIO(V)				#GET VILLAIN ACTION,
	DV=ODESC2(V)				#DESCRIPTION.
	BLOW=RMISS				#ASSUME NO RESULT.
#D	TYPE 10,H,V,RMK,HFLG,OUT
#D10	FORMAT(' BLOW 10-- ',3I7,L7,I7)
	IF(.NOT.HFLG) GO TO 1000		#HERO STRIKING BLOW?
#
# HERO IS ATTACKER, VILLAIN IS DEFENDER.
#
	PBLOSE=10				#BAD LK PROB.
	OFLAG2(V)=OFLAG2(V).OR.FITEBT		#YES, VILLAIN GETS MAD.
	IF(AND(AFLAG(H),ASTAG).EQ.0) GO TO 100	#HERO STAG?
	CALL RSPEAK(591)			#YES, CANT FIGHT.
	AFLAG(H)=AND(AFLAG(H),NOT(ASTAG))
	RETURN
#
100	ATT=FIGHTS(H,.TRUE.)			#GET HIS STRENGTH.
	OA=ATT
	DEF=VILSTR(V)				#GET VILL STRENGTH.
	OD=DEF
	DWEAP=0					#ASSUME NO WEAPON.
	DO I=1,OLNT {				#SEARCH VILLAIN.
	  IF((OCAN(I).EQ.V).AND.(AND(OFLAG2(I),WEAPBT).NE.0))
		DWEAP=I
	  }
	IF(V.EQ.AOBJ(PLAYER)) GO TO 300		#KILLING SELF?
	IF(DEF.NE.0) GO TO 2000			#DEFENDER ALIVE?
	CALL RSPSUB(592,DV)			#VILLAIN DEAD.
	RETURN
#
300	CALL JIGSUP(593)			#KILLING SELF.
	RETURN
#
# VILLAIN IS ATTACKER, HERO IS DEFENDER.
#
1000	PBLOSE=50				#BAD LK PROB.
	AFLAG(H)=AND(AFLAG(H),NOT(ASTAG))	#VILL STRIKING.
	IF(AND(OFLAG2(V),STAGBT).EQ.0) GO TO 1200	#VILL STAGGERED?
	OFLAG2(V)=AND(OFLAG2(V),NOT(STAGBT))	#MAKE HIM OK.
	CALL RSPSUB(594,DV)			#DESCRIBE.
	RETURN
#
1200	ATT=VILSTR(V)				#SET UP ATT, DEF.
	OA=ATT
	DEF=FIGHTS(H,.TRUE.)
	IF(DEF.LE.0) RETURN			#DONT ALLOW DEAD DEF.
	OD=FIGHTS(H,.FALSE.)
	DWEAP=IABS(FWIM(0,WEAPBT,0,0,H,.TRUE.))	#FIND A WEAPON.

# BLOW, PAGE 4
#
# PARTIES ARE NOW EQUIPPED.  DEF CANNOT BE ZERO.
# ATT MUST BE > 0.
#
2000	CONTINUE
#D	TYPE 2050,ATT,OA,DEF,OD,DWEAP
#D2050	FORMAT(' BLOW 2050-- ',5I7)
	IF(DEF.GT.0) GO TO 2100			#DEF ALIVE?
	RES=RKILL
	IF(HFLG) CALL RSPSUB(595,DV)		#DEADER.
	GO TO 3000
#
2100	IF(DEF-2) 2200,2300,2400		#DEF <2,=2,>2
2200	ATT=MIN0(ATT,3)				#SCALE ATT.
	TBL=DEF1R(ATT)				#CHOOSE TABLE.
	GO TO 2500
#
2300	ATT=MIN0(ATT,4)				#SCALE ATT.
	TBL=DEF2R(ATT)				#CHOOSE TABLE.
	GO TO 2500
#
2400	ATT=ATT-DEF				#SCALE ATT.
	ATT=MIN0(2,MAX0(-2,ATT))+3
	TBL=DEF3R(ATT)
#
2500	RES=RVECTR(TBL+RND(10))			#GET RESULT.
	IF(OUT.EQ.0) GO TO 2600			#WAS HE OUT?
	IF(RES.EQ.RSTAG) GO TO 2550		#YES, STAG--> HES.
	RES=RSIT				#OTHERWISE, SITTING.
	GO TO 2600
2550	RES=RHES
2600	IF((RES.EQ.RSTAG).AND.(DWEAP.NE.0).AND.PROB(25,PBLOSE))
		RES=RLOSE			#LOSE WEAPON.
#
	MI=RSTATE(((RMK-1)*9)+RES+1)		#CHOOSE TABLE ENTRY.
	IF(MI.EQ.0) GO TO 3000
	I=(MOD(MI,1000)+RND(MI/1000))+MBASE+1
	J=DV
	IF(.NOT.HFLG .AND.(DWEAP.NE.0)) J=ODESC2(DWEAP)
#D	TYPE 2650,RES,MI,I,J,MBASE
#D2650	FORMAT(' BLOW 2650-- ',5I7)
	CALL RSPSUB(I,J)			#PRESENT RESULT.

# BLOW, PAGE 5
#
# NOW APPLY RESULT
#
3000	GO TO (4000,3100,3200,3300,3400,3500,3600,4000,3200),RES+1
#
3100	IF(HFLG) DEF=-DEF			#UNCONSCIOUS.
	GO TO 4000
#
3200	DEF=0					#KILLED OR SITTING DUCK.
	GO TO 4000
#
3300	DEF=MAX0(0,DEF-1)			#LIGHT WOUND.
	GO TO 4000
#
3400	DEF=MAX0(0,DEF-2)			#SERIOUS WOUND.
	GO TO 4000
#
3500	IF(HFLG) GO TO 3550			#STAGGERED.
	AFLAG(H)=AFLAG(H).OR.ASTAG
	GO TO 4000
#
3550	OFLAG2(V)=OFLAG2(V).OR.STAGBT
	GO TO 4000
#
3600	CALL NEWSTA(DWEAP,0,HERE,0,0)		#LOSE WEAPON.
	DWEAP=0
	IF(HFLG) GO TO 4000			#IF HERO, DONE.
	DWEAP=IABS(FWIM(0,WEAPBT,0,0,H,.TRUE.))	#GET NEW.
	IF(DWEAP.NE.0) CALL RSPSUB(605,ODESC2(DWEAP))

# BLOW, PAGE 6
#
4000	BLOW=RES				#RETURN RESULT.
	IF(.NOT.HFLG) GO TO 4500		#HERO?
	OCAPAC(V)=DEF				#STORE NEW CAPACITY.
	IF(DEF.NE.0) GO TO 4100			#DEAD?
	OFLAG2(V)=AND(OFLAG2(V),NOT(FITEBT))	#YES, NOT FIGHTING.
	CALL RSPSUB(572,DV)			#HE DIES.
	CALL NEWSTA(V,0,0,0,0)			#MAKE HIM DISAPPEAR.
	IF(RA.EQ.0) RETURN			#IF NX TO DO, EXIT.
	PRSA=DEADXW				#LET HIM KNOW.
	F=OAPPLI(RA,0)
	RETURN
#
4100	IF((RES.NE.ROUT).OR.(RA.EQ.0)) RETURN
	PRSA=OUTXW				#LET HIM BE OUT.
	F=OAPPLI(RA,0)
	RETURN
#
4500	ASTREN(H)=-10000			#ASSUME DEAD.
	IF(DEF.NE.0) ASTREN(H)=DEF-OD
	IF(DEF.GE.OD) GO TO 4600
	CTICK(CEVCUR)=30
	CFLAG(CEVCUR)=.TRUE.
4600	IF(FIGHTS(H,.TRUE.).GT.0) RETURN
	ASTREN(H)=1-FIGHTS(H,.FALSE.)		#HE'S DEAD.
	CALL JIGSUP(596)
	BLOW=-1
	RETURN
#
	END

# SWORDD- SWORD INTERMOVE DEMON
#
# DECLARATIONS
#
	SUBROUTINE SWORDD
	IMPLICIT INTEGER(A-Z)
	LOGICAL INFEST,FINDXT
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
#
# EXITS
#
	COMMON /CURXT/ XTYPE,XROOM1,XSTRNG,XACTIO,XOBJ
	EQUIVALENCE (XFLAG,XOBJ)
#
	COMMON /XSRCH/ XMIN,XMAX,XDOWN,XUP,
		XNORTH,XSOUTH,XENTER,XEXIT
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
	COMMON /OINDEX/ WATER,ROPE,KNIFE,SWORD,LAMP,BLAMP,RUG
	COMMON /OINDEX/	LEAVE,TROLL,AXE
	COMMON /OINDEX/ RKNIF,KEYS,ICE,BAR
	COMMON /OINDEX/ COFFI,TORCH,TBASK,FBASK,IRBOX
	COMMON /OINDEX/ GHOST,TRUNK,BELL,BOOK,CANDL
	COMMON /OINDEX/ MATCH,TUBE,PUTTY,WRENC,SCREW,CYCLO,CHALI
	COMMON /OINDEX/ THIEF,STILL,WINDO,GRATE,DOOR
	COMMON /OINDEX/ HPOLE,LEAK,RBUTT,RAILI
	COMMON /OINDEX/ POT,STATU,IBOAT,DBOAT,PUMP,RBOAT
	COMMON /OINDEX/ STICK,BUOY,SHOVE,BALLO,RECEP,GUANO
	COMMON /OINDEX/ BROPE,HOOK1,HOOK2,SAFE,SSLOT,BRICK,FUSE
	COMMON /OINDEX/ GNOME,BLABE,DBALL,TOMB
	COMMON /OINDEX/ LCASE,CAGE,RCAGE,SPHER,SQBUT
	COMMON /OINDEX/ FLASK,POOL,SAFFR,BUCKE,ECAKE,ORICE,RDICE,BLICE
	COMMON /OINDEX/ ROBOT,FTREE,BILLS,PORTR,SCOL,ZGNOM
	COMMON /OINDEX/ EGG,BEGG,BAUBL,CANAR,BCANA
	COMMON /OINDEX/ YLWAL,RDWAL,PINDR,RBEAM
	COMMON /OINDEX/ ODOOR,QDOOR,CDOOR,NUM1,NUM8
	COMMON /OINDEX/ HANDS,WALL,LUNGS,SAILO,AVIAT,TEETH
	COMMON /OINDEX/ ITOBJ,EVERY,VALUA,OPLAY,WNORT,GWATE,MASTER
#
# VILLAINS AND DEMONS
#
	LOGICAL THFFLG,SWDACT,THFACT
	COMMON /HACK/ THFPOS,THFFLG,THFACT,SWDACT,SWDSTA
#
# ADVENTURERS
#
	COMMON /AINDEX/ PLAYER,AROBOT,AMASTR

# SWORDD, PAGE 2
#
	IF(OADV(SWORD).NE.PLAYER) GO TO 500	#HOLDING SWORD?
	NG=2					#ASSUME VILL CLOSE.
	IF(INFEST(HERE)) GO TO 300		#VILL HERE?
	NG=1
	DO I=XMIN,XMAX,XMIN {			#NO, SEARCH ROOMS.
	  IF(.NOT.FINDXT(I,HERE)) NEXT		#ROOM THAT WAY?
	  GO TO (50,200,50,50),XTYPE		#SEE IF ROOM AT ALL.
50	  IF(INFEST(XROOM1)) GO TO 300		#CHECK ROOM.
	  }
	NG=0					#NO GLOW.
#
300	IF(NG.EQ.SWDSTA) RETURN			#ANY STATE CHANGE?
	CALL RSPEAK(NG+495)			#YES, TELL NEW STATE.
	SWDSTA=NG
	RETURN
#
500	SWDACT=.FALSE.				#DROPPED SWORD,
	RETURN					#DISABLE DEMON.
	END

# INFEST-	SUBROUTINE TO TEST FOR INFESTED ROOM
#
# DECLARATIONS
#
	LOGICAL FUNCTION INFEST(R)
	IMPLICIT INTEGER(A-Z)
#
# ROOMS
#
	COMMON /RINDEX/ WHOUS,LROOM,CELLA
	COMMON /RINDEX/ MTROL,MAZE1	
	COMMON /RINDEX/ MGRAT,MAZ15	
	COMMON /RINDEX/ FORE1,FORE3,CLEAR,RESER
	COMMON /RINDEX/ STREA,EGYPT,ECHOR
	COMMON /RINDEX/ TSHAF	
	COMMON /RINDEX/ BSHAF,MMACH,DOME,MTORC
	COMMON /RINDEX/ CAROU	
	COMMON /RINDEX/ RIDDL,LLD2,TEMP1,TEMP2,MAINT
	COMMON /RINDEX/ BLROO,TREAS,RIVR1,RIVR2,RIVR3,MCYCL
	COMMON /RINDEX/ RIVR4,RIVR5,FCHMP,FALLS,MBARR
	COMMON /RINDEX/ MRAIN,POG,VLBOT,VAIR1,VAIR2,VAIR3,VAIR4
	COMMON /RINDEX/ LEDG2,LEDG3,LEDG4,MSAFE,CAGER
	COMMON /RINDEX/ CAGED,TWELL,BWELL,ALICE,ALISM,ALITR
	COMMON /RINDEX/ MTREE,BKENT,BKVW,BKTWI,BKVAU,BKBOX
	COMMON /RINDEX/ CRYPT,TSTRS,MRANT,MREYE
	COMMON /RINDEX/ MRA,MRB,MRC,MRG,MRD,FDOOR
	COMMON /RINDEX/ MRAE,MRCE,MRCW,MRGE,MRGW,MRDW,INMIR
	COMMON /RINDEX/ SCORR,NCORR,PARAP,CELL,PCELL,NCELL
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
	COMMON /OINDEX/ WATER,ROPE,KNIFE,SWORD,LAMP,BLAMP,RUG
	COMMON /OINDEX/	LEAVE,TROLL,AXE
	COMMON /OINDEX/ RKNIF,KEYS,ICE,BAR
	COMMON /OINDEX/ COFFI,TORCH,TBASK,FBASK,IRBOX
	COMMON /OINDEX/ GHOST,TRUNK,BELL,BOOK,CANDL
	COMMON /OINDEX/ MATCH,TUBE,PUTTY,WRENC,SCREW,CYCLO,CHALI
	COMMON /OINDEX/ THIEF,STILL,WINDO,GRATE,DOOR
	COMMON /OINDEX/ HPOLE,LEAK,RBUTT,RAILI
	COMMON /OINDEX/ POT,STATU,IBOAT,DBOAT,PUMP,RBOAT
	COMMON /OINDEX/ STICK,BUOY,SHOVE,BALLO,RECEP,GUANO
	COMMON /OINDEX/ BROPE,HOOK1,HOOK2,SAFE,SSLOT,BRICK,FUSE
	COMMON /OINDEX/ GNOME,BLABE,DBALL,TOMB
	COMMON /OINDEX/ LCASE,CAGE,RCAGE,SPHER,SQBUT
	COMMON /OINDEX/ FLASK,POOL,SAFFR,BUCKE,ECAKE,ORICE,RDICE,BLICE
	COMMON /OINDEX/ ROBOT,FTREE,BILLS,PORTR,SCOL,ZGNOM
	COMMON /OINDEX/ EGG,BEGG,BAUBL,CANAR,BCANA
	COMMON /OINDEX/ YLWAL,RDWAL,PINDR,RBEAM
	COMMON /OINDEX/ ODOOR,QDOOR,CDOOR,NUM1,NUM8
	COMMON /OINDEX/ HANDS,WALL,LUNGS,SAILO,AVIAT,TEETH
	COMMON /OINDEX/ ITOBJ,EVERY,VALUA,OPLAY,WNORT,GWATE,MASTER
#
# VILLAINS AND DEMONS
#
	LOGICAL THFFLG,SWDACT,THFACT
	COMMON /HACK/ THFPOS,THFFLG,THFACT,SWDACT,SWDSTA
#
# FLAGS
#
	LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL FOLLWF,SPELLF,sprf
	COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
		DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
		MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
			EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
		GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
		GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
		MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
		follwf,spellf,sprf(6)
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL
#
	IF(.NOT.ENDGMF) INFEST=(OROOM(CYCLO).EQ.R).OR.(OROOM(TROLL).EQ.R).OR.((OROOM(THIEF).EQ.R).AND.THFACT)
	IF(ENDGMF) INFEST=(R.EQ.MRG).OR.(R.EQ.MRGE).OR.(R.EQ.MRGW).OR.((R.EQ.INMIR).AND.(MLOC.EQ.MRG))
	RETURN
	END

# CEVAPP- CLOCK EVENT APPLICABLES
#
# DECLARATIONS
#
	SUBROUTINE CEVAPP(RI)
	IMPLICIT INTEGER (A-Z)
	INTEGER CNDTCK(10),LMPTCK(12)
	LOGICAL FINDXT,LIT,RMINFO,QOPEN,MOVETO
	LOGICAL F,QLEDGE,QVAIR,QHERE,PROB
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
	COMMON /STATE/ MOVES,DEATHS,RWSCOR,MXSCOR,MXLOAD,
		LTSHFT,BLOC,MUNGRM,HS,EGSCOR,EGMXSC
#
# ROOMS
#
	COMMON /ROOMS/ RLNT,RDESC2,RDESC1(215),REXIT(215),
		RACTIO(215),RVAL(215),RFLAG(215)
	INTEGER RRAND(215)
	EQUIVALENCE (RVAL,RRAND)
#
	COMMON /RFLAG/ RSEEN,RLIGHT,RLAND,RWATER,RAIR,
		RSACRD,RFILL,RMUNG,RBUCK,RHOUSE,RNWALL,REND
#
	COMMON /RINDEX/ WHOUS,LROOM,CELLA
	COMMON /RINDEX/ MTROL,MAZE1	
	COMMON /RINDEX/ MGRAT,MAZ15	
	COMMON /RINDEX/ FORE1,FORE3,CLEAR,RESER
	COMMON /RINDEX/ STREA,EGYPT,ECHOR
	COMMON /RINDEX/ TSHAF	
	COMMON /RINDEX/ BSHAF,MMACH,DOME,MTORC
	COMMON /RINDEX/ CAROU	
	COMMON /RINDEX/ RIDDL,LLD2,TEMP1,TEMP2,MAINT
	COMMON /RINDEX/ BLROO,TREAS,RIVR1,RIVR2,RIVR3,MCYCL
	COMMON /RINDEX/ RIVR4,RIVR5,FCHMP,FALLS,MBARR
	COMMON /RINDEX/ MRAIN,POG,VLBOT,VAIR1,VAIR2,VAIR3,VAIR4
	COMMON /RINDEX/ LEDG2,LEDG3,LEDG4,MSAFE,CAGER
	COMMON /RINDEX/ CAGED,TWELL,BWELL,ALICE,ALISM,ALITR
	COMMON /RINDEX/ MTREE,BKENT,BKVW,BKTWI,BKVAU,BKBOX
	COMMON /RINDEX/ CRYPT,TSTRS,MRANT,MREYE
	COMMON /RINDEX/ MRA,MRB,MRC,MRG,MRD,FDOOR
	COMMON /RINDEX/ MRAE,MRCE,MRCW,MRGE,MRGW,MRDW,INMIR
	COMMON /RINDEX/ SCORR,NCORR,PARAP,CELL,PCELL,NCELL
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
	COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
	COMMON /OINDEX/ WATER,ROPE,KNIFE,SWORD,LAMP,BLAMP,RUG
	COMMON /OINDEX/	LEAVE,TROLL,AXE
	COMMON /OINDEX/ RKNIF,KEYS,ICE,BAR
	COMMON /OINDEX/ COFFI,TORCH,TBASK,FBASK,IRBOX
	COMMON /OINDEX/ GHOST,TRUNK,BELL,BOOK,CANDL
	COMMON /OINDEX/ MATCH,TUBE,PUTTY,WRENC,SCREW,CYCLO,CHALI
	COMMON /OINDEX/ THIEF,STILL,WINDO,GRATE,DOOR
	COMMON /OINDEX/ HPOLE,LEAK,RBUTT,RAILI
	COMMON /OINDEX/ POT,STATU,IBOAT,DBOAT,PUMP,RBOAT
	COMMON /OINDEX/ STICK,BUOY,SHOVE,BALLO,RECEP,GUANO
	COMMON /OINDEX/ BROPE,HOOK1,HOOK2,SAFE,SSLOT,BRICK,FUSE
	COMMON /OINDEX/ GNOME,BLABE,DBALL,TOMB
	COMMON /OINDEX/ LCASE,CAGE,RCAGE,SPHER,SQBUT
	COMMON /OINDEX/ FLASK,POOL,SAFFR,BUCKE,ECAKE,ORICE,RDICE,BLICE
	COMMON /OINDEX/ ROBOT,FTREE,BILLS,PORTR,SCOL,ZGNOM
	COMMON /OINDEX/ EGG,BEGG,BAUBL,CANAR,BCANA
	COMMON /OINDEX/ YLWAL,RDWAL,PINDR,RBEAM
	COMMON /OINDEX/ ODOOR,QDOOR,CDOOR,NUM1,NUM8
	COMMON /OINDEX/ HANDS,WALL,LUNGS,SAILO,AVIAT,TEETH
	COMMON /OINDEX/ ITOBJ,EVERY,VALUA,OPLAY,WNORT,GWATE,MASTER
#
# CLOCK INTERRUPTS
#
	LOGICAL CFLAG
	COMMON /CEVENT/ CLNT,CTICK(25),CACTIO(25),CFLAG(25)
#
	COMMON /CINDEX/ CEVCUR,CEVMNT,CEVLNT,CEVMAT,CEVCND,
		CEVBAL,CEVBRN,CEVFUS,CEVLED,CEVSAF,CEVVLG,
		CEVGNO,CEVBUC,CEVSPH,CEVEGH,
			CEVFOR,CEVSCL,CEVZGI,CEVZGO,CEVSTE,
		CEVMRS,CEVPIN,CEVINQ,CEVFOL
#
# EXITS
#
	COMMON /CURXT/ XTYPE,XROOM1,XSTRNG,XACTIO,XOBJ
	EQUIVALENCE (XFLAG,XOBJ)
#
	COMMON /XSRCH/ XMIN,XMAX,XDOWN,XUP,
		XNORTH,XSOUTH,XENTER,XEXIT
#
# VILLAINS AND DEMONS
#
	LOGICAL THFFLG,SWDACT,THFACT
	COMMON /HACK/ THFPOS,THFFLG,THFACT,SWDACT,SWDSTA
#
# ADVENTURERS
#
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
		AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
#
	COMMON /AINDEX/ PLAYER,AROBOT,AMASTR
#
# FLAGS
#
	LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL FOLLWF,SPELLF,sprf
	COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
		DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
		MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
			EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
		GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
		GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
		MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
		follwf,spellf,sprf(6)
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL
#
# FUNCTIONS AND DATA
#
	QOPEN(R)=AND(OFLAG2(R),OPENBT).NE.0
	QLEDGE(R)=(R.EQ.LEDG2).OR.(R.EQ.LEDG3).OR.(R.EQ.LEDG4).OR.(R.EQ.VLBOT)
	QVAIR(R)=(R.EQ.VAIR1).OR.(R.EQ.VAIR2).OR.(R.EQ.VAIR3).OR.(R.EQ.VAIR4)
	DATA CNDTCK/50,20,10,5,0,156,156,156,157,0/
	DATA LMPTCK/50,30,20,10,4,0,154,154,154,154,155,0/

# CEVAPP, PAGE 2
#
	IF(RI.EQ.0) RETURN			#IGNORE DISABLED.
	GO TO (1000,2000,3000,4000,5000,6000,7000,8000,9000,10000,
		11000,12000,13000,14000,15000,16000,17000,18000,19000,
		20000,21000,22000,23000,24000),RI
	CALL BUG(3,RI)
#
# CEV1--	CURE CLOCK.  LET PLAYER SLOWLY RECOVER.
#
1000	ASTREN(PLAYER)=MIN0(0,ASTREN(PLAYER)+1)		#RECOVER.
	IF(ASTREN(PLAYER).GE.0) RETURN		#FULLY RECOVERED?
	CTICK(CEVCUR)=30			#NO, WAIT SOME MORE.
	RETURN
#
# CEV2--	MAINT-ROOM WITH LEAK.  RAISE THE WATER LEVEL.
#
2000	IF(HERE.EQ.MAINT) CALL RSPEAK(71+(RVMNT/2))	#DESCRIBE.
	RVMNT=RVMNT+1				#RAISE WATER LEVEL.
	IF(RVMNT.LE.16) RETURN			#IF NOT FULL, EXIT.
	CTICK(CEVMNT)=0				#FULL, DISABLE CLOCK.
	RFLAG(MAINT)=RFLAG(MAINT).OR.RMUNG	#MUNG ROOM.
	RRAND(MAINT)=80				#SAY IT IS FULL OF WATER.
	IF(HERE.EQ.MAINT) CALL JIGSUP(81)	#DROWN HIM IF PRESENT.
	RETURN
#
# CEV3--	LANTERN.  DESCRIBE GROWING DIMNESS.
#
3000	CALL LITINT(LAMP,ORLAMP,CEVLNT,LMPTCK,12)	#DO LIGHT INTERRUPT.
	RETURN
#
# CEV4--	MATCH.  OUT IT GOES.
#
4000	CALL RSPEAK(153)			#MATCH IS OUT.
	OFLAG1(MATCH)=AND(OFLAG1(MATCH),NOT(ONBT))
	RETURN
#
# CEV5--	CANDLE.  DESCRIBE GROWING DIMNESS.
#
5000	CALL LITINT(CANDL,ORCAND,CEVCND,CNDTCK,10)	#DO CANDLE INTERRUPT.
	RETURN

# CEVAPP, PAGE 3
#
# CEV6--	BALLOON
#
6000	CTICK(CEVBAL)=3				#RESCHEDULE INTERRUPT.
	F=AVEHIC(WINNER).EQ.BALLO		#SEE IF IN BALLOON.
	IF(BLOC.EQ.VLBOT) GO TO 6800		#AT BOTTOM?
	IF(QLEDGE(BLOC)) GO TO 6700		#ON LEDGE?
	IF(QOPEN(RECEP).AND.(BINFF.NE.0))
		GO TO 6500			#INFLATED AND RECEP OPEN?.
#
# BALLOON IS IN MIDAIR AND IS DEFLATED (OR HAS RECEPTACLE CLOSED).
# FALL TO NEXT ROOM.
#
	IF(BLOC.NE.VAIR1) GO TO 6300		#IN VAIR1?
	BLOC=VLBOT				#YES, NOW AT VLBOT.
	CALL NEWSTA(BALLO,0,BLOC,0,0)
	IF(F) GO TO 6200			#IN BALLOON?
	IF(QLEDGE(HERE)) CALL RSPEAK(530)	#ON LEDGE, DESCRIBE.
	RETURN
#
6200	F=MOVETO(BLOC,WINNER)			#MOVE HIM.
	IF(BINFF.EQ.0) GO TO 6250		#IN BALLOON.  INFLATED?
	CALL RSPEAK(531)			#YES, LANDED.
	F=RMINFO(.FALSE.)			#DESCRIBE.
	RETURN
#
6250	CALL NEWSTA(BALLO,532,0,0,0)		#NO, BALLOON DIES.
	CALL NEWSTA(DBALL,0,BLOC,0,0)		#INSERT DEAD BALLOON.
	AVEHIC(WINNER)=0			#NOT IN VEHICLE.
	CFLAG(CEVBAL)=.FALSE.			#DISABLE INTERRUPTS.
	CFLAG(CEVBRN)=.FALSE.
	BINFF=0
	BTIEF=0
	RETURN
#
6300	BLOC=BLOC-1				#NOT IN VAIR1, DESCEND.
	CALL NEWSTA(BALLO,0,BLOC,0,0)
	IF(F) GO TO 6400			#IS HE IN BALLOON?
	IF(QLEDGE(HERE)) CALL RSPEAK(533)	#IF ON LEDGE, DESCRIBE.
	RETURN
#
6400	F=MOVETO(BLOC,WINNER)			#IN BALLOON, MOVE HIM.
	CALL RSPEAK(534)			#DESCRIBE.
	F=RMINFO(.FALSE.)
	RETURN
#
# BALLOON IS IN MIDAIR AND IS INFLATED, UP-UP-AND-AWAY!
#
6500	IF(BLOC.NE.VAIR4) GO TO 6600		#AT VAIR4?
	CTICK(CEVBRN)=.FALSE.			#DISABLE INTERRUPTS.
	CTICK(CEVBAL)=.FALSE.
	BINFF=0
	BTIEF=0
	BLOC=VLBOT				#FALL TO BOTTOM.
	CALL NEWSTA(BALLO,0,0,0,0)		#GET RID OF BALLOON.
	CALL NEWSTA(DBALL,0,BLOC,0,0)		#SUBSTITUTE DEAD BALLOON.
	IF(F) GO TO 6550			#WAS HE IN IT?
	IF(QLEDGE(HERE)) CALL RSPEAK(535)	#IF HE CAN SEE, DESCRIBE.
	RETURN
#
6550	CALL JIGSUP(536)			#IN BALLOON AT CRASH, DIE.
	RETURN
#
6600	BLOC=BLOC+1				#NOT AT VAIR4, GO UP.
	CALL NEWSTA(BALLO,0,BLOC,0,0)
	IF(F) GO TO 6650			#IN BALLOON?
	IF(QLEDGE(HERE)) CALL RSPEAK(537)	#CAN HE SEE IT?
	RETURN
#
6650	F=MOVETO(BLOC,WINNER)			#MOVE PLAYER.
	CALL RSPEAK(538)			#DESCRIBE.
	F=RMINFO(.FALSE.)
	RETURN
#
# ON LEDGE, GOES TO MIDAIR ROOM WHETHER INFLATED OR NOT.
#
6700	BLOC=BLOC+(VAIR2-LEDG2)			#MOVE TO MIDAIR.
	CALL NEWSTA(BALLO,0,BLOC,0,0)
	IF(F) GO TO 6750			#IN BALLOON?
	IF(QLEDGE(HERE)) CALL RSPEAK(539)	#NO, STRANDED.
	CTICK(CEVVLG)=10			#MATERIALIZE GNOME.
	RETURN
#
6750	F=MOVETO(BLOC,WINNER)			#MOVE TO NEW ROOM.
	CALL RSPEAK(540)			#DESCRIBE.
	F=RMINFO(.FALSE.)
	RETURN
#
# AT BOTTOM, GO UP IF INFLATED, DO NOTHING IF DEFLATED.
#
6800	IF((BINFF.EQ.0).OR..NOT.QOPEN(RECEP)) RETURN
	BLOC=VAIR1				#INFLATED AND OPEN,
	CALL NEWSTA(BALLO,0,BLOC,0,0)		#GO UP TO VAIR1.
	IF(F) GO TO 6850			#IN BALLOON?
	IF(QLEDGE(HERE)) CALL RSPEAK(541)	#IF CAN SEE, DESCRIBE.
	RETURN
#
6850	F=MOVETO(BLOC,WINNER)			#MOVE PLAYER.
	CALL RSPEAK(542)
	F=RMINFO(.FALSE.)
	RETURN

# CEVAPP, PAGE 4
#
# CEV7--	BALLOON BURNUP
#
7000	DO I=1,OLNT {				#FIND BURNING OBJECT
	  IF((RECEP.EQ.OCAN(I)).AND.(AND(OFLAG1(I),FLAMBT).NE.0))
		GO TO 7200			#IN RECEPTACLE.
	  }
	CALL BUG(4,0)
#
7200	CALL NEWSTA(I,0,0,0,0)		#VANISH OBJECT.
	BINFF=0					#UNINFLATED.
	IF(HERE.EQ.BLOC) CALL RSPSUB(292,ODESC2(I))	#DESCRIBE.
	RETURN
#
# CEV8--	FUSE FUNCTION
#
8000	IF(OCAN(FUSE).NE.BRICK) GO TO 8500	#IGNITED BRICK?
	BR=OROOM(BRICK)				#GET BRICK ROOM.
	BC=OCAN(BRICK)				#GET CONTAINER.
	IF((BR.EQ.0).AND.(BC.NE.0)) BR=OROOM(BC)
	CALL NEWSTA(FUSE,0,0,0,0)		#KILL FUSE.
	CALL NEWSTA(BRICK,0,0,0,0)		#KILL BRICK.
	IF((BR.NE.0).AND.(BR.NE.HERE)) GO TO 8100	#BRICK ELSEWHERE?
#
	RFLAG(HERE)=RFLAG(HERE).OR.RMUNG	#BLEW SELF.
	RRAND(HERE)=114				#MUNG ROOM.
	CALL JIGSUP(150)			#DEAD.
	RETURN
#
8100	CALL RSPEAK(151)			#BOOM.
	MUNGRM=BR				#SAVE ROOM THAT BLEW.
	CTICK(CEVSAF)=5				#SET SAFE INTERRUPT.
	IF(BR.NE.MSAFE) GO TO 8200		#BLEW SAFE ROOM?
	IF(BC.NE.SSLOT) RETURN			#WAS BRICK IN SAFE?
	CALL NEWSTA(SSLOT,0,0,0,0)		#KILL SLOT.
	OFLAG2(SAFE)=OFLAG2(SAFE).OR.OPENBT	#OPEN SAFE.
	SAFEF=.TRUE.				#INDICATE SAFE BLOWN.
	RETURN
#
8200	DO I=1,OLNT {				#BLEW WRONG ROOM.
	  IF(QHERE(I,BR) .AND. (AND(OFLAG1(I),TAKEBT).NE.0))
		CALL NEWSTA(I,0,0,0,0)		#VANISH CONTENTS.
	  }
	IF(BR.NE.LROOM) RETURN			#BLEW LIVING ROOM?
	DO I=1,OLNT {
	  IF(OCAN(I).EQ.TCASE) CALL NEWSTA(I,0,0,0,0)	#KILL TROPHY CASE.
	  }
	RETURN
#
8500	IF(QHERE(FUSE,HERE).OR.(OADV(FUSE).EQ.WINNER))
		CALL RSPEAK(152)
	CALL NEWSTA(FUSE,0,0,0,0)		#KILL FUSE.
	RETURN

# CEVAPP, PAGE 5
#
# CEV9--	LEDGE MUNGE.
#
9000	RFLAG(LEDG4)=RFLAG(LEDG4).OR.RMUNG	#LEDGE COLLAPSES.
	RRAND(LEDG4)=109
	IF(HERE.EQ.LEDG4) GO TO 9100		#WAS HE THERE?
	CALL RSPEAK(110)			#NO, NARROW ESCAPE.
	RETURN
#
9100	IF(AVEHIC(WINNER).NE.0) GO TO 9200	#IN VEHICLE?
	CALL JIGSUP(111)			#NO, DEAD.
	RETURN
#
9200	IF(BTIEF.NE.0) GO TO 9300		#TIED TO LEDGE?
	CALL RSPEAK(112)			#NO, NO PLACE TO LAND.
	RETURN
#
9300	BLOC=VLBOT				#YES, CRASH BALLOON.
	CALL NEWSTA(BALLO,0,0,0,0)
	CALL NEWSTA(DBALL,0,BLOC,0,0)
	BTIEF=0
	BINFF=0
	CFLAG(CEVBAL)=.FALSE.
	CFLAG(CEVBRN)=.FALSE.
	CALL JIGSUP(113)			#DEAD
	RETURN
#
# CEV10--	SAFE MUNG.
#
10000	RFLAG(MUNGRM)=RFLAG(MUNGRM).OR.RMUNG	#MUNG TARGET.
	RRAND(MUNGRM)=114
	IF(HERE.EQ.MUNGRM) GO TO 10100		#IS HE PRESENT?
	CALL RSPEAK(115)			#LET HIM KNOW.
	IF(MUNGRM.EQ.MSAFE) CTICK(CEVLED)=8	#START LEDGE CLOCK.
	RETURN
#
10100	I=116					#HE'S DEAD,
	IF((RFLAG(HERE).AND.RHOUSE).NE.0) I=117	#ONE WAY OR ANOTHER.
	CALL JIGSUP(I)				#LET HIM KNOW.
	RETURN

# CEVAPP, PAGE 6
#
# CEV11--	VOLCANO GNOME
#
11000	IF(QLEDGE(HERE)) GO TO 11100		#IS HE ON LEDGE?
	CTICK(CEVVLG)=1				#NO, WAIT A WHILE.
	RETURN
#
11100	CALL NEWSTA(GNOME,118,HERE,0,0)		#YES, MATERIALIZE GNOME.
	RETURN
#
# CEV12--	VOLCANO GNOME DISAPPEARS
#
12000	CALL NEWSTA(GNOME,149,0,0,0)		#DISAPPEAR THE GNOME.
	RETURN
#
# CEV13--	BUCKET.
#
13000	IF(OCAN(WATER).EQ.BUCKE)
		CALL NEWSTA(WATER,0,0,0,0)	#WATER LEAKS OUT.
	RETURN
#
# CEV14--	SPHERE.  IF EXPIRES, HE'S TRAPPED.
#
14000	RFLAG(CAGER)=RFLAG(CAGER).OR.RMUNG	#MUNG ROOM.
	RRAND(CAGER)=147
	CALL JIGSUP(148)			#MUNG PLAYER.
	RETURN
#
# CEV15--	END GAME HERALD.
#
15000	ENDGMF=.TRUE.				#WE'RE IN ENDGAME.
	CALL RSPEAK(119)			#INFORM OF ENDGAME.
	RETURN

# CEVAPP, PAGE 7
#
# CEV16--	FOREST MURMURS
#
16000	CFLAG(CEVFOR)=(HERE.EQ.MTREE).OR.((HERE.GE.FORE1).AND.(HERE.LT.CLEAR))
	IF(CFLAG(CEVFOR).AND.PROB(10,10)) CALL RSPEAK(635)
	RETURN
#
# CEV17--	SCOL ALARM
#
17000	IF(HERE.EQ.BKTWI) CFLAG(CEVZGI)=.TRUE.	#IF IN TWI, GNOME.
	IF(HERE.EQ.BKVAU) CALL JIGSUP(636)	#IF IN VAU, DEAD.
	RETURN
#
# CEV18--	ENTER GNOME OF ZURICH
#
18000	CFLAG(CEVZGO)=.TRUE.			#EXITS, TOO.
	CALL NEWSTA(ZGNOM,0,BKTWI,0,0)		#PLACE IN TWI.
	IF(HERE.EQ.BKTWI) CALL RSPEAK(637)	#ANNOUNCE.
	RETURN
#
# CEV19--	EXIT GNOME
#
19000	CALL NEWSTA(ZGNOM,0,0,0,0)		#VANISH.
	IF(HERE.EQ.BKTWI) CALL RSPEAK(638)	#ANNOUNCE.
	RETURN

# CEVAPP, PAGE 8
#
# CEV20--	START OF ENDGAME
#
20000	IF(SPELLF) GO TO 20200			#SPELL HIS WAY IN?
	IF(HERE.NE.CRYPT) RETURN		#NO, STILL IN TOMB?
	IF(.NOT.LIT(HERE)) GO TO 20100		#LIGHTS OFF?
	CTICK(CEVSTE)=3				#RESCHEDULE.
	RETURN
#
20100	CALL RSPEAK(727)			#ANNOUNCE.
20200	DO I=1,OLNT {				#STRIP HIM OF OBJS.
	  CALL NEWSTA(I,0,OROOM(I),OCAN(I),0)
	  }
	CALL NEWSTA(LAMP,0,0,0,PLAYER)		#GIVE HIM LAMP.
	CALL NEWSTA(SWORD,0,0,0,PLAYER)		#GIVE HIM SWORD.
#
	OFLAG1(LAMP)=AND((OFLAG1(LAMP).OR.LITEBT),NOT(ONBT))
	OFLAG2(LAMP)=OR(OFLAG2(LAMP),TCHBT)
	CFLAG(CEVLNT)=.FALSE.			#LAMP IS GOOD AS NEW.
	CTICK(CEVLNT)=350
	ORLAMP=0
	OFLAG2(SWORD)=OR(OFLAG2(SWORD),TCHBT)	#RECREATE SWORD.
	SWDACT=.TRUE.
	SWDSTA=0
#
	THFACT=.FALSE.				#THIEF GONE.
	ENDGMF=.TRUE.				#ENDGAME RUNNING.
	CFLAG(CEVMAT)=.FALSE.			#MATCHES GONE,
	CFLAG(CEVCND)=.FALSE.			#CANDLES GONE.
#
	CALL SCRUPD(RVAL(CRYPT))		#SCORE CRYPT,
	RVAL(CRYPT)=0				#BUT ONLY ONCE.
	F=MOVETO(TSTRS,WINNER)			#TO TOP OF STAIRS,
	F=RMINFO(.TRUE.)			#AND DESCRIBE.
	RETURN					#BAM!
#
# CEV21--	MIRROR CLOSES.
#
21000	MRPSHF=.FALSE.			#BUTTON IS OUT.
	MROPNF=.FALSE.				#MIRROR IS CLOSED.
	IF(HERE.EQ.MRANT) CALL RSPEAK(728)	#DESCRIBE BUTTON.
	IF((HERE.EQ.INMIR).OR.(MRHERE(HERE).EQ.1))
		CALL RSPEAK(729)		#DESCRIBE MIRROR.
	RETURN

# CEVAPP, PAGE 9
#
# CEV22--	DOOR CLOSES.
#
22000	IF(WDOPNF) CALL RSPEAK(730)		#DESCRIBE.
	WDOPNF=.FALSE.				#CLOSED.
	RETURN
#
# CEV23--	INQUISITOR'S QUESTION
#
23000	IF(AROOM(PLAYER).NE.FDOOR) RETURN	#IF PLAYER LEFT, DIE.
	CALL RSPEAK(769)
	CALL RSPEAK(770+QUESNO)
	CTICK(CEVINQ)=2
	RETURN
#
# CEV24--	MASTER FOLLOWS
#
24000	IF(AROOM(AMASTR).EQ.HERE) RETURN	#NO MOVEMENT, DONE.
	IF((HERE.NE.CELL).AND.(HERE.NE.PCELL)) GO TO 24100
	IF(FOLLWF) CALL RSPEAK(811)		#WONT GO TO CELLS.
	FOLLWF=.FALSE.
	RETURN
#
24100	FOLLWF=.TRUE.				#FOLLOWING.
	I=812					#ASSUME CATCHES UP.
	DO J=XMIN,XMAX,XMIN {
	  IF(FINDXT(J,AROOM(AMASTR)).AND.(XROOM1.EQ.HERE))
		I=813				#ASSUME FOLLOWS.
	  }
	CALL RSPEAK(I)
	CALL NEWSTA(MASTER,0,HERE,0,0)		#MOVE MASTER OBJECT.
	AROOM(AMASTR)=HERE		#MOVE MASTER PLAYER.
	RETURN
#
	END

# LITINT-	LIGHT INTERRUPT PROCESSOR
#
# DECLARATIONS
#
	SUBROUTINE LITINT(OBJ,CTR,CEV,TICKS,TICKLN)
	IMPLICIT INTEGER (A-Z)
	INTEGER TICKS(TICKLN)
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
# CLOCK INTERRUPTS
#
	LOGICAL CFLAG
	COMMON /CEVENT/ CLNT,CTICK(25),CACTIO(25),CFLAG(25)
#
	CTR=CTR+1				#ADVANCE STATE CNTR.
	CTICK(CEV)=TICKS(CTR)		#RESET INTERRUPT.
	IF(CTICK(CEV).NE.0) GO TO 100		#EXPIRED?
	OFLAG1(OBJ)=AND(OFLAG1(OBJ),NOT(LITEBT+FLAMBT+ONBT))
	IF((OROOM(OBJ).EQ.HERE).OR.(OADV(OBJ).EQ.WINNER))
		CALL RSPSUB(293,ODESC2(OBJ))
	RETURN
#
100	IF((OROOM(OBJ).EQ.HERE).OR.(OADV(OBJ).EQ.WINNER))
		CALL RSPEAK(TICKS(CTR+(TICKLN/2)))
	RETURN
#
	END

# RAPPL1- SPECIAL PURPOSE ROOM ROUTINES, PART 1
#
# DECLARATIONS
#
	LOGICAL FUNCTION RAPPL1(RI)
	IMPLICIT INTEGER (A-Z)
	LOGICAL QOPEN,QON,QHERE,PROB,F
	LOGICAL MOVETO,LIT
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
	COMMON /STATE/ MOVES,DEATHS,RWSCOR,MXSCOR,MXLOAD,
		LTSHFT,BLOC,MUNGRM,HS,EGSCOR,EGMXSC
#
# SCREEN OF LIGHT
#
	COMMON /SCREEN/ FROMDR,SCOLRM,SCOLAC
	COMMON /SCREEN/ SCOLDR(8),SCOLWL(12)
#
# MISCELLANEOUS VARIABLES
#
	COMMON /BATS/ BATDRP(9)
#
# ROOMS
#
	COMMON /ROOMS/ RLNT,RDESC2,RDESC1(215),REXIT(215),
		RACTIO(215),RVAL(215),RFLAG(215)
	INTEGER RRAND(215)
	EQUIVALENCE (RVAL,RRAND)
#
	COMMON /RFLAG/ RSEEN,RLIGHT,RLAND,RWATER,RAIR,
		RSACRD,RFILL,RMUNG,RBUCK,RHOUSE,RNWALL,REND
#
	COMMON /RINDEX/ WHOUS,LROOM,CELLA
	COMMON /RINDEX/ MTROL,MAZE1	
	COMMON /RINDEX/ MGRAT,MAZ15	
	COMMON /RINDEX/ FORE1,FORE3,CLEAR,RESER
	COMMON /RINDEX/ STREA,EGYPT,ECHOR
	COMMON /RINDEX/ TSHAF	
	COMMON /RINDEX/ BSHAF,MMACH,DOME,MTORC
	COMMON /RINDEX/ CAROU	
	COMMON /RINDEX/ RIDDL,LLD2,TEMP1,TEMP2,MAINT
	COMMON /RINDEX/ BLROO,TREAS,RIVR1,RIVR2,RIVR3,MCYCL
	COMMON /RINDEX/ RIVR4,RIVR5,FCHMP,FALLS,MBARR
	COMMON /RINDEX/ MRAIN,POG,VLBOT,VAIR1,VAIR2,VAIR3,VAIR4
	COMMON /RINDEX/ LEDG2,LEDG3,LEDG4,MSAFE,CAGER
	COMMON /RINDEX/ CAGED,TWELL,BWELL,ALICE,ALISM,ALITR
	COMMON /RINDEX/ MTREE,BKENT,BKVW,BKTWI,BKVAU,BKBOX
	COMMON /RINDEX/ CRYPT,TSTRS,MRANT,MREYE
	COMMON /RINDEX/ MRA,MRB,MRC,MRG,MRD,FDOOR
	COMMON /RINDEX/ MRAE,MRCE,MRCW,MRGE,MRGW,MRDW,INMIR
	COMMON /RINDEX/ SCORR,NCORR,PARAP,CELL,PCELL,NCELL
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
	COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
	COMMON /OINDEX/ WATER,ROPE,KNIFE,SWORD,LAMP,BLAMP,RUG
	COMMON /OINDEX/	LEAVE,TROLL,AXE
	COMMON /OINDEX/ RKNIF,KEYS,ICE,BAR
	COMMON /OINDEX/ COFFI,TORCH,TBASK,FBASK,IRBOX
	COMMON /OINDEX/ GHOST,TRUNK,BELL,BOOK,CANDL
	COMMON /OINDEX/ MATCH,TUBE,PUTTY,WRENC,SCREW,CYCLO,CHALI
	COMMON /OINDEX/ THIEF,STILL,WINDO,GRATE,DOOR
	COMMON /OINDEX/ HPOLE,LEAK,RBUTT,RAILI
	COMMON /OINDEX/ POT,STATU,IBOAT,DBOAT,PUMP,RBOAT
	COMMON /OINDEX/ STICK,BUOY,SHOVE,BALLO,RECEP,GUANO
	COMMON /OINDEX/ BROPE,HOOK1,HOOK2,SAFE,SSLOT,BRICK,FUSE
	COMMON /OINDEX/ GNOME,BLABE,DBALL,TOMB
	COMMON /OINDEX/ LCASE,CAGE,RCAGE,SPHER,SQBUT
	COMMON /OINDEX/ FLASK,POOL,SAFFR,BUCKE,ECAKE,ORICE,RDICE,BLICE
	COMMON /OINDEX/ ROBOT,FTREE,BILLS,PORTR,SCOL,ZGNOM
	COMMON /OINDEX/ EGG,BEGG,BAUBL,CANAR,BCANA
	COMMON /OINDEX/ YLWAL,RDWAL,PINDR,RBEAM
	COMMON /OINDEX/ ODOOR,QDOOR,CDOOR,NUM1,NUM8
	COMMON /OINDEX/ HANDS,WALL,LUNGS,SAILO,AVIAT,TEETH
	COMMON /OINDEX/ ITOBJ,EVERY,VALUA,OPLAY,WNORT,GWATE,MASTER
#
# CLOCK INTERRUPTS
#
	LOGICAL CFLAG
	COMMON /CEVENT/ CLNT,CTICK(25),CACTIO(25),CFLAG(25)
#
	COMMON /CINDEX/ CEVCUR,CEVMNT,CEVLNT,CEVMAT,CEVCND,
		CEVBAL,CEVBRN,CEVFUS,CEVLED,CEVSAF,CEVVLG,
		CEVGNO,CEVBUC,CEVSPH,CEVEGH,
			CEVFOR,CEVSCL,CEVZGI,CEVZGO,CEVSTE,
		CEVMRS,CEVPIN,CEVINQ,CEVFOL

#
	LOGICAL THFFLG,THFACT,SWDACT
	COMMON /HACK/ THFPOS,THFFLG,THFACT,SWDACT
#
# ADVENTURERS
#
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
		AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
#
	COMMON /AINDEX/ PLAYER,AROBOT,AMASTR
#
# VERBS
#
	COMMON /VINDEX/ CINTW,DEADXW,FRSTQW,INXW,OUTXW
	COMMON /VINDEX/ WALKIW,FIGHTW,FOOW
	COMMON /VINDEX/ MELTW,READW,INFLAW,DEFLAW,ALARMW,EXORCW
	COMMON /VINDEX/ PLUGW,KICKW,WAVEW,RAISEW,LOWERW,RUBW
	COMMON /VINDEX/ PUSHW,UNTIEW,TIEW,TIEUPW,TURNW,BREATW
	COMMON /VINDEX/ KNOCKW,LOOKW,EXAMIW,SHAKEW,MOVEW,TRNONW,TRNOFW
	COMMON /VINDEX/ OPENW,CLOSEW,FINDW,WAITW,SPINW,BOARDW,UNBOAW,TAKEW
	COMMON /VINDEX/ INVENW,FILLW,EATW,DRINKW,BURNW
	COMMON /VINDEX/ MUNGW,KILLW,ATTACW,SWINGW
	COMMON /VINDEX/ WALKW,TELLW,PUTW,DROPW,GIVEW,POURW,THROWW
	COMMON /VINDEX/ DIGW,LEAPW,STAYW,FOLLOW
	COMMON /VINDEX/ HELLOW,LOOKIW,LOOKUW,PUMPW,WINDW
	COMMON /VINDEX/ CLMBW,CLMBUW,CLMBDW,TRNTOW
#
# FLAGS
#
	LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL FOLLWF,SPELLF,sprf
	COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
		DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
		MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
			EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
		GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
		GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
		MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
		follwf,spellf,sprf(6)
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL
#
# FUNCTIONS AND DATA
#
	QOPEN(R)=AND(OFLAG2(R),OPENBT).NE.0
	QON(R)=AND(OFLAG1(R),ONBT).NE.0

# RAPPL1, PAGE 2
#
	RAPPL1=.TRUE.				#USUALLY IGNORED.
	IF(RI.EQ.0) RETURN			#RETURN IF NAUGHT.
#						#SET TO FALSE FOR
#						#NEW DESC NEEDED.
	GO TO (1000,2000,3000,4000,5000,6000,7000,8000,9000,10000,
		11000,12000,13000,14000,15000,16000,17000,18000,19000,20000,
		21000,22000,23000,24000,25000,26000,27000,28000,29000,30000,
		 31000,32000,33000,34000,35000,36000,37000),RI
	CALL BUG(1,RI)
#
# R1--	EAST OF HOUSE.  DESCRIPTION DEPENDS ON STATE OF WINDOW
#
1000	IF(PRSA.NE.LOOKW) RETURN		#LOOK?
	I=13					#ASSUME CLOSED.
	IF(QOPEN(WINDO)) I=12			#IF OPEN, AJAR.
	CALL RSPSUB(11,I)			#DESCRIBE.
	RETURN
#
# R2--	KITCHEN.  SAME VIEW FROM INSIDE.
#
2000	IF(PRSA.NE.LOOKW) RETURN		#LOOK?
	I=13					#ASSUME CLOSED.
	IF(QOPEN(WINDO)) I=12			#IF OPEN, AJAR.
	CALL RSPSUB(14,I)			#DESCRIBE.
	RETURN
#
# R3--	LIVING ROOM.  DESCRIPTION DEPENDS ON MAGICF (STATE OF
#	DOOR TO CYCLOPS ROOM), RUG (MOVED OR NOT), DOOR (OPEN OR CLOSED)
#
3000	IF(PRSA.NE.LOOKW) GO TO 3500		#LOOK?
	I=15					#ASSUME NO HOLE.
	IF(MAGICF) I=16				#IF MAGICF, CYCLOPS HOLE.
	CALL RSPEAK(I)				#DESCRIBE.
	I=17+ORRUG				#ASSUME INITIAL STATE.
	IF(QOPEN(DOOR)) I=I+2			#DOOR OPEN?
	CALL RSPEAK(I)				#DESCRIBE.
	RETURN
#
#	NOT A LOOK WORD.  REEVALUATE TROPHY CASE.
#
3500	IF((PRSA.NE.TAKEW).AND.((PRSA.NE.PUTW).OR.(PRSI.NE.TCASE)))
		RETURN				#IF NOT TAKE OR PUT.
	ASCORE(WINNER)=RWSCOR			#SCORE TROPHY CASE.
	DO I=1,OLNT {				#RETAIN RAW SCORE AS WELL.
	  J=I					#FIND OUT IF IN CASE.
3550	  J=OCAN(J)				#TRACE OWNERSHIP.
	  IF(J.EQ.0) NEXT
	  IF(J.NE.TCASE) GO TO 3550		#DO ALL LEVELS.
	  ASCORE(WINNER)=ASCORE(WINNER)+OTVAL(I)
	  }
	CALL SCRUPD(0)				#SEE IF ENDGAME TRIG.
	RETURN

# RAPPL1, PAGE 3
#
# R4--	CELLAR.  SHUT DOOR AND BAR IT IF HE JUST WALKED IN.
#
4000	IF(PRSA.NE.LOOKW) GO TO 4500		#LOOK?
	CALL RSPEAK(21)				#DESCRIBE CELLAR.
	RETURN
#
4500	IF(PRSA.NE.WALKIW) RETURN		#WALKIN?
	IF(AND(OFLAG2(DOOR),(OPENBT+TCHBT)).NE.OPENBT) RETURN
	OFLAG2(DOOR)=AND(OR(OFLAG2(DOOR),TCHBT),NOT(OPENBT))
	CALL RSPEAK(22)				#SLAM AND BOLT DOOR.
	RETURN
#
# R5--	MAZE11.  DESCRIBE STATE OF GRATING.
#
5000	IF(PRSA.NE.LOOKW) RETURN		#LOOK?
	CALL RSPEAK(23)				#DESCRIBE.
	I=24					#ASSUME LOCKED.
	IF(GRUNLF) I=26				#UNLOCKED?
	IF(QOPEN(GRATE)) I=25			#OPEN?
	CALL RSPEAK(I)				#DESCRIBE GRATE.
	RETURN
#
# R6--	CLEARING.  DESCRIBE CLEARING, MOVE LEAVES.
#
6000	IF(PRSA.NE.LOOKW) GO TO 6500		#LOOK?
	CALL RSPEAK(27)				#DESCRIBE.
	IF(RVCLR.EQ.0) RETURN			#LEAVES MOVED?
	I=28					#YES, ASSUME GRATE CLOSED.
	IF(QOPEN(GRATE)) I=29			#OPEN?
	CALL RSPEAK(I)				#DESCRIBE GRATE.
	RETURN
#
6500	IF((RVCLR.NE.0).OR.(QHERE(LEAVE,CLEAR).AND.
		((PRSA.NE.MOVEW).OR.(PRSO.NE.LEAVE)))) RETURN
	CALL RSPEAK(30)				#MOVE LEAVES, REVEAL GRATE.
	RVCLR=1					#INDICATE LEAVES MOVED.
	RETURN

# RAPPL1, PAGE 4
#
# R7--	RESERVOIR SOUTH.  DESCRIPTION DEPENDS ON LOW TIDE FLAG.
#
7000	IF(PRSA.NE.LOOKW) RETURN		#LOOK?
	I=31					#ASSUME FULL.
	IF(LWTIDF) I=32				#IF LOW TIDE, EMPTY.
	CALL RSPEAK(I)				#DESCRIBE.
	CALL RSPEAK(33)				#DESCRIBE EXITS.
	RETURN
#
# R8--	RESERVOIR.  STATE DEPENDS ON LOW TIDE FLAG.
#
8000	IF(PRSA.NE.LOOKW) RETURN		#LOOK?
	I=34					#ASSUME FULL.
	IF(LWTIDF) I=35				#IF LOW TIDE, EMTPY.
	CALL RSPEAK(I)				#DESCRIBE.
	RETURN
#
# R9--	RESERVOIR NORTH.  ALSO DEPENDS ON LOW TIDE FLAG.
#
9000	IF(PRSA.NE.LOOKW) RETURN		#LOOK?
	I=36					#YOU GET THE IDEA.
	IF(LWTIDF) I=37
	CALL RSPEAK(I)
	CALL RSPEAK(38)
	RETURN
#
# R10--	GLACIER ROOM.  STATE DEPENDS ON MELTED, VANISHED FLAGS.
#
10000	IF(PRSA.NE.LOOKW) RETURN		#LOOK?
	CALL RSPEAK(39)				#BASIC DESCRIPTION.
	I=0					#ASSUME NO CHANGES.
	IF(GLACMF) I=40				#PARTIAL MELT?
	IF(GLACRF) I=41				#COMPLETE MELT?
	CALL RSPEAK(I)				#DESCRIBE.
	RETURN
#
# R11--	FOREST ROOM
#
11000	IF(PRSA.EQ.WALKIW) CFLAG(CEVFOR)=.TRUE.	#IF WALK IN, BIRDIE.
	RETURN
#
# R12--	MIRROR ROOM.  STATE DEPENDS ON MIRROR INTACT.
#
12000	IF(PRSA.NE.LOOKW) RETURN		#LOOK?
	CALL RSPEAK(42)				#DESCRIBE.
	IF(MIRRMF) CALL RSPEAK(43)		#IF BROKEN, NASTY REMARK.
	RETURN

# RAPPL1, PAGE 5
#
# R13--	CAVE2 ROOM.  BLOW OUT CANDLES WITH 50% PROBABILITY.
#
13000	IF(PRSA.NE.WALKIW) RETURN		#WALKIN?
	IF(PROB(50,50).OR.(OADV(CANDL).NE.WINNER).OR.
		.NOT.QON(CANDL)) RETURN		#BLOW EM OUT?
	OFLAG1(CANDL)=AND(OFLAG1(CANDL),NOT(ONBT))	#YES.
	CALL RSPEAK(47)				#TELL OF WINDS.
	CFLAG(CEVCND)=.FALSE.			#HALT CANDLE COUNTDOWN.
	RETURN
#
# R14--	BOOM ROOM.  BLOW HIM UP IF CARRYING FLAMING OBJECT.
#
14000	J=ODESC2(CANDL)				#ASSUME CANDLE.
	IF((OADV(CANDL).EQ.WINNER).AND.QON(CANDL)) GO TO 14100
	J=ODESC2(TORCH)				#ASSUME TORCH.
	IF((OADV(TORCH).EQ.WINNER).AND.QON(TORCH)) GO TO 14100
	J=ODESC2(MATCH)
	IF((OADV(MATCH).EQ.WINNER).AND.QON(MATCH)) GO TO 14100
	RETURN					#SAFE
#
14100	IF(PRSA.NE.TRNONW) GO TO 14200		#TURN ON?
	CALL RSPSUB(294,J)			#BOOM!
	CALL JIGSUP(44)
	RETURN
#
14200	IF(PRSA.NE.WALKIW) RETURN		#WALKIN?
	CALL RSPSUB(295,J)			#BOOM!
	CALL JIGSUP(44)
	RETURN
#
# R15--	NO-OBJS.  SEE IF EMPTY HANDED, SCORE LIGHT SHAFT.
#
15000	EMPTHF=.TRUE.				#ASSUME TRUE.
	DO I=1,OLNT {				#SEE IF CARRYING.
	  IF(OADV(I).EQ.WINNER) EMPTHF=.FALSE.
	  }
#
	IF((HERE.NE.BSHAF).OR.(.NOT.LIT(HERE))) RETURN
	CALL SCRUPD(LTSHFT)			#SCORE LIGHT SHAFT.
	LTSHFT=0				#NEVER AGAIN.
	RETURN

# RAPPL1, PAGE 6
#
# R16--	MACHINE ROOM.  DESCRIBE MACHINE.
#
16000	IF(PRSA.NE.LOOKW) RETURN		#LOOK?
	I=46					#ASSUME LID CLOSED.
	IF(QOPEN(MACHI)) I=12			#IF OPEN, OPEN.
	CALL RSPSUB(45,I)			#DESCRIBE.
	RETURN
#
# R17--	BAT ROOM.  UNLESS CARRYING GARLIC, FLY AWAY WITH ME...
#
17000	IF(PRSA.NE.LOOKW) GO TO 17500		#LOOK?
	CALL RSPEAK(48)				#DESCRIBE ROOM.
	IF(OADV(GARLI).EQ.WINNER) CALL RSPEAK(49)	#BAT HOLDS NOSE.
	RETURN
#
17500	IF((PRSA.NE.WALKIW).OR.(OADV(GARLI).EQ.WINNER)) RETURN
	CALL RSPEAK(50)				#TIME TO FLY, JACK.
	F=MOVETO(BATDRP(RND(9)+1),WINNER)	#SELECT RANDOM DEST.
	RAPPL1=.FALSE.				#INDICATE NEW DESC NEEDED.
	RETURN
#
# R18--	DOME ROOM.  STATE DEPENDS ON WHETHER ROPE TIED TO RAILING.
#
18000	IF(PRSA.NE.LOOKW) GO TO 18500		#LOOK?
	CALL RSPEAK(51)				#DESCRIBE.
	IF(DOMEF) CALL RSPEAK(52)		#IF ROPE, DESCRIBE.
	RETURN
#
18500	IF(PRSA.EQ.LEAPW) CALL JIGSUP(53)	#DID HE JUMP???
	RETURN
#
# R19--	TORCH ROOM.  ALSO DEPENDS ON WHETHER ROPE TIED TO RAILING.
#
19000	IF(PRSA.NE.LOOKW) RETURN		#LOOK?
	CALL RSPEAK(54)				#DESCRIBE.
	IF(DOMEF) CALL RSPEAK(55)		#IF ROPE, DESCRIBE.
	RETURN
#
# R20--	CAROUSEL ROOM.  SPIN HIM OR KILL HIM.
#
20000	IF(PRSA.NE.LOOKW) GO TO 20500		#LOOK?
	CALL RSPEAK(56)				#DESCRIBE.
	IF(.NOT.CAROFF) CALL RSPEAK(57)		#IF NOT FLIPPED, SPIN.
	RETURN
#
20500	IF((PRSA.EQ.WALKIW).AND.CAROZF) CALL JIGSUP(58)	#WALKED IN.
	RETURN

# RAPPL1, PAGE 7
#
# R21--	LLD ROOM.  HANDLE EXORCISE, DESCRIPTIONS.
#
21000	IF(PRSA.NE.LOOKW) GO TO 21500		#LOOK?
	CALL RSPEAK(59)				#DESCRIBE.
	IF(.NOT.LLDF) CALL RSPEAK(60)		#IF NOT VANISHED, GHOSTS.
	RETURN
#
21500	IF(PRSA.NE.EXORCW) RETURN		#EXORCISE?
	IF((OADV(BELL).EQ.WINNER).AND.(OADV(BOOK).EQ.WINNER).AND.
		(OADV(CANDL).EQ.WINNER).AND.QON(CANDL)) GO TO 21600
	CALL RSPEAK(62)				#NOT EQUIPPED.
	RETURN
#
21600	IF(QHERE(GHOST,HERE)) GO TO 21700	#GHOST HERE?
	CALL JIGSUP(61)				#NOPE, EXORCISE YOU.
	RETURN
#
21700	CALL NEWSTA(GHOST,63,0,0,0)		#VANISH GHOST.
	LLDF=.TRUE.				#OPEN GATE.
	RETURN
#
# R22--	LLD2-ROOM.  IS HIS HEAD ON A POLE?
#
22000	IF(PRSA.NE.LOOKW) RETURN		#LOOK?
	CALL RSPEAK(64)				#DESCRIBE.
	IF(ONPOLF) CALL RSPEAK(65)		#ON POLE?
	RETURN
#
# R23--	DAM ROOM.  DESCRIBE RESERVOIR, PANEL.
#
23000	IF(PRSA.NE.LOOKW) RETURN		#LOOK?
	CALL RSPEAK(66)				#DESCRIBE.
	I=67
	IF(LWTIDF) I=68
	CALL RSPEAK(I)				#DESCRIBE RESERVOIR.
	CALL RSPEAK(69)				#DESCRIBE PANEL.
	IF(GATEF) CALL RSPEAK(70)		#BUBBLE IS GLOWING.
	RETURN
#
# R24--	TREE ROOM
#
24000	IF(PRSA.NE.LOOKW) RETURN		#LOOK?
	CALL RSPEAK(660)			#DESCRIBE.
	I=661					#SET FLAG FOR BELOW.
	DO J=1,OLNT {				#DESCRIBE OBJ IN FORE3.
	  IF(.NOT.QHERE(J,FORE3).OR.(J.EQ.FTREE)) NEXT
	  CALL RSPEAK(I)			#SET STAGE,
	  I=0
	  CALL RSPSUB(502,ODESC2(J))		#DESCRIBE.
	  }
	RETURN

# RAPPL1, PAGE 8
#
# R25--	CYCLOPS-ROOM.  DEPENDS ON CYCLOPS STATE, ASLEEP FLAG, MAGIC FLAG.
#
25000	IF(PRSA.NE.LOOKW) RETURN		#LOOK?
	CALL RSPEAK(606)			#DESCRIBE.
	I=607					#ASSUME BASIC STATE.
	IF(RVCYC.GT.0) I=608			#>0?  HUNGRY.
	IF(RVCYC.LT.0) I=609			#<0?  THIRSTY.
	IF(CYCLOF) I=610			#ASLEEP?
	IF(MAGICF) I=611			#GONE?
	CALL RSPEAK(I)				#DESCRIBE.
	IF(.NOT.CYCLOF .AND.(RVCYC.NE.0))
		CALL RSPEAK(193+IABS(RVCYC))	#CYCLOPS IS ANNOYED.
	RETURN
#
# R26--	BANK BOX ROOM.
#
26000	IF(PRSA.NE.WALKIW) RETURN		#SURPRISE HIM.
	DO I=1,8,2 {				#SCOLRM DEPENDS ON
	  IF(FROMDR.EQ.SCOLDR(I)) SCOLRM=SCOLDR(I+1)
	  }					#ENTRY DIRECTION.
	RETURN
#
# R27--	TREASURE ROOM.
#
27000	IF((PRSA.NE.WALKIW).OR. .NOT.THFACT)
		RETURN				#WALKIN, THIEF ACTIVE?
	IF(OROOM(THIEF).NE.HERE)
		CALL NEWSTA(THIEF,82,HERE,0,0)	#NO, MATERIALIZE HIM.
	THFPOS=HERE				#RESET SEARCH PATTERN.
	OFLAG2(THIEF)=OFLAG2(THIEF).OR.FITEBT	#HE'S ANGRY.
	IF(OROOM(CHALI).EQ.HERE)
		OFLAG1(CHALI)=AND(OFLAG1(CHALI),NOT(TAKEBT))
#
#	VANISH EVERYTHING IN ROOM
#
	J=0					#ASSUME NOTHING TO VANISH.
	DO I=1,OLNT {
	  IF((I.EQ.CHALI).OR.(I.EQ.THIEF).OR..NOT.QHERE(I,HERE))
		NEXT				#HERE?
	  J=83					#FLAG BYEBYE.
	  OFLAG1(I)=AND(OFLAG1(I),NOT(VISIBT))	#AWAY IT GOES.
	  }
	CALL RSPEAK(J)				#DESCRIBE.
	RETURN
#
# R28--	CLIFF FUNCTION.  SEE IF CARRYING INFLATED BOAT.
#
28000	DEFLAF=OADV(RBOAT).NE.WINNER		#TRUE IF NOT CARRYING.
	RETURN

# RAPPL1, PAGE 9
#
# R29--	RIVR4 ROOM.  PLAY WITH BUOY.
#
29000	IF(.NOT.BUOYF.OR.(OADV(BUOY).NE.WINNER)) RETURN
	CALL RSPEAK(84)				#GIVE HINT,
	BUOYF=.FALSE.				#THEN DISABLE.
	RETURN
#
# R30--	OVERFALLS.  DOOM.
#
30000	IF(PRSA.NE.LOOKW) CALL JIGSUP(85)	#OVER YOU GO.
	RETURN
#
# R31--	BEACH ROOM.  DIG A HOLE.
#
31000	IF((PRSA.NE.DIGW).OR.(PRSO.NE.SHOVE)) RETURN
	RVSND=RVSND+1				#INCREMENT DIG STATE.
	GO TO (31100,31100,31100,31400,31500),RVSND	#PROCESS STATE.
	CALL BUG(2,RVSND)
#
31100	CALL RSPEAK(85+RVSND)			#1-3... DISCOURAGE HIM.
	RETURN
#
31400	I=89					#ASSUME DISCOVERY.
	IF(AND(OFLAG1(STATU),VISIBT).NE.0) I=88	#ALREADY DONE.
	CALL RSPEAK(I)
	OFLAG1(STATU)=OR(OFLAG1(STATU),VISIBT)	#MATERIALIZE STATUE.
	RETURN
#
31500	RVSND=0					#5... SAND COLLAPSES
	CALL JIGSUP(90)				#AND SO DOES HE.
	RETURN
#
# R32--	TCAVE ROOM.  DIG A HOLE IN GUANO.
#
32000	IF((PRSA.NE.DIGW).OR.(PRSO.NE.SHOVE)) RETURN
	I=91					#ASSUME NO GUANO.
	IF(.NOT. QHERE(GUANO,HERE)) GO TO 32100	#IS IT HERE?
	RVGUA=MIN0(4,RVGUA+1)		#YES, SET NEW STATE.
	I=91+RVGUA				#GET NASTY REMARK.
32100	CALL RSPEAK(I)				#DESCRIBE.
	RETURN
#
# R33--	FALLS ROOM
#
33000	IF(PRSA.NE.LOOKW) RETURN		#LOOK?
	CALL RSPEAK(96)				#DESCRIBE.
	I=97					#ASSUME NO RAINBOW.
	IF(RAINBF) I=98				#GOT ONE?
	CALL RSPEAK(I)				#DESCRIBE.
	RETURN

# RAPPL1, PAGE 10
#
# R34--	LEDGE FUNCTION.  LEDGE CAN COLLAPSE.
#
34000	IF(PRSA.NE.LOOKW) RETURN		#LOOK?
	CALL RSPEAK(100)			#DESCRIBE.
	I=102					#ASSUME SAFE ROOM OK.
	IF((RFLAG(MSAFE).AND.RMUNG).NE.0) I=101	#IF MUNGED, ROOM GONE.
	CALL RSPEAK(I)				#DESCRIBE.
	RETURN
#
# R35--	SAFE ROOM.  STATE DEPENDS ON WHETHER SAFE BLOWN.
#
35000	IF(PRSA.NE.LOOKW) RETURN		#LOOK?
	CALL RSPEAK(104)			#DESCRIBE.
	I=105					#ASSUME OK.
	IF(SAFEF) I=106				#BLOWN?
	CALL RSPEAK(I)				#DESCRIBE.
	RETURN
#
# R36--	MAGNET ROOM.  DESCRIBE, CHECK FOR SPINDIZZY DOOM.
#
36000	IF(PRSA.NE.LOOKW) GO TO 36500		#LOOK?
	CALL RSPEAK(107)			#DESCRIBE.
	RETURN
#
36500	IF((PRSA.NE.WALKIW).OR. .NOT.CAROFF) RETURN	#WALKIN ON FLIPPED?
	IF(CAROZF) GO TO 36600			#ZOOM?
	CALL RSPEAK(108)			#NO, SPIN HIS COMPASS.
	RETURN
#
36600	I=58					#SPIN HIS INSIDES.
	IF(WINNER.NE.PLAYER) I=99		#SPIN ROBOT.
	CALL JIGSUP(I)				#DEAD.
	RETURN
#
# R37--	CAGE ROOM.  IF SOLVED CAGE, MOVE TO OTHER CAGE ROOM.
#
37000	IF(CAGESF) F=MOVETO(CAGER,WINNER)	#IF SOLVED, MOVE.
	RETURN
#
	END

# SOBJS-	SIMPLE OBJECTS PROCESSOR
#	OBJECTS IN THIS MODULE CANNOT CALL RMINFO, JIGSUP,
#	MAJOR VERBS, OR OTHER NON-RESIDENT SUBROUTINES
#
# DECLARATIONS
#
	LOGICAL FUNCTION SOBJS(RI,ARG)
	IMPLICIT INTEGER (A-Z)
	LOGICAL QOPEN
	LOGICAL MOVETO,OPNCLS,LIT
	LOGICAL QHERE,F
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
	COMMON /STATE/ MOVES,DEATHS,RWSCOR,MXSCOR,MXLOAD,
		LTSHFT,BLOC,MUNGRM,HS,EGSCOR,EGMXSC
#
# ROOMS
#
	COMMON /ROOMS/ RLNT,RDESC2,RDESC1(215),REXIT(215),
		RACTIO(215),RVAL(215),RFLAG(215)
	INTEGER RRAND(215)
	EQUIVALENCE (RVAL,RRAND)
#
	COMMON /RFLAG/ RSEEN,RLIGHT,RLAND,RWATER,RAIR,
		RSACRD,RFILL,RMUNG,RBUCK,RHOUSE,RNWALL,REND
#
	COMMON /RINDEX/ WHOUS,LROOM,CELLA
	COMMON /RINDEX/ MTROL,MAZE1	
	COMMON /RINDEX/ MGRAT,MAZ15	
	COMMON /RINDEX/ FORE1,FORE3,CLEAR,RESER
	COMMON /RINDEX/ STREA,EGYPT,ECHOR
	COMMON /RINDEX/ TSHAF	
	COMMON /RINDEX/ BSHAF,MMACH,DOME,MTORC
	COMMON /RINDEX/ CAROU	
	COMMON /RINDEX/ RIDDL,LLD2,TEMP1,TEMP2,MAINT
	COMMON /RINDEX/ BLROO,TREAS,RIVR1,RIVR2,RIVR3,MCYCL
	COMMON /RINDEX/ RIVR4,RIVR5,FCHMP,FALLS,MBARR
	COMMON /RINDEX/ MRAIN,POG,VLBOT,VAIR1,VAIR2,VAIR3,VAIR4
	COMMON /RINDEX/ LEDG2,LEDG3,LEDG4,MSAFE,CAGER
	COMMON /RINDEX/ CAGED,TWELL,BWELL,ALICE,ALISM,ALITR
	COMMON /RINDEX/ MTREE,BKENT,BKVW,BKTWI,BKVAU,BKBOX
	COMMON /RINDEX/ CRYPT,TSTRS,MRANT,MREYE
	COMMON /RINDEX/ MRA,MRB,MRC,MRG,MRD,FDOOR
	COMMON /RINDEX/ MRAE,MRCE,MRCW,MRGE,MRGW,MRDW,INMIR
	COMMON /RINDEX/ SCORR,NCORR,PARAP,CELL,PCELL,NCELL
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
	COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
	COMMON /OINDEX/ WATER,ROPE,KNIFE,SWORD,LAMP,BLAMP,RUG
	COMMON /OINDEX/	LEAVE,TROLL,AXE
	COMMON /OINDEX/ RKNIF,KEYS,ICE,BAR
	COMMON /OINDEX/ COFFI,TORCH,TBASK,FBASK,IRBOX
	COMMON /OINDEX/ GHOST,TRUNK,BELL,BOOK,CANDL
	COMMON /OINDEX/ MATCH,TUBE,PUTTY,WRENC,SCREW,CYCLO,CHALI
	COMMON /OINDEX/ THIEF,STILL,WINDO,GRATE,DOOR
	COMMON /OINDEX/ HPOLE,LEAK,RBUTT,RAILI
	COMMON /OINDEX/ POT,STATU,IBOAT,DBOAT,PUMP,RBOAT
	COMMON /OINDEX/ STICK,BUOY,SHOVE,BALLO,RECEP,GUANO
	COMMON /OINDEX/ BROPE,HOOK1,HOOK2,SAFE,SSLOT,BRICK,FUSE
	COMMON /OINDEX/ GNOME,BLABE,DBALL,TOMB
	COMMON /OINDEX/ LCASE,CAGE,RCAGE,SPHER,SQBUT
	COMMON /OINDEX/ FLASK,POOL,SAFFR,BUCKE,ECAKE,ORICE,RDICE,BLICE
	COMMON /OINDEX/ ROBOT,FTREE,BILLS,PORTR,SCOL,ZGNOM
	COMMON /OINDEX/ EGG,BEGG,BAUBL,CANAR,BCANA
	COMMON /OINDEX/ YLWAL,RDWAL,PINDR,RBEAM
	COMMON /OINDEX/ ODOOR,QDOOR,CDOOR,NUM1,NUM8
	COMMON /OINDEX/ HANDS,WALL,LUNGS,SAILO,AVIAT,TEETH
	COMMON /OINDEX/ ITOBJ,EVERY,VALUA,OPLAY,WNORT,GWATE,MASTER
#
# CLOCK INTERRUPTS
#
	LOGICAL CFLAG
	COMMON /CEVENT/ CLNT,CTICK(25),CACTIO(25),CFLAG(25)
#
	COMMON /CINDEX/ CEVCUR,CEVMNT,CEVLNT,CEVMAT,CEVCND,
		CEVBAL,CEVBRN,CEVFUS,CEVLED,CEVSAF,CEVVLG,
		CEVGNO,CEVBUC,CEVSPH,CEVEGH,
			CEVFOR,CEVSCL,CEVZGI,CEVZGO,CEVSTE,
		CEVMRS,CEVPIN,CEVINQ,CEVFOL

#
# VILLAINS AND DEMONS
#
	LOGICAL THFFLG,SWDACT,THFACT
	COMMON /HACK/ THFPOS,THFFLG,THFACT,SWDACT,SWDSTA
#
# ADVENTURERS
#
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
		AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
#
	COMMON /AINDEX/ PLAYER,AROBOT,AMASTR
#
# VERBS
#
	COMMON /VINDEX/ CINTW,DEADXW,FRSTQW,INXW,OUTXW
	COMMON /VINDEX/ WALKIW,FIGHTW,FOOW
	COMMON /VINDEX/ MELTW,READW,INFLAW,DEFLAW,ALARMW,EXORCW
	COMMON /VINDEX/ PLUGW,KICKW,WAVEW,RAISEW,LOWERW,RUBW
	COMMON /VINDEX/ PUSHW,UNTIEW,TIEW,TIEUPW,TURNW,BREATW
	COMMON /VINDEX/ KNOCKW,LOOKW,EXAMIW,SHAKEW,MOVEW,TRNONW,TRNOFW
	COMMON /VINDEX/ OPENW,CLOSEW,FINDW,WAITW,SPINW,BOARDW,UNBOAW,TAKEW
	COMMON /VINDEX/ INVENW,FILLW,EATW,DRINKW,BURNW
	COMMON /VINDEX/ MUNGW,KILLW,ATTACW,SWINGW
	COMMON /VINDEX/ WALKW,TELLW,PUTW,DROPW,GIVEW,POURW,THROWW
	COMMON /VINDEX/ DIGW,LEAPW,STAYW,FOLLOW
	COMMON /VINDEX/ HELLOW,LOOKIW,LOOKUW,PUMPW,WINDW
	COMMON /VINDEX/ CLMBW,CLMBUW,CLMBDW,TRNTOW
#
# FLAGS
#
	LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL FOLLWF,SPELLF,sprf
	COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
		DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
		MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
			EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
		GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
		GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
		MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
		follwf,spellf,sprf(6)
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL
#
# FUNCTIONS AND DATA
#
	QOPEN(R)=AND(OFLAG2(R),OPENBT).NE.0

# SOBJS, PAGE 2
#
	IF(PRSO.NE.0) ODO2=ODESC2(PRSO)
	IF(PRSI.NE.0) ODI2=ODESC2(PRSI)
	AV=AVEHIC(WINNER)
	SOBJS=.TRUE.
#
	GO TO (1000,3000,4000,6000,7000,8000,9000,
		13000,14000,16000,17000,
		21000,23000,24000,27000,28000,29000,30000,
		31000,33000,34000,36000,37000,38000,
		41000,42000,43000,44000,46000,
		53000,56000)RI
	CALL BUG(6,RI)
#
# RETURN HERE TO DECLARE FALSE RESULT
#
10	SOBJS=.FALSE.
	RETURN

# SOBJS, PAGE 3
#
# O1--	GUNK FUNCTION
#
1000	IF(OCAN(GUNK).EQ.0) GO TO 10		#NOT INSIDE? F
	CALL NEWSTA(GUNK,122,0,0,0)		#FALLS APART.
	RETURN
#
# O2--	TROPHY CASE
#
3000	IF(PRSA.NE.TAKEW) GO TO 10		#TAKE?
	CALL RSPEAK(128)			#CANT.
	RETURN
#
# O3--	BOTTLE FUNCTION
#
4000	IF(PRSA.NE.THROWW) GO TO 4100		#THROW?
	CALL NEWSTA(PRSO,129,0,0,0)		#BREAKS.
	RETURN
#
4100	IF(PRSA.NE.MUNGW) GO TO 10		#MUNG?
	CALL NEWSTA(PRSO,131,0,0,0)		#BREAKS.
	RETURN

# SOBJS, PAGE 4
#
# O4--	ROPE FUNCTION
#
6000	IF(HERE.EQ.DOME) GO TO 6100		#IN DOME?
	DOMEF=.FALSE.				#NO,
	IF(PRSA.NE.UNTIEW) GO TO 6050		#UNTIE?
	CALL RSPEAK(134)			#CANT
	RETURN
#
6050	IF(PRSA.NE.TIEW) GO TO 10		#TIE?
	CALL RSPEAK(135)			#CANT TIE
	RETURN
#
6100	IF((PRSA.NE.TIEW).OR.(PRSI.NE.RAILI)) GO TO 6200
	IF(DOMEF) GO TO 6150			#ALREADY TIED?
	DOMEF=.TRUE.				#NO, TIE IT.
	OFLAG1(ROPE)=OFLAG1(ROPE).OR.NDSCBT
	OFLAG2(ROPE)=OFLAG2(ROPE).OR.CLMBBT
	CALL NEWSTA(ROPE,137,DOME,0,0)
	RETURN
#
6150	CALL RSPEAK(136)			#DUMMY.
	RETURN
#
6200	IF(PRSA.NE.UNTIEW) GO TO 6300		#UNTIE?
	IF(DOMEF) GO TO 6250			#TIED?
	CALL RSPEAK(138)			#NO, DUMMY.
	RETURN
#
6250	DOMEF=.FALSE.				#YES, UNTIE IT.
	OFLAG1(ROPE)=AND(OFLAG1(ROPE),NOT(NDSCBT))
	OFLAG2(ROPE)=AND(OFLAG2(ROPE),NOT(CLMBBT))
	CALL RSPEAK(139)
	RETURN
#
6300	IF(DOMEF.OR.(PRSA.NE.DROPW)) GO TO 6400	#DROP & UNTIED?
	CALL NEWSTA(ROPE,140,MTORC,0,0)		#YES, DROP.
	RETURN
#
6400	IF((PRSA.NE.TAKEW).OR. .NOT.DOMEF) GO TO 10
	CALL RSPEAK(141)			#TAKE & TIED.
	RETURN
#
# O5--	SWORD FUNCTION
#
7000	IF((PRSA.EQ.TAKEW).AND.(WINNER.EQ.PLAYER))
		SWDACT=.TRUE.			#TURN ON DEMON.
	GO TO 10
#
# O6--	LANTERN
#
8000	IF(PRSA.NE.THROWW) GO TO 8100		#THROW?
	CALL NEWSTA(LAMP,142,0,0,0)		#BREAKS,
	CALL NEWSTA(BLAMP,0,HERE,0,0)		#REPLACED.
	RETURN
#
8100	IF(PRSA.EQ.TRNONW) CFLAG(CEVLNT)=.TRUE.
	IF(PRSA.EQ.TRNOFW) CFLAG(CEVLNT)=.FALSE.
	GO TO 10
#
# O7--	RUG FUNCTION
#
9000	IF(PRSA.NE.RAISEW) GO TO 9100		#RAISE?
	CALL RSPEAK(143)			#CANT
	RETURN
#
9100	IF(PRSA.NE.TAKEW) GO TO 9200		#TAKE?
	CALL RSPEAK(144)			#CANT
	RETURN
#
9200	IF(PRSA.NE.MOVEW) GO TO 9300		#MOVE?
	CALL RSPEAK(145+ORRUG)
	ORRUG=1
	OFLAG1(DOOR)=OFLAG1(DOOR).OR.VISIBT	#REVEAL DOOR.
	RETURN
#
9300	IF((PRSA.NE.LOOKUW).OR.(ORRUG.NE.0).OR.
		QOPEN(DOOR)) GO TO 10		#LOOK UNDER RUG?
	CALL RSPEAK(345)
	RETURN

# SOBJS, PAGE 5
#
# O8--	SKELETON
#
13000	I=ROBRM(HERE,100,LLD2,0,0)+ROBADV(WINNER,LLD2,0,0)
	IF(I.NE.0) CALL RSPEAK(162)		#IF ROBBED, SAY SO.
	RETURN
#
# O9--	MIRROR
#
14000	IF(MIRRMF.OR.(PRSA.NE.RUBW)) GO TO 14500
	MROOM=HERE.XOR.1			#CALCULATE NEW RM.
	DO I=1,OLNT {				#INTERCHANGE OBJS.
	  IF(OROOM(I).EQ.HERE) OROOM(I)=-1
	  IF(OROOM(I).EQ.MROOM) OROOM(I)=HERE
	  IF(OROOM(I).EQ.-1) OROOM(I)=MROOM
	  }
	F=MOVETO(MROOM,WINNER)
	CALL RSPEAK(163)			#SHAKE WORLD.
	RETURN
#
14500	IF((PRSA.NE.LOOKW).AND.(PRSA.NE.LOOKIW).AND.
		(PRSA.NE.EXAMIW)) GO TO 14600
	I=164					#MIRROR OK.
	IF(MIRRMF) I=165			#MIRROR DEAD.
	CALL RSPEAK(I)
	RETURN
#
14600	IF(PRSA.NE.TAKEW) GO TO 14700		#TAKE?
	CALL RSPEAK(166)			#JOKE.
	RETURN
#
14700	IF((PRSA.NE.MUNGW).AND.(PRSA.NE.THROWW)) GO TO 10
	I=167					#MIRROR BREAKS.
	IF(MIRRMF) I=168			#MIRROR ALREADY BROKEN.
	MIRRMF=.TRUE.
	BADLKF=.TRUE.
	CALL RSPEAK(I)
	RETURN

# SOBJS, PAGE 6
#
# O10--	DUMBWAITER
#
16000	IF(PRSA.NE.RAISEW) GO TO 16100		#RAISE?
	IF(CAGETF) GO TO 16400			#ALREADY AT TOP?
	CALL NEWSTA(TBASK,175,TSHAF,0,0)	#NO, RAISE BASKET.
	CALL NEWSTA(FBASK,0,BSHAF,0,0)
	CAGETF=.TRUE.			#AT TOP.
	RETURN
#
16100	IF(PRSA.NE.LOWERW) GO TO 16200		#LOWER?
	IF(.NOT.CAGETF) GO TO 16400		#ALREADY AT BOTTOM?
	CALL NEWSTA(TBASK,176,BSHAF,0,0)	#NO, LOWER BASKET.
	CALL NEWSTA(FBASK,0,TSHAF,0,0)
	CAGETF=.FALSE.
	IF(.NOT.LIT(HERE)) CALL RSPEAK(406)	#IF DARK, DIE.
	RETURN
#
16200	IF((PRSO.NE.FBASK).AND.(PRSI.NE.FBASK)) GO TO 16300
	CALL RSPEAK(130)			#WRONG BASKET.
	RETURN
#
16300	IF(PRSA.NE.TAKEW) GO TO 10		#TAKE?
	CALL RSPEAK(177)			#JOKE.
	RETURN
#
16400	CALL RSPEAK(125+RND(3))			#DUMMY.
	RETURN
#
# O11--	GHOST FUNCTION
#
17000	I=178					#ASSUME DIRECT.
	IF(PRSO.NE.GHOST) I=179			#IF NOT, INDIRECT.
	CALL RSPEAK(I)
	RETURN					#SPEAK AND EXIT.

# SOBJS, PAGE 7
#
# O12--	TUBE
#
21000	IF((PRSA.NE.PUTW).OR.(PRSI.NE.TUBE)) GO TO 10
	CALL RSPEAK(186)			#CANT PUT BACK IN.
	RETURN
#
# O13--	CHALICE
#
23000	IF((PRSA.NE.TAKEW).OR.(OCAN(PRSO).NE.0).OR.
		(OROOM(PRSO).NE.TREAS).OR.(OROOM(THIEF).NE.TREAS).OR.
		(AND(OFLAG2(THIEF),FITEBT).EQ.0).OR.
			.NOT. THFACT) GO TO 10
	CALL RSPEAK(204)			#CANT TAKE.
	RETURN
#
# O14--	PAINTING
#
24000	IF(PRSA.NE.MUNGW) GO TO 10		#MUNG?
	CALL RSPEAK(205)			#DESTROY PAINTING.
	OFVAL(PRSO)=0
	OTVAL(PRSO)=0
	ODESC1(PRSO)=207
	ODESC2(PRSO)=206
	RETURN

# SOBJS, PAGE 8
#
# O15--	BOLT
#
27000	IF(PRSA.NE.TURNW) GO TO 10		#TURN BOLT?
	IF(PRSI.NE.WRENC) GO TO 27500		#WITH WRENCH?
	IF(GATEF) GO TO 27100			#PROPER BUTTON PUSHED?
	CALL RSPEAK(210)			#NO, LOSE.
	RETURN
#
27100	IF(LWTIDF) GO TO 27200			#LOW TIDE NOW?
	LWTIDF=.TRUE.				#NO, EMPTY DAM.
	CALL RSPEAK(211)
	OFLAG2(COFFI)=AND(OFLAG2(COFFI),NOT(SCRDBT))
	OFLAG1(TRUNK)=OR(OFLAG1(TRUNK),VISIBT)	#MATERIALIZE TRUNK.
	RFLAG(RESER)=AND(OR(RFLAG(RESER),RLAND),
		NOT(RWATER+RSEEN))		#KEEP THIEF AWAY.
	RETURN
#
27200	LWTIDF=.FALSE.				#YES, FILL DAM.
	CALL RSPEAK(212)
	IF(QHERE(TRUNK,RESER)) {
		OFLAG1(TRUNK)=AND(OFLAG1(TRUNK),NOT(VISIBT))
		}
	RFLAG(RESER)=AND(OR(RFLAG(RESER),RWATER),NOT(RLAND))
	RETURN
#
27500	CALL RSPSUB(299,ODI2)			#NOT WITH THAT.
	RETURN
#
# O16--	GRATING
#
28000	IF((PRSA.NE.OPENW).AND.(PRSA.NE.CLOSEW)) GO TO 10
	IF(GRUNLF) GO TO 28200			#UNLOCKED?
	CALL RSPEAK(214)			#NO, LOCKED.
	RETURN
#
28200	I=215					#UNLOCKED, VIEW FRM CLR.
	IF(HERE.NE.CLEAR) I=216			#VIEW FROM BELOW.
	SOBJS=OPNCLS(GRATE,I,217)		#OPEN/CLOSE.
	RETURN
#
# O17--	TRAP DOOR
#
29000	IF(HERE.NE.LROOM) GO TO 29100		#FROM LIVING ROOM?
	SOBJS=OPNCLS(DOOR,218,219)		#OPEN/CLOSE.
	RETURN
#
29100	IF(HERE.NE.CELLA) GO TO 10		#FROM CELLAR?
	IF((PRSA.NE.OPENW).OR.QOPEN(DOOR)) GO TO 29200
	CALL RSPEAK(220)			#CANT OPEN CLOSED DOOR.
	RETURN
#
29200	SOBJS=OPNCLS(DOOR,0,22)			#NORMAL OPEN/CLOSE.
	RETURN
#
# O18--	DURABLE DOOR
#
30000	I=0					#ASSUME NO APPL.
	IF(PRSA.EQ.OPENW) I=221			#OPEN?
	IF(PRSA.EQ.BURNW) I=222			#BURN?
	IF(PRSA.EQ.MUNGW) I=223+RND(3)		#MUNG?
	IF(I.EQ.0) GO TO 10
	CALL RSPEAK(I)
	RETURN
#
# O19--	MASTER SWITCH
#
31000	IF(PRSA.NE.TURNW) GO TO 10		#TURN?
	IF(PRSI.NE.SCREW) GO TO 31500		#WITH SCREWDRIVER?
	IF(QOPEN(MACHI)) GO TO 31600		#LID UP?
	CALL RSPEAK(226)			#NO, ACTIVATE.
	IF(OCAN(COAL).NE.MACHI) GO TO 31400	#COAL INSIDE?
	CALL NEWSTA(COAL,0,0,0,0)		#VANISH COAL.
	CALL NEWSTA(DIAMO,0,0,MACHI,0)		#PRODUCE DIAMOND.
	RETURN
#
31400	DO I=1,OLNT {				#KILL NONCOAL OBJECTS.
	  IF(OCAN(I).NE.MACHI) NEXT		#INSIDE MACHINE?
	  CALL NEWSTA(I,0,0,0,0)
	  CALL NEWSTA(GUNK,0,0,MACHI,0)		#REDUCE TO GUNK.
	  }
	RETURN
#
31500	CALL RSPSUB(300,ODI2)			#CANT TURN WITH THAT.
	RETURN
#
31600	CALL RSPEAK(227)			#LID IS UP.
	RETURN

# SOBJS, PAGE 9
#
# O20--	LEAK
#
33000	IF((PRSO.NE.LEAK).OR.(PRSA.NE.PLUGW).OR.(RVMNT.LE.0))
		GO TO 10			#PLUG ACTIVE LEAK?
	IF(PRSI.NE.PUTTY) GO TO 33100		#WITH PUTTY?
	RVMNT=-1				#DISABLE LEAK.
	CTICK(CEVMNT)=0
	CALL RSPEAK(577)
	RETURN
#
33100	CALL RSPSUB(301,ODI2)			#CANT WITH THAT.
	RETURN
#
# O21--	DROWNING BUTTONS
#
34000	IF(PRSA.NE.PUSHW) GO TO 10		#PUSH?
	GO TO (34100,34200,34300,34400),(PRSO-RBUTT+1)
	GO TO 10				#NOT A BUTTON.
#
34100	RFLAG(HERE)=RFLAG(HERE).XOR.RLIGHT	#RED, ZAP LIGHTS.
	I=230
	IF(AND(RFLAG(HERE),RLIGHT).NE.0) I=231
	CALL RSPEAK(I)
	RETURN
#
34200	GATEF=.TRUE.				#RELEASE GATE.
	CALL RSPEAK(232)
	RETURN
#
34300	GATEF=.FALSE.				#INTERLOCK GATE.
	CALL RSPEAK(232)
	RETURN
#
34400	IF(RVMNT.NE.0) GO TO 34500		#LEAK ALREADY STARTED?
	CALL RSPEAK(233)			#NO, START LEAK.
	RVMNT=1
	CTICK(CEVMNT)=-1
	RETURN
#
34500	CALL RSPEAK(234)			#BUTTON JAMMED.
	RETURN
#
# O22--	INFLATABLE BOAT
#
36000	IF(PRSA.NE.INFLAW) GO TO 10		#INFLATE?
	IF(OROOM(IBOAT).NE.0) GO TO 36100	#IN ROOM?
	CALL RSPEAK(235)			#NO, JOKE.
	RETURN
#
36100	IF(PRSI.NE.PUMP) GO TO 36200		#WITH PUMP?
	CALL NEWSTA(IBOAT,0,0,0,0)		#REPLACE BOAT WITH
	CALL NEWSTA(RBOAT,236,HERE,0,0)	#MAGIC BOAT.
	DEFLAF=.FALSE.
	RETURN
#
36200	I=237					#JOKES.
	IF(PRSI.NE.LUNGS) I=303
	CALL RSPSUB(I,ODI2)
	RETURN
#
# O23--	DEFLATED BOAT
#
37000	IF(PRSA.NE.INFLAW) GO TO 37100		#INFLATE?
	CALL RSPEAK(238)			#JOKE.
	RETURN
#
37100	IF(PRSA.NE.PLUGW) GO TO 10		#PLUG?
	IF(PRSI.NE.PUTTY) GO TO 33100		#WITH PUTTY?
	CALL NEWSTA(IBOAT,239,OROOM(DBOAT),OCAN(DBOAT),OADV(DBOAT))
	CALL NEWSTA(DBOAT,0,0,0,0)
	RETURN

# SOBJS, PAGE 10
#
# O24--	RUBBER BOAT
#
38000	IF(ARG.NE.0) GO TO 10			#DISMISS READIN, OUT.
	IF((PRSA.NE.BOARDW).OR.(OADV(STICK).NE.WINNER)) GO TO 38100
	CALL NEWSTA(RBOAT,0,0,0,0)		#STICK PUNCTURES
	CALL NEWSTA(DBOAT,240,HERE,0,0)	#INFLATED BOAT.
	DEFLAF=.TRUE.
	RETURN
#
38100	IF(PRSA.NE.INFLAW) GO TO 38200		#INFLATE?
	CALL RSPEAK(367)			#YES, JOKE.
	RETURN
#
38200	IF(PRSA.NE.DEFLAW) GO TO 10		#DEFLATE?
	IF(AV.EQ.RBOAT) GO TO 38300		#IN BOAT?
	IF(OROOM(RBOAT).EQ.0) GO TO 38400	#ON GROUND?
	CALL NEWSTA(IBOAT,241,HERE,0,0)		#REPLACE WITH
	CALL NEWSTA(RBOAT,0,0,0,0)		#INFLATABLE BOAT.
	DEFLAF=.TRUE.
	RETURN
#
38300	CALL RSPEAK(242)			#IN BOAT.
	RETURN
#
38400	CALL RSPEAK(243)			#NOT ON GROUND.
	RETURN
#
# O25--	BRAIDED ROPE
#
41000	IF((PRSA.NE.TIEW).OR.(PRSO.NE.BROPE).OR.
		((PRSI.NE.HOOK1).AND.(PRSI.NE.HOOK2)))
		GO TO 41500			#TIE TO HOOK?
	BTIEF=PRSI				#RECORD LOCATION.
	CFLAG(CEVBAL)=.FALSE.			#STALL ASCENT.
	CALL RSPEAK(248)
	RETURN
#
41500	IF((PRSA.NE.UNTIEW).OR.(PRSO.NE.BROPE)) GO TO 10
	IF(BTIEF.NE.0) GO TO 41600		#TIED UP?
	CALL RSPEAK(249)			#NO, JOKE.
	RETURN
#
41600	CALL RSPEAK(250)
	BTIEF=0					#UNTIE.
	CTICK(CEVBAL)=3				#RESTART CLOCK.
	CFLAG(CEVBAL)=.TRUE.
	RETURN
#
# O26--	SAFE
#
42000	I=0					#ASSUME UNPROCESSED.
	IF(PRSA.EQ.TAKEW) I=251			#TAKE?
	IF((PRSA.EQ.OPENW).AND.SAFEF) I=253	#OPEN AFTER BLAST?
	IF((PRSA.EQ.OPENW).AND..NOT.SAFEF) I=254	#OPEN BEFORE BLAST?
	IF((PRSA.EQ.CLOSEW).AND.SAFEF) I=253	#CLOSE AFTER?
	IF((PRSA.EQ.CLOSEW).AND..NOT.SAFEF) I=255
	IF(I.EQ.0) GO TO 10
	CALL RSPEAK(I)
	RETURN
#
# O27--	FUSE
#
43000	IF(PRSA.NE.BURNW) GO TO 10		#BURN?
	CALL RSPEAK(256)
	CTICK(CEVFUS)=2				#START COUNTDOWN.
	RETURN
#
# O28--	GNOME
#
44000	IF((PRSA.NE.GIVEW).AND.(PRSA.NE.THROWW)) GO TO 44500
	IF(OTVAL(PRSO).EQ.0) GO TO 44100	#TREASURE?
	CALL RSPSUB(257,ODO2)			#YES, GET DOOR.
	CALL NEWSTA(PRSO,0,0,0,0)
	CALL NEWSTA(GNOME,0,0,0,0)		#VANISH GNOME.
	GNODRF=.TRUE.
	RETURN
#
44100	CALL RSPSUB(258,ODO2)			#NO, LOSE OBJECT.
	CALL NEWSTA(PRSO,0,0,0,0)
	RETURN
#
44500	CALL RSPEAK(259)			#NERVOUS GNOME.
	IF(.NOT.GNOMEF) CTICK(CEVGNO)=5		#SCHEDULE BYEBYE.
	GNOMEF=.TRUE.
	RETURN
#
# O29--	COKE BOTTLES
#
46000	IF((PRSA.NE.THROWW).AND.(PRSA.NE.MUNGW)) GO TO 10
	CALL NEWSTA(PRSO,262,0,0,0)		#MUNG BOTTLES.
	RETURN

# SOBJS, PAGE 11
#
#
# O30--	ROBOT
#
53000	IF(PRSA.NE.GIVEW) GO TO 53200		#GIVE?
	CALL NEWSTA(PRSO,0,0,0,AROBOT)		#PUT ON ROBOT.
	CALL RSPSUB(302,ODO2)
	RETURN
#
53200	IF((PRSA.NE.MUNGW).AND.(PRSA.NE.THROWW)) GO TO 10
	CALL NEWSTA(ROBOT,285,0,0,0)		#KILL ROBOT.
	RETURN
#
# O31--	GRUE
#
56000	IF(PRSA.NE.EXAMIW) GO TO 56100		#EXAMINE?
	CALL RSPEAK(288)
	RETURN
#
56100	IF(PRSA.NE.FINDW) GO TO 10		#FIND?
	CALL RSPEAK(289)
	RETURN
#
	END

# BALLOP-	BALLOON FUNCTION
#
# DECLARATIONS
#
	LOGICAL FUNCTION BALLOP(ARG)
	IMPLICIT INTEGER (A-Z)
	LOGICAL FINDXT,QEMPTY
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
	COMMON /STATE/ MOVES,DEATHS,RWSCOR,MXSCOR,MXLOAD,
		LTSHFT,BLOC,MUNGRM,HS,EGSCOR,EGMXSC
#
# ROOMS
#
	COMMON /ROOMS/ RLNT,RDESC2,RDESC1(215),REXIT(215),
		RACTIO(215),RVAL(215),RFLAG(215)
	INTEGER RRAND(215)
	EQUIVALENCE (RVAL,RRAND)
#
	COMMON /RFLAG/ RSEEN,RLIGHT,RLAND,RWATER,RAIR,
		RSACRD,RFILL,RMUNG,RBUCK,RHOUSE,RNWALL,REND
#
# EXITS
#
	COMMON /CURXT/ XTYPE,XROOM1,XSTRNG,XACTIO,XOBJ
	EQUIVALENCE (XFLAG,XOBJ)
#
	COMMON /XPARS/ XRMASK,XDMASK,XFMASK,XFSHFT,XASHFT,
		XELNT(4),XNORM,XNO,XCOND,XDOOR,XLFLAG
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
	COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
	COMMON /OINDEX/ WATER,ROPE,KNIFE,SWORD,LAMP,BLAMP,RUG
	COMMON /OINDEX/	LEAVE,TROLL,AXE
	COMMON /OINDEX/ RKNIF,KEYS,ICE,BAR
	COMMON /OINDEX/ COFFI,TORCH,TBASK,FBASK,IRBOX
	COMMON /OINDEX/ GHOST,TRUNK,BELL,BOOK,CANDL
	COMMON /OINDEX/ MATCH,TUBE,PUTTY,WRENC,SCREW,CYCLO,CHALI
	COMMON /OINDEX/ THIEF,STILL,WINDO,GRATE,DOOR
	COMMON /OINDEX/ HPOLE,LEAK,RBUTT,RAILI
	COMMON /OINDEX/ POT,STATU,IBOAT,DBOAT,PUMP,RBOAT
	COMMON /OINDEX/ STICK,BUOY,SHOVE,BALLO,RECEP,GUANO
	COMMON /OINDEX/ BROPE,HOOK1,HOOK2,SAFE,SSLOT,BRICK,FUSE
	COMMON /OINDEX/ GNOME,BLABE,DBALL,TOMB
	COMMON /OINDEX/ LCASE,CAGE,RCAGE,SPHER,SQBUT
	COMMON /OINDEX/ FLASK,POOL,SAFFR,BUCKE,ECAKE,ORICE,RDICE,BLICE
	COMMON /OINDEX/ ROBOT,FTREE,BILLS,PORTR,SCOL,ZGNOM
	COMMON /OINDEX/ EGG,BEGG,BAUBL,CANAR,BCANA
	COMMON /OINDEX/ YLWAL,RDWAL,PINDR,RBEAM
	COMMON /OINDEX/ ODOOR,QDOOR,CDOOR,NUM1,NUM8
	COMMON /OINDEX/ HANDS,WALL,LUNGS,SAILO,AVIAT,TEETH
	COMMON /OINDEX/ ITOBJ,EVERY,VALUA,OPLAY,WNORT,GWATE,MASTER
#
# CLOCK INTERRUPTS
#
	LOGICAL CFLAG
	COMMON /CEVENT/ CLNT,CTICK(25),CACTIO(25),CFLAG(25)
#
	COMMON /CINDEX/ CEVCUR,CEVMNT,CEVLNT,CEVMAT,CEVCND,
		CEVBAL,CEVBRN,CEVFUS,CEVLED,CEVSAF,CEVVLG,
		CEVGNO,CEVBUC,CEVSPH,CEVEGH,
			CEVFOR,CEVSCL,CEVZGI,CEVZGO,CEVSTE,
		CEVMRS,CEVPIN,CEVINQ,CEVFOL

#
# VERBS
#
	COMMON /VINDEX/ CINTW,DEADXW,FRSTQW,INXW,OUTXW
	COMMON /VINDEX/ WALKIW,FIGHTW,FOOW
	COMMON /VINDEX/ MELTW,READW,INFLAW,DEFLAW,ALARMW,EXORCW
	COMMON /VINDEX/ PLUGW,KICKW,WAVEW,RAISEW,LOWERW,RUBW
	COMMON /VINDEX/ PUSHW,UNTIEW,TIEW,TIEUPW,TURNW,BREATW
	COMMON /VINDEX/ KNOCKW,LOOKW,EXAMIW,SHAKEW,MOVEW,TRNONW,TRNOFW
	COMMON /VINDEX/ OPENW,CLOSEW,FINDW,WAITW,SPINW,BOARDW,UNBOAW,TAKEW
	COMMON /VINDEX/ INVENW,FILLW,EATW,DRINKW,BURNW
	COMMON /VINDEX/ MUNGW,KILLW,ATTACW,SWINGW
	COMMON /VINDEX/ WALKW,TELLW,PUTW,DROPW,GIVEW,POURW,THROWW
	COMMON /VINDEX/ DIGW,LEAPW,STAYW,FOLLOW
	COMMON /VINDEX/ HELLOW,LOOKIW,LOOKUW,PUMPW,WINDW
	COMMON /VINDEX/ CLMBW,CLMBUW,CLMBDW,TRNTOW
#
# FLAGS
#
	LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL FOLLWF,SPELLF,sprf
	COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
		DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
		MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
			EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
		GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
		GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
		MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
		follwf,spellf,sprf(6)
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL

# BALLOP, PAGE 2
#
	BALLOP=.TRUE.				#ASSUME WINS.
	IF(ARG.NE.2) GO TO 200			#READOUT?
	IF(PRSA.NE.LOOKW) GO TO 10		#ONLY PROCESS LOOK.
	IF(BINFF.NE.0) GO TO 50			#INFLATED?
	CALL RSPEAK(543)			#NO.
	GO TO 100
50	CALL RSPSUB(544,ODESC2(BINFF))		#YES.
100	IF(BTIEF.NE.0) CALL RSPEAK(545)		#HOOKED?
	RETURN
#
200	IF(ARG.NE.1) GO TO 500			#READIN?
	IF(PRSA.NE.WALKW) GO TO 300		#WALK?
	IF(FINDXT(PRSO,HERE)) GO TO 250		#VALID EXIT?
	CALL RSPEAK(546)			#NO, JOKE.
	RETURN
#
250	IF(BTIEF.EQ.0) GO TO 275		#TIED UP?
	CALL RSPEAK(547)			#YES, JOKE.
	RETURN
#
275	IF(XTYPE.NE.XNORM) GO TO 10		#NORMAL EXIT?
	IF(AND(RFLAG(XROOM1),RMUNG).EQ.0) BLOC=XROOM1
10	BALLOP=.FALSE.
	RETURN
#
300	IF((PRSA.NE.TAKEW).OR.(PRSO.NE.BINFF)) GO TO 350
	CALL RSPSUB(548,ODESC2(BINFF))		#RECEP CONT TOO HOT.
	RETURN
#
350	IF((PRSA.NE.PUTW).OR.(PRSI.NE.RECEP).OR.QEMPTY(RECEP))
		GO TO 10			#RECEP ALREADY FULL.
	CALL RSPEAK(549)
	RETURN
#
500	IF((PRSA.NE.UNBOAW).OR.(AND(RFLAG(HERE),RLAND).EQ.0))
		GO TO 600			#DISEMBARK ON LAND?
	IF(BINFF.NE.0) CTICK(CEVBAL)=3		#HE GOT OUT, START BALLOON.
	GO TO 10
#
600	IF((PRSA.NE.BURNW).OR.(OCAN(PRSO).NE.RECEP)) GO TO 700
	CALL RSPSUB(550,ODESC2(PRSO))		#LIGHT FIRE IN RECEP.
	CTICK(CEVBRN)=OSIZE(PRSO)*20
	OFLAG1(PRSO)=AND(OR(OFLAG1(PRSO),(ONBT+FLAMBT+LITEBT)),
			NOT(TAKEBT+READBT))		#BURN IT.
	IF(BINFF.NE.0) RETURN			#ALREADY INFLATED?
	CALL NEWSTA(BLABE,0,0,BALLO,0)		#INSERT LABEL.
	BINFF=PRSO
	CTICK(CEVBAL)=3				#START COUNTDOWN.
	CALL RSPEAK(551)
	RETURN
#
700	IF((PRSA.EQ.UNBOAW).AND.(BINFF.NE.0).AND.
		(AND(RFLAG(HERE),RLAND).NE.0))
		CTICK(CEVBAL)=3
	GO TO 10
#
	END

# LIGHTP-	LIGHT PROCESSOR
#
# DECLARATIONS
#
	LOGICAL FUNCTION LIGHTP(OBJ)
	IMPLICIT INTEGER (A-Z)
	LOGICAL QON
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
	COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
	COMMON /OINDEX/ WATER,ROPE,KNIFE,SWORD,LAMP,BLAMP,RUG
	COMMON /OINDEX/	LEAVE,TROLL,AXE
	COMMON /OINDEX/ RKNIF,KEYS,ICE,BAR
	COMMON /OINDEX/ COFFI,TORCH,TBASK,FBASK,IRBOX
	COMMON /OINDEX/ GHOST,TRUNK,BELL,BOOK,CANDL
	COMMON /OINDEX/ MATCH,TUBE,PUTTY,WRENC,SCREW,CYCLO,CHALI
	COMMON /OINDEX/ THIEF,STILL,WINDO,GRATE,DOOR
	COMMON /OINDEX/ HPOLE,LEAK,RBUTT,RAILI
	COMMON /OINDEX/ POT,STATU,IBOAT,DBOAT,PUMP,RBOAT
	COMMON /OINDEX/ STICK,BUOY,SHOVE,BALLO,RECEP,GUANO
	COMMON /OINDEX/ BROPE,HOOK1,HOOK2,SAFE,SSLOT,BRICK,FUSE
	COMMON /OINDEX/ GNOME,BLABE,DBALL,TOMB
	COMMON /OINDEX/ LCASE,CAGE,RCAGE,SPHER,SQBUT
	COMMON /OINDEX/ FLASK,POOL,SAFFR,BUCKE,ECAKE,ORICE,RDICE,BLICE
	COMMON /OINDEX/ ROBOT,FTREE,BILLS,PORTR,SCOL,ZGNOM
	COMMON /OINDEX/ EGG,BEGG,BAUBL,CANAR,BCANA
	COMMON /OINDEX/ YLWAL,RDWAL,PINDR,RBEAM
	COMMON /OINDEX/ ODOOR,QDOOR,CDOOR,NUM1,NUM8
	COMMON /OINDEX/ HANDS,WALL,LUNGS,SAILO,AVIAT,TEETH
	COMMON /OINDEX/ ITOBJ,EVERY,VALUA,OPLAY,WNORT,GWATE,MASTER
#
# CLOCK INTERRUPTS
#
	LOGICAL CFLAG
	COMMON /CEVENT/ CLNT,CTICK(25),CACTIO(25),CFLAG(25)
#
	COMMON /CINDEX/ CEVCUR,CEVMNT,CEVLNT,CEVMAT,CEVCND,
		CEVBAL,CEVBRN,CEVFUS,CEVLED,CEVSAF,CEVVLG,
		CEVGNO,CEVBUC,CEVSPH,CEVEGH,
			CEVFOR,CEVSCL,CEVZGI,CEVZGO,CEVSTE,
		CEVMRS,CEVPIN,CEVINQ,CEVFOL

#
# VERBS
#
	COMMON /VINDEX/ CINTW,DEADXW,FRSTQW,INXW,OUTXW
	COMMON /VINDEX/ WALKIW,FIGHTW,FOOW
	COMMON /VINDEX/ MELTW,READW,INFLAW,DEFLAW,ALARMW,EXORCW
	COMMON /VINDEX/ PLUGW,KICKW,WAVEW,RAISEW,LOWERW,RUBW
	COMMON /VINDEX/ PUSHW,UNTIEW,TIEW,TIEUPW,TURNW,BREATW
	COMMON /VINDEX/ KNOCKW,LOOKW,EXAMIW,SHAKEW,MOVEW,TRNONW,TRNOFW
	COMMON /VINDEX/ OPENW,CLOSEW,FINDW,WAITW,SPINW,BOARDW,UNBOAW,TAKEW
	COMMON /VINDEX/ INVENW,FILLW,EATW,DRINKW,BURNW
	COMMON /VINDEX/ MUNGW,KILLW,ATTACW,SWINGW
	COMMON /VINDEX/ WALKW,TELLW,PUTW,DROPW,GIVEW,POURW,THROWW
	COMMON /VINDEX/ DIGW,LEAPW,STAYW,FOLLOW
	COMMON /VINDEX/ HELLOW,LOOKIW,LOOKUW,PUMPW,WINDW
	COMMON /VINDEX/ CLMBW,CLMBUW,CLMBDW,TRNTOW
#
# FLAGS
#
	LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL FOLLWF,SPELLF,sprf
	COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
		DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
		MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
			EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
		GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
		GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
		MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
		follwf,spellf,sprf(6)
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL
#
# FUNCTIONS AND DATA
#
	QON(R)=AND(OFLAG1(R),ONBT).NE.0

# LIGHTP, PAGE 2
#
	LIGHTP=.TRUE.				#ASSUME WINS
	FLOBTS=FLAMBT+LITEBT+ONBT
	IF(OBJ.NE.CANDL) GO TO 20000		#CANDLE?
	IF(ORCAND.NE.0) GO TO 19100		#FIRST REF?
	ORCAND=1				#YES, CANDLES ARE
	CTICK(CEVCND)=50			#BURNING WHEN SEEN.
#
19100	IF(PRSI.EQ.CANDL) GO TO 10		#IGNORE IND REFS.
	IF(PRSA.NE.TRNOFW) GO TO 19200		#TURN OFF?
	I=513					#ASSUME OFF.
	IF(QON(CANDL)) I=514			#IF ON, DIFFERENT.
	CFLAG(CEVCND)=.FALSE.			#DISABLE COUNTDOWN.
	OFLAG1(CANDL)=AND(OFLAG1(CANDL),NOT(ONBT))
	CALL RSPEAK(I)
	RETURN
#
19200	IF((PRSA.NE.BURNW).AND.(PRSA.NE.TRNONW)) GO TO 10
	IF(AND(OFLAG1(CANDL),LITEBT).NE.0) GO TO 19300
	CALL RSPEAK(515)			#CANDLES TOO SHORT.
	RETURN
#
19300	IF(PRSI.NE.0) GO TO 19400		#ANY FLAME?
	CALL RSPEAK(516)			#NO, LOSE.
	PRSWON=.FALSE.
	RETURN
#
19400	IF((PRSI.NE.MATCH).OR. .NOT.QON(MATCH)) GO TO 19500
	I=517					#ASSUME OFF.
	IF(QON(CANDL)) I=518			#IF ON, JOKE.
	OFLAG1(CANDL)=OFLAG1(CANDL).OR.ONBT	#LITE CANDLES.
	CFLAG(CEVCND)=.TRUE.			#RESUME COUNTDOWN.
	CALL RSPEAK(I)
	RETURN
#
19500	IF((PRSI.NE.TORCH).OR. .NOT.QON(TORCH)) GO TO 19600
	IF(QON(CANDL)) GO TO 19700		#ALREADY ON?
	CALL NEWSTA(CANDL,521,0,0,0)		#NO, VAPORIZE.
	RETURN
#
19600	CALL RSPEAK(519)			#CANT LIGHT WITH THAT.
	RETURN
#
19700	CALL RSPEAK(520)			#ALREADY ON.
	RETURN
#
20000	IF(OBJ.NE.MATCH) CALL BUG(6,OBJ)
	IF((PRSA.NE.TRNONW).OR.(PRSO.NE.MATCH)) GO TO 20500
	IF(ORMTCH.NE.0) GO TO 20100		#ANY MATCHES LEFT?
	CALL RSPEAK(183)			#NO, LOSE.
	RETURN
#
20100	ORMTCH=ORMTCH-1				#DECREMENT NO MATCHES.
	OFLAG1(MATCH)=OFLAG1(MATCH).OR.FLOBTS
	CTICK(CEVMAT)=2				#COUNTDOWN.
	CALL RSPEAK(184)
	RETURN
#
20500	IF((PRSA.NE.TRNOFW).OR.(AND(OFLAG1(MATCH),ONBT).EQ.0))
		GO TO 10			#EXTINGUISH?
	OFLAG1(MATCH)=AND(OFLAG1(MATCH),NOT(FLOBTS))
	CTICK(CEVMAT)=0
	CALL RSPEAK(185)
	RETURN
#
# HERE FOR FALSE RETURN
#
10	LIGHTP=.FALSE.
	RETURN
	END

# TROLLP-	TROLL FUNCTION
#
# DECLARATIONS
#
	LOGICAL FUNCTION TROLLP(ARG)
	IMPLICIT INTEGER (A-Z)
	LOGICAL QHERE,PROB
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
	COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
	COMMON /OINDEX/ WATER,ROPE,KNIFE,SWORD,LAMP,BLAMP,RUG
	COMMON /OINDEX/	LEAVE,TROLL,AXE
	COMMON /OINDEX/ RKNIF,KEYS,ICE,BAR
	COMMON /OINDEX/ COFFI,TORCH,TBASK,FBASK,IRBOX
	COMMON /OINDEX/ GHOST,TRUNK,BELL,BOOK,CANDL
	COMMON /OINDEX/ MATCH,TUBE,PUTTY,WRENC,SCREW,CYCLO,CHALI
	COMMON /OINDEX/ THIEF,STILL,WINDO,GRATE,DOOR
	COMMON /OINDEX/ HPOLE,LEAK,RBUTT,RAILI
	COMMON /OINDEX/ POT,STATU,IBOAT,DBOAT,PUMP,RBOAT
	COMMON /OINDEX/ STICK,BUOY,SHOVE,BALLO,RECEP,GUANO
	COMMON /OINDEX/ BROPE,HOOK1,HOOK2,SAFE,SSLOT,BRICK,FUSE
	COMMON /OINDEX/ GNOME,BLABE,DBALL,TOMB
	COMMON /OINDEX/ LCASE,CAGE,RCAGE,SPHER,SQBUT
	COMMON /OINDEX/ FLASK,POOL,SAFFR,BUCKE,ECAKE,ORICE,RDICE,BLICE
	COMMON /OINDEX/ ROBOT,FTREE,BILLS,PORTR,SCOL,ZGNOM
	COMMON /OINDEX/ EGG,BEGG,BAUBL,CANAR,BCANA
	COMMON /OINDEX/ YLWAL,RDWAL,PINDR,RBEAM
	COMMON /OINDEX/ ODOOR,QDOOR,CDOOR,NUM1,NUM8
	COMMON /OINDEX/ HANDS,WALL,LUNGS,SAILO,AVIAT,TEETH
	COMMON /OINDEX/ ITOBJ,EVERY,VALUA,OPLAY,WNORT,GWATE,MASTER
#
# VERBS
#
	COMMON /VINDEX/ CINTW,DEADXW,FRSTQW,INXW,OUTXW
	COMMON /VINDEX/ WALKIW,FIGHTW,FOOW
	COMMON /VINDEX/ MELTW,READW,INFLAW,DEFLAW,ALARMW,EXORCW
	COMMON /VINDEX/ PLUGW,KICKW,WAVEW,RAISEW,LOWERW,RUBW
	COMMON /VINDEX/ PUSHW,UNTIEW,TIEW,TIEUPW,TURNW,BREATW
	COMMON /VINDEX/ KNOCKW,LOOKW,EXAMIW,SHAKEW,MOVEW,TRNONW,TRNOFW
	COMMON /VINDEX/ OPENW,CLOSEW,FINDW,WAITW,SPINW,BOARDW,UNBOAW,TAKEW
	COMMON /VINDEX/ INVENW,FILLW,EATW,DRINKW,BURNW
	COMMON /VINDEX/ MUNGW,KILLW,ATTACW,SWINGW
	COMMON /VINDEX/ WALKW,TELLW,PUTW,DROPW,GIVEW,POURW,THROWW
	COMMON /VINDEX/ DIGW,LEAPW,STAYW,FOLLOW
	COMMON /VINDEX/ HELLOW,LOOKIW,LOOKUW,PUMPW,WINDW
	COMMON /VINDEX/ CLMBW,CLMBUW,CLMBDW,TRNTOW
#
# FLAGS
#
	LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL FOLLWF,SPELLF,sprf
	COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
		DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
		MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
			EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
		GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
		GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
		MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
		follwf,spellf,sprf(6)
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL

# TROLLP, PAGE 2
#
	TROLLP=.TRUE.				#ASSUME WINS.
	IF(PRSA.NE.FIGHTW) GO TO 1100		#FIGHT?
	IF(OCAN(AXE).EQ.TROLL) GO TO 10		#GOT AXE?  NOTHING.
	I=433					#ASSUME CANT GET.
	IF(.NOT.QHERE(AXE,HERE)) GO TO 1050	#HERE?
	I=434					#YES, RECOVER.
	CALL NEWSTA(AXE,0,0,TROLL,0)
1050	IF(QHERE(TROLL,HERE)) CALL RSPEAK(I)	#IF PLAYER HERE.
	RETURN
#
1100	IF(PRSA.NE.DEADXW) GO TO 1200		#DEAD?
	TROLLF=.TRUE.				#PERMIT EXITS.
	RETURN
#
1200	IF(PRSA.NE.OUTXW) GO TO 1300		#OUT?
	TROLLF=.TRUE.				#PERMIT EXITS.
	OFLAG1(AXE)=AND(OFLAG1(AXE),NOT(VISIBT))
	ODESC1(TROLL)=435			#TROLL OUT.
	RETURN
#
1300	IF(PRSA.NE.INXW) GO TO 1400		#WAKE UP?
	TROLLF=.FALSE.				#FORBID EXITS.
	OFLAG1(AXE)=OR(OFLAG1(AXE),VISIBT)
	ODESC1(TROLL)=436			#TROLL IN.
	IF(QHERE(TROLL,HERE)) CALL RSPEAK(437)
	RETURN
#
1400	IF(PRSA.NE.FRSTQW) GO TO 1500		#FIRST ENCOUNTER?
	TROLLP=PROB(33,66)		#33% TRUE UNLESS BADLK.
	RETURN
#
1500	IF((PRSA.NE.MOVEW).AND.(PRSA.NE.TAKEW).AND.(PRSA.NE.MUNGW)
		.AND.(PRSA.NE.THROWW).AND.(PRSA.NE.GIVEW)) GO TO 2000
	IF(OCAPAC(TROLL).GE.0) GO TO 1550	#TROLL OUT?
	OCAPAC(TROLL)=-OCAPAC(TROLL)		#YES, WAKE HIM.
	OFLAG1(AXE)=OFLAG1(AXE).OR.VISIBT
	TROLLF=.FALSE.
	ODESC1(TROLL)=436
	CALL RSPEAK(437)
#
1550	IF((PRSA.NE.TAKEW).AND.(PRSA.NE.MOVEW)) GO TO 1600
	CALL RSPEAK(438)			#JOKE.
	RETURN
#
1600	IF(PRSA.NE.MUNGW) GO TO 1700		#MUNG?
	CALL RSPEAK(439)			#JOKE.
	RETURN
#
1700	IF(PRSO.EQ.0) GO TO 10			#NO OBJECT?
	I=440					#ASSUME THROW.
	IF(PRSA.EQ.GIVEW) I=441			#GIVE?
	CALL RSPSUB(I,ODESC2(PRSO))		#TROLL TAKES.
	IF(PRSO.EQ.KNIFE) GO TO 1900		#OBJ KNIFE?
	CALL NEWSTA(PRSO,442,0,0,0)		#NO, EATS IT.
	RETURN
#
1900	CALL RSPEAK(443)			#KNIFE, THROWS IT BACK
	OFLAG2(TROLL)=OFLAG2(TROLL).OR.FITEBT	#AND GETS MAD.
	RETURN
#
2000	IF(.NOT.TROLLF.OR.(PRSA.NE.HELLOW)) GO TO 10
	CALL RSPEAK(366)			#TROLL OUT.
	RETURN
#
10	TROLLP=.FALSE.				#COULDNT HANDLE IT.
	RETURN
	END

# CYCLOP-	CYCLOPS FUNCTION
#
# DECLARATIONS
#
	LOGICAL FUNCTION CYCLOP(ARG)
	IMPLICIT INTEGER (A-Z)
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
	COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
	COMMON /OINDEX/ WATER,ROPE,KNIFE,SWORD,LAMP,BLAMP,RUG
	COMMON /OINDEX/	LEAVE,TROLL,AXE
	COMMON /OINDEX/ RKNIF,KEYS,ICE,BAR
	COMMON /OINDEX/ COFFI,TORCH,TBASK,FBASK,IRBOX
	COMMON /OINDEX/ GHOST,TRUNK,BELL,BOOK,CANDL
	COMMON /OINDEX/ MATCH,TUBE,PUTTY,WRENC,SCREW,CYCLO,CHALI
	COMMON /OINDEX/ THIEF,STILL,WINDO,GRATE,DOOR
	COMMON /OINDEX/ HPOLE,LEAK,RBUTT,RAILI
	COMMON /OINDEX/ POT,STATU,IBOAT,DBOAT,PUMP,RBOAT
	COMMON /OINDEX/ STICK,BUOY,SHOVE,BALLO,RECEP,GUANO
	COMMON /OINDEX/ BROPE,HOOK1,HOOK2,SAFE,SSLOT,BRICK,FUSE
	COMMON /OINDEX/ GNOME,BLABE,DBALL,TOMB
	COMMON /OINDEX/ LCASE,CAGE,RCAGE,SPHER,SQBUT
	COMMON /OINDEX/ FLASK,POOL,SAFFR,BUCKE,ECAKE,ORICE,RDICE,BLICE
	COMMON /OINDEX/ ROBOT,FTREE,BILLS,PORTR,SCOL,ZGNOM
	COMMON /OINDEX/ EGG,BEGG,BAUBL,CANAR,BCANA
	COMMON /OINDEX/ YLWAL,RDWAL,PINDR,RBEAM
	COMMON /OINDEX/ ODOOR,QDOOR,CDOOR,NUM1,NUM8
	COMMON /OINDEX/ HANDS,WALL,LUNGS,SAILO,AVIAT,TEETH
	COMMON /OINDEX/ ITOBJ,EVERY,VALUA,OPLAY,WNORT,GWATE,MASTER
#
# VERBS
#
	COMMON /VINDEX/ CINTW,DEADXW,FRSTQW,INXW,OUTXW
	COMMON /VINDEX/ WALKIW,FIGHTW,FOOW
	COMMON /VINDEX/ MELTW,READW,INFLAW,DEFLAW,ALARMW,EXORCW
	COMMON /VINDEX/ PLUGW,KICKW,WAVEW,RAISEW,LOWERW,RUBW
	COMMON /VINDEX/ PUSHW,UNTIEW,TIEW,TIEUPW,TURNW,BREATW
	COMMON /VINDEX/ KNOCKW,LOOKW,EXAMIW,SHAKEW,MOVEW,TRNONW,TRNOFW
	COMMON /VINDEX/ OPENW,CLOSEW,FINDW,WAITW,SPINW,BOARDW,UNBOAW,TAKEW
	COMMON /VINDEX/ INVENW,FILLW,EATW,DRINKW,BURNW
	COMMON /VINDEX/ MUNGW,KILLW,ATTACW,SWINGW
	COMMON /VINDEX/ WALKW,TELLW,PUTW,DROPW,GIVEW,POURW,THROWW
	COMMON /VINDEX/ DIGW,LEAPW,STAYW,FOLLOW
	COMMON /VINDEX/ HELLOW,LOOKIW,LOOKUW,PUMPW,WINDW
	COMMON /VINDEX/ CLMBW,CLMBUW,CLMBDW,TRNTOW
#
# FLAGS
#
	LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL FOLLWF,SPELLF,sprf
	COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
		DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
		MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
			EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
		GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
		GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
		MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
		follwf,spellf,sprf(6)
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL

# CYCLOP, PAGE 2
#
	CYCLOP=.TRUE.				#ASSUME WINS.
	IF(.NOT.CYCLOF) GO TO 100		#ASLEEP?
	IF((PRSA.NE.ALARMW).AND.(PRSA.NE.MUNGW).AND.(PRSA.NE.HELLOW).AND.
		(PRSA.NE.BURNW).AND.(PRSA.NE.KILLW).AND.(PRSA.NE.ATTACW))
		 GO TO 10
	CYCLOF=.FALSE.			#WAKE CYCLOPS.
	CALL RSPEAK(187)			#DESCRIBE.
	RVCYC=IABS(RVCYC)
	OFLAG2(CYCLO)=AND(OR(OFLAG2(CYCLO),FITEBT),NOT(SLEPBT))
	RETURN
#
100	IF((PRSA.EQ.FIGHTW).OR.(PRSA.EQ.FRSTQW)) GO TO 10
	IF(IABS(RVCYC).LE.5) GO TO 200		#ANNOYED TOO MUCH?
	RVCYC=0					#RESTART COUNT.
	CALL JIGSUP(188)			#YES, EATS PLAYER.
	RETURN
#
200	IF(PRSA.NE.GIVEW) GO TO 500		#GIVE?
	IF((PRSO.NE.FOOD).OR.(RVCYC.LT.0)) GO TO 300	#FOOD WHEN HUNGRY?
	CALL NEWSTA(FOOD,189,0,0,0)		#EATS PEPPERS.
	RVCYC=MIN0(-1,-RVCYC)			#GETS THIRSTY.
	RETURN
#
300	IF(PRSO.NE.WATER) GO TO 400		#DRINK WHEN THIRSTY?
	IF(RVCYC.GE.0) GO TO 350
	CALL NEWSTA(PRSO,190,0,0,0)		#DRINKS AND
	CYCLOF=.TRUE.				#FALLS ASLEEP.
	OFLAG2(CYCLO)=AND(OR(OFLAG2(CYCLO),SLEPBT),NOT(FITEBT))
	RETURN
#
350	CALL RSPEAK(191)			#NOT THIRSTY.
10	CYCLOP=.FALSE.				#FAILS.
	RETURN
#
400	I=192					#ASSUME INEDIBLE.
	IF(PRSO.EQ.GARLI) I=193			#GARLIC IS JOKE.
450	CALL RSPEAK(I)				#DISDAIN IT.
	IF(RVCYC.LT.0) RVCYC=RVCYC-1
	IF(RVCYC.GE.0) RVCYC=RVCYC+1
	IF(.NOT.CYCLOF) CALL RSPEAK(193+IABS(RVCYC))
	RETURN
#
500	I=0					#ASSUME NOT HANDLED.
	IF(PRSA.EQ.HELLOW) GO TO 450		#HELLO IS NO GO.
	IF((PRSA.EQ.THROWW).OR.(PRSA.EQ.MUNGW)) I=200+RND(2)
	IF(PRSA.EQ.TAKEW) I=202
	IF(PRSA.EQ.TIEW) I=203
	IF(I) 10,10,450			#SEE IF HANDLED.
#
	END

# THIEFP-	THIEF FUNCTION
#
# DECLARATIONS
#
	LOGICAL FUNCTION THIEFP(ARG)
	IMPLICIT INTEGER (A-Z)
	LOGICAL QHERE,PROB
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
#
# ROOMS
#
	COMMON /RINDEX/ WHOUS,LROOM,CELLA
	COMMON /RINDEX/ MTROL,MAZE1	
	COMMON /RINDEX/ MGRAT,MAZ15	
	COMMON /RINDEX/ FORE1,FORE3,CLEAR,RESER
	COMMON /RINDEX/ STREA,EGYPT,ECHOR
	COMMON /RINDEX/ TSHAF	
	COMMON /RINDEX/ BSHAF,MMACH,DOME,MTORC
	COMMON /RINDEX/ CAROU	
	COMMON /RINDEX/ RIDDL,LLD2,TEMP1,TEMP2,MAINT
	COMMON /RINDEX/ BLROO,TREAS,RIVR1,RIVR2,RIVR3,MCYCL
	COMMON /RINDEX/ RIVR4,RIVR5,FCHMP,FALLS,MBARR
	COMMON /RINDEX/ MRAIN,POG,VLBOT,VAIR1,VAIR2,VAIR3,VAIR4
	COMMON /RINDEX/ LEDG2,LEDG3,LEDG4,MSAFE,CAGER
	COMMON /RINDEX/ CAGED,TWELL,BWELL,ALICE,ALISM,ALITR
	COMMON /RINDEX/ MTREE,BKENT,BKVW,BKTWI,BKVAU,BKBOX
	COMMON /RINDEX/ CRYPT,TSTRS,MRANT,MREYE
	COMMON /RINDEX/ MRA,MRB,MRC,MRG,MRD,FDOOR
	COMMON /RINDEX/ MRAE,MRCE,MRCW,MRGE,MRGW,MRDW,INMIR
	COMMON /RINDEX/ SCORR,NCORR,PARAP,CELL,PCELL,NCELL
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
	COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
	COMMON /OINDEX/ WATER,ROPE,KNIFE,SWORD,LAMP,BLAMP,RUG
	COMMON /OINDEX/	LEAVE,TROLL,AXE
	COMMON /OINDEX/ RKNIF,KEYS,ICE,BAR
	COMMON /OINDEX/ COFFI,TORCH,TBASK,FBASK,IRBOX
	COMMON /OINDEX/ GHOST,TRUNK,BELL,BOOK,CANDL
	COMMON /OINDEX/ MATCH,TUBE,PUTTY,WRENC,SCREW,CYCLO,CHALI
	COMMON /OINDEX/ THIEF,STILL,WINDO,GRATE,DOOR
	COMMON /OINDEX/ HPOLE,LEAK,RBUTT,RAILI
	COMMON /OINDEX/ POT,STATU,IBOAT,DBOAT,PUMP,RBOAT
	COMMON /OINDEX/ STICK,BUOY,SHOVE,BALLO,RECEP,GUANO
	COMMON /OINDEX/ BROPE,HOOK1,HOOK2,SAFE,SSLOT,BRICK,FUSE
	COMMON /OINDEX/ GNOME,BLABE,DBALL,TOMB
	COMMON /OINDEX/ LCASE,CAGE,RCAGE,SPHER,SQBUT
	COMMON /OINDEX/ FLASK,POOL,SAFFR,BUCKE,ECAKE,ORICE,RDICE,BLICE
	COMMON /OINDEX/ ROBOT,FTREE,BILLS,PORTR,SCOL,ZGNOM
	COMMON /OINDEX/ EGG,BEGG,BAUBL,CANAR,BCANA
	COMMON /OINDEX/ YLWAL,RDWAL,PINDR,RBEAM
	COMMON /OINDEX/ ODOOR,QDOOR,CDOOR,NUM1,NUM8
	COMMON /OINDEX/ HANDS,WALL,LUNGS,SAILO,AVIAT,TEETH
	COMMON /OINDEX/ ITOBJ,EVERY,VALUA,OPLAY,WNORT,GWATE,MASTER
#
# CLOCK INTERRUPTS
#
	LOGICAL CFLAG
	COMMON /CEVENT/ CLNT,CTICK(25),CACTIO(25),CFLAG(25)
#
	COMMON /CINDEX/ CEVCUR,CEVMNT,CEVLNT,CEVMAT,CEVCND,
		CEVBAL,CEVBRN,CEVFUS,CEVLED,CEVSAF,CEVVLG,
		CEVGNO,CEVBUC,CEVSPH,CEVEGH,
			CEVFOR,CEVSCL,CEVZGI,CEVZGO,CEVSTE,
		CEVMRS,CEVPIN,CEVINQ,CEVFOL

#
# VILLAINS AND DEMONS
#
	LOGICAL THFFLG,SWDACT,THFACT
	COMMON /HACK/ THFPOS,THFFLG,THFACT,SWDACT
#
# VERBS
#
	COMMON /VINDEX/ CINTW,DEADXW,FRSTQW,INXW,OUTXW
	COMMON /VINDEX/ WALKIW,FIGHTW,FOOW
	COMMON /VINDEX/ MELTW,READW,INFLAW,DEFLAW,ALARMW,EXORCW
	COMMON /VINDEX/ PLUGW,KICKW,WAVEW,RAISEW,LOWERW,RUBW
	COMMON /VINDEX/ PUSHW,UNTIEW,TIEW,TIEUPW,TURNW,BREATW
	COMMON /VINDEX/ KNOCKW,LOOKW,EXAMIW,SHAKEW,MOVEW,TRNONW,TRNOFW
	COMMON /VINDEX/ OPENW,CLOSEW,FINDW,WAITW,SPINW,BOARDW,UNBOAW,TAKEW
	COMMON /VINDEX/ INVENW,FILLW,EATW,DRINKW,BURNW
	COMMON /VINDEX/ MUNGW,KILLW,ATTACW,SWINGW
	COMMON /VINDEX/ WALKW,TELLW,PUTW,DROPW,GIVEW,POURW,THROWW
	COMMON /VINDEX/ DIGW,LEAPW,STAYW,FOLLOW
	COMMON /VINDEX/ HELLOW,LOOKIW,LOOKUW,PUMPW,WINDW
	COMMON /VINDEX/ CLMBW,CLMBUW,CLMBDW,TRNTOW
#
# FLAGS
#
	LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL FOLLWF,SPELLF,sprf
	COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
		DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
		MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
			EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
		GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
		GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
		MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
		follwf,spellf,sprf(6)
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL

# THIEFP, PAGE 2
#
	THIEFP=.TRUE.				#ASSUME WINS.
	IF(PRSA.NE.FIGHTW) GO TO 100		#FIGHT?
	IF(OCAN(STILL).EQ.THIEF) GO TO 10	#GOT STILLETTO?  F.
	IF(QHERE(STILL,THFPOS)) GO TO 50	#CAN HE RECOVER IT?
	CALL NEWSTA(THIEF,0,0,0,0)		#NO, VANISH.
	IF(QHERE(THIEF,HERE)) CALL RSPEAK(498)	#IF HERO, TELL.
	RETURN
#
50	CALL NEWSTA(STILL,0,0,THIEF,0)		#YES, RECOVER.
	IF(QHERE(THIEF,HERE)) CALL RSPEAK(499)	#IF HERO, TELL.
	RETURN
#
100	IF(PRSA.NE.DEADXW) GO TO 200		#DEAD?
	THFACT=.FALSE.				#DISABLE DEMON.
	OFLAG1(CHALI)=OFLAG1(CHALI).OR.TAKEBT
	J=0
	DO I=1,OLNT {				#CARRYING ANYTHING?
	  IF(OADV(I).EQ.-THIEF) J=500
	  }

	CALL RSPEAK(J)				#TELL IF BOOTY REAPPEARS.
#
	J=501
	DO I=1,OLNT {				#LOOP.
	  IF((I.EQ.CHALI).OR.(I.EQ.THIEF).OR.(HERE.NE.TREAS)
		.OR. .NOT.QHERE(I,HERE)) GO TO 135
	  OFLAG1(I)=OFLAG1(I).OR.VISIBT		#REMATERIALIZE OBJECTS.
	  CALL RSPSUB(J,ODESC2(I))		#DESCRIBE.
	  J=502
	  NEXT
#
135	  IF(OADV(I).EQ.-THIEF) CALL NEWSTA(I,0,HERE,0,0)
	  }
	RETURN
#
200	IF(PRSA.NE.FRSTQW) GO TO 250		#FIRST ENCOUNTER?
	THIEFP=PROB(20,75)
	RETURN
#
250	IF((PRSA.NE.HELLOW).OR.(ODESC1(THIEF).NE.504))
		GO TO 300			#HELLO TO OUT THIEF?
	CALL RSPEAK(626)
	RETURN
#
300	IF(PRSA.NE.OUTXW) GO TO 400		#OUT?
	THFACT=.FALSE.				#DISABLE DEMON.
	ODESC1(THIEF)=504			#CHANGE DESCRIPTION.
	OFLAG1(STILL)=AND(OFLAG1(STILL),NOT(VISIBT))
	OFLAG1(CHALI)=OR(OFLAG1(CHALI),TAKEBT)
	RETURN
#
400	IF(PRSA.NE.INXW) GO TO 500		#IN?
	IF(QHERE(THIEF,HERE)) CALL RSPEAK(505)	#CAN HERO SEE?
	THFACT=.TRUE.				#ENABLE DEMON.
	ODESC1(THIEF)=503			#CHANGE DESCRIPTION.
	OFLAG1(STILL)=OR(OFLAG1(STILL),VISIBT)
	IF((HERE.EQ.TREAS).AND.QHERE(CHALI,HERE))
		OFLAG1(CHALI)=AND(OFLAG1(CHALI),NOT(TAKEBT))
	RETURN
#
500	IF(PRSA.NE.TAKEW) GO TO 600		#TAKE?
	CALL RSPEAK(506)			#JOKE.
	RETURN
#
600	IF((PRSA.NE.THROWW).OR.(PRSO.NE.KNIFE).OR.
		(AND(OFLAG2(THIEF),FITEBT).NE.0)) GO TO 700
	IF(PROB(10)) GO TO 650			#THREW KNIFE, 10%?
	CALL RSPEAK(507)			#NO, JUST MAKES
	OFLAG2(THIEF)=OFLAG2(THIEF).OR.FITEBT	#THIEF MAD.
	RETURN
#
650	J=508					#THIEF DROPS STUFF.
	DO I=1,OLNT {
	  IF(OADV(I).NE.-THIEF) NEXT		#THIEF CARRYING?
	  J=509
	  CALL NEWSTA(I,0,HERE,0,0)
	  }
	CALL NEWSTA(THIEF,J,0,0,0)		#THIEF VANISHES.
	RETURN
#
700	IF(((PRSA.NE.THROWW).AND.(PRSA.NE.GIVEW)).OR.(PRSO.EQ.0).OR.
		(PRSO.EQ.THIEF)) GO TO 10	#THRO/GIVE TO THIEF?
	IF(OCAPAC(THIEF).GE.0) GO TO 750	#WAKE HIM UP.
	OCAPAC(THIEF)=-OCAPAC(THIEF)
	THFACT=.TRUE.
	OFLAG1(STILL)=OR(OFLAG1(STILL),VISIBT)
	ODESC1(THIEF)=503
	CALL RSPEAK(510)
#
750	IF((PRSO.NE.BRICK).OR.(OCAN(FUSE).NE.BRICK).OR.
		(CTICK(CEVFUS).EQ.0)) GO TO 800
	CALL RSPEAK(511)			#THIEF REFUSES BOMB.
	RETURN
#
800	CALL NEWSTA(PRSO,0,0,0,-THIEF)		#THIEF TAKES GIFT.
	IF(OTVAL(PRSO).GT.0) GO TO 900		#A TREASURE?
	CALL RSPSUB(512,ODESC2(PRSO))
	RETURN
#
900	CALL RSPSUB(627,ODESC2(PRSO))		#THIEF ENGROSSED.
	THFENF=.TRUE.
	RETURN
#
10	THIEFP=.FALSE.
	RETURN
	END

# RAPPL2- SPECIAL PURPOSE ROOM ROUTINES, PART 2
#
# DECLARATIONS
#
	LOGICAL FUNCTION RAPPL2(RI)
	IMPLICIT INTEGER (A-Z)
	LOGICAL QOPEN,QHERE,F
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
	COMMON /STATE/ MOVES,DEATHS,RWSCOR,MXSCOR,MXLOAD,
		LTSHFT,BLOC,MUNGRM,HS,EGSCOR,EGMXSC
#
# MISCELLANEOUS VARIABLES
#
	COMMON /CHAN/ INPCH,OUTCH,DBCH
#
# ROOMS
#
	COMMON /ROOMS/ RLNT,RDESC2,RDESC1(215),REXIT(215),
		RACTIO(215),RVAL(215),RFLAG(215)
	INTEGER RRAND(215)
	EQUIVALENCE (RVAL,RRAND)
#
	COMMON /RFLAG/ RSEEN,RLIGHT,RLAND,RWATER,RAIR,
		RSACRD,RFILL,RMUNG,RBUCK,RHOUSE,RNWALL,REND
#
	COMMON /RINDEX/ WHOUS,LROOM,CELLA
	COMMON /RINDEX/ MTROL,MAZE1	
	COMMON /RINDEX/ MGRAT,MAZ15	
	COMMON /RINDEX/ FORE1,FORE3,CLEAR,RESER
	COMMON /RINDEX/ STREA,EGYPT,ECHOR
	COMMON /RINDEX/ TSHAF	
	COMMON /RINDEX/ BSHAF,MMACH,DOME,MTORC
	COMMON /RINDEX/ CAROU	
	COMMON /RINDEX/ RIDDL,LLD2,TEMP1,TEMP2,MAINT
	COMMON /RINDEX/ BLROO,TREAS,RIVR1,RIVR2,RIVR3,MCYCL
	COMMON /RINDEX/ RIVR4,RIVR5,FCHMP,FALLS,MBARR
	COMMON /RINDEX/ MRAIN,POG,VLBOT,VAIR1,VAIR2,VAIR3,VAIR4
	COMMON /RINDEX/ LEDG2,LEDG3,LEDG4,MSAFE,CAGER
	COMMON /RINDEX/ CAGED,TWELL,BWELL,ALICE,ALISM,ALITR
	COMMON /RINDEX/ MTREE,BKENT,BKVW,BKTWI,BKVAU,BKBOX
	COMMON /RINDEX/ CRYPT,TSTRS,MRANT,MREYE
	COMMON /RINDEX/ MRA,MRB,MRC,MRG,MRD,FDOOR
	COMMON /RINDEX/ MRAE,MRCE,MRCW,MRGE,MRGW,MRDW,INMIR
	COMMON /RINDEX/ SCORR,NCORR,PARAP,CELL,PCELL,NCELL
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
	COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
	COMMON /OINDEX/ WATER,ROPE,KNIFE,SWORD,LAMP,BLAMP,RUG
	COMMON /OINDEX/	LEAVE,TROLL,AXE
	COMMON /OINDEX/ RKNIF,KEYS,ICE,BAR
	COMMON /OINDEX/ COFFI,TORCH,TBASK,FBASK,IRBOX
	COMMON /OINDEX/ GHOST,TRUNK,BELL,BOOK,CANDL
	COMMON /OINDEX/ MATCH,TUBE,PUTTY,WRENC,SCREW,CYCLO,CHALI
	COMMON /OINDEX/ THIEF,STILL,WINDO,GRATE,DOOR
	COMMON /OINDEX/ HPOLE,LEAK,RBUTT,RAILI
	COMMON /OINDEX/ POT,STATU,IBOAT,DBOAT,PUMP,RBOAT
	COMMON /OINDEX/ STICK,BUOY,SHOVE,BALLO,RECEP,GUANO
	COMMON /OINDEX/ BROPE,HOOK1,HOOK2,SAFE,SSLOT,BRICK,FUSE
	COMMON /OINDEX/ GNOME,BLABE,DBALL,TOMB
	COMMON /OINDEX/ LCASE,CAGE,RCAGE,SPHER,SQBUT
	COMMON /OINDEX/ FLASK,POOL,SAFFR,BUCKE,ECAKE,ORICE,RDICE,BLICE
	COMMON /OINDEX/ ROBOT,FTREE,BILLS,PORTR,SCOL,ZGNOM
	COMMON /OINDEX/ EGG,BEGG,BAUBL,CANAR,BCANA
	COMMON /OINDEX/ YLWAL,RDWAL,PINDR,RBEAM
	COMMON /OINDEX/ ODOOR,QDOOR,CDOOR,NUM1,NUM8
	COMMON /OINDEX/ HANDS,WALL,LUNGS,SAILO,AVIAT,TEETH
	COMMON /OINDEX/ ITOBJ,EVERY,VALUA,OPLAY,WNORT,GWATE,MASTER
#
# CLOCK INTERRUPTS
#
	LOGICAL CFLAG
	COMMON /CEVENT/ CLNT,CTICK(25),CACTIO(25),CFLAG(25)
#
	COMMON /CINDEX/ CEVCUR,CEVMNT,CEVLNT,CEVMAT,CEVCND,
		CEVBAL,CEVBRN,CEVFUS,CEVLED,CEVSAF,CEVVLG,
		CEVGNO,CEVBUC,CEVSPH,CEVEGH,
			CEVFOR,CEVSCL,CEVZGI,CEVZGO,CEVSTE,
		CEVMRS,CEVPIN,CEVINQ,CEVFOL

#
	COMMON /AINDEX/ PLAYER,AROBOT,AMASTR
#
# VERBS
#
	COMMON /VINDEX/ CINTW,DEADXW,FRSTQW,INXW,OUTXW
	COMMON /VINDEX/ WALKIW,FIGHTW,FOOW
	COMMON /VINDEX/ MELTW,READW,INFLAW,DEFLAW,ALARMW,EXORCW
	COMMON /VINDEX/ PLUGW,KICKW,WAVEW,RAISEW,LOWERW,RUBW
	COMMON /VINDEX/ PUSHW,UNTIEW,TIEW,TIEUPW,TURNW,BREATW
	COMMON /VINDEX/ KNOCKW,LOOKW,EXAMIW,SHAKEW,MOVEW,TRNONW,TRNOFW
	COMMON /VINDEX/ OPENW,CLOSEW,FINDW,WAITW,SPINW,BOARDW,UNBOAW,TAKEW
	COMMON /VINDEX/ INVENW,FILLW,EATW,DRINKW,BURNW
	COMMON /VINDEX/ MUNGW,KILLW,ATTACW,SWINGW
	COMMON /VINDEX/ WALKW,TELLW,PUTW,DROPW,GIVEW,POURW,THROWW
	COMMON /VINDEX/ DIGW,LEAPW,STAYW,FOLLOW
	COMMON /VINDEX/ HELLOW,LOOKIW,LOOKUW,PUMPW,WINDW
	COMMON /VINDEX/ CLMBW,CLMBUW,CLMBDW,TRNTOW
#
# FLAGS
#
	LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL FOLLWF,SPELLF,sprf
	COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
		DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
		MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
			EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
		GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
		GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
		MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
		follwf,spellf,sprf(6)
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL
#
# FUNCTIONS AND DATA
#
	QOPEN(R)=AND(OFLAG2(R),OPENBT).NE.0
	DATA NEWRMS/38/

# RAPPL2, PAGE 2
#
	RAPPL2=.TRUE.
	GO TO (38000,39000,40000,41000,42000,43000,44000,
		45000,46000,47000,48000,49000,50000,
		51000,52000,53000,54000,55000,56000,
			57000,58000),
		(RI-NEWRMS+1)
	CALL BUG(70,RI)
	RETURN
#
# R38--	MIRROR D ROOM
#
38000	IF(PRSA.EQ.LOOKW) CALL LOOKTO(FDOOR,MRG,0,682,681)
	RETURN
#
# R39--	MIRROR G ROOM
#
39000	IF(PRSA.EQ.WALKIW) CALL JIGSUP(685)
	RETURN
#
# R40--	MIRROR C ROOM
#
40000	IF(PRSA.EQ.LOOKW) CALL LOOKTO(MRG,MRB,683,0,681)
	RETURN
#
# R41--	MIRROR B ROOM
#
41000	IF(PRSA.EQ.LOOKW) CALL LOOKTO(MRC,MRA,0,0,681)
	RETURN
#
# R42--	MIRROR A ROOM
#
42000	IF(PRSA.EQ.LOOKW) CALL LOOKTO(MRB,0,0,684,681)
	RETURN

# RAPPL2, PAGE 3
#
# R43--	MIRROR C EAST/WEST
#
43000	IF(PRSA.EQ.LOOKW) CALL EWTELL(HERE,683)
	RETURN
#
# R44--	MIRROR B EAST/WEST
#
44000	IF(PRSA.EQ.LOOKW) CALL EWTELL(HERE,686)
	RETURN
#
# R45--	MIRROR A EAST/WEST
#
45000	IF(PRSA.EQ.LOOKW) CALL EWTELL(HERE,687)
	RETURN
#
# R46--	INSIDE MIRROR
#
46000	IF(PRSA.NE.LOOKW) RETURN		#LOOK?
	CALL RSPEAK(688)			#DESCRIBE
#
# NOW DESCRIBE POLE STATE.
#
# CASES 1,2--	MDIR=270 & MLOC=MRB, POLE IS UP OR IN HOLE
# CASES 3,4--	MDIR=0 V MDIR=180, POLE IS UP OR IN CHANNEL
# CASE 5--	POLE IS UP
#
	I=689					#ASSUME CASE 5.
	IF((MDIR.EQ.270).AND.(MLOC.EQ.MRB))
		I=690+MIN0(POLEUF,1)		#CASES 1,2.
	IF(MOD(MDIR,180).EQ.0)
		I=692+MIN0(POLEUF,1)		#CASES 3,4.
	CALL RSPEAK(I)			#DESCRIBE POLE.
	CALL RSPSUB(694,695+(MDIR/45))		#DESCRIBE ARROW.
	RETURN

# RAPPL2, PAGE 4
#
# R47--	MIRROR EYE ROOM
#
47000	IF(PRSA.NE.LOOKW) RETURN		#LOOK?
	I=704					#ASSUME BEAM STOP.
	DO J=1,OLNT {
	  IF(QHERE(J,HERE).AND.(J.NE.RBEAM)) GO TO 47200
	  }
	I=703
47200	CALL RSPSUB(I,ODESC2(J))		#DESCRIBE BEAM.
	CALL LOOKTO(MRA,0,0,0,0)		#LOOK NORTH.
	RETURN
#
# R48--	INSIDE CRYPT
#
48000	IF(PRSA.NE.LOOKW) RETURN		#LOOK?
	I=46					#CRYPT IS OPEN/CLOSED.
	IF(QOPEN(TOMB)) I=12
	CALL RSPSUB(705,I)
	RETURN
#
# R49--	SOUTH CORRIDOR
#
49000	IF(PRSA.NE.LOOKW) RETURN		#LOOK?
	CALL RSPEAK(706)			#DESCRIBE.
	I=46					#ODOOR IS OPEN/CLOSED.
	IF(QOPEN(ODOOR)) I=12
	IF(LCELL.EQ.4) CALL RSPSUB(707,I)	#DESCRIBE ODOOR IF THERE.
	RETURN
#
# R50--	BEHIND DOOR
#
50000	IF(PRSA.NE.WALKIW) GO TO 50100		#WALK IN?
	CFLAG(CEVFOL)=.TRUE.			#MASTER FOLLOWS.
	CTICK(CEVFOL)=-1
	RETURN
#
50100	IF(PRSA.NE.LOOKW) RETURN		#LOOK?
	I=46					#QDOOR IS OPEN/CLOSED.
	IF(QOPEN(QDOOR)) I=12
	CALL RSPSUB(708,I)
	RETURN

# RAPPL2, PAGE 5
#
# R51--	FRONT DOOR
#
51000	IF(PRSA.EQ.WALKIW) CTICK(CEVFOL)=0	#IF EXITS, KILL FOLLOW.
	IF(PRSA.NE.LOOKW) RETURN		#LOOK?
	CALL LOOKTO(0,MRD,709,0,0)		#DESCRIBE SOUTH.
	I=46					#PANEL IS OPEN/CLOSED.
	IF(INQSTF) I=12				#OPEN IF INQ STARTED.
	J=46					#QDOOR IS OPEN/CLOSED.
	IF(QOPEN(QDOOR)) J=12
	CALL RSPSB2(710,I,J)
	RETURN
#
# R52--	NORTH CORRIDOR
#
52000	IF(PRSA.NE.LOOKW) RETURN		#LOOK?
	I=46
	IF(QOPEN(CDOOR)) I=12			#CDOOR IS OPEN/CLOSED.
	CALL RSPSUB(711,I)
	RETURN
#
# R53--	PARAPET
#
53000	IF(PRSA.EQ.LOOKW) CALL RSPSUB(712,712+PNUMB)
	RETURN
#
# R54--	CELL
#
54000	IF(PRSA.NE.LOOKW) RETURN		#LOOK?
	I=721					#CDOOR IS OPEN/CLOSED.
	IF(QOPEN(CDOOR)) I=722
	CALL RSPEAK(I)
	I=46					#ODOOR IS OPEN/CLOSED.
	IF(QOPEN(ODOOR)) I=12
	IF(LCELL.EQ.4) CALL RSPSUB(723,I)	#DESCRIBE.
	RETURN
#
# R55--	PRISON CELL
#
55000	IF(PRSA.EQ.LOOKW) CALL RSPEAK(724)	#LOOK?
	RETURN
#
# R56--	NIRVANA CELL
#
56000	IF(PRSA.NE.LOOKW) RETURN		#LOOK?
	I=46					#ODOOR IS OPEN/CLOSED.
	IF(QOPEN(ODOOR)) I=12
	CALL RSPSUB(725,I)
	RETURN
#
# R57--	NIRVANA AND END OF GAME
#
57000	IF(PRSA.NE.WALKIW) RETURN		#WALKIN?
	CALL RSPEAK(726)
	CALL SCORE(.FALSE.)
	CLOSE(UNIT=DBCH,DISPOSE='SAVE')
	CALL EXIT
#
# R58--	TOMB ROOM
#
58000	IF(PRSA.NE.LOOKW) RETURN		#LOOK?
	I=46					#TOMB IS OPEN/CLOSED.
	IF(QOPEN(TOMB)) I=12
	CALL RSPSUB(792,I)
	RETURN
#
	END

# LOOKTO--	DESCRIBE VIEW IN MIRROR HALLWAY
#
# DECLARATIONS
#
	SUBROUTINE LOOKTO(NRM,SRM,NT,ST,HT)
	IMPLICIT INTEGER(A-Z)
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
#
# FLAGS
#
	LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL FOLLWF,SPELLF,sprf
	COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
		DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
		MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
			EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
		GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
		GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
		MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
		follwf,spellf,sprf(6)
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL

# LOOKTO, PAGE 2
#
	CALL RSPEAK(HT)				#DESCRIBE HALL.
	CALL RSPEAK(NT)				#DESCRIBE NORTH VIEW.
	CALL RSPEAK(ST)				#DESCRIBE SOUTH VIEW.
	DIR=0					#ASSUME NO DIRECTION.
	IF(IABS(MLOC-HERE).NE.1) GO TO 200	#MIRROR TO N OR S?
	IF(MLOC.EQ.NRM) DIR=695
	IF(MLOC.EQ.SRM) DIR=699			#DIR=N/S.
	IF(MOD(MDIR,180).NE.0) GO TO 100	#MIRROR N-S?
	CALL RSPSUB(847,DIR)			#YES, HE SEES PANEL
	CALL RSPSB2(848,DIR,DIR)		#AND NARROW ROOMS.
	GO TO 200
#
100	M1=MRHERE(HERE)				#WHICH MIRROR?
	MRBF=0					#ASSUME INTACT.
	IF(((M1.EQ.1).AND..NOT.MR1F).OR.
		((M1.EQ.2).AND..NOT.MR2F)) MRBF=1	#BROKEN?
	CALL RSPSUB(849+MRBF,DIR)		#DESCRIBE.
	IF((M1.EQ.1).AND.MROPNF) CALL RSPEAK(823+MRBF)
	IF(MRBF.NE.0) CALL RSPEAK(851)
#
200	I=0					#ASSUME NO MORE TO DO.
	IF((NT.EQ.0).AND.((DIR.EQ.0).OR.(DIR.EQ.699))) I=852
	IF((ST.EQ.0).AND.((DIR.EQ.0).OR.(DIR.EQ.695))) I=853
	IF((NT+ST+DIR).EQ.0) I=854
	IF(HT.NE.0) CALL RSPEAK(I)		#DESCRIBE HALLS.
	RETURN
#
	END

# EWTELL--	DESCRIBE E/W NARROW ROOMS
#
# DECLARATIONS
#
	SUBROUTINE EWTELL(RM,ST)
	IMPLICIT INTEGER(A-Z)
	LOGICAL M1
#
# ROOMS
#
	COMMON /RINDEX/ WHOUS,LROOM,CELLA
	COMMON /RINDEX/ MTROL,MAZE1	
	COMMON /RINDEX/ MGRAT,MAZ15	
	COMMON /RINDEX/ FORE1,FORE3,CLEAR,RESER
	COMMON /RINDEX/ STREA,EGYPT,ECHOR
	COMMON /RINDEX/ TSHAF	
	COMMON /RINDEX/ BSHAF,MMACH,DOME,MTORC
	COMMON /RINDEX/ CAROU	
	COMMON /RINDEX/ RIDDL,LLD2,TEMP1,TEMP2,MAINT
	COMMON /RINDEX/ BLROO,TREAS,RIVR1,RIVR2,RIVR3,MCYCL
	COMMON /RINDEX/ RIVR4,RIVR5,FCHMP,FALLS,MBARR
	COMMON /RINDEX/ MRAIN,POG,VLBOT,VAIR1,VAIR2,VAIR3,VAIR4
	COMMON /RINDEX/ LEDG2,LEDG3,LEDG4,MSAFE,CAGER
	COMMON /RINDEX/ CAGED,TWELL,BWELL,ALICE,ALISM,ALITR
	COMMON /RINDEX/ MTREE,BKENT,BKVW,BKTWI,BKVAU,BKBOX
	COMMON /RINDEX/ CRYPT,TSTRS,MRANT,MREYE
	COMMON /RINDEX/ MRA,MRB,MRC,MRG,MRD,FDOOR
	COMMON /RINDEX/ MRAE,MRCE,MRCW,MRGE,MRGW,MRDW,INMIR
	COMMON /RINDEX/ SCORR,NCORR,PARAP,CELL,PCELL,NCELL
#
# FLAGS
#
	LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL FOLLWF,SPELLF,sprf
	COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
		DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
		MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
			EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
		GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
		GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
		MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
		follwf,spellf,sprf(6)
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL

# EWTELL, PAGE 2
#
# NOTE THAT WE ARE EAST OR WEST OF MIRROR, AND
# MIRROR MUST BE N-S.
#
	M1=(MDIR+(MOD(RM-MRAE,2)*180)).EQ.180
	I=819+MOD(RM-MRAE,2)			#GET BASIC E/W STRING.
	IF((M1.AND..NOT.MR1F).OR.(.NOT.M1.AND..NOT.MR2F))
		I=I+2				#MIRROR BROKEN?
	CALL RSPEAK(I)
	IF(M1.AND.MROPNF) CALL RSPEAK(823+((I-819)/2))
	CALL RSPEAK(825)
	CALL RSPEAK(ST)
	RETURN
#
	END
# NOBJS-	NEW OBJECTS PROCESSOR
#	OBJECTS IN THIS MODULE CANNOT CALL RMINFO, JIGSUP,
#	MAJOR VERBS, OR OTHER NON-RESIDENT SUBROUTINES
#
# DECLARATIONS
#
	LOGICAL FUNCTION NOBJS(RI,ARG)
	IMPLICIT INTEGER (A-Z)
	LOGICAL QOPEN,MOVETO,F
	LOGICAL QHERE,OPNCLS,MIRPAN
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
	COMMON /STATE/ MOVES,DEATHS,RWSCOR,MXSCOR,MXLOAD,
		LTSHFT,BLOC,MUNGRM,HS,EGSCOR,EGMXSC
#
# SCREEN OF LIGHT
#
	COMMON /SCREEN/ FROMDR,SCOLRM,SCOLAC
	COMMON /SCREEN/ SCOLDR(8),SCOLWL(12)
#
# ROOMS
#
	COMMON /ROOMS/ RLNT,RDESC2,RDESC1(215),REXIT(215),
		RACTIO(215),RVAL(215),RFLAG(215)
	INTEGER RRAND(215)
	EQUIVALENCE (RVAL,RRAND)
#
	COMMON /RFLAG/ RSEEN,RLIGHT,RLAND,RWATER,RAIR,
		RSACRD,RFILL,RMUNG,RBUCK,RHOUSE,RNWALL,REND
#
	COMMON /RINDEX/ WHOUS,LROOM,CELLA
	COMMON /RINDEX/ MTROL,MAZE1	
	COMMON /RINDEX/ MGRAT,MAZ15	
	COMMON /RINDEX/ FORE1,FORE3,CLEAR,RESER
	COMMON /RINDEX/ STREA,EGYPT,ECHOR
	COMMON /RINDEX/ TSHAF	
	COMMON /RINDEX/ BSHAF,MMACH,DOME,MTORC
	COMMON /RINDEX/ CAROU	
	COMMON /RINDEX/ RIDDL,LLD2,TEMP1,TEMP2,MAINT
	COMMON /RINDEX/ BLROO,TREAS,RIVR1,RIVR2,RIVR3,MCYCL
	COMMON /RINDEX/ RIVR4,RIVR5,FCHMP,FALLS,MBARR
	COMMON /RINDEX/ MRAIN,POG,VLBOT,VAIR1,VAIR2,VAIR3,VAIR4
	COMMON /RINDEX/ LEDG2,LEDG3,LEDG4,MSAFE,CAGER
	COMMON /RINDEX/ CAGED,TWELL,BWELL,ALICE,ALISM,ALITR
	COMMON /RINDEX/ MTREE,BKENT,BKVW,BKTWI,BKVAU,BKBOX
	COMMON /RINDEX/ CRYPT,TSTRS,MRANT,MREYE
	COMMON /RINDEX/ MRA,MRB,MRC,MRG,MRD,FDOOR
	COMMON /RINDEX/ MRAE,MRCE,MRCW,MRGE,MRGW,MRDW,INMIR
	COMMON /RINDEX/ SCORR,NCORR,PARAP,CELL,PCELL,NCELL
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
	COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
	COMMON /OINDEX/ WATER,ROPE,KNIFE,SWORD,LAMP,BLAMP,RUG
	COMMON /OINDEX/	LEAVE,TROLL,AXE
	COMMON /OINDEX/ RKNIF,KEYS,ICE,BAR
	COMMON /OINDEX/ COFFI,TORCH,TBASK,FBASK,IRBOX
	COMMON /OINDEX/ GHOST,TRUNK,BELL,BOOK,CANDL
	COMMON /OINDEX/ MATCH,TUBE,PUTTY,WRENC,SCREW,CYCLO,CHALI
	COMMON /OINDEX/ THIEF,STILL,WINDO,GRATE,DOOR
	COMMON /OINDEX/ HPOLE,LEAK,RBUTT,RAILI
	COMMON /OINDEX/ POT,STATU,IBOAT,DBOAT,PUMP,RBOAT
	COMMON /OINDEX/ STICK,BUOY,SHOVE,BALLO,RECEP,GUANO
	COMMON /OINDEX/ BROPE,HOOK1,HOOK2,SAFE,SSLOT,BRICK,FUSE
	COMMON /OINDEX/ GNOME,BLABE,DBALL,TOMB
	COMMON /OINDEX/ LCASE,CAGE,RCAGE,SPHER,SQBUT
	COMMON /OINDEX/ FLASK,POOL,SAFFR,BUCKE,ECAKE,ORICE,RDICE,BLICE
	COMMON /OINDEX/ ROBOT,FTREE,BILLS,PORTR,SCOL,ZGNOM
	COMMON /OINDEX/ EGG,BEGG,BAUBL,CANAR,BCANA
	COMMON /OINDEX/ YLWAL,RDWAL,PINDR,RBEAM
	COMMON /OINDEX/ ODOOR,QDOOR,CDOOR,NUM1,NUM8
	COMMON /OINDEX/ HANDS,WALL,LUNGS,SAILO,AVIAT,TEETH
	COMMON /OINDEX/ ITOBJ,EVERY,VALUA,OPLAY,WNORT,GWATE,MASTER
#
# CLOCK INTERRUPTS
#
	LOGICAL CFLAG
	COMMON /CEVENT/ CLNT,CTICK(25),CACTIO(25),CFLAG(25)
#
	COMMON /CINDEX/ CEVCUR,CEVMNT,CEVLNT,CEVMAT,CEVCND,
		CEVBAL,CEVBRN,CEVFUS,CEVLED,CEVSAF,CEVVLG,
		CEVGNO,CEVBUC,CEVSPH,CEVEGH,
			CEVFOR,CEVSCL,CEVZGI,CEVZGO,CEVSTE,
		CEVMRS,CEVPIN,CEVINQ,CEVFOL

#
# VILLAINS AND DEMONS
#
	LOGICAL THFFLG,SWDACT,THFACT
	COMMON /HACK/ THFPOS,THFFLG,THFACT,SWDACT,SWDSTA
#
# ADVENTURERS
#
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
		AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
#
	COMMON /AINDEX/ PLAYER,AROBOT,AMASTR
#
# VERBS
#
	COMMON /VINDEX/ CINTW,DEADXW,FRSTQW,INXW,OUTXW
	COMMON /VINDEX/ WALKIW,FIGHTW,FOOW
	COMMON /VINDEX/ MELTW,READW,INFLAW,DEFLAW,ALARMW,EXORCW
	COMMON /VINDEX/ PLUGW,KICKW,WAVEW,RAISEW,LOWERW,RUBW
	COMMON /VINDEX/ PUSHW,UNTIEW,TIEW,TIEUPW,TURNW,BREATW
	COMMON /VINDEX/ KNOCKW,LOOKW,EXAMIW,SHAKEW,MOVEW,TRNONW,TRNOFW
	COMMON /VINDEX/ OPENW,CLOSEW,FINDW,WAITW,SPINW,BOARDW,UNBOAW,TAKEW
	COMMON /VINDEX/ INVENW,FILLW,EATW,DRINKW,BURNW
	COMMON /VINDEX/ MUNGW,KILLW,ATTACW,SWINGW
	COMMON /VINDEX/ WALKW,TELLW,PUTW,DROPW,GIVEW,POURW,THROWW
	COMMON /VINDEX/ DIGW,LEAPW,STAYW,FOLLOW
	COMMON /VINDEX/ HELLOW,LOOKIW,LOOKUW,PUMPW,WINDW
	COMMON /VINDEX/ CLMBW,CLMBUW,CLMBDW,TRNTOW
#
# FLAGS
#
	LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL FOLLWF,SPELLF,sprf
	COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
		DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
		MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
			EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
		GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
		GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
		MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
		follwf,spellf,sprf(6)
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL
#
# FUNCTIONS AND DATA
#
	QOPEN(R)=AND(OFLAG2(R),OPENBT).NE.0

# NOBJS, PAGE 2
#
	IF(PRSO.NE.0) ODO2=ODESC2(PRSO)
	IF(PRSI.NE.0) ODI2=ODESC2(PRSI)
	AV=AVEHIC(WINNER)
	NOBJS=.TRUE.
#
	GO TO (1000,2000,3000,4000,5000,6000,7000,8000,9000,
		10000,11000,12000,13000,14000,15000,16000,17000,
		18000,19000,20000),
			(RI-31)
	CALL BUG(6,RI)
#
# RETURN HERE TO DECLARE FALSE RESULT
#
10	NOBJS=.FALSE.
	RETURN
#
# O32--	BILLS
#
1000	IF(PRSA.NE.EATW) GO TO 1100		#EAT?
	CALL RSPEAK(639)			#JOKE.
	RETURN
#
1100	IF(PRSA.EQ.BURNW) CALL RSPEAK(640)	#BURN?  JOKE.
	GO TO 10				#LET IT BE HANDLED.

# NOBJS, PAGE 3
#
# O33--	SCREEN OF LIGHT
#
2000	TARGET=SCOL				#TARGET IS SCOL.
2100	IF(PRSO.NE.TARGET) GO TO 2400		#PRSO EQ TARGET?
	IF((PRSA.NE.PUSHW).AND.(PRSA.NE.MOVEW).AND.
		(PRSA.NE.TAKEW).AND.(PRSA.NE.RUBW)) GO TO 2200
	CALL RSPEAK(673)			#HAND PASSES THRU.
	RETURN
#
2200	IF((PRSA.NE.KILLW).AND.(PRSA.NE.ATTACW).AND.
		(PRSA.NE.MUNGW)) GO TO 2400	#AGGRESSIVE?
	CALL RSPSUB(674,ODI2)			#PASSES THRU.
	RETURN
#
2400	IF((PRSA.NE.THROWW).OR.(PRSI.NE.TARGET)) GO TO 10
	IF(HERE.EQ.BKBOX) GO TO 2600		#THRU SCOL?
	CALL NEWSTA(PRSO,0,BKBOX,0,0)		#NO, THRU WALL.
	CALL RSPSUB(675,ODO2)			#ENDS UP IN BOX ROOM.
	CTICK(CEVSCL)=0				#CANCEL ALARM.
	SCOLRM=0				#RESET SCOL ROOM.
	RETURN
#
2600	IF(SCOLRM.EQ.0) GO TO 2900		#TRIED TO GO THRU?
	CALL NEWSTA(PRSO,0,SCOLRM,0,0)		#SUCCESS.
	CALL RSPSUB(676,ODO2)			#ENDS UP SOMEWHERE.
	CTICK(CEVSCL)=0			#CANCEL ALARM.
	SCOLRM=0				#RESET SCOL ROOM.
	RETURN
#
2900	CALL RSPEAK(213)			#CANT DO IT.
	RETURN

# NOBJS, PAGE 4
#
# O34--	GNOME OF ZURICH
#
3000	IF((PRSA.NE.GIVEW).AND.(PRSA.NE.THROWW)) GO TO 3200
	IF(OTVAL(PRSO).NE.0) GO TO 3100		#THROW A TREASURE?
	CALL NEWSTA(PRSO,641,0,0,0)		#NO, GO POP.
	RETURN
#
3100	CALL NEWSTA(PRSO,0,0,0,0)		#YES, BYE BYE TREASURE.
	CALL RSPSUB(642,ODO2)
	CALL NEWSTA(ZGNOM,0,0,0,0)		#BYE BYE GNOME.
	CTICK(CEVZGO)=0				#CANCEL EXIT.
	F=MOVETO(BKENT,WINNER)			#NOW IN BANK ENTRANCE.
	RETURN
#
3200	IF((PRSA.NE.ATTACW).AND.(PRSA.NE.KILLW).AND.
		(PRSA.NE.MUNGW)) GO TO 3300	#AGGRESSIVE?
	CALL NEWSTA(ZGNOM,643,0,0,0)		#VANISH GNOME.
	CTICK(CEVZGO)=0				#CANCEL EXIT.
	RETURN
#
3300	CALL RSPEAK(644)			#GNOME IS IMPATIENT.
	RETURN
#
# O35--	EGG
#
4000	IF((PRSA.NE.OPENW).OR.(PRSO.NE.EGG)) GO TO 4500
	IF(.NOT.QOPEN(EGG)) GO TO 4100		#OPEN ALREADY?
	CALL RSPEAK(649)			#YES.
	RETURN
#
4100	IF(PRSI.NE.0) GO TO 4200		#WITH SOMETHING?
	CALL RSPEAK(650)			#NO, CANT.
	RETURN
#
4200	IF(PRSI.NE.HANDS) GO TO 4300		#WITH HANDS?
	CALL RSPEAK(651)			#NOT RECOMMENDED.
	RETURN
#
4300	I=652					#MUNG MESSAGE.
	IF((AND(OFLAG1(PRSI),TOOLBT).NE.0).OR.
		(AND(OFLAG2(PRSI),WEAPBT).NE.0)) GO TO 4600
	I=653					#NOVELTY 1.
	IF(AND(OFLAG2(PRSO),FITEBT).NE.0) I=654	#NOVELTY 2.
	OFLAG2(PRSO)=OR(OFLAG2(PRSO),FITEBT)
	CALL RSPSUB(I,ODI2)
	RETURN
#
4500	IF((PRSA.NE.OPENW).AND.(PRSA.NE.MUNGW)) GO TO 4800
	I=655					#YOU BLEW IT.
4600	CALL NEWSTA(BEGG,I,OROOM(EGG),OCAN(EGG),OADV(EGG))
	CALL NEWSTA(EGG,0,0,0,0)		#VANISH EGG.
	OTVAL(BEGG)=2				#BAD EGG HAS VALUE.
	IF(OCAN(CANAR).NE.EGG) GO TO 4700	#WAS CANARY INSIDE?
	CALL RSPEAK(ODESCO(BCANA))		#YES, DESCRIBE RESULT.
	OTVAL(BCANA)=1
	RETURN
#
4700	CALL NEWSTA(BCANA,0,0,0,0)		#NO, VANISH IT.
	RETURN
#
4800	IF((PRSA.NE.DROPW).OR.(HERE.NE.MTREE)) GO TO 10
	CALL NEWSTA(BEGG,658,FORE3,0,0)	#DROPPED EGG.
	CALL NEWSTA(EGG,0,0,0,0)
	OTVAL(BEGG)=2
	IF(OCAN(CANAR).NE.EGG) GO TO 4700
	OTVAL(BCANA)=1			#BAD CANARY.
	RETURN

# NOBJS, PAGE 5
#
# O36--	CANARIES, GOOD AND BAD
#
5000	IF(PRSA.NE.WINDW) GO TO 10		#WIND EM UP?
	IF(PRSO.EQ.CANAR) GO TO 5100		#RIGHT ONE?
	CALL RSPEAK(645)			#NO, BAD NEWS.
	RETURN
#
5100	IF(.NOT.SINGSF.AND.((HERE.EQ.MTREE).OR.
		((HERE.GE.FORE1).AND.(HERE.LT.CLEAR))))
		GO TO 5200			#FIRST SONG IN FOR?
	CALL RSPEAK(646)			#NO, MEDIOCRE NEWS.
	RETURN
#
5200	SINGSF=.TRUE.				#SANG SONG.
	I=HERE
	IF(I.EQ.MTREE) I=FORE3			#PLACE BAUBLE.
	CALL NEWSTA(BAUBL,647,I,0,0)
	RETURN
#
# O37--	WHITE CLIFFS
#
6000	IF((PRSA.NE.CLMBW).AND.(PRSA.NE.CLMBUW).AND.
		(PRSA.NE.CLMBDW)) GO TO 10	#CLIMB?
	CALL RSPEAK(648)			#OH YEAH?
	RETURN
#
# O38--	WALL 
#
7000	IF((IABS(HERE-MLOC).NE.1).OR.(MRHERE(HERE).NE.0).OR.
		(PRSA.NE.PUSHW)) GO TO 7100
	CALL RSPEAK(860)			#PUSHED MIRROR WALL.
	RETURN
#
7100	IF((RFLAG(HERE).AND.RNWALL).EQ.0) GO TO 10
	CALL RSPEAK(662)			#NO WALL.
	RETURN

# NOBJS, PAGE 6
#
# O39--	SONG BIRD GLOBAL
#
8000	IF(PRSA.NE.FINDW) GO TO 8100		#FIND?
	CALL RSPEAK(666)
	RETURN
#
8100	IF(PRSA.NE.EXAMIW) GO TO 10		#EXAMINE?
	CALL RSPEAK(667)
	RETURN
#
# O40--	SCOL WALLS
#
9000	IF(HERE.NE.SCOLAC) GO TO 9200		#IN SCOL ACTIVE ROOM?
	DO I=1,12,3 {
	  TARGET=SCOLWL(I+1)			#ASSUME TARGET.
	  IF(SCOLWL(I).EQ.HERE) GO TO 2100	#TREAT IF FOUND.
	  }
#
9200	IF(HERE.NE.BKBOX) GO TO 10		#IN BOX ROOM?
	TARGET=WNORT
	GO TO 2100

# NOBJS, PAGE 7
#
# O41--	SHORT POLE
#
10000	IF(PRSA.NE.RAISEW) GO TO 10100		#LIFT?
	I=749					#ASSUME UP.
	IF(POLEUF.EQ.2) I=750			#ALREADY UP?
	CALL RSPEAK(I)
	POLEUF=2				#POLE IS RAISED.
	RETURN
#
10100	IF((PRSA.NE.LOWERW).AND.(PRSA.NE.PUSHW)) GO TO 10
	IF(POLEUF.NE.0) GO TO 10200		#ALREADY LOWERED?
	CALL RSPEAK(751)			#CANT DO IT.
	RETURN
#
10200	IF(MOD(MDIR,180).NE.0) GO TO 10300	#MIRROR N-S?
	POLEUF=0				#YES, LOWER INTO
	CALL RSPEAK(752)			#CHANNEL.
	RETURN
#
10300	IF((MDIR.NE.270).OR.(MLOC.NE.MRB)) GO TO 10400
	POLEUF=0				#LOWER INTO HOLE.
	CALL RSPEAK(753)
	RETURN
#
10400	CALL RSPEAK(753+POLEUF)			#POLEUF = 1 OR 2.
	POLEUF=1				#NOW ON FLOOR.
	RETURN
#
# O42--	MIRROR SWITCH
#
11000	IF(PRSA.NE.PUSHW) GO TO 10		#PUSH?
	IF(MRPSHF) GO TO 11300			#ALREADY PUSHED?
	CALL RSPEAK(756)			#BUTTON GOES IN.
	DO I=1,OLNT {				#BLOCKED?
	  IF(QHERE(I,MREYE).AND.(I.NE.RBEAM)) GO TO 11200
	  }
	CALL RSPEAK(757)			#NOTHING IN BEAM.
	RETURN
#
11200	CFLAG(CEVMRS)=.TRUE.			#MIRROR OPENS.
	CTICK(CEVMRS)=7
	MRPSHF=.TRUE.
	MROPNF=.TRUE.
	RETURN
#
11300	CALL RSPEAK(758)			#MIRROR ALREADYOPEN.
	RETURN

# NOBJS, PAGE 8
#
# O43--	BEAM FUNCTION
#
12000	IF((PRSA.NE.TAKEW).OR.(PRSO.NE.RBEAM)) GO TO 12100
	CALL RSPEAK(759)			#TAKE BEAM, JOKE.
	RETURN
#
12100	I=PRSO					#ASSUME BLK WITH DIROBJ.
	IF((PRSA.EQ.PUTW).AND.(PRSI.EQ.RBEAM)) GO TO 12200
	IF((PRSA.NE.MUNGW).OR.(PRSO.NE.RBEAM).OR.
		(PRSI.EQ.0)) GO TO 10		#BREAK BEAM WITH X?
	I=PRSI
12200	IF(OADV(I).NE.WINNER) GO TO 12300	#CARRYING?
	CALL NEWSTA(I,0,HERE,0,0)		#DROP OBJ.
	CALL RSPSUB(760,ODESC2(I))
	RETURN
#
12300	J=761					#ASSUME NOT IN ROOM.
	IF(QHERE(J,HERE)) I=762			#IN ROOM?
	CALL RSPSUB(J,ODESC2(I))		#DESCRIBE.
	RETURN
#
# O44--	BRONZE DOOR
#
13000	IF((HERE.EQ.NCELL).OR.((LCELL.EQ.4).AND.
		((HERE.EQ.CELL).OR.(HERE.EQ.SCORR))))
		GO TO 13100
	CALL RSPEAK(763)			#DOOR NOT THERE.
	RETURN
#
13100	IF(.NOT.OPNCLS(ODOOR,764,765)) GO TO 10	#OPEN/CLOSE?
	IF((HERE.EQ.NCELL).AND.QOPEN(ODOOR))
		CALL RSPEAK(766)		#DESCR VIEW.
	RETURN
#
# O45--	QUIZ DOOR
#
14000	IF((PRSA.NE.OPENW).AND.(PRSA.NE.CLOSEW)) GO TO 14100
	CALL RSPEAK(767)			#DOOR WONT MOVE.
	RETURN
#
14100	IF(PRSA.NE.KNOCKW) GO TO 10		#KNOCK?
	IF(INQSTF) GO TO 14200		#TRIED IT ALREADY?
	INQSTF=.TRUE.				#START INQUISITION.
	CFLAG(CEVINQ)=.TRUE.
	CTICK(CEVINQ)=2
	QUESNO=RND(8)				#SELECT QUESTION.
	NQATT=0
	CORRCT=0
	CALL RSPEAK(768)			#ANNOUNCE RULES.
	CALL RSPEAK(769)
	CALL RSPEAK(770+QUESNO)			#ASK QUESTION.
	RETURN
#
14200	CALL RSPEAK(798)			#NO REPLY.
	RETURN
#
# O46--	LOCKED DOOR
#
15000	IF(PRSA.NE.OPENW) GO TO 10		#OPEN?
	CALL RSPEAK(778)			#CANT.
	RETURN
#
# O47--	CELL DOOR
#
16000	NOBJS=OPNCLS(CDOOR,779,780)		#OPEN/CLOSE?
	RETURN

# NOBJS, PAGE 9
#
# O48--	DIALBUTTON
#
17000	IF(PRSA.NE.PUSHW) GO TO 10		#PUSH?
	CALL RSPEAK(809)			#CLICK.
	IF(QOPEN(CDOOR)) CALL RSPEAK(810)	#CLOSE CELL DOOR.
#
	DO I=1,OLNT {				#RELOCATE OLD TO HYPER.
	  IF((OROOM(I).EQ.CELL).AND.(AND(OFLAG1(I),DOORBT).EQ.0))
		CALL NEWSTA(I,0,LCELL*1000,0,0)
	  IF(OROOM(I).EQ.(PNUMB*1000))
		CALL NEWSTA(I,0,CELL,0,0)	#MOVE IN NEW HYPER.
	  }
#
	OFLAG2(ODOOR)=AND(OFLAG2(ODOOR),NOT(OPENBT))
	OFLAG2(CDOOR)=AND(OFLAG2(CDOOR),NOT(OPENBT))
	OFLAG1(ODOOR)=AND(OFLAG1(ODOOR),NOT(VISIBT))
	IF(PNUMB.EQ.4) OFLAG1(ODOOR)=OR(OFLAG1(ODOOR),VISIBT)
#
	IF(AROOM(PLAYER).NE.CELL) GO TO 17300	#PLAYER IN CELL?
	ACELL=LCELL				#YES, NOTE WHERE.
	IF(LCELL.NE.4) GO TO 17200		#IN RIGHT CELL?
	OFLAG1(ODOOR)=OFLAG1(ODOOR).OR. VISIBT
	F=MOVETO(NCELL,PLAYER)			#YES, MOVETO NCELL.
	GO TO 17400
17200	F=MOVETO(PCELL,PLAYER)			#NO, MOVETO PCELL.
	GO TO 17400
#
17300	IF(ACELL.NE.PNUMB) GO TO 17400	#OLD = NEW?
	ACELL=0
	F=MOVETO(CELL,PLAYER)			#PUT HIM IN CELL.
#
17400	IF(AROOM(AMASTR).NE.CELL) GO TO 17500	#MASTER IN CELL???
	AROOM(AMASTR)=PCELL			#PUT HIM IN PCELL.
	DCELL=LCELL
	LCELL=PNUMB
	RETURN
#
17500	IF(DCELL.EQ.PNUMB) DCELL=0
	LCELL=PNUMB				#SET OLD = NEW.
	RETURN

# NOBJS, PAGE 10
#
# O49--	DIAL INDICATOR
#
18000	IF(PRSA.NE.SPINW) GO TO 18100		#SPIN?
	PNUMB=RND(8)+1				#WHEE!
	CALL RSPSUB(797,712+PNUMB)
	RETURN
#
18100	IF((PRSA.NE.MOVEW).AND.(PRSA.NE.PUTW).AND.
		(PRSA.NE.TRNTOW)) GO TO 10
	IF(PRSI.NE.0) GO TO 18200		#TURN DIAL TO X?
	CALL RSPEAK(806)			#MUST SPECIFY.
	RETURN
#
18200	IF((PRSI.GE.NUM1).AND.(PRSI.LE.NUM8)) GO TO 18300
	CALL RSPEAK(807)			#MUST BE DIGIT.
	RETURN
#
18300	PNUMB=PRSI-NUM1+1			#SET UP NEW.
	CALL RSPSUB(808,712+PNUMB)
	RETURN
#
# O50--	GLOBAL MIRROR
#
19000	NOBJS=MIRPAN(832,.FALSE.)
	RETURN
#
# O51--	GLOBAL PANEL
#
20000	IF(HERE.NE.FDOOR) GO TO 20100		#AT FRONT DOOR?
	IF((PRSA.NE.OPENW).AND.(PRSA.NE.CLOSEW)) GO TO 10
	CALL RSPEAK(843)			#PANEL IN DOOR, NOGO.
	RETURN
#
20100	NOBJS=MIRPAN(838,.TRUE.)
	RETURN
#
	END

# MIRPAN--	PROCESSOR FOR GLOBAL MIRROR/PANEL
#
# DECLARATIONS
#
	LOGICAL FUNCTION MIRPAN(ST,PNF)
	IMPLICIT INTEGER(A-Z)
	LOGICAL PNF
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
# VERBS
#
	COMMON /VINDEX/ CINTW,DEADXW,FRSTQW,INXW,OUTXW
	COMMON /VINDEX/ WALKIW,FIGHTW,FOOW
	COMMON /VINDEX/ MELTW,READW,INFLAW,DEFLAW,ALARMW,EXORCW
	COMMON /VINDEX/ PLUGW,KICKW,WAVEW,RAISEW,LOWERW,RUBW
	COMMON /VINDEX/ PUSHW,UNTIEW,TIEW,TIEUPW,TURNW,BREATW
	COMMON /VINDEX/ KNOCKW,LOOKW,EXAMIW,SHAKEW,MOVEW,TRNONW,TRNOFW
	COMMON /VINDEX/ OPENW,CLOSEW,FINDW,WAITW,SPINW,BOARDW,UNBOAW,TAKEW
	COMMON /VINDEX/ INVENW,FILLW,EATW,DRINKW,BURNW
	COMMON /VINDEX/ MUNGW,KILLW,ATTACW,SWINGW
	COMMON /VINDEX/ WALKW,TELLW,PUTW,DROPW,GIVEW,POURW,THROWW
	COMMON /VINDEX/ DIGW,LEAPW,STAYW,FOLLOW
	COMMON /VINDEX/ HELLOW,LOOKIW,LOOKUW,PUMPW,WINDW
	COMMON /VINDEX/ CLMBW,CLMBUW,CLMBDW,TRNTOW
#
# FLAGS
#
	LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL FOLLWF,SPELLF,sprf
	COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
		DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
		MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
			EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
		GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
		GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
		MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
		follwf,spellf,sprf(6)
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL

# MIRPAN, PAGE 2
#
	MIRPAN=.TRUE.
	NUM=MRHERE(HERE)			#GET MIRROR NUM.
	IF(NUM.NE.0) GO TO 100			#ANY HERE?
	CALL RSPEAK(ST)				#NO, LOSE.
	RETURN
#
100	MRBF=0					#ASSUME MIRROR OK.
	IF(((NUM.EQ.1).AND..NOT.MR1F).OR.
		((NUM.EQ.2).AND..NOT.MR2F)) MRBF=1
	IF((PRSA.NE.MOVEW).AND.(PRSA.NE.OPENW)) GO TO 200
	CALL RSPEAK(ST+1)			#CANT OPEN OR MOVE.
	RETURN
#
200	IF(PNF.OR.((PRSA.NE.LOOKIW).AND.(PRSA.NE.EXAMIW).AND.
		(PRSA.NE.LOOKW))) GO TO 300
	CALL RSPEAK(844+MRBF)			#LOOK IN MIRROR.
	RETURN
#
300	IF(PRSA.NE.MUNGW) GO TO 400		#BREAK?
	CALL RSPEAK(ST+2+MRBF)			#DO IT.
	IF((NUM.EQ.1).AND..NOT.PNF) MR1F=.FALSE.
	IF((NUM.EQ.2).AND..NOT.PNF) MR2F=.FALSE.
	RETURN
#
400	IF(PNF.OR.(MRBF.EQ.0)) GO TO 500	#BROKEN MIRROR?
	CALL RSPEAK(846)
	RETURN
#
500	IF(PRSA.NE.PUSHW) GO TO 600		#PUSH?
	CALL RSPEAK(ST+3+NUM)
	RETURN
#
600	MIRPAN=.FALSE.			#CANT HANDLE IT.
	RETURN
#
	END
# PRINCR- PRINT CONTENTS OF ROOM
#
# DECLARATIONS
#
	SUBROUTINE PRINCR(FULL,RM)
	IMPLICIT INTEGER (A-Z)
	LOGICAL QEMPTY,QHERE,FULL
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
#
# ROOMS
#
	COMMON /ROOMS/ RLNT,RDESC2,RDESC1(215),REXIT(215),
		RACTIO(215),RVAL(215),RFLAG(215)
	INTEGER RRAND(215)
	EQUIVALENCE (RVAL,RRAND)
#
	COMMON /RFLAG/ RSEEN,RLIGHT,RLAND,RWATER,RAIR,
		RSACRD,RFILL,RMUNG,RBUCK,RHOUSE,RNWALL,REND
#
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
	COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
#
# ADVENTURERS
#
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
		AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
#
	COMMON /AINDEX/ PLAYER,AROBOT,AMASTR
#
# FLAGS
#
	LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL GLACMF,ENDGMF,FROBZF,BADLKF,THFENF,SINGSF
	LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL FOLLWF,SPELLF,sprf
	COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
		DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
		MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
			EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
		GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
		GLACMF,ENDGMF,FROBZF,BADLKF,THFENF,SINGSF,
		MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
		follwf,spellf,sprf(6)
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVGUA,RVSND
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL

# PRINCR, PAGE 2
#
	J=329				#ASSUME SUPERBRIEF FORMAT.
	DO I=1,OLNT {			#LOOP ON OBJECTS
	  IF(.NOT.QHERE(I,RM).OR.(AND(OFLAG1(I),(VISIBT+NDSCBT)).NE.
		VISIBT).OR.(I.EQ.AVEHIC(WINNER))) NEXT
	  IF(.NOT.FULL.AND.(SUPERF.OR.(BRIEFF.AND.
		(AND(RFLAG(HERE),RSEEN).NE.0)))) GO TO 200
#
# DO LONG DESCRIPTION OF OBJECT.
#
	  K=ODESCO(I)				#GET UNTOUCHED.
	  IF((K.EQ.0).OR.(AND(OFLAG2(I),TCHBT).NE.0)) K=ODESC1(I)
	  CALL RSPEAK(K)			#DESCRIBE.
	  NEXT
# DO SHORT DESCRIPTION OF OBJECT.
#
200	  CALL RSPSUB(J,ODESC2(I))	#YOU CAN SEE IT.
	  J=502
#
	  }
#
# NOW LOOP TO PRINT CONTENTS OF OBJECTS IN ROOM.
#
	DO I=1,OLNT {				#LOOP ON OBJECTS.
	  IF(.NOT.QHERE(I,RM).OR.(AND(OFLAG1(I),(VISIBT+NDSCBT)).NE.
		VISIBT)) NEXT
	  IF(AND(OFLAG2(I),ACTRBT).NE.0) CALL INVENT(OACTOR(I))
	  IF(((AND(OFLAG1(I),TRANBT).EQ.0).AND.(AND(OFLAG2(I),OPENBT)
		.EQ.0)).OR.QEMPTY(I)) NEXT
#
# OBJECT IS NOT EMPTY AND IS OPEN OR TRANSPARENT.
#
	  J=573
	  IF(I.NE.TCASE) GO TO 600		#TROPHY CASE?
	  J=574
	  IF((BRIEFF.OR.SUPERF).AND. .NOT.FULL) NEXT
600	  CALL PRINCO(I,J)			#PRINT CONTENTS.
#
	  }
	RETURN
#
	END

# INVENT- PRINT CONTENTS OF ADVENTURER
#
# DECLARATIONS
#
	SUBROUTINE INVENT(ADV)
	IMPLICIT INTEGER (A-Z)
	LOGICAL QEMPTY
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
#
# ADVENTURERS
#
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
		AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
#
	COMMON /AINDEX/ PLAYER,AROBOT,AMASTR

# INVENT, PAGE 2
#
	I=575					#FIRST LINE.
	IF(ADV.NE.PLAYER) I=576			#IF NOT ME.
	DO J=1,OLNT {					#LOOP
	  IF((OADV(J).NE.ADV).OR.(AND(OFLAG1(J),VISIBT).EQ.0))
		NEXT
	  CALL RSPSUB(I,ODESC2(AOBJ(ADV)))
	  I=0
	  CALL RSPSUB(502,ODESC2(J))
	  }
#
	IF(I.EQ.0) GO TO 25			#ANY OBJECTS?
	IF(ADV.EQ.PLAYER) CALL RSPEAK(578)	#NO, TELL HIM.
	RETURN
#
25	DO J=1,OLNT {				#LOOP.
	  IF((OADV(J).NE.ADV).OR.(AND(OFLAG1(J),VISIBT).EQ.0).OR.
		((AND(OFLAG1(J),TRANBT).EQ.0).AND.
		(AND(OFLAG2(J),OPENBT).EQ.0))) NEXT
	  IF(.NOT.QEMPTY(J)) CALL PRINCO(J,573)	#IF NOT EMPTY, LIST.
	  }
	RETURN
#
	END

# PRINCO-	PRINT CONTENTS OF OBJECT
#
# DECLARATIONS
#
	SUBROUTINE PRINCO(OBJ,DESC)
	IMPLICIT INTEGER(A-Z)
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	CALL RSPSUB(DESC,ODESC2(OBJ))		#PRINT HEADER.
	DO I=1,OLNT {				#LOOP THRU.
	  IF(OCAN(I).EQ.OBJ) CALL RSPSUB(502,ODESC2(I))
	  }
	RETURN
#
	END

# MOVETO- MOVE PLAYER TO NEW ROOM
#
# DECLARATIONS
#
	LOGICAL FUNCTION MOVETO(NR,WHO)
	IMPLICIT INTEGER (A-Z)
	LOGICAL NLV,LHR,LNR
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
#
# ROOMS
#
	COMMON /ROOMS/ RLNT,RDESC2,RDESC1(215),REXIT(215),
		RACTIO(215),RVAL(215),RFLAG(215)
	INTEGER RRAND(215)
	EQUIVALENCE (RVAL,RRAND)
#
	COMMON /RFLAG/ RSEEN,RLIGHT,RLAND,RWATER,RAIR,
		RSACRD,RFILL,RMUNG,RBUCK,RHOUSE,RNWALL,REND
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
	COMMON /OINDEX/ WATER,ROPE,KNIFE,SWORD,LAMP,BLAMP,RUG
	COMMON /OINDEX/	LEAVE,TROLL,AXE
	COMMON /OINDEX/ RKNIF,KEYS,ICE,BAR
	COMMON /OINDEX/ COFFI,TORCH,TBASK,FBASK,IRBOX
	COMMON /OINDEX/ GHOST,TRUNK,BELL,BOOK,CANDL
	COMMON /OINDEX/ MATCH,TUBE,PUTTY,WRENC,SCREW,CYCLO,CHALI
	COMMON /OINDEX/ THIEF,STILL,WINDO,GRATE,DOOR
	COMMON /OINDEX/ HPOLE,LEAK,RBUTT,RAILI
	COMMON /OINDEX/ POT,STATU,IBOAT,DBOAT,PUMP,RBOAT
	COMMON /OINDEX/ STICK,BUOY,SHOVE,BALLO,RECEP,GUANO
	COMMON /OINDEX/ BROPE,HOOK1,HOOK2,SAFE,SSLOT,BRICK,FUSE
	COMMON /OINDEX/ GNOME,BLABE,DBALL,TOMB
	COMMON /OINDEX/ LCASE,CAGE,RCAGE,SPHER,SQBUT
	COMMON /OINDEX/ FLASK,POOL,SAFFR,BUCKE,ECAKE,ORICE,RDICE,BLICE
	COMMON /OINDEX/ ROBOT,FTREE,BILLS,PORTR,SCOL,ZGNOM
	COMMON /OINDEX/ EGG,BEGG,BAUBL,CANAR,BCANA
	COMMON /OINDEX/ YLWAL,RDWAL,PINDR,RBEAM
	COMMON /OINDEX/ ODOOR,QDOOR,CDOOR,NUM1,NUM8
	COMMON /OINDEX/ HANDS,WALL,LUNGS,SAILO,AVIAT,TEETH
	COMMON /OINDEX/ ITOBJ,EVERY,VALUA,OPLAY,WNORT,GWATE,MASTER
#
# ADVENTURERS
#
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
		AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
#
	COMMON /AINDEX/ PLAYER,AROBOT,AMASTR

# MOVETO, PAGE 2
#
	MOVETO=.FALSE.				#ASSUME FAILS.
	LHR=ANd(RFLAG(HERE),RLAND).NE.0	#LAND  HERE FLAG.
	LNR=AND(RFLAG(NR),RLAND).NE.0		#LAND THERE FLAG.
	J=AVEHIC(WHO)			#HIS VEHICLE
#
	IF(J.NE.0) GO TO 100			#IN VEHICLE?
	IF(LNR) GO TO 500			#NO, GOING TO LAND?
	CALL RSPEAK(427)			#CAN'T GO WITHOUT VEHICLE.
	RETURN
#
100	BITS=0					#ASSUME NOWHERE.
	IF(J.EQ.RBOAT) BITS=RWATER		#IN BOAT?
	IF(J.EQ.BALLO) BITS=RAIR		#IN BALLOON?
	IF(J.EQ.BUCKE) BITS=RBUCK		#IN BUCKET?
	NLV=AND(RFLAG(NR),BITS).EQ.0	#GOT WRONG VEHICLE FLAG.
	IF((.NOT.LNR .AND.NLV) .OR.
		(LNR.AND.LHR.AND.NLV.AND.(BITS.NE.RLAND)))
		GO TO 800			#GOT WRONG VEHICLE?
#
500	MOVETO=.TRUE.				#MOVE SHOULD SUCCEED.
	IF(AND(RFLAG(NR),RMUNG).EQ.0) GO TO 600	#ROOM MUNGED?
	CALL RSPEAK(RRAND(NR))			#YES, TELL HOW.
	RETURN
#
600	IF(WHO.NE.PLAYER) CALL NEWSTA(AOBJ(WHO),0,NR,0,0)
	IF(J.NE.0) CALL NEWSTA(J,0,NR,0,0)
	HERE=NR
	AROOM(WHO)=HERE
	CALL SCRUPD(RVAL(NR))			#SCORE ROOM
	RVAL(NR)=0
	RETURN
#
800	CALL RSPSUB(428,ODESC2(J))		#WRONG VEHICLE.
	RETURN
	END

# SCORE-- PRINT OUT CURRENT SCORE
#
# DECLARATIONS
#
	SUBROUTINE SCORE(FLG)
	IMPLICIT INTEGER (A-Z)
	LOGICAL FLG
	INTEGER RANK(10),ERANK(5)
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
	COMMON /STATE/ MOVES,DEATHS,RWSCOR,MXSCOR,MXLOAD,
		LTSHFT,BLOC,MUNGRM,HS,EGSCOR,EGMXSC
#
	COMMON /CHAN/ INPCH,OUTCH,DBCH
#
# ADVENTURERS
#
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
		AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
#
# FLAGS
#
	LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL FOLLWF,SPELLF,sprf
	COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
		DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
		MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
			EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
		GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
		GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
		MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
		follwf,spellf,sprf(6)
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL
#
# FUNCTIONS AND DATA
#
	DATA RANK/20,19,18,16,12,8,4,2,1,0/
	DATA ERANK/20,15,10,5,0/

# SCORE, PAGE 2
#
	AS=ASCORE(WINNER)
	IF(ENDGMF) GO TO 60			#ENDGAME?
	IF(FLG) WRITE(OUTCH,100)
	IF(.NOT.FLG) WRITE(OUTCH,110)
	IF(MOVES.NE.1) WRITE(OUTCH,120) AS,MXSCOR,MOVES
	IF(MOVES.EQ.1) WRITE(OUTCH,130) AS,MXSCOR,MOVES
	DO I=1,10 {
	  IF((AS*20/MXSCOR).GE.RANK(I)) GO TO 50
	  }
50	write(outch,90)
	CALL RSPEAK(484+I)
	RETURN
#
60	IF(FLG) WRITE(OUTCH,140)
	IF(.NOT.FLG) WRITE(OUTCH,150)
	WRITE(OUTCH,120) EGSCOR,EGMXSC,MOVES
	DO I=1,5 {
	  IF((EGSCOR*20/EGMXSC).GE.ERANK(I)) GO TO 80
	  }
80	write(outch,90)
	CALL RSPEAK(786+I)
	RETURN
#
90	format(' ')
100	FORMAT(' Your score would be')
110	FORMAT(' Your score is')
120	FORMAT('+',I4,' [total of',I4,' points], in',I5,' moves.')
130	FORMAT('+',I4,' [total of',I4,' points], in',I5,' move.')
140	FORMAT(' Your score in the endgame would be')
150	FORMAT(' Your score in the endgame is')
#
	END

# SCRUPD- UPDATE WINNER'S SCORE
#
# DECLARATIONS
#
	SUBROUTINE SCRUPD(N)
	IMPLICIT INTEGER (A-Z)
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
	COMMON /STATE/ MOVES,DEATHS,RWSCOR,MXSCOR,MXLOAD,
		LTSHFT,BLOC,MUNGRM,HS,EGSCOR,EGMXSC
#
# CLOCK INTERRUPTS
#
	LOGICAL CFLAG
	COMMON /CEVENT/ CLNT,CTICK(25),CACTIO(25),CFLAG(25)
#
	COMMON /CINDEX/ CEVCUR,CEVMNT,CEVLNT,CEVMAT,CEVCND,
		CEVBAL,CEVBRN,CEVFUS,CEVLED,CEVSAF,CEVVLG,
		CEVGNO,CEVBUC,CEVSPH,CEVEGH,
			CEVFOR,CEVSCL,CEVZGI,CEVZGO,CEVSTE,
		CEVMRS,CEVPIN,CEVINQ,CEVFOL
#
# ADVENTURERS
#
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
		AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
#
# FLAGS
#
	LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL FOLLWF,SPELLF,sprf
	COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
		DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
		MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
			EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
		GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
		GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
		MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
		follwf,spellf,sprf(6)
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL
#
	IF(ENDGMF) GO TO 100			#ENDGAME?
	ASCORE(WINNER)=ASCORE(WINNER)+N		#UPDATE SCORE
	RWSCOR=RWSCOR+N				#UPDATE RAW SCORE
	IF(ASCORE(WINNER).LT.(MXSCOR-(10*DEATHS))) RETURN
	if(.not.cflag(cevegh))CTICK(CEVEGH)=15
	CFLAG(CEVEGH)=.TRUE.			#TURN ON END GAME
	RETURN
#
100	EGSCOR=EGSCOR+N				#UPDATE EG SCORE.
	RETURN
	END

# FINDXT- FIND EXIT FROM ROOM
#
# DECLARATIONS
#
	LOGICAL FUNCTION FINDXT(DIR,RM)
	IMPLICIT INTEGER (A-Z)
#
# ROOMS
#
	COMMON /ROOMS/ RLNT,RDESC2,RDESC1(215),REXIT(215),
		RACTIO(215),RVAL(215),RFLAG(215)
	INTEGER RRAND(215)
	EQUIVALENCE (RVAL,RRAND)
#
# EXITS
#
	COMMON /EXITS/ XLNT,TRAVEL(870)
#
	COMMON /CURXT/ XTYPE,XROOM1,XSTRNG,XACTIO,XOBJ
	EQUIVALENCE (XFLAG,XOBJ)
#
	COMMON /XPARS/ XRMASK,XDMASK,XFMASK,XFSHFT,XASHFT,
		XELNT(4),XNORM,XNO,XCOND,XDOOR,XLFLAG
#
	FINDXT=.TRUE.				#ASSUME WINS.
	XI=REXIT(RM)				#FIND FIRST ENTRY.
	IF(XI.EQ.0) GO TO 1000			#NO EXITS?
#
100	I=TRAVEL(XI)				#GET ENTRY.
	XROOM1=AND(I,XRMASK)			#ISOLATE ROOM.
	XTYPE=AND((AND(I,NOT(XLFLAG))/XFSHFT),XFMASK)+1
	GO TO (110,120,130,130),XTYPE		#BRANCH ON ENTRY.
	CALL BUG(10,XTYPE)
#
130	XOBJ=AND(TRAVEL(XI+2),XRMASK)		#DOOR/CEXIT- GET OBJ/FLAG.
	XACTIO=TRAVEL(XI+2)/XASHFT
120	XSTRNG=TRAVEL(XI+1)			#DOOR/CEXIT/NEXIT - STRING.
110	XI=XI+XELNT(XTYPE)			#ADVANCE TO NEXT ENTRY.
	IF(AND(I,XDMASK).EQ.DIR) RETURN	#MATCH?
	IF(AND(I,XLFLAG).EQ.0) GO TO 100	#LAST ENTRY?
1000	FINDXT=.FALSE.				#YES, LOSE.
	RETURN
	END

# FWIM- FIND WHAT I MEAN
#
# DECLARATIONS
#
	INTEGER FUNCTION FWIM(F1,F2,RM,CON,ADV,NOCARE)
	IMPLICIT INTEGER (A-Z)
	LOGICAL NOCARE
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
	FWIM=0					#ASSUME NOTHING.
	DO I=1,OLNT {				#LOOP
	  IF(((RM.EQ.0).OR.(OROOM(I).NE.RM)) .AND.
		((ADV.EQ.0).OR.(OADV(I).NE.ADV)) .AND.
		((CON.EQ.0).OR.(OCAN(I).NE.CON)))
			NEXT
#
# OBJECT IS ON LIST... IS IT A MATCH?
#
	  IF(AND(OFLAG1(I),VISIBT).EQ.0) NEXT
	  IF((.NOT.NOCARE .AND.(AND(OFLAG1(I),TAKEBT).EQ.0)) .OR.
		((AND(OFLAG1(I),F1).EQ.0).AND.
		 (AND(OFLAG2(I),F2).EQ.0))) GO TO 500
	  IF(FWIM.EQ.0) GO TO 400			#ALREADY GOT SOMETHING?
	  FWIM=-FWIM				#YES, AMBIGUOUS.
	  RETURN
#
400	  FWIM=I					#NOTE MATCH.
#
# DOES OBJECT CONTAIN A MATCH?
#
500	  IF(AND(OFLAG2(I),OPENBT).EQ.0) NEXT		#CLOSED?
	  DO J=1,OLNT {					#NO, SEARCH CONTENTS.
	    IF((OCAN(J).NE.I).OR.(AND(OFLAG1(J),VISIBT).EQ.0) .OR.
		((AND(OFLAG1(J),F1).EQ.0).AND.
		 (AND(OFLAG2(J),F2).EQ.0))) NEXT
	    IF(FWIM.EQ.0) GO TO 600
	    FWIM=-FWIM
	    RETURN
#
600	    FWIM=J
	    }
	  }
	RETURN
	END

# YESNO- OBTAIN YES/NO ANSWER
#
# CALLED BY-
#
#	YES-IS-TRUE=YESNO(QUESTION,YES-STRING,NO-STRING)
#
	LOGICAL FUNCTION YESNO(Q,Y,N)
	IMPLICIT INTEGER(A-Z)
	COMMON /CHAN/ INPCH,OUTCH,DBCH
#
100	CALL RSPEAK(Q)				#ASK
	READ(INPCH,110) ANS			#GET ANSWER
110	FORMAT(A1)
	IF((ANS.EQ.'Y').OR.(ANS.EQ.'y')) GO TO 200
	IF((ANS.EQ.'N').OR.(ANS.EQ.'n')) GO TO 300
	CALL RSPEAK(6)				#SCOLD.
	GO TO 100
#
200	YESNO=.TRUE.				#YES,
	CALL RSPEAK(Y)				#OUT WITH IT.
	RETURN
#
300	YESNO=.FALSE.				#NO,
	CALL RSPEAK(N)				#LIKEWISE.
	RETURN
#
	END
# ROBADV-- STEAL WINNER'S VALUABLES
#
# DECLARATIONS
#
	INTEGER FUNCTION ROBADV(ADV,NR,NC,NA)
	IMPLICIT INTEGER (A-Z)
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
	ROBADV=0				#COUNT OBJECTS
	DO I=1,OLNT {
	  IF((OADV(I).NE.ADV).OR.(OTVAL(I).LE.0).OR.
		(AND(OFLAG2(I),SCRDBT).NE.0)) NEXT
	  CALL NEWSTA(I,0,NR,NC,NA)		#STEAL OBJECT
	  ROBADV=ROBADV+1
	  }
	RETURN
	END

# ROBRM-- STEAL ROOM VALUABLES
#
# DECLARATIONS
#
	INTEGER FUNCTION ROBRM(RM,PR,NR,NC,NA)
	IMPLICIT INTEGER (A-Z)
	LOGICAL PROB,QHERE
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
	ROBRM=0					#COUNT OBJECTS
	DO I=1,OLNT {				#LOOP ON OBJECTS.
	  IF(.NOT. QHERE(I,RM)) NEXT
	  IF((OTVAL(I).LE.0).OR.(AND(OFLAG2(I),SCRDBT).NE.0).OR.
		(AND(OFLAG1(I),VISIBT).EQ.0).OR.(.NOT.PROB(PR,PR)))
		GO TO 50
	  CALL NEWSTA(I,0,NR,NC,NA)
	  ROBRM=ROBRM+1
	  OFLAG2(I)=OFLAG2(I).OR.TCHBT
	  NEXT
50	  IF(AND(OFLAG2(I),ACTRBT).NE.0)
		ROBRM=ROBRM+ROBADV(OACTOR(I),NR,NC,NA)
	  }
	RETURN
	END

# WINNIN-- SEE IF VILLAIN IS WINNING
#
# DECLARATIONS
#
	LOGICAL FUNCTION WINNIN(VL,HR)
	IMPLICIT INTEGER (A-Z)
	LOGICAL PROB
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	VS=OCAPAC(VL)			#VILLAIN STRENGTH
	PS=VS-FIGHTS(HR,.TRUE.)		#HIS MARGIN OVER HERO
	WINNIN=PROB(90,100)
	IF(PS.GT.3) RETURN		#+3... 90% WINNING
	WINNIN=PROB(75,85)
	IF(PS.GT.0) RETURN		#>0... 75% WINNING
	WINNIN=PROB(50,30)
	IF(PS.EQ.0) RETURN		#=0... 50% WINNING
	WINNIN=PROB(25,25)
	IF(VS.GT.1) RETURN		#ANY VILLAIN STRENGTH.
	WINNIN=PROB(10,0)
	RETURN
	END

# FIGHTS-- COMPUTE FIGHT STRENGTH
#
# DECLARATIONS
#
	INTEGER FUNCTION FIGHTS(H,FLG)
	IMPLICIT INTEGER (A-Z)
	LOGICAL FLG
#
# GAME STATE
#
	COMMON /STATE/ MOVES,DEATHS,RWSCOR,MXSCOR,MXLOAD,
		LTSHFT,BLOC,MUNGRM,HS,EGSCOR,EGMXSC
#
# ADVENTURERS
#
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
		AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
#
# FUNCTIONS AND DATA
#
	DATA SMAX/7/,SMIN/2/
#
	FIGHTS=SMIN+((((SMAX-SMIN)*ASCORE(H))+(MXSCOR/2))/MXSCOR)
	IF(FLG) FIGHTS=FIGHTS+ASTREN(H)
	RETURN
	END

# VILSTR-	COMPUTE VILLAIN STRENGTH
#
# DECLARATIONS
#
	INTEGER FUNCTION VILSTR(V)
	IMPLICIT INTEGER (A-Z)
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
	COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
	COMMON /OINDEX/ WATER,ROPE,KNIFE,SWORD,LAMP,BLAMP,RUG
	COMMON /OINDEX/	LEAVE,TROLL,AXE
	COMMON /OINDEX/ RKNIF,KEYS,ICE,BAR
	COMMON /OINDEX/ COFFI,TORCH,TBASK,FBASK,IRBOX
	COMMON /OINDEX/ GHOST,TRUNK,BELL,BOOK,CANDL
	COMMON /OINDEX/ MATCH,TUBE,PUTTY,WRENC,SCREW,CYCLO,CHALI
	COMMON /OINDEX/ THIEF,STILL,WINDO,GRATE,DOOR
	COMMON /OINDEX/ HPOLE,LEAK,RBUTT,RAILI
	COMMON /OINDEX/ POT,STATU,IBOAT,DBOAT,PUMP,RBOAT
	COMMON /OINDEX/ STICK,BUOY,SHOVE,BALLO,RECEP,GUANO
	COMMON /OINDEX/ BROPE,HOOK1,HOOK2,SAFE,SSLOT,BRICK,FUSE
	COMMON /OINDEX/ GNOME,BLABE,DBALL,TOMB
	COMMON /OINDEX/ LCASE,CAGE,RCAGE,SPHER,SQBUT
	COMMON /OINDEX/ FLASK,POOL,SAFFR,BUCKE,ECAKE,ORICE,RDICE,BLICE
	COMMON /OINDEX/ ROBOT,FTREE,BILLS,PORTR,SCOL,ZGNOM
	COMMON /OINDEX/ EGG,BEGG,BAUBL,CANAR,BCANA
	COMMON /OINDEX/ YLWAL,RDWAL,PINDR,RBEAM
	COMMON /OINDEX/ ODOOR,QDOOR,CDOOR,NUM1,NUM8
	COMMON /OINDEX/ HANDS,WALL,LUNGS,SAILO,AVIAT,TEETH
	COMMON /OINDEX/ ITOBJ,EVERY,VALUA,OPLAY,WNORT,GWATE,MASTER
#
	COMMON /VILL/ VLNT,VILLNS(4),VPROB(4),VOPPS(4),VBEST(4),VMELEE(4)
#
# FLAGS
#
	LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL FOLLWF,SPELLF,sprf
	COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
		DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
		MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
			EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
		GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
		GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
		MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
		follwf,spellf,sprf(6)
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL

# VILSTR, PAGE 2
#
	VILSTR=OCAPAC(V)
	IF(VILSTR.LE.0) RETURN
	IF((V.NE.THIEF).OR..NOT.THFENF) GO TO 100
	THFENF=.FALSE.				#THIEF UNENGROSSED.
	VILSTR=MIN0(VILSTR,2)		#NO BETTER THAN 2.
#
100	DO I=1,VLNT {				#SEE IF  BEST WEAPON.
	  IF((VILLNS(I).EQ.V).AND.(PRSI.EQ.VBEST(I)))
		VILSTR=MAX0(1,VILSTR-1)
	  }
	RETURN
	END

# GTTIME-- GET TOTAL TIME PLAYED
#
# DECLARATIONS
#
	SUBROUTINE GTTIME(T)
	IMPLICIT INTEGER(A-Z)
#
	COMMON /TIME/ PLTIME,SHOUR,SMIN,SSEC
#
	CALL ITIME(H,M,S)
	T=((H*60)+M)-((SHOUR*60)+SMIN)
	IF(T.LT.0) T=T+1440
	T=T+PLTIME
	RETURN
	END
# OPNCLS-- PROCESS OPEN/CLOSE FOR DOORS
#
# DECLARATIONS
#
	LOGICAL FUNCTION OPNCLS(OBJ,SO,SC)
	IMPLICIT INTEGER (A-Z)
	LOGICAL QOPEN
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
# VERBS
#
	COMMON /VINDEX/ CINTW,DEADXW,FRSTQW,INXW,OUTXW
	COMMON /VINDEX/ WALKIW,FIGHTW,FOOW
	COMMON /VINDEX/ MELTW,READW,INFLAW,DEFLAW,ALARMW,EXORCW
	COMMON /VINDEX/ PLUGW,KICKW,WAVEW,RAISEW,LOWERW,RUBW
	COMMON /VINDEX/ PUSHW,UNTIEW,TIEW,TIEUPW,TURNW,BREATW
	COMMON /VINDEX/ KNOCKW,LOOKW,EXAMIW,SHAKEW,MOVEW,TRNONW,TRNOFW
	COMMON /VINDEX/ OPENW,CLOSEW,FINDW,WAITW,SPINW,BOARDW,UNBOAW,TAKEW
	COMMON /VINDEX/ INVENW,FILLW,EATW,DRINKW,BURNW
	COMMON /VINDEX/ MUNGW,KILLW,ATTACW,SWINGW
	COMMON /VINDEX/ WALKW,TELLW,PUTW,DROPW,GIVEW,POURW,THROWW
	COMMON /VINDEX/ DIGW,LEAPW,STAYW,FOLLOW
	COMMON /VINDEX/ HELLOW,LOOKIW,LOOKUW,PUMPW,WINDW
	COMMON /VINDEX/ CLMBW,CLMBUW,CLMBDW,TRNTOW
#
# FUNCTIONS AND DATA
#
	QOPEN(O)=AND(OFLAG2(O),OPENBT).NE.0
#
	OPNCLS=.TRUE.			#ASSUME WINS.
	IF(PRSA.EQ.CLOSEW) GO TO 100	#CLOSE?
	IF(PRSA.EQ.OPENW) GO TO 50	#OPEN?
	OPNCLS=.FALSE.			#LOSE
	RETURN
#
50	IF(QOPEN(OBJ)) GO TO 200	#OPEN... IS IT?
	CALL RSPEAK(SO)
	OFLAG2(OBJ)=OFLAG2(OBJ).OR.OPENBT
	RETURN
#
100	IF(.NOT.QOPEN(OBJ)) GO TO 200	#CLOSE... IS IT?
	CALL RSPEAK(SC)
	OFLAG2(OBJ)=AND(OFLAG2(OBJ),NOT(OPENBT))
	RETURN
#
200	CALL RSPEAK(125+RND(3))		#DUMMY.
	RETURN
	END

# LIT-- IS ROOM LIT?
#
# DECLARATIONS
#
	LOGICAL FUNCTION LIT(RM)
	IMPLICIT INTEGER (A-Z)
	LOGICAL QHERE
#
# ROOMS
#
	COMMON /ROOMS/ RLNT,RDESC2,RDESC1(215),REXIT(215),
		RACTIO(215),RVAL(215),RFLAG(215)
	INTEGER RRAND(215)
	EQUIVALENCE (RVAL,RRAND)
#
	COMMON /RFLAG/ RSEEN,RLIGHT,RLAND,RWATER,RAIR,
		RSACRD,RFILL,RMUNG,RBUCK,RHOUSE,RNWALL,REND
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
		OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
		NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
		TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
		WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
		TCHBT,VEHBT,SCHBT
#
# ADVENTURERS
#
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
		AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
#
	LIT=.TRUE.				#ASSUME WINS
	IF(AND(RFLAG(RM),RLIGHT).NE.0) RETURN	#ROOM LIT?
#
	DO I=1,OLNT {				#LOOK FOR LIT OBJ
	  IF(QHERE(I,RM)) GO TO 100		#IN ROOM?
	  OA=OADV(I)				#NO
	  IF(OA.LE.0) NEXT			#ON ADV?
	  IF(AROOM(OA).NE.RM) NEXT		#ADV IN ROOM?
#
# OBJ IN ROOM OR ON ADV IN ROOM
#
100	  IF(AND(OFLAG1(I),ONBT).NE.0) RETURN	#LIT?
	  IF((AND(OFLAG1(I),VISIBT).EQ.0).OR.
		((AND(OFLAG1(I),TRANBT).EQ.0).AND.
		(AND(OFLAG2(I),OPENBT).EQ.0))) NEXT
#
# OBJ IS VISIBLE AND OPEN OR TRANSPARENT
#
	  DO J=1,OLNT {
	    IF((OCAN(J).EQ.I).AND.(AND(OFLAG1(J),ONBT).NE.0))
		RETURN
	    }
	  }
	LIT=.FALSE.
	RETURN
	END

# WEIGHT- RETURNS SUM OF WEIGHT OF QUALIFYING OBJECTS
#
# DECLARATIONS
#
	INTEGER FUNCTION WEIGHT(RM,CN,AD)
	IMPLICIT INTEGER (A-Z)
	LOGICAL QHERE
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
		OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
		OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
		OADV(250),OCAN(250),OREAD(250)
#
	WEIGHT=0
	DO I=1,OLNT {				#OMIT BIG FIXED ITEMS.
	  IF(OSIZE(I).GE.10000) NEXT		#IF FIXED, FORGET IT.
	  IF((QHERE(I,RM).AND.(RM.NE.0)).OR.
		((OADV(I).EQ.AD).AND.(AD.NE.0))) GO TO 50
	  J=I					#SEE IF CONTAINED.
25	  J=OCAN(J)				#GET NEXT LEVEL UP.
	  IF(J.EQ.0) GO TO 100			#END OF LIST?
	  IF(J.NE.CN) GO TO 25
50	  WEIGHT=WEIGHT+OSIZE(I)
	  }
	RETURN
	END

# GHERE--	IS GLOBAL ACTUALLY IN THIS ROOM?
#
# DECLARATIONS
#
	LOGICAL FUNCTION GHERE(OBJ,RM)
	IMPLICIT INTEGER(A-Z)
#
# ROOMS
#
	COMMON /ROOMS/ RLNT,RDESC2,RDESC1(215),REXIT(215),
		RACTIO(215),RVAL(215),RFLAG(215)
	INTEGER RRAND(215)
	EQUIVALENCE (RVAL,RRAND)
#
	COMMON /RFLAG/ RSEEN,RLIGHT,RLAND,RWATER,RAIR,
		RSACRD,RFILL,RMUNG,RBUCK,RHOUSE,RNWALL,REND
#
	COMMON /RINDEX/ WHOUS,LROOM,CELLA
	COMMON /RINDEX/ MTROL,MAZE1	
	COMMON /RINDEX/ MGRAT,MAZ15	
	COMMON /RINDEX/ FORE1,FORE3,CLEAR,RESER
	COMMON /RINDEX/ STREA,EGYPT,ECHOR
	COMMON /RINDEX/ TSHAF	
	COMMON /RINDEX/ BSHAF,MMACH,DOME,MTORC
	COMMON /RINDEX/ CAROU	
	COMMON /RINDEX/ RIDDL,LLD2,TEMP1,TEMP2,MAINT
	COMMON /RINDEX/ BLROO,TREAS,RIVR1,RIVR2,RIVR3,MCYCL
	COMMON /RINDEX/ RIVR4,RIVR5,FCHMP,FALLS,MBARR
	COMMON /RINDEX/ MRAIN,POG,VLBOT,VAIR1,VAIR2,VAIR3,VAIR4
	COMMON /RINDEX/ LEDG2,LEDG3,LEDG4,MSAFE,CAGER
	COMMON /RINDEX/ CAGED,TWELL,BWELL,ALICE,ALISM,ALITR
	COMMON /RINDEX/ MTREE,BKENT,BKVW,BKTWI,BKVAU,BKBOX
	COMMON /RINDEX/ CRYPT,TSTRS,MRANT,MREYE
	COMMON /RINDEX/ MRA,MRB,MRC,MRG,MRD,FDOOR
	COMMON /RINDEX/ MRAE,MRCE,MRCW,MRGE,MRGW,MRDW,INMIR
	COMMON /RINDEX/ SCORR,NCORR,PARAP,CELL,PCELL,NCELL
#
	COMMON /STAR/ MBASE,STRBIT

# GHERE, PAGE 2
#
	GHERE=.TRUE.				#ASSUME WINS.
	GO TO (1000,1000,1000,1000,1000,1000,
		1000,1000,1000,1000,1000,
		2000,3000,4000,5000,5000,5000,6000,
		7000,8000,9000,9100,8000,10000),OBJ-STRBIT
	CALL BUG(60,OBJ)
#
# 1000--	STARS ARE ALWAYS HERE
#
1000	RETURN
#
# 2000--	BIRD
#
2000	GHERE=((RM.GE.FORE1).AND.(RM.LT.CLEAR)).OR.(RM.EQ.MTREE)
	RETURN
#
# 3000--	TREE
#
3000	GHERE=((RM.GE.FORE1).AND.(RM.LT.CLEAR)).AND.(RM.NE.FORE3)
	RETURN
#
# 4000--	NORTH WALL
#
4000	GHERE=(RM.GE.BKVW).AND.(RM.LE.BKBOX)
	RETURN
#
# 5000--	EAST, SOUTH, WEST WALLS
#
5000	GHERE=(RM.GE.BKVW).AND.(RM.LT.BKBOX)
	RETURN
#
# 6000--	GLOBAL WATER
#
6000	GHERE=AND(RFLAG(RM),(RWATER+RFILL)).NE.0
	RETURN
#
# 7000--	GLOBAL GUARDIANS
#
7000	GHERE=((RM.GE.MRC).AND.(RM.LE.MRD)).OR.((RM.GE.MRCE).AND.(RM.LE.MRDW)).OR.(RM.EQ.INMIR)
	RETURN
#
# 8000--	ROSE/CHANNEL
#
8000	GHERE=((RM.GE.MRA).AND.(RM.LE.MRD)).OR.(RM.EQ.INMIR)
	RETURN
#
# 9000--	MIRROR
# 9100		PANEL
#
9100	IF(RM.EQ.FDOOR) RETURN			#PANEL AT FDOOR.
9000	GHERE=((RM.GE.MRA).AND.(RM.LE.MRC)).OR.((RM.GE.MRAE).AND.(RM.LE.MRCW))
	RETURN
#
# 10000--	MASTER
#
10000	GHERE=(RM.EQ.FDOOR).OR.(RM.EQ.NCORR).OR.(RM.EQ.PARAP).OR.(RM.EQ.CELL)
	RETURN
#
	END

# MRHERE--	IS MIRROR HERE?
#
# DECLARATIONS
#
	INTEGER FUNCTION MRHERE(RM)
	IMPLICIT INTEGER(A-Z)
#
# ROOMS
#
	COMMON /RINDEX/ WHOUS,LROOM,CELLA
	COMMON /RINDEX/ MTROL,MAZE1	
	COMMON /RINDEX/ MGRAT,MAZ15	
	COMMON /RINDEX/ FORE1,FORE3,CLEAR,RESER
	COMMON /RINDEX/ STREA,EGYPT,ECHOR
	COMMON /RINDEX/ TSHAF	
	COMMON /RINDEX/ BSHAF,MMACH,DOME,MTORC
	COMMON /RINDEX/ CAROU	
	COMMON /RINDEX/ RIDDL,LLD2,TEMP1,TEMP2,MAINT
	COMMON /RINDEX/ BLROO,TREAS,RIVR1,RIVR2,RIVR3,MCYCL
	COMMON /RINDEX/ RIVR4,RIVR5,FCHMP,FALLS,MBARR
	COMMON /RINDEX/ MRAIN,POG,VLBOT,VAIR1,VAIR2,VAIR3,VAIR4
	COMMON /RINDEX/ LEDG2,LEDG3,LEDG4,MSAFE,CAGER
	COMMON /RINDEX/ CAGED,TWELL,BWELL,ALICE,ALISM,ALITR
	COMMON /RINDEX/ MTREE,BKENT,BKVW,BKTWI,BKVAU,BKBOX
	COMMON /RINDEX/ CRYPT,TSTRS,MRANT,MREYE
	COMMON /RINDEX/ MRA,MRB,MRC,MRG,MRD,FDOOR
	COMMON /RINDEX/ MRAE,MRCE,MRCW,MRGE,MRGW,MRDW,INMIR
	COMMON /RINDEX/ SCORR,NCORR,PARAP,CELL,PCELL,NCELL
#
# FLAGS
#
	LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL FOLLWF,SPELLF,sprf
	COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
		DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
		MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
		EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
		GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
		GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
		MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
		follwf,spellf,sprf(6)
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL

# MRHERE, PAGE 2
#
	IF((RM.LT.MRAE).OR.(RM.GT.MRDW)) GO TO 100
#
# RM IS AN E-W ROOM, MIRROR MUST BE N-S (MDIR= 0 OR 180)
#
	MRHERE=1			#ASSUME MIRROR 1 HERE.
	IF(MOD(RM-MRAE,2).EQ.(MDIR/180)) MRHERE=2
	RETURN
#
# RM IS NORTH OR SOUTH OF MIRROR.  IF MIRROR IS N-S OR NOT
# WITHIN ONE ROOM OF RM, LOSE.
#
100	MRHERE=0
	IF((IABS(MLOC-RM).NE.1).OR.(MOD(MDIR,180).EQ.0)) RETURN
#
# RM IS WITHIN ONE OF MLOC, AND MDIR IS E-W
#
	MRHERE=1
	IF(((RM.LT.MLOC).AND.(MDIR.LT.180)).OR.((RM.GT.MLOC).AND.(MDIR.GT.180)))
		MRHERE=2
	RETURN
	END

# ENCRYP--	ENCRYPT PASSWORD
#
# DECLARATIONS
#
	SUBROUTINE ENCRYP(INW,OUTW)
	IMPLICIT INTEGER(A-Z)
	LOGICAL INW(6),OUTW(6),KEYW(6)
	INTEGER UINW(6),UKEYW(6)
	DATA KEYW/'E','C','O','R','M','S'/
#
	UINWS=0					#UNBIASED INW SUM.
	UKEYWS=0				#UNBIASED KEYW SUM.
	J=1					#POINTER IN KEYWORD.
	DO I=1,6 {				#UNBIAS, COMPUTE SUMS.
	  UKEYW(I)=(KEYW(I)/o'4000000000')-o'100'	#STRIP ASCII.
	  IF((INW(J)/o'4000000000').LE.o'100') J=1	#RECYCLE ON BAD.
	  UINW(I)=(INW(J)/o'4000000000')-o'100'
	  UKEYWS=UKEYWS+UKEYW(I)
	  UINWS=UINWS+UINW(I)
	  J=J+1
	  }
#
	USUM=MOD(UINWS,8)+(8*MOD(UKEYWS,8))	#COMPUTE MASK.
	DO I=1,6 {
	  J=AND(XOR(XOR(UINW(I),UKEYW(I)),USUM),o'37')
	  USUM=MOD(USUM+1,32)
	  IF(J.GT.26) J=MOD(J,26)
	  OUTW(I)=MAX0(1,J)*o'4000000000'+'@'
	  }
	RETURN
#
	END
	INTEGER FUNCTION RND(X)
	INTEGER X
#
	RND = INT(FLOAT(X) * RAN(FOO))
	END
