.TH BTOA 1 local
.SH NAME
btoa, atob, tarmail, untarmail \- encode/decode binary to printable ASCII
.SH SYNOPSIS
.B btoa
.br
.B atob
.br
.B tarmail
who subject files ...
.br
.B untarmail
[ file ]
.SH DESCRIPTION
.I Btoa
is a filter that reads anything from the standard input, and encodes it into
printable ASCII on the standard output.  It also attaches a header and checksum
information used by the reverse filter 
.I atob 
to find the start of the data and to check integrity.
.PP
.I Atob
reads an encoded file, strips off any leading and
trailing lines added by mailers, and recreates a copy of the original file
on the standard output.
.I Atob 
gives NO output (and exits with an error message) if its input is garbage or 
the checksums do not check.
.PP
.I Tarmail
is a shell script that tar's up all the given files, pipes them 
through 
.IR compress ","
.IR btoa ","
and mails them to the given person with the given subject phrase.  For
example:
.PP
.in 1i
tarmail ralph "here it is ralph" foo.c a.out
.in -1i
.PP
Will package up files "foo.c" and "a.out" and mail them to "ralph" using
subject "here it is ralph".  Notice the quotes on the subject.  They are
necessary to make it one argument to the shell.
.PP
.I Tarmail 
with no args will print a short message reminding you what the required args 
are.  When the mail is received at the other end, that person should use
mail to save the message in some temporary file name (say "xx").
Then saying "untarmail xx"
will decode the message and untar it.  
.I Untarmail 
can also be used as a filter.  By using 
.IR tarmail ","
binary files and
entire directory structures can be easily transmitted between machines.
Naturally, you should understand what tar itself does before you use 
.IR tarmail "."
.PP
Other uses:
.PP
compress < secrets | crypt | btoa | mail ralph
.PP
will mail the encrypted contents of the file "secrets" to ralph.  If ralph
knows the encryption key, he can decode it by saving the mail (say in "xx"),
and then running:
.PP
atob < xx | crypt | uncompress
.PP
(crypt requests the key from the terminal,
and the "secrets" come out on the terminal).
.SH AUTHOR
Paul Rutter
.SH FEATURES
.I Btoa
uses a compact base-85 encoding so that
4 bytes are encoded into 5 characters (file is expanded by 25%).
As a special case, 32-bit zero is encoded as one character.  This encoding
produces less output than
.IR uuencode "(1)."
.SH "SEE ALSO"
compress(1), crypt(1), uuencode(1), mail(1)
