#
#include "hsh.h"

read1(ca)
char *ca;
{
	register cc, tc;

	if (rlp >= irlp || ca == 0) {
		if ((cc = erlp - irlp) <= 0) {
			if (rlp < irlp) return(0);
			rlp = rlbuf;
			irlp = rlbuf;
			cc = RLBSIZ;
		}
		nlflag = 0;	/* init. nlflag, used in err2() */
	    reread:
		putc(0);	/* flush output buffer */
		tc = readline(0, irlp, cc);
		if (echflag && tc > 0) write(2, irlp, tc);
		irlp =+ tc;
		if (irlp <= brlp) {	/* eof at beg. of line means bye */
			if (promp == 0) return(0);
			prsfill("bye");	/* bye<esc> */
			rlp = brlp;
		}
		switch (irlp[-1]) {
		case LINEDEL:
			reset();
		case CHARDEL:
			irlp--;
			if (irlp > rlp) {
				putc(*--irlp);
				cc++;
			} else
				putc(7);
			goto reread;
		case '\r':
			irlp[-1] = '\n';
		case '\n':
			break;
		default:
			if (irlp == erlp) break;
			*irlp++ = ESC;	/* here cntrl/d == esc */
		case ESC:
			/* if esc hit twice at same point --> error */
			if (--tc <= 0 && lastesc == irlp)
				err2(*svargp,": not a harvard shell command");
			lastesc = irlp;
		}
		if (ca == 0) return(0);	/* arg of zero */
	}
	*ca = *rlp++;
	return(1);
}

prsfill(str)
char *str;
{

	register char *sp1, *sp2, *sp3;

	if (promp == 0) return(0);
	sp1 = str;
	sp2 = rlp;
	sp3 = erlp;
	while (sp2 < sp3) {
		if ((*sp2++ = *sp1++) > 0) continue;
		if (*--sp2 == 0) {
			prs(rlp);	/* echo string */
			rlp = sp2;
			irlp = sp2;
			return(0);
		}
		/* add in a '\' because was quoted before */
		*sp2++ = '\\';
		if (sp2 >= sp3) break;
		*sp2++ = sp1[-1] & 0177;
	}
	putc(7);	/* no room, just bing! */
	return(-1);
}

prompt()
{
	terminators = "\n\r";	/* newline, cr, esc */
	retypeptr = rlp = irlp = rlbuf;
	erlp = &rlbuf[RLBSIZ];
	lastesc = 0;
	if (!promp) {
		brlp = irlp;
		return;
	}
	signal(INTR, &resetsh);
	signal(QUIT, &resetsh);
	ttmode[2] =| DDTMODE;
	stty(2, ttmode);
	if (prepromp) putc(*rlp++ = prepromp);
	prsfill(promp);
	brlp = irlp;
	return;
}

unprompt()
{
	putc(0);	/* flush output buffer */
	if (!promp) return;
	signal(INTR, 1);
	signal(QUIT, 1);
	ttmode[2] =& ~DDTMODE;
	stty(2, ttmode);
}

complete(longer, short)
char *longer, *short;
{
	while(*short++) longer++;
	if (*longer) prsfill(longer);
}

putc(c)
{
	static char putbuf[41];	/* extra char for nl if needed */
	static char *putbp;
	register char *cp;

	if (c == ESC) return;	/* don't output escape code */
	if ((cp = putbp) == 0) cp = putbuf;
	if (c == '\n') {
		*cp++ = c;
		c = 0;
	}
	if (cp >= &putbuf[40] || c == 0) {
		write(2, putbuf, cp-putbuf);
		cp = putbuf;
	}
	if ((*cp++ = c) == 0) cp--;
	putbp = cp;
}

resetsh()
{
	signal(INTR, 1);
	signal(QUIT, 1);
	reset();
}
mvstrg(str, bufp, ebufp)
char *str, *bufp, *ebufp;
{
	register char *s1, *s2, *s3;

	s1 = bufp;
	s2 = str;
	s3 = ebufp;
	do if (s1 >= s3) return(0);
	  while (*s1++ = *s2++);
	return (--s1);
}

err2(str1, str2)
char *str1, *str2;
{
	if (nlflag == 0) {
		nlflag++;
		if (irlp[-1] == ESC) prs(NEWLINE);
	}
	prs(str1);
	prs(str2);
	prs(NEWLINE);
	gflg++;
}

chkconf()
{
	register char *yesp, c;
	register notconf;

	/* return 1 if confirmed, otherwise 0 */
	if (!promp) return(1);
	notconf = 0;
	yesp = "yes";
	prsfill(" [confirm]");
	while (c = getc()) {
		switch(c) {
		case ' ':
		case '\t':
			continue;
		case ESC:
			prs(NEWLINE);
		case '\n':
			if (notconf) return(0);	/* not confirmed */
			return(1);
		default:
			if (c != *yesp++) {
				yesp--;		/* prevent memfault */
				notconf++;
			}
			continue;
		}
	}
}
