#

/*	deass -- logically deassign devices
 *
 *	usage:	deass dev1 [dev2 [dev3 ... ] ]
 *	
 *	description:  deass logically deassigns devices that can be
 *		deassigned.  Together with it's companion procedure 
 *		ass, deass protects a system resource from external
 *		(anyone but the owner and the omnipotent super-user)
 *		interference.  Ass and deass can easily be thought of
 *		as a "begin/end" pair that enclose (protect) a device. 
 *		it is to everyone's advantage to use these two procedures;
 *		the small amount of inconvenience to type in the command
 *		will be compensated for when one day some uncautious user
 *		attempts to write on your dec-tape backup (which,
 *		because of a system crash, is the only remaining source
 *		version of a 10000 line program that you want to modify...). 
 *		If you're smart, you get the point.
 *
 *	note:   deassingments can only be done to devices owned
 *		by the requesting user.
 *
 *	assumptions:	1)  maximum filename is 14 chars long
 *			2)  maximum user name (logon name) is 8 chars long
 *			3)  maximum devicename is 19 chars long
 *
 *	files:	/etc/passwd		password file
 *		/etc/utmp		user information
 *		/usr/sys/sbuf.h		inode structure for "stat" calls
 *
 *	source:	/usr/pavo/deass.c
 *
 *	object:	/usr/bin/deass
 *	
 *	see also:  /usr/pavo/ass.c
 *
 *					...  pavo 	11-76
 */

#include	"/usr/sys/sbuf.h"	/*inode structure for "stat" */
#define		bin	3		/*system id  */
#define		isvtx 	01000		/*assignable device flag */
#define		unprot	01666		/* unprotected file mode */



main(argc,argp)
int	argc;
char	**argp;

{	int	argnum;
	argnum	= 0;

	if(argc == 1)
		printf("USAGE:  deass  dev1 [dev2 [dev3 ... ] ] \n");
	else  {
		while((++argnum) < argc)
			deassign(argp[argnum]);
	}
	exit(0);			/*normal termination */
}

/*	deassign -- deassign the next device
 *
 *	usage:	deassign(devicename)
 *
 *	steps:	1)  declare and initialize local variables
 *		2)  check for first 5 chars of devicename equal to
 *		    "/dev/";  if not, prefix devicename with "/dev/"
 *		3)  check status of device and current owner;
 *		    if device is assignable and current owner is not the
 *		    system, check to see if the requesting user is the
 *		    current owner.  If so, deassign (return) the device.
 *		    In all other cases, do not change the device's mode
 *		    or owner.
 *
 *					...  pavo	11-76
 */

deassign(devname)
char	*devname;

/*	<step 1>	*/
{	char	*devprefx,  *dev;
	char	devbuf[20];
	int	i,	user;
	struct	inode	sbuf;
	devprefx = "/dev/";
	dev	= devbuf;

/*	<step 2> 	*/
	i = 0;
	while(i < 5  &&  *devname != '\0')  {
		*dev++  = *devname++;
		i++;
	}
	devname =- i;
	*dev = 0;
	dev = devbuf;
	if((compstr(devprefx,dev))  != 1)  {
		while(*dev++  =  *devprefx++)  {}
		dev--;
		while(*dev++  =  *devname++)   {}
		devname = devbuf;
	}
	
/*	<step 3>	*/
	if(stat(devname,&sbuf) < 0)
		return;
	if((sbuf.i_mode & isvtx)  !=  isvtx)
		return;
	user = getuid()  &  0377;
	if((user  !=  sbuf.i_uid)  &&  (logdin(sbuf.i_uid)))  {
		dev = getun(sbuf.i_uid);
		printf("%s:	assigned to %s\n",devname,dev);
	}
	else
		chdev(devname);
	return;
}
/*	logdin -- find if a user is still logged-on to UNIX 
 *
 *	usage:	LOGDIN(userid)
 *	        where   "userid" is returned from a "getuid" call
 *
 *	returns:
 *		 0	"userid" is not currently logged-on
 *		 1	"userid" is currently logged-on
 *
 *	steps:	1)  declare and initialize local variables.
 *		2)  get device owner's name from password file pointed at
 *		    by argument passed to logdin.
 *		3)  scan utmp file for logged-on user; return appropriate
 *		    flag depending on result.
 *
 *					...  pavo	10-76
 */

logdin(usid)
int	usid;

/*	<step 1>	*/
{	char	*online,  *devowner;
	char	onlinbuf[16];
	int	fdes;
	online 	= onlinbuf;

/*	<step 2>	*/
	devowner = getun(usid);
	if(devowner == -1)  
		return(0);
	
/*	<step 3>	*/
	fdes = open("/etc/utmp",0);
	while(read(fdes,online,16) == 16) {
		if(*online  !=  '\0')  {
			online = onlinbuf;
			online[8] = 0;
			while(*online++  !=  ' ')  {}
			online--;
			*online = '\0';
			online = onlinbuf;
			if(compstr(online,devowner) > 0)  {
				close(fdes);
				return(1);
			}
		}
	}
	close(fdes);
	return(0);
}

/*	getun -- get a user name given its index
 *
 *	usage:	getun(userid)
 *		where 	"userid" is an integer returned from a "getpw" call
 *
 *	returns:
 *  		?   -   a pointer to the null-terminated name
 *	       -1   -	error
 *
 *	steps:	1)  declare and initialize local variables.
 *		2)  get user's process word and extract user name.
 *
 *					...  pavo	11-76
 */

getun(userid)
int	userid;

/*	<step 1>	*/
{	static 	char   tempbuf[10];
	char	namebuf[75];
	char	*temp,	*name;
	name 	= namebuf;
	temp	= tempbuf;

/*	<step 2> 	*/
	if(getpw(userid,name)	!=  0)  {
		return(-1);
	}
	name = namebuf;
	while((*temp++ = *name++) != ':')  {}
	temp--;
	*temp = 0;
	name = tempbuf;
	return(name);
}

/*	compstr -- compare two strings
 *
 *	usage:	compstr(str1,str2)
 *		where	"str1" is a pointer to a string,
 *			"str2" is a pointer to a string,
 *
 *
 *	returns:	1   -   strings are equal
 *			0   -   strings are unequal
 *
 *	steps:	1)  declare and initialize variables
 *		2)  get sizes of both strings (terminated with '0')
 *		3)  check char with char 
 *		4)  return appropriate flag
 *
 *					...  pavo	11-76
 */

compstr(first,second)
char	*first,	*second;

/*	<step 1>	*/
{	int	i,	size;
	size  =  i  =  0;

/*	<step 2>	*/
	size = sizstr(first);
	if(size != (sizstr(second)))
		return(0);
	while(*first != '\0'  &&  *first++  ==  *second++)
		i++;

/*	<step 3>	*/
	if(i == size)
		return(1);
	else	
		return(0);
}

/*	sizstr -- get the size of a string
 *
 *	usage:	sizstr(string)
 *		where "string" is a character pointer pointing to
 *			a null-terminated ('0') string.
 *
 *	returns:  the size of the string
 *
 *	important:  "string" MUST be terminated by '0' for "sizstr" to
 *		work correctly.
 *
 *	steps:	1)  declare and initialize all local variables.
 *		2)  find and return size of the string.
 *
 *					...  pavo	11-76
 */

sizstr(str)
char	*str;

/*	<step 1>	*/
{	int	size;
	size	= 0;

/*	<step 2>	*/
	while(*str++  !=  '\0')  {
		size++;
	}
	return(size);
}

/*	chdev -- change id and mode of a device
 *
 *	usage:	chdev(devname)
 *
 *	returns:   1   -   successful
 *		  -1   -   unsuccessful
 *
 *	note:  This version will always change the device's id to that
 *		of the system (bin = 3); the mode will always be
 *		changed to "unprotected", allowing all users to request
 *		the device's assignment.
 *
 *	steps:	1)  declare and initialize local variables.
 *		2)  change mode and owner of device 
 *
 *					...  pavo	11-76
 */

chdev(devname)
char	*devname;

/*	<step 1>	*/
{	char	*name;
	struct	inode	sbuf;

/*	<step 2>	*/
	chown(devname,(bin<<8)|bin);
	chmod(devname,unprot);
	printf("%s:	now unassigned\n",devname);
	return(1);
}

