#include	"/mnt/muir/con-source/con.h"
int     srtflag;					/* line control, stop flag	 */
/*
*	misc declarations
*/
int     i;						/* for statement incrementor		 */
int     stop;						/* character initiating line control stop	 */
int     start;						/* character initiating line control start	 */
char    c;						/* one character buffer for local input	 */
char    buf[BUFLEN];					/* the children's buffer		 */
int     l;						/* length of remote reads		 */
int     skill ();					/* kill of send process		 */
int     writef ();					/* write string to file		 */
int     writef1 ();					/* write string to standard output   */
int     writenl ();					/* write newline on standard output    */
main (argc, argv)
int     argc;
char   *argv[];
{
    read (PIPER, &p, PSIZE);
    signal (SIGHUP, skill);
    loop
    {
	srtflag = 0;
	if (p.start && p.stop)
	    {
							/*  flush the ldcon pipe because there might be a lot of junk
							   in it if lots of line starts have occurred since its last
							   use.  we start processing the line starts when the buffer
							   returned has a length less than
							   BUFLEN.			 */
	    while ((l = read (p.ldcon[0], buf, BUFLEN)) > 0)
		{
		if (l < BUFLEN)
		    {
		    for (i = 0; i < l; i++)
			{
			if (buf[i] == STX)
			    {
			    srtflag++;
			    }
			}
		    break;
		    }
		}
	    }
	else
	    {
	    srtflag++;
	    }
	while (srtflag)
	    {
	    c = getchar (p.fls);
	    if (c == NL)
		c = CR;
	    if (c <= 0)
		{
		writef1 ("Transmit EOF\n\r");
		close (p.fls);
		exit ();
		}
	    write (p.fro, &c, 1);
	    if (c == p.stop)
		break;
	    }
    }
}
/*
Name:
	getchar
Function:
	To read a character from a specified file.
Algorithm:
	Do a read, and if we got an end of file, return a -1.
	CAVEAT	Input is unbuffered.
Parameters:
	int	file descriptor of file to be read from.
Returns:
	char	or -1
Globals:
Calls:
	read()
Called by:
X	lots of people
History:
	Someone at berkeley.
*/
char    getchar (cfd) int   cfd;
{
    char    bc;
    return read (cfd, &bc, 1) <= 0 ? IOERR : bc & 0177;
}
/*	kill off send process when going down or another send process
*	is going to be initiated
*/
skill ()
{
    writef1 ("Transmit abort\n\r");
    close (p.fls);
    exit ();
}
/*
Name:
	writef and writef1 and writeln
Function:
	Write a null terminated string without the terminator.  (Writef1 is
	a printf substitute which is adequate and faster when only strings are
	printed--as in this program).  (Writeln writes a new line on the
	standard output.)
Algorithm:
	Determine the length of the string.  Write it out. (Writef1 writes to standard output only.)
 CAVEAT	This call is not buffered, so use it carefully or pay the cost
	of high I/O expense.  It was writted to decrease subroutine linkage
	global variable referencing and module size.  But those gains can
	easily be lost if writef is consistantly called with small strings
	where buffered i/o would be possible.
Parameters:
	int	file descriptor of output file (not present in writef1 or writeln).
	*char	pointer to null terminated string (not present in writeln).
Returns:
	int	value returned by write.
Globals:
Calls:
	write()		(writef1 calls writef and writeln calls writef1)
Called by:
	lotsa people
History:
	Initially coded by Mark Kampe 11/22/75
	Writef1 and writenl written by Rick Balocca 8/1/76
*/
writef (afd, str) int   afd;
char   *str;
{
    register char  *r;
    register char  *s;
    s = str;
    r = s;
    while (*s++);
    return write (afd, r, --s - r);
}
writef1 (str) char *str;
{
    return writef (1, str);
}
writenl ()
{
    return writef1 ("\n");
}
