#include	"/mnt/muir/con-source/con.h"
int     savstat[3];					/* saved status of tty			 */
int     orstat[3];					/* old remote tty status, saved when doing a break to remote
							   system  */
int     escstat[3];					/* escape processing status	 */
							/* brkstat sets speed to 50 baud to cause framing error (break)
							   on remote system  */
int     brkstat[3]
{
    000401, 000000, EVENP + RAW + HUPCL
};
							/* dlstat sets speed for dialer adapter during dialing
							   phase		 */
int     dlstat[3]
{
    003407, 000000, ANYP + RAW + HUPCL
};
/*
*	flag variables
*/
int     nflag;						/* dial number in buffer flag	 */
int     sflag;						/* send file flag		 */
int     srtflag;					/* line control, stop flag	 */
/*
*	misc declarations
*/
int     max;						/* maximum array length of pnum		 */
int     i;						/* for statement incrementor		 */
char   *sp;						/* string pointer	 */
#define	DDIGIT	24
#define	PDIGIT	20
int     prid;						/* process id of the children		 */
int     sprid;						/* process id of sending process	 */
char    c;						/* one character buffer for local input	 */
char    lc;						/* one character buffer for line control pipe	 */
char    buf[BUFLEN];					/* the children's buffer		 */
char    fbuf[BUFLEN];					/* buffer for receive file, no carriage returns  */
int     l;						/* length of remote reads		 */
char    rdev[] "/dev/ttyx\0";				/* tty string to be completed when the real remote tty port is
							   found	 */
char    tdev[] "/dev/ttyx";				/* tty string to be completed when the real local tty port is
							   found	 */
char    rlock[] "/usr/dpd/lockx";			/* lock filename string to be completed by input
							   arguments	 */
char    filename[BUFLEN];				/* buffer for passing names 		 */
int     onhup;						/* hang-up interupt interceptor		 */
int     onquit;						/* qinterceptor		 */
int     ask ();						/* ask a question of the local tty    */
int     skill ();					/* kill of send process		 */
int     catch ();					/* catch interupts to parent	 */
int     cleanup ();					/* close up files, kill children and stty */
int     writef ();					/* write string to file		 */
int     writef1 ();					/* write string to standard output   */
int     writenl ();					/* write newline on standard output    */
int     escmode ();					/* escape mode of raw and echo		 */
int     remode ();					/* remote mode				 */
int     locmode ();					/* local mode in con			 */
int     brkmode ();					/* mode to do a break			 */
int     dlmode ();					/* mode for dialer			 */
int     oldmode ();					/* old local mode beforecon was entered */
/*	parent process; Controls both children thru pipe connections
*	(ldcon) and (filcom) and signal interupts.
*	Copies from local terminal to remote tty port and handles
*	all escape processing as well as file transmission and dialing.
*	the parent process kills off the children before exiting
*	to UNIX, this ensures that the remote tty port will be
*	disconnected from the modem.
*/
main (argc, argv)
int     argc;
char   *argv[];
{
    read (PIPER, &p, PSIZE);
    write (p.ctrl[1], &p, PSIZE);
    if (p.pnum[0])
	nflag++;
    if ((prid = fork ()) == 0)
	{
	execl ("/usr/dpd/conb", "conback", 0);
	}
    escstat[0] = p.olstat[0];
    escstat[1] = p.olstat[1];
    escstat[2] = p.olstat[2] | (CRMOD + RAW + XTABS);
    if ((nflag) && ((dial (p.pnum)) <= 0))
	{
	cleanup ();
	exit ();
	}
    loop
    {
	while ((read (p.fli, &c, 1)) > 0)
	    {
	    if (c == ESC)
		{
		escmode ();
		read (p.fli, &c, 1);
		switch (c)
		    {
		    case KILL: cleanup ();
			break;
		    case SEND: 
			locmode ();
			oldmode ();
			send (ONE);
			locmode ();
			continue;
		    case QSND: send (ZERO);
			locmode ();
			continue;
		    case RECV: 
			locmode ();
			oldmode ();
			recvc (TWO);
			locmode ();
			continue;
		    case QREC: recvc (THREE);
			locmode ();
			continue;
		    case BRK: brk ();
			locmode ();
			continue;
		    case ESP: 
			locmode ();
			oldmode ();
			unix ();
			locmode ();
			continue;
		    case HELP: 
			help ();
			locmode ();
			continue;
		    case ESC: 
			locmode ();
			break;
		    default: 
			writef1 (" Bad\r\n");
			locmode ();
			continue;
		    }
		}
	    if (c == NL)
		c = CR;
	    write (p.fro, &c, 1);
	    }
    }
}
/*
Name:
	ask
Function:
	Collect an line from the terminal.  If the line starts with a 'y' or
	a 'Y', return true, otherwise return false;
Algorithm:
	Loop, getting characters until new line is encountered.  If a 'y' or a
	'Y' was encountered, set answer to true.
Parameters:
	str	char	* string to be printed before answer is collected.
Returns:
	The variable answer, set according to algorithm above.
Globals:
	none.
Calls:
	getchar
	writef1
is called by:
	main
	send
"History:
	Written by Rick Balocca 7/30/76
*/
ask (str) char *str;
{
    register int    answer;
    writef1 (str);					/* 	ask the question	 */
    answer = FALSE;					/* 	assumed answer is false	 */
    loop
	switch (getchar (0))
	{
	case IOERR: 
	case '\n': return answer;
	case 'Y': 
	case 'y': answer = TRUE;
	}
    return answer;
}
brk ()
{							/*  send break to remote system  	 */
    char    bc;
    bc = NULL;
    brkmode ();
    write (p.fro, &bc, 1);
    sleep (1);
    remode ();
    return;
}
cleanup ()
{							/*  close files in children, kill childs and exit	 */
    if (prid)
	kill (prid, SIGHUP);
    if (sprid)
	kill (sprid, SIGHUP);
    sleep (2);
    if (prid)
	kill (prid, SIGKIL);
    stty (p.fli, p.olstat);
    rlock[13] = p.tty;
    unlink (rlock);
    sleep (1);
    writenl ();
    sleep (1);
    exit ();
}
dial (num) char *num;
{							/*  dial number for remote connection	 */
    char    dstr[DDIGIT];
    char    abort;
    char    trailer[2];
    char    header;
    extern char lc;
    abort = SOH;
    header = STX;
    trailer[0] = SI;
    trailer[1] = ETX;
    sleep (3);
    dlmode ();
    oldmode ();
    loop
    {
	max = 0;
	dstr[max++] = header;
	for (i = 0; num[i] != '\0'; i++)
	    dstr[max++] = num[i];
	dstr[max++] = trailer[0];
	dstr[max++] = trailer[1];
	dstr[max] = NULL;
	writef (p.fro, dstr);
	writef1 ("Trying...\n");
	if ((read (p.ldcon[0], &lc, 1)) > 0)
	    {						/* read the pipe for status  */
	    switch (lc)
		{
		case DSS: 
		    kill (prid, SIGINT);
		    writef1 ("  Open \n\r");
		    nflag = 0;
		    remode ();
		    locmode ();
		    return '1';
		case FRAMER: writef1 ("Dialer framing error\n");
		    return IOERR;
		case PTYERR: writef1 ("Dialer parity error\n");
		    return IOERR;
		case OVERUN: writef1 ("Dialer overrun\n");
		    return IOERR;
		case DLO: writef1 ("Dialer busy\n");
		    return IOERR;
		case ACR: printf ("Busy signal on %s\n", num);
		    if ((ask ("Try another number?")) <= 0)
			return IOERR;
		}
	    }
	writenl ();
	writef1 ("Number?=");
	gather (num, p.fli);
	writenl ();
    }
}
dlmode ()
{
    gtty (p.fri, orstat);
    stty (p.fri, dlstat);
}
escmode ()
{
    gtty (p.fli, savstat);
    stty (p.fli, escstat);
}
/*
Name:
	gather
Function:
	Read a single line of console input into the user specified
	buffer.  Standard unix editing is in effect.
Algorithm:
	Read a character:
	If it is an unescaped new line, null terminate the buffer and return.
	Otherwise, stash the character into the buffer.
	If the length of the buffer has been reached, echo a new line and
	return.
Parameters:
	*char	pointer to user buffer of length STRINGLEN
Returns:
	nothing
Globals:
	STRINGLEN
Calls:
	getchar
	slashc
Called by:
	main
	send
History:
	Recoded by Mark Kampe 11/22/75
	Rerecoded by R. B.
*/
gather (gsp, fds) char *gsp;
int     fds;
{
    register int    gc;
    register int    gi;
    register char  *ptr;
    ptr = gsp;
    for (gi = STRINGLEN + 1; --gi;)
	{
	gc = getchar (fds);
	if (gc < 0 || gc == '\n')
	    break;
	else
	    *ptr++ = gc == "\\" ? slashc (fds) : gc;
	}
    *ptr = '\0';
}
/*
Name:
	getchar
Function:
	To read a character from a specified file.
Algorithm:
	Do a read, and if we got an end of file, return a -1.
	CAVEAT	Input is unbuffered.
Parameters:
	int	file descriptor of file to be read from.
Returns:
	char	or -1
Globals:
Calls:
	read()
Called by:
X	lots of people
History:
	Someone at berkeley.
*/
char    getchar (cfd) int   cfd;
{
    char    bc;
    return read (cfd, &bc, 1) <= 0 ? IOERR : bc & 0177;
}
locmode ()
{
    stty (p.fli, savstat);
}
oldmode ()
{
    gtty (p.fli, savstat);
    stty (p.fli, p.olstat);
}
recvc (arg) char    arg;
{
    char    eof;
    eof = '\n';
    if (arg == 2)
	{						/*  set up filename in parent and send it up the filename
							   pipe					 */
	writef1 ("Receive filename?=");
	gather (filename, p.fli);
	writenl ();
	writef (p.filnm[1], filename);
	write (p.filnm[1], &eof, 1);
	kill (prid, SIGQIT);
	return;
	}
    if (arg == 3)
	{
	kill (prid, SIGINT);
	}
}							/*  end of recv		 */
remode ()
{
    stty (p.fri, orstat);
}
send (arg) int  arg;
{							/*  send file function.  this function will fork off a process
							   so that the local keyboard and the sending file can be dealt
							   with asyncronously, this permits the local tty to stop the
							   send process thru the normal escape processing in the
							   parent.			 */
    extern int  sprid;
    if ((arg == 0) && (sprid))
	{
	kill (sprid, SIGHUP);
	return;
	}
    if (arg == 1)
	{
	if (sprid)
	    kill (sprid, SIGHUP);
	loop
	{
	    writef1 ("Transmit filename?=");
	    gather (filename, p.fli);
	    writenl ();
	    if ((p.fls = open (filename, 2)) < 0)
		{
		printf ("Inadequate permissions on %s\n\r", filename);
		return;
		}
	    if ((ask ("Start transmission?")) > 0)
		{
		sflag++;
		stty (p.fli, savstat);
		break;
		}
	    close (p.fls);
	}
/*	a new process is forked here to handle the file transmission
*	to the remote tty.  the sending file is checked for the line control
*	stop character and transmission suspended if line control is
*	in effect.  
*/
	write (p.ctrl[1], &p, PSIZE);
	if ((sprid = fork ()) == 0)
	    {
	    execl ("/usr/dpd/cons", "con-send", 0);
	    }
	if (close (p.fls) < 0)
	    printf ("Unable to close fd, p.fls=%o octal\r\n", p.fls);
	return;
	}
}
unix ()
{
    register    savint,
                pid,
                rpid;
    int     retcode;
    onhup = 1;
    onquit = 1;
    if ((pid = fork ()) == 0)
	{
	signal (SIGHUP, onhup);
	signal (SIGQIT, onquit);
	execl ("/bin/sh", "sh", "-t", 0);
	exit ();
	}
    savint = signal (SIGINT, 1);
    while ((rpid = wait (&retcode)) != pid && rpid != -1);
    signal (SIGINT, savint);
    writef1 ("!");
}
help ()
{							/*  help file		 */
    writef1 ("\nEscape character '?' must proceed ALL functions\n\n");
    writef1 ("Function		Keystroke\n\n");
    writef1 ("Return to shell		Cnt 'd'\n");
    writef1 ("Escape to UNIX		'!'\n");
    writef1 ("Send a break		Del\n");
    writef1 ("Transmit a file		Cnt 't'\n");
    writef1 ("Stop transmitting	Cnt 's'\n");
    writef1 ("Receive a file		Cnt 'r'\n");
    writef1 ("Stop receiving file	Cnt 'q'\n");
    writef1 ("Help file		'h'\n");
    writef1 ("Send escape character	'?'\n");
    writef1 ("\nAll other characters will be ignored.\n");
    return;
}
/*
Name:
	writef and writef1 and writeln
Function:
	Write a null terminated string without the terminator.  (Writef1 is
	a printf substitute which is adequate and faster when only strings are
	printed--as in this program).  (Writeln writes a new line on the
	standard output.)
Algorithm:
	Determine the length of the string.  Write it out. (Writef1 writes to standard output only.)
 CAVEAT	This call is not buffered, so use it carefully or pay the cost
"	of high I/O expense.  It was writted to decrease subroutine linkage
	global variable referencing and module size.  But those gains can
	easily be lost if writef is consistantly called with small strings
	where buffered i/o would be possible.
"Parameters:
	int	file descriptor of output file (not present in writef1 or writeln).
	*char	pointer to null terminated string (not present in writeln).
Returns:
	int	value returned by write.
Globals:
Calls:
	write()		(writef1 calls writef and writeln calls writef1)
Called by:
	lotsa people
History:
	Initially coded by Mark Kampe 11/22/75
	Writef1 and writenl written by Rick Balocca 8/1/76
*/
writef (afd, str) int   afd;
char   *str;
{
    register char  *r;
    register char  *s;
    s = str;
    r = s;
    while (*s++);
    return write (afd, r, --s - r);
}
writef1 (str) char *str;
{
    return writef (1, str);
}
writenl ()
{
    return writef1 ("\n");
}
brkmode ()
{
    gtty (p.fri, orstat);
    stty (p.fri, brkstat);
}
/*
Name:
	slashc
Function:
	Given that the last input character seen was a backslash, this
	routine returns the character that is being escaped.
Algorithm:
	If terminal is half ascii
		If next char is lower case, return its upper case counterpart.
		If it is the preimage of a non-half ascii character, return
			that character.
	Else, return the next character.
Parameters:
Returns:
	A character.
Globals:
	ttys	to check out the console modes.
Calls:
	getchar
Called by:
	input
History:
	Initial coding by someone at berkeley.
*/
slashc (sfd)
int     sfd;
{
    register char   sc;
    sc = getchar (sfd);
    if ((p.olstat[2]) & 04)				/* Half-ASCII */
	{
	if (sc >= 'a' && sc <= 'z')
	    return sc & not 040;			/* ascii dependent */
	else
	    switch (sc)
		{
		case '!': return '|';
		case '\'': return '`';
		case '^': return '~';
		case '(': return '{';
		case ')': return '}';
		default: return sc;
		}
	}
    else
	return sc;
}
