/*
*	tty flags
*/
#define	HUPCL	01
#define	XTABS	02
#define	LCASE	04
#define	ECHO	010
#define	CRMOD	020
#define	RAW	040
#define	ODDP	0100
#define	EVENP	0200
#define	ANYP	0300
/*	
*	delay algorithims
*/
#define	CR1	010000
#define	CR2	020000
#define	CR3	030000
#define	NL1	000400
#define	NL1	001000
#define	NL3	001400
#define	TAB1	002000
#define	TAB2	004000
#define	TAB3	006000
#define	FF1	040000
/*
*	erase and kill characters
*/
#define	ERASE1	010
#define	ERASE2	'#'
#define	ERASE3	01					/* ctrl a */
#define	ERASE4	0100					/*  at sign  */
#define	KILL1	0100					/* at sign */
#define	KILL2	03					/* ctrl c */
#define	KILL3	027					/* ctrl o */
#define	KILL4	030					/*  ctrl x */
/*
*	tty speeds
*/
#define	BOFF	0
#define	B50	1
#define	B75	2
#define	B110	3
#define	B134	4
#define	B150	5
#define	B200	6
#define	B300	7
#define	B600	8
#define	B1200	9
#define	B1800	10
#define	B2400	11
#define	B4800	12
#define	B9600	13
#define	BEXTA	15
#define	BEXTB	15
/*
*	interupt signals
*/
#define	SIGHUP	1
#define	SIGINT	2
#define	SIGQIT	3
#define	SILILL	4
#define	SIGTRP	5
#define	SIGIOT	6
#define	SIGEMT	7
#define	SIGFLT	8
#define	SIGKIL	9
#define	SIGBUS	10
#define	SIGSEG	11
#define	SIGARG	12
#define SIGPIP 	13
/*
*	special characters and functions
*/
#define	not	~					/*  binary not operator  */
#define	DEL	0177
#define	cnt	not 0140 &				/*  generates control characters when combined with a
							   leter			 */
#define	LMODE	0444
#define	FMODE	0644
#define	TRUE	001
#define	FALSE	000
#define	ZERO	000
#define	ONE	001
#define	TWO	002
#define	THREE	003
#define IOERR	000
#define	loop	for (;;)
/*
*	escape processing strings used in parent process
*/
#define	ESC	'?'
#define	KILL	cnt 'd' 
#define	SEND	cnt 't' 
#define	RECV	cnt 'r' 
#define	BRK	0177
#define	QREC	cnt 'q' 
#define QSND 	cnt 's' 
#define	ESP	'!'
#define	HELP	'h' : case 'H'
/*	auto-dialer conventions   */
#define	STX	02					/*  number header  */
#define	SI	017					/*  number buffer limit  */
#define	ETX	03					/*  transfer to dialer  */
#define	SOH	01					/*  abandon call and retry, resets the adapter.  */
							/*  wait 1 second before proceeding	 */
#define	DSS	'A'					/*  data set status, the call has been completed successfully
							   and the port is now connected to the modem for
							   transmission	 */
#define	ACR	'B'					/*  the dialer encountered a busy signal, or abandon call and
							   retry (SOH) was just performed.  */
#define FRAMER	'D'					/*  framing error on the number load of the dialer, probably
							   due to the wrong speed (do stty) or incorrect word length.  
							*/
#define	PTYERR	'E'					/*  parity error on dialer number load, check stty call, and
							   dialer adapter strap options.  */
#define	OVERUN	'F'					/*  dialer buffer over run, were sending too many numbers so
							   lets check our pointers  */
#define	DLO	'G'					/*  data line occupied.  this only applies to multi line
							   dialing situations.  	 */
/*
*	line control
*/
#define	XON	021
#define	CR	015
#define	NL	012
#define	NULL	000
/*
*	string handling
*/
#define	BUFLEN	128
#define STRINGLEN	70
#define	PIPER	05
#define	PIPEW	06
#define	PDIGIT	20				/* max size of phone number  */
struct 	params
{
	int	ctrl[2];
	int	comm[2];
	int	ldcon[2];
	int	filnm[2];
	int	fri;
	int	fro;
	int	fli;
	int	flo;
	int	fls;
	int	flr;
	int	lfds;
	int	olstat[3];
	int	start;
	int	stop;
	int	tty;
	int	tabname;
	char	pnum[PDIGIT];
}	p;
#define	PSIZE	64
#define	DDIGIT	25
