#
/*
 */

/*
 * DR-11B DMA DRIVER
 */

#include "../param.h"
#include "../buf.h"
#include "../conf.h"
#include "../user.h"

struct {
	int	drwc;
	int	drba;
	int	drcs;
	int	drda;
};

struct	devtab	drtab;
struct	buf	rdrbuf;

#define	DRADDR	0172410

#define	GO	01
#define	IENABLE	0100

drstrategy(abp)
struct buf *abp;
{
	register struct buf *bp;

	bp = abp;
	if(bp->b_flags&B_PHYS)
		mapalloc(bp);
	bp->av_forw = 0;
	spl5();
	if (drtab.d_actf==0)
		drtab.d_actf = bp;
	else
		drtab.d_actl->av_forw = bp;
	drtab.d_actl = bp;
	if (drtab.d_active==0)
		drstart();
	spl0();
}

drstart()
{
	register struct buf *bp;

	if ((bp = drtab.d_actf) == 0)
		return;
	drtab.d_active++;
	dmastart(bp,&DRADDR->drwc);
}

drintr()
{
	register struct buf *bp;

	if (drtab.d_active == 0)
		return;
	bp = drtab.d_actf;
	drtab.d_active = 0;
	drtab.d_actf = bp->av_forw;
	iodone(bp);
	drstart();
}

drread(dev)
{

	physio(drstrategy, &rdrbuf, dev, B_READ);
}

dmastart(bp,devloc)
struct buf *bp;
int *devloc;
	{
	register int *dp;
	register struct buf *rbp;

	dp=devloc;
	rbp=bp;
	*dp= rbp->b_wcount;
	*++dp= rbp->b_addr;
	*++dp= IENABLE | GO | ((rbp->b_xmem & 03 ) << 4);
	}
