#include	"pop.h"

/* itts contains the printing characters of class
 * MAP (default) which cannot be displayed on the 3210.
 * maps contains the characters used as the
 * second character in the 2 character
 * sequence used to represent the itts chars
 * on the display.
 *
 * If ITT mode is not set, the mapping is
 * not performed.
 */

char *itts	"{}|~`";
char *maps	"()!^'";

extern char screenmap[NLINES+1][NCHARS+1];

/* Copies the line specified by
 * lineno within popid into buf
 * doing any character conversions
 * as per the POP mode.
 * Trailing spaces at the end
 * of the line are ignored and the
 * copied line is terminated by
 * a null character.
 * The number of characters copied
 * is returned as the value of the function.
 */


pgetl(popid, lineno, buf)
char *buf;
{
register char *s, *smap, c;
char *endline, *lastch;
pop *p;
int n;

	if ((p = do_get(popid)) == -1)
		return(-1);

	if ((lineno < 0) || ((n = p->cv+lineno) > p->vmax))
		return(-1);

	lastch = s = buf;
	lastch--;
	smap = &screenmap[n][p->hmin];
	endline = &screenmap[n][p->hmax];

	while (smap <= endline) {
		c = *smap++;
		if ((p->mode&ITT) && (s!=buf) && (*(s-1) == '\\')
					&& ((n = sis(c,maps)) != -1)) {
			s--;
			c = *(itts+n);
		}
		if (c != SPACE)
			lastch = s;
		*s++ = c;
	}

	*++lastch = '\0';
	return(lastch-buf);
}


/* Checks whether cc is a
 * member of the string ss
 * and returns its position
 * within the string if found.
 */
sis(cc,ss)
char cc, *ss;
{
register char c, *s;

	c = cc;
	s = ss;
	while (c != *s)
		if (*s++ == '\0')
			return(-1);
	return(s-ss);
}
