#
/* the 'setup' command to locate and initialise devices
connected to intelligent controllers, and transmit
the standard input to it.

George Coulouris,  20 May 76 */

# define BUFSIZE	100
# define NETMODE	042 /* raw, no echo, no mappings */

struct spdev {
	/*char sysname[20];*/
	char devname[20];
	char loadname[20];
	char sysrq[10];
	char sysresponse[10];
	char loadrq[10];
	char loadresponse[10];
	char time[5];
	int timeout;
	};

struct iob {
	int fd;
	int nleft;
	char *nextp;
	char buffer[512];
	};

struct iob iobuf;

main( argc, argv)
 char **argv;
{
int devdes, fd, n, initial, savetty, ttymode[3];
char *device, buffer[BUFSIZE];
struct spdev devstruct;
register char *tp, *sp, *bp;

	if ((initial=compare(*argv, "setup")))
		if(--argc == 0)
			{ puts(1, "argcount");
			exit();
		}
	device = *(argv + initial);
	if((devdes = spopen(device, 2, &devstruct)) < 0) {
		putb(1,devstruct.devname); puts(1, " not available");
		exit();
	}
					 /*open the appropriate controller
				and leave the characteristics in devstruct */
	if( gtty(devdes, ttymode) >= 0) {
		savetty = ttymode[2];
		ttymode[2] = NETMODE;
		if(stty(devdes, ttymode)<0)
			 puts(1,"cannot set tty mode on device");
	}
	else puts(1,"not a tty");
tryagain:
	gett(devdes, buffer, BUFSIZE, 1); /*to clear any waiting chars */
	if(!initial) {
		putb(devdes, devstruct.sysrq); /* "who are you?" */
		gett(devdes, buffer, BUFSIZE, devstruct.timeout);
	}
	if(initial || !compare(buffer, devstruct.sysresponse)) {
		putb(devdes, devstruct.loadrq);
		gett(devdes, buffer, BUFSIZE, devstruct.timeout);
		tp = sp = devstruct.loadresponse;
		while(*sp++);
		bp = buffer; while(*bp++);
		while(*(--bp) == *(--sp))
			if (sp == tp) {sp = 0; break; }
		if (sp != 0) {
			putb(1, devstruct.devname);
			puts(1, " not responding as expected");
			putb(1, "Type 'y' when ready to try again,");
			putb(1, " 'n' to give up:");
			sp = buffer;
			while((*sp++ = getchar()) != '\n');
			if (buffer[0] == 'y') goto tryagain;
			exit();
		}
		if((fd = open(devstruct.loadname,0))<0) {
			putb(1,devstruct.loadname);
			puts(1, " monitor not found");
			exit();
		}
		putb(1, "loading "); putb(1, device); puts(1, " monitor -");
		while (n = read( fd, iobuf.buffer, 512)) {
			write(devdes, iobuf.buffer, n);
			putch(1,'-');
		}
		puts(1, " done");
		close( fd);
	}
	buffer[0] = 0; gett(devdes, buffer, BUFSIZE, 1); puts(1, buffer);
	if(initial) {
		putb(1, device); putb(1, " ready to receive on ");
		puts(1, devstruct.devname);
	}
	else while(n = read(0, iobuf.buffer,512)) {
			write(devdes,iobuf.buffer,n);
		}

}

spopen( device, mode, devstruct)	struct spdev *devstruct; char *device;

/* opens a special device listed in /etc/spdev, for i/o according to "mode",
	leaving the entry from /etc/spdev in devstruct */

{
	register char ch, *sp;

	if( (fopen( "/etc/spdevices", &iobuf)) < 0) {
		puts(1, "/etc/spdevices not found");
		return -1;
	}

	for(;;) {
		sp = device;
		while ((ch = getc(&iobuf)) == *sp++);
		if( ch == ':' && ! *(--sp) ) break;
		while( (ch = getc(&iobuf)) != '\n') 
			if(ch<0) {
				putb(1, device); puts(1,  " not known");
				return -1;
			};
	}

	unpack(&iobuf, devstruct);
	return(open(devstruct->devname, mode));
}


unpack( buf, dstruct)	struct spdev *dstruct; struct iob *buf;
/* reads the variable length record and unpacks the fields delimited by ':'
into the structure */
{
	register char *sp; int t;
	field(buf, dstruct -> devname );
	field(buf, dstruct -> loadname );
	field(buf, dstruct -> sysrq );
	field(buf, dstruct -> sysresponse );
	field(buf, dstruct -> loadrq );
	field(buf, dstruct -> loadresponse );
	field(buf, dstruct -> time );

	sp = dstruct -> time;
	t = 0;
	while(*sp) t = 10*t + ( *sp++ - '0');
	dstruct -> timeout = t;

	while(getc(buf) != '\n');
}

field( buf, ptr)	struct iob *buf; char *ptr;
{
register char ch, *sp;

	sp = ptr;
	while((ch = getc(buf)) != ':') *sp++ = ch;
	*sp = '\0';

}
/* George's patent i/o package */

# define QUIT	3
# define KILL	9
int pipedes[2], pid;
int onquit();
char *bp, *tp;

concat(head,tail,dest)
	char *head, *tail;
{register char *s1, *s2, *s3;

	s1 = head; s2 = tail; s3 = dest;

	while(*s3++ = *s1++);
	s1--;
	while(*s3++ = *s2++);
}

compare(s1, s2)		char *s1, *s2;
{ register char *sp, *lp;

	sp = s1; lp = s2;
	while( *sp == *lp ) { sp++; if( !(*lp++) ) return 1; }
	return 0;
}

puts(filedes, as)	char *as;
{	putb( filedes, as); putch( filedes, '\n'); }

putch(filedes, ch) char ch;
{ write(filedes, &ch, 1); }

putb(filedes, ptr)	char *ptr;
{	register char *p;

	p = ptr;
	if(*p == '\0') return;
	while(*(++p));
	write( filedes,ptr,p-ptr);
}

/* a procedure to read an unknown number of characters recieved in a
time interval t */

gett(filedes, buf, n, t)
char *buf;
{
	int status[1];

	bp = buf; tp = buf;
	pipe(pipedes);
	if (pid = fork()) {
		close(pipedes[1]); /*since parent only reads */
		sleep(t+1);
		kill(pid, QUIT);
		wait(status);
		while (tp - bp <n)
			if(read(pipedes[0],tp,1) == 1) tp++;
			else { *tp = 0;
			close(pipedes[0]);
			return;
			}
		puts(1, "buffer overflow");
	}

	else {
		close(pipedes[0]); /* since child only writes to pipe */
		signal( QUIT, onquit);
		while (tp - bp <n) if(read(filedes,tp,1) == 1) tp++;
		puts(1, "buffer overflow");
	} /* end of child process */
}

onquit()
{
	*tp = '\0'; tp = bp;
	putb( pipedes[1], tp);
	exit();
}

