/*	Improved c-version of tp?.s
 *	Implements update and replace for Magtape.
 *
 *	M. Ferentz
 *	Brooklyn College of CUNY
 *
 *	September 1976
 */

#define MDIRENT	2000	/* Sized to maximum core available (was 2776) */
			/* Max number depends on efficiency of your C compiler;
			   2776 may be too high.  Also depends on max core/process */
#define DIRSIZE	16
#define tapsiz	32767

#define	tapeblk	&tpentry[0]
#define tapeb	&tpentry[0]

struct 	tent	{	/* Structure of a tape directory block */
	char	pathnam[32];
	int	mode;
	char	uid;
	char	gid;
	char	spare;
	char	size0;
	int	size1;
	int	time[2];	 /* timen == time[n] */
	int	tapea;		/* tape address */
	int	unused[8];
	int	cksum;
}	tpentry[8];

struct	dent {	/* in core version of tent with "unused" removed
		 * and pathname replaced by pointer to same in a
		 * packed area (nameblock).
		 */
	char	*d_namep;
	int	d_mode;
	char	d_uid;
	char	d_gid;
	char	d_spare;
	char	d_size0;
	int	d_size1;
	int	d_time[2];
	int	d_tapea;
};

/*  The structure below uses all available core.  Names are stored
 *  backwards starting from the end.  Directory entries are stored
 *  starting at dir[0].  Blocks for directory entries are allocated
 *  eight at a time, corresponding to one block on the tape.  Checks
 *  for overlapping give "Out of core" fatal error message.
 */

struct	dent	dir[MDIRENT];

struct {
	int	s_skip[2];
	int	s_flags;
	char	s_nlinks;
	char	s_uid;
	char	s_gid;
	char	s_size0;
	int	s_size1;
	int	s_addr[8];
	int	s_active[2];
	int	s_modtime[2];
	} statb;

/**/

char	map[4096];
int	catlb[10];
char	name[32];
char	name1[32];
char	mt[]	;
char	nrw_mt[] ;
char	backup[] ;

int	narg, rnarg;
char	**parg;
int	wseeka,rseeka;
int	fio;
int	backio;
int	ndirent, ndentd8;
char	*edir;
struct dent *lastd;
int	endtape;	/* number of blocks before file mark */
			/* Used with improved driver for speed */
int	(*command)();

char	*nptr;

int	   flags	;	/* default is flu */
#define	flc	0001
#define	flf	0002
#define	fli	0004
#define	flu	0020
#define	flv	0040
#define	flw	0100

struct { int integer; };
