The "talk" command allows users to communicate with other users
currently logged onto the system.

Syntax:

	& talk logname [tty]

.in 16
.ti 0
	where	"logname" is the logname of the person you wish to reach
.ti 0
		"[tty]" (optional) is the terminal she/he is on.

.in 0
Note: The tty option is only needed when the user is logged
on more than one terminal, i.e. if jones3 was logged onto
terminals j and l, you might wish to speak to him at l and
not at j (having noticed that he's at the shell level on
l and in the middle of something on j).  So you would type:
	& talk jones3 ttyl

\?..

If, on initiating a talk, you receive a "Permission denied." message,
then the other person has set messages to "no" (see help messages)
in order to avoid being disturbed.  If, on the other hand, you are told
"Communications established..." then you should wait until the other
person "talk"s back and you get something like:
	message from fubar (ttyz)...
	-ga
.br
before typing your message.  Some users will refuse to talk to anyone
who doesn't wait for a reply.

"ga" means "go ahead" and is commonly used to indicate whose turn it
is to talk.  Because messages may take many seconds to be delivered and
some people type slower than others interruptions can be very confusing.

To end a talk type "ga/bye" (a formality to warn your co-talker in case
of last-minute ideas) and then "^D" (ctrl d) as the first char on a line.

\?..
If someone is talking to you and won't stop typing, you can
"turn him off" by executing a "messages n" command, even
while he is in the middle of a talk! (See "help messages".)

Talk can also allow you to temporarily exit to shell.
Imagine, for example, that you are talking to fubar and you forget the
name of a file that you wished to communicate to her...
Simply type (on a new line):
	!<NL>       "new line" or "carriage return".
	>&
.br
You can now ask the shell to list your files, run a program, etc.
When you are finished, type:
	>& bye<NL>
.br
Now you are back to your talk but the other person has not received
anything since the "!".

Post comments to sys.
.pl 2
