#

/*
 * Editor
 * Copyright 1974, Bell Telephone Laboratories, Incorporated
 * Modifications by UCB (the o command)
 * Modifications by UCLA (the b,j, & z commands; miscellaneous improvements)
 */

#define	SIGHUP	1
#define	SIGINTR	2
#define	SIGQUIT	3
#define	FNSIZE	64
#define	LBSIZE	512
#define	mainsize	520
#define	ESIZE	128
#define	GBSIZE	256
#define	NBRA	5
#define	EOF	-1
#define CTLA	001
#define CTLC	003
#define CTLH	010
#define CTLX	030
#define NP	014
#define LTAB	21					/* long tab character */
#define FLUSHLIM 20					/* number of changed lines before temp updated */

#define	CBRA	1
#define	CCHR	2
#define	CDOT	4
#define	CCL	6
#define	NCCL	8
#define	CDOL	10
#define	CEOF	11
#define	CKET	12

#define	STAR	01

#define	error	errfunc("?")
#define	READ	0
#define	WRITE	1

int     peekc;
char    savedfile[FNSIZE];
char    file[FNSIZE];
char    docu[FNSIZE];					/* user defined documentation file (x command) */
char    cmdsour[FNSIZE];				/* file of editor commands */
char    linebuf[LBSIZE];
char    mainstore[mainsize];
char   *textpoint[26];
char    rhsbuf[LBSIZE / 2];
char    expbuf[ESIZE + 4];
char    globuf[GBSIZE];
char    genbuf[LBSIZE];
int     circfl;
int    *zero;
int    *dot;
int    *dol;
int    *endcore;
int    *fendcore;
int    *addr1;
int    *addr2;
int	olddot;
int     count[2];
char   *nextip;
char   *linebp;
int     ninbuf;
int     io;
int     pflag;
int     vflag 1;
int     zcount;
int     zflag 0;
int     onhup ();
int     onquit;
int     listz;
int     listf;
int     col;
int	inz;
int	intrapt;
char   *globp;
int     tfile - 1;
int     tline;
char   *tfname;
							/* tfname = "etmp.Exxxxx" where xxxxx is process id in decimal,
							   and E is either 'e' for text temporary (maintained by append
							   and delete routines) or 'E' for line index temporary
							   (maintained by flushio routine) if for some reason
							   etmp.Exxxxx can't be created on entry, /tmp/Exxxxx is tried. 
							*/
int     tlpfile;
char   *loc1;
char   *loc2;
char   *locs;
char    ibuff[512];
int     iblock - 1;
char    obuff[512];
int     oblock - 1;
int     ichanged;
int     fchanged;
							/* fchanged=0 means internal file = external file */
							/* fchanged=1 means internal file = temp files */
							/* fchanged>1 means internal file differs from temp files by
							   less than fchanged lines */
int     action[30] {
    13, 2, -1, 1, 11, 4, 15, -1,			/* A,B,c,D,E,F,G,h */
    -1, -1, 5, 14, -1, 12, 16,				/* i,j,K,L,m,N,O  */
    10, -1, 6, 7, 8, 0, -1, 9, 3, -1, -1		/* P,q,R,S,T,U,v,W,X,y,z,-,-,-,- */
    - 1, -1, -1, -1
};
int     nest;
int     newnest;
char   *tx0[1] "continue;";
char   *tx1[1] "#define		";
char   *tx2[1] "break;";
char   *tx3[1] "extern  ";
char   *tx4[4] {
    "for (", "; ", "; ", ") {"
};
char   *tx5[2] {
    "		/* ", " */"
};
char   *tx6[2] {
    "return( ", " );"
};
char   *tx7[1] "struct ";
char   *tx8[2] {
    "switch ( ", " ) {"
};
char   *tx9[2] {
    "while ( ", " ) {"
};
char   *tx10[2] {
    "printf (", " );"
};
char   *tx11[2] {
    "case ", " :"
};
char   *tx12[1] "int     ";
char   *tx13[1] "char    ";
char   *tx14[2] {
    "#include		\"", "\""
};
char   *tx15[1] "register  ";
char   *tx16[1] "main(argc,argv)  char **argv;";

char  **strg[17] {
    tx0, tx1, tx2, tx3, tx4, tx5, tx6, tx7, tx8, tx9,
    tx10, tx11, tx12, tx13, tx14, tx15, tx16
};
int     nstrg[10] {
    1, 1, 1, 1, 4, 2, 2, 1, 2, 2, 2, 2, 1, 1, 2, 1, 1
};
int     nleft;


int     errfunc ();
int     cmdid;						/* i/o id for alternate command stream */
int     cmdsw;						/* command switch for     "       "    */
int     docsw;
int     tab1 40;
int     tab2 78;
int     docmode;
int     did;
char    DOCFILE[] "/etc/eddoc";
char    TMPERR[] "Temp file error";
char    IOERR[] "Write error";
char    BUFERR[] "Buffer overflow";
int     names[26];
char   *braslist[NBRA];
char   *braelist[NBRA];

#define RIGHT 1
#define LEFT 0
#define COPY 1
#define NOCOPY 0
#define EOT 004

int     hiding 0;
char   *to,
       *fr;
int     istty 0;
int     ttmode[3];
int     ttnorm;						/* saves ttmode[2] during 'o' commands */
int     zlength 23;

main (argc, argv)
char  **argv;
{
    register char  *p1,
                   *p2;
    register    pid;
    extern int  onintr ();

    onquit = signal (SIGQUIT, 1);
    signal (SIGHUP, onhup);
    if (gtty (0, ttmode) != -1) {
	istty++;
	ttnorm = ttmode[2];
    }
    argv++;
    if (argc > 1 && **argv == '-') {
							/* allow debugging quits? */
	switch ((*argv)[1]) {
	    case 'q': 
		signal (SIGQUIT, 0);
		break;
	    case 0: 
		vflag = 0;
		break;
	}
	argv++;
	argc--;
    }
    tfname = "etmp.exxxxx";
    pid = getpid ();
    for (p1 = &tfname[11]; p1 > &tfname[6];) {
	*--p1 = (pid % 10) + '0';
	pid =/ 10;
    }
    if ((signal (SIGINTR, 1) & 01) == 0)
	signal (SIGINTR, onintr);
    init ();
    setexit ();
							/* All Errors return to this point via reset() */
    if (argc > 1) {
							/* read in input; has to be after setexit() */
	argc = 0;
	p1 = *argv;
	p2 = savedfile;
	while (*p2++ = *p1++);
	p1 = *argv;
	p2 = file;
	while (*p2++ = *p1++);
	readfile (zero);
	fchanged = 0;
    }
    commands ();
    if (fchanged)
	dontgo ();
    rmfiles ();
}

commands () {
    int     cprogtty ();
    int     getfile (), gettty ();
    register   *a1,
                c;
    register char  *p;
    int     id,
            wc;
    char   *endmain;
    int     r;

    for (;;) {
	if (pflag) {
	    pflag = 0;
	    addr1 = addr2 = dot;
	    printlines ();
	}
	if (vflag && !globp && !cmdsw)
	    write (1, "* ", 2);

	if(intrapt && inz){intrapt=0;
		addr1 = addr2 = olddot;
		 goto zprint;}
	addr1 = addr2 = address ();
	c = getchar ();
	if (addr1) {
	    if (c == ';') {
		dot = addr1;
		addr2 = address ();
		c = getchar ();
	    }
	    else
		if (c == ',') {
		    addr2 = address ();
		    c = getchar ();
		}
	}

	inz = c == 'z';
	switch (c) {

	    case 'a': 
		setdot ();
		if ((c = getchar ()) == '\n') {
		    append (gettty, addr2);
		}
		else {
		    if (c != 'c')
			error;
		    if ((c = getchar ()) != '\n')
			nest = c - '0';
		    else
			peekc = c;
		    newline ();
		    write (1, "\7", 1);
		    ttmode[2] =| 040;
		    ttmode[2] =& ~010;
		    stty (0, ttmode);
		    append (cprogtty, addr2);
		    ttmode[2] = ttnorm;
		    stty (0, ttmode);
		}
		continue;

	    case 'b': 
							/* read in library file */
		while ((c = getchar ()) == ' ');
		p = linebuf;
		if ((*p++ = c) == '\n') {
		    for (wc = 0; wc < 26; wc++) {
			if (p = textpoint[wc]) {
			    id = wc + 'a' | ('\t' << 8);
			    write (1, &id, 2);
			    id = 0;
			    while (*p++)
				id++;
			    write (1, textpoint[wc], id);
			    write (1, "\n", 1);
			}
		    }
		    continue;
		}
		for (wc = 0; wc < 26; wc++)
		    textpoint[wc] = 0;
		while ((*p++ = getchar ()) != '\n');
		*--p = 0;				/* file name */
		if ((id = open (linebuf, 0)) < 0)
		    error;
		wc = read (id, mainstore, mainsize);
		close (id);
		p = mainstore;
		endmain = p + wc;
		while (p < endmain) {
		    if (*p < 'a' || *p > 'z')
			error;
		    textpoint[*p - 'a'] = p + 1;
		    while (*p++ != '\n')
			if (p > endmain)
			    error;
		    *(p - 1) = 0;
		}
		continue;

	    case 'c': 
		setdot ();
		newline ();
		nonzero ();
		delete ();
		append (gettty, addr1 - 1);
		continue;

	    case 'd': 
		setdot ();
		newline ();
		nonzero ();
		delete ();
		continue;

	    case 'E': 
		fchanged = 0;				/* ignore message */
	    case 'e': 
		setnoaddr ();
		if (fchanged)
		    dontgo ();
		if ((peekc = getchar ()) != ' ')
		    error;
		savedfile[0] = 0;
		filename ();
		init ();
		readfile (zero);
		fchanged = 0;
		continue;

	    case 'f': 
		setnoaddr ();
		if ((c = getchar ()) != '\n') {
		    peekc = c;
		    savedfile[0] = 0;
		    filename ();
		}
		puts (savedfile);
		if (cmdsour[0]) {
		    puts (" command file: ");
		    puts (cmdsour);
		}
		continue;

	    case 'g': 
		global  (1);
		continue;

	    case 'x': 
		if (acceptfile (docu))
		    did = open (DOCFILE, 0);
		else
		    did = open (docu, 0);
		if (did == -1)
		    error;
		docsw++;
		docmode = 1;
		setdot ();
		append (gettty, addr2);
		continue;

	    case '\t': 
		setdot ();
		nonzero ();
		peekc = '\t';
		append (gettty, addr2 - 1);
		continue;

	    case 'i': 
		setdot ();
		nonzero ();
		if ((c = getchar ()) == '\n') {
		    append (gettty, addr2 - 1);
		}
		else {
		    if (c != 'c')
			error;
		    if ((c = getchar ()) != '\n')
			nest = c - '0';
		    else
			peekc = c;
		    newline ();
		    write (1, "\7", 1);
		    ttmode[2] =| 040;
		    ttmode[2] =& ~010;
		    stty (0, ttmode);
		    append (cprogtty, addr2 - 1);
		    ttmode[2] = ttnorm;
		    stty (0, ttmode);
		}
		continue;

	    case 'j': 
		setdot ();
		nonzero ();
		newline ();
		join ();
		continue;

	    case 'k': 
		if ((c = getchar ()) < 'a' || c > 'z')
		    error;
		setdot ();
		nonzero ();
		newline ();
		names[c - 'a'] = *addr2 | 01;
		continue;

	    case 'm': 
		move (0);
		continue;

	    case 'n': 
		listf = 2;
		goto print;

	    case '\n': 
		if (addr2 == 0)
		    addr2 = dot + 1;
		addr1 = addr2;
		printlines ();
		continue;

	    case 'l': 
		listf = 1;
	print: 
	    case 'p': 
		newline ();
		setdot ();
		printlines ();
		continue;

	    case 'o': 
		setdot ();
		nonzero ();
		newline ();
		write (1, "\7", 1);
		ttmode[2] =| 040;
		ttmode[2] =& ~010;
		stty (0, ttmode);
		ilsubst ();
		ttmode[2] = ttnorm;
		stty (0, ttmode);
		continue;

	    case 'Q': 
		fchanged = 0;
	    case 'q': 
		setnoaddr ();
		if (fchanged)
		    dontgo ();
		newline ();
		rmfiles ();
		exit ();

	    case 'r': 
	caseread: 
		filename ();
		setall ();
		readfile (addr2);
		continue;

	    case 's': 
		setdot ();
		nonzero ();
		substitute (globp);
		continue;

	    case 't': 
		move (1);
		continue;

	    case 'v': 
		global  (0);
		continue;

	    case 'w': 
		setall ();
		nonzero ();
		peekc = getchar ();
		if (peekc == '-') {
		    peekc = 0;
		    c = 1;
		}
		else
		    c = 0;
		filename ();
		if (c)
		    io = open (file, 1);
		else
		    io = creat (file, 0666);
		if (io < 0)
		    errfunc ("Can't create");
		seek (io, 0, 2);			/* go to end of file */
		putfile ();
		exfile ();
		fchanged = 0;
		continue;

	    case 'y': 					/* get commands from file */
		setnoadr ();
		if (acceptfile (cmdsour) && !cmdsour[0])
		    error;				/* did not type file name */
		if (cmdid)
		    error;				/* file already open */
		if ((cmdid = open (cmdsour)) == -1)
		    error;
		cmdsw++;
		continue;
		zprint:
	    case 'z': 
		getzlen ();
		olddot = addr2;		/* save old end address */
		zflag++;

		write(1,"\t       \176\035",10);
		printlines ();
		zflag = pflag = 0;
		continue;

	    case '=': 
		setall ();
		newline ();
		count[1] = (addr2 - zero) & 077777;
		putd ();
		putchar ('\n');
		continue;

	    case '!': 
		unix ();
		continue;

	    case EOF: 
		return;

	}
	error;
    }
}

address () {
    register   *a1,
                minus,
                c;
    int     n,
            relerr;

    minus = 0;
    a1 = 0;
    for (;;) {
	c = getchar ();
	if ('0' <= c && c <= '9') {
	    n = 0;
	    do {
		n =* 10;
		n =+ c - '0';
	    } while ((c = getchar ()) >= '0' && c <= '9');
	    peekc = c;
	    if (a1 == 0)
		a1 = zero;
	    if (minus < 0)
		n = -n;
	    a1 =+ n;
	    minus = 0;
	    continue;
	}
	relerr = 0;
	if (a1 || minus)
	    relerr++;
	switch (c) {
	    case ' ': 
		continue;

	    case '+': 
		minus++;
		if (a1 == 0)
		    a1 = dot;
		continue;

	    case '-': 
	    case '^': 
		minus--;
		if (a1 == 0)
		    a1 = dot;
		continue;

	    case '?': 
	    case '/': 
		compile (c);
		a1 = dot;
		for (;;) {
		    if (c == '/') {
			a1++;
			if (a1 > dol)
			    a1 = zero;
		    }
		    else {
			a1--;
			if (a1 < zero)
			    a1 = dol;
		    }
		    if (execute (0, a1))
			break;
		    if (a1 == dot)
			error;
		}
		break;

	    case '$': 
		a1 = dol;
		break;

	    case '.': 
		a1 = dot;
		break;

	    case '\'': 
		if ((c = getchar ()) < 'a' || c > 'z')
		    error;
		for (a1 = zero; a1 <= dol; a1++)
		    if (names[c - 'a'] == (*a1 | 01))
			break;
		break;

	    default: 
		peekc = c;
		if (a1 == 0)
		    return (0);
		a1 =+ minus;
		if (a1 < zero)
		    a1 = zero;
		if (a1 > dol)
		    a1 = dol;
		return (a1);
	}
	if (relerr)
	    error;
    }
}

setdot () {
    if (addr2 == 0) {
	if (dot > dol)
	    dot = dol;
	addr1 = addr2 = dot;
    }
    if (addr1 > addr2)
	error;
}

setall () {
    if (addr2 == 0) {
	addr1 = zero + 1;
	addr2 = dol;
	if (dol == zero)
	    addr1 = zero;
    }
    setdot ();
}

setnoaddr () {
    if (addr2)
	error;
}

nonzero () {
    if (addr1 > dol)
	error;
    if (addr1 <= zero)
	addr1 = zero + 1;
    if (addr2 > dol)
	addr2 = dol;
    if (addr1 > addr2)
	error;
}

newline () {
    register    c;

    if ((c = getchar ()) == '\n')
	return;
    pflag++;
    if (c == 'l')
	listf = 1;
    else
	if (c == 'p');
	else
	    if (c == 'n')
		listf = 2;
	    else
		error;
    if (getchar () != '\n')
	error;
    return;
}

filename () {
    register char  *p1,
                   *p2;
    register    c;

    count[1] = 0;
    c = getchar ();
    if (c == '\n' || c == EOF) {
	p1 = savedfile;
	if (*p1 == 0)
	    error;
	p2 = file;
	while (*p2++ = *p1++);
	return;
    }
    if (c != ' ')
	error;
    while ((c = getchar ()) == ' ');
    if (c == '\n')
	error;
    p1 = file;
    do {
	*p1++ = c;
    } while ((c = getchar ()) != '\n');
    *p1++ = 0;
    if (savedfile[0] == 0) {
	p1 = savedfile;
	p2 = file;
	while (*p1++ = *p2++);
    }
}

exfile () {
    close (io);
    io = -1;
    if (vflag) {
	putd ();
	putchar ('\n');
    }
}

getzlen () {
    register char   c,
                    zmode;
    register int    i;
    while ((c = getchar ()) == ' ');
    if (c == ':') {
	listz = (listz + 2) % 4;
	c = getchar ();
    }
    listf = listz;
    if (c == '.' || c == '-' || c == '+' || c == '/') {
	zmode = c;
	c = getchar ();
    }
    else
	zmode = '+';
    if (c >= '0' && c <= '9') {
	i = c - '0';
	while ((c = getchar ()) >= '0' && c <= '9')
	    i = i * 10 + (c - '0');
    }
    else
	i = zlength;
    peekc = c;
    newline ();
    zlength = i;
    if (addr2 == 0)
	addr1 = dot;
    switch (zmode) {
	case '.': 
	    addr1 =- zlength / 2;
	    break;
	case '/': 
	    addr1 =- zlength + zlength - 2;
	    break;
	case '-': 
	    addr1 =- zlength - 1;
	    break;
    }
    addr2 = addr1 + zlength - 1;
}

onintr () {
    signal (SIGINTR, onintr);
    putchar ('\n');
	if(inz){intrapt=1; peekc = '\n'; reset();}  /* next z page */
    error;
}

onhup () {
    globp = "w ed-hup\n";
    commands ();
    rmfiles ();
    exit (-1);
}

dontgo () {
    register char   c;
    fchanged = 0;
    errfunc ("Modified file not written out");
}

errfunc (s)
char   *s;
{

    listf = 0;
    puts (s);
    count[0] = 0;
    seek (0, 0, 2);
    docmode = 0;
    docsw = 0;
    if (cmdid)
	close (cmdid);
    if (did)
	close (did);
    did = 0;
    cmdid = 0;
    cmdsw = 0;
    pflag = 0;
    globp = 0;
    if (io > 0) {
	close (io);
	io = -1;
    }
    peekc = 0;
    ttmode[2] = ttnorm;
    stty (0, ttmode);					/* reset tty if necessary */
							/* and flush all pending input */
    reset ();
							/* returns to top command level */
}

getchar () {
    char    c;
    if (c = peekc) {
	peekc = 0;
	return (c);
    }
    if (globp) {
	if ((c = *globp++) != 0)
	    return (c);
	globp = 0;
	return (EOF);
    }
    if (cmdsw) {
	if (read (cmdid, &c, 1) <= 0) {
	    close (cmdid);
	    cmdid = 0;
	    cmdsw = 0;
	    return (getchar ());
	}
    }
    else
	if (read (0, &c, 1) <= 0)
	    return (c = EOF);
    c =& 0177;
    if (c == CTLC) {
							/* happened in a 'o' command */
	putchar ('\n');
	c = '\n';
	hiding = 0;
	error;
    }
    return (c);
}

gettty () {
    register    c,
                gf;
    register char  *p;
    char    (*iofcn[2]) ();
    extern  getchar (), getdoc ();

    iofcn[0] = getchar;
    iofcn[1] = getdoc;
    p = linebuf;
    gf = globp;

    c = 0;
    while (c != '\n') {
	
	    if ((0177 & (c = (*iofcn[docmode]) ())) == 033 && docsw) {
	    docmode++;
	    docmode =% 2;
	    if (docmode && getchar () != '\n')
		error;
	    
		continue;
	}
	if (c == EOF) {
	    if (gf)
		peekc = c;
	    docmode = 0;
	    docsw = 0;
	    if (did)
		close (did);
	    return (c);
	}
	if ((c =& 0177) == 0)
	    continue;

	*p++ = c;
	if (p >= &linebuf[LBSIZE - 2])
	    error;
    }
    *(--p) = 0;
    if (linebuf[0] == '.' && linebuf[1] == 0) {
	docmode = 0;
	docsw = 0;
	if (did)
	    close (did);
	return (EOF);
    }
    return (0);
}
cprogtty () {
    char   *backpos ();
    register    gf;
    char    c;
    int     i;
    int     id;
    char   *s;
    char  **sptr;
    int     nstr;
    int     eofsw;
    register char  *p;

    gf = globp;

freshline: 
    newnest = nest;
    p = linebuf;
    for (i = 0; i < nest; i++) {
	*p++ = ' ';
	*p++ = ' ';
	write (1, "    ", 4);
	*p++ = ' ';
	*p++ = ' ';
    }

    c = 0;
    while (c != '\n') {
	
	    if ((0177 & (c = getchar ())) == EOF) {
	    if (gf)
		peekc = c;
	    return (c);
	}


	switch (c =& 0177) {
	    case 0: 
		continue;

	    case 032: 					/* ^z  */
		nest = getchar () - '0';
		write (1, "\n", 1);
		goto freshline;
	    case '\n': 
		continue;
	    case 031: 					/* ^y */
		if ((c = getchar ()) < 'a' || c > 'z')
		    continue;
		if (s = textpoint[c - 'a']) {
		    while (*s) {
			p = backpos (p, *s++);
		    }
		}
		continue;
	}

	if (c == '\t' || c == 010 || c >= ' ') {
	    p = backpos (p, c);
	}
	else {						/* process table insert */
	    id = action[c - 1];
	    if (id < 0)
		continue;				/* undefined */
	    sptr = strg[id];
	    nstr = nstrg[id];
	    eofsw = 0;

	    while (nstr--) {
		s = *sptr++;
		while (*s) {
		    p = backpos (p, *s++);
		}
		if (eofsw)
		    continue;
		if (nstr) {
		    while ((c = getchar ()) != '\n' && c != 033) {
			if (c == 031) {
			    if ((c = getchar ()) < 'a' || c > 'z')
				continue;
			    if (s = textpoint[c - 'a']) {
				while (*s) {
				    p = backpos (p, *s++);
				}
			    }
			    continue;
			}
			p = backpos (p, c);
		    }
		    if (c == '\n')
			eofsw = 1;
		}
	    }
	}
	if (p >= &linebuf[LBSIZE - 2])
	    error;
    }
    *p = 0;
    write (1, "\n", 1);
    if (linebuf[4 * nest] == '.' && linebuf[4 * nest + 1] == 0) {
	return (EOF);
    }
    if (linebuf[4 * nest] == 0)
	linebuf[0] = 0;
    nest = newnest;
    return (0);
}

char   *backpos (p, c)
char   *p,
        c;
{							/* insert with backspace handling */
    switch (c) {

	case '{': 
	case '(': 
	    newnest++;
	    break;
	case '}': 
	case ')': 
	    if (p == linebuf + 4 * nest && nest > 0) {
		p =- 4;
		write (1, "\010\010\010\010", 4);
	    }
	    newnest--;
	    break;
	case 010: 					/* ^H */
	    if (p <= linebuf)
		return (p);				/* at beginning */
	    write (1, "\010 \010", 3);
	    switch (*(p - 1)) {
		case '(': 
		case '{': 
		    newnest--;
		    break;
		case ')': 
		case '}': 
		    newnest++;
	    }
	    return (p - 1);
    }
    *p = c;
    write (1, &c, 1);
    return (p + 1);
}

getfile () {
    register    c;
    register char  *lp,
                   *fp;

    lp = linebuf;
    fp = nextip;
    do {
	if (--ninbuf < 0) {
	    if ((ninbuf = read (io, genbuf, LBSIZE) - 1) < 0)
		return (EOF);
	    fp = genbuf;
	}
	if (lp >= &linebuf[LBSIZE])
	    errfunc (BUFERR);
	if ((*lp++ = c = *fp++ & 0177) == 0) {
	    lp--;
	    continue;
	}
	if (++count[1] == 0)
	    ++count[0];
    } while (c != '\n');
    *--lp = 0;
    nextip = fp;
    return (0);
}

putfile () {
    int    *a1;
    register char  *fp,
                   *lp;
    register int    i;

    i = 0;
    fp = genbuf;
    a1 = addr1;
    lp = getline (*a1);
    for (;;) {
							/* i = fp-genbuf; fp points to next place to put char to output
							   genbuf[0..i-1] contains chars created to output a1 = line
							   number of current line being moved lp points to next
							   character to move count[0,1] contains total # of bytes moved 
							*/
	if (++count[1] == 0)
	    ++count[0];
	i++;
	if ((*fp++ = *lp++) == 0) {
	    fp[-1] = '\n';
	    if (a1++ >= addr2)
		break;
	    lp = getline (*a1);
	}
	if (i == 512) {
	    if (write (io, genbuf, i) != i)
		errfunc (IOERR);
	    fp = genbuf;
	    i = 0;
	}
    }
    if (write (io, genbuf, i) != i)
	errfunc (IOERR);
}

append (f, a)
int     (*f) ();
{
    register   *a1,
               *a2,
               *rdot;
    int     nline,
            tl;
    struct {
	int     integer;
    };

    nline = 0;
    dot = a;
    while ((*f) () == 0) {
	if (dol >= endcore) {
	    if (sbrk (1024) == -1)
		errfunc ("No more core");
	    endcore.integer =+ 1024;
	}
	tl = putline ();
	nline++;
	a1 = ++dol;
	a2 = a1 + 1;
	rdot = ++dot;
	while (a1 > rdot)
	    *--a2 = *--a1;
	*rdot = tl;
    }
    return (nline);
}

unix () {
    register    savint,
                pid,
                rpid;
    char   *p;
    int     retcode;

    setnoaddr ();
    p = linebuf;
    while ((*p = getchar ()) != '\n' && *p != EOF)
	if (p++ >= linebuf + LBSIZE)
	    errfunc (BUFERR);
    *p = 0;
    if ((pid = fork ()) == 0) {
	signal (SIGHUP, onhup);
	signal (SIGQUIT, onquit);
	if (*linebuf)
	    execl ("/bin/sh", "sh", "-c", linebuf);
	else
	    execl ("/bin/sh", "sh");
	error;
    }
    savint = signal (SIGINTR, 1);
    while ((rpid = wait (&retcode)) != pid && rpid != -1);
    signal (SIGINTR, savint);
    puts ("!");
}

delete () {
    register   *a1,
               *a2,
               *a3;

    a1 = addr1;
    a2 = addr2 + 1;
    a3 = dol;
    dol =- a2 - a1;
    do
	*a1++ = *a2++;
    while (a2 <= a3);
    a1 = addr1;
    dot = a1;
    fchanged =+ a2 - a1;
    if (fchanged > FLUSHLIM)
	flushio ();
}

join () {
    register char  *a1,
                   *a2;

    a1 = genbuf;
    addr1 = addr2 - 1;
    if (addr1 <= zero)
	error;
    a2 = getline (*addr2);
    while (*a1++ = *a2++);
    a1 = getline (*addr1);
    while (*a1++);
    --a1;
    a2 = genbuf;
    while (*a1++ = *a2++);
    *addr2 = putline ();
    addr2 = addr1;
    delete ();
}

getline (tl) {
    register char  *bp,
                   *lp;
    register    nl;

    lp = linebuf;
    bp = getblock (tl, READ);
    nl = nleft;
    tl =& ~0377;
    while (*lp++ = *bp++)
	if (--nl == 0) {
	    bp = getblock (tl =+ 0400, READ);
	    nl = nleft;
	}
    return (linebuf);
}

putline () {
    register char  *bp,
                   *lp;
    register    nl;
    int     tl;

    lp = linebuf;
    tl = tline;
    bp = getblock (tl, WRITE);
    nl = nleft;
    tl =& ~0377;
    while (*bp = *lp++) {
	if (*bp++ == '\n') {
	    *--bp = 0;
	    linebp = lp;
	    break;
	}
	if (--nl == 0) {
	    bp = getblock (tl =+ 0400, WRITE);
	    nl = nleft;
	}
    }
    nl = tline;
    tline =+ (((lp - linebuf) + 03) >> 1) & 077776;
    fchanged++;
    if (fchanged > FLUSHLIM)
	flushio ();
    return (nl);
}

getblock (atl, iof) {
    extern  read (), write ();
    register    bno,
                off;

    bno = (atl >> 8) & 0377;
    off = (atl << 1) & 0774;
    if (bno >= 255)
	errfunc (TMPERR);
    nleft = 512 - off;
    if (bno == iblock) {
	ichanged =| iof;
	return (ibuff + off);
    }
    if (bno == oblock)
	return (obuff + off);
    if (iof == READ) {
	if (ichanged)
	    blkio (iblock, ibuff, write);
	ichanged = 0;
	iblock = bno;
	blkio (bno, ibuff, read);
	return (ibuff + off);
    }
    if (oblock >= 0)
	blkio (oblock, obuff, write);
    oblock = bno;
    return (obuff + off);
}

flushio () {
							/* this causes temporaries to be updated to most current state.
							    Then reset fchanged to 1 if fchanged was > 0. */
    int    *a;
    int     i;
    extern  read (), write ();
    if (ichanged)
	blkio (iblock, ibuff, write);
    ichanged = 0;
    blkio (oblock, obuff, write);
    if (tlpfile)
	seek (tlpfile, 0, 0);				/* go back to start */
    else {
	tfname[5] = 'E';
	tlpfile = creat (tfname, 0600);
	tfname[5] = 'e';
    }
    *(dol + 1) = -1;					/* mark eof */
    for (a = zero + 1; a < (dol - 255); a =+ 256)
	if (write (tlpfile, a, 512) != 512)
	    errfunc (IOERR);
    i = dol - a + 2;					/* length of last write */
    i =* 2;
    if (write (tlpfile, a, i) != i)
	errfunc (IOERR);
    if (fchanged)
	fchanged = 1;
							/* don't set to 0 because 'w' command wasn't issued */
}

blkio (b, buf, iofcn)
int     (*iofcn) ();
{
    seek (tfile, b, 3);
    if ((*iofcn) (tfile, buf, 512) != 512)
	errfunc (TMPERR);
}

init () {
    close (tfile);
    rmfiles ();
    fendcore = sbrk (0);
    fchanged = ichanged = 0;
    tline = 0;
    iblock = -1;
    oblock = -1;
    tfname[0] = 'e';
    tfname[4] = '.';
    tfile = creat (tfname, 0600);
    if (tfile < 0) {
							/* couldn't make temp in local area, try /tmp */
	tfname[0] = '/';
	tfname[4] = '/';
	tfile = creat (tfname, 0600);
    }
							/* must close and open it to get the right access! */
    close (tfile);
    open (tfname, 2);
    brk (fendcore);
    dot = zero = dol = fendcore;
    endcore = fendcore - 4;
}

rmfiles () {
    if (tfile) {
	close (tfile);
	tfile = 0;
    }
    if (tlpfile) {
	close (tlpfile);
	tfile = 0;
    }
    tfname[5] = 'E';
    unlink (tfname);
    tfname[5] = 'e';
    unlink (tfname);
    tlpfile = 0;
}

global  (k) {
    register    c;
    register int   *a1;

    if (globp)
	error;
    setall ();
    nonzero ();
    if ((c = getchar ()) == '\n')
	error;
    compile (c);
    globread ();
    for (a1 = zero; a1 <= dol; a1++) {
	*a1 =& ~01;
	if (a1 >= addr1 && a1 <= addr2 && execute (0, a1) == k)
	    *a1 =| 01;
    }
    for (a1 = zero; a1 <= dol; a1++) {
	if (*a1 & 01) {
	    *a1 =& ~01;
	    dot = a1;
	    globp = globuf;
	    commands ();
	    a1 = zero;
	}
    }
}

globread () {
    register char  *gp,
                    c;
    gp = globuf;
    while ((c = getchar ()) != '\n') {
	if (c == EOF)
	    error;
	if (c == '\\') {
	    c = getchar ();
	    if (c != '\n')
		*gp++ = '\\';
	}
	*gp++ = c;
	if (gp >= &globuf[GBSIZE - 2])
	    errfunc (BUFERR);
    }
    *gp++ = '\n';
    *gp++ = 0;
}

substitute (inglob) {
    register    gsubf,
               *a1,
                nl;
    int     getsub ();

    gsubf = compsub ();
    for (a1 = addr1; a1 <= addr2; a1++) {
	if (execute (0, a1) == 0)
	    continue;
	inglob =| 01;
	dosub ();
	if (gsubf) {
	    while (*loc2) {
		if (execute (1) == 0)
		    break;
		dosub ();
	    }
	}
	*a1 = putline ();
	nl = append (getsub, a1);
	a1 =+ nl;
	addr2 =+ nl;
    }
    if (inglob == 0)
	error;
}

compsub () {
    register    seof,
                c;
    register char  *p;
    int     gsubf;

    if ((seof = getchar ()) == '\n')
	return (0);
    if (seof >= 'a' && seof <= 'z') {
	if (seof != 'g')
	    peekc = seof;
	newline ();
	if (seof == 'g')
	    return (1);					/* signal global parm */
	else
	    return (0);
    }
    compile (seof);
    p = rhsbuf;
    for (;;) {
	c = getchar ();
	if (c == '\\')
	    c = getchar () | 0200;
	if (c == '\n')
	    error;
	if (c == seof)
	    break;
	*p++ = c;
	if (p >= &rhsbuf[LBSIZE / 2])
	    errfunc (BUFERR);
    }
    *p++ = 0;
    if ((peekc = getchar ()) == 'g') {
	peekc = 0;
	newline ();
	return (1);
    }
    newline ();
    return (0);
}

getsub () {
    register char  *p1,
                   *p2;

    p1 = linebuf;
    if ((p2 = linebp) == 0)
	return (EOF);
    while (*p1++ = *p2++);
    linebp = 0;
    return (0);
}

dosub () {
    register char  *lp,
                   *sp,
                   *rp;
    int     c;

    lp = linebuf;
    sp = genbuf;
    rp = rhsbuf;
    while (lp < loc1)
	*sp++ = *lp++;
    while (c = *rp++) {
	if (c == '&') {
	    sp = place (sp, loc1, loc2);
	    continue;
	}
	else
	    if (c < 0 && (c =& 0177) >= '1' && c < NBRA + '1') {
		sp = place (sp, braslist[c - '1'], braelist[c - '1']);
		continue;
	    }
	*sp++ = c & 0177;
	if (sp >= &genbuf[LBSIZE])
	    errfunc (BUFERR);
    }
    lp = loc2;
    loc2 = sp + linebuf - genbuf;
    while (*sp++ = *lp++)
	if (sp >= &genbuf[LBSIZE])
	    errfunc (BUFERR);
    lp = linebuf;
    sp = genbuf;
    while (*lp++ = *sp++);
}

place (asp, al1, al2) {
    register char  *sp,
                   *l1,
                   *l2;

    sp = asp;
    l1 = al1;
    l2 = al2;
    while (l1 < l2) {
	*sp++ = *l1++;
	if (sp >= &genbuf[LBSIZE])
	    errfunc (BUFERR);
    }
    return (sp);
}

move (copy)
int     copy;
{
    register int   *adt,
                   *ad1,
                   *ad2;
    int     getcopy ();

    setdot ();
    nonzero ();
    if ((adt = address ()) == 0)
	error;
    newline ();
    fchanged = 0100000;
    if (copy) {
	ad1 = dol + 1;
	append (getcopy, dol);
							/* getcopy delivers addr1 thru addr2; append changes dol */
	ad2 = dol + 1;
    }
    else {
	ad1 = addr1;
	ad2 = addr2 + 1;
    }
    if (adt < ad1) {
	dot = adt + (ad2 - ad1);
	if ((++adt) == ad1)
	    return;
	reverse (adt, ad1);
	reverse (ad1, ad2);
	reverse (adt, ad2);
    }
    else
	if (adt >= ad2) {
	    dot = adt++;
	    reverse (ad1, ad2);
	    reverse (ad2, adt);
	    reverse (ad1, adt);
	}
	else
	    error;
    flushio ();
}

reverse (aa1, aa2) {
    register int   *a1,
                   *a2,
                    t;

    a1 = aa1;
    a2 = aa2;
    for (;;) {
	t = *--a2;
	if (a2 <= a1)
	    return;
	*a2 = *a1;
	*a1++ = t;
    }
}

getcopy () {
    if (addr1 > addr2)
	return (EOF);
    getline (*addr1++);
    return (0);
}

compile (aeof) {
    register    eof,
                c;
    register char  *ep;
    char   *lastep;
    char    bracket[NBRA],
           *bracketp;
    int     nbra;
    int     cclcnt;

    ep = expbuf;
    eof = aeof;
    bracketp = bracket;
    nbra = 0;
    if ((c = getchar ()) == eof) {
	if (*ep == 0)
	    error;
	return;
    }
    else
	if (c == '\n') {
	    peekc = c;
	    return;
	}
    circfl = 0;
    if (c == '^') {
	c = getchar ();
	circfl++;
    }
    if (c == '*')
	goto cerror;
    peekc = c;
    for (;;) {
	if (ep >= &expbuf[ESIZE])
	    goto cerror;
	c = getchar ();
	if (c == eof) {
	    *ep++ = CEOF;
	    return;
	}
	if (c != '*')
	    lastep = ep;
	switch (c) {

	    case '\\': 
		if ((c = getchar ()) == '(') {
		    if (nbra >= NBRA)
			goto cerror;
		    *bracketp++ = nbra;
		    *ep++ = CBRA;
		    *ep++ = nbra++;
		    continue;
		}
		if (c == ')') {
		    if (bracketp <= bracket)
			goto cerror;
		    *ep++ = CKET;
		    *ep++ = *--bracketp;
		    continue;
		}
		if (c == '\n')
		    cerror;
		goto defchar;

	    case '.': 
		*ep++ = CDOT;
		continue;

	    case '\n': 
		*ep++ = CEOF;
		peekc = c;
		return;

	    case '*': 
		if (*lastep == CBRA || *lastep == CKET)
		    error;
		*lastep =| STAR;
		continue;

	    case '$': 
		if ((peekc = getchar ()) != eof)
		    goto defchar;
		*ep++ = CDOL;
		continue;

	    case '[': 
		*ep++ = CCL;
		*ep++ = 0;
		cclcnt = 1;
		if ((c = getchar ()) == '^') {
		    c = getchar ();
		    ep[-2] = NCCL;
		}
		do {
		    if (c == '\n')
			goto cerror;
		    *ep++ = c;
		    cclcnt++;
		    if (ep >= &expbuf[ESIZE])
			goto cerror;
		} while ((c = getchar ()) != ']');
		lastep[1] = cclcnt;
		continue;

	defchar: 
	    default: 
		*ep++ = CCHR;
		*ep++ = c;
	}
    }
cerror: 
    expbuf[0] = 0;
    error;
}

execute (gf, addr)
int    *addr;
{
    register char  *p1,
                   *p2,
                    c;

    if (gf) {
	if (circfl)
	    return (0);
	p1 = linebuf;
	p2 = genbuf;
	while (*p1++ = *p2++);
	locs = p1 = loc2;
    }
    else {
	if (addr == zero)
	    return (0);
	p1 = getline (*addr);
	locs = 0;
    }
    p2 = expbuf;
    if (circfl) {
	loc1 = p1;
	return (advance (p1, p2));
    }
							/* fast check for first character */
    if (*p2 == CCHR) {
	c = p2[1];
	do {
	    if (*p1 != c)
		continue;
	    if (advance (p1, p2)) {
		loc1 = p1;
		return (1);
	    }
	} while (*p1++);
	return (0);
    }
							/* regular algorithm */
    do {
	if (advance (p1, p2)) {
	    loc1 = p1;
	    return (1);
	}
    } while (*p1++);
    return (0);
}

advance (alp, aep) {
    register char  *lp,
                   *ep,
                   *curlp;
    char   *nextep;

    lp = alp;
    ep = aep;
    for (;;)
	switch (*ep++) {

	    case CCHR: 
		if (*ep++ == *lp++)
		    continue;
		return (0);

	    case CDOT: 
		if (*lp++)
		    continue;
		return (0);

	    case CDOL: 
		if (*lp == 0)
		    continue;
		return (0);

	    case CEOF: 
		loc2 = lp;
		return (1);

	    case CCL: 
		if (cclass (ep, *lp++, 1)) {
		    ep =+ *ep;
		    continue;
		}
		return (0);

	    case NCCL: 
		if (cclass (ep, *lp++, 0)) {
		    ep =+ *ep;
		    continue;
		}
		return (0);

	    case CBRA: 
		braslist[*ep++] = lp;
		continue;

	    case CKET: 
		braelist[*ep++] = lp;
		continue;

	    case CDOT | STAR: 
		curlp = lp;
		while (*lp++);
		goto star;

	    case CCHR | STAR: 
		curlp = lp;
		while (*lp++ == *ep);
		ep++;
		goto star;

	    case CCL | STAR: 
	    case NCCL | STAR: 
		curlp = lp;
		while (cclass (ep, *lp++, ep[-1] == (CCL | STAR)));
		ep =+ *ep;
		goto star;

	star: 
		do {
		    lp--;
		    if (lp == locs)
			break;
		    if (advance (lp, ep))
			return (1);
		} while (lp > curlp);
		return (0);

	    default: 
		error;
	}
}

cclass (aset, ac, af) {
    register char  *set,
                    c;
    register    n;

    set = aset;
    if ((c = ac) == 0)
	return (0);
    n = *set++;
    while (--n)
	if (*set++ == c)
	    return (af);
    return (!af);
}

putd () {
    register    r;
    extern  ldivr;

    count[1] = ldiv (count[0], count[1], 10);
    count[0] = 0;
    r = ldivr;
    if (count[1])
	putd ();
    putchar (r + '0');
}

puts (as) {
    register char  *sp;

    sp = as;
    col = 0;
    while (*sp)
	putchar (*sp++);
    putchar ('\n');
}

putchar (ac) {
    register char   i,
                    c;
    static char line[70],
                linx;

    i = linx;
    c = ac;
    if (listf == 1) {
	col++;
	if (col >= 72) {
	    col = 0;
	    line[i] = '\\';
	    line[i + 1] = '\n';
	    i =+ 2;
	}
	if (c == '\t') {
	    c = '>';
	    goto esc;
	}
	if (c == '\b') {
	    c = '<';
    esc: 
	    line[i] = '-';
	    line[i + 1] = '\b';
	    line[i + 2] = c;
	    i =+ 3;
	    goto out;
	}
	if ((c < ' ' && c != '\n') || c == 0177 || c == 0176) {
	    line[i] = '\\';
	    line[i + 1] = (c >> 6 & 07) + '0';
	    line[i + 2] = (c >> 3 & 07) + '0';
	    line[i + 3] = (c & 07) + '0';
	    i =+ 4;
	    col =+ 3;
	    goto out;
	}
    }
    else {
	if (zflag) {					/* stomp long lines */
	    zcount++;
	    if (c == '\t')
		zcount = (zcount + 7) & ~007;
	    if (zcount >= 80 && c != '\n')
		c = 0;
	}
    }
	line[i++] = c;
out: 
    if (c == '\n' || i >= 64) {
	write (1, line, i);
	i = 0;
    }
    linx = i;
}

/*
* Get process ID routine if system call is unavailable.
* getpid()
* {
* 	register f;
* 	int b[1];
* 
* 	f = open("/dev/kmem", 0);
* 	if(f < 0)
* 		return(-1);
* 	seek(f, 0140074, 0);
* 	read(f, b, 2);
* 	seek(f, b[0]+8, 0);
* 	read(f, b, 2);
* 	close(f);
* 	return(b[0]);
* }
*/
ilsubst () {
    register int   *a1,
                    nl;
    extern int  getsub ();
    for (a1 = addr1; a1 <= addr2; a1++) {
	getline (*a1);
	ildo ();
	*a1 = putline ();
	nl = append (getsub, a1);
	a1 =+ nl;
	addr2 =+ nl;
    }
}


ildo () {
    char   *t1,
           *t2,
           *tp;
    int     c,
            tmp,
            n,
            minus,
            tmp2;
restart: 
    n = 1;
    tp = &linebuf[0];
    while (*tp) {
	n++;
	tp++;
    }
    fr = &genbuf[LBSIZE];
    while (n--)
	*--fr = *tp--;
    to = &genbuf[0];
    for (;;) {
	n = 1;
	minus = 0;
	c = ilgetchar ();
	if (c == '-')
	    minus++;
	else
	    peekc = c;
	if ((c = ilgetchar ()) >= '0' && c <= '9') {
	    n = 0;
	    do {
		n =* 10;
		n =+ c - '0';
	    } while ((c = ilgetchar ()) >= '0' && c <= '9');
	}
	else
	    if (c == '$') {
		n = &genbuf[LBSIZE] - fr;
		c = ilgetchar ();
	    }
	if (minus)
	    n = -n;
	switch (c) {
	    case '#': 
	    case CTLH: 
		n = -n;
	    case ' ': 
		if (n < 0)
		    while (n++ && ilmove (LEFT, COPY));
		else
		    while (n-- && ilmove (RIGHT, COPY));
		break;
	    case 'e': 
	    case CTLA: 
		n = -n;
	    case 'd': 
		if (n < 0)
		    while (n++ && ilmove (LEFT, NOCOPY));
		else
		    while (n-- && ilmove (RIGHT, NOCOPY));
		break;
	    case 'c': 
		if (n < 0)
		    n = -n;
		while (n--) {
		    tmp = ilgetchar ();
		    if (!*fr)
			break;
		    if (tmp == EOT)
			break;
		    *fr = tmp;
		    ilmove (RIGHT, COPY);
		}
		break;
	    case 'r': 
		if (n < 0)
		    while (n++ && ilmove (LEFT, NOCOPY));
		else
		    while (n-- && ilmove (RIGHT, NOCOPY));
	    case 'i': 
		while ((tmp = ilgetchar ()) != EOT) {
		    if (to == fr)
			break;
		    if (tmp == CTLH)
			ilmove (LEFT, NOCOPY);
		    else {
			*--fr = tmp;
			ilmove (RIGHT, COPY);
		    }
		}
		break;
	    case '@': 
	    case CTLX: 
		puts ("");				/* output a new line */
		goto restart;
	    case 'f': 
		show ();
		goto finish;
	    case '\n': 
		show ();
		while (ilmove (RIGHT, COPY));
	finish: 
		*to = 0;
		to = &linebuf[0];
		fr = &genbuf[0];
		while (*to++ = *fr++);
		write (1, "\n", 1);
		hiding = 0;
		return;
	    case 'p': 
		show ();
		tp = fr;
		while (*tp)
		    write (1, tp++, 1);
		write (1, "\n", 1);
		tp = &genbuf[0];
		while (tp != to)
		    write (1, tp++, 1);
		break;
	    case 'l': 
		show ();
		tp = fr;
		while (*tp)
		    write (1, tp++, 1);
		write (1, "\n", 1);
		n = to - &genbuf[0];
		while (n--)
		    *--fr = *--to;
		break;
	    case 's': 
		tmp = ilgetchar ();
		if (n < 0)
		    while (n++) {
			ilmove (LEFT, COPY);
			while (to != &genbuf[0] && *(to - 1) != tmp)
			    ilmove (LEFT, COPY);
		    }
		else
		    while (n--) {
			ilmove (RIGHT, COPY);
			while (*fr && *fr != tmp)
			    ilmove (RIGHT, COPY);
		    }
		break;
	    case 'k': 
		tmp = ilgetchar ();
		t1 = fr;
		t2 = to;
		if (n < 0) {
		    while (n++) {
			--t2;
			while (t2 != &genbuf[0] && *--t2 != tmp);
			if (*t2 == tmp) {
			    tmp2 = to - t2;
			    while (tmp2--)
				ilmove (LEFT, NOCOPY);
			}
		    }
		}
		else {
		    while (n--) {
			t1++;
			while (*t1 && *t1 != tmp)
			    t1++;
			if (*t1) {
			    tmp2 = t1 - fr;
			    while (tmp2--)
				ilmove (RIGHT, NOCOPY);
			}
		    }
		}
		break;
	}
    }
}

char    ilmove (dir, cp) int    dir,
                                cp; {
    char    c;
    if (dir == LEFT) {
	if (to == &genbuf[0])
	    return (0);
	hide ();
	c = *--to;
	write (1, &c, 1);
	if (cp == COPY)
	    *--fr = c;
	return (c);
    }
    else {
	if (!*fr)
	    return (0);
	if (cp == COPY)
	    show ();
	else
	    hide ();
	c = *fr++;
	write (1, &c, 1);
	if (cp == COPY)
	    *to++ = c;
	return (c);
    }
}

ilgetchar () {
    char    c,
            d;
    c = getchar ();
    if (c == '\\') {
	d = getchar ();
	if (d == '@' || d == '#' || d == CTLH || d == CTLA || d == '\\')
	    return (d);
	peekc = d;
	return (c);					/* ASSERT: c == backslash */
    }
}

show () {
    if (hiding) {
	write (1, "\\", 1);
	hiding = 0;
    }
}

hide () {
    if (!hiding) {
	write (1, "\\", 1);
	hiding = 1;
    }
}

printlines () {
    register char  *p,
                   *s;
    register int   *a1;
    nonzero ();
    for (a1 = addr1; a1 <= addr2; a1++) {
	zcount = 0;
	if (listf == 2) {
	    count[1] = (a1 - zero) & 077777;
	    putd ();
	    putchar ('\t');
	}
	p = getline (*a1);
	puts (p);
    }
    dot = addr2;
exit: 
    listf = 0;
}

readfile (addr) {
    if ((io = open (file, 0)) < 0)
	errfunc ("Can't open");
    ninbuf = 0;
    fchanged = 0100000;					/* don't flush during read */
    append (getfile, addr);
    flushio ();
    exfile ();
}
getdoc () {
    char    c;
    if (read (did, &c, 1) != 1)
	c = EOF;
    if ((0177 & c) != 033)
	write (1, &c, 1);
    return (c);
}
acceptfile (buf)
char   *buf;
{
    register char   c;

    c = getchar ();
    if (c == '\n' || c == EOF)
	return (1);					/* no file name typed in */
    if (c != ' ')
	error;
    while ((c = getchar ()) == ' ');
    if (c == '\n')
	error;

    do {
	*buf++ = c;
    } while ((c = getchar ()) != '\n');
    *buf = 0;
    return (0);
}
