/This is the integer-to-ascii converter. It assumes that
/the integer is in r0, and that r1 contains a pointer to
/an array of bytes of length greater than or equal to
/2+log10(r0). This is so that,besides the digits, we can
/fit in a nul byte at the end and a possible minus sign
/at the beginning. This will never be more than 8 characters.
/
	.globl  itoa
itoa:   mov     r2,-(sp)
	mov     r3,-(sp)
	tst     r0
	bge     1f
/If the number is negative, negated it and
/insert a minus sign in the buffer.
	movb    '-,(r1)+
	neg     r0
1:      mov     r0,r3
/This loop moves over once for each digit it finds
/will be in a number.
/A null byte is deposited at the end of the string.
1:      clr     r2
	div     $12,r2
	tstb    (r1)+
	mov     r2,r3
	bne     1b
	movb    $0,(r1)
/This is your typical divide-by-ten-and-add-the-digit-zerro-
/to-the-remainder-and-deposit-it-in-your-buffer-until-you're-done
/integer-to-ascii loop.
	mov     r0,r3
1:      clr     r2
	div     $12,r2
	add     $60,r3
	movb    r3,-(r1)
	mov     r2,r3
	bne     1b
	mov     (sp)+,r3
	mov     (sp)+,r2
	rts     pc
