#
/*      DELREMIND command -- Steve Zucker, April, 1976     */
/*       Compile -i, as super user and set mode 04555      */

#define MAXRCVRS 50
#define MAXMSG	 1000
#define DIRSIZE  254    /* No bigger than 254 */
#define MAXREMS  100    /* Maximum that this program can process at once */

char *rmdlock   {"/tmp/rmdlock"};       /* exists while proc is busy */
char *reminders {"/etc/rmdfile"};
char *tempfile  {"/tmp/d.XXXXXX"};
char *rmdtemp   {"/tmp/rmdtemp"};

char *nofile	{"Unable to open %s\n"};
char *norems    {"No reminders\n"};

struct rmdblock
{	int	tdeliver[2];
	int	nobytes;
	int	tsent[2];
	char	sender[8];
	char	bits;
	char    dirsize;
	char	nrcvrs;
	int	msgbytes;
	char    rcvr1[8];
} m, hdr[MAXREMS];

#define PRIORITY 01	/* bits */

#define DELETED  01     /* mark bit */
char    marks[MAXREMS];
int     fdrem, fdcopy, fdtemp, nrmds;
char    rmdbuff[8*MAXRCVRS-8 + MAXMSG + DIRSIZE];
char    rmddata[8*MAXRCVRS-8 + MAXMSG + DIRSIZE];
char    command[160];
char    user[100];      /* password entry then user id null padded */

main()
{       register int i;
	register char *p;
	register char c;
	int j;
	int uid;
	struct {char real, eff; }; /* user id fields */
	extern errno;

	/* Get user name if not superuser */
	uid = getuid();
	if (uid.real)
	{       if (getpw(uid.real, user))
		{       printf (nofile, "password file");
			exit(1);
		}
		else
		{       for (p=user; *p != ':'; p++) ;
			while (p < &user[8]) *p++ = '\0';
		}
	}

	/* Make tempfile name */
	p = &tempfile[7];
	j = getpid();
	for (i=18; i =- 3; )
		*p++ = ((j>>i)&07) + '0';

	lock();

	if ((fdcopy = creat(tempfile,0600)) == -1)
	{       printf(nofile, tempfile);
		exit(1);
	}
	close(fdcopy);
	fdcopy = open(tempfile,2);

	if ((fdrem = open(reminders,0)) == -1)
	{       printf(norems);
		cleanup();
	}

	for (i=0; i<MAXREMS; )
	{
		errno = 0;
		p = &hdr[i];
		if (read(fdrem,p,sizeof m) == 0) break;
		if (errno) ioerror();
		if (uid.real == 0 || equal(user,p->sender,8) ||
		   (p->nrcvrs==1 && equal(user,p->rcvr1,8)))
		{       /* Copy relevant portions of reminder file */
			read(fdrem,rmddata,p->nobytes-8);
			write(fdcopy,rmddata,p->nobytes-8);
			if (errno) ioerror();
			i++;
		}
		else
			seek(fdrem,p->nobytes-8,1);
	}
	close(fdrem);
	unlock();

	if ((nrmds = i) == 0)
	{       printf(norems);
		cleanup();
	}

	printf ("%d messages\n",i);

	/* Collect and execute one command at a time */
	for (;;)
	{       for (i=0; i < sizeof command; )
		{  switch(c = getchar())
		   {    case ' ':
			case '\t':
				continue;  /* Ignore blanks and tabs */
			case '\0':
				cleanup(); /* Exit with no change on EOT */
			case '\n':
				command[i++] = '\0';
				if (parse()) goto wrapup;
				goto nextcom;
			default:
				command[i++] = c;
		   }
		}
		printf ("Line too long\n");
		while ((c = getchar()) != '\n' && c != '\0') ;
    nextcom:  ; /* Make C compiler happy */
	}

wrapup: /* Delete marked messages if any */
	for (i=0; i<nrmds; i++)
		if (marks[i]&DELETED) break;
	if (i >= nrmds) cleanup();
	printf ("Marked reminders are being deleted\n");

	lock();

	if ((fdrem = open(reminders,0)) == -1)
		cleanup();  /* They're all gone anyway */
	if ((fdtemp = creat(rmdtemp,0600)) == -1)
	{       printf(nofile,rmdtemp);
		cleanup();
	}

	while (read(fdrem, &m, sizeof m) == sizeof m)
	{       read(fdrem, rmddata,m.nobytes-8);
		for (i=0; i < nrmds; i++)
		{       if (marks[i]&DELETED && equal(&m,&hdr[i],sizeof m))
			{       getcopy(i);
				if (equal(rmdbuff,rmddata,m.nobytes-8))
				{       /* delete (don't copy) it */
					marks[i] = 0;
					goto nocopy;
				}
			}
		}
		write (fdtemp, &m, sizeof m);
		write (fdtemp, rmddata, m.nobytes-8);
    nocopy:   ; /* Make C compiler happy */
	}

	unlink(reminders);
	link(rmdtemp,reminders);
	cleanup();
}

ioerror()
{       printf("I/O error\n");
	cleanup();
}

cleanup()
{       unlink(rmdtemp);
	unlink(tempfile);
	unlock();
	exit(0);
}

parse()
{       /* Parse command and carry it out */
	register char *p;
	register int i;
	int first, last;
	char *convert();

	p = command;
	switch(*p++)
	{       default: printf ("Invalid command\nCommands are:\n");
			printf ("  headers [list]\n  show [list]\n");
			printf ("  delete [list]\n  keep [list]\n");
			printf ("  write\n  abort\n");
			return(0);
		case 'w': /* Write   */
			return(1);
		case 'a': /* Abort   */
			cleanup();
		case 'h': /* Headers */
		case 's': /* Show    */
			printf ("%-5s%-9s%-9s%-26s%-25s%-5s\n",
				" No","From","To","Sent","For delivery",
				"Flags");
		case 'd': /* Delete  */
		case 'k': /* Keep    */
		     ; /* Keep C compiler happy */
	}

	/* Scan over other alphabetics */
	while (*p >= 'a' && *p <= 'z') p++;

	if (*p == '\0')
	{       perform(command[0],1,nrmds);
		return(0);
	}

	while (p = convert(p,&first))
	{       if (*p == ',' || *p == '\0')
			perform(command[0],first,first);
		else if (*p++ == '-')
		{       if ((p = convert(p,&last)) &&
			    (*p == ',' || *p == '\0'))
				perform(command[0],first,last);
			else break;
		}
		else break;
		if (*p++ == '\0') return(0);
	}
	printf ("Syntax error or index out of range\n");
	return(0);
}

perform(cmnd,first,last)
char cmnd; int first, last;
{       register int i, j;
	register char *p;
	int k;

	j = (--first <= --last ? 1 : -1);
	for (i = first; (i-j) != last; i =+ j)
	{  p = &hdr[i];
	   switch(cmnd)
	   {    case 'd': marks[i] =| DELETED;
			  printf("%5d Marked for deletion\n",i+1);
			  break;
		case 'k': marks[i] =& ~DELETED;
			  printf ("%5d Kept\n",i+1);
			  break;
		case 's':
		case 'h':
			printf("%c%-4d%-8s %-8s %-26.24s",
				(marks[i]&DELETED ? '*' : ' '), i+1,
				p->sender, p->rcvr1, ctime(p->tsent));
			printf ("%-25.24s%c%c\n", ctime(p->tdeliver),
				(p->dirsize ? 'E' : ' '),
				(p->bits&PRIORITY ? 'P' : ' '));
	  }

	  if (cmnd == 's')
	  {     getcopy(i);
		p = rmdbuff;
		for (k = hdr[i].nrcvrs; --k; p =+ 8)
			printf ("%14s%s\n", " ", p);
		if (k = hdr[i].dirsize)
		{       printf ("Directory: ");
			/* Skip over user id byte (++p) */
			write (1,++p,--k);
			p =+ k;
		}
		printf ("\nMessage:\n");
		write (1,p,hdr[i].msgbytes);
		putchar('\n');
	  }
	}
}

getcopy(item)
{       register int i;
	seek(fdcopy,0,0);
	for (i=0; i<item; i++)
		seek(fdcopy,hdr[i].nobytes-8,1);
	read(fdcopy,rmdbuff,hdr[i].nobytes-8);
}

char *convert(pp,an)
char *pp; int *an;
{       register char *p;
	register int i;

	p = pp;
	for (i=0; i <= nrmds; p++)
	{       if (*p >= '0' && *p <= '9')
			i = 10*i + *p - '0';
		else
		{       if (*an = i) return(p);
			else break;
		}
	}
	return(0);
}

/* Use lock file as semaphore.  Can't run as superuser, so forks. */
lock()
{       register int i;
	int x;
	signal(1,1);
	signal(2,1);
	signal(3,1);
	if (fork())
		wait(&x);
	else
	{       setuid(1);      /* 1 is bin, NOT root */
		while ((i = creat(rmdlock,0444)) == -1)
			sleep(5);
		close(i);
		exit();
	}
}

unlock()
{       unlink(rmdlock);
	unlink(rmdtemp);
	signal(1,&cleanup);
	signal(2,&cleanup);
	signal(3,&cleanup);
}

equal(pp,qq)
char *pp, *qq;
{	register char *p, *q;
	register int i;
	p = pp;
	q = qq;
	for (i = 8; i--; )
		if (*p++ != *q++) return(0);
	return(1);
}

