dmr/dj.c        ! 
"  h
 N ,	~Y^dmr/ht.c  
  @  #    M#
c  T  P 	 
F]dmr/hp.c 	e@ W  0	  h
   7  

 	dmr/rt.c    ߋp@E A   J
D* 
  
 
                                                                                                                                                                                                                                                                 #
/* installation:
 *	put symbols for djopen, close, read, write, and sgtty in
 *		../conf/c.c
 *	put symbols for djxint, djrint in ../conf/l.s
 *	cc -c -O dj.c
 *	ar rv ../lib2 dj.o
 *	rm dj.o
 *	make a new unix and boot it
 */


/*
 *	DJ-11 driver
 *	compliments of Peter Nielsen,
 *	Lincoln Labs,
 *	Advanced Seismology Group
 */

#include "../param.h"
#include "../conf.h"
#include "../user.h"
#include "../tty.h"
#include "../proc.h"

/*	DJ device address
 */
#define DJADDR	0160010

#define NDJ11	16	/* number of lines */

struct tty dj11[NDJ11];	/* tty buffers: see tty.h */

/*
 *	Hardware control bits in the csr register
 */
#define TRANSRD	0100000	/* transmitter ready bit */
#define TRANSINT 040000	/* transmitter interrupt enable bit */
#define FIFOFULL 020000	/* FIFO silo full bit */
#define FIFOEN	010000	/* FIFO silo full interrupt enable bit */
#define BRKSEL	02000	/* break select bit */
#define SCANEN	0400	/* transmitter scan enable bit */
#define RCVRDN	0200	/* receiver done bit */
#define RCVRINT	0100	/* receiver interrupt enable */
#define BUSYCLR	020	/* busy clear */
#define MOSCLR	010	/* mos clear */
#define MAINT	04	/* maintenance mode: transmit and receive connected */
#define HDUPLX	02	/* half duplex */
#define RCVREN	01	/* receiver enabled */

/*
 *	Hardware bits in the rbuf and tbuf registers
 */
#define PERROR	010000	/* parity error bit */
#define FRERROR	020000	/* framing error bit */
#define XINT	0100000	/* data present */
#define LINENO	07400	/* line number bits in both rbuf and tbuf */

/*	DJ device registers
 */
struct djregs {
	int djcsr;	/* command and status */
	int djrbuf;	/* receiver buffer */
	int djtcr;	/* transmit control */
	int djtbuf;	/* transmit buffer */
};

/*
 * Open a DJ11 line.
 *	test if line number is greater than the largest possible
 *	line number; if so return error
 *
 *	get tty buffer address
 *	set up djstart routine in loc for special start routine
 *	set csr register bits for the DJ
 *	set teletype state to waiting for open and start routines
 *	if tty not previously opened then set tty state flags
 *	set ttystate to open
 */
djopen(dev, flags)
{
	register struct tty *tp;
	extern djstart();

	if (dev.d_minor >= NDJ11) {
		u.u_error = ENXIO;
		return;
	}
	tp = &dj11[dev.d_minor];
	if (u.u_procp->p_ttyp == 0) {	/* not in at UCHI, replaced SAI */
		u.u_procp->p_ttyp = tp;
		tp->t_dev = dev;
	}
	tp->t_addr = djstart;
/*	tp->t_dev = dev; */	/* UCHI fix for v.5 */
	tp->t_state =| (WOPEN | SSTART);
	if ((tp->t_state & ISOPEN) == 0) {
		tp->t_erase = CERASE;
		tp->t_kill = CKILL;
		tp->t_flags = (XTABS | LCASE | CRMOD | ECHO);
	}
	tp->t_state =& ~WOPEN;
	tp->t_state =| (ISOPEN | CARR_ON);
	DJADDR->djcsr =| (TRANSINT | FIFOEN | SCANEN | RCVRINT | RCVREN);
}

/*
 * Close a DJ11 line
 *	clear the tty state bits and
 *	flush the remaining chars in the buffer
 */
djclose(dev)
{
	register struct tty *tp;

	tp = &dj11[dev.d_minor];
	tp->t_state =& (CARR_ON | SSTART);
	wflushtty(tp);
}

/*
 * Read from a DJ11 line.
 *	call the tty read routine in tty.c
 */
djread(dev)
{
	ttread(&dj11[dev.d_minor]);
}

/*
 * Write on a DJ11 line
 *	call the tty write routine in tty.c
 */
djwrite(dev)
{
	ttwrite(&dj11[dev.d_minor]);
}

/*
 * DJ11 receiver interrupt.
 *	get character from dj register
 *	get line number from dj register
 *	get buffer address
 *	if device not open or parity error wake process
 *	if framing error adjust character to
 *		null 0 (raw mode) or delete, otherwise
 *		put char into the char buffer
 */
djrint()
{
	register struct tty *tp;
	register int c;

	while ((c = DJADDR->djrbuf) < 0) {	/* char present */
		tp = &dj11[(c >> 8) & 017];
		if (tp >= &dj11[NDJ11])
			continue;
		if ((tp->t_state & ISOPEN) == 0 ||
				(c & PERROR)) {
			wakeup(tp);
			continue;
		}
		if (c & FRERROR)		/* break */
			if (tp->t_flags & RAW)
				c = NULL;	/* null for getty */
			else
				c = 0177;	/* DEL (intr) */
		ttyinput(c, tp);
	}
}

/*
 * stty/gtty for DJ11
 *	call tty mode routine in tty.c
 */
djsgtty(dev, av)
int *av;
{
	register struct tty *tp;

	tp = &dj11[dev.d_minor];
	if (ttystty(tp, av))
		return;
}

/*
 * DJ11 transmitter interrupt
 *	while a line is ready to be served (TRANSRD bit high):
 *		reset the transmitter read and interrupt enable bits
 *		get the line number and use it to get the tty buffer
 *		get the next character from the tty buffer
 *		transmit it out by placing it in the transmit register
 *		if this was the last char for this line disable xmit ctrl bit
 *	wake up a sleeping process if it was waiting on a full buffer
 *	reset the transmit interrupt enable bit
 */
djxint()
{
	register struct tty *tp;
	register int c;
	int line, i;
	extern ttrstrt();

	while (DJADDR->djcsr & TRANSRD) {
		DJADDR->djcsr =& ~TRANSINT;     /* TRANSRD cant be cleared */
		line = (DJADDR->djtbuf & LINENO) >> 8;
		tp = &dj11[line];
/*		* get the char from the queue to the dj */
		c = getc(&tp->t_outq);
/*
 *              DJADDR->djtbuf = c;
 *              if ((tp->t_outq.c_cc == 0) | (c < 0))
 *                      DJADDR->djtcr =& ~(1 << tp->t_dev.d_minor);
 *
 *              * the above replaced by jsdy@SAI
 */
		if(c < 0)
			DJADDR->djtcr =& ~(1 << tp->t_dev.d_minor);
		else {
			if((c & ~0177) == 0)
				DJADDR->djtbuf = c;
			else {
				timeout(ttrstrt,tp,c&0177);
				tp->t_state =| TIMEOUT;
				DJADDR->djtcr =& ~(