
/*
 * card -- read cards from card reader, and
 *		convert to ASCII
 *
 *	% cards [output file]
 *
 *	( default output to standard output )
 */

char tab0[040]	{ ' ', '1', '2', '3', '4', '5', '6', '7',
		'8',   0, ':', '=', '\'', '?', 0, '[', '9',
		 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
char tab1[040]	{'0', '/', 's', 't', 'u', 'v', 'w', 'x', 'y', 0,
		']', ',', '(', '#', '_', '&', 'z',
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
char tab2[040]	{ '-', 'j', 'k', 'l', 'm',  'n', 'o', 'p', 'q', 0,
		'"', '$', '*', '^', '!', '>', 'r',
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
char tab3[040]	{ '+', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h',0,
		'<', '.', ')', '@', '\\', ';', 'i',
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

char *tab[] {	tab0, tab1, tab2, 0, tab3, 0, 0, 0};

char buf[100];
int ofd;

main(argc, argp)
char **argp;
{
	register  cnt, fd, i;
	extern fout;

	fout = 2;
	ofd = 1;
	if(argc > 1){
		if(argc > 2){
			printf("syntax: cards [ file ]\n");
			flush();
			exit(1);
		}
		ofd = opn(argp[1], 0644);
	}
	while((fd = open("/dev/cr", 0)) <= 0){
		printf("can't open card reader\n");
		sleep(1);
	}
	while(1){
		cnt = read(fd, buf, 100);
		if(cnt <= 0)
			break;
		for(i=0; i<cnt; i++)
			map(buf[i]);
		outc('\n');
	}
	outf();
	if(cnt < 0)
		printf(" I/O error on card reader\n");
	flush();
	exit();
}

map(c)
{
	register j,k;
	register char *p;

	j = (c>>5)&07;
	k = c &037;
	if((p = tab[j]) && (j = p[k]))
		outc(j);
}
char obuf[512];
char *obp	obuf;
int nob	0;

outc(c)
{
	*obp++ = c;
	if(++nob >= 512){
		write(ofd, obuf, nob);
		obp = obuf;
		nob = 0;
	}
}
outf()
{
	if(nob)
		write(ofd, obuf, nob);
}
