#include "apl.h"

/*
 * misc. other routines
 */

ex_exit()
{
	exit(topfix());
}

ex_fork()
{
	register pid;
	register struct item *p;

	if(pid = fork()){
		if(pid == -1)
			error("couldn't fork");
	}
	pop();
	iodone(pid);
}

ex_wait()
{
	register struct item *p;
	register sig, pid;
	int s;

	sig = signal(2, 1);
	pid = wait1(&s);
	signal(2, sig);
	p = newdat(DA, 1, 3);
	p->datap[0] = pid;
	p->datap[1] = s&0377;
	p->datap[2] = (s>>8)&0377;
	pop();		/* dummy arg */
	*sp++ = p;
}

#define MAXP 20

ex_exec()
{
	register struct item *p;
	register i;
	register char *cp;
	char *argv[MAXP];

	p = fetch1();
	if(p->rank != 2 || p->dim[0] > MAXP || p->size > 500
			|| p->type != CH)
		error("Lexec D");
	cp = p->datap;
	for(i=0; i<p->dim[0]; i++){
		argv[i] = cp + i*p->dim[1];
	}
	argv[p->dim[0]] = 0;
	execv(argv[0], &argv[1]);
	pop();
	p = newdat(DA,0,0);
	*sp++ = p;
}

ex_chdir()
{
	iodone(chdir(iofname()));
}

ex_write()
{
	register int fd, m;
	register struct item *p;

	fd = topfix();
	p = fetch1();
	if(p->type != CH)
		error("Lwrite D");
	m = write(fd, p->datap, p->size);
	pop();
	iodone(m);
}

ex_creat()
{
	register m;

	m = topfix();
	iodone(creat(iofname(), m));
}

ex_open()
{
	register struct item *p;
	register m;

	m = topfix();
	iodone(open(iofname(), m));
}

ex_seek()
{
	register struct item *p;
	int k1, k2, k3;

	p = fetch1();
	if(p->type != DA || p->rank != 1 || p->size != 3)
		error("Lseek D");
	k1 = p->datap[0];
	k2 = p->datap[1];
	k3 = p->datap[2];
	k1 = seek(k1, k2, k3);
	pop();
	iodone(k1);
}

ex_close()
{
	iodone(close(topfix()));
}

ex_pipe()
{
	register struct item *p;
	int pp[2];

	if(pipe(pp) == -1)
		p = newdat(DA, 0, 0);
	else {
		p = newdat(DA, 1, 2);
		p->datap[0] = pp[0];
		p->datap[1] = pp[1];
	}
	pop();
	*sp++ = p;
}

ex_read()
{
	register struct item *p, *q;
	int fd, nb, c;

	fd = topfix();
	nb = topfix();
	p = newdat(CH, 1, nb);
	c = read(fd, p->datap, nb);
	if(c != nb){
		q = p;
		if(c <= 0)
			p = newdat(CH, 0, 0);
		else {
			p = newdat(CH, 1, c);
			copy(CH, q->datap, p->datap, c);
		}
		dealloc(q);
	}
	*sp++ = p;
}

ex_unlink()
{
	iodone(unlink(iofname()));
}

ex_kill()
{
	register pid, signo;

	pid = topfix();
	signo = topfix();
	kill(pid, signo);
	*sp++ = newdat(DA, 0, 0);
}

ex_rd()
{
	/*
	 * note:
	 * an empty line is converted to NULL.
	 * no '\n' chars are returned.
	 */
	char buf[200];
	register struct item *p;
	register fd, i;

	fd = topfix();
	i = 0;
	while((read(fd, &buf[i], 1) == 1) && i < 200 && buf[i] != '\n')
		i++;
	if(i == 200)
		error("Lrd D");
	if(buf[i] == '\n')
		i--;
	p = newdat(CH, 1, i+1);
	copy(CH, buf, p->datap, i+1);
	*sp++ = p;
}

ex_dup()
{
	iodone(dup(topfix()));
}

ex_ap()
{
	register i, fd;
	register struct item *p;

	fd = topfix();
	p = fetch1();
	seek(fd, 0, 2);
	fappend(fd, p);
	if(p->rank == 1)
		write(fd, "\n", 1);
	pop();
	*sp++ = newdat(DA, 0, 0);
}

iodone(ok)
{
	register struct item *p;

	p = newdat(DA, 0, 1);
	p->datap[0] = ok;
	*sp++ = p;
}

iofname(m)
{
	register struct item *p;
	char b[200];

	p = fetch1();
	if(p->type != CH || p->rank > 1)
		error("file name D");
	copy(CH, p->datap, b, p->size);
	b[p->size] = 0;
	pop();
	return(b);
}
fappend(fd, ap)
struct item *ap;
{
	register struct item *p;
	register char *p1;
	int i, dim0, dim1, sb[32];
	char b[200];

	p = ap;
	if((p->rank != 2 && p->rank != 1) || p->type != CH)
		error("file append D");
	dim1 = p->dim[1];
	dim0 = p->dim[0];
	if(p->rank == 1)
		dim1 = dim0;
	p1 = p->datap;
	if(p->rank == 2)
		for(i=0; i<dim0; i++){
			copy(CH, p1, b, dim1);
			p1 =+ dim1;
			b[ dim1 ] = '\n';
			write(fd, b, dim1+1);
		}
	else
		write(fd, p->datap, dim0);
}
