#

/*
 * incremental dump
 * dump fisbuodha filesystem
 * f take output tape from arglist
 * i from date in /etc/dtab
 * s specify tape size in feet (feet = blocks/30)
 * b specify tape size in blocks
 * u update /etc/dtab to current date
 * 0 dump from the epoch
 * d dump specified number of days
 * h dump specified number of hours
 * a on incremental dump, dump files even >= MAXSIZE
 */

char	*dargv[]
{
	0,
	"ai",
	"hp01",
	0
};

#include "/usr/sys/ino.h"
#include "/usr/sys/filsys.h"
#define	MAXSIZE	1000
struct filsys sblock;
struct
{
	char	name[16];
	int	date[2];
} dtab[10];
char	*dfile	"/etc/dtab";
char	*ifile	"/dev/       ";
char	*ofile	"/dev/       ";
int	arg[3];
int	*talist;
int	fi;
int	buf[256];
int	dbuf[256];
int	ibuf[256];
int	vbuf[256];
int	tapbuf[2560];
int	*tapbufp;
char	*date[2];
char	*ddate[2];
char	chgtap	-1;
int	fo;
int	ino;
int	pher;
int	dflg;
int	iflg;
int	cflg;
int	aflg;
char	*tsize	6700;
char	*taddr;

main(argc, argv)
char **argv;
{
	char *c, *key;
	int s, i, nfil, nblk, tblk, f;
	register *tap;
	register struct inode *ip;

	ofile = "/dev/rmt0";
	time(date);
	if(argc == 1) {
		argv = dargv;
		for(argc = 1; dargv[argc]; argc++);
	}

	argc--;
	argv++;
	key = *argv;
	while(*key)
	switch(*key++) {

	default:
		printf("bad character in key\n");
		exit();

	case 'a': /* dump all (even large) */
		aflg++;
		continue;

	case '-':
		continue;

	case 'c': /* increment file name */
		cflg++;
		continue;

	case 'f': /* file name from arg list */
		argc--;
		argv++;
		c = &ofile[5];
		while((*c++ = *argv[0]++) && (c != &ofile[12]));
		continue;

	case 'i': /* date from date file */
		iflg++;
		continue;

	case 's': /* tape size */
		tsize = number(argv[1]) * 3;
		argv++;
		argc--;
		continue;

	case 'b': /* tape size */
		tsize = number(argv[1]) / 10;
		argv++;
		argc--;
		continue;

	case 'u': /* rewrite date */
		dflg++;
		continue;

	case '0': /* dump all */
		ddate[0] = ddate[1] = 0;
		continue;

	case 'd': /* dump some number of days */
		i = 21600;
		goto sd;

	case 'h': /* dump some number of hours */
		i = 900;
		goto sd;

	sd:
		ddate[0] = date[0];
		ddate[1] = date[1];
		s = number(argv[1])*4;
		argv++;
		argc--;
		while(s) {
			if(i > ddate[1])
				ddate[0]--;
			ddate[1] =- i;
			s--;
		}
		continue;
	}
	if(argc <= 1) {
		printf("no file system specified\n");
		exit();
	}
	if(iflg) {
		f = open(dfile, 0);
		if(f >= 0) {
			read(f, dtab, sizeof dtab);
			close(f);
			for(i=0; i<10; i++)
				if(equal(dtab[i].name, argv[1])) {
					ddate[0] = dtab[i].date[0];
					ddate[1] = dtab[i].date[1];
				}
		}
	}
	c = &ifile[5];
	while((*c++ = *argv[1]++) && (c != &ifile[12]));
	printf("dump %s onto %s\n", ifile, ofile);
	fi = open(ifile, 0);
	if(fi < 0) {
		printf("cannot open %s\n", ifile);
		exit();
	}
	printf("incremental dump from\n");
	pdate(ddate);
	sync();
	bread(1, &sblock);
	talist = sbrk(size(0, sblock.s_isize*32)*512);
	tap = talist;
	if(tap == -1) {
		printf("No memory\n");
		exit();
	}
	nfil = 0;
	nblk = size(0, sblock.s_isize*32);
	ino = 0;
	for(i=0; i<sblock.s_isize; i++) {
		bread(i+2, buf);
		for(ip = &buf[0]; ip < &buf[256]; ip++) {
			ino++;
			if((ip->i_mode & IALLOC) == 0 ||
			   ip->i_mode == 0 || ip->i_nlink == 0) {
				*tap++ = -1;
				continue;
			}
			if(ip->i_mtime[0] < ddate[0])
				goto no;
			if(ip->i_mtime[0] == ddate[0] &&
			   ip->i_mtime[1] <  ddate[1])
				goto no;
			s = size(ip->i_size0&0377, ip->i_size1) + 1;
			if (s>MAXSIZE && aflg==0 && iflg!=0) {
				printf("%l big; not dumped.\n", ino);
				goto no;
			}
			nfil++;
			nblk =+ s;
			*tap++ = s;
			continue;
		no:
			*tap++ = 0;
		}
	}
	tblk = ldiv(0, nblk + 9, 10);
	printf("%l files\n%l UNIX blocks\n%l tape blocks\n",nfil, nblk, tblk);
	i = ldiv(0, tblk, ldiv(0, tsize, 100));
	printf("%l.%l%l tapes\n", i / 100, (i = i % 100) / 10, i % 10);

	printf("\n\007mount tape");
	while(getchar() != '\n');
chkprot:
	arg[0] = arg[1] = 1;	/* 1600 bpi; rewind online */
	arg[2] = 0;
	i = cflg;
	cflg = 0;
	otape();
	cflg = i;
	if(write(fo, buf, 2) != 2) {
		printf("\n\007write error: check file protection!!");
		arg[1] = 0;	/* rewind offline */
		stty(fo, arg);
		close(fo);
		while(getchar() != '\n');
		goto chkprot;
	}
	else
		close(fo);
	arg[1] = 0;		/* rewind offline */

	tapbufp = tapbuf;
	tap = buf;
	clrbuf(tap);
	*tap++ = sblock.s_isize;
	*tap++ = sblock.s_fsize;
	*tap++ = date[0];
	*tap++ = date[1];
	*tap++ = ddate[0];
	*tap++ = ddate[1];
	*tap++ = tsize;
	swrite(buf);
	i = size(0, sblock.s_isize*32);
	tap = talist;
	while(i--) {
		bwrite(tap);
		tap =+ 256;
	}
	tap = talist;
	ino = 0;
	for(i=0; i<sblock.s_isize; i++) {
		bread(i+2, buf);
		for(ip = &buf[0]; ip < &buf[256]; ip++) {
			ino++;
			if(*tap && *tap != -1)
				dump(ip, *tap-1);
			tap++;
		}
	}
	clrbuf(buf);
	while(tapbufp != tapbuf)
		bwrite(buf);
	printf("\n%l phase errors\n", pher);
	if(!dflg)
		exit();
	for(i=0; i<10; i++)
		dtab[i].name[0] = 0;
	f = open(dfile, 2);
	if(f < 0) {
		f = creat(dfile, 0666);
		if(f < 0) {
			printf("cannot create %s\n", dfile);
			exit();
		}
	} else
		read(f, dtab, sizeof dtab);
	for(i=0; i<10; i++)
		if(dtab[i].name[0] == 0 || equal(dtab[i].name, argv[1]))
			goto found;
	printf("%s full\n", dfile);
	exit();

found:
	for(s=0; s<15; s++) {
		dtab[i].name[s] = argv[1][s];
		if(argv[1][s] == 0)
			break;
	}
	dtab[i].date[0] = date[0];
	dtab[i].date[1] = date[1];
	seek(f, 0, 0);
	write(f, dtab, sizeof dtab);
	printf("date updated\n");
	pdate(date);
}

pdate(d)
int *d;
{

	if(d[0] == 0 && d[1] == 0)
		printf("the epoch\n"); else
		printf(ctime(d));
}

dump(ip, sz)
struct inode *ip;
{
	register *p, *q, *r;

	p = dbuf;
	q = ip;
	clrbuf(p);
	while(q < &ip->i_mtime[2])
		*p++ = *q++;
	swrite(dbuf);
	if(ip->i_mode & (IFBLK&IFCHR)) {
		if(sz != 0)
			printf("special\n");
		return;
	}
	for(p = &ip->i_addr[0]; p < &ip->i_addr[8]; p++)
	if(*p) {
		if(ip->i_mode&ILARG) {
			bread(*p, ibuf);
			for(q = &ibuf[0]; q < &ibuf[256]; q++)
			if(*q) {
				if(p == &ip->i_addr[7]) {
					bread(*q, vbuf);
					for(r = &vbuf[0]; r < &vbuf[256]; r++)
					if(*r) {
						if(--sz < 0)
							goto pe;
						bread(*r, dbuf);
						bwrite(dbuf);
					}
					continue;
				}
				if(--sz < 0)
					goto pe;
				bread(*q, dbuf);
				bwrite(dbuf);
			}
		} else {
			if(--sz < 0)
				goto pe;
			bread(*p, dbuf);
			bwrite(dbuf);
		}
	}
	if(sz)
		goto pe;
	return;

pe:
	clrbuf(dbuf);
	while(--sz >= 0)
		bwrite(dbuf);
	printf("phase err; ino=%l\n", ino);
	pher++;
}

bread(bno, b)
{

	seek(fi, bno, 3);
	if(read(fi, b, 512) != 512) {
		printf("read error %l\n", bno);
	}
}

clrbuf(b)
int *b;
{
	register i, *p;

	p = b;
	i = 256;
	while(i--)
		*p++ = 0;
}

swrite(b)
int *b;
{
	register i, s, *p;

	i = 254;
	s = taddr;
	p = b;
	while(i--)
		s =+ *p++;
	*p++ = taddr;
	*p = 031415 - s;
	bwrite(b);
}

bwrite(b)
int *b;
{
	register int i, *bufp, *bufe;

	if(chgtap) {
		if(chgtap > 0) {
			printf("\n\007change tapes");
			close(fo);
			while(getchar() != '\n');
		}
		otape();
		chgtap = 0;
	}

	bufp = b;
	bufe = &b[256];
	while(bufp < bufe)
		*tapbufp++ = *bufp++;
	if(tapbufp == &tapbuf[2560]) {
		if(write(fo, tapbuf, 5120) != 5120) {
			printf("write error\n");
			exit();
		}
		tapbufp = tapbuf;
		if(taddr++ >= tsize) {
			taddr = 0;
			chgtap++;
		}
	}
}

number(s)
char *s;
{
	register n, c;

	n = 0;
	while(c = *s++) {
		if(c<'0' || c>'9')
			continue;
		n = n*10+c-'0';
	}
	return(n);
}

size(s0, s1)
{
	register s;
	extern ldivr;

	s = ldiv(s0&0377, s1, 512);
	if(ldivr)
		s++;
	return(s);
}

otape()
{
	register char *p;

	fo = creat(ofile, 0666);
	if(fo < 0) {
		printf("can not open %s\n", ofile);
		exit();
	}
	stty(fo, arg);		/* select 1600 bpi */
	if(!cflg)
		return;
	p = ofile;
	while(*p++)
		;
	p[-2]++;
}

equal(a, b)
char *a, *b;
{

	while(*a++ == *b)
		if(*b++ == 0)
			return(1);
	return(0);
}
