#

	/* Gt40 loader  
	 *	Forrest William Howard, Jr.
	 *	Commercial Union Leasing Co.
	 *	645 Madison Avenue
	 *	New York, NY. 10022
	 *
	 * This loads an a.out file into the gt40.
	 * Use and description:
	 *
	 *   Start the gt40/42 at 166000. This starts the hardWare bootstrap.
	 *   Use the converstaion facilities provided by this to log in
	 *   and type:
	 *	#gt40  filename
	 *   The file should be an a.out format file produced by
	 *   linker, ld, or as.
	 *
	 *   After a while, the program will start at location 0.
	 *   The sp is initilized to the highest location in core,
	 *   although the program should probably not rely on this.
	 *
	 *   For you technical fiends, the loading is actually
	 *   accomplished with two loaders, the first the hardware
	 *   loader, and the second an a.out loader, which is loaded by 
	 *   the first (whose .lda file must live at the place mentioned
	 *   in the below define).
	 *
	 *   Other comments:
	 *	core is zeroed so bss works.
	 * 	 (this is not totally true... the top 200 words or so
	 *	 are left with the image of the loader).
	 *	Loading takes a while... even at 9600 baud, only about
	 *	 18000 words are loaded each minute.
	 *
	 *	Compile instructions:
	 *		cc -O gt40.c
	 *		mv a.out gt40
	 *		as gt40l.s
	 *		mv a.out gt40l.out
	 *		lda gt40l.out
	 *		mv gt40l.lda to ?????	(where it lives )
	 *					( see define below)
	 *	Parts of this were taken from the berkeley gtload.
	 */


#define GT40L	"/sys/gt42/gt40l.lda"
#define	NODELAY	01
#define	XTABS	02
#define	LCASE	04
#define	ECHO	010
#define	CRMOD	020
#define	RAW	040
#define	ODDP	0100
#define	EVENP	0200
#define	NTDELAY 010000


char	junk[20];	/* for read-back */
char	ibuf[520];	/* use getc/getwd */
char	lbuf[520];	/* for loader */
char	obuf[520];	/* for outputing stuff */
int	ttymode[3];
int	lsize;
int	ldaflg;		/* load the file as an .lda file */

char	reset[] {
	0175,'R',0175,'L','@','@','@','@','@','@','@','@' 
};
main(argc,argv)
char	**argv;
{
	extern	onintr();
	register savetty;
	if(argc < 2) {
		type(2,"Usage: gt40 file(.out)\n");
		exit(1);
	}
	if (argc==3)
		ldaflg++;		/* load just lda file */
	else {
		if(fopen(stickext(argv[1],"out",0),ibuf)== -1){
			type(2,"Can't get input\n");
			exit(1);
		}
		if(getw(ibuf)!= 0407){
			type(2,"Must be 0407 header\n");
			exit(1);
		}
		lsize=getw(ibuf)+getw(ibuf);
		if(lsize==0){
			type(2,"Empty program\n");
			exit(1);
		}
		getw(ibuf); getw(ibuf); getw(ibuf); getw(ibuf); getw(ibuf);
	}
	if(fopen(ldaflg ? argv[1] : GT40L,lbuf)== -1){
		type(2,"No subloader???\n");
		exit(1);
	}
	obuf[0]=1;

	gtty(0,ttymode);
	savetty=ttymode[2];
	/* set lower case, no echo, no cr-lf mapping, */
	ttymode[2]=& ~(ECHO|LCASE|CRMOD);
	ttymode[2]=| RAW;
	stty(0,ttymode);
	ttymode[2]=savetty;
	signal(2,&onintr);

	write(1,reset,12);
	loadit(lbuf);		/* load the loader */
	if (read(0, junk, 1) < 0 || (junk[0]&0177) != 033) {
bad:		type(2, "Bad load\n");
		stty(0, ttymode);
		exit(1);
	}
	read(0, junk, 1);	/* read 'G' or 'B' */
	if ((junk[0] & 0177) != 'G') goto bad; 
	sleep(2);		/* give it a chance to clear core */
	if (ldaflg)
		exit(0);
	loadll(ibuf);		/* load the "actual" stuff */
	stty(0,ttymode);
	close(lbuf[0]);
	close(ibuf[0]);
}


stickext(s,ext,f)
char	*s,*ext;
{
	static	name[134];
	register	dot;
	register char	*cs,*cd;

	cs = s;
	dot = 0;	/* is set to 0 when / seen;
			   set to 1 when dot seen */
	cd = name;
	if(! *cs){
		type(2,"Internally saw null file name\n");
		exit(1);
	}
	do {
		if(*cs == '/')	 dot = 0;
		if(*cs == '.')   dot = 1;
		*cd++ = *cs;
		if(cd > &name[128]){
			type(2,"File name too long\n");
			exit(1);
		}
	} while (*cs++);
	--cd;
	if(dot && f<0){
		do {
		  dot= *cd;
		  *cd--=0;
		} while(dot != '.');
		dot=0;
		cd++;
	}
	if(dot) return(s); /* name had dot-- don't append another*/
	cs = cd;
	*cd++ = '.';
	while(*cd++ = *ext++);
	if((! f) && (stat(name,junk)== -1))
					*cs = 0;
	return(name);
}



loadit(p)
char	*p;
{
	register char	*b;
	static char	buf8[3],buf6[4];
	register char *to;
	register c;

	b=p;
	for(;;){
		to= buf8;
		while(to < &buf8[3]){
			c= getc(b);
			if(c == -1 ){
				if(to == buf8){
					fflush(obuf);
					return;
				}
				while(to < &buf8[3])
					*to++ = 0;
				break;
			} else
				*to++ = c;
		}

		buf6[0] = (buf8[0]>>2)&077;
		buf6[1] = ((buf8[0]<<4)&060)|((buf8[1]>>4)&017);
		buf6[2] = ((buf8[1]<<2)&074)|((buf8[2]>>6)&03);
		buf6[3] = buf8[2]& 077;
		/* below used to be an assign and while,
			but would not opt. properly */
		for(to=buf6;to < &buf6[4];){
			putc((*to< 040? *to++ + 0100 : *to++),obuf);
		}
	}
}



loadll(p)
char	*p;
{
	/* we'll load in two 6 bits, and 1 4 bit */

	register i;
	register char *b;
	register sobc;

	b=p;
	i= lsize;
	lsize=>>1;
	lsize=& 077777;

	do {
		stuff(i);
		stuff(i=>>6);
		stuff(i=>>6);
		i=getw(b);
	} while(lsize--);
	fflush(obuf);
}

onintr()
{
	stty(1,ttymode);
	exit(1);
}

type(c,s)
char	*s;
{
	register char	*sf,*st;

	sf=st=s;
	while(*sf++);
	--sf;
	write(c,st,sf-st);
}


stuff(i)
{
	register	ii;

	ii=i;
	ii=& 077;
	if(ii<040)
		ii=+ 0100;
	putc(ii,obuf);
}
