#
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * *
		Created by Peter Langston

Permission to copy, either in whole or in part, is  hereby
granted  to  anyone  wishing to do so with the restriction
that this entire notice must accompany any copies.

Copyright (c) 1976 by Peter S. Langston
*		      Commercial Union Leasing Co
*		      645 Madison Ave
*		      New York, NY 10022
* * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/*
**	FOLD -- FOrmat listing for nyLon post binDer
**		--		     -		 -
**	Compile: cc -O -n fold.c 
*/

#define	BEL	007
#define	BS	010
#define	HT	011
#define	LF	012
#define	FF	014
#define	CR	015
#define	SP	040

#define	TMPFILE	"    "

char	*stars "\
******************************************************************\
******************************************************************\n";
char	*curr_file, owner[34];
int	line, num_files, uid;

struct	{
	int	fildes, nleft;
	char	*nextp, buf[512];
} ibuf, obuf;

main(argc, argv)
char **argv;
{
	char *argbuf[12], **argp, *arg, *cp;

	if (argc < 2) {
		write(2, "Usage: fold [-switch...] file1 [file2...]\n", 42);
		write(2, "  See \"man fold\".", 17);
		exit(-1);
	}
	if (stat(TMPFILE, &obuf.buf) != -1) {
		write(2, "Fold temp file (\"    \") already exists...\n", 42);
		exit(-1);
	}
	if (fcreat(TMPFILE, &obuf) < 0) {
		write(2, "Unable to fcreat temp file in this dir\n", 39);
		exit(-1);
	}
	num_files = 0;
	uid = getluid();
	cp = copy("	", owner);
	cp = copy(getfstn(uid), cp);
	cp = copy(" ", cp);
	cp = copy(getlstn(uid), cp);
	cp = copy("\n", cp);
	argp = argbuf;
	*argp++ = "The one, (the only) *F*O*L*D* !";
	*argp++ = "-ps";	/* surpress page numbers */
	*argp++ = "-t";		/* Truncate long lines */
	while (--argc) {
		arg = *++argv;
		if (*arg == '-') {
			*argp++ = arg;
			continue;
		}
		curr_file = arg;
		fold();
	}
	*argp++ = TMPFILE;
	*argp = 0;
	if (num_files > 0) {
		fflush(&obuf);
		if (fork() == 0) {
			execv("/bin/print",argbuf);
			write(2, "Failed to exec /bin/print\n", 25);
			exit(-1);
		}
		wait();
	}
	unlink(TMPFILE);
}

fold()
{
	register char c;
	register int garbage;
	char junk[512], *cp;
	int page;

	if (fopen(curr_file, &ibuf) < 0) {
		cp = copy("Unable to fopen '", junk);
		cp = copy(curr_file, cp);
		cp = copy("'\n", cp);
		write(1, junk, cp-junk);
		return;
	}
	if (num_files++) {
		putc(FF, &obuf);
		puts(stars);
		puts(owner);
	}
	puts("\n\n\n");
	page = 1;
	line = 55;
	garbage = 0;
	while ((c=getc(&ibuf)) != -1) {
		switch (c) {
		case LF:
			putc(LF, &obuf);
			if (--line == 0)
				header(page++);
			garbage = 0;
			break;
		case FF:
			while (--line >= 0)
				putc(LF, &obuf);
			header(page++);
			garbage = 0;
			break;
		case BEL:
		case BS:
		case HT:
		case CR:
			putc(c, &obuf);
			break;
		default:
			if (c < SP && garbage++ > 25) {
				puts("\n\n*** GARBAGE IN / GARBAGE OUT ***");
				line =- 2;
				goto quit;
			}
			putc(c, &obuf);
			break;
		}
	}
quit:
	close(ibuf.fildes);
	if (page & 1)  {
		while (--line >= 0)
			putc(LF, &obuf);
		header(page++);
	}
}

header(page)
{
	line = 57;
	if ((page & 1) == 0) {
		puts("\n\n\n\n");
		puts(stars);
		puts(stars);
		puts("\n\n\n\n");
		return;
	}
	title(page);
	puts("\n\n");
	title(page+1);
}

title(page)
{
	int tvec[2];

	puts("\nPage ");
	if (page > 99)
		putc((page/100)|'0', &obuf);
	if (page > 9)
		putc(((page%100)/10)|'0', &obuf);
	putc((page%10)|'0', &obuf);
	puts("  	");
	puts(curr_file);
	puts("		");
	time(tvec);
	puts(ctime(tvec));
	putc(LF, &obuf);
}

puts(string)
char *string;
{
	register char *cp, c;

	cp = string;
	while (c = *cp++)
		putc(c, &obuf);
}



copy(from,to)
char *from, *to;
{
	register char *f, *t;

	f = from;
	t = to;
	while (*t++ = *f++);
	return(--t);
}
