#
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * *
		Created by Peter Langston

Permission to copy, either in whole or in part, is  hereby
granted  to  anyone  wishing to do so with the restriction
that this entire notice must accompany any copies.

Copyright (c) 1976 by Peter S. Langston
*		      Commercial Union Leasing Co
		      645 Madison Avenue
*		      New  York,  N.Y.
* * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
**	BANNER -- Produce large signs on the line printer
**
**	Compile: cc -O -n banner.c 
*/

#define eschar 033
#define LPLEN	132

char *ofile "?????????????????????";
char *chfil, chx, chy, chsiz;
char cbuf[256], chdot[8][11], dchar[2], dot[10][20], obuf[66][LPLEN];
char cfh, ofh, jnk[100], lf[66], xo, yo, lx, ly;
char cflg, uflg;
struct {
	char x,y;
} ds;

main()
{
	char *cp, *cep, *jp, flg;
	register int i;
	int dfh;

		/* the next three lines determine the char set */
	chfil = "/sys/programs/banner/7x9.dot";
	chx = 7;
	chy = 11;

	chsiz = chx*chy+1;
	if ((cfh=open(chfil,0)) < 0) {
		printf("character set file \"%s\" unopenable\n", chfil);
		exit(-1);
	}
	for (i=0; i<66; i++)
		lf[i] = '\n';
ofloop:
	gets("output file : ",ofile);
	if (*ofile == 0)
		ofile = "junk";
	if ((ofh=creat(ofile,0600)) < 0)
		goto ofloop;
dotlop:
	gets("dot design : ",cbuf);
	jp = "/sys/programs/banner/dot?";
	if (*cbuf == 0)
		jp[24] = '5';
	else
		jp[24] = *cbuf;
	if ((dfh=open(jp,0)) < 0) {
		printf("dot type %c non-existent\n",*cbuf);
		goto dotlop;
	}
	read(dfh,&ds,2);
	seek(dfh,1,1);
	printf("for a %dx%d dot the standard h, v overlaps",ds.y,ds.x);
	printf(" are %d, %d\n",yo=ds.y*.3+.6,xo=ds.x*.24+.5);
overlop:
	printf("h, v overlaps : ");
	cp = jnk;
	if (read(0,cp,100) > 1) {
		yo = ds.y - atoi(cp);
		while (*cp++ != ',')
			if (cp-jnk > 20)
				goto overlop;
		xo = ds.x - atoi(cp);
	} else {
		yo = ds.y - yo;
		xo = ds.x - xo;
	}
	lx = (chy-1)*xo+ds.x;
	if (lx > LPLEN) {
		printf("squeeze...\n");
		lx = LPLEN;
		i = (lx-ds.x)/(chy-1);
		yo = yo*i/xo;
		xo = i;
	}
	getd(dfh);
	close(dfh);
	gets("dot chars : ",cbuf);
	if (*cbuf != 0) {
		dchar[0] = cbuf[0];
		dchar[1] = cbuf[1];
	} else {
		dchar[0] = '*';
		dchar[1] = 'O';
	}
	write(ofh,lf,66);
	cep = gets("text : ",cbuf);
txtlop:	for (cp=cbuf; cp<cep; cp++) {
		if (*cp != eschar) {
			letter(*cp);
			continue;
		}
		flg = 1;
	esclop:	switch (*++cp) {
		case eschar:
			letter(eschar);
			break;
		case '-':
			flg = 0;
			goto esclop;
		case 'c':
			cflg = flg;
			break;
		case 'f':
			if ((i=open(++cp,0)) < 0) {
				printf("can't open %s\n",cp);
				exit();
			}
			cep = cbuf + read(i,cbuf,256);
			goto txtlop;
		case 'u':
			uflg = flg;
			break;
		case '0':
			i = 0;
			while (*++cp != eschar) i = (i<<3) + *cp-060;
			letter(i);
			break;
		default:
			if (*cp<'0' || *cp>'9') {
				printf("$ error...?$%s\n",cp);
				exit();
			}
			i = 0;
			while (*++cp != eschar) i = i*10 + *cp-060;
			letter(i);
			break;
		}
	}
	write(ofh,lf,66);
	gets("print now? ",cbuf);
	if (*cbuf != 'y') exit();
	if (fork() == 0) execl("/bin/print","print",ofile,0);
	wait();
	gets("delete file? ",cbuf);
	if (*cbuf == 'y') unlink(ofile);
}

gets(cp,bp)
char *cp, *bp;
{
	int l;

	printf("%s",cp);
	l = read(0,bp,256)-1;
	bp[l] = 0;
	return(&bp[l]);
}

getn(cp)
{
	printf("%s",cp);
	read(0,jnk,100);
	return(atoi(jnk));
}

getd(n)
{
	register int i, j;

	for (i=0; i<ds.y; i++) {
		read(n,jnk,ds.x+1);
		for (j=0; j<ds.x; j++)
			dot[i][j] = jnk[j]==' ' ? 0 : 1;
	}
}

letter(c)
{
	register char *op;
	char out[LPLEN*2+2], *lstx, *bp, chwide;
	register int i, j;
	int k;

	if (c == ' ') {
		write(ofh,lf,ds.y+ds.x);
		return;
	}
	if (cflg && c>='a' && c<='z') c =& ~040;
	seek(cfh, chsiz*c, 0);
	if (read(cfh, &chwide, 1) != 1 ||
		read(cfh, chdot, chsiz-1) != chsiz-1) {
			printf("Read error in character dot file");
			exit(1);
	}
	ly = chwide; ly =* yo; ly =+ ds.y;
	for (i=0; i<chwide; i++) {
		k = i*yo;
		for (j=0; j<chy; j++) {
			if (chdot[i][j]) dotat(k,j*xo);
		}
	}
	if (uflg) {
		for (i=0; i<=chwide; i++) {
			k = i==chwide ? i : i+1;
			for (j = i==0?0:i-1; j<=k; j++)
				if (chdot[j][0]) j = 9999;
			if (j < 9999) dotat(i*yo,0);
		}
	}
	/* obuf prepared */
	for (i=0; i<ly; i++) {
		for (lstx = &obuf[i][lx]; --lstx >= obuf[i];)
			if (*lstx) break;
		op = out;
		for (bp=obuf[i]; bp<=lstx; bp++) {
			if (*bp) *op++ = dchar[0];
			else *op++ = ' ';
		}
		*op++ = '\r';
		for (bp=obuf[i]; bp<=lstx; bp++) {
			if (*bp) {
				*op++ = dchar[1];
				*bp = 0;
			} else *op++ = ' ';
		}
		*op++ = '\n';
		write(ofh,out,op-out);
	}
}

dotat(ii,jj)
{
	register int i, j;

	for (i=0; i<ds.y; i++)
		for (j=0; j<ds.x; j++)
			if (dot[i][j]) obuf[ii+i][jj+j] = 1;
}
