			Changes to the C Debugger

				P. Jones, CAC


^
	Steps backward through the debugged process or file, the same as
	in 'db'.  The last mode you used with '/' is the mode that you get.

%a file
	Auto command.  Reads 'file' which can be any legal pathname, and
	interprets the input just as it would from the tty.  This is nice
	for lengthy setups (or short setups if you're lazy) at the start of
	a debugging session.  Any command execept '%a' is legal in the file.

n,m!x
	Puts the value x into the range of locations from n,m inclusive.
	If the debugged program has not been run, the image on the disk
	is patched as in 'db', otherwise the core image is changed.  Of
	course if only one value is used (n!x), only that location is
	changed.  Normal typein rules apply.

:
	When referencing automatic variables, cdb now remembers the procedure
	name so that to get to another variable in that procedure all you
	do is type ':var'.  You can use this with the '!' command too!

n,m%s;<rubout>
	Single step command.  After a breakpoint is reached, the program
	can be continued instruction by instruction.  '%s' can be used
	repeatedly but it is easier after the first one just to hit
	the rubout key (interrupt).  The program resumes normally with
	the '%c' command.  If the 'n,m%s' construct is used, (m-n)+1 instructions
	are executed.

	The '%s' command can be followed by an optional group number
	which remains in effect until another '%s' is executed.  The
	named group will print after each instruction during single stepping.

.
	The notion of 'dot' is now accepted the same as in 'db'.

*
	Causes indirection.  The contents of the expression are used
	as an address and that location is printed in the current mode.
	If no expression is used, * operates on 'dot'.

#
	Causes the next symbol to be taken as is; i.e., there is no '_'
	prepended to it.  Very useful for working with non-C generated symbols.

%bn
	Breakpoints with group printout.  n is 0-9 to specify which group
	of variables are to be typed each time the breakpoint is reached.

%gn {<spec> {,<spec>}*}?
	The group specification command.  It allows up to ten groups, numbered
	from 0-9, to be set up.  <spec> is a legal core location (symbolic or
	otherwise) followed by an optional mode specifier.

		Ex:
			%g0 var1/o,var2/",var3

	This means that group 0 consists of var1 to be treated as octal, var2 to
	be a string pointer, and var3 three to have the default attributes.
	Any mode legal at the top level of cdb is legal in a group
	spec.


	To delete a group, just type '%gn' where n is the group to delete.  If
	you make an error in the specifications, the old group will not be
	affected.

%pn
	Prints group n immediately.
