
.globl exp, _exp
.globl fpsim, fpsr, m.ext, m.lngi       / Floating point  stuff

/  This routine was converted to call the floating point
/  simulator directly 1-14-76 (rfb of ucsdcdcfs)

/
	jsr     pc, fpsim       / call floating point simulator
ldfps = 170100^tst
	jsr     pc, fpsim       / call floating point simulator
stfps = 170200^tst
/
/       exp accepts its argument and returns its result
/       in fr0.  the carry bit is set if the result overflows.
/       the coefficients are #1067 from hart & cheney.
/
	jsr     pc, fpsim       / call floating point simulator
/       movf    arg,fr0
/       jsr     pc,exp
	jsr     pc, fpsim       / call floating point simulator
/       movf    fr0,result
/
_exp:
	mov     r5,-(sp)
	mov     sp,r5
	mov     4(r5),fr0
	jsr     pc,exp
	mov     (sp)+,r5
	rts     pc

exp:
	jsr     pc, fpsim       / call floating point simulator
	stfps   -(sp)
	jsr     pc, fpsim       / call floating point simulator
	ldfps   $200            /di mode
	jsr     pc, fpsim       / call floating point simulator
	movf    fr2,-(sp)
	jsr     pc, fpsim       / call floating point simulator
	movf    fr1,-(sp)
	jsr     pc, fpsim       / call floating point simulator
	tstf    fr0
	jsr     pc, fpsim       / call floating point simulator
	cfcc
	bne     1f
	jsr     pc, fpsim       / call floating point simulator
	movf    $one,fr0        /exp(0)
	clc
	br      out
1:
	jsr     pc, fpsim       / call floating point simulator
	modf    log2e,fr0       /exp(x) = 2^(x*log2(e))
	jsr     pc, fpsim       / call floating point simulator
	cfcc
	bmi     2f
	jsr     pc, fpsim       / call floating point simulator
	movfi   fr1,-(sp)       /save integer part
	jsr     pc, fpsim       / call floating point simulator
	subf    $half,fr0
	br      3f
2:
	jsr     pc, fpsim       / call floating point simulator
	movfi   fr1,-(sp)
	dec     (sp)
	jsr     pc, fpsim       / call floating point simulator
	addf    $half,fr0
3:
	jsr     pc, fpsim       / call floating point simulator
	movf    fr0,fr1         / -.5 < x < +.5
	jsr     pc, fpsim       / call floating point simulator
	mulf    fr1,fr1         /arg**2
/
	jsr     pc, fpsim       / call floating point simulator
	movf    p2,fr2
	jsr     pc, fpsim       / call floating point simulator
	mulf    fr1,fr2
	jsr     pc, fpsim       / call floating point simulator
	addf    p1,fr2
	jsr     pc, fpsim       / call floating point simulator
	mulf    fr1,fr2
	jsr     pc, fpsim       / call floating point simulator
	addf    p0,fr2
	jsr     pc, fpsim       / call floating point simulator
	mulf    fr2,fr0         /xp(x**2)
/
	jsr     pc, fpsim       / call floating point simulator
	movf    fr1,fr2
	jsr     pc, fpsim       / call floating point simulator
	addf    q1,fr2
	jsr     pc, fpsim       / call floating point simulator
	mulf    fr1,fr2
	jsr     pc, fpsim       / call floating point simulator
	addf    q0,fr2          /q(x**2)
/
	jsr     pc, fpsim       / call floating point simulator
	movf    fr2,fr1
	jsr     pc, fpsim       / call floating point simulator
	subf    fr0,fr1
	jsr     pc, fpsim       / call floating point simulator
	addf    fr2,fr0
	jsr     pc, fpsim       / call floating point simulator
	divf    fr1,fr0         /(q+xp)/(q-xp)
	jsr     pc, fpsim       / call floating point simulator
	mulf    sqrt2,fr0
/
	jsr     pc, fpsim       / call floating point simulator
	movei   fr0,-(sp)
	add     (sp)+,(sp)
/
	cmp     (sp),$177
	ble     2f
	tst     (sp)+
	jsr     pc, fpsim       / call floating point simulator
	movf    big,fr0         /overflow
	sec
	br      1f
2:
	cmp     (sp),$-177
	bge     2f
	tst     (sp)+
	jsr     pc, fpsim       / call floating point simulator
	clrf    fr0             /underflow
	clc
	br      1f
2:
	jsr     pc, fpsim       / call floating point simulator
	movie   (sp)+,fr0
	clc
1:
out:
	jsr     pc, fpsim       / call floating point simulator
	movf    (sp)+,fr1
	jsr     pc, fpsim       / call floating point simulator
	movf    (sp)+,fr2
	jsr     pc, fpsim       / call floating point simulator
	ldfps   (sp)+
	rts     pc
/
/
	.data
p0:      42675;  36404;  77563;  46675
p1:      41241; 116724; 114237;  60333
p2:      36675;  27102; 125560; 136652
q0:      43210; 100661;  76072;  62453
q1:      42151;  27450;  75350; 112503
log2e:   40270; 125073;  24534;  13761
sqrt2:   40265;  02363;  31771; 157144
half    = 40000
one     = 40200
/
big:     77777; 177777; 177777; 177777
/
/ p0 = .15139 06799 05433 89158 94328 d4
/ p1 = .20202 06565 12869 27227 886   d2
/ p2 = .23093 34775 37502 33624       d-1
/
/ q0 = .43682 11662 72755 84984 96814 d4
/ q1 = .23318 42114 27481 62379 0295  d3
/ q2 = .1                             d1
/
/ log2e = 1.44269 50408 88963 40735 99246
/ sqrt2 = 1.41421 35623 73095 04880 16887

