.CH "Error handling"
There are three classes of errors to be distinguished.
In the first class are the error messages generated by the compiler.
The second class consists of the occasional errors generated by the other
programs involved in the compilation process.
Errors of the third class are the errors as defined in the standard by:
.DS
An error is a violation by a program of the requirements of this standard
such that detection normally requires execution of the program.
.DE
.SH "Compiler errors"
The error messages (and the listing) are not generated by the compiler itself.
The compiler only detects errors and writes the errors in condensed form on
an intermediate file.
Each error in condensed form consists of:
.IS
.LB -
an optional error messages parameter (identifier or number).
.LB -
an error number
.LB -
a line number
.LB -
a column number.
.IE
In all cases where the compiler detects an error which does not have influence
on the code produced by the compiler or on the syntax decisions, a warning
messages is given.
If only warnings are generated, compilation proceeds and probably results
in a correctly compiled program.
.PP
The intermediate file is read by the interface program pc [4], which produces the error messages.
It uses an other file, the error message file, indexed by the error number
to find an error script line.
Whenever this error script line contains the character '%', the error messages
parameter is substituted.
For negative error numbers the so constructed message is prepended with 'Warning: '.
.PP
Sometimes the compiler produces several errors for the same file position
(line number, column number).
Only the first of these messages is given, because the others are probably
directly caused by the first one.
If the first one is a warning while one of its successors for that position
is a fatal message, then the warning is promoted to a fatal one.
However, parameterized messages are always given.
.PP
The error messages and listing come in three flavours, selected by flags
given to pc [4]:
.in +10
.sp
.ti -8
default:no listing, one line per error giving the line number and the error messages.
.sp
.ti -8
-e:~~~~~for each erroneous line a listing of that line and its predecessor.
The next line contains one or more characters '^' pinpointing to the
places where an error is detected.
For each error on that line a message follows.
.sp
.ti -8
-E:~~~~~same as for '-e', except that all source lines are listed,
even if the program is perfect.
.IE
.IE
.SH "Other errors detected at compilation time"
Two main categories: file system problems and table overflow.
Problems with the file system may be caused by protection (you may not read
or create files) or by space problems (no space left on device; out of inodes;
too many processes).
Table overflow problems are often caused by peculiar source programs:
very long procedures or functions, a lot of strings.
.PP
Extensive treatment of these errors is outside the scope of this manual.
.SH "Runtime errors"
Errors detected at runtime cause an error message to be generated on the
diagnostic output stream (UNIX file descriptor 2).
The message consists of the name of the program followed by a message
describing the error, possibly followed by the source line number.
Unless the l-option is turned off, the compiler generates code to keep track
of which source line causes which EM1 instructions to be generated.
It depends on the EM1-implementation whether these LIN instructions
are skipped or executed:
.I1
LIN instructions are always executed. The old line number is saved and
restored whenever a procedure or function is called.
All error messages contain this line number, except when the l-option
was turned off.
.I2
same as above, but line numbers are not saved when procedures and functions
are called.
.IE
For each error mentioned in the standard we give the section number,
the quotation from that section and the way it is processed by the
Pascal-VU system.
.IT 6.4.3.3
An error should be caused if a reference is made to a field of a variant other than the
current variant.
.IS
This error is not detected.
Sometimes this feature is used to achieve easy type conversion.
However, using record variants this way is dangerous, error prone and not portable.
.IT 6.4.6
An error should be caused if an expression E of type T2 must be
assignment-compatible with type T1, while
T1 and T2 are compatible ordinal-types and the value of
E is not in the closed interval specified by T1.
.IS
The compiler distinguishes between array-index expressions and the other
places where assignment-compatibility is required.
.PP
Array subscripting is done using the EM1 array instructions.
These instructions have three arguments: the array base address,
the index and the address of the array descriptor.
An array descriptor describes one dimension by three values:
the element size, the lower bound on the index and the number of elements
minus one.
It depends on the EM1-implementation whether these bounds are checked:
.I1
\*(ONchecked
.br
\*(OFnot checked
.I2
not checked.
.IE
The other places where assignment-compatibility is required are:
.IS
.LB -
assignment
.LB -
value parameters
.LB -
procedures read and readln
.IE
For these places the compiler generates an EM1 range check instruction, except
when the r-option is turned off, or when the range of values of T2
is enclosed in the range of T1.
If the expression consists of a single variable and if that variable
is of a subrange type,
then the subrange type itself is taken as T2, not the host-type of that subrange.
Therefore, a range instruction is only generated if T1 is a subrange type
and if the expression is a constant, an expression with two or more
operands, or a single variable with a type not enclosed in T1.
If a constant is assigned, then the EM1 optimizer removes the range check
instruction, except when the value is out of bounds.
.PP
It depends on the EM1-implementation whether the range check instruction
is executed or skipped:
.I1
\*(ONchecked
.br
\*(OFskipped
.I2
skipped
.IE
.IT 6.4.6
An error should be caused if an expression E of type T2 must be
assignment-compatible with type T1, while T1 and T2 are compatible
set-types and any of the members of the
set expression E is not in the closed interval specified by the base-type
of the type T1.
.IS
This error is not detected.
.IT 6.5.4
An error should be caused if the pointer value is NIL or undefined at the time it is de-referenced.
.IS
The EM1 definition does not specify the binary representation of pointer
values, so that it is not possible to choose an otherwise illegal
binary representation for the pointer value NIL.
Rather arbitrary the compiler uses the integer value zero to represent NIL.
For all current implementations this does not cause problems.
.PP
The EM1 definition does specify the size of pointer objects: 2 bytes.
However, when the v-option is turned on, the compiler produces code
for one of the planned successors of EM1, a machine with 32 bits pointer values.
In this case NIL is represented by 32 zero bits.
.PP
It depends on the EM1-implementation whether de-referencing of a pointer
with value NIL causes an error:
.I1
\*(ONfor every de-reference the pointer value is checked to be legal.
The value NIL is always illegal.
Objects addressed by means of a NIL pointer always cause an error, except
when they are part of some extraordinary sized structure.
.br
\*(OFde-referencing for the purpose of fetching will not cause
an error to occur.
However, if the pointer value is used for a store operation,
a segmentation violation probably results.
(Note: this is only true if the interpreter is executed with coinciding
address spaces and protected text part. The interpreter must therefore
be loaded with the '-n' option of the UNIX loader [5]).
.I2
de-referencing for a fetch operation will not cause an error.
A store operation probably causes an error if the '-n' flag is
specified to pc [4] or ld [5] while loading your program.
.IE
Some implementations of EM1 initialize all memory cells for newly
created variables with a constant likely to cause an error if that variable
is not initialized with a value of its own type before use.
For each implementation we give whether memory cells are initialized,
with which value, and whether this value causes an error if de-referenced.
.I1
each memory word is initialized with the bit representation 1000000000000000,
representing -32768 in 2's complement notation.
For most small and medium sized programs this value will cause a segmentation
violation.
.I2
no initialization.
Whenever a pointer is de-referenced, without being properly initialized,
a 'segmentation violation' or a 'bus error' are possible.
.IE
.IT 6.6.5.2
An error should be caused if eof(f) does not yield true prior to execution of put(f).
.IS
This error is detected indirectly. Execution of put(f) will cause an error if
f is not opened for writing by using rewrite(f).
Rewrite(f) causes eof(f) to yield true.
All standard procedures allowed for files opened for writing, including put(f),
do not cause eof(f) to yield false.
.IT 6.6.5.2
An error should be caused if eof(f) does not yield false prior to execution of get(f).
.IS
This error is detected.
.IT 6.6.5.2
An error should be caused if the current file position of a file is altered while the buffer
variable f^ is an actual variable parameter, or an element of the
record-variable-list of a with-statement, or both.
.IS
This error is not detected.
.IT 6.6.5.3
An error should be caused if the value of the pointer parameter of dispose is NIL or undefined.
.IS
The same comments apply as for de-referencing NIL or undefined pointers.
.IT 6.6.5.3
An error should be caused if a variable that is currently either an actual variable parameter,
or an element of the record-variable-list of a with-statement, or both,
is referred to by the pointer parameter of dispose.
.IS
This error is not detected.
.IT 6.6.5.3
An error should be caused if a referenced-variable created using the second form of new is used
as an operand in an expression, or the variable in an assignment-statement
or as an actual-parameter.
.IS
This error is not detected.
.IT 6.6.6.2
An error should be caused if x not greater than zero in ln(x).
.IS
This error is detected.
.IT 6.6.6.2
An error should be caused if x is negative in sqrt(x).
.IS
This error is detected.
.IT 6.6.6.2
An error should be caused if trunc(x) is not a value of type integer.
.IS
This error is detected.
.IT 6.6.6.2
An error should be caused if round(x) is not a value of type integer.
.IS
This error is detected.
.IT 6.6.6.2
An error should be caused if chr(x) does not exist.
.IS
Except when the r-option is turned off, the compiler generates an EM1
range check instruction. The effect of this instruction depends on the
EM1-implementation as described before.
.IT 6.6.6.2
An error should be caused if succ(x) does not exist.
.IS
Same comments as for chr(x).
.IT 6.6.6.2
An error should be caused if pred(x) does not exist.
.IS
Same comments as for chr(x).
.IT 6.7.1
An error should be caused if any variable or function used as an operand in an expression has
an undefined value at the time of its use.
.IS
Detection of undefined operands is only possible if there is at least one bit
representation which is not allowed as legal value.
The set of legal values depends on the type of the operand.
To detect undefined operands, all newly created variables must be assigned
a value illegal for the type of the created variable.
The compiler itself does not generate code to initialize newly created variables.
Instead, the compiler generates code to allocate some new memory cells.
It is up to the EM1-implementation to initialize these memory cells.
However, the EM1 machine does not know the types of the variables for which
memory cells are allocated.
Therefore, the best an EM1-implementation can do is to initialize with a value
which is likely to be illegal for the most common types of operands.
.PP
For all current EM1-implementations we will describe whether memory cells
are initialized, which value is used to initialize, for each operand type
whether that value is illegal, and for all operations on all operand
types whether that value is detected as undefined.
.I1
\*(ONnew memory words are initialized with -32768.
Assignment of that value is always allowed. Errors may occur
whenever undefined operands are used in operations.
.br
.ul
integer:
-32768 is illegal. All arithmetic operations (except unary +) cause
an error.
Relational operations do not, except for IN when the left operand is undefined.
Printing of -32768 using write is allowed.
.br
.ul
real:
the bit representation of a real, caused by initializing the constituent
memory words with -32768, is illegal.
All arithmetic and relational operations (except unary +) cause an error.
Printing causes an error.
.br
.ul
char:
the value -32768 is illegal. For objects of type 'packed array[] of char'
half the characters will have the value chr(0), which is legal, and the
others will have the value chr(128), outside the valid ASCII range.
The relational operators, however, do not cause an error.
.br
.ul
Boolean:
the value -32768 is illegal. For objects of type 'packed array[] of boolean'
half the booleans will have the value false, while the others have the value v,
where ord(v) = 128, naturally illegal.
However, the Boolean and relational operations do not cause an error.
.br
.ul
set:
undefined operands of type set can not be distinguished from
properly initialized ones.
The set and relational operations, therefore, can never cause an error.
However, if one forgets to initialize a set of character, then spurious
characters like '/', '?', 'O', '_' and 'o' appear.
.sp
\*(OFnew memory cells are initialized with -32768.
The only cases where this value causes an error are when
an undefined operand of type real is used in an arithmetic or relational
operation (except unary +) or when an undefined real is used as an
argument to one of the standard functions.
.I2
Newly created memory cells are not initialized and therefore
they have a random value.
.IT 6.7.1
An error should be caused if the value of an expression which is the member of a set is outside
the implementation-defined limits.
.IS
This error is detected.
.IT 6.7.2.2
An error should be caused if j is zero in i DIV j.
.IS
It depends on the EM1-implementation whether this error is detected:
.I1
\*(ONdetected.
.br
\*(OFnot detected.
.I2
not detected.
.IE
.IT 6.7.2.2
An error should be caused if the result of a binary operation on integer
operands is not in the range -maxint..+maxint.
.IS
The reaction depends on the EM1-implementation:
.I1
\*(ONerror detected if
.EQ
     (result >= 32768) or (result < -32768).
.EN
Note that if the result is -32768 the use of this value in further operations
may cause an error.
.br
\*(OFnot detected.
.I2
not detected.
.IT 6.8.3.5
An error should be caused if none of the case-constants is equal to the current value of the
selector.
.IS
This error is detected.
.IT 6.8.3.9
An error should be caused if the control-variable is assigned to by the repeated statement or
altered by any procedure or function activated by the repeated statement.
.IS
This error is not detected.
.IT 6.9.2
An error should be caused if the sequence of characters read looking for an integer does not
form a signed-integer as specified in 6.1.5.
.IS
This error is detected.
.IT 6.9.2
An error should be caused if the sequence of characters read looking for a real does not
form a signed-number as specified in 6.1.5.
.IS
This error is detected.
